#ifndef _WSCREEN_H
#define _WSCREEN_H

#include "graph.h"
#include <windows.h>
#include <string.h>
#include "hash.h"
#include "mytypes.h"
#include "misc.h"
#include "list.h"

class MsgQ;

// windows graphical interface
class WScreen : public Graphics
{
public:
  WScreen(void (*key)(int, int, int, char *),
  	  HANDLE hInstance, HANDLE hPrevInstance,
	  int nCmdShow);
  virtual ~WScreen();

  int AllocColor(char *name);

  // displays a message somewhere on the screen
  void DisplayMessage(char *str, int color);

  // these functions should draw stuff on the map window

  void WriteStr(int x, int y, char *str, int color);
  void WriteChar(int x, int y, int ch, int color);

  void Clear();

  void FillRect(int x, int y, int width, int ht, int col);
  void Rect(int x, int y, int width, int ht, int col);

  void BitBlt(int sx, int sy, int w, int h, int dx, int dy);

  long CompilePixmap(char **pixmap);
  void FreePixmap(long handle);
  void DrawPixmap(int xc, int yc, long handle);
  void GetPixmapInfo(long handle, int &w, int &h);

  // this function starts up an event driven loop and calls the handler
  // which you specified whenever some event occurs
  // event's are either keypresses or data arriving on the socket
  int MainLoop(); // will not return

  friend LONG FAR PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);

  void StartTimer(int which, int milli, HandlerFunc func);
  void StopTimer(int which);

  void AddReadNotify(int fd, void (*func)(MsgQ *, int, int), int info = 0,
		     int q = 1);

  void CreateChoiceFrame(char *mesg, List<charp> choices);
  void MessageBox(char *mesg);

private:
  struct ColorInfo {
    char *name;
    int r, g, b, id;
  };

  HashTable<ColorInfo, StrKey> colors;

  int nextColor;
};

struct RecvInfo {
  ushort len, left;
  char *buf, *ptr;
  int stat;
  MsgQ *q;
  int qLen;
};

typedef RecvInfo *RecvInfoP;

#endif
