
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include "xlchip.h"

win_chip::win_chip(int vsizex, int vsizey, int csizex, int csizey)
     : win_scroll( vsizex, vsizey)
{
    csx = csizex;
    csy = csizey;
    spr_max = sprite;
}

win_chip::~win_chip()
{
    XFreePixmap(disp, chip_mask);
    XFreePixmap(disp, chip);
    XFreePixmap(disp, p_store);
} 

void win_chip::make(win *back,int wx,int wy, int sizex,int sizey)
{
    this->win_scroll::make(back,wx,wy,sizex,sizey);
    p_store   = XCreatePixmap(disp,w,vsx,vsy,DefaultDepth(disp,0));
    chip      = XCreatePixmap(disp,w,csx,csy,DefaultDepth(disp,0));
    chip_mask = XCreatePixmap(disp,w,csx,csy,DefaultDepth(disp,0));
    XGCValues gcv;
    gcv.graphics_exposures = False;
    set_gc = XCreateGC(disp,w, GCGraphicsExposures, &gcv);
    
    gcv.graphics_exposures = False;
    gcv.function = GXand;
    and_gc = XCreateGC(disp,w,GCFunction | GCGraphicsExposures, &gcv);
    
    gcv.graphics_exposures = False;
    gcv.function = GXor;
    or_gc = XCreateGC(disp,w,GCFunction | GCGraphicsExposures, &gcv);
}

void win_chip::torus_copy_from_chip_and_store(int x, int y, int h, int v,
                                              int x1, int x2)
{
    XCopyArea(disp,chip,p,      set_gc,x,y,h,v,x1,x2);
    XCopyArea(disp,chip,p_store,set_gc,x,y,h,v,x1,x2);
    if (x1 < sx){
        XCopyArea(disp,chip,p,      set_gc,x,y,h,v,x1+vsx-sx,x2);
        XCopyArea(disp,chip,p_store,set_gc,x,y,h,v,x1+vsx-sx,x2);
        if (x2 < sy){
            XCopyArea(disp,chip,p,      set_gc,x,y,h,v,x1,x2+vsy-sy);
            XCopyArea(disp,chip,p_store,set_gc,x,y,h,v,x1,x2+vsy-sy);
            XCopyArea(disp,chip,p,      set_gc,x,y,h,v,x1+vsx-sx,x2+vsy-sy);
            XCopyArea(disp,chip,p_store,set_gc,x,y,h,v,x1+vsx-sx,x2+vsy-sy);
        }
    }
    else if (x2 < sy){
        XCopyArea(disp,chip,p,      set_gc,x,y,h,v,x1,x2+vsy-sy);
        XCopyArea(disp,chip,p_store,set_gc,x,y,h,v,x1,x2+vsy-sy);
    }
}

void win_chip::store()
{
    XCopyArea(disp, p, p_store, set_gc, 0, 0, vsx, vsy, 0, 0);
}

void win_chip::restore()
{
    _sprite *spp;
    for (spp=sprite; spp<spr_max; spp++)
      XCopyArea(disp, p_store, p, set_gc,
                spp->x, spp->y, spp->h, spp->v, spp->x, spp->y);
    spr_max = sprite;
}
