.TH XBOING 6 "July 1993" "X Version 11"
.SH NAME

\fIxboing\fP \- An X Window System based blockout clone.

.SH SYNOPSIS

\fIxboing\fP [-version] [-usage] [-help] [-sync] [-display <displayName>] [-speed <1-10>] [-scores] [-keys] [-sound] [-setup] [-nosfx]

    -speed <n>         - The game speed, 1 - 9. [5]
    -help              - Produce this help message.
    -sync              - Turn on X synchronisation.
    -usage             - Print a brief help message.
    -version           - Print out the current version.
    -scores            - Print out current highscores.
    -keys              - Use keys instead of mouse control.
    -sound             - Turn audio ON for game.
    -setup             - Print setup information.
    -nosfx             - Turn off special effects.
    -display <display> - Set the display for the game.

.SH DESCRIPTION

\fIXBoing\fP is a simple blockout type game where you have a paddle which you use to bounce a ball around the game area blowing up blocks with the ball. You win by obtaining points for each block destroyed and each level completed. The person with the highest score wins.

The play area is filled with blocks and other objects. You have a paddle that
can move from left to right at the bottom of the screen. You move the paddle
so that the ball that bounces around blowing up blocks does not go past the
paddle and out the bottom, much like a pinball game.

The blocks exhibit different behaviour. The bomb block when hit will explode all
blocks around it. If another bomb is beside it then it will go off also. The
solid wall brick will not explode unless next a bomb. The ammunition block will
give you four bullets and so on. Special blocks such as reverse and machine gun will only last for one level.

There are random blocks that change their colour and therefore their points every now and then. They add a bit of change to the levels.

There is a pirate symbol that will kill your ball if touched. You can shoot this block 3 times to kill it but you will lose 1000 points. Keep away from the Death block, it kills your ball!
 
The walls off block will turn the wall bounce off on both the left and right side of the playing area. This will mean the ball will not bounce off but continue through the wall and wrap around to the other side respectively.

The reverse block will when hit reverse the controls to the paddle. This block should be avoided as it makes the game really hard. Hitting another reverse while already in reverse mode will turn it off.

The teleport block will teleport the ball somewhere else on that level. It will not place you too close to the bottom of the screen or on another block.

The sticky paddle block will stick the ball to your paddle each time it is hit and wait until you press space to shoot it off again. This can be a #$%$#@! and also useful for lining up shots for hard bricks.

There is a machine gun block that allows you to shoot much faster. Note that you will also go through your bullets at a great rate. Can be fun to let off a burst every now and then. Erases counter blocks very fast.

An extra ball symbol may appear and when shot or hit with another ball it will give you an extra ball!

You can use the bullets to shoot the last pesky blocks or to collet lots of
bonus coins. You will be given 4 bullets when a new level starts. If you lose
a ball you will be given a token 2 bullets. Use bullets wisely as you will
hate yourself when there is one brick left and the ball is missing it for ever.

Throughout the game the bonus coins will appear. Collect these for bonus points when the level is finished. Sometimes the coin may appear as a x2 or x4 symbol which will indicate that the scoring from now onwards will be multiplied by 2 or 4 respectively. Note: if you get a x2 then x4 then x2 you will go back to x2 mode. Also note that this x2 or x4 mode will be disabled after each ball death.

The bonus screen will tell you how you went in the last level. Your bonuses
will be added and the bullet and level bonus will be added. You get 500 points
for each bullet not used. You get 3000 points for each bonus and if you get
more than 10 bonuses you get a SUPER BONUS of 50000 points. You also get a new
ball every 100,000 points. Pressing space will skip the bonus animations when
the bonus screen appears. Your bonus score will still be added.

There is a level timer that counts down while playing the level. If you don't
complete the level in time you will not get the time bonus which is 100 points
per second remaining. You will also miss out on the level bonus if your time runs out.

The ball will be automatically shot off the paddle after about 5 seconds unless you press the space bar. You can always press P to pause the game.

If the ball gets stuck in an infinite loop it will automatically tilt the board if the ball hasn't hit the paddle after a certain time span. The time span is about 8 seconds I think.

XBoing was started like many other projects to learn Xlib better. I had the
XPM library and was already using it in a Motif application. I thought that it
would be cool to have nice colour pictures/animations in an Xlib game. So I
did. Without the XPM library I would be still playing with the colours I think.

.SH GAME CONTROL
.PP
You must have specified "-keys" on the command line to use the keys for
the paddle control. The default is to use the mouse control method.
.nf

J = Paddle Left
LeftArrow = Paddle Left
K = Shoot bullet
L = Paddle Right
RightArrow = Paddle Right

Left Mouse Button = Paddle Left
Middle Mouse Button = Shoot Bullet
Right Mouse Button = Paddle Right

Use the mouse to move the paddle left and right by moving the mouse 
left and right. The paddle will follow the mouse pointer. This is
the best method and easiest to use by far.

Space   = Start ball moving/Start game
Escape  = End game and return to introduction.
i       = iconify the game and pause.
H       = View roll of honour.
h       = View personal highscores.
p       = Pause game.
d       = Kill the ball.
a       = Toggle audio on/off
s       = Toggle special effects on/off
c       = Cycle through the intro screens.
1-9	    = Game speed where 9 is fastest.
q       = Quit XBoing

Note: Highscores are saved at the end of each game.
.fi
.PP
.SH SCORING

Each blocks has a certain point score. Some blocks such as the counter block will have more than one score associated with it.

.nf
red = 100
blue = 110
green = 120
yellow = 140
tan = 130
purple = 150
bomb = 50 plus the surrounding blocks points
wall = 0
pirate = 100
reverse = 100
ammo = 50 plus bullets
counter = 200 (each number). 
.fi

Each time the paddle is hit with the ball your earn 10 points. I'm nice.

There are death symbols (a pirate) that when hit by a ball will kill the ball. You can shoot them but you will lose 1000 points.

The bonus coins are 3000 points - but only added to score if you reach the end of the level and go through the bonus screen.

If you collect more than 10 bonus coins you get a Super Bonus of 50,000 points. Each remaining bullet after a level is worth 500 points.

At the end of each level you are awarded a level bouns which is level <n> x 1000 points. So for level 20 you get 20,000 points! If you fail to complete the level in the time allotted you will not receive a level bonus.

.SH LEVELS

The levels are not increasingly harder to play - some are but some are easy. This is because it takes ages to create and design levels. The paddle does get smaller as the game goes on. This makes it REALLY hard. I may also add a ball speedup feature.

The level data is a simple ASCII file format that can be edited. The levels
are loaded when required from the directory specified when the game was made.

You can create more levels if you like making sure that they are in the correct
format and that they have a correct filename format.

Copy level0.data to level??.data and use that for the editing of new levels.

level format:	(case sensitive)

    w = wall block
    r = red block
    g = green block
    b = blue block
    t = tan block
    p = purple block
    y = yellow block
    X = Bomb
    B = Ammo
    . = blank
    D = Death
    R = Reverse
    H = Teleport
    L = Extra ball
    M = Machine Gun
    W = Walls off
    ? = Random block
    m = Multiple balls
    s = sticky block

The format of the level is shown in the newlevel.data file in the source distribution in the levels directory.

Make sure you have a level title and a time bonus in seconds.

.SH NOTES

Obatin all new versions from export.lcs.mit.edu or a mirror site.

.SH REDISTRIBUTION 

(c) Copyright 1993, Justin C. Kibell, All Rights Reserved

Permission to use, copy, modify, and distribute this software and its documentation without written agreement is hereby granted. You cannot sell this software without written permission from the author. This entire copyright notice must appear in all copies of this software.

IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

.SH AUTHOR

Justin C. Kibell - Systems Programmer - CATT Centre CITRI Melbourne - Victoria - Australia.  email: jck@citri.edu.au

Computer Science Graduate - Royal Melbourne Institute of Technology (RMIT) - Australia

.SH BUGS

See TODO in source distribution for list of bugs. Mail all bug reports/suggestions to jck@citri.edu.au specifying the version and machine type you are using. Use 'uname -a' to explain the machine type. Please note the version of X11 that you have installed as well, ie: X11R5, X11R4, etc.
