#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#define MAXMENUS 5
#define MAXMENUSIZE 10

typedef struct _menubuttontype {
	char *name;
	XtCallbackProc callback;
	XtPointer arg;
} menubuttontype;

typedef struct _submenutype {
	char *name;
	int size;
	menubuttontype button[MAXMENUSIZE];
	Widget pulldown, pshell;
} submenutype;

typedef struct _menutype {
	int size;
	submenutype submenu[MAXMENUS];
} menutype;

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>

#define OK	1
#define CANCEL	2

#define wCreateLabelWidget(name, parent) \
	XtCreateManagedWidget(name, xmLabelWidgetClass, parent, NULL, 0)
#define wCreateSeparatorWidget(name, parent) \
	XtCreateManagedWidget(name, xmSeparatorWidgetClass, parent, NULL, 0)
#define wCreateRowColumnWidget(name, parent) \
	XtCreateManagedWidget(name, xmRowColumnWidgetClass, parent, NULL, 0)
#define wCreateMenuBar(name, parent, menu) \
	motif_CreateMenuBar(name, parent, menu)
#define wCreatePixmapBox(name, parent, pixmap, text) \
	motif_CreatePixmapBox(name, parent, pixmap, text)
#define wCreateEnterText(name, parent, buttonmask, text, callback) \
	CreateEnterText(name, parent, buttonmask, text, callback)
#define wCreateDialog(name, parent, buttonmask, icon, text, buttons, callback)\
	CreateDialog(name, parent, buttonmask, icon, text, buttons, callback)
#define wCreateDrawingArea(name, parent, width, height) \
	motif_CreateDrawingArea(name, parent, width, height)
#define print_to_widget(w, str) \
	motif_print_to_widget(w, str)	
	
Widget motif_CreateMenuBar(char *name, Widget parent, menutype menu);
Widget motif_CreatePixmapBox(char *name, Widget parent, Pixmap pixmap,
	char *text);
Widget CreateEnterText
	(char *name, Widget parent, int buttonmask, char *text, XtCallbackProc callback);
Widget CreateDialog
	(char *name, Widget parent, int buttonmask, Pixmap icon, char *text, char *button, XtCallbackProc callback);
Widget motif_CreateDrawingArea(char *name, Widget parent, int width, int height);
void motif_print_to_widget(Widget w, char *str);
	
void setup_main_widgets ();
void setup_other_widgets (Pixmap about, Pixmap rules, Pixmap thanks,
	Pixmap story, Pixmap freeware);
void update_info(Widget info, horde *bill, network *net, library *systems,
	int level);
