% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettycode.R
\name{code_highlight}
\alias{code_highlight}
\title{Syntax highlight R code}
\usage{
code_highlight(code, code_theme = NULL)
}
\arguments{
\item{code}{Character vector, each element is one line of code.}

\item{code_theme}{Theme see \code{\link[=code_theme_list]{code_theme_list()}}.}
}
\value{
Character vector, the highlighted code.
}
\description{
Syntax highlight R code
}
\details{
See \code{\link[=code_theme_list]{code_theme_list()}} for the default syntax highlighting theme and
how to change it.

If \code{code} does not parse, then it is returned unchanged and a
\code{cli_parse_failure} condition is thrown. Note that this is not an error,
and the condition is ignored, unless explicitly caught.
}
\examples{
code_highlight(deparse(ls))
cat(code_highlight(deparse(ls)), sep = "\n")
}
\seealso{
Other syntax highlighting: 
\code{\link{code_theme_list}()}
}
\concept{syntax highlighting}
