.\"
.\" %nmhwarning%
.\"
.TH MH-TAILOR %manext5% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mh-tailor, mts.conf \- mail transport customization for nmh message handler
.SH SYNOPSIS
.I %etcdir%/mts.conf
.SH DESCRIPTION
The file
.I %etcdir%/mts.conf
defines run-time options for those
.B nmh
programs which interact (in some form) with the message transport system.
At present, these (user) programs are:
.BR ap ,
.BR conflict ,
.BR inc ,
.BR msgchk ,
.BR msh ,
.BR post ,
.BR rcvdist ,
and
.BR rcvpack .
.PP
Each option should be given on a single line.  Blank lines and lines
which begin with `#' are ignored.  The options available along with
default values and a description of their meanings are listed below:
.PP
.BR mts :
.RS 5
The mail transport method to use.  The two acceptable options are
.B smtp
(which is the default), and
.BR sendmail .
.PP
If you use
.BR smtp ,
this will enable a direct SMTP (simple mail transport
protocol) interface in
.BR nmh .
When sending mail, instead of passing the
message to the mail transport agent,
.B post
will open a socket connection
to the mail port on the machine specified in the
.B servers
entry.
.PP
If you use
.BR sendmail ,
then
.B post
will send messages by forking a
local copy of
.BR sendmail .
Currently it will still speak SMTP with this local
copy of
.BR sendmail .
.RE
.PP
.BR localname :
.RS 5
The hostname
.B nmh
considers local.  It should typically be a fully
qualified hostname.  If this is not set, depending on the version of
UNIX you're running,
.B nmh
will query the system for this value
(e.g. uname, gethostname, etc.), and attempt to fully qualify this
value.
.PP
If you are using POP to retrieve new messages, you may want to set this
value to the name of the POP server, so that outgoing message appear to
have originated on the POP server.
.RE
.PP
.BR localdomain :
.RS 5
If this is set, a `.' followed by this string will be appended to your
hostname.
.PP
This should only be needed, if for some reason
.B nmh
is not able to
fully qualify the hostname returned by the system (e.g. uname,
gethostname, etc.).
.RE
.PP
.BR clientname :
.RS 5
This option specifies the host name that
.B nmh
will give in the
SMTP
.B HELO
(and
.BR EHLO )
command, when posting mail.  If not
set, the default is to use the host name that
.B nmh
considers local
(see
.B localname
above).  If this option is set, but empty, no
.B HELO
command will be given.
.PP
Although the
.B HELO
command is required by RFC\-821, many SMTP servers
do not require it.  Early versions of
.I SendMail
will fail if the hostname
given in the
.B HELO
command is the local host.  Later versions of
.I SendMail
will complain if you omit the
.B HELO
command.  If you run
.IR SendMail ,
find out what your system expects and set this field if needed.
.RE
.PP
.BR systemname :
.RS 5
This option is only used for UUCP mail.  It specifies the name of the
local host in the UUCP \*(lqdomain\*(rq.  If not set, depending
on the version of UNIX you're running,
.B nmh
will query the system
for this value.  This has no equivalent in the
.B nmh
configuration
file.
.RE
.PP
.BR mmdfldir :
%mailspool%
.RS 5
The directory where maildrops are kept.  If this option is set, but empty,
the user's home directory is used.  This overrides the default value
chosen at the time of compilation.
.RE
.PP
.BR mmdflfil :
.RS 5
The name of the maildrop file in the directory where maildrops are kept.
If this is empty, the user's login name is used.  This overrides the default
value (which is empty).
.RE
.PP
.BR mmdelim1 :
\&\\001\\001\\001\\001\\n
.RS 5
The beginning-of-message delimiter for maildrops.
.RE
.PP
.BR mmdelim2 :
\&\\001\\001\\001\\001\\n
.RS 5
The end-of-message delimiter for maildrops.
.RE
.PP
.BR maildelivery :
%libdir%/maildelivery
.RS 5
The name of the system-wide default
.I maildelivery
file.
See
.BR slocal (1)
for the details.
.RE
.PP
.BR everyone :
200
.RS 5
The highest user-id which should NOT receive mail addressed to
\*(lqeveryone\*(rq.
.RE
.PP
.BR noshell :
.RS 5
If set, then each user-id greater than \*(lqeveryone\*(rq that has a
login shell equivalent to the given value (e.g., \*(lq/bin/csh\*(rq)
indicates that mail for \*(lqeveryone\*(rq should not be sent to them.
This is useful for handling admin, dummy, and guest logins.
.RE
.SS "SMTP support"
This option is only available if you set
.B mts
to
.BR smtp .
.PP
.BR servers :
localhost
.RS 5
A lists of hosts and networks which to look for SMTP servers when
posting local mail.  It turns out this is a major win for hosts which
don't run an message transport system.  The value of
.B servers
should be one or more items.  Each item is the name of a host which
is (hopefully) running a SMTP server.
.SS "SendMail"
This option is only available if you set
.B mts
to
.BR sendmail .
.PP
.BR sendmail :
%sendmailpath%
.RS 5
The pathname to the
.B sendmail
program.
.RE
.SS "Post Office Protocol"
This option is only available if you have compiled
.B nmh
with POP support enabled (i.e., \*(lq--enable-pop\*(rq).
.PP
.BR pophost :
.RS 5
The name of the default POP service host.  If this is not set, then
.B nmh
looks in the standard maildrop areas for waiting mail, otherwise
the named POP service host is consulted.
.RE
\"  .SS "BBoards Delivery"
\"  This option is only available if you compiled \fInmh\fP with
\"  \*(lqbbdelivery:\ on\*(rq.
\"  .PP
\"  .BR bbdomain :
\"  .RS 5
\"  The local BBoards domain (a UCI hack).
\"  .RE

\"  .SS "BBoards & The POP"
\"  These options are only available if you compiled \fInmh\fP with
\"  \*(lqbboards:\ pop\*(rq and \*(lqpop:\ on\*(rq.

\"  .PP
\"  .BR popbbhost :
\"  .RS 5
\"  The POP service host which also acts as a BBoard server.  This variable
\"  should be set on the POP BBoards client host.
\"  .RE
\"  .PP
\"  .BR popbbuser :
\"  .RS 5
\"  The guest account on the POP/BB service host.  This should be a different
\"  login ID than either the POP user or the BBoards user.  (The user-id
\"  \*(lqftp\*(rq is highly recommended.)  This variable should be set on
\"  both the POP BBoards client and service hosts.
\"  .RE
\"  .PP
\"  .BR popbblist :
\"  %etcdir%/hosts.popbb
\"  .RS 5
\"  A file containing of lists of hosts that are allowed to use the POP
\"  facility to access BBoards using the guest account.  If this file is not
\"  present, then no check is made.  This variable should be set on the POP
\"  BBoards service host.
\"  .RE

.SS "File Locking"
A few words on locking:
.B nmh
has several methods for creating locks
on files.  When configuring
.BR nmh ,
you will need to decide on the
locking style and locking directory (if any).  The first controls the
method of locking, the second says where lock files should be created.
.PP
To configure
.B nmh
for kernel locking, use the \*(lq--with-locking=flock\*(rq configure option if
you want to use the
.B flock
system call; use \*(lq--with-locking=lockf\*(rq if
you want to use the
.B lockf
system call; or use \*(lq--with-locking=fcntl\*(rq
if you want to use the
.B fcntl
system call for kernel-level locking.
.PP
Instead of kernel locking, you can configure
.B nmh
to use dot locking by using \*(lq--with-locking=dot\*(rq.  Dot locking
specifies that
a file should be created whose existence means \*(lqlocked\*(rq and
whose non-existence means \*(lqunlocked\*(rq.  The name of this file is
constructed by appending \*(lq.lock\*(rq to the name of the file being
locked.  If \*(lq--enable-lockdir=directory\*(rq
is not specified at build time, lock files will be created
in the directory where the file being locked resides.  Otherwise, lock
files will be created in the directory specified by
\*(lq--enable-lockdir\*(rq.
.PP
Prior to installing
.BR nmh ,
you should see how locking is done at
your site, and set the appropriate values.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^%etcdir%/mts.conf~^nmh mts configuration file
.fi

.SH "PROFILE COMPONENTS"
None

.SH "SEE ALSO"
mh\-mts(8), post(8)

.SH DEFAULTS
As listed above
