/*
 * libopenraw - libopenraw.h
 *
 * Copyright (C) 2005-2016 Hubert Figuiere
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */
/**
 * @brief the libopenraw public API header
 * @author Hubert Figuiere <hub@figuiere.net>
 */

#ifndef LIBOPENRAW_H_
#define LIBOPENRAW_H_

#include <libopenraw/prefix.h>

#include <libopenraw/types.h>
#include <libopenraw/consts.h>
#include <libopenraw/cameraids.h>
#include <libopenraw/io.h>
#include <libopenraw/thumbnails.h>
#include <libopenraw/rawdata.h>
#include <libopenraw/bitmapdata.h>
#include <libopenraw/rawfile.h>
#include <libopenraw/debug.h>
#include <libopenraw/demosaic.h>
#include <libopenraw/cfapattern.h>
#include <libopenraw/metadata.h>

#endif
