------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2003-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;
with AWS.Resources;
with AWS.Utils;

with zresres;

procedure ERes is

   procedure Test (Name : String) is
      use AWS.Resources;
   begin
      Ada.Text_IO.Put_Line (File_Instance'Image (Exist (Name)));
   end Test;

begin
   Test ("this-file-does-not-exist");
   Test ("filea.txt");
   Test ("fileb.txt.gz");
   Test ("fileb.txt");
   Test ("adains.png");
   Test ("file1.txt");
   Test ("file2.txt.gz");
   Test ("file2.txt");
end ERes;
