/*******************************************************************************
 * Copyright (c) 2014 Ericsson and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Marc Khouzam (Ericsson) - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.dsf.gdb.service;

import org.eclipse.cdt.dsf.debug.service.IMemory.IMemoryDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

/**
 * Adapt to GDB 7.4 where breakpoints are for all inferiors at once.
 * 
 * @since 4.4
 */
public class GDBProcesses_7_4 extends GDBProcesses_7_2_1 {
    
	public GDBProcesses_7_4(DsfSession session) {
		super(session);
	}

	/**
	 * A container context that is not an IBreakpointsTargetDMContext.
	 */
	private static class GDBContainerDMC_7_4 extends MIContainerDMC 
	implements IMemoryDMContext
	{
		public GDBContainerDMC_7_4(String sessionId, IProcessDMContext processDmc, String groupId) {
			super(sessionId, processDmc, groupId);
		}
	}
	
	@Override
    public IMIContainerDMContext createContainerContext(IProcessDMContext processDmc,
    													String groupId) {
    	return new GDBContainerDMC_7_4(getSession().getId(), processDmc, groupId);
    }
	

}

