/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Attribute;
import com.amazonaws.services.ec2.model.transform.AccountAttributeValueStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AttributeStaxUnmarshaller
implements Unmarshaller<Attribute, StaxUnmarshallerContext> {
    private static AttributeStaxUnmarshaller instance;

    public Attribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        Attribute attribute = new Attribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return attribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("attributeName", targetDepth)) {
                    attribute.setAttributeName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("attributeValueSet/item", targetDepth)) continue;
                attribute.getAttributeValueSet().add(AccountAttributeValueStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return attribute;
    }

    public static AttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeStaxUnmarshaller();
        }
        return instance;
    }
}

