#include <stdlib.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

#include "uwa-test-client.h"

static void
fake_callback (UnityWebappsContext *context, gpointer user_data)
{
  return;
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  int i;
  
  for (i = 0; i < 1000; i++)
    {
      gchar *name;
      
      name = g_strdup_printf("Thousand indicators %d", i);
      unity_webapps_indicator_show_indicator (context, name);
      unity_webapps_indicator_clear_indicator (context, name);
      unity_webapps_indicator_add_action (context, name, fake_callback, NULL);
      g_free (name);
    }

  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
