// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Xunit;

namespace Microsoft.AspNetCore.Http.Features
{
    public class FeatureCollectionTests
    {
        [Fact]
        public void AddedInterfaceIsReturned()
        {
            var interfaces = new FeatureCollection();
            var thing = new Thing();

            interfaces[typeof(IThing)] = thing;

            var thing2 = interfaces[typeof(IThing)];
            Assert.Equal(thing2, thing);
        }

        [Fact]
        public void IndexerAlsoAddsItems()
        {
            var interfaces = new FeatureCollection();
            var thing = new Thing();

            interfaces[typeof(IThing)] = thing;

            Assert.Equal(interfaces[typeof(IThing)], thing);
        }

        [Fact]
        public void SetNullValueRemoves()
        {
            var interfaces = new FeatureCollection();
            var thing = new Thing();

            interfaces[typeof(IThing)] = thing;
            Assert.Equal(interfaces[typeof(IThing)], thing);

            interfaces[typeof(IThing)] = null;

            var thing2 = interfaces[typeof(IThing)];
            Assert.Null(thing2);
        }
    }
}
