#!/usr/bin/env python

import wx
from wx.lib.art import flagart, img2pyartprov

FlagArtProvider = None

#----------------------------------------------------------------------

class TestPanel(wx.Panel):
    def __init__(self, parent, log):
        self.log = log
        wx.Panel.__init__(self, parent, -1)

        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)

        title = wx.StaticText(self, -1, "Img2PyArtProvider")
        title.SetFont(wx.Font(18, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD))
        sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        line = wx.StaticLine(self, -1, size=(20,-1), style=wx.LI_HORIZONTAL)
        sizer.Add(line, 0, wx.GROW|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        sizer.Add((20,20))

        box = wx.BoxSizer(wx.HORIZONTAL)
        ch = wx.ComboBox(self, -1, 'BLANK', choices=flagart.index,
                         style=wx.CB_DROPDOWN|wx.CB_READONLY)
        self.Bind(wx.EVT_COMBOBOX, self.OnSelectCountry, ch)
        box.Add(ch, 0,  wx.ALIGN_CENTER_VERTICAL)
        box.Add((50,10))

        bmp = wx.Bitmap(32,22)
        self.bmpFlag = wx.StaticBitmap(self, -1, bmp)
        box.Add(self.bmpFlag, 0, wx.ALIGN_CENTER_VERTICAL)

        sizer.Add(box, 0, wx.CENTER|wx.ALL, 10)

        self.country = 'BLANK'
        global FlagArtProvider
        if FlagArtProvider is None:
            FlagArtProvider = img2pyartprov.Img2PyArtProvider(flagart,
                                                              artIdPrefix='wx.ART_')
            wx.ArtProvider.Push(FlagArtProvider)

        self.getArt()


    def OnSelectCountry(self, evt):
        self.log.write("OnSelectCountry\n")
        self.country = evt.GetString()
        self.getArt()


    def getArt(self):
        bmp = wx.ArtProvider.GetBitmap('wx.ART_'+self.country, wx.ART_OTHER, (32,22))
        if not bmp.IsOk():
            bmp = wx.Bitmap(32,22)
            self.clearBmp(bmp)
        self.bmpFlag.SetBitmap(bmp)


    def clearBmp(self, bmp):
        dc = wx.MemoryDC()
        dc.SelectObject(bmp)
        dc.SetBackground(wx.Brush("white"))
        dc.Clear()

#----------------------------------------------------------------------

def runTest(frame, nb, log):
    win = TestPanel(nb, log)
    return win

#----------------------------------------------------------------------



overview = """<html><body>
<h2><center>Img2PyArtProvider</center></h2>

Img2PyArtProvider is an ArtProvider class that publishes images from
modules generated by img2py.

<p>
This sample shows how to access the flag images in wx.lib.art.flagart
via the ArtProvider.


</body></html>
"""



if __name__ == '__main__':
    import sys,os
    import run
    run.main(['', os.path.basename(sys.argv[0])] + sys.argv[1:])

