/*
    unicap
    Copyright (C) 2004  Arne Caspari

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __DCAM_FORMAT_TABLE_H__
#define __DCAM_FORMAT_TABLE_H__


#define FOURCC(a,b,c,d) (unsigned int)((((unsigned int)a))+(((unsigned int)b)<<8)+(((unsigned int)c)<<16)+(((unsigned int)d)<<24))

#include "dcam.h"

unicap_format_t _dcam_unicap_formats[] =
{
	// format 0
	{ identifier: "YUV(4:4:4) 160x120",
	  size:     { x: 0, y: 0, width:  160, height: 120}, 
	  min_size: { x: 0, y: 0, width:  160, height: 120}, 
	  max_size: { x: 0, y: 0, width:  160, height: 120}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp:        24, 
	  fourcc:     FOURCC('Y','4','4','4'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 160*120*3 },

	{ identifier: "YUV(4:2:2) 320x240",
	  size:     { x: 0, y: 0, width: 320, height: 240}, 
	  min_size: { x: 0, y: 0, width: 320, height: 240}, 
	  max_size: { x: 0, y: 0, width: 320, height: 240}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 320*240*2 },

	{ identifier: "YUV(4:1:1) 640x480",
	  size:     { x: 0, y: 0, width: 640, height: 480}, 
	  min_size: { x: 0, y: 0, width: 640, height: 480}, 
	  max_size: { x: 0, y: 0, width: 640, height: 480}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 12, 
	  fourcc: FOURCC('Y','4','1','1'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 640*480 * 1.5 }, 

	{ identifier: "YUV(4:2:2) 640x480",
	  size: { x: 0, y: 0, width: 640, height: 480}, 
	  min_size: { x: 0, y: 0, width: 640, height: 480}, 
	  max_size: { x: 0, y: 0, width: 640, height: 480}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 640*480*2 },

	{ identifier: "RGB 640x480",
	  size:     { x: 0, y: 0, width: 640, height: 480}, 
	  min_size: { x: 0, y: 0, width: 640, height: 480}, 
	  max_size: { x: 0, y: 0, width: 640, height: 480}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 24, 
	  fourcc: FOURCC('R','G','B','3'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 640*480*3 }, 

	{ identifier: "Y(Mono) 640x480",
	  size:     { x: 0, y: 0, width: 640, height: 480}, 
	  min_size: { x: 0, y: 0, width: 640, height: 480}, 
	  max_size: { x: 0, y: 0, width: 640, height: 480}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 8, 
	  fourcc: FOURCC('Y','8','0','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 640*480 },

	{ identifier: "Y(Mono16) 640x480",
	  size:     { x: 0, y: 0, width: 640, height: 480}, 
	  min_size: { x: 0, y: 0, width: 640, height: 480}, 
	  max_size: { x: 0, y: 0, width: 640, height: 480}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('Y','1','6','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 640*480*2 }, 

	{ identifier: "Reserved",
	  size:     { x: 0, y: 0, width: 0, height: 0}, 
	  min_size: { x: 0, y: 0, width: 0, height: 0}, 
	  max_size: { x: 0, y: 0, width: 0, height: 0}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 0, 
	  fourcc: FOURCC('R','S','V','D'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 0 }, 

	// format1
	{ identifier: "YUV(4:2:2) 800x600",
	  size:     { x: 0, y: 0, width: 800, height: 600}, 
	  min_size: { x: 0, y: 0, width: 800, height: 600}, 
	  max_size: { x: 0, y: 0, width: 800, height: 600}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 800*600*2 },

	{ identifier: "RGB 800x600", 
	  size:     { x: 0, y: 0, width: 800, height: 600}, 
	  min_size: { x: 0, y: 0, width: 800, height: 600}, 
	  max_size: { x: 0, y: 0, width: 800, height: 600}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 24, 
	  fourcc: FOURCC('R','G','B',' '), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 800*600*3 },

	{ identifier: "Y(Mono) 800x600",
	  size:     { x: 0, y: 0, width: 800, height: 600}, 
	  min_size: { x: 0, y: 0, width: 800, height: 600}, 
	  max_size: { x: 0, y: 0, width: 800, height: 600}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 8, 
	  fourcc: FOURCC('Y','8','0','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 800*600 },

	{ identifier: "YUV(4:2:2) 1024x768",
	  size:     { x: 0, y: 0, width: 1024, height: 768}, 
	  min_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  max_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1024*768*2 }, 

	{ identifier: "RGB 1024x768",
	  size:     { x: 0, y: 0, width: 1024, height: 768},
	  min_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  max_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 24, 
	  fourcc: FOURCC('R','G','B',' '), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1024*768*3 },

	{ identifier: "Y(Mono) 1024x768",
	  size:     { x: 0, y: 0, width: 1024, height: 768}, 
	  min_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  max_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 8, 
	  fourcc: FOURCC('Y','8','0','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1024*768 },

	{ identifier: "Y(Mono16) 800x600",
	  size:     { x: 0, y: 0, width: 800, height: 600}, 
	  min_size: { x: 0, y: 0, width: 800, height: 600}, 
	  max_size: { x: 0, y: 0, width: 800, height: 600}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('Y','1','6','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 800*600*2 }, 

	{ identifier: "Y(Mono16) 1024x768",
	  size:     { x: 0, y: 0, width: 1024, height: 768}, 
	  min_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  max_size: { x: 0, y: 0, width: 1024, height: 768}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('Y','1','6','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1024*768*2 },

	//format2
	{ identifier: "YUV(4:2:2) 1280x960",
	  size:     { x: 0, y: 0, width: 1280,  height: 960}, 
	  min_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  max_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1280*960*2 },

	{ identifier: "RGB 1280x960",
	  size:     { x: 0, y: 0, width: 1280,  height: 960}, 
	  min_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  max_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0,
	  bpp: 24, 
	  fourcc: FOURCC('R','G','B',' '), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1280*960*3 },

	{ identifier: "Y(Mono) 1280x960",
	  size:     { x: 0, y: 0, width: 1280,  height: 960}, 
	  min_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  max_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 8, 
	  fourcc: FOURCC('Y','8','0','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1280*960 }, 

	{ identifier: "YUV(4:2:2) 1600x1200",
	  size:     { x: 0, y: 0, width: 1600, height: 1200}, 
	  min_size: { x: 0, y: 0, width: 1600, height: 1200}, 
	  max_size: { x: 0, y: 0, width: 1600, height: 1200},
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('U','Y','V','Y'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1600*1200*2 },

	{ identifier: "RGB 1600x1200",
	  size:     { x: 0, y: 0, width: 1600, height: 1200}, 
	  min_size: { x: 0, y: 0, width: 1600, height: 1200}, 
	  max_size: { x: 0, y: 0, width: 1600, height: 1200},
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 24, 
	  fourcc: FOURCC('R','G','B',' '), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1600*1200*3 },

	{ identifier: "Y(Mono) 1600x1200",
	  size:     { x: 0, y: 0, width: 1600, height: 1200}, 
	  min_size: { x: 0, y: 0, width: 1600, height: 1200}, 
	  max_size: { x: 0, y: 0, width: 1600, height: 1200},
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 8, 
	  fourcc: FOURCC('Y','8','0','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1600*1200 },

	{ identifier: "Y(Mono16) 1280x960" ,
	  size:     { x: 0, y: 0, width: 1280,  height: 960}, 
	  min_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  max_size: { x: 0, y: 0, width: 1280,  height: 960}, 
	  bpp: 16, 
	  fourcc: FOURCC('Y','1','6','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1280*960*2 },

	{ identifier: "Y(Mono16) 1600x1200",
	  size:     { x: 0, y: 0, width: 1600, height: 1200}, 
	  min_size: { x: 0, y: 0, width: 1600, height: 1200}, 
	  max_size: { x: 0, y: 0, width: 1600, height: 1200}, 
	  h_stepping: -1, 
	  v_stepping: -1, 
	  sizes:      0, 
	  size_count: 0, 
	  bpp: 16, 
	  fourcc: FOURCC('Y','1','6','0'), 
	  flags: 0, 
	  buffer_types: UNICAP_BUFFER_TYPE_USER | UNICAP_BUFFER_TYPE_SYSTEM, 
	  system_buffer_count: DCAM_NUM_DMA_BUFFERS,
	  buffer_size: 1600*1200*2 }
};

#endif//__DCAM_FORMAT_TABLE_H__
