# SPDX-FileCopyrightText: 2015-2024 Alexey Rochev
#
# SPDX-License-Identifier: CC0-1.0

set(CPACK_THREADS 0)
set(CPACK_PACKAGE_DIRECTORY "${CMAKE_CURRENT_BINARY_DIR}")

if (WIN32)
    set(os "Windows")
elseif (APPLE)
    set(os "macOS")
else ()
    message(FATAL_ERROR "Unsupported target platform ${CMAKE_SYSTEM_NAME}")
endif ()

if (DEFINED VCPKG_TARGET_TRIPLET)
    if (VCPKG_TARGET_TRIPLET MATCHES "^x64.*$")
        set(arch "x86_64")
    elseif (VCPKG_TARGET_TRIPLET MATCHES "^arm64.*$")
        set(arch "arm64")
    else ()
        message(FATAL_ERROR "Unsupported VCPKG_TARGET_TRIPLET ${VCPKG_TARGET_TRIPLET}")
    endif ()
elseif (DEFINED CMAKE_OSX_ARCHITECTURES)
    if (CMAKE_OSX_ARCHITECTURES STREQUAL "x86_64")
        set(arch "x86_64")
    elseif (CMAKE_OSX_ARCHITECTURES STREQUAL "arm64")
        set(arch "arm64")
    else ()
        message(FATAL_ERROR "Unsupported CMAKE_OSX_ARCHITECTURES ${CMAKE_OSX_ARCHITECTURES}")
    endif ()
else ()
    string(TOLOWER "${CMAKE_SYSTEM_PROCESSOR}" target_arch)
    if ((target_arch STREQUAL "amd64") OR (target_arch STREQUAL "x86_64"))
        set(arch "x86_64")
    elseif (target_arch STREQUAL "arm64")
        set(arch "arm64")
    else ()
        message(FATAL_ERROR "Unsupported target architecture ${target_arch}")
    endif ()
endif ()

get_property(is_multi_config GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG)
if (is_multi_config)
    set(CPACK_PACKAGE_FILE_NAME "${PROJECT_NAME}-${PROJECT_VERSION}-${os}-${arch}-\${CPACK_BUILD_CONFIG}")
else ()
    set(CPACK_PACKAGE_FILE_NAME "${PROJECT_NAME}-${PROJECT_VERSION}-${os}-${arch}-${CMAKE_BUILD_TYPE}")
endif ()
