use super::{Element, Isotope};

impl Isotope {
    /// Returns the chemical element associated with the isotope
    ///
    /// ```
    /// use mendeleev::{Element, Isotope};
    /// assert_eq!(Isotope::H1.element(), Element::H);
    /// assert_eq!(Isotope::Og295.element(), Element::Og);
    /// ```
    pub const fn element(&self) -> Element {
        match self {
            Isotope::H1 => Element::H,
            Isotope::H2 => Element::H,
            Isotope::H3 => Element::H,
            Isotope::H4 => Element::H,
            Isotope::H5 => Element::H,
            Isotope::H6 => Element::H,
            Isotope::H7 => Element::H,
            Isotope::He3 => Element::He,
            Isotope::He4 => Element::He,
            Isotope::He5 => Element::He,
            Isotope::He6 => Element::He,
            Isotope::He7 => Element::He,
            Isotope::He8 => Element::He,
            Isotope::He9 => Element::He,
            Isotope::He10 => Element::He,
            Isotope::Li3 => Element::Li,
            Isotope::Li4 => Element::Li,
            Isotope::Li5 => Element::Li,
            Isotope::Li6 => Element::Li,
            Isotope::Li7 => Element::Li,
            Isotope::Li8 => Element::Li,
            Isotope::Li9 => Element::Li,
            Isotope::Li10 => Element::Li,
            Isotope::Li11 => Element::Li,
            Isotope::Li12 => Element::Li,
            Isotope::Li13 => Element::Li,
            Isotope::Be5 => Element::Be,
            Isotope::Be6 => Element::Be,
            Isotope::Be7 => Element::Be,
            Isotope::Be8 => Element::Be,
            Isotope::Be9 => Element::Be,
            Isotope::Be10 => Element::Be,
            Isotope::Be11 => Element::Be,
            Isotope::Be12 => Element::Be,
            Isotope::Be13 => Element::Be,
            Isotope::Be14 => Element::Be,
            Isotope::Be15 => Element::Be,
            Isotope::Be16 => Element::Be,
            Isotope::B6 => Element::B,
            Isotope::B7 => Element::B,
            Isotope::B8 => Element::B,
            Isotope::B9 => Element::B,
            Isotope::B10 => Element::B,
            Isotope::B11 => Element::B,
            Isotope::B12 => Element::B,
            Isotope::B13 => Element::B,
            Isotope::B14 => Element::B,
            Isotope::B15 => Element::B,
            Isotope::B16 => Element::B,
            Isotope::B17 => Element::B,
            Isotope::B18 => Element::B,
            Isotope::B19 => Element::B,
            Isotope::B20 => Element::B,
            Isotope::B21 => Element::B,
            Isotope::C8 => Element::C,
            Isotope::C9 => Element::C,
            Isotope::C10 => Element::C,
            Isotope::C11 => Element::C,
            Isotope::C12 => Element::C,
            Isotope::C13 => Element::C,
            Isotope::C14 => Element::C,
            Isotope::C15 => Element::C,
            Isotope::C16 => Element::C,
            Isotope::C17 => Element::C,
            Isotope::C18 => Element::C,
            Isotope::C19 => Element::C,
            Isotope::C20 => Element::C,
            Isotope::C21 => Element::C,
            Isotope::C22 => Element::C,
            Isotope::C23 => Element::C,
            Isotope::N10 => Element::N,
            Isotope::N11 => Element::N,
            Isotope::N12 => Element::N,
            Isotope::N13 => Element::N,
            Isotope::N14 => Element::N,
            Isotope::N15 => Element::N,
            Isotope::N16 => Element::N,
            Isotope::N17 => Element::N,
            Isotope::N18 => Element::N,
            Isotope::N19 => Element::N,
            Isotope::N20 => Element::N,
            Isotope::N21 => Element::N,
            Isotope::N22 => Element::N,
            Isotope::N23 => Element::N,
            Isotope::N24 => Element::N,
            Isotope::N25 => Element::N,
            Isotope::O11 => Element::O,
            Isotope::O12 => Element::O,
            Isotope::O13 => Element::O,
            Isotope::O14 => Element::O,
            Isotope::O15 => Element::O,
            Isotope::O16 => Element::O,
            Isotope::O17 => Element::O,
            Isotope::O18 => Element::O,
            Isotope::O19 => Element::O,
            Isotope::O20 => Element::O,
            Isotope::O21 => Element::O,
            Isotope::O22 => Element::O,
            Isotope::O23 => Element::O,
            Isotope::O24 => Element::O,
            Isotope::O25 => Element::O,
            Isotope::O26 => Element::O,
            Isotope::O27 => Element::O,
            Isotope::O28 => Element::O,
            Isotope::F13 => Element::F,
            Isotope::F14 => Element::F,
            Isotope::F15 => Element::F,
            Isotope::F16 => Element::F,
            Isotope::F17 => Element::F,
            Isotope::F18 => Element::F,
            Isotope::F19 => Element::F,
            Isotope::F20 => Element::F,
            Isotope::F21 => Element::F,
            Isotope::F22 => Element::F,
            Isotope::F23 => Element::F,
            Isotope::F24 => Element::F,
            Isotope::F25 => Element::F,
            Isotope::F26 => Element::F,
            Isotope::F27 => Element::F,
            Isotope::F28 => Element::F,
            Isotope::F29 => Element::F,
            Isotope::F30 => Element::F,
            Isotope::F31 => Element::F,
            Isotope::Ne15 => Element::Ne,
            Isotope::Ne16 => Element::Ne,
            Isotope::Ne17 => Element::Ne,
            Isotope::Ne18 => Element::Ne,
            Isotope::Ne19 => Element::Ne,
            Isotope::Ne20 => Element::Ne,
            Isotope::Ne21 => Element::Ne,
            Isotope::Ne22 => Element::Ne,
            Isotope::Ne23 => Element::Ne,
            Isotope::Ne24 => Element::Ne,
            Isotope::Ne25 => Element::Ne,
            Isotope::Ne26 => Element::Ne,
            Isotope::Ne27 => Element::Ne,
            Isotope::Ne28 => Element::Ne,
            Isotope::Ne29 => Element::Ne,
            Isotope::Ne30 => Element::Ne,
            Isotope::Ne31 => Element::Ne,
            Isotope::Ne32 => Element::Ne,
            Isotope::Ne33 => Element::Ne,
            Isotope::Ne34 => Element::Ne,
            Isotope::Na17 => Element::Na,
            Isotope::Na18 => Element::Na,
            Isotope::Na19 => Element::Na,
            Isotope::Na20 => Element::Na,
            Isotope::Na21 => Element::Na,
            Isotope::Na22 => Element::Na,
            Isotope::Na23 => Element::Na,
            Isotope::Na24 => Element::Na,
            Isotope::Na25 => Element::Na,
            Isotope::Na26 => Element::Na,
            Isotope::Na27 => Element::Na,
            Isotope::Na28 => Element::Na,
            Isotope::Na29 => Element::Na,
            Isotope::Na30 => Element::Na,
            Isotope::Na31 => Element::Na,
            Isotope::Na32 => Element::Na,
            Isotope::Na33 => Element::Na,
            Isotope::Na34 => Element::Na,
            Isotope::Na35 => Element::Na,
            Isotope::Na36 => Element::Na,
            Isotope::Na37 => Element::Na,
            Isotope::Na38 => Element::Na,
            Isotope::Na39 => Element::Na,
            Isotope::Mg19 => Element::Mg,
            Isotope::Mg20 => Element::Mg,
            Isotope::Mg21 => Element::Mg,
            Isotope::Mg22 => Element::Mg,
            Isotope::Mg23 => Element::Mg,
            Isotope::Mg24 => Element::Mg,
            Isotope::Mg25 => Element::Mg,
            Isotope::Mg26 => Element::Mg,
            Isotope::Mg27 => Element::Mg,
            Isotope::Mg28 => Element::Mg,
            Isotope::Mg29 => Element::Mg,
            Isotope::Mg30 => Element::Mg,
            Isotope::Mg31 => Element::Mg,
            Isotope::Mg32 => Element::Mg,
            Isotope::Mg33 => Element::Mg,
            Isotope::Mg34 => Element::Mg,
            Isotope::Mg35 => Element::Mg,
            Isotope::Mg36 => Element::Mg,
            Isotope::Mg37 => Element::Mg,
            Isotope::Mg38 => Element::Mg,
            Isotope::Mg39 => Element::Mg,
            Isotope::Mg40 => Element::Mg,
            Isotope::Mg41 => Element::Mg,
            Isotope::Al21 => Element::Al,
            Isotope::Al22 => Element::Al,
            Isotope::Al23 => Element::Al,
            Isotope::Al24 => Element::Al,
            Isotope::Al25 => Element::Al,
            Isotope::Al26 => Element::Al,
            Isotope::Al27 => Element::Al,
            Isotope::Al28 => Element::Al,
            Isotope::Al29 => Element::Al,
            Isotope::Al30 => Element::Al,
            Isotope::Al31 => Element::Al,
            Isotope::Al32 => Element::Al,
            Isotope::Al33 => Element::Al,
            Isotope::Al34 => Element::Al,
            Isotope::Al35 => Element::Al,
            Isotope::Al36 => Element::Al,
            Isotope::Al37 => Element::Al,
            Isotope::Al38 => Element::Al,
            Isotope::Al39 => Element::Al,
            Isotope::Al40 => Element::Al,
            Isotope::Al41 => Element::Al,
            Isotope::Al42 => Element::Al,
            Isotope::Al43 => Element::Al,
            Isotope::Si22 => Element::Si,
            Isotope::Si23 => Element::Si,
            Isotope::Si24 => Element::Si,
            Isotope::Si25 => Element::Si,
            Isotope::Si26 => Element::Si,
            Isotope::Si27 => Element::Si,
            Isotope::Si28 => Element::Si,
            Isotope::Si29 => Element::Si,
            Isotope::Si30 => Element::Si,
            Isotope::Si31 => Element::Si,
            Isotope::Si32 => Element::Si,
            Isotope::Si33 => Element::Si,
            Isotope::Si34 => Element::Si,
            Isotope::Si35 => Element::Si,
            Isotope::Si36 => Element::Si,
            Isotope::Si37 => Element::Si,
            Isotope::Si38 => Element::Si,
            Isotope::Si39 => Element::Si,
            Isotope::Si40 => Element::Si,
            Isotope::Si41 => Element::Si,
            Isotope::Si42 => Element::Si,
            Isotope::Si43 => Element::Si,
            Isotope::Si44 => Element::Si,
            Isotope::Si45 => Element::Si,
            Isotope::P24 => Element::P,
            Isotope::P25 => Element::P,
            Isotope::P26 => Element::P,
            Isotope::P27 => Element::P,
            Isotope::P28 => Element::P,
            Isotope::P29 => Element::P,
            Isotope::P30 => Element::P,
            Isotope::P31 => Element::P,
            Isotope::P32 => Element::P,
            Isotope::P33 => Element::P,
            Isotope::P34 => Element::P,
            Isotope::P35 => Element::P,
            Isotope::P36 => Element::P,
            Isotope::P37 => Element::P,
            Isotope::P38 => Element::P,
            Isotope::P39 => Element::P,
            Isotope::P40 => Element::P,
            Isotope::P41 => Element::P,
            Isotope::P42 => Element::P,
            Isotope::P43 => Element::P,
            Isotope::P44 => Element::P,
            Isotope::P45 => Element::P,
            Isotope::P46 => Element::P,
            Isotope::P47 => Element::P,
            Isotope::S26 => Element::S,
            Isotope::S27 => Element::S,
            Isotope::S28 => Element::S,
            Isotope::S29 => Element::S,
            Isotope::S30 => Element::S,
            Isotope::S31 => Element::S,
            Isotope::S32 => Element::S,
            Isotope::S33 => Element::S,
            Isotope::S34 => Element::S,
            Isotope::S35 => Element::S,
            Isotope::S36 => Element::S,
            Isotope::S37 => Element::S,
            Isotope::S38 => Element::S,
            Isotope::S39 => Element::S,
            Isotope::S40 => Element::S,
            Isotope::S41 => Element::S,
            Isotope::S42 => Element::S,
            Isotope::S43 => Element::S,
            Isotope::S44 => Element::S,
            Isotope::S45 => Element::S,
            Isotope::S46 => Element::S,
            Isotope::S47 => Element::S,
            Isotope::S48 => Element::S,
            Isotope::S49 => Element::S,
            Isotope::Cl28 => Element::Cl,
            Isotope::Cl29 => Element::Cl,
            Isotope::Cl30 => Element::Cl,
            Isotope::Cl31 => Element::Cl,
            Isotope::Cl32 => Element::Cl,
            Isotope::Cl33 => Element::Cl,
            Isotope::Cl34 => Element::Cl,
            Isotope::Cl35 => Element::Cl,
            Isotope::Cl36 => Element::Cl,
            Isotope::Cl37 => Element::Cl,
            Isotope::Cl38 => Element::Cl,
            Isotope::Cl39 => Element::Cl,
            Isotope::Cl40 => Element::Cl,
            Isotope::Cl41 => Element::Cl,
            Isotope::Cl42 => Element::Cl,
            Isotope::Cl43 => Element::Cl,
            Isotope::Cl44 => Element::Cl,
            Isotope::Cl45 => Element::Cl,
            Isotope::Cl46 => Element::Cl,
            Isotope::Cl47 => Element::Cl,
            Isotope::Cl48 => Element::Cl,
            Isotope::Cl49 => Element::Cl,
            Isotope::Cl50 => Element::Cl,
            Isotope::Cl51 => Element::Cl,
            Isotope::Cl52 => Element::Cl,
            Isotope::Ar29 => Element::Ar,
            Isotope::Ar30 => Element::Ar,
            Isotope::Ar31 => Element::Ar,
            Isotope::Ar32 => Element::Ar,
            Isotope::Ar33 => Element::Ar,
            Isotope::Ar34 => Element::Ar,
            Isotope::Ar35 => Element::Ar,
            Isotope::Ar36 => Element::Ar,
            Isotope::Ar37 => Element::Ar,
            Isotope::Ar38 => Element::Ar,
            Isotope::Ar39 => Element::Ar,
            Isotope::Ar40 => Element::Ar,
            Isotope::Ar41 => Element::Ar,
            Isotope::Ar42 => Element::Ar,
            Isotope::Ar43 => Element::Ar,
            Isotope::Ar44 => Element::Ar,
            Isotope::Ar45 => Element::Ar,
            Isotope::Ar46 => Element::Ar,
            Isotope::Ar47 => Element::Ar,
            Isotope::Ar48 => Element::Ar,
            Isotope::Ar49 => Element::Ar,
            Isotope::Ar50 => Element::Ar,
            Isotope::Ar51 => Element::Ar,
            Isotope::Ar52 => Element::Ar,
            Isotope::Ar53 => Element::Ar,
            Isotope::Ar54 => Element::Ar,
            Isotope::K31 => Element::K,
            Isotope::K32 => Element::K,
            Isotope::K33 => Element::K,
            Isotope::K34 => Element::K,
            Isotope::K35 => Element::K,
            Isotope::K36 => Element::K,
            Isotope::K37 => Element::K,
            Isotope::K38 => Element::K,
            Isotope::K39 => Element::K,
            Isotope::K40 => Element::K,
            Isotope::K41 => Element::K,
            Isotope::K42 => Element::K,
            Isotope::K43 => Element::K,
            Isotope::K44 => Element::K,
            Isotope::K45 => Element::K,
            Isotope::K46 => Element::K,
            Isotope::K47 => Element::K,
            Isotope::K48 => Element::K,
            Isotope::K49 => Element::K,
            Isotope::K50 => Element::K,
            Isotope::K51 => Element::K,
            Isotope::K52 => Element::K,
            Isotope::K53 => Element::K,
            Isotope::K54 => Element::K,
            Isotope::K55 => Element::K,
            Isotope::K56 => Element::K,
            Isotope::K57 => Element::K,
            Isotope::K58 => Element::K,
            Isotope::K59 => Element::K,
            Isotope::Ca33 => Element::Ca,
            Isotope::Ca34 => Element::Ca,
            Isotope::Ca35 => Element::Ca,
            Isotope::Ca36 => Element::Ca,
            Isotope::Ca37 => Element::Ca,
            Isotope::Ca38 => Element::Ca,
            Isotope::Ca39 => Element::Ca,
            Isotope::Ca40 => Element::Ca,
            Isotope::Ca41 => Element::Ca,
            Isotope::Ca42 => Element::Ca,
            Isotope::Ca43 => Element::Ca,
            Isotope::Ca44 => Element::Ca,
            Isotope::Ca45 => Element::Ca,
            Isotope::Ca46 => Element::Ca,
            Isotope::Ca47 => Element::Ca,
            Isotope::Ca48 => Element::Ca,
            Isotope::Ca49 => Element::Ca,
            Isotope::Ca50 => Element::Ca,
            Isotope::Ca51 => Element::Ca,
            Isotope::Ca52 => Element::Ca,
            Isotope::Ca53 => Element::Ca,
            Isotope::Ca54 => Element::Ca,
            Isotope::Ca55 => Element::Ca,
            Isotope::Ca56 => Element::Ca,
            Isotope::Ca57 => Element::Ca,
            Isotope::Ca58 => Element::Ca,
            Isotope::Ca59 => Element::Ca,
            Isotope::Ca60 => Element::Ca,
            Isotope::Ca61 => Element::Ca,
            Isotope::Sc35 => Element::Sc,
            Isotope::Sc36 => Element::Sc,
            Isotope::Sc37 => Element::Sc,
            Isotope::Sc38 => Element::Sc,
            Isotope::Sc39 => Element::Sc,
            Isotope::Sc40 => Element::Sc,
            Isotope::Sc41 => Element::Sc,
            Isotope::Sc42 => Element::Sc,
            Isotope::Sc43 => Element::Sc,
            Isotope::Sc44 => Element::Sc,
            Isotope::Sc45 => Element::Sc,
            Isotope::Sc46 => Element::Sc,
            Isotope::Sc47 => Element::Sc,
            Isotope::Sc48 => Element::Sc,
            Isotope::Sc49 => Element::Sc,
            Isotope::Sc50 => Element::Sc,
            Isotope::Sc51 => Element::Sc,
            Isotope::Sc52 => Element::Sc,
            Isotope::Sc53 => Element::Sc,
            Isotope::Sc54 => Element::Sc,
            Isotope::Sc55 => Element::Sc,
            Isotope::Sc56 => Element::Sc,
            Isotope::Sc57 => Element::Sc,
            Isotope::Sc58 => Element::Sc,
            Isotope::Sc59 => Element::Sc,
            Isotope::Sc60 => Element::Sc,
            Isotope::Sc61 => Element::Sc,
            Isotope::Sc62 => Element::Sc,
            Isotope::Sc63 => Element::Sc,
            Isotope::Ti37 => Element::Ti,
            Isotope::Ti38 => Element::Ti,
            Isotope::Ti39 => Element::Ti,
            Isotope::Ti40 => Element::Ti,
            Isotope::Ti41 => Element::Ti,
            Isotope::Ti42 => Element::Ti,
            Isotope::Ti43 => Element::Ti,
            Isotope::Ti44 => Element::Ti,
            Isotope::Ti45 => Element::Ti,
            Isotope::Ti46 => Element::Ti,
            Isotope::Ti47 => Element::Ti,
            Isotope::Ti48 => Element::Ti,
            Isotope::Ti49 => Element::Ti,
            Isotope::Ti50 => Element::Ti,
            Isotope::Ti51 => Element::Ti,
            Isotope::Ti52 => Element::Ti,
            Isotope::Ti53 => Element::Ti,
            Isotope::Ti54 => Element::Ti,
            Isotope::Ti55 => Element::Ti,
            Isotope::Ti56 => Element::Ti,
            Isotope::Ti57 => Element::Ti,
            Isotope::Ti58 => Element::Ti,
            Isotope::Ti59 => Element::Ti,
            Isotope::Ti60 => Element::Ti,
            Isotope::Ti61 => Element::Ti,
            Isotope::Ti62 => Element::Ti,
            Isotope::Ti63 => Element::Ti,
            Isotope::Ti64 => Element::Ti,
            Isotope::Ti65 => Element::Ti,
            Isotope::V39 => Element::V,
            Isotope::V40 => Element::V,
            Isotope::V41 => Element::V,
            Isotope::V42 => Element::V,
            Isotope::V43 => Element::V,
            Isotope::V44 => Element::V,
            Isotope::V45 => Element::V,
            Isotope::V46 => Element::V,
            Isotope::V47 => Element::V,
            Isotope::V48 => Element::V,
            Isotope::V49 => Element::V,
            Isotope::V50 => Element::V,
            Isotope::V51 => Element::V,
            Isotope::V52 => Element::V,
            Isotope::V53 => Element::V,
            Isotope::V54 => Element::V,
            Isotope::V55 => Element::V,
            Isotope::V56 => Element::V,
            Isotope::V57 => Element::V,
            Isotope::V58 => Element::V,
            Isotope::V59 => Element::V,
            Isotope::V60 => Element::V,
            Isotope::V61 => Element::V,
            Isotope::V62 => Element::V,
            Isotope::V63 => Element::V,
            Isotope::V64 => Element::V,
            Isotope::V65 => Element::V,
            Isotope::V66 => Element::V,
            Isotope::V67 => Element::V,
            Isotope::Cr41 => Element::Cr,
            Isotope::Cr42 => Element::Cr,
            Isotope::Cr43 => Element::Cr,
            Isotope::Cr44 => Element::Cr,
            Isotope::Cr45 => Element::Cr,
            Isotope::Cr46 => Element::Cr,
            Isotope::Cr47 => Element::Cr,
            Isotope::Cr48 => Element::Cr,
            Isotope::Cr49 => Element::Cr,
            Isotope::Cr50 => Element::Cr,
            Isotope::Cr51 => Element::Cr,
            Isotope::Cr52 => Element::Cr,
            Isotope::Cr53 => Element::Cr,
            Isotope::Cr54 => Element::Cr,
            Isotope::Cr55 => Element::Cr,
            Isotope::Cr56 => Element::Cr,
            Isotope::Cr57 => Element::Cr,
            Isotope::Cr58 => Element::Cr,
            Isotope::Cr59 => Element::Cr,
            Isotope::Cr60 => Element::Cr,
            Isotope::Cr61 => Element::Cr,
            Isotope::Cr62 => Element::Cr,
            Isotope::Cr63 => Element::Cr,
            Isotope::Cr64 => Element::Cr,
            Isotope::Cr65 => Element::Cr,
            Isotope::Cr66 => Element::Cr,
            Isotope::Cr67 => Element::Cr,
            Isotope::Cr68 => Element::Cr,
            Isotope::Cr69 => Element::Cr,
            Isotope::Cr70 => Element::Cr,
            Isotope::Mn43 => Element::Mn,
            Isotope::Mn44 => Element::Mn,
            Isotope::Mn45 => Element::Mn,
            Isotope::Mn46 => Element::Mn,
            Isotope::Mn47 => Element::Mn,
            Isotope::Mn48 => Element::Mn,
            Isotope::Mn49 => Element::Mn,
            Isotope::Mn50 => Element::Mn,
            Isotope::Mn51 => Element::Mn,
            Isotope::Mn52 => Element::Mn,
            Isotope::Mn53 => Element::Mn,
            Isotope::Mn54 => Element::Mn,
            Isotope::Mn55 => Element::Mn,
            Isotope::Mn56 => Element::Mn,
            Isotope::Mn57 => Element::Mn,
            Isotope::Mn58 => Element::Mn,
            Isotope::Mn59 => Element::Mn,
            Isotope::Mn60 => Element::Mn,
            Isotope::Mn61 => Element::Mn,
            Isotope::Mn62 => Element::Mn,
            Isotope::Mn63 => Element::Mn,
            Isotope::Mn64 => Element::Mn,
            Isotope::Mn65 => Element::Mn,
            Isotope::Mn66 => Element::Mn,
            Isotope::Mn67 => Element::Mn,
            Isotope::Mn68 => Element::Mn,
            Isotope::Mn69 => Element::Mn,
            Isotope::Mn70 => Element::Mn,
            Isotope::Mn71 => Element::Mn,
            Isotope::Mn72 => Element::Mn,
            Isotope::Mn73 => Element::Mn,
            Isotope::Fe45 => Element::Fe,
            Isotope::Fe46 => Element::Fe,
            Isotope::Fe47 => Element::Fe,
            Isotope::Fe48 => Element::Fe,
            Isotope::Fe49 => Element::Fe,
            Isotope::Fe50 => Element::Fe,
            Isotope::Fe51 => Element::Fe,
            Isotope::Fe52 => Element::Fe,
            Isotope::Fe53 => Element::Fe,
            Isotope::Fe54 => Element::Fe,
            Isotope::Fe55 => Element::Fe,
            Isotope::Fe56 => Element::Fe,
            Isotope::Fe57 => Element::Fe,
            Isotope::Fe58 => Element::Fe,
            Isotope::Fe59 => Element::Fe,
            Isotope::Fe60 => Element::Fe,
            Isotope::Fe61 => Element::Fe,
            Isotope::Fe62 => Element::Fe,
            Isotope::Fe63 => Element::Fe,
            Isotope::Fe64 => Element::Fe,
            Isotope::Fe65 => Element::Fe,
            Isotope::Fe66 => Element::Fe,
            Isotope::Fe67 => Element::Fe,
            Isotope::Fe68 => Element::Fe,
            Isotope::Fe69 => Element::Fe,
            Isotope::Fe70 => Element::Fe,
            Isotope::Fe71 => Element::Fe,
            Isotope::Fe72 => Element::Fe,
            Isotope::Fe73 => Element::Fe,
            Isotope::Fe74 => Element::Fe,
            Isotope::Fe75 => Element::Fe,
            Isotope::Fe76 => Element::Fe,
            Isotope::Co47 => Element::Co,
            Isotope::Co48 => Element::Co,
            Isotope::Co49 => Element::Co,
            Isotope::Co50 => Element::Co,
            Isotope::Co51 => Element::Co,
            Isotope::Co52 => Element::Co,
            Isotope::Co53 => Element::Co,
            Isotope::Co54 => Element::Co,
            Isotope::Co55 => Element::Co,
            Isotope::Co56 => Element::Co,
            Isotope::Co57 => Element::Co,
            Isotope::Co58 => Element::Co,
            Isotope::Co59 => Element::Co,
            Isotope::Co60 => Element::Co,
            Isotope::Co61 => Element::Co,
            Isotope::Co62 => Element::Co,
            Isotope::Co63 => Element::Co,
            Isotope::Co64 => Element::Co,
            Isotope::Co65 => Element::Co,
            Isotope::Co66 => Element::Co,
            Isotope::Co67 => Element::Co,
            Isotope::Co68 => Element::Co,
            Isotope::Co69 => Element::Co,
            Isotope::Co70 => Element::Co,
            Isotope::Co71 => Element::Co,
            Isotope::Co72 => Element::Co,
            Isotope::Co73 => Element::Co,
            Isotope::Co74 => Element::Co,
            Isotope::Co75 => Element::Co,
            Isotope::Co76 => Element::Co,
            Isotope::Co77 => Element::Co,
            Isotope::Co78 => Element::Co,
            Isotope::Ni48 => Element::Ni,
            Isotope::Ni49 => Element::Ni,
            Isotope::Ni50 => Element::Ni,
            Isotope::Ni51 => Element::Ni,
            Isotope::Ni52 => Element::Ni,
            Isotope::Ni53 => Element::Ni,
            Isotope::Ni54 => Element::Ni,
            Isotope::Ni55 => Element::Ni,
            Isotope::Ni56 => Element::Ni,
            Isotope::Ni57 => Element::Ni,
            Isotope::Ni58 => Element::Ni,
            Isotope::Ni59 => Element::Ni,
            Isotope::Ni60 => Element::Ni,
            Isotope::Ni61 => Element::Ni,
            Isotope::Ni62 => Element::Ni,
            Isotope::Ni63 => Element::Ni,
            Isotope::Ni64 => Element::Ni,
            Isotope::Ni65 => Element::Ni,
            Isotope::Ni66 => Element::Ni,
            Isotope::Ni67 => Element::Ni,
            Isotope::Ni68 => Element::Ni,
            Isotope::Ni69 => Element::Ni,
            Isotope::Ni70 => Element::Ni,
            Isotope::Ni71 => Element::Ni,
            Isotope::Ni72 => Element::Ni,
            Isotope::Ni73 => Element::Ni,
            Isotope::Ni74 => Element::Ni,
            Isotope::Ni75 => Element::Ni,
            Isotope::Ni76 => Element::Ni,
            Isotope::Ni77 => Element::Ni,
            Isotope::Ni78 => Element::Ni,
            Isotope::Ni79 => Element::Ni,
            Isotope::Ni80 => Element::Ni,
            Isotope::Ni81 => Element::Ni,
            Isotope::Ni82 => Element::Ni,
            Isotope::Cu52 => Element::Cu,
            Isotope::Cu53 => Element::Cu,
            Isotope::Cu54 => Element::Cu,
            Isotope::Cu55 => Element::Cu,
            Isotope::Cu56 => Element::Cu,
            Isotope::Cu57 => Element::Cu,
            Isotope::Cu58 => Element::Cu,
            Isotope::Cu59 => Element::Cu,
            Isotope::Cu60 => Element::Cu,
            Isotope::Cu61 => Element::Cu,
            Isotope::Cu62 => Element::Cu,
            Isotope::Cu63 => Element::Cu,
            Isotope::Cu64 => Element::Cu,
            Isotope::Cu65 => Element::Cu,
            Isotope::Cu66 => Element::Cu,
            Isotope::Cu67 => Element::Cu,
            Isotope::Cu68 => Element::Cu,
            Isotope::Cu69 => Element::Cu,
            Isotope::Cu70 => Element::Cu,
            Isotope::Cu71 => Element::Cu,
            Isotope::Cu72 => Element::Cu,
            Isotope::Cu73 => Element::Cu,
            Isotope::Cu74 => Element::Cu,
            Isotope::Cu75 => Element::Cu,
            Isotope::Cu76 => Element::Cu,
            Isotope::Cu77 => Element::Cu,
            Isotope::Cu78 => Element::Cu,
            Isotope::Cu79 => Element::Cu,
            Isotope::Cu80 => Element::Cu,
            Isotope::Cu81 => Element::Cu,
            Isotope::Cu82 => Element::Cu,
            Isotope::Cu83 => Element::Cu,
            Isotope::Cu84 => Element::Cu,
            Isotope::Zn54 => Element::Zn,
            Isotope::Zn55 => Element::Zn,
            Isotope::Zn56 => Element::Zn,
            Isotope::Zn57 => Element::Zn,
            Isotope::Zn58 => Element::Zn,
            Isotope::Zn59 => Element::Zn,
            Isotope::Zn60 => Element::Zn,
            Isotope::Zn61 => Element::Zn,
            Isotope::Zn62 => Element::Zn,
            Isotope::Zn63 => Element::Zn,
            Isotope::Zn64 => Element::Zn,
            Isotope::Zn65 => Element::Zn,
            Isotope::Zn66 => Element::Zn,
            Isotope::Zn67 => Element::Zn,
            Isotope::Zn68 => Element::Zn,
            Isotope::Zn69 => Element::Zn,
            Isotope::Zn70 => Element::Zn,
            Isotope::Zn71 => Element::Zn,
            Isotope::Zn72 => Element::Zn,
            Isotope::Zn73 => Element::Zn,
            Isotope::Zn74 => Element::Zn,
            Isotope::Zn75 => Element::Zn,
            Isotope::Zn76 => Element::Zn,
            Isotope::Zn77 => Element::Zn,
            Isotope::Zn78 => Element::Zn,
            Isotope::Zn79 => Element::Zn,
            Isotope::Zn80 => Element::Zn,
            Isotope::Zn81 => Element::Zn,
            Isotope::Zn82 => Element::Zn,
            Isotope::Zn83 => Element::Zn,
            Isotope::Zn84 => Element::Zn,
            Isotope::Zn85 => Element::Zn,
            Isotope::Zn86 => Element::Zn,
            Isotope::Ga56 => Element::Ga,
            Isotope::Ga57 => Element::Ga,
            Isotope::Ga58 => Element::Ga,
            Isotope::Ga59 => Element::Ga,
            Isotope::Ga60 => Element::Ga,
            Isotope::Ga61 => Element::Ga,
            Isotope::Ga62 => Element::Ga,
            Isotope::Ga63 => Element::Ga,
            Isotope::Ga64 => Element::Ga,
            Isotope::Ga65 => Element::Ga,
            Isotope::Ga66 => Element::Ga,
            Isotope::Ga67 => Element::Ga,
            Isotope::Ga68 => Element::Ga,
            Isotope::Ga69 => Element::Ga,
            Isotope::Ga70 => Element::Ga,
            Isotope::Ga71 => Element::Ga,
            Isotope::Ga72 => Element::Ga,
            Isotope::Ga73 => Element::Ga,
            Isotope::Ga74 => Element::Ga,
            Isotope::Ga75 => Element::Ga,
            Isotope::Ga76 => Element::Ga,
            Isotope::Ga77 => Element::Ga,
            Isotope::Ga78 => Element::Ga,
            Isotope::Ga79 => Element::Ga,
            Isotope::Ga80 => Element::Ga,
            Isotope::Ga81 => Element::Ga,
            Isotope::Ga82 => Element::Ga,
            Isotope::Ga83 => Element::Ga,
            Isotope::Ga84 => Element::Ga,
            Isotope::Ga85 => Element::Ga,
            Isotope::Ga86 => Element::Ga,
            Isotope::Ga87 => Element::Ga,
            Isotope::Ga88 => Element::Ga,
            Isotope::Ge58 => Element::Ge,
            Isotope::Ge59 => Element::Ge,
            Isotope::Ge60 => Element::Ge,
            Isotope::Ge61 => Element::Ge,
            Isotope::Ge62 => Element::Ge,
            Isotope::Ge63 => Element::Ge,
            Isotope::Ge64 => Element::Ge,
            Isotope::Ge65 => Element::Ge,
            Isotope::Ge66 => Element::Ge,
            Isotope::Ge67 => Element::Ge,
            Isotope::Ge68 => Element::Ge,
            Isotope::Ge69 => Element::Ge,
            Isotope::Ge70 => Element::Ge,
            Isotope::Ge71 => Element::Ge,
            Isotope::Ge72 => Element::Ge,
            Isotope::Ge73 => Element::Ge,
            Isotope::Ge74 => Element::Ge,
            Isotope::Ge75 => Element::Ge,
            Isotope::Ge76 => Element::Ge,
            Isotope::Ge77 => Element::Ge,
            Isotope::Ge78 => Element::Ge,
            Isotope::Ge79 => Element::Ge,
            Isotope::Ge80 => Element::Ge,
            Isotope::Ge81 => Element::Ge,
            Isotope::Ge82 => Element::Ge,
            Isotope::Ge83 => Element::Ge,
            Isotope::Ge84 => Element::Ge,
            Isotope::Ge85 => Element::Ge,
            Isotope::Ge86 => Element::Ge,
            Isotope::Ge87 => Element::Ge,
            Isotope::Ge88 => Element::Ge,
            Isotope::Ge89 => Element::Ge,
            Isotope::Ge90 => Element::Ge,
            Isotope::As60 => Element::As,
            Isotope::As61 => Element::As,
            Isotope::As62 => Element::As,
            Isotope::As63 => Element::As,
            Isotope::As64 => Element::As,
            Isotope::As65 => Element::As,
            Isotope::As66 => Element::As,
            Isotope::As67 => Element::As,
            Isotope::As68 => Element::As,
            Isotope::As69 => Element::As,
            Isotope::As70 => Element::As,
            Isotope::As71 => Element::As,
            Isotope::As72 => Element::As,
            Isotope::As73 => Element::As,
            Isotope::As74 => Element::As,
            Isotope::As75 => Element::As,
            Isotope::As76 => Element::As,
            Isotope::As77 => Element::As,
            Isotope::As78 => Element::As,
            Isotope::As79 => Element::As,
            Isotope::As80 => Element::As,
            Isotope::As81 => Element::As,
            Isotope::As82 => Element::As,
            Isotope::As83 => Element::As,
            Isotope::As84 => Element::As,
            Isotope::As85 => Element::As,
            Isotope::As86 => Element::As,
            Isotope::As87 => Element::As,
            Isotope::As88 => Element::As,
            Isotope::As89 => Element::As,
            Isotope::As90 => Element::As,
            Isotope::As91 => Element::As,
            Isotope::As92 => Element::As,
            Isotope::Se63 => Element::Se,
            Isotope::Se64 => Element::Se,
            Isotope::Se65 => Element::Se,
            Isotope::Se66 => Element::Se,
            Isotope::Se67 => Element::Se,
            Isotope::Se68 => Element::Se,
            Isotope::Se69 => Element::Se,
            Isotope::Se70 => Element::Se,
            Isotope::Se71 => Element::Se,
            Isotope::Se72 => Element::Se,
            Isotope::Se73 => Element::Se,
            Isotope::Se74 => Element::Se,
            Isotope::Se75 => Element::Se,
            Isotope::Se76 => Element::Se,
            Isotope::Se77 => Element::Se,
            Isotope::Se78 => Element::Se,
            Isotope::Se79 => Element::Se,
            Isotope::Se80 => Element::Se,
            Isotope::Se81 => Element::Se,
            Isotope::Se82 => Element::Se,
            Isotope::Se83 => Element::Se,
            Isotope::Se84 => Element::Se,
            Isotope::Se85 => Element::Se,
            Isotope::Se86 => Element::Se,
            Isotope::Se87 => Element::Se,
            Isotope::Se88 => Element::Se,
            Isotope::Se89 => Element::Se,
            Isotope::Se90 => Element::Se,
            Isotope::Se91 => Element::Se,
            Isotope::Se92 => Element::Se,
            Isotope::Se93 => Element::Se,
            Isotope::Se94 => Element::Se,
            Isotope::Se95 => Element::Se,
            Isotope::Br65 => Element::Br,
            Isotope::Br66 => Element::Br,
            Isotope::Br67 => Element::Br,
            Isotope::Br68 => Element::Br,
            Isotope::Br69 => Element::Br,
            Isotope::Br70 => Element::Br,
            Isotope::Br71 => Element::Br,
            Isotope::Br72 => Element::Br,
            Isotope::Br73 => Element::Br,
            Isotope::Br74 => Element::Br,
            Isotope::Br75 => Element::Br,
            Isotope::Br76 => Element::Br,
            Isotope::Br77 => Element::Br,
            Isotope::Br78 => Element::Br,
            Isotope::Br79 => Element::Br,
            Isotope::Br80 => Element::Br,
            Isotope::Br81 => Element::Br,
            Isotope::Br82 => Element::Br,
            Isotope::Br83 => Element::Br,
            Isotope::Br84 => Element::Br,
            Isotope::Br85 => Element::Br,
            Isotope::Br86 => Element::Br,
            Isotope::Br87 => Element::Br,
            Isotope::Br88 => Element::Br,
            Isotope::Br89 => Element::Br,
            Isotope::Br90 => Element::Br,
            Isotope::Br91 => Element::Br,
            Isotope::Br92 => Element::Br,
            Isotope::Br93 => Element::Br,
            Isotope::Br94 => Element::Br,
            Isotope::Br95 => Element::Br,
            Isotope::Br96 => Element::Br,
            Isotope::Br97 => Element::Br,
            Isotope::Br98 => Element::Br,
            Isotope::Kr67 => Element::Kr,
            Isotope::Kr68 => Element::Kr,
            Isotope::Kr69 => Element::Kr,
            Isotope::Kr70 => Element::Kr,
            Isotope::Kr71 => Element::Kr,
            Isotope::Kr72 => Element::Kr,
            Isotope::Kr73 => Element::Kr,
            Isotope::Kr74 => Element::Kr,
            Isotope::Kr75 => Element::Kr,
            Isotope::Kr76 => Element::Kr,
            Isotope::Kr77 => Element::Kr,
            Isotope::Kr78 => Element::Kr,
            Isotope::Kr79 => Element::Kr,
            Isotope::Kr80 => Element::Kr,
            Isotope::Kr81 => Element::Kr,
            Isotope::Kr82 => Element::Kr,
            Isotope::Kr83 => Element::Kr,
            Isotope::Kr84 => Element::Kr,
            Isotope::Kr85 => Element::Kr,
            Isotope::Kr86 => Element::Kr,
            Isotope::Kr87 => Element::Kr,
            Isotope::Kr88 => Element::Kr,
            Isotope::Kr89 => Element::Kr,
            Isotope::Kr90 => Element::Kr,
            Isotope::Kr91 => Element::Kr,
            Isotope::Kr92 => Element::Kr,
            Isotope::Kr93 => Element::Kr,
            Isotope::Kr94 => Element::Kr,
            Isotope::Kr95 => Element::Kr,
            Isotope::Kr96 => Element::Kr,
            Isotope::Kr97 => Element::Kr,
            Isotope::Kr98 => Element::Kr,
            Isotope::Kr99 => Element::Kr,
            Isotope::Kr100 => Element::Kr,
            Isotope::Kr101 => Element::Kr,
            Isotope::Rb71 => Element::Rb,
            Isotope::Rb72 => Element::Rb,
            Isotope::Rb73 => Element::Rb,
            Isotope::Rb74 => Element::Rb,
            Isotope::Rb75 => Element::Rb,
            Isotope::Rb76 => Element::Rb,
            Isotope::Rb77 => Element::Rb,
            Isotope::Rb78 => Element::Rb,
            Isotope::Rb79 => Element::Rb,
            Isotope::Rb80 => Element::Rb,
            Isotope::Rb81 => Element::Rb,
            Isotope::Rb82 => Element::Rb,
            Isotope::Rb83 => Element::Rb,
            Isotope::Rb84 => Element::Rb,
            Isotope::Rb85 => Element::Rb,
            Isotope::Rb86 => Element::Rb,
            Isotope::Rb87 => Element::Rb,
            Isotope::Rb88 => Element::Rb,
            Isotope::Rb89 => Element::Rb,
            Isotope::Rb90 => Element::Rb,
            Isotope::Rb91 => Element::Rb,
            Isotope::Rb92 => Element::Rb,
            Isotope::Rb93 => Element::Rb,
            Isotope::Rb94 => Element::Rb,
            Isotope::Rb95 => Element::Rb,
            Isotope::Rb96 => Element::Rb,
            Isotope::Rb97 => Element::Rb,
            Isotope::Rb98 => Element::Rb,
            Isotope::Rb99 => Element::Rb,
            Isotope::Rb100 => Element::Rb,
            Isotope::Rb101 => Element::Rb,
            Isotope::Rb102 => Element::Rb,
            Isotope::Rb103 => Element::Rb,
            Isotope::Rb104 => Element::Rb,
            Isotope::Sr73 => Element::Sr,
            Isotope::Sr74 => Element::Sr,
            Isotope::Sr75 => Element::Sr,
            Isotope::Sr76 => Element::Sr,
            Isotope::Sr77 => Element::Sr,
            Isotope::Sr78 => Element::Sr,
            Isotope::Sr79 => Element::Sr,
            Isotope::Sr80 => Element::Sr,
            Isotope::Sr81 => Element::Sr,
            Isotope::Sr82 => Element::Sr,
            Isotope::Sr83 => Element::Sr,
            Isotope::Sr84 => Element::Sr,
            Isotope::Sr85 => Element::Sr,
            Isotope::Sr86 => Element::Sr,
            Isotope::Sr87 => Element::Sr,
            Isotope::Sr88 => Element::Sr,
            Isotope::Sr89 => Element::Sr,
            Isotope::Sr90 => Element::Sr,
            Isotope::Sr91 => Element::Sr,
            Isotope::Sr92 => Element::Sr,
            Isotope::Sr93 => Element::Sr,
            Isotope::Sr94 => Element::Sr,
            Isotope::Sr95 => Element::Sr,
            Isotope::Sr96 => Element::Sr,
            Isotope::Sr97 => Element::Sr,
            Isotope::Sr98 => Element::Sr,
            Isotope::Sr99 => Element::Sr,
            Isotope::Sr100 => Element::Sr,
            Isotope::Sr101 => Element::Sr,
            Isotope::Sr102 => Element::Sr,
            Isotope::Sr103 => Element::Sr,
            Isotope::Sr104 => Element::Sr,
            Isotope::Sr105 => Element::Sr,
            Isotope::Sr106 => Element::Sr,
            Isotope::Sr107 => Element::Sr,
            Isotope::Y75 => Element::Y,
            Isotope::Y76 => Element::Y,
            Isotope::Y77 => Element::Y,
            Isotope::Y78 => Element::Y,
            Isotope::Y79 => Element::Y,
            Isotope::Y80 => Element::Y,
            Isotope::Y81 => Element::Y,
            Isotope::Y82 => Element::Y,
            Isotope::Y83 => Element::Y,
            Isotope::Y84 => Element::Y,
            Isotope::Y85 => Element::Y,
            Isotope::Y86 => Element::Y,
            Isotope::Y87 => Element::Y,
            Isotope::Y88 => Element::Y,
            Isotope::Y89 => Element::Y,
            Isotope::Y90 => Element::Y,
            Isotope::Y91 => Element::Y,
            Isotope::Y92 => Element::Y,
            Isotope::Y93 => Element::Y,
            Isotope::Y94 => Element::Y,
            Isotope::Y95 => Element::Y,
            Isotope::Y96 => Element::Y,
            Isotope::Y97 => Element::Y,
            Isotope::Y98 => Element::Y,
            Isotope::Y99 => Element::Y,
            Isotope::Y100 => Element::Y,
            Isotope::Y101 => Element::Y,
            Isotope::Y102 => Element::Y,
            Isotope::Y103 => Element::Y,
            Isotope::Y104 => Element::Y,
            Isotope::Y105 => Element::Y,
            Isotope::Y106 => Element::Y,
            Isotope::Y107 => Element::Y,
            Isotope::Y108 => Element::Y,
            Isotope::Y109 => Element::Y,
            Isotope::Zr77 => Element::Zr,
            Isotope::Zr78 => Element::Zr,
            Isotope::Zr79 => Element::Zr,
            Isotope::Zr80 => Element::Zr,
            Isotope::Zr81 => Element::Zr,
            Isotope::Zr82 => Element::Zr,
            Isotope::Zr83 => Element::Zr,
            Isotope::Zr84 => Element::Zr,
            Isotope::Zr85 => Element::Zr,
            Isotope::Zr86 => Element::Zr,
            Isotope::Zr87 => Element::Zr,
            Isotope::Zr88 => Element::Zr,
            Isotope::Zr89 => Element::Zr,
            Isotope::Zr90 => Element::Zr,
            Isotope::Zr91 => Element::Zr,
            Isotope::Zr92 => Element::Zr,
            Isotope::Zr93 => Element::Zr,
            Isotope::Zr94 => Element::Zr,
            Isotope::Zr95 => Element::Zr,
            Isotope::Zr96 => Element::Zr,
            Isotope::Zr97 => Element::Zr,
            Isotope::Zr98 => Element::Zr,
            Isotope::Zr99 => Element::Zr,
            Isotope::Zr100 => Element::Zr,
            Isotope::Zr101 => Element::Zr,
            Isotope::Zr102 => Element::Zr,
            Isotope::Zr103 => Element::Zr,
            Isotope::Zr104 => Element::Zr,
            Isotope::Zr105 => Element::Zr,
            Isotope::Zr106 => Element::Zr,
            Isotope::Zr107 => Element::Zr,
            Isotope::Zr108 => Element::Zr,
            Isotope::Zr109 => Element::Zr,
            Isotope::Zr110 => Element::Zr,
            Isotope::Zr111 => Element::Zr,
            Isotope::Zr112 => Element::Zr,
            Isotope::Zr113 => Element::Zr,
            Isotope::Nb79 => Element::Nb,
            Isotope::Nb80 => Element::Nb,
            Isotope::Nb81 => Element::Nb,
            Isotope::Nb82 => Element::Nb,
            Isotope::Nb83 => Element::Nb,
            Isotope::Nb84 => Element::Nb,
            Isotope::Nb85 => Element::Nb,
            Isotope::Nb86 => Element::Nb,
            Isotope::Nb87 => Element::Nb,
            Isotope::Nb88 => Element::Nb,
            Isotope::Nb89 => Element::Nb,
            Isotope::Nb90 => Element::Nb,
            Isotope::Nb91 => Element::Nb,
            Isotope::Nb92 => Element::Nb,
            Isotope::Nb93 => Element::Nb,
            Isotope::Nb94 => Element::Nb,
            Isotope::Nb95 => Element::Nb,
            Isotope::Nb96 => Element::Nb,
            Isotope::Nb97 => Element::Nb,
            Isotope::Nb98 => Element::Nb,
            Isotope::Nb99 => Element::Nb,
            Isotope::Nb100 => Element::Nb,
            Isotope::Nb101 => Element::Nb,
            Isotope::Nb102 => Element::Nb,
            Isotope::Nb103 => Element::Nb,
            Isotope::Nb104 => Element::Nb,
            Isotope::Nb105 => Element::Nb,
            Isotope::Nb106 => Element::Nb,
            Isotope::Nb107 => Element::Nb,
            Isotope::Nb108 => Element::Nb,
            Isotope::Nb109 => Element::Nb,
            Isotope::Nb110 => Element::Nb,
            Isotope::Nb111 => Element::Nb,
            Isotope::Nb112 => Element::Nb,
            Isotope::Nb113 => Element::Nb,
            Isotope::Nb114 => Element::Nb,
            Isotope::Nb115 => Element::Nb,
            Isotope::Nb116 => Element::Nb,
            Isotope::Mo81 => Element::Mo,
            Isotope::Mo82 => Element::Mo,
            Isotope::Mo83 => Element::Mo,
            Isotope::Mo84 => Element::Mo,
            Isotope::Mo85 => Element::Mo,
            Isotope::Mo86 => Element::Mo,
            Isotope::Mo87 => Element::Mo,
            Isotope::Mo88 => Element::Mo,
            Isotope::Mo89 => Element::Mo,
            Isotope::Mo90 => Element::Mo,
            Isotope::Mo91 => Element::Mo,
            Isotope::Mo92 => Element::Mo,
            Isotope::Mo93 => Element::Mo,
            Isotope::Mo94 => Element::Mo,
            Isotope::Mo95 => Element::Mo,
            Isotope::Mo96 => Element::Mo,
            Isotope::Mo97 => Element::Mo,
            Isotope::Mo98 => Element::Mo,
            Isotope::Mo99 => Element::Mo,
            Isotope::Mo100 => Element::Mo,
            Isotope::Mo101 => Element::Mo,
            Isotope::Mo102 => Element::Mo,
            Isotope::Mo103 => Element::Mo,
            Isotope::Mo104 => Element::Mo,
            Isotope::Mo105 => Element::Mo,
            Isotope::Mo106 => Element::Mo,
            Isotope::Mo107 => Element::Mo,
            Isotope::Mo108 => Element::Mo,
            Isotope::Mo109 => Element::Mo,
            Isotope::Mo110 => Element::Mo,
            Isotope::Mo111 => Element::Mo,
            Isotope::Mo112 => Element::Mo,
            Isotope::Mo113 => Element::Mo,
            Isotope::Mo114 => Element::Mo,
            Isotope::Mo115 => Element::Mo,
            Isotope::Mo116 => Element::Mo,
            Isotope::Mo117 => Element::Mo,
            Isotope::Mo118 => Element::Mo,
            Isotope::Mo119 => Element::Mo,
            Isotope::Tc83 => Element::Tc,
            Isotope::Tc84 => Element::Tc,
            Isotope::Tc85 => Element::Tc,
            Isotope::Tc86 => Element::Tc,
            Isotope::Tc87 => Element::Tc,
            Isotope::Tc88 => Element::Tc,
            Isotope::Tc89 => Element::Tc,
            Isotope::Tc90 => Element::Tc,
            Isotope::Tc91 => Element::Tc,
            Isotope::Tc92 => Element::Tc,
            Isotope::Tc93 => Element::Tc,
            Isotope::Tc94 => Element::Tc,
            Isotope::Tc95 => Element::Tc,
            Isotope::Tc96 => Element::Tc,
            Isotope::Tc97 => Element::Tc,
            Isotope::Tc98 => Element::Tc,
            Isotope::Tc99 => Element::Tc,
            Isotope::Tc100 => Element::Tc,
            Isotope::Tc101 => Element::Tc,
            Isotope::Tc102 => Element::Tc,
            Isotope::Tc103 => Element::Tc,
            Isotope::Tc104 => Element::Tc,
            Isotope::Tc105 => Element::Tc,
            Isotope::Tc106 => Element::Tc,
            Isotope::Tc107 => Element::Tc,
            Isotope::Tc108 => Element::Tc,
            Isotope::Tc109 => Element::Tc,
            Isotope::Tc110 => Element::Tc,
            Isotope::Tc111 => Element::Tc,
            Isotope::Tc112 => Element::Tc,
            Isotope::Tc113 => Element::Tc,
            Isotope::Tc114 => Element::Tc,
            Isotope::Tc115 => Element::Tc,
            Isotope::Tc116 => Element::Tc,
            Isotope::Tc117 => Element::Tc,
            Isotope::Tc118 => Element::Tc,
            Isotope::Tc119 => Element::Tc,
            Isotope::Tc120 => Element::Tc,
            Isotope::Tc121 => Element::Tc,
            Isotope::Tc122 => Element::Tc,
            Isotope::Ru85 => Element::Ru,
            Isotope::Ru86 => Element::Ru,
            Isotope::Ru87 => Element::Ru,
            Isotope::Ru88 => Element::Ru,
            Isotope::Ru89 => Element::Ru,
            Isotope::Ru90 => Element::Ru,
            Isotope::Ru91 => Element::Ru,
            Isotope::Ru92 => Element::Ru,
            Isotope::Ru93 => Element::Ru,
            Isotope::Ru94 => Element::Ru,
            Isotope::Ru95 => Element::Ru,
            Isotope::Ru96 => Element::Ru,
            Isotope::Ru97 => Element::Ru,
            Isotope::Ru98 => Element::Ru,
            Isotope::Ru99 => Element::Ru,
            Isotope::Ru100 => Element::Ru,
            Isotope::Ru101 => Element::Ru,
            Isotope::Ru102 => Element::Ru,
            Isotope::Ru103 => Element::Ru,
            Isotope::Ru104 => Element::Ru,
            Isotope::Ru105 => Element::Ru,
            Isotope::Ru106 => Element::Ru,
            Isotope::Ru107 => Element::Ru,
            Isotope::Ru108 => Element::Ru,
            Isotope::Ru109 => Element::Ru,
            Isotope::Ru110 => Element::Ru,
            Isotope::Ru111 => Element::Ru,
            Isotope::Ru112 => Element::Ru,
            Isotope::Ru113 => Element::Ru,
            Isotope::Ru114 => Element::Ru,
            Isotope::Ru115 => Element::Ru,
            Isotope::Ru116 => Element::Ru,
            Isotope::Ru117 => Element::Ru,
            Isotope::Ru118 => Element::Ru,
            Isotope::Ru119 => Element::Ru,
            Isotope::Ru120 => Element::Ru,
            Isotope::Ru121 => Element::Ru,
            Isotope::Ru122 => Element::Ru,
            Isotope::Ru123 => Element::Ru,
            Isotope::Ru124 => Element::Ru,
            Isotope::Ru125 => Element::Ru,
            Isotope::Rh88 => Element::Rh,
            Isotope::Rh89 => Element::Rh,
            Isotope::Rh90 => Element::Rh,
            Isotope::Rh91 => Element::Rh,
            Isotope::Rh92 => Element::Rh,
            Isotope::Rh93 => Element::Rh,
            Isotope::Rh94 => Element::Rh,
            Isotope::Rh95 => Element::Rh,
            Isotope::Rh96 => Element::Rh,
            Isotope::Rh97 => Element::Rh,
            Isotope::Rh98 => Element::Rh,
            Isotope::Rh99 => Element::Rh,
            Isotope::Rh100 => Element::Rh,
            Isotope::Rh101 => Element::Rh,
            Isotope::Rh102 => Element::Rh,
            Isotope::Rh103 => Element::Rh,
            Isotope::Rh104 => Element::Rh,
            Isotope::Rh105 => Element::Rh,
            Isotope::Rh106 => Element::Rh,
            Isotope::Rh107 => Element::Rh,
            Isotope::Rh108 => Element::Rh,
            Isotope::Rh109 => Element::Rh,
            Isotope::Rh110 => Element::Rh,
            Isotope::Rh111 => Element::Rh,
            Isotope::Rh112 => Element::Rh,
            Isotope::Rh113 => Element::Rh,
            Isotope::Rh114 => Element::Rh,
            Isotope::Rh115 => Element::Rh,
            Isotope::Rh116 => Element::Rh,
            Isotope::Rh117 => Element::Rh,
            Isotope::Rh118 => Element::Rh,
            Isotope::Rh119 => Element::Rh,
            Isotope::Rh120 => Element::Rh,
            Isotope::Rh121 => Element::Rh,
            Isotope::Rh122 => Element::Rh,
            Isotope::Rh123 => Element::Rh,
            Isotope::Rh124 => Element::Rh,
            Isotope::Rh125 => Element::Rh,
            Isotope::Rh126 => Element::Rh,
            Isotope::Rh127 => Element::Rh,
            Isotope::Rh128 => Element::Rh,
            Isotope::Pd90 => Element::Pd,
            Isotope::Pd91 => Element::Pd,
            Isotope::Pd92 => Element::Pd,
            Isotope::Pd93 => Element::Pd,
            Isotope::Pd94 => Element::Pd,
            Isotope::Pd95 => Element::Pd,
            Isotope::Pd96 => Element::Pd,
            Isotope::Pd97 => Element::Pd,
            Isotope::Pd98 => Element::Pd,
            Isotope::Pd99 => Element::Pd,
            Isotope::Pd100 => Element::Pd,
            Isotope::Pd101 => Element::Pd,
            Isotope::Pd102 => Element::Pd,
            Isotope::Pd103 => Element::Pd,
            Isotope::Pd104 => Element::Pd,
            Isotope::Pd105 => Element::Pd,
            Isotope::Pd106 => Element::Pd,
            Isotope::Pd107 => Element::Pd,
            Isotope::Pd108 => Element::Pd,
            Isotope::Pd109 => Element::Pd,
            Isotope::Pd110 => Element::Pd,
            Isotope::Pd111 => Element::Pd,
            Isotope::Pd112 => Element::Pd,
            Isotope::Pd113 => Element::Pd,
            Isotope::Pd114 => Element::Pd,
            Isotope::Pd115 => Element::Pd,
            Isotope::Pd116 => Element::Pd,
            Isotope::Pd117 => Element::Pd,
            Isotope::Pd118 => Element::Pd,
            Isotope::Pd119 => Element::Pd,
            Isotope::Pd120 => Element::Pd,
            Isotope::Pd121 => Element::Pd,
            Isotope::Pd122 => Element::Pd,
            Isotope::Pd123 => Element::Pd,
            Isotope::Pd124 => Element::Pd,
            Isotope::Pd125 => Element::Pd,
            Isotope::Pd126 => Element::Pd,
            Isotope::Pd127 => Element::Pd,
            Isotope::Pd128 => Element::Pd,
            Isotope::Pd129 => Element::Pd,
            Isotope::Pd130 => Element::Pd,
            Isotope::Pd131 => Element::Pd,
            Isotope::Ag92 => Element::Ag,
            Isotope::Ag93 => Element::Ag,
            Isotope::Ag94 => Element::Ag,
            Isotope::Ag95 => Element::Ag,
            Isotope::Ag96 => Element::Ag,
            Isotope::Ag97 => Element::Ag,
            Isotope::Ag98 => Element::Ag,
            Isotope::Ag99 => Element::Ag,
            Isotope::Ag100 => Element::Ag,
            Isotope::Ag101 => Element::Ag,
            Isotope::Ag102 => Element::Ag,
            Isotope::Ag103 => Element::Ag,
            Isotope::Ag104 => Element::Ag,
            Isotope::Ag105 => Element::Ag,
            Isotope::Ag106 => Element::Ag,
            Isotope::Ag107 => Element::Ag,
            Isotope::Ag108 => Element::Ag,
            Isotope::Ag109 => Element::Ag,
            Isotope::Ag110 => Element::Ag,
            Isotope::Ag111 => Element::Ag,
            Isotope::Ag112 => Element::Ag,
            Isotope::Ag113 => Element::Ag,
            Isotope::Ag114 => Element::Ag,
            Isotope::Ag115 => Element::Ag,
            Isotope::Ag116 => Element::Ag,
            Isotope::Ag117 => Element::Ag,
            Isotope::Ag118 => Element::Ag,
            Isotope::Ag119 => Element::Ag,
            Isotope::Ag120 => Element::Ag,
            Isotope::Ag121 => Element::Ag,
            Isotope::Ag122 => Element::Ag,
            Isotope::Ag123 => Element::Ag,
            Isotope::Ag124 => Element::Ag,
            Isotope::Ag125 => Element::Ag,
            Isotope::Ag126 => Element::Ag,
            Isotope::Ag127 => Element::Ag,
            Isotope::Ag128 => Element::Ag,
            Isotope::Ag129 => Element::Ag,
            Isotope::Ag130 => Element::Ag,
            Isotope::Ag131 => Element::Ag,
            Isotope::Ag132 => Element::Ag,
            Isotope::Ag133 => Element::Ag,
            Isotope::Cd94 => Element::Cd,
            Isotope::Cd95 => Element::Cd,
            Isotope::Cd96 => Element::Cd,
            Isotope::Cd97 => Element::Cd,
            Isotope::Cd98 => Element::Cd,
            Isotope::Cd99 => Element::Cd,
            Isotope::Cd100 => Element::Cd,
            Isotope::Cd101 => Element::Cd,
            Isotope::Cd102 => Element::Cd,
            Isotope::Cd103 => Element::Cd,
            Isotope::Cd104 => Element::Cd,
            Isotope::Cd105 => Element::Cd,
            Isotope::Cd106 => Element::Cd,
            Isotope::Cd107 => Element::Cd,
            Isotope::Cd108 => Element::Cd,
            Isotope::Cd109 => Element::Cd,
            Isotope::Cd110 => Element::Cd,
            Isotope::Cd111 => Element::Cd,
            Isotope::Cd112 => Element::Cd,
            Isotope::Cd113 => Element::Cd,
            Isotope::Cd114 => Element::Cd,
            Isotope::Cd115 => Element::Cd,
            Isotope::Cd116 => Element::Cd,
            Isotope::Cd117 => Element::Cd,
            Isotope::Cd118 => Element::Cd,
            Isotope::Cd119 => Element::Cd,
            Isotope::Cd120 => Element::Cd,
            Isotope::Cd121 => Element::Cd,
            Isotope::Cd122 => Element::Cd,
            Isotope::Cd123 => Element::Cd,
            Isotope::Cd124 => Element::Cd,
            Isotope::Cd125 => Element::Cd,
            Isotope::Cd126 => Element::Cd,
            Isotope::Cd127 => Element::Cd,
            Isotope::Cd128 => Element::Cd,
            Isotope::Cd129 => Element::Cd,
            Isotope::Cd130 => Element::Cd,
            Isotope::Cd131 => Element::Cd,
            Isotope::Cd132 => Element::Cd,
            Isotope::Cd133 => Element::Cd,
            Isotope::Cd134 => Element::Cd,
            Isotope::Cd135 => Element::Cd,
            Isotope::In96 => Element::In,
            Isotope::In97 => Element::In,
            Isotope::In98 => Element::In,
            Isotope::In99 => Element::In,
            Isotope::In100 => Element::In,
            Isotope::In101 => Element::In,
            Isotope::In102 => Element::In,
            Isotope::In103 => Element::In,
            Isotope::In104 => Element::In,
            Isotope::In105 => Element::In,
            Isotope::In106 => Element::In,
            Isotope::In107 => Element::In,
            Isotope::In108 => Element::In,
            Isotope::In109 => Element::In,
            Isotope::In110 => Element::In,
            Isotope::In111 => Element::In,
            Isotope::In112 => Element::In,
            Isotope::In113 => Element::In,
            Isotope::In114 => Element::In,
            Isotope::In115 => Element::In,
            Isotope::In116 => Element::In,
            Isotope::In117 => Element::In,
            Isotope::In118 => Element::In,
            Isotope::In119 => Element::In,
            Isotope::In120 => Element::In,
            Isotope::In121 => Element::In,
            Isotope::In122 => Element::In,
            Isotope::In123 => Element::In,
            Isotope::In124 => Element::In,
            Isotope::In125 => Element::In,
            Isotope::In126 => Element::In,
            Isotope::In127 => Element::In,
            Isotope::In128 => Element::In,
            Isotope::In129 => Element::In,
            Isotope::In130 => Element::In,
            Isotope::In131 => Element::In,
            Isotope::In132 => Element::In,
            Isotope::In133 => Element::In,
            Isotope::In134 => Element::In,
            Isotope::In135 => Element::In,
            Isotope::In136 => Element::In,
            Isotope::In137 => Element::In,
            Isotope::Sn99 => Element::Sn,
            Isotope::Sn100 => Element::Sn,
            Isotope::Sn101 => Element::Sn,
            Isotope::Sn102 => Element::Sn,
            Isotope::Sn103 => Element::Sn,
            Isotope::Sn104 => Element::Sn,
            Isotope::Sn105 => Element::Sn,
            Isotope::Sn106 => Element::Sn,
            Isotope::Sn107 => Element::Sn,
            Isotope::Sn108 => Element::Sn,
            Isotope::Sn109 => Element::Sn,
            Isotope::Sn110 => Element::Sn,
            Isotope::Sn111 => Element::Sn,
            Isotope::Sn112 => Element::Sn,
            Isotope::Sn113 => Element::Sn,
            Isotope::Sn114 => Element::Sn,
            Isotope::Sn115 => Element::Sn,
            Isotope::Sn116 => Element::Sn,
            Isotope::Sn117 => Element::Sn,
            Isotope::Sn118 => Element::Sn,
            Isotope::Sn119 => Element::Sn,
            Isotope::Sn120 => Element::Sn,
            Isotope::Sn121 => Element::Sn,
            Isotope::Sn122 => Element::Sn,
            Isotope::Sn123 => Element::Sn,
            Isotope::Sn124 => Element::Sn,
            Isotope::Sn125 => Element::Sn,
            Isotope::Sn126 => Element::Sn,
            Isotope::Sn127 => Element::Sn,
            Isotope::Sn128 => Element::Sn,
            Isotope::Sn129 => Element::Sn,
            Isotope::Sn130 => Element::Sn,
            Isotope::Sn131 => Element::Sn,
            Isotope::Sn132 => Element::Sn,
            Isotope::Sn133 => Element::Sn,
            Isotope::Sn134 => Element::Sn,
            Isotope::Sn135 => Element::Sn,
            Isotope::Sn136 => Element::Sn,
            Isotope::Sn137 => Element::Sn,
            Isotope::Sn138 => Element::Sn,
            Isotope::Sn139 => Element::Sn,
            Isotope::Sn140 => Element::Sn,
            Isotope::Sb102 => Element::Sb,
            Isotope::Sb103 => Element::Sb,
            Isotope::Sb104 => Element::Sb,
            Isotope::Sb105 => Element::Sb,
            Isotope::Sb106 => Element::Sb,
            Isotope::Sb107 => Element::Sb,
            Isotope::Sb108 => Element::Sb,
            Isotope::Sb109 => Element::Sb,
            Isotope::Sb110 => Element::Sb,
            Isotope::Sb111 => Element::Sb,
            Isotope::Sb112 => Element::Sb,
            Isotope::Sb113 => Element::Sb,
            Isotope::Sb114 => Element::Sb,
            Isotope::Sb115 => Element::Sb,
            Isotope::Sb116 => Element::Sb,
            Isotope::Sb117 => Element::Sb,
            Isotope::Sb118 => Element::Sb,
            Isotope::Sb119 => Element::Sb,
            Isotope::Sb120 => Element::Sb,
            Isotope::Sb121 => Element::Sb,
            Isotope::Sb122 => Element::Sb,
            Isotope::Sb123 => Element::Sb,
            Isotope::Sb124 => Element::Sb,
            Isotope::Sb125 => Element::Sb,
            Isotope::Sb126 => Element::Sb,
            Isotope::Sb127 => Element::Sb,
            Isotope::Sb128 => Element::Sb,
            Isotope::Sb129 => Element::Sb,
            Isotope::Sb130 => Element::Sb,
            Isotope::Sb131 => Element::Sb,
            Isotope::Sb132 => Element::Sb,
            Isotope::Sb133 => Element::Sb,
            Isotope::Sb134 => Element::Sb,
            Isotope::Sb135 => Element::Sb,
            Isotope::Sb136 => Element::Sb,
            Isotope::Sb137 => Element::Sb,
            Isotope::Sb138 => Element::Sb,
            Isotope::Sb139 => Element::Sb,
            Isotope::Sb140 => Element::Sb,
            Isotope::Sb141 => Element::Sb,
            Isotope::Sb142 => Element::Sb,
            Isotope::Te104 => Element::Te,
            Isotope::Te105 => Element::Te,
            Isotope::Te106 => Element::Te,
            Isotope::Te107 => Element::Te,
            Isotope::Te108 => Element::Te,
            Isotope::Te109 => Element::Te,
            Isotope::Te110 => Element::Te,
            Isotope::Te111 => Element::Te,
            Isotope::Te112 => Element::Te,
            Isotope::Te113 => Element::Te,
            Isotope::Te114 => Element::Te,
            Isotope::Te115 => Element::Te,
            Isotope::Te116 => Element::Te,
            Isotope::Te117 => Element::Te,
            Isotope::Te118 => Element::Te,
            Isotope::Te119 => Element::Te,
            Isotope::Te120 => Element::Te,
            Isotope::Te121 => Element::Te,
            Isotope::Te122 => Element::Te,
            Isotope::Te123 => Element::Te,
            Isotope::Te124 => Element::Te,
            Isotope::Te125 => Element::Te,
            Isotope::Te126 => Element::Te,
            Isotope::Te127 => Element::Te,
            Isotope::Te128 => Element::Te,
            Isotope::Te129 => Element::Te,
            Isotope::Te130 => Element::Te,
            Isotope::Te131 => Element::Te,
            Isotope::Te132 => Element::Te,
            Isotope::Te133 => Element::Te,
            Isotope::Te134 => Element::Te,
            Isotope::Te135 => Element::Te,
            Isotope::Te136 => Element::Te,
            Isotope::Te137 => Element::Te,
            Isotope::Te138 => Element::Te,
            Isotope::Te139 => Element::Te,
            Isotope::Te140 => Element::Te,
            Isotope::Te141 => Element::Te,
            Isotope::Te142 => Element::Te,
            Isotope::Te143 => Element::Te,
            Isotope::Te144 => Element::Te,
            Isotope::Te145 => Element::Te,
            Isotope::I106 => Element::I,
            Isotope::I107 => Element::I,
            Isotope::I108 => Element::I,
            Isotope::I109 => Element::I,
            Isotope::I110 => Element::I,
            Isotope::I111 => Element::I,
            Isotope::I112 => Element::I,
            Isotope::I113 => Element::I,
            Isotope::I114 => Element::I,
            Isotope::I115 => Element::I,
            Isotope::I116 => Element::I,
            Isotope::I117 => Element::I,
            Isotope::I118 => Element::I,
            Isotope::I119 => Element::I,
            Isotope::I120 => Element::I,
            Isotope::I121 => Element::I,
            Isotope::I122 => Element::I,
            Isotope::I123 => Element::I,
            Isotope::I124 => Element::I,
            Isotope::I125 => Element::I,
            Isotope::I126 => Element::I,
            Isotope::I127 => Element::I,
            Isotope::I128 => Element::I,
            Isotope::I129 => Element::I,
            Isotope::I130 => Element::I,
            Isotope::I131 => Element::I,
            Isotope::I132 => Element::I,
            Isotope::I133 => Element::I,
            Isotope::I134 => Element::I,
            Isotope::I135 => Element::I,
            Isotope::I136 => Element::I,
            Isotope::I137 => Element::I,
            Isotope::I138 => Element::I,
            Isotope::I139 => Element::I,
            Isotope::I140 => Element::I,
            Isotope::I141 => Element::I,
            Isotope::I142 => Element::I,
            Isotope::I143 => Element::I,
            Isotope::I144 => Element::I,
            Isotope::I145 => Element::I,
            Isotope::I146 => Element::I,
            Isotope::I147 => Element::I,
            Isotope::Xe108 => Element::Xe,
            Isotope::Xe109 => Element::Xe,
            Isotope::Xe110 => Element::Xe,
            Isotope::Xe111 => Element::Xe,
            Isotope::Xe112 => Element::Xe,
            Isotope::Xe113 => Element::Xe,
            Isotope::Xe114 => Element::Xe,
            Isotope::Xe115 => Element::Xe,
            Isotope::Xe116 => Element::Xe,
            Isotope::Xe117 => Element::Xe,
            Isotope::Xe118 => Element::Xe,
            Isotope::Xe119 => Element::Xe,
            Isotope::Xe120 => Element::Xe,
            Isotope::Xe121 => Element::Xe,
            Isotope::Xe122 => Element::Xe,
            Isotope::Xe123 => Element::Xe,
            Isotope::Xe124 => Element::Xe,
            Isotope::Xe125 => Element::Xe,
            Isotope::Xe126 => Element::Xe,
            Isotope::Xe127 => Element::Xe,
            Isotope::Xe128 => Element::Xe,
            Isotope::Xe129 => Element::Xe,
            Isotope::Xe130 => Element::Xe,
            Isotope::Xe131 => Element::Xe,
            Isotope::Xe132 => Element::Xe,
            Isotope::Xe133 => Element::Xe,
            Isotope::Xe134 => Element::Xe,
            Isotope::Xe135 => Element::Xe,
            Isotope::Xe136 => Element::Xe,
            Isotope::Xe137 => Element::Xe,
            Isotope::Xe138 => Element::Xe,
            Isotope::Xe139 => Element::Xe,
            Isotope::Xe140 => Element::Xe,
            Isotope::Xe141 => Element::Xe,
            Isotope::Xe142 => Element::Xe,
            Isotope::Xe143 => Element::Xe,
            Isotope::Xe144 => Element::Xe,
            Isotope::Xe145 => Element::Xe,
            Isotope::Xe146 => Element::Xe,
            Isotope::Xe147 => Element::Xe,
            Isotope::Xe148 => Element::Xe,
            Isotope::Xe149 => Element::Xe,
            Isotope::Xe150 => Element::Xe,
            Isotope::Cs111 => Element::Cs,
            Isotope::Cs112 => Element::Cs,
            Isotope::Cs113 => Element::Cs,
            Isotope::Cs114 => Element::Cs,
            Isotope::Cs115 => Element::Cs,
            Isotope::Cs116 => Element::Cs,
            Isotope::Cs117 => Element::Cs,
            Isotope::Cs118 => Element::Cs,
            Isotope::Cs119 => Element::Cs,
            Isotope::Cs120 => Element::Cs,
            Isotope::Cs121 => Element::Cs,
            Isotope::Cs122 => Element::Cs,
            Isotope::Cs123 => Element::Cs,
            Isotope::Cs124 => Element::Cs,
            Isotope::Cs125 => Element::Cs,
            Isotope::Cs126 => Element::Cs,
            Isotope::Cs127 => Element::Cs,
            Isotope::Cs128 => Element::Cs,
            Isotope::Cs129 => Element::Cs,
            Isotope::Cs130 => Element::Cs,
            Isotope::Cs131 => Element::Cs,
            Isotope::Cs132 => Element::Cs,
            Isotope::Cs133 => Element::Cs,
            Isotope::Cs134 => Element::Cs,
            Isotope::Cs135 => Element::Cs,
            Isotope::Cs136 => Element::Cs,
            Isotope::Cs137 => Element::Cs,
            Isotope::Cs138 => Element::Cs,
            Isotope::Cs139 => Element::Cs,
            Isotope::Cs140 => Element::Cs,
            Isotope::Cs141 => Element::Cs,
            Isotope::Cs142 => Element::Cs,
            Isotope::Cs143 => Element::Cs,
            Isotope::Cs144 => Element::Cs,
            Isotope::Cs145 => Element::Cs,
            Isotope::Cs146 => Element::Cs,
            Isotope::Cs147 => Element::Cs,
            Isotope::Cs148 => Element::Cs,
            Isotope::Cs149 => Element::Cs,
            Isotope::Cs150 => Element::Cs,
            Isotope::Cs151 => Element::Cs,
            Isotope::Cs152 => Element::Cs,
            Isotope::Ba113 => Element::Ba,
            Isotope::Ba114 => Element::Ba,
            Isotope::Ba115 => Element::Ba,
            Isotope::Ba116 => Element::Ba,
            Isotope::Ba117 => Element::Ba,
            Isotope::Ba118 => Element::Ba,
            Isotope::Ba119 => Element::Ba,
            Isotope::Ba120 => Element::Ba,
            Isotope::Ba121 => Element::Ba,
            Isotope::Ba122 => Element::Ba,
            Isotope::Ba123 => Element::Ba,
            Isotope::Ba124 => Element::Ba,
            Isotope::Ba125 => Element::Ba,
            Isotope::Ba126 => Element::Ba,
            Isotope::Ba127 => Element::Ba,
            Isotope::Ba128 => Element::Ba,
            Isotope::Ba129 => Element::Ba,
            Isotope::Ba130 => Element::Ba,
            Isotope::Ba131 => Element::Ba,
            Isotope::Ba132 => Element::Ba,
            Isotope::Ba133 => Element::Ba,
            Isotope::Ba134 => Element::Ba,
            Isotope::Ba135 => Element::Ba,
            Isotope::Ba136 => Element::Ba,
            Isotope::Ba137 => Element::Ba,
            Isotope::Ba138 => Element::Ba,
            Isotope::Ba139 => Element::Ba,
            Isotope::Ba140 => Element::Ba,
            Isotope::Ba141 => Element::Ba,
            Isotope::Ba142 => Element::Ba,
            Isotope::Ba143 => Element::Ba,
            Isotope::Ba144 => Element::Ba,
            Isotope::Ba145 => Element::Ba,
            Isotope::Ba146 => Element::Ba,
            Isotope::Ba147 => Element::Ba,
            Isotope::Ba148 => Element::Ba,
            Isotope::Ba149 => Element::Ba,
            Isotope::Ba150 => Element::Ba,
            Isotope::Ba151 => Element::Ba,
            Isotope::Ba152 => Element::Ba,
            Isotope::Ba153 => Element::Ba,
            Isotope::Ba154 => Element::Ba,
            Isotope::La116 => Element::La,
            Isotope::La117 => Element::La,
            Isotope::La118 => Element::La,
            Isotope::La119 => Element::La,
            Isotope::La120 => Element::La,
            Isotope::La121 => Element::La,
            Isotope::La122 => Element::La,
            Isotope::La123 => Element::La,
            Isotope::La124 => Element::La,
            Isotope::La125 => Element::La,
            Isotope::La126 => Element::La,
            Isotope::La127 => Element::La,
            Isotope::La128 => Element::La,
            Isotope::La129 => Element::La,
            Isotope::La130 => Element::La,
            Isotope::La131 => Element::La,
            Isotope::La132 => Element::La,
            Isotope::La133 => Element::La,
            Isotope::La134 => Element::La,
            Isotope::La135 => Element::La,
            Isotope::La136 => Element::La,
            Isotope::La137 => Element::La,
            Isotope::La138 => Element::La,
            Isotope::La139 => Element::La,
            Isotope::La140 => Element::La,
            Isotope::La141 => Element::La,
            Isotope::La142 => Element::La,
            Isotope::La143 => Element::La,
            Isotope::La144 => Element::La,
            Isotope::La145 => Element::La,
            Isotope::La146 => Element::La,
            Isotope::La147 => Element::La,
            Isotope::La148 => Element::La,
            Isotope::La149 => Element::La,
            Isotope::La150 => Element::La,
            Isotope::La151 => Element::La,
            Isotope::La152 => Element::La,
            Isotope::La153 => Element::La,
            Isotope::La154 => Element::La,
            Isotope::La155 => Element::La,
            Isotope::La156 => Element::La,
            Isotope::La157 => Element::La,
            Isotope::Ce119 => Element::Ce,
            Isotope::Ce120 => Element::Ce,
            Isotope::Ce121 => Element::Ce,
            Isotope::Ce122 => Element::Ce,
            Isotope::Ce123 => Element::Ce,
            Isotope::Ce124 => Element::Ce,
            Isotope::Ce125 => Element::Ce,
            Isotope::Ce126 => Element::Ce,
            Isotope::Ce127 => Element::Ce,
            Isotope::Ce128 => Element::Ce,
            Isotope::Ce129 => Element::Ce,
            Isotope::Ce130 => Element::Ce,
            Isotope::Ce131 => Element::Ce,
            Isotope::Ce132 => Element::Ce,
            Isotope::Ce133 => Element::Ce,
            Isotope::Ce134 => Element::Ce,
            Isotope::Ce135 => Element::Ce,
            Isotope::Ce136 => Element::Ce,
            Isotope::Ce137 => Element::Ce,
            Isotope::Ce138 => Element::Ce,
            Isotope::Ce139 => Element::Ce,
            Isotope::Ce140 => Element::Ce,
            Isotope::Ce141 => Element::Ce,
            Isotope::Ce142 => Element::Ce,
            Isotope::Ce143 => Element::Ce,
            Isotope::Ce144 => Element::Ce,
            Isotope::Ce145 => Element::Ce,
            Isotope::Ce146 => Element::Ce,
            Isotope::Ce147 => Element::Ce,
            Isotope::Ce148 => Element::Ce,
            Isotope::Ce149 => Element::Ce,
            Isotope::Ce150 => Element::Ce,
            Isotope::Ce151 => Element::Ce,
            Isotope::Ce152 => Element::Ce,
            Isotope::Ce153 => Element::Ce,
            Isotope::Ce154 => Element::Ce,
            Isotope::Ce155 => Element::Ce,
            Isotope::Ce156 => Element::Ce,
            Isotope::Ce157 => Element::Ce,
            Isotope::Ce158 => Element::Ce,
            Isotope::Ce159 => Element::Ce,
            Isotope::Pr121 => Element::Pr,
            Isotope::Pr122 => Element::Pr,
            Isotope::Pr123 => Element::Pr,
            Isotope::Pr124 => Element::Pr,
            Isotope::Pr125 => Element::Pr,
            Isotope::Pr126 => Element::Pr,
            Isotope::Pr127 => Element::Pr,
            Isotope::Pr128 => Element::Pr,
            Isotope::Pr129 => Element::Pr,
            Isotope::Pr130 => Element::Pr,
            Isotope::Pr131 => Element::Pr,
            Isotope::Pr132 => Element::Pr,
            Isotope::Pr133 => Element::Pr,
            Isotope::Pr134 => Element::Pr,
            Isotope::Pr135 => Element::Pr,
            Isotope::Pr136 => Element::Pr,
            Isotope::Pr137 => Element::Pr,
            Isotope::Pr138 => Element::Pr,
            Isotope::Pr139 => Element::Pr,
            Isotope::Pr140 => Element::Pr,
            Isotope::Pr141 => Element::Pr,
            Isotope::Pr142 => Element::Pr,
            Isotope::Pr143 => Element::Pr,
            Isotope::Pr144 => Element::Pr,
            Isotope::Pr145 => Element::Pr,
            Isotope::Pr146 => Element::Pr,
            Isotope::Pr147 => Element::Pr,
            Isotope::Pr148 => Element::Pr,
            Isotope::Pr149 => Element::Pr,
            Isotope::Pr150 => Element::Pr,
            Isotope::Pr151 => Element::Pr,
            Isotope::Pr152 => Element::Pr,
            Isotope::Pr153 => Element::Pr,
            Isotope::Pr154 => Element::Pr,
            Isotope::Pr155 => Element::Pr,
            Isotope::Pr156 => Element::Pr,
            Isotope::Pr157 => Element::Pr,
            Isotope::Pr158 => Element::Pr,
            Isotope::Pr159 => Element::Pr,
            Isotope::Pr160 => Element::Pr,
            Isotope::Pr161 => Element::Pr,
            Isotope::Nd124 => Element::Nd,
            Isotope::Nd125 => Element::Nd,
            Isotope::Nd126 => Element::Nd,
            Isotope::Nd127 => Element::Nd,
            Isotope::Nd128 => Element::Nd,
            Isotope::Nd129 => Element::Nd,
            Isotope::Nd130 => Element::Nd,
            Isotope::Nd131 => Element::Nd,
            Isotope::Nd132 => Element::Nd,
            Isotope::Nd133 => Element::Nd,
            Isotope::Nd134 => Element::Nd,
            Isotope::Nd135 => Element::Nd,
            Isotope::Nd136 => Element::Nd,
            Isotope::Nd137 => Element::Nd,
            Isotope::Nd138 => Element::Nd,
            Isotope::Nd139 => Element::Nd,
            Isotope::Nd140 => Element::Nd,
            Isotope::Nd141 => Element::Nd,
            Isotope::Nd142 => Element::Nd,
            Isotope::Nd143 => Element::Nd,
            Isotope::Nd144 => Element::Nd,
            Isotope::Nd145 => Element::Nd,
            Isotope::Nd146 => Element::Nd,
            Isotope::Nd147 => Element::Nd,
            Isotope::Nd148 => Element::Nd,
            Isotope::Nd149 => Element::Nd,
            Isotope::Nd150 => Element::Nd,
            Isotope::Nd151 => Element::Nd,
            Isotope::Nd152 => Element::Nd,
            Isotope::Nd153 => Element::Nd,
            Isotope::Nd154 => Element::Nd,
            Isotope::Nd155 => Element::Nd,
            Isotope::Nd156 => Element::Nd,
            Isotope::Nd157 => Element::Nd,
            Isotope::Nd158 => Element::Nd,
            Isotope::Nd159 => Element::Nd,
            Isotope::Nd160 => Element::Nd,
            Isotope::Nd161 => Element::Nd,
            Isotope::Nd162 => Element::Nd,
            Isotope::Nd163 => Element::Nd,
            Isotope::Pm126 => Element::Pm,
            Isotope::Pm127 => Element::Pm,
            Isotope::Pm128 => Element::Pm,
            Isotope::Pm129 => Element::Pm,
            Isotope::Pm130 => Element::Pm,
            Isotope::Pm131 => Element::Pm,
            Isotope::Pm132 => Element::Pm,
            Isotope::Pm133 => Element::Pm,
            Isotope::Pm134 => Element::Pm,
            Isotope::Pm135 => Element::Pm,
            Isotope::Pm136 => Element::Pm,
            Isotope::Pm137 => Element::Pm,
            Isotope::Pm138 => Element::Pm,
            Isotope::Pm139 => Element::Pm,
            Isotope::Pm140 => Element::Pm,
            Isotope::Pm141 => Element::Pm,
            Isotope::Pm142 => Element::Pm,
            Isotope::Pm143 => Element::Pm,
            Isotope::Pm144 => Element::Pm,
            Isotope::Pm145 => Element::Pm,
            Isotope::Pm146 => Element::Pm,
            Isotope::Pm147 => Element::Pm,
            Isotope::Pm148 => Element::Pm,
            Isotope::Pm149 => Element::Pm,
            Isotope::Pm150 => Element::Pm,
            Isotope::Pm151 => Element::Pm,
            Isotope::Pm152 => Element::Pm,
            Isotope::Pm153 => Element::Pm,
            Isotope::Pm154 => Element::Pm,
            Isotope::Pm155 => Element::Pm,
            Isotope::Pm156 => Element::Pm,
            Isotope::Pm157 => Element::Pm,
            Isotope::Pm158 => Element::Pm,
            Isotope::Pm159 => Element::Pm,
            Isotope::Pm160 => Element::Pm,
            Isotope::Pm161 => Element::Pm,
            Isotope::Pm162 => Element::Pm,
            Isotope::Pm163 => Element::Pm,
            Isotope::Pm164 => Element::Pm,
            Isotope::Pm165 => Element::Pm,
            Isotope::Sm128 => Element::Sm,
            Isotope::Sm129 => Element::Sm,
            Isotope::Sm130 => Element::Sm,
            Isotope::Sm131 => Element::Sm,
            Isotope::Sm132 => Element::Sm,
            Isotope::Sm133 => Element::Sm,
            Isotope::Sm134 => Element::Sm,
            Isotope::Sm135 => Element::Sm,
            Isotope::Sm136 => Element::Sm,
            Isotope::Sm137 => Element::Sm,
            Isotope::Sm138 => Element::Sm,
            Isotope::Sm139 => Element::Sm,
            Isotope::Sm140 => Element::Sm,
            Isotope::Sm141 => Element::Sm,
            Isotope::Sm142 => Element::Sm,
            Isotope::Sm143 => Element::Sm,
            Isotope::Sm144 => Element::Sm,
            Isotope::Sm145 => Element::Sm,
            Isotope::Sm146 => Element::Sm,
            Isotope::Sm147 => Element::Sm,
            Isotope::Sm148 => Element::Sm,
            Isotope::Sm149 => Element::Sm,
            Isotope::Sm150 => Element::Sm,
            Isotope::Sm151 => Element::Sm,
            Isotope::Sm152 => Element::Sm,
            Isotope::Sm153 => Element::Sm,
            Isotope::Sm154 => Element::Sm,
            Isotope::Sm155 => Element::Sm,
            Isotope::Sm156 => Element::Sm,
            Isotope::Sm157 => Element::Sm,
            Isotope::Sm158 => Element::Sm,
            Isotope::Sm159 => Element::Sm,
            Isotope::Sm160 => Element::Sm,
            Isotope::Sm161 => Element::Sm,
            Isotope::Sm162 => Element::Sm,
            Isotope::Sm163 => Element::Sm,
            Isotope::Sm164 => Element::Sm,
            Isotope::Sm165 => Element::Sm,
            Isotope::Sm166 => Element::Sm,
            Isotope::Sm167 => Element::Sm,
            Isotope::Sm168 => Element::Sm,
            Isotope::Eu130 => Element::Eu,
            Isotope::Eu131 => Element::Eu,
            Isotope::Eu132 => Element::Eu,
            Isotope::Eu133 => Element::Eu,
            Isotope::Eu134 => Element::Eu,
            Isotope::Eu135 => Element::Eu,
            Isotope::Eu136 => Element::Eu,
            Isotope::Eu137 => Element::Eu,
            Isotope::Eu138 => Element::Eu,
            Isotope::Eu139 => Element::Eu,
            Isotope::Eu140 => Element::Eu,
            Isotope::Eu141 => Element::Eu,
            Isotope::Eu142 => Element::Eu,
            Isotope::Eu143 => Element::Eu,
            Isotope::Eu144 => Element::Eu,
            Isotope::Eu145 => Element::Eu,
            Isotope::Eu146 => Element::Eu,
            Isotope::Eu147 => Element::Eu,
            Isotope::Eu148 => Element::Eu,
            Isotope::Eu149 => Element::Eu,
            Isotope::Eu150 => Element::Eu,
            Isotope::Eu151 => Element::Eu,
            Isotope::Eu152 => Element::Eu,
            Isotope::Eu153 => Element::Eu,
            Isotope::Eu154 => Element::Eu,
            Isotope::Eu155 => Element::Eu,
            Isotope::Eu156 => Element::Eu,
            Isotope::Eu157 => Element::Eu,
            Isotope::Eu158 => Element::Eu,
            Isotope::Eu159 => Element::Eu,
            Isotope::Eu160 => Element::Eu,
            Isotope::Eu161 => Element::Eu,
            Isotope::Eu162 => Element::Eu,
            Isotope::Eu163 => Element::Eu,
            Isotope::Eu164 => Element::Eu,
            Isotope::Eu165 => Element::Eu,
            Isotope::Eu166 => Element::Eu,
            Isotope::Eu167 => Element::Eu,
            Isotope::Eu168 => Element::Eu,
            Isotope::Eu169 => Element::Eu,
            Isotope::Eu170 => Element::Eu,
            Isotope::Gd133 => Element::Gd,
            Isotope::Gd134 => Element::Gd,
            Isotope::Gd135 => Element::Gd,
            Isotope::Gd136 => Element::Gd,
            Isotope::Gd137 => Element::Gd,
            Isotope::Gd138 => Element::Gd,
            Isotope::Gd139 => Element::Gd,
            Isotope::Gd140 => Element::Gd,
            Isotope::Gd141 => Element::Gd,
            Isotope::Gd142 => Element::Gd,
            Isotope::Gd143 => Element::Gd,
            Isotope::Gd144 => Element::Gd,
            Isotope::Gd145 => Element::Gd,
            Isotope::Gd146 => Element::Gd,
            Isotope::Gd147 => Element::Gd,
            Isotope::Gd148 => Element::Gd,
            Isotope::Gd149 => Element::Gd,
            Isotope::Gd150 => Element::Gd,
            Isotope::Gd151 => Element::Gd,
            Isotope::Gd152 => Element::Gd,
            Isotope::Gd153 => Element::Gd,
            Isotope::Gd154 => Element::Gd,
            Isotope::Gd155 => Element::Gd,
            Isotope::Gd156 => Element::Gd,
            Isotope::Gd157 => Element::Gd,
            Isotope::Gd158 => Element::Gd,
            Isotope::Gd159 => Element::Gd,
            Isotope::Gd160 => Element::Gd,
            Isotope::Gd161 => Element::Gd,
            Isotope::Gd162 => Element::Gd,
            Isotope::Gd163 => Element::Gd,
            Isotope::Gd164 => Element::Gd,
            Isotope::Gd165 => Element::Gd,
            Isotope::Gd166 => Element::Gd,
            Isotope::Gd167 => Element::Gd,
            Isotope::Gd168 => Element::Gd,
            Isotope::Gd169 => Element::Gd,
            Isotope::Gd170 => Element::Gd,
            Isotope::Gd171 => Element::Gd,
            Isotope::Gd172 => Element::Gd,
            Isotope::Tb135 => Element::Tb,
            Isotope::Tb136 => Element::Tb,
            Isotope::Tb137 => Element::Tb,
            Isotope::Tb138 => Element::Tb,
            Isotope::Tb139 => Element::Tb,
            Isotope::Tb140 => Element::Tb,
            Isotope::Tb141 => Element::Tb,
            Isotope::Tb142 => Element::Tb,
            Isotope::Tb143 => Element::Tb,
            Isotope::Tb144 => Element::Tb,
            Isotope::Tb145 => Element::Tb,
            Isotope::Tb146 => Element::Tb,
            Isotope::Tb147 => Element::Tb,
            Isotope::Tb148 => Element::Tb,
            Isotope::Tb149 => Element::Tb,
            Isotope::Tb150 => Element::Tb,
            Isotope::Tb151 => Element::Tb,
            Isotope::Tb152 => Element::Tb,
            Isotope::Tb153 => Element::Tb,
            Isotope::Tb154 => Element::Tb,
            Isotope::Tb155 => Element::Tb,
            Isotope::Tb156 => Element::Tb,
            Isotope::Tb157 => Element::Tb,
            Isotope::Tb158 => Element::Tb,
            Isotope::Tb159 => Element::Tb,
            Isotope::Tb160 => Element::Tb,
            Isotope::Tb161 => Element::Tb,
            Isotope::Tb162 => Element::Tb,
            Isotope::Tb163 => Element::Tb,
            Isotope::Tb164 => Element::Tb,
            Isotope::Tb165 => Element::Tb,
            Isotope::Tb166 => Element::Tb,
            Isotope::Tb167 => Element::Tb,
            Isotope::Tb168 => Element::Tb,
            Isotope::Tb169 => Element::Tb,
            Isotope::Tb170 => Element::Tb,
            Isotope::Tb171 => Element::Tb,
            Isotope::Tb172 => Element::Tb,
            Isotope::Tb173 => Element::Tb,
            Isotope::Tb174 => Element::Tb,
            Isotope::Dy138 => Element::Dy,
            Isotope::Dy139 => Element::Dy,
            Isotope::Dy140 => Element::Dy,
            Isotope::Dy141 => Element::Dy,
            Isotope::Dy142 => Element::Dy,
            Isotope::Dy143 => Element::Dy,
            Isotope::Dy144 => Element::Dy,
            Isotope::Dy145 => Element::Dy,
            Isotope::Dy146 => Element::Dy,
            Isotope::Dy147 => Element::Dy,
            Isotope::Dy148 => Element::Dy,
            Isotope::Dy149 => Element::Dy,
            Isotope::Dy150 => Element::Dy,
            Isotope::Dy151 => Element::Dy,
            Isotope::Dy152 => Element::Dy,
            Isotope::Dy153 => Element::Dy,
            Isotope::Dy154 => Element::Dy,
            Isotope::Dy155 => Element::Dy,
            Isotope::Dy156 => Element::Dy,
            Isotope::Dy157 => Element::Dy,
            Isotope::Dy158 => Element::Dy,
            Isotope::Dy159 => Element::Dy,
            Isotope::Dy160 => Element::Dy,
            Isotope::Dy161 => Element::Dy,
            Isotope::Dy162 => Element::Dy,
            Isotope::Dy163 => Element::Dy,
            Isotope::Dy164 => Element::Dy,
            Isotope::Dy165 => Element::Dy,
            Isotope::Dy166 => Element::Dy,
            Isotope::Dy167 => Element::Dy,
            Isotope::Dy168 => Element::Dy,
            Isotope::Dy169 => Element::Dy,
            Isotope::Dy170 => Element::Dy,
            Isotope::Dy171 => Element::Dy,
            Isotope::Dy172 => Element::Dy,
            Isotope::Dy173 => Element::Dy,
            Isotope::Dy174 => Element::Dy,
            Isotope::Dy175 => Element::Dy,
            Isotope::Dy176 => Element::Dy,
            Isotope::Ho140 => Element::Ho,
            Isotope::Ho141 => Element::Ho,
            Isotope::Ho142 => Element::Ho,
            Isotope::Ho143 => Element::Ho,
            Isotope::Ho144 => Element::Ho,
            Isotope::Ho145 => Element::Ho,
            Isotope::Ho146 => Element::Ho,
            Isotope::Ho147 => Element::Ho,
            Isotope::Ho148 => Element::Ho,
            Isotope::Ho149 => Element::Ho,
            Isotope::Ho150 => Element::Ho,
            Isotope::Ho151 => Element::Ho,
            Isotope::Ho152 => Element::Ho,
            Isotope::Ho153 => Element::Ho,
            Isotope::Ho154 => Element::Ho,
            Isotope::Ho155 => Element::Ho,
            Isotope::Ho156 => Element::Ho,
            Isotope::Ho157 => Element::Ho,
            Isotope::Ho158 => Element::Ho,
            Isotope::Ho159 => Element::Ho,
            Isotope::Ho160 => Element::Ho,
            Isotope::Ho161 => Element::Ho,
            Isotope::Ho162 => Element::Ho,
            Isotope::Ho163 => Element::Ho,
            Isotope::Ho164 => Element::Ho,
            Isotope::Ho165 => Element::Ho,
            Isotope::Ho166 => Element::Ho,
            Isotope::Ho167 => Element::Ho,
            Isotope::Ho168 => Element::Ho,
            Isotope::Ho169 => Element::Ho,
            Isotope::Ho170 => Element::Ho,
            Isotope::Ho171 => Element::Ho,
            Isotope::Ho172 => Element::Ho,
            Isotope::Ho173 => Element::Ho,
            Isotope::Ho174 => Element::Ho,
            Isotope::Ho175 => Element::Ho,
            Isotope::Ho176 => Element::Ho,
            Isotope::Ho177 => Element::Ho,
            Isotope::Ho178 => Element::Ho,
            Isotope::Er142 => Element::Er,
            Isotope::Er143 => Element::Er,
            Isotope::Er144 => Element::Er,
            Isotope::Er145 => Element::Er,
            Isotope::Er146 => Element::Er,
            Isotope::Er147 => Element::Er,
            Isotope::Er148 => Element::Er,
            Isotope::Er149 => Element::Er,
            Isotope::Er150 => Element::Er,
            Isotope::Er151 => Element::Er,
            Isotope::Er152 => Element::Er,
            Isotope::Er153 => Element::Er,
            Isotope::Er154 => Element::Er,
            Isotope::Er155 => Element::Er,
            Isotope::Er156 => Element::Er,
            Isotope::Er157 => Element::Er,
            Isotope::Er158 => Element::Er,
            Isotope::Er159 => Element::Er,
            Isotope::Er160 => Element::Er,
            Isotope::Er161 => Element::Er,
            Isotope::Er162 => Element::Er,
            Isotope::Er163 => Element::Er,
            Isotope::Er164 => Element::Er,
            Isotope::Er165 => Element::Er,
            Isotope::Er166 => Element::Er,
            Isotope::Er167 => Element::Er,
            Isotope::Er168 => Element::Er,
            Isotope::Er169 => Element::Er,
            Isotope::Er170 => Element::Er,
            Isotope::Er171 => Element::Er,
            Isotope::Er172 => Element::Er,
            Isotope::Er173 => Element::Er,
            Isotope::Er174 => Element::Er,
            Isotope::Er175 => Element::Er,
            Isotope::Er176 => Element::Er,
            Isotope::Er177 => Element::Er,
            Isotope::Er178 => Element::Er,
            Isotope::Er179 => Element::Er,
            Isotope::Er180 => Element::Er,
            Isotope::Tm144 => Element::Tm,
            Isotope::Tm145 => Element::Tm,
            Isotope::Tm146 => Element::Tm,
            Isotope::Tm147 => Element::Tm,
            Isotope::Tm148 => Element::Tm,
            Isotope::Tm149 => Element::Tm,
            Isotope::Tm150 => Element::Tm,
            Isotope::Tm151 => Element::Tm,
            Isotope::Tm152 => Element::Tm,
            Isotope::Tm153 => Element::Tm,
            Isotope::Tm154 => Element::Tm,
            Isotope::Tm155 => Element::Tm,
            Isotope::Tm156 => Element::Tm,
            Isotope::Tm157 => Element::Tm,
            Isotope::Tm158 => Element::Tm,
            Isotope::Tm159 => Element::Tm,
            Isotope::Tm160 => Element::Tm,
            Isotope::Tm161 => Element::Tm,
            Isotope::Tm162 => Element::Tm,
            Isotope::Tm163 => Element::Tm,
            Isotope::Tm164 => Element::Tm,
            Isotope::Tm165 => Element::Tm,
            Isotope::Tm166 => Element::Tm,
            Isotope::Tm167 => Element::Tm,
            Isotope::Tm168 => Element::Tm,
            Isotope::Tm169 => Element::Tm,
            Isotope::Tm170 => Element::Tm,
            Isotope::Tm171 => Element::Tm,
            Isotope::Tm172 => Element::Tm,
            Isotope::Tm173 => Element::Tm,
            Isotope::Tm174 => Element::Tm,
            Isotope::Tm175 => Element::Tm,
            Isotope::Tm176 => Element::Tm,
            Isotope::Tm177 => Element::Tm,
            Isotope::Tm178 => Element::Tm,
            Isotope::Tm179 => Element::Tm,
            Isotope::Tm180 => Element::Tm,
            Isotope::Tm181 => Element::Tm,
            Isotope::Tm182 => Element::Tm,
            Isotope::Yb148 => Element::Yb,
            Isotope::Yb149 => Element::Yb,
            Isotope::Yb150 => Element::Yb,
            Isotope::Yb151 => Element::Yb,
            Isotope::Yb152 => Element::Yb,
            Isotope::Yb153 => Element::Yb,
            Isotope::Yb154 => Element::Yb,
            Isotope::Yb155 => Element::Yb,
            Isotope::Yb156 => Element::Yb,
            Isotope::Yb157 => Element::Yb,
            Isotope::Yb158 => Element::Yb,
            Isotope::Yb159 => Element::Yb,
            Isotope::Yb160 => Element::Yb,
            Isotope::Yb161 => Element::Yb,
            Isotope::Yb162 => Element::Yb,
            Isotope::Yb163 => Element::Yb,
            Isotope::Yb164 => Element::Yb,
            Isotope::Yb165 => Element::Yb,
            Isotope::Yb166 => Element::Yb,
            Isotope::Yb167 => Element::Yb,
            Isotope::Yb168 => Element::Yb,
            Isotope::Yb169 => Element::Yb,
            Isotope::Yb170 => Element::Yb,
            Isotope::Yb171 => Element::Yb,
            Isotope::Yb172 => Element::Yb,
            Isotope::Yb173 => Element::Yb,
            Isotope::Yb174 => Element::Yb,
            Isotope::Yb175 => Element::Yb,
            Isotope::Yb176 => Element::Yb,
            Isotope::Yb177 => Element::Yb,
            Isotope::Yb178 => Element::Yb,
            Isotope::Yb179 => Element::Yb,
            Isotope::Yb180 => Element::Yb,
            Isotope::Yb181 => Element::Yb,
            Isotope::Yb182 => Element::Yb,
            Isotope::Yb183 => Element::Yb,
            Isotope::Yb184 => Element::Yb,
            Isotope::Yb185 => Element::Yb,
            Isotope::Lu150 => Element::Lu,
            Isotope::Lu151 => Element::Lu,
            Isotope::Lu152 => Element::Lu,
            Isotope::Lu153 => Element::Lu,
            Isotope::Lu154 => Element::Lu,
            Isotope::Lu155 => Element::Lu,
            Isotope::Lu156 => Element::Lu,
            Isotope::Lu157 => Element::Lu,
            Isotope::Lu158 => Element::Lu,
            Isotope::Lu159 => Element::Lu,
            Isotope::Lu160 => Element::Lu,
            Isotope::Lu161 => Element::Lu,
            Isotope::Lu162 => Element::Lu,
            Isotope::Lu163 => Element::Lu,
            Isotope::Lu164 => Element::Lu,
            Isotope::Lu165 => Element::Lu,
            Isotope::Lu166 => Element::Lu,
            Isotope::Lu167 => Element::Lu,
            Isotope::Lu168 => Element::Lu,
            Isotope::Lu169 => Element::Lu,
            Isotope::Lu170 => Element::Lu,
            Isotope::Lu171 => Element::Lu,
            Isotope::Lu172 => Element::Lu,
            Isotope::Lu173 => Element::Lu,
            Isotope::Lu174 => Element::Lu,
            Isotope::Lu175 => Element::Lu,
            Isotope::Lu176 => Element::Lu,
            Isotope::Lu177 => Element::Lu,
            Isotope::Lu178 => Element::Lu,
            Isotope::Lu179 => Element::Lu,
            Isotope::Lu180 => Element::Lu,
            Isotope::Lu181 => Element::Lu,
            Isotope::Lu182 => Element::Lu,
            Isotope::Lu183 => Element::Lu,
            Isotope::Lu184 => Element::Lu,
            Isotope::Lu185 => Element::Lu,
            Isotope::Lu186 => Element::Lu,
            Isotope::Lu187 => Element::Lu,
            Isotope::Lu188 => Element::Lu,
            Isotope::Hf153 => Element::Hf,
            Isotope::Hf154 => Element::Hf,
            Isotope::Hf155 => Element::Hf,
            Isotope::Hf156 => Element::Hf,
            Isotope::Hf157 => Element::Hf,
            Isotope::Hf158 => Element::Hf,
            Isotope::Hf159 => Element::Hf,
            Isotope::Hf160 => Element::Hf,
            Isotope::Hf161 => Element::Hf,
            Isotope::Hf162 => Element::Hf,
            Isotope::Hf163 => Element::Hf,
            Isotope::Hf164 => Element::Hf,
            Isotope::Hf165 => Element::Hf,
            Isotope::Hf166 => Element::Hf,
            Isotope::Hf167 => Element::Hf,
            Isotope::Hf168 => Element::Hf,
            Isotope::Hf169 => Element::Hf,
            Isotope::Hf170 => Element::Hf,
            Isotope::Hf171 => Element::Hf,
            Isotope::Hf172 => Element::Hf,
            Isotope::Hf173 => Element::Hf,
            Isotope::Hf174 => Element::Hf,
            Isotope::Hf175 => Element::Hf,
            Isotope::Hf176 => Element::Hf,
            Isotope::Hf177 => Element::Hf,
            Isotope::Hf178 => Element::Hf,
            Isotope::Hf179 => Element::Hf,
            Isotope::Hf180 => Element::Hf,
            Isotope::Hf181 => Element::Hf,
            Isotope::Hf182 => Element::Hf,
            Isotope::Hf183 => Element::Hf,
            Isotope::Hf184 => Element::Hf,
            Isotope::Hf185 => Element::Hf,
            Isotope::Hf186 => Element::Hf,
            Isotope::Hf187 => Element::Hf,
            Isotope::Hf188 => Element::Hf,
            Isotope::Hf189 => Element::Hf,
            Isotope::Hf190 => Element::Hf,
            Isotope::Ta155 => Element::Ta,
            Isotope::Ta156 => Element::Ta,
            Isotope::Ta157 => Element::Ta,
            Isotope::Ta158 => Element::Ta,
            Isotope::Ta159 => Element::Ta,
            Isotope::Ta160 => Element::Ta,
            Isotope::Ta161 => Element::Ta,
            Isotope::Ta162 => Element::Ta,
            Isotope::Ta163 => Element::Ta,
            Isotope::Ta164 => Element::Ta,
            Isotope::Ta165 => Element::Ta,
            Isotope::Ta166 => Element::Ta,
            Isotope::Ta167 => Element::Ta,
            Isotope::Ta168 => Element::Ta,
            Isotope::Ta169 => Element::Ta,
            Isotope::Ta170 => Element::Ta,
            Isotope::Ta171 => Element::Ta,
            Isotope::Ta172 => Element::Ta,
            Isotope::Ta173 => Element::Ta,
            Isotope::Ta174 => Element::Ta,
            Isotope::Ta175 => Element::Ta,
            Isotope::Ta176 => Element::Ta,
            Isotope::Ta177 => Element::Ta,
            Isotope::Ta178 => Element::Ta,
            Isotope::Ta179 => Element::Ta,
            Isotope::Ta180 => Element::Ta,
            Isotope::Ta181 => Element::Ta,
            Isotope::Ta182 => Element::Ta,
            Isotope::Ta183 => Element::Ta,
            Isotope::Ta184 => Element::Ta,
            Isotope::Ta185 => Element::Ta,
            Isotope::Ta186 => Element::Ta,
            Isotope::Ta187 => Element::Ta,
            Isotope::Ta188 => Element::Ta,
            Isotope::Ta189 => Element::Ta,
            Isotope::Ta190 => Element::Ta,
            Isotope::Ta191 => Element::Ta,
            Isotope::Ta192 => Element::Ta,
            Isotope::Ta193 => Element::Ta,
            Isotope::Ta194 => Element::Ta,
            Isotope::W157 => Element::W,
            Isotope::W158 => Element::W,
            Isotope::W159 => Element::W,
            Isotope::W160 => Element::W,
            Isotope::W161 => Element::W,
            Isotope::W162 => Element::W,
            Isotope::W163 => Element::W,
            Isotope::W164 => Element::W,
            Isotope::W165 => Element::W,
            Isotope::W166 => Element::W,
            Isotope::W167 => Element::W,
            Isotope::W168 => Element::W,
            Isotope::W169 => Element::W,
            Isotope::W170 => Element::W,
            Isotope::W171 => Element::W,
            Isotope::W172 => Element::W,
            Isotope::W173 => Element::W,
            Isotope::W174 => Element::W,
            Isotope::W175 => Element::W,
            Isotope::W176 => Element::W,
            Isotope::W177 => Element::W,
            Isotope::W178 => Element::W,
            Isotope::W179 => Element::W,
            Isotope::W180 => Element::W,
            Isotope::W181 => Element::W,
            Isotope::W182 => Element::W,
            Isotope::W183 => Element::W,
            Isotope::W184 => Element::W,
            Isotope::W185 => Element::W,
            Isotope::W186 => Element::W,
            Isotope::W187 => Element::W,
            Isotope::W188 => Element::W,
            Isotope::W189 => Element::W,
            Isotope::W190 => Element::W,
            Isotope::W191 => Element::W,
            Isotope::W192 => Element::W,
            Isotope::W193 => Element::W,
            Isotope::W194 => Element::W,
            Isotope::W195 => Element::W,
            Isotope::W196 => Element::W,
            Isotope::W197 => Element::W,
            Isotope::Re159 => Element::Re,
            Isotope::Re160 => Element::Re,
            Isotope::Re161 => Element::Re,
            Isotope::Re162 => Element::Re,
            Isotope::Re163 => Element::Re,
            Isotope::Re164 => Element::Re,
            Isotope::Re165 => Element::Re,
            Isotope::Re166 => Element::Re,
            Isotope::Re167 => Element::Re,
            Isotope::Re168 => Element::Re,
            Isotope::Re169 => Element::Re,
            Isotope::Re170 => Element::Re,
            Isotope::Re171 => Element::Re,
            Isotope::Re172 => Element::Re,
            Isotope::Re173 => Element::Re,
            Isotope::Re174 => Element::Re,
            Isotope::Re175 => Element::Re,
            Isotope::Re176 => Element::Re,
            Isotope::Re177 => Element::Re,
            Isotope::Re178 => Element::Re,
            Isotope::Re179 => Element::Re,
            Isotope::Re180 => Element::Re,
            Isotope::Re181 => Element::Re,
            Isotope::Re182 => Element::Re,
            Isotope::Re183 => Element::Re,
            Isotope::Re184 => Element::Re,
            Isotope::Re185 => Element::Re,
            Isotope::Re186 => Element::Re,
            Isotope::Re187 => Element::Re,
            Isotope::Re188 => Element::Re,
            Isotope::Re189 => Element::Re,
            Isotope::Re190 => Element::Re,
            Isotope::Re191 => Element::Re,
            Isotope::Re192 => Element::Re,
            Isotope::Re193 => Element::Re,
            Isotope::Re194 => Element::Re,
            Isotope::Re195 => Element::Re,
            Isotope::Re196 => Element::Re,
            Isotope::Re197 => Element::Re,
            Isotope::Re198 => Element::Re,
            Isotope::Re199 => Element::Re,
            Isotope::Os161 => Element::Os,
            Isotope::Os162 => Element::Os,
            Isotope::Os163 => Element::Os,
            Isotope::Os164 => Element::Os,
            Isotope::Os165 => Element::Os,
            Isotope::Os166 => Element::Os,
            Isotope::Os167 => Element::Os,
            Isotope::Os168 => Element::Os,
            Isotope::Os169 => Element::Os,
            Isotope::Os170 => Element::Os,
            Isotope::Os171 => Element::Os,
            Isotope::Os172 => Element::Os,
            Isotope::Os173 => Element::Os,
            Isotope::Os174 => Element::Os,
            Isotope::Os175 => Element::Os,
            Isotope::Os176 => Element::Os,
            Isotope::Os177 => Element::Os,
            Isotope::Os178 => Element::Os,
            Isotope::Os179 => Element::Os,
            Isotope::Os180 => Element::Os,
            Isotope::Os181 => Element::Os,
            Isotope::Os182 => Element::Os,
            Isotope::Os183 => Element::Os,
            Isotope::Os184 => Element::Os,
            Isotope::Os185 => Element::Os,
            Isotope::Os186 => Element::Os,
            Isotope::Os187 => Element::Os,
            Isotope::Os188 => Element::Os,
            Isotope::Os189 => Element::Os,
            Isotope::Os190 => Element::Os,
            Isotope::Os191 => Element::Os,
            Isotope::Os192 => Element::Os,
            Isotope::Os193 => Element::Os,
            Isotope::Os194 => Element::Os,
            Isotope::Os195 => Element::Os,
            Isotope::Os196 => Element::Os,
            Isotope::Os197 => Element::Os,
            Isotope::Os198 => Element::Os,
            Isotope::Os199 => Element::Os,
            Isotope::Os200 => Element::Os,
            Isotope::Os201 => Element::Os,
            Isotope::Os202 => Element::Os,
            Isotope::Os203 => Element::Os,
            Isotope::Ir163 => Element::Ir,
            Isotope::Ir164 => Element::Ir,
            Isotope::Ir165 => Element::Ir,
            Isotope::Ir166 => Element::Ir,
            Isotope::Ir167 => Element::Ir,
            Isotope::Ir168 => Element::Ir,
            Isotope::Ir169 => Element::Ir,
            Isotope::Ir170 => Element::Ir,
            Isotope::Ir171 => Element::Ir,
            Isotope::Ir172 => Element::Ir,
            Isotope::Ir173 => Element::Ir,
            Isotope::Ir174 => Element::Ir,
            Isotope::Ir175 => Element::Ir,
            Isotope::Ir176 => Element::Ir,
            Isotope::Ir177 => Element::Ir,
            Isotope::Ir178 => Element::Ir,
            Isotope::Ir179 => Element::Ir,
            Isotope::Ir180 => Element::Ir,
            Isotope::Ir181 => Element::Ir,
            Isotope::Ir182 => Element::Ir,
            Isotope::Ir183 => Element::Ir,
            Isotope::Ir184 => Element::Ir,
            Isotope::Ir185 => Element::Ir,
            Isotope::Ir186 => Element::Ir,
            Isotope::Ir187 => Element::Ir,
            Isotope::Ir188 => Element::Ir,
            Isotope::Ir189 => Element::Ir,
            Isotope::Ir190 => Element::Ir,
            Isotope::Ir191 => Element::Ir,
            Isotope::Ir192 => Element::Ir,
            Isotope::Ir193 => Element::Ir,
            Isotope::Ir194 => Element::Ir,
            Isotope::Ir195 => Element::Ir,
            Isotope::Ir196 => Element::Ir,
            Isotope::Ir197 => Element::Ir,
            Isotope::Ir198 => Element::Ir,
            Isotope::Ir199 => Element::Ir,
            Isotope::Ir200 => Element::Ir,
            Isotope::Ir201 => Element::Ir,
            Isotope::Ir202 => Element::Ir,
            Isotope::Ir203 => Element::Ir,
            Isotope::Ir204 => Element::Ir,
            Isotope::Ir205 => Element::Ir,
            Isotope::Pt165 => Element::Pt,
            Isotope::Pt166 => Element::Pt,
            Isotope::Pt167 => Element::Pt,
            Isotope::Pt168 => Element::Pt,
            Isotope::Pt169 => Element::Pt,
            Isotope::Pt170 => Element::Pt,
            Isotope::Pt171 => Element::Pt,
            Isotope::Pt172 => Element::Pt,
            Isotope::Pt173 => Element::Pt,
            Isotope::Pt174 => Element::Pt,
            Isotope::Pt175 => Element::Pt,
            Isotope::Pt176 => Element::Pt,
            Isotope::Pt177 => Element::Pt,
            Isotope::Pt178 => Element::Pt,
            Isotope::Pt179 => Element::Pt,
            Isotope::Pt180 => Element::Pt,
            Isotope::Pt181 => Element::Pt,
            Isotope::Pt182 => Element::Pt,
            Isotope::Pt183 => Element::Pt,
            Isotope::Pt184 => Element::Pt,
            Isotope::Pt185 => Element::Pt,
            Isotope::Pt186 => Element::Pt,
            Isotope::Pt187 => Element::Pt,
            Isotope::Pt188 => Element::Pt,
            Isotope::Pt189 => Element::Pt,
            Isotope::Pt190 => Element::Pt,
            Isotope::Pt191 => Element::Pt,
            Isotope::Pt192 => Element::Pt,
            Isotope::Pt193 => Element::Pt,
            Isotope::Pt194 => Element::Pt,
            Isotope::Pt195 => Element::Pt,
            Isotope::Pt196 => Element::Pt,
            Isotope::Pt197 => Element::Pt,
            Isotope::Pt198 => Element::Pt,
            Isotope::Pt199 => Element::Pt,
            Isotope::Pt200 => Element::Pt,
            Isotope::Pt201 => Element::Pt,
            Isotope::Pt202 => Element::Pt,
            Isotope::Pt203 => Element::Pt,
            Isotope::Pt204 => Element::Pt,
            Isotope::Pt205 => Element::Pt,
            Isotope::Pt206 => Element::Pt,
            Isotope::Pt207 => Element::Pt,
            Isotope::Pt208 => Element::Pt,
            Isotope::Au168 => Element::Au,
            Isotope::Au169 => Element::Au,
            Isotope::Au170 => Element::Au,
            Isotope::Au171 => Element::Au,
            Isotope::Au172 => Element::Au,
            Isotope::Au173 => Element::Au,
            Isotope::Au174 => Element::Au,
            Isotope::Au175 => Element::Au,
            Isotope::Au176 => Element::Au,
            Isotope::Au177 => Element::Au,
            Isotope::Au178 => Element::Au,
            Isotope::Au179 => Element::Au,
            Isotope::Au180 => Element::Au,
            Isotope::Au181 => Element::Au,
            Isotope::Au182 => Element::Au,
            Isotope::Au183 => Element::Au,
            Isotope::Au184 => Element::Au,
            Isotope::Au185 => Element::Au,
            Isotope::Au186 => Element::Au,
            Isotope::Au187 => Element::Au,
            Isotope::Au188 => Element::Au,
            Isotope::Au189 => Element::Au,
            Isotope::Au190 => Element::Au,
            Isotope::Au191 => Element::Au,
            Isotope::Au192 => Element::Au,
            Isotope::Au193 => Element::Au,
            Isotope::Au194 => Element::Au,
            Isotope::Au195 => Element::Au,
            Isotope::Au196 => Element::Au,
            Isotope::Au197 => Element::Au,
            Isotope::Au198 => Element::Au,
            Isotope::Au199 => Element::Au,
            Isotope::Au200 => Element::Au,
            Isotope::Au201 => Element::Au,
            Isotope::Au202 => Element::Au,
            Isotope::Au203 => Element::Au,
            Isotope::Au204 => Element::Au,
            Isotope::Au205 => Element::Au,
            Isotope::Au206 => Element::Au,
            Isotope::Au207 => Element::Au,
            Isotope::Au208 => Element::Au,
            Isotope::Au209 => Element::Au,
            Isotope::Au210 => Element::Au,
            Isotope::Hg170 => Element::Hg,
            Isotope::Hg171 => Element::Hg,
            Isotope::Hg172 => Element::Hg,
            Isotope::Hg173 => Element::Hg,
            Isotope::Hg174 => Element::Hg,
            Isotope::Hg175 => Element::Hg,
            Isotope::Hg176 => Element::Hg,
            Isotope::Hg177 => Element::Hg,
            Isotope::Hg178 => Element::Hg,
            Isotope::Hg179 => Element::Hg,
            Isotope::Hg180 => Element::Hg,
            Isotope::Hg181 => Element::Hg,
            Isotope::Hg182 => Element::Hg,
            Isotope::Hg183 => Element::Hg,
            Isotope::Hg184 => Element::Hg,
            Isotope::Hg185 => Element::Hg,
            Isotope::Hg186 => Element::Hg,
            Isotope::Hg187 => Element::Hg,
            Isotope::Hg188 => Element::Hg,
            Isotope::Hg189 => Element::Hg,
            Isotope::Hg190 => Element::Hg,
            Isotope::Hg191 => Element::Hg,
            Isotope::Hg192 => Element::Hg,
            Isotope::Hg193 => Element::Hg,
            Isotope::Hg194 => Element::Hg,
            Isotope::Hg195 => Element::Hg,
            Isotope::Hg196 => Element::Hg,
            Isotope::Hg197 => Element::Hg,
            Isotope::Hg198 => Element::Hg,
            Isotope::Hg199 => Element::Hg,
            Isotope::Hg200 => Element::Hg,
            Isotope::Hg201 => Element::Hg,
            Isotope::Hg202 => Element::Hg,
            Isotope::Hg203 => Element::Hg,
            Isotope::Hg204 => Element::Hg,
            Isotope::Hg205 => Element::Hg,
            Isotope::Hg206 => Element::Hg,
            Isotope::Hg207 => Element::Hg,
            Isotope::Hg208 => Element::Hg,
            Isotope::Hg209 => Element::Hg,
            Isotope::Hg210 => Element::Hg,
            Isotope::Hg211 => Element::Hg,
            Isotope::Hg212 => Element::Hg,
            Isotope::Hg213 => Element::Hg,
            Isotope::Hg214 => Element::Hg,
            Isotope::Hg215 => Element::Hg,
            Isotope::Hg216 => Element::Hg,
            Isotope::Tl176 => Element::Tl,
            Isotope::Tl177 => Element::Tl,
            Isotope::Tl178 => Element::Tl,
            Isotope::Tl179 => Element::Tl,
            Isotope::Tl180 => Element::Tl,
            Isotope::Tl181 => Element::Tl,
            Isotope::Tl182 => Element::Tl,
            Isotope::Tl183 => Element::Tl,
            Isotope::Tl184 => Element::Tl,
            Isotope::Tl185 => Element::Tl,
            Isotope::Tl186 => Element::Tl,
            Isotope::Tl187 => Element::Tl,
            Isotope::Tl188 => Element::Tl,
            Isotope::Tl189 => Element::Tl,
            Isotope::Tl190 => Element::Tl,
            Isotope::Tl191 => Element::Tl,
            Isotope::Tl192 => Element::Tl,
            Isotope::Tl193 => Element::Tl,
            Isotope::Tl194 => Element::Tl,
            Isotope::Tl195 => Element::Tl,
            Isotope::Tl196 => Element::Tl,
            Isotope::Tl197 => Element::Tl,
            Isotope::Tl198 => Element::Tl,
            Isotope::Tl199 => Element::Tl,
            Isotope::Tl200 => Element::Tl,
            Isotope::Tl201 => Element::Tl,
            Isotope::Tl202 => Element::Tl,
            Isotope::Tl203 => Element::Tl,
            Isotope::Tl204 => Element::Tl,
            Isotope::Tl205 => Element::Tl,
            Isotope::Tl206 => Element::Tl,
            Isotope::Tl207 => Element::Tl,
            Isotope::Tl208 => Element::Tl,
            Isotope::Tl209 => Element::Tl,
            Isotope::Tl210 => Element::Tl,
            Isotope::Tl211 => Element::Tl,
            Isotope::Tl212 => Element::Tl,
            Isotope::Tl213 => Element::Tl,
            Isotope::Tl214 => Element::Tl,
            Isotope::Tl215 => Element::Tl,
            Isotope::Tl216 => Element::Tl,
            Isotope::Tl217 => Element::Tl,
            Isotope::Tl218 => Element::Tl,
            Isotope::Pb178 => Element::Pb,
            Isotope::Pb179 => Element::Pb,
            Isotope::Pb180 => Element::Pb,
            Isotope::Pb181 => Element::Pb,
            Isotope::Pb182 => Element::Pb,
            Isotope::Pb183 => Element::Pb,
            Isotope::Pb184 => Element::Pb,
            Isotope::Pb185 => Element::Pb,
            Isotope::Pb186 => Element::Pb,
            Isotope::Pb187 => Element::Pb,
            Isotope::Pb188 => Element::Pb,
            Isotope::Pb189 => Element::Pb,
            Isotope::Pb190 => Element::Pb,
            Isotope::Pb191 => Element::Pb,
            Isotope::Pb192 => Element::Pb,
            Isotope::Pb193 => Element::Pb,
            Isotope::Pb194 => Element::Pb,
            Isotope::Pb195 => Element::Pb,
            Isotope::Pb196 => Element::Pb,
            Isotope::Pb197 => Element::Pb,
            Isotope::Pb198 => Element::Pb,
            Isotope::Pb199 => Element::Pb,
            Isotope::Pb200 => Element::Pb,
            Isotope::Pb201 => Element::Pb,
            Isotope::Pb202 => Element::Pb,
            Isotope::Pb203 => Element::Pb,
            Isotope::Pb204 => Element::Pb,
            Isotope::Pb205 => Element::Pb,
            Isotope::Pb206 => Element::Pb,
            Isotope::Pb207 => Element::Pb,
            Isotope::Pb208 => Element::Pb,
            Isotope::Pb209 => Element::Pb,
            Isotope::Pb210 => Element::Pb,
            Isotope::Pb211 => Element::Pb,
            Isotope::Pb212 => Element::Pb,
            Isotope::Pb213 => Element::Pb,
            Isotope::Pb214 => Element::Pb,
            Isotope::Pb215 => Element::Pb,
            Isotope::Pb216 => Element::Pb,
            Isotope::Pb217 => Element::Pb,
            Isotope::Pb218 => Element::Pb,
            Isotope::Pb219 => Element::Pb,
            Isotope::Pb220 => Element::Pb,
            Isotope::Bi184 => Element::Bi,
            Isotope::Bi185 => Element::Bi,
            Isotope::Bi186 => Element::Bi,
            Isotope::Bi187 => Element::Bi,
            Isotope::Bi188 => Element::Bi,
            Isotope::Bi189 => Element::Bi,
            Isotope::Bi190 => Element::Bi,
            Isotope::Bi191 => Element::Bi,
            Isotope::Bi192 => Element::Bi,
            Isotope::Bi193 => Element::Bi,
            Isotope::Bi194 => Element::Bi,
            Isotope::Bi195 => Element::Bi,
            Isotope::Bi196 => Element::Bi,
            Isotope::Bi197 => Element::Bi,
            Isotope::Bi198 => Element::Bi,
            Isotope::Bi199 => Element::Bi,
            Isotope::Bi200 => Element::Bi,
            Isotope::Bi201 => Element::Bi,
            Isotope::Bi202 => Element::Bi,
            Isotope::Bi203 => Element::Bi,
            Isotope::Bi204 => Element::Bi,
            Isotope::Bi205 => Element::Bi,
            Isotope::Bi206 => Element::Bi,
            Isotope::Bi207 => Element::Bi,
            Isotope::Bi208 => Element::Bi,
            Isotope::Bi209 => Element::Bi,
            Isotope::Bi210 => Element::Bi,
            Isotope::Bi211 => Element::Bi,
            Isotope::Bi212 => Element::Bi,
            Isotope::Bi213 => Element::Bi,
            Isotope::Bi214 => Element::Bi,
            Isotope::Bi215 => Element::Bi,
            Isotope::Bi216 => Element::Bi,
            Isotope::Bi217 => Element::Bi,
            Isotope::Bi218 => Element::Bi,
            Isotope::Bi219 => Element::Bi,
            Isotope::Bi220 => Element::Bi,
            Isotope::Bi221 => Element::Bi,
            Isotope::Bi222 => Element::Bi,
            Isotope::Bi223 => Element::Bi,
            Isotope::Bi224 => Element::Bi,
            Isotope::Po186 => Element::Po,
            Isotope::Po187 => Element::Po,
            Isotope::Po188 => Element::Po,
            Isotope::Po189 => Element::Po,
            Isotope::Po190 => Element::Po,
            Isotope::Po191 => Element::Po,
            Isotope::Po192 => Element::Po,
            Isotope::Po193 => Element::Po,
            Isotope::Po194 => Element::Po,
            Isotope::Po195 => Element::Po,
            Isotope::Po196 => Element::Po,
            Isotope::Po197 => Element::Po,
            Isotope::Po198 => Element::Po,
            Isotope::Po199 => Element::Po,
            Isotope::Po200 => Element::Po,
            Isotope::Po201 => Element::Po,
            Isotope::Po202 => Element::Po,
            Isotope::Po203 => Element::Po,
            Isotope::Po204 => Element::Po,
            Isotope::Po205 => Element::Po,
            Isotope::Po206 => Element::Po,
            Isotope::Po207 => Element::Po,
            Isotope::Po208 => Element::Po,
            Isotope::Po209 => Element::Po,
            Isotope::Po210 => Element::Po,
            Isotope::Po211 => Element::Po,
            Isotope::Po212 => Element::Po,
            Isotope::Po213 => Element::Po,
            Isotope::Po214 => Element::Po,
            Isotope::Po215 => Element::Po,
            Isotope::Po216 => Element::Po,
            Isotope::Po217 => Element::Po,
            Isotope::Po218 => Element::Po,
            Isotope::Po219 => Element::Po,
            Isotope::Po220 => Element::Po,
            Isotope::Po221 => Element::Po,
            Isotope::Po222 => Element::Po,
            Isotope::Po223 => Element::Po,
            Isotope::Po224 => Element::Po,
            Isotope::Po225 => Element::Po,
            Isotope::Po226 => Element::Po,
            Isotope::Po227 => Element::Po,
            Isotope::At191 => Element::At,
            Isotope::At192 => Element::At,
            Isotope::At193 => Element::At,
            Isotope::At194 => Element::At,
            Isotope::At195 => Element::At,
            Isotope::At196 => Element::At,
            Isotope::At197 => Element::At,
            Isotope::At198 => Element::At,
            Isotope::At199 => Element::At,
            Isotope::At200 => Element::At,
            Isotope::At201 => Element::At,
            Isotope::At202 => Element::At,
            Isotope::At203 => Element::At,
            Isotope::At204 => Element::At,
            Isotope::At205 => Element::At,
            Isotope::At206 => Element::At,
            Isotope::At207 => Element::At,
            Isotope::At208 => Element::At,
            Isotope::At209 => Element::At,
            Isotope::At210 => Element::At,
            Isotope::At211 => Element::At,
            Isotope::At212 => Element::At,
            Isotope::At213 => Element::At,
            Isotope::At214 => Element::At,
            Isotope::At215 => Element::At,
            Isotope::At216 => Element::At,
            Isotope::At217 => Element::At,
            Isotope::At218 => Element::At,
            Isotope::At219 => Element::At,
            Isotope::At220 => Element::At,
            Isotope::At221 => Element::At,
            Isotope::At222 => Element::At,
            Isotope::At223 => Element::At,
            Isotope::At224 => Element::At,
            Isotope::At225 => Element::At,
            Isotope::At226 => Element::At,
            Isotope::At227 => Element::At,
            Isotope::At228 => Element::At,
            Isotope::At229 => Element::At,
            Isotope::Rn193 => Element::Rn,
            Isotope::Rn194 => Element::Rn,
            Isotope::Rn195 => Element::Rn,
            Isotope::Rn196 => Element::Rn,
            Isotope::Rn197 => Element::Rn,
            Isotope::Rn198 => Element::Rn,
            Isotope::Rn199 => Element::Rn,
            Isotope::Rn200 => Element::Rn,
            Isotope::Rn201 => Element::Rn,
            Isotope::Rn202 => Element::Rn,
            Isotope::Rn203 => Element::Rn,
            Isotope::Rn204 => Element::Rn,
            Isotope::Rn205 => Element::Rn,
            Isotope::Rn206 => Element::Rn,
            Isotope::Rn207 => Element::Rn,
            Isotope::Rn208 => Element::Rn,
            Isotope::Rn209 => Element::Rn,
            Isotope::Rn210 => Element::Rn,
            Isotope::Rn211 => Element::Rn,
            Isotope::Rn212 => Element::Rn,
            Isotope::Rn213 => Element::Rn,
            Isotope::Rn214 => Element::Rn,
            Isotope::Rn215 => Element::Rn,
            Isotope::Rn216 => Element::Rn,
            Isotope::Rn217 => Element::Rn,
            Isotope::Rn218 => Element::Rn,
            Isotope::Rn219 => Element::Rn,
            Isotope::Rn220 => Element::Rn,
            Isotope::Rn221 => Element::Rn,
            Isotope::Rn222 => Element::Rn,
            Isotope::Rn223 => Element::Rn,
            Isotope::Rn224 => Element::Rn,
            Isotope::Rn225 => Element::Rn,
            Isotope::Rn226 => Element::Rn,
            Isotope::Rn227 => Element::Rn,
            Isotope::Rn228 => Element::Rn,
            Isotope::Rn229 => Element::Rn,
            Isotope::Rn230 => Element::Rn,
            Isotope::Rn231 => Element::Rn,
            Isotope::Fr197 => Element::Fr,
            Isotope::Fr198 => Element::Fr,
            Isotope::Fr199 => Element::Fr,
            Isotope::Fr200 => Element::Fr,
            Isotope::Fr201 => Element::Fr,
            Isotope::Fr202 => Element::Fr,
            Isotope::Fr203 => Element::Fr,
            Isotope::Fr204 => Element::Fr,
            Isotope::Fr205 => Element::Fr,
            Isotope::Fr206 => Element::Fr,
            Isotope::Fr207 => Element::Fr,
            Isotope::Fr208 => Element::Fr,
            Isotope::Fr209 => Element::Fr,
            Isotope::Fr210 => Element::Fr,
            Isotope::Fr211 => Element::Fr,
            Isotope::Fr212 => Element::Fr,
            Isotope::Fr213 => Element::Fr,
            Isotope::Fr214 => Element::Fr,
            Isotope::Fr215 => Element::Fr,
            Isotope::Fr216 => Element::Fr,
            Isotope::Fr217 => Element::Fr,
            Isotope::Fr218 => Element::Fr,
            Isotope::Fr219 => Element::Fr,
            Isotope::Fr220 => Element::Fr,
            Isotope::Fr221 => Element::Fr,
            Isotope::Fr222 => Element::Fr,
            Isotope::Fr223 => Element::Fr,
            Isotope::Fr224 => Element::Fr,
            Isotope::Fr225 => Element::Fr,
            Isotope::Fr226 => Element::Fr,
            Isotope::Fr227 => Element::Fr,
            Isotope::Fr228 => Element::Fr,
            Isotope::Fr229 => Element::Fr,
            Isotope::Fr230 => Element::Fr,
            Isotope::Fr231 => Element::Fr,
            Isotope::Fr232 => Element::Fr,
            Isotope::Fr233 => Element::Fr,
            Isotope::Ra201 => Element::Ra,
            Isotope::Ra202 => Element::Ra,
            Isotope::Ra203 => Element::Ra,
            Isotope::Ra204 => Element::Ra,
            Isotope::Ra205 => Element::Ra,
            Isotope::Ra206 => Element::Ra,
            Isotope::Ra207 => Element::Ra,
            Isotope::Ra208 => Element::Ra,
            Isotope::Ra209 => Element::Ra,
            Isotope::Ra210 => Element::Ra,
            Isotope::Ra211 => Element::Ra,
            Isotope::Ra212 => Element::Ra,
            Isotope::Ra213 => Element::Ra,
            Isotope::Ra214 => Element::Ra,
            Isotope::Ra215 => Element::Ra,
            Isotope::Ra216 => Element::Ra,
            Isotope::Ra217 => Element::Ra,
            Isotope::Ra218 => Element::Ra,
            Isotope::Ra219 => Element::Ra,
            Isotope::Ra220 => Element::Ra,
            Isotope::Ra221 => Element::Ra,
            Isotope::Ra222 => Element::Ra,
            Isotope::Ra223 => Element::Ra,
            Isotope::Ra224 => Element::Ra,
            Isotope::Ra225 => Element::Ra,
            Isotope::Ra226 => Element::Ra,
            Isotope::Ra227 => Element::Ra,
            Isotope::Ra228 => Element::Ra,
            Isotope::Ra229 => Element::Ra,
            Isotope::Ra230 => Element::Ra,
            Isotope::Ra231 => Element::Ra,
            Isotope::Ra232 => Element::Ra,
            Isotope::Ra233 => Element::Ra,
            Isotope::Ra234 => Element::Ra,
            Isotope::Ra235 => Element::Ra,
            Isotope::Ac205 => Element::Ac,
            Isotope::Ac206 => Element::Ac,
            Isotope::Ac207 => Element::Ac,
            Isotope::Ac208 => Element::Ac,
            Isotope::Ac209 => Element::Ac,
            Isotope::Ac210 => Element::Ac,
            Isotope::Ac211 => Element::Ac,
            Isotope::Ac212 => Element::Ac,
            Isotope::Ac213 => Element::Ac,
            Isotope::Ac214 => Element::Ac,
            Isotope::Ac215 => Element::Ac,
            Isotope::Ac216 => Element::Ac,
            Isotope::Ac217 => Element::Ac,
            Isotope::Ac218 => Element::Ac,
            Isotope::Ac219 => Element::Ac,
            Isotope::Ac220 => Element::Ac,
            Isotope::Ac221 => Element::Ac,
            Isotope::Ac222 => Element::Ac,
            Isotope::Ac223 => Element::Ac,
            Isotope::Ac224 => Element::Ac,
            Isotope::Ac225 => Element::Ac,
            Isotope::Ac226 => Element::Ac,
            Isotope::Ac227 => Element::Ac,
            Isotope::Ac228 => Element::Ac,
            Isotope::Ac229 => Element::Ac,
            Isotope::Ac230 => Element::Ac,
            Isotope::Ac231 => Element::Ac,
            Isotope::Ac232 => Element::Ac,
            Isotope::Ac233 => Element::Ac,
            Isotope::Ac234 => Element::Ac,
            Isotope::Ac235 => Element::Ac,
            Isotope::Ac236 => Element::Ac,
            Isotope::Ac237 => Element::Ac,
            Isotope::Th208 => Element::Th,
            Isotope::Th209 => Element::Th,
            Isotope::Th210 => Element::Th,
            Isotope::Th211 => Element::Th,
            Isotope::Th212 => Element::Th,
            Isotope::Th213 => Element::Th,
            Isotope::Th214 => Element::Th,
            Isotope::Th215 => Element::Th,
            Isotope::Th216 => Element::Th,
            Isotope::Th217 => Element::Th,
            Isotope::Th218 => Element::Th,
            Isotope::Th219 => Element::Th,
            Isotope::Th220 => Element::Th,
            Isotope::Th221 => Element::Th,
            Isotope::Th222 => Element::Th,
            Isotope::Th223 => Element::Th,
            Isotope::Th224 => Element::Th,
            Isotope::Th225 => Element::Th,
            Isotope::Th226 => Element::Th,
            Isotope::Th227 => Element::Th,
            Isotope::Th228 => Element::Th,
            Isotope::Th229 => Element::Th,
            Isotope::Th230 => Element::Th,
            Isotope::Th231 => Element::Th,
            Isotope::Th232 => Element::Th,
            Isotope::Th233 => Element::Th,
            Isotope::Th234 => Element::Th,
            Isotope::Th235 => Element::Th,
            Isotope::Th236 => Element::Th,
            Isotope::Th237 => Element::Th,
            Isotope::Th238 => Element::Th,
            Isotope::Th239 => Element::Th,
            Isotope::Pa211 => Element::Pa,
            Isotope::Pa212 => Element::Pa,
            Isotope::Pa213 => Element::Pa,
            Isotope::Pa214 => Element::Pa,
            Isotope::Pa215 => Element::Pa,
            Isotope::Pa216 => Element::Pa,
            Isotope::Pa217 => Element::Pa,
            Isotope::Pa218 => Element::Pa,
            Isotope::Pa219 => Element::Pa,
            Isotope::Pa220 => Element::Pa,
            Isotope::Pa221 => Element::Pa,
            Isotope::Pa222 => Element::Pa,
            Isotope::Pa223 => Element::Pa,
            Isotope::Pa224 => Element::Pa,
            Isotope::Pa225 => Element::Pa,
            Isotope::Pa226 => Element::Pa,
            Isotope::Pa227 => Element::Pa,
            Isotope::Pa228 => Element::Pa,
            Isotope::Pa229 => Element::Pa,
            Isotope::Pa230 => Element::Pa,
            Isotope::Pa231 => Element::Pa,
            Isotope::Pa232 => Element::Pa,
            Isotope::Pa233 => Element::Pa,
            Isotope::Pa234 => Element::Pa,
            Isotope::Pa235 => Element::Pa,
            Isotope::Pa236 => Element::Pa,
            Isotope::Pa237 => Element::Pa,
            Isotope::Pa238 => Element::Pa,
            Isotope::Pa239 => Element::Pa,
            Isotope::Pa240 => Element::Pa,
            Isotope::Pa241 => Element::Pa,
            Isotope::U215 => Element::U,
            Isotope::U216 => Element::U,
            Isotope::U217 => Element::U,
            Isotope::U218 => Element::U,
            Isotope::U219 => Element::U,
            Isotope::U220 => Element::U,
            Isotope::U221 => Element::U,
            Isotope::U222 => Element::U,
            Isotope::U223 => Element::U,
            Isotope::U224 => Element::U,
            Isotope::U225 => Element::U,
            Isotope::U226 => Element::U,
            Isotope::U227 => Element::U,
            Isotope::U228 => Element::U,
            Isotope::U229 => Element::U,
            Isotope::U230 => Element::U,
            Isotope::U231 => Element::U,
            Isotope::U232 => Element::U,
            Isotope::U233 => Element::U,
            Isotope::U234 => Element::U,
            Isotope::U235 => Element::U,
            Isotope::U236 => Element::U,
            Isotope::U237 => Element::U,
            Isotope::U238 => Element::U,
            Isotope::U239 => Element::U,
            Isotope::U240 => Element::U,
            Isotope::U241 => Element::U,
            Isotope::U242 => Element::U,
            Isotope::U243 => Element::U,
            Isotope::Np219 => Element::Np,
            Isotope::Np220 => Element::Np,
            Isotope::Np221 => Element::Np,
            Isotope::Np222 => Element::Np,
            Isotope::Np223 => Element::Np,
            Isotope::Np224 => Element::Np,
            Isotope::Np225 => Element::Np,
            Isotope::Np226 => Element::Np,
            Isotope::Np227 => Element::Np,
            Isotope::Np228 => Element::Np,
            Isotope::Np229 => Element::Np,
            Isotope::Np230 => Element::Np,
            Isotope::Np231 => Element::Np,
            Isotope::Np232 => Element::Np,
            Isotope::Np233 => Element::Np,
            Isotope::Np234 => Element::Np,
            Isotope::Np235 => Element::Np,
            Isotope::Np236 => Element::Np,
            Isotope::Np237 => Element::Np,
            Isotope::Np238 => Element::Np,
            Isotope::Np239 => Element::Np,
            Isotope::Np240 => Element::Np,
            Isotope::Np241 => Element::Np,
            Isotope::Np242 => Element::Np,
            Isotope::Np243 => Element::Np,
            Isotope::Np244 => Element::Np,
            Isotope::Np245 => Element::Np,
            Isotope::Pu221 => Element::Pu,
            Isotope::Pu222 => Element::Pu,
            Isotope::Pu223 => Element::Pu,
            Isotope::Pu224 => Element::Pu,
            Isotope::Pu225 => Element::Pu,
            Isotope::Pu226 => Element::Pu,
            Isotope::Pu227 => Element::Pu,
            Isotope::Pu228 => Element::Pu,
            Isotope::Pu229 => Element::Pu,
            Isotope::Pu230 => Element::Pu,
            Isotope::Pu231 => Element::Pu,
            Isotope::Pu232 => Element::Pu,
            Isotope::Pu233 => Element::Pu,
            Isotope::Pu234 => Element::Pu,
            Isotope::Pu235 => Element::Pu,
            Isotope::Pu236 => Element::Pu,
            Isotope::Pu237 => Element::Pu,
            Isotope::Pu238 => Element::Pu,
            Isotope::Pu239 => Element::Pu,
            Isotope::Pu240 => Element::Pu,
            Isotope::Pu241 => Element::Pu,
            Isotope::Pu242 => Element::Pu,
            Isotope::Pu243 => Element::Pu,
            Isotope::Pu244 => Element::Pu,
            Isotope::Pu245 => Element::Pu,
            Isotope::Pu246 => Element::Pu,
            Isotope::Pu247 => Element::Pu,
            Isotope::Am223 => Element::Am,
            Isotope::Am224 => Element::Am,
            Isotope::Am225 => Element::Am,
            Isotope::Am226 => Element::Am,
            Isotope::Am227 => Element::Am,
            Isotope::Am228 => Element::Am,
            Isotope::Am229 => Element::Am,
            Isotope::Am230 => Element::Am,
            Isotope::Am231 => Element::Am,
            Isotope::Am232 => Element::Am,
            Isotope::Am233 => Element::Am,
            Isotope::Am234 => Element::Am,
            Isotope::Am235 => Element::Am,
            Isotope::Am236 => Element::Am,
            Isotope::Am237 => Element::Am,
            Isotope::Am238 => Element::Am,
            Isotope::Am239 => Element::Am,
            Isotope::Am240 => Element::Am,
            Isotope::Am241 => Element::Am,
            Isotope::Am242 => Element::Am,
            Isotope::Am243 => Element::Am,
            Isotope::Am244 => Element::Am,
            Isotope::Am245 => Element::Am,
            Isotope::Am246 => Element::Am,
            Isotope::Am247 => Element::Am,
            Isotope::Am248 => Element::Am,
            Isotope::Am249 => Element::Am,
            Isotope::Cm231 => Element::Cm,
            Isotope::Cm232 => Element::Cm,
            Isotope::Cm233 => Element::Cm,
            Isotope::Cm234 => Element::Cm,
            Isotope::Cm235 => Element::Cm,
            Isotope::Cm236 => Element::Cm,
            Isotope::Cm237 => Element::Cm,
            Isotope::Cm238 => Element::Cm,
            Isotope::Cm239 => Element::Cm,
            Isotope::Cm240 => Element::Cm,
            Isotope::Cm241 => Element::Cm,
            Isotope::Cm242 => Element::Cm,
            Isotope::Cm243 => Element::Cm,
            Isotope::Cm244 => Element::Cm,
            Isotope::Cm245 => Element::Cm,
            Isotope::Cm246 => Element::Cm,
            Isotope::Cm247 => Element::Cm,
            Isotope::Cm248 => Element::Cm,
            Isotope::Cm249 => Element::Cm,
            Isotope::Cm250 => Element::Cm,
            Isotope::Cm251 => Element::Cm,
            Isotope::Cm252 => Element::Cm,
            Isotope::Bk233 => Element::Bk,
            Isotope::Bk234 => Element::Bk,
            Isotope::Bk235 => Element::Bk,
            Isotope::Bk236 => Element::Bk,
            Isotope::Bk237 => Element::Bk,
            Isotope::Bk238 => Element::Bk,
            Isotope::Bk239 => Element::Bk,
            Isotope::Bk240 => Element::Bk,
            Isotope::Bk241 => Element::Bk,
            Isotope::Bk242 => Element::Bk,
            Isotope::Bk243 => Element::Bk,
            Isotope::Bk244 => Element::Bk,
            Isotope::Bk245 => Element::Bk,
            Isotope::Bk246 => Element::Bk,
            Isotope::Bk247 => Element::Bk,
            Isotope::Bk248 => Element::Bk,
            Isotope::Bk249 => Element::Bk,
            Isotope::Bk250 => Element::Bk,
            Isotope::Bk251 => Element::Bk,
            Isotope::Bk252 => Element::Bk,
            Isotope::Bk253 => Element::Bk,
            Isotope::Bk254 => Element::Bk,
            Isotope::Cf237 => Element::Cf,
            Isotope::Cf238 => Element::Cf,
            Isotope::Cf239 => Element::Cf,
            Isotope::Cf240 => Element::Cf,
            Isotope::Cf241 => Element::Cf,
            Isotope::Cf242 => Element::Cf,
            Isotope::Cf243 => Element::Cf,
            Isotope::Cf244 => Element::Cf,
            Isotope::Cf245 => Element::Cf,
            Isotope::Cf246 => Element::Cf,
            Isotope::Cf247 => Element::Cf,
            Isotope::Cf248 => Element::Cf,
            Isotope::Cf249 => Element::Cf,
            Isotope::Cf250 => Element::Cf,
            Isotope::Cf251 => Element::Cf,
            Isotope::Cf252 => Element::Cf,
            Isotope::Cf253 => Element::Cf,
            Isotope::Cf254 => Element::Cf,
            Isotope::Cf255 => Element::Cf,
            Isotope::Cf256 => Element::Cf,
            Isotope::Es239 => Element::Es,
            Isotope::Es240 => Element::Es,
            Isotope::Es241 => Element::Es,
            Isotope::Es242 => Element::Es,
            Isotope::Es243 => Element::Es,
            Isotope::Es244 => Element::Es,
            Isotope::Es245 => Element::Es,
            Isotope::Es246 => Element::Es,
            Isotope::Es247 => Element::Es,
            Isotope::Es248 => Element::Es,
            Isotope::Es249 => Element::Es,
            Isotope::Es250 => Element::Es,
            Isotope::Es251 => Element::Es,
            Isotope::Es252 => Element::Es,
            Isotope::Es253 => Element::Es,
            Isotope::Es254 => Element::Es,
            Isotope::Es255 => Element::Es,
            Isotope::Es256 => Element::Es,
            Isotope::Es257 => Element::Es,
            Isotope::Es258 => Element::Es,
            Isotope::Fm241 => Element::Fm,
            Isotope::Fm242 => Element::Fm,
            Isotope::Fm243 => Element::Fm,
            Isotope::Fm244 => Element::Fm,
            Isotope::Fm245 => Element::Fm,
            Isotope::Fm246 => Element::Fm,
            Isotope::Fm247 => Element::Fm,
            Isotope::Fm248 => Element::Fm,
            Isotope::Fm249 => Element::Fm,
            Isotope::Fm250 => Element::Fm,
            Isotope::Fm251 => Element::Fm,
            Isotope::Fm252 => Element::Fm,
            Isotope::Fm253 => Element::Fm,
            Isotope::Fm254 => Element::Fm,
            Isotope::Fm255 => Element::Fm,
            Isotope::Fm256 => Element::Fm,
            Isotope::Fm257 => Element::Fm,
            Isotope::Fm258 => Element::Fm,
            Isotope::Fm259 => Element::Fm,
            Isotope::Fm260 => Element::Fm,
            Isotope::Md244 => Element::Md,
            Isotope::Md245 => Element::Md,
            Isotope::Md246 => Element::Md,
            Isotope::Md247 => Element::Md,
            Isotope::Md248 => Element::Md,
            Isotope::Md249 => Element::Md,
            Isotope::Md250 => Element::Md,
            Isotope::Md251 => Element::Md,
            Isotope::Md252 => Element::Md,
            Isotope::Md253 => Element::Md,
            Isotope::Md254 => Element::Md,
            Isotope::Md255 => Element::Md,
            Isotope::Md256 => Element::Md,
            Isotope::Md257 => Element::Md,
            Isotope::Md258 => Element::Md,
            Isotope::Md259 => Element::Md,
            Isotope::Md260 => Element::Md,
            Isotope::Md261 => Element::Md,
            Isotope::Md262 => Element::Md,
            Isotope::No248 => Element::No,
            Isotope::No249 => Element::No,
            Isotope::No250 => Element::No,
            Isotope::No251 => Element::No,
            Isotope::No252 => Element::No,
            Isotope::No253 => Element::No,
            Isotope::No254 => Element::No,
            Isotope::No255 => Element::No,
            Isotope::No256 => Element::No,
            Isotope::No257 => Element::No,
            Isotope::No258 => Element::No,
            Isotope::No259 => Element::No,
            Isotope::No260 => Element::No,
            Isotope::No261 => Element::No,
            Isotope::No262 => Element::No,
            Isotope::No263 => Element::No,
            Isotope::No264 => Element::No,
            Isotope::Lr251 => Element::Lr,
            Isotope::Lr252 => Element::Lr,
            Isotope::Lr253 => Element::Lr,
            Isotope::Lr254 => Element::Lr,
            Isotope::Lr255 => Element::Lr,
            Isotope::Lr256 => Element::Lr,
            Isotope::Lr257 => Element::Lr,
            Isotope::Lr258 => Element::Lr,
            Isotope::Lr259 => Element::Lr,
            Isotope::Lr260 => Element::Lr,
            Isotope::Lr261 => Element::Lr,
            Isotope::Lr262 => Element::Lr,
            Isotope::Lr263 => Element::Lr,
            Isotope::Lr264 => Element::Lr,
            Isotope::Lr265 => Element::Lr,
            Isotope::Lr266 => Element::Lr,
            Isotope::Rf253 => Element::Rf,
            Isotope::Rf254 => Element::Rf,
            Isotope::Rf255 => Element::Rf,
            Isotope::Rf256 => Element::Rf,
            Isotope::Rf257 => Element::Rf,
            Isotope::Rf258 => Element::Rf,
            Isotope::Rf259 => Element::Rf,
            Isotope::Rf260 => Element::Rf,
            Isotope::Rf261 => Element::Rf,
            Isotope::Rf262 => Element::Rf,
            Isotope::Rf263 => Element::Rf,
            Isotope::Rf264 => Element::Rf,
            Isotope::Rf265 => Element::Rf,
            Isotope::Rf266 => Element::Rf,
            Isotope::Rf267 => Element::Rf,
            Isotope::Rf268 => Element::Rf,
            Isotope::Db255 => Element::Db,
            Isotope::Db256 => Element::Db,
            Isotope::Db257 => Element::Db,
            Isotope::Db258 => Element::Db,
            Isotope::Db259 => Element::Db,
            Isotope::Db260 => Element::Db,
            Isotope::Db261 => Element::Db,
            Isotope::Db262 => Element::Db,
            Isotope::Db263 => Element::Db,
            Isotope::Db264 => Element::Db,
            Isotope::Db265 => Element::Db,
            Isotope::Db266 => Element::Db,
            Isotope::Db267 => Element::Db,
            Isotope::Db268 => Element::Db,
            Isotope::Db269 => Element::Db,
            Isotope::Db270 => Element::Db,
            Isotope::Sg258 => Element::Sg,
            Isotope::Sg259 => Element::Sg,
            Isotope::Sg260 => Element::Sg,
            Isotope::Sg261 => Element::Sg,
            Isotope::Sg262 => Element::Sg,
            Isotope::Sg263 => Element::Sg,
            Isotope::Sg264 => Element::Sg,
            Isotope::Sg265 => Element::Sg,
            Isotope::Sg266 => Element::Sg,
            Isotope::Sg267 => Element::Sg,
            Isotope::Sg268 => Element::Sg,
            Isotope::Sg269 => Element::Sg,
            Isotope::Sg270 => Element::Sg,
            Isotope::Sg271 => Element::Sg,
            Isotope::Sg272 => Element::Sg,
            Isotope::Sg273 => Element::Sg,
            Isotope::Bh260 => Element::Bh,
            Isotope::Bh261 => Element::Bh,
            Isotope::Bh262 => Element::Bh,
            Isotope::Bh263 => Element::Bh,
            Isotope::Bh264 => Element::Bh,
            Isotope::Bh265 => Element::Bh,
            Isotope::Bh266 => Element::Bh,
            Isotope::Bh267 => Element::Bh,
            Isotope::Bh268 => Element::Bh,
            Isotope::Bh269 => Element::Bh,
            Isotope::Bh270 => Element::Bh,
            Isotope::Bh271 => Element::Bh,
            Isotope::Bh272 => Element::Bh,
            Isotope::Bh273 => Element::Bh,
            Isotope::Bh274 => Element::Bh,
            Isotope::Bh275 => Element::Bh,
            Isotope::Bh276 => Element::Bh,
            Isotope::Bh277 => Element::Bh,
            Isotope::Bh278 => Element::Bh,
            Isotope::Hs263 => Element::Hs,
            Isotope::Hs264 => Element::Hs,
            Isotope::Hs265 => Element::Hs,
            Isotope::Hs266 => Element::Hs,
            Isotope::Hs267 => Element::Hs,
            Isotope::Hs268 => Element::Hs,
            Isotope::Hs269 => Element::Hs,
            Isotope::Hs270 => Element::Hs,
            Isotope::Hs271 => Element::Hs,
            Isotope::Hs272 => Element::Hs,
            Isotope::Hs273 => Element::Hs,
            Isotope::Hs274 => Element::Hs,
            Isotope::Hs275 => Element::Hs,
            Isotope::Hs276 => Element::Hs,
            Isotope::Hs277 => Element::Hs,
            Isotope::Hs278 => Element::Hs,
            Isotope::Hs279 => Element::Hs,
            Isotope::Hs280 => Element::Hs,
            Isotope::Mt265 => Element::Mt,
            Isotope::Mt266 => Element::Mt,
            Isotope::Mt267 => Element::Mt,
            Isotope::Mt268 => Element::Mt,
            Isotope::Mt269 => Element::Mt,
            Isotope::Mt270 => Element::Mt,
            Isotope::Mt271 => Element::Mt,
            Isotope::Mt272 => Element::Mt,
            Isotope::Mt273 => Element::Mt,
            Isotope::Mt274 => Element::Mt,
            Isotope::Mt275 => Element::Mt,
            Isotope::Mt276 => Element::Mt,
            Isotope::Mt277 => Element::Mt,
            Isotope::Mt278 => Element::Mt,
            Isotope::Mt279 => Element::Mt,
            Isotope::Mt280 => Element::Mt,
            Isotope::Mt281 => Element::Mt,
            Isotope::Mt282 => Element::Mt,
            Isotope::Ds267 => Element::Ds,
            Isotope::Ds268 => Element::Ds,
            Isotope::Ds269 => Element::Ds,
            Isotope::Ds270 => Element::Ds,
            Isotope::Ds271 => Element::Ds,
            Isotope::Ds272 => Element::Ds,
            Isotope::Ds273 => Element::Ds,
            Isotope::Ds274 => Element::Ds,
            Isotope::Ds275 => Element::Ds,
            Isotope::Ds276 => Element::Ds,
            Isotope::Ds277 => Element::Ds,
            Isotope::Ds278 => Element::Ds,
            Isotope::Ds279 => Element::Ds,
            Isotope::Ds280 => Element::Ds,
            Isotope::Ds281 => Element::Ds,
            Isotope::Ds282 => Element::Ds,
            Isotope::Ds283 => Element::Ds,
            Isotope::Ds284 => Element::Ds,
            Isotope::Rg272 => Element::Rg,
            Isotope::Rg273 => Element::Rg,
            Isotope::Rg274 => Element::Rg,
            Isotope::Rg275 => Element::Rg,
            Isotope::Rg276 => Element::Rg,
            Isotope::Rg277 => Element::Rg,
            Isotope::Rg278 => Element::Rg,
            Isotope::Rg279 => Element::Rg,
            Isotope::Rg280 => Element::Rg,
            Isotope::Rg281 => Element::Rg,
            Isotope::Rg282 => Element::Rg,
            Isotope::Rg283 => Element::Rg,
            Isotope::Rg284 => Element::Rg,
            Isotope::Rg285 => Element::Rg,
            Isotope::Rg286 => Element::Rg,
            Isotope::Cn276 => Element::Cn,
            Isotope::Cn277 => Element::Cn,
            Isotope::Cn278 => Element::Cn,
            Isotope::Cn279 => Element::Cn,
            Isotope::Cn280 => Element::Cn,
            Isotope::Cn281 => Element::Cn,
            Isotope::Cn282 => Element::Cn,
            Isotope::Cn283 => Element::Cn,
            Isotope::Cn284 => Element::Cn,
            Isotope::Cn285 => Element::Cn,
            Isotope::Cn286 => Element::Cn,
            Isotope::Cn287 => Element::Cn,
            Isotope::Cn288 => Element::Cn,
            Isotope::Nh278 => Element::Nh,
            Isotope::Nh279 => Element::Nh,
            Isotope::Nh280 => Element::Nh,
            Isotope::Nh281 => Element::Nh,
            Isotope::Nh282 => Element::Nh,
            Isotope::Nh283 => Element::Nh,
            Isotope::Nh284 => Element::Nh,
            Isotope::Nh285 => Element::Nh,
            Isotope::Nh286 => Element::Nh,
            Isotope::Nh287 => Element::Nh,
            Isotope::Nh288 => Element::Nh,
            Isotope::Nh289 => Element::Nh,
            Isotope::Nh290 => Element::Nh,
            Isotope::Fl284 => Element::Fl,
            Isotope::Fl285 => Element::Fl,
            Isotope::Fl286 => Element::Fl,
            Isotope::Fl287 => Element::Fl,
            Isotope::Fl288 => Element::Fl,
            Isotope::Fl289 => Element::Fl,
            Isotope::Fl290 => Element::Fl,
            Isotope::Fl291 => Element::Fl,
            Isotope::Mc287 => Element::Mc,
            Isotope::Mc288 => Element::Mc,
            Isotope::Mc289 => Element::Mc,
            Isotope::Mc290 => Element::Mc,
            Isotope::Mc291 => Element::Mc,
            Isotope::Mc292 => Element::Mc,
            Isotope::Lv289 => Element::Lv,
            Isotope::Lv290 => Element::Lv,
            Isotope::Lv291 => Element::Lv,
            Isotope::Lv292 => Element::Lv,
            Isotope::Lv293 => Element::Lv,
            Isotope::Ts291 => Element::Ts,
            Isotope::Ts292 => Element::Ts,
            Isotope::Ts293 => Element::Ts,
            Isotope::Ts294 => Element::Ts,
            Isotope::Og293 => Element::Og,
            Isotope::Og294 => Element::Og,
            Isotope::Og295 => Element::Og,
        }
    }
}
