% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_to_signatures_bootstrapped.R
\name{fit_to_signatures_bootstrapped}
\alias{fit_to_signatures_bootstrapped}
\title{Fit mutational signatures to a mutation matrix with bootstrapping}
\usage{
fit_to_signatures_bootstrapped(
  mut_matrix,
  signatures,
  n_boots = 1000,
  max_delta = 0.05,
  method = c("strict", "regular", "regular_10+"),
  verbose = TRUE
)
}
\arguments{
\item{mut_matrix}{mutation count matrix (dimensions: x mutation types
X n samples)}

\item{signatures}{Signature matrix (dimensions: x mutation types
X n signatures)}

\item{n_boots}{Number of bootstrap iterations.}

\item{max_delta}{The maximum difference in original vs reconstructed cosine similarity between two iterations.
Only used with method strict.}

\item{method}{The refitting method to be used.
 Possible values:
* 'strict' Uses fit_to_signatures_strict;
* 'regular' Uses fit_to_signatures;
* 'regular_10+' Uses fit_to_signatures, but removes signatures with less than 10 variants.;}

\item{verbose}{Boolean. If TRUE, the function will show how far along it is.}
}
\value{
A matrix showing the signature contributions across all the bootstrap iterations.
}
\description{
Bootstrapping the signature refitting shows how stable the refit is, when small changes are made to the
mutation matrix. You can be more confident in the refitting results, when the differences in signature
contributions are small between bootstrap iterations.
}
\details{
The mutation matrix is resampled 'n_boots' times.
Resampling is done per column (sample) with replacement.
The row weights are used as probabilities.
On each resampled matrix the 'fit_to_signatures()' or 'fit_to_signatures_strict()' function
is applied.
In the end a matrix is returned with the contributions for each bootstrap iteration.
Each row is a single bootstrap iteration from a single sample.
The method you choose determines how strict the signature refitting is.
The 'regular' and "regular_10+ methods often suffer from a lot of overfitting,
however this is less of an issue when you refit on an limited number of signatures.
The 'strict' method suffers less from overfitting, but can suffer from more
signature misattribution. The best method will depend on your data and
research question.
}
\examples{
## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Get pre-defined signatures
signatures <- get_known_signatures()

## Fit to signatures with bootstrapping
contri_boots <- fit_to_signatures_bootstrapped(mut_mat,
  signatures,
  n_boots = 10,
  max_delta = 0.05
)

## Use the regular refit method
contri_boots <- fit_to_signatures_bootstrapped(mut_mat,
  signatures,
  n_boots = 10,
  max_delta = 0.05,
  method = "regular"
)
}
\seealso{
\code{\link{mut_matrix}},
\code{\link{fit_to_signatures_strict}},
\code{\link{fit_to_signatures_bootstrapped}}
}
