# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.networkcloud import NetworkCloudMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-networkcloud
# USAGE
    python virtual_machines_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkCloudMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="123e4567-e89b-12d3-a456-426655440000",
    )

    response = client.virtual_machines.begin_create_or_update(
        resource_group_name="resourceGroupName",
        virtual_machine_name="virtualMachineName",
        virtual_machine_parameters={
            "extendedLocation": {
                "name": "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
                "type": "CustomLocation",
            },
            "identity": {
                "type": "UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/userIdentity1": {}
                },
            },
            "location": "location",
            "properties": {
                "adminUsername": "username",
                "bootMethod": "UEFI",
                "cloudServicesNetworkAttachment": {
                    "attachedNetworkId": "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
                    "ipAllocationMethod": "Dynamic",
                },
                "cpuCores": 2,
                "memorySizeGB": 8,
                "networkAttachments": [
                    {
                        "attachedNetworkId": "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
                        "defaultGateway": "True",
                        "ipAllocationMethod": "Dynamic",
                        "ipv4Address": "198.51.100.1",
                        "ipv6Address": "2001:0db8:0000:0000:0000:0000:0000:0000",
                        "networkAttachmentName": "netAttachName01",
                    }
                ],
                "networkDataContent": "bmV0d29ya0RhdGVTYW1wbGU=",
                "placementHints": [
                    {
                        "hintType": "Affinity",
                        "resourceId": "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
                        "schedulingExecution": "Hard",
                        "scope": "",
                    }
                ],
                "sshPublicKeys": [
                    {
                        "keyData": "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"
                    }
                ],
                "storageProfile": {
                    "osDisk": {"createOption": "Ephemeral", "deleteOption": "Delete", "diskSizeGB": 120},
                    "volumeAttachments": [
                        "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName"
                    ],
                },
                "userDataContent": "dXNlckRhdGVTYW1wbGU=",
                "vmDeviceModel": "T2",
                "vmImage": "myacr.azurecr.io/foobar:latest",
                "vmImageRepositoryCredentials": {
                    "password": "{password}",
                    "registryUrl": "myacr.azurecr.io",
                    "username": "myuser",
                },
            },
            "tags": {"key1": "myvalue1", "key2": "myvalue2"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2025-09-01/examples/VirtualMachines_Create.json
if __name__ == "__main__":
    main()
