# Troubleshooting Azure Core

This document provides solutions to common issues you may encounter when using the Azure Core library.

## Continuation Token Compatibility Issues

### Error: "Continuation token from a previous version is not compatible"

**Symptoms:**

You may encounter an error message like:

```
ValueError: This continuation token is not compatible with this version of azure-core. It may have been generated by a previous version.
```

**Cause:**

Starting from azure-core version 1.38.0, the continuation token format was changed. This change was made to improve security and portability. Continuation tokens are opaque strings and their internal format is not guaranteed to be stable across versions.

Continuation tokens generated by previous versions of azure-core are not compatible with version 1.38.0 and later.

**Solution:**

Unfortunately, old continuation tokens cannot be migrated to the new version. You will need to:

1. **Start a new long-running operation**: Instead of using the old continuation token, initiate a new request for your long-running operation.

2. **Check operation status via Azure Portal or CLI**: If you need to check the status of an operation that was started with an old token, you can use the Azure Portal or Azure CLI to check the operation status directly.

3. **Update or pin your dependencies**: Ensure that any new continuation tokens are generated and consumed using the same version of azure-core (1.38.0 or later).

**Prevention:**

To avoid this issue in the future:

- When upgrading azure-core, ensure that any stored continuation tokens are either consumed before the upgrade or discarded.
- Design your application to handle the case where a continuation token may become invalid.

For more information, see the [CHANGELOG](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/CHANGELOG.md) for version 1.38.0.
