# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs.aio import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSDatastoresOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_datastores_list(self, resource_group):
        response = self.client.datastores.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_datastores_get(self, resource_group):
        response = await self.client.datastores.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            datastore_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_datastores_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.datastores.begin_create_or_update(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
                datastore_name="str",
                datastore={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "diskPoolVolume": {"lunName": "str", "targetId": "str", "mountOption": "str", "path": "str"},
                        "elasticSanVolume": {"targetId": "str"},
                        "netAppVolume": {"id": "str"},
                        "provisioningState": "str",
                        "pureStorageVolume": {"sizeGb": 0, "storagePoolId": "str"},
                        "status": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_datastores_begin_delete(self, resource_group):
        response = await (
            await self.client.datastores.begin_delete(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
                datastore_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
