/**********************************************************************
 * $show_all_signals example -- C source code using TF/ACC PLI routines
 *
 * C source to scan through a module and list the names of all nets,
 * regs and variables in the module with the current logic value.  A
 * null argument or no argument is interpreted as the current module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $show_all_nets(<module_instance>?);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ShowSignals2_checktf(),
 *              PLIbook_ShowSignals2_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ShowSignals2_checktf,  /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ShowSignals2_calltf,   /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$show_all_signals2",          /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ShowSignals2_checktf()
{
  acc_initialize();
  if (tf_nump() == 0)
    return(0); /* no arguments is OK, skip remaining checks */
  if (tf_nump() > 1)
    tf_error("$show_all_signals must have 0 or 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    return(0); /* null argument is OK, skip remaining checks */
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$show_all_signals arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ShowSignals2_calltf()
{
  handle module_h, signal_h;
  static int signal_types[6] = {accNet, accReg, accIntegerVar,
                                accTimeVar, accRealVar, 0 };
  acc_initialize();
  if (tf_nump() == 0)
    module_h = acc_handle_scope(acc_handle_tfinst());
  else if (tf_typep(1) == tf_nullparam)
    module_h = acc_handle_scope(acc_handle_tfinst());
  else
    module_h = acc_handle_tfarg(1);
  io_printf("\nAt time %s, signals in module %s (%s):\n",
            tf_strgettime(),
            acc_fetch_fullname(module_h),
            acc_fetch_defname(module_h));
  signal_h = null;    /* start with known value for target handle */
  while (signal_h = acc_next(signal_types, module_h, signal_h)) {
    io_printf("  %-13s %-13s  value is  %s (hex)\n",
              acc_fetch_type_str(acc_fetch_fulltype(signal_h)),
              acc_fetch_name(signal_h),
              acc_fetch_value(signal_h, "%h", null));
  }
  acc_close();
  return(0);
}
/*********************************************************************/

