/**********************************************************************
 * Example vpi_user.c file
 *
 * vpi_user.c file to register PLI applications using the VPI library.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include "vpi_user.h"

/* prototypes of the PLI registration routines */

extern void PLIbook_ShowNets_register(); /* */
extern void PLIbook_ReadVecVal_register(); /* */
extern void PLIbook_ReadStrengthVal_register(); /* */
extern void PLIbook_ReadTimeVal_register(); /* */
extern void PLIbook_RealPow_register(); /* */
extern void PLIbook_ReadAttribute_register(); /* */
extern void PLIbook_ReadDelays_register(); /* */
extern void PLIbook_SetMipd_register(); 

void (*vlog_startup_routines[])() = 
{
  PLIbook_ShowNets_register, /* */
  PLIbook_ReadVecVal_register, /* */
  PLIbook_ReadStrengthVal_register, /* */
  PLIbook_ReadTimeVal_register, /* */
  PLIbook_RealPow_register, /* */
  PLIbook_ReadAttribute_register, /* */
  PLIbook_ReadDelays_register, /* */
  PLIbook_SetMipd_register, 
  0 /*** final entry must be 0 ***/

};
