// Generated by LiveScript 1.6.0
var ref$, id, ref1$, split, join, lines, unlines, words, unwords, chars, unchars, empty, reverse, repeat, capitalize, camelize, dasherize, slice, take, drop, splitAt, takeWhile, dropWhile, span, breakStr, eq, deepEq, ok;
ref$ = require('../..'), id = ref$.id, ref1$ = ref$.Str, split = ref1$.split, join = ref1$.join, lines = ref1$.lines, unlines = ref1$.unlines, words = ref1$.words, unwords = ref1$.unwords, chars = ref1$.chars, unchars = ref1$.unchars, empty = ref1$.empty, reverse = ref1$.reverse, repeat = ref1$.repeat, capitalize = ref1$.capitalize, camelize = ref1$.camelize, dasherize = ref1$.dasherize, slice = ref1$.slice, take = ref1$.take, drop = ref1$.drop, splitAt = ref1$.splitAt, takeWhile = ref1$.takeWhile, dropWhile = ref1$.dropWhile, span = ref1$.span, breakStr = ref1$.breakStr;
ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('split', function(){
  test('empty string as input', function(){
    return deepEq([], split('', ''));
  });
  test('string of some length', function(){
    return deepEq(['1', '2', '3'], split('|', '1|2|3'));
  });
  return test('curried', function(){
    var f;
    f = split('|');
    return deepEq(['1', '2', '3'], f('1|2|3'));
  });
});
suite('join', function(){
  test('empty list as input', function(){
    return eq('', join('', []));
  });
  test('list as input', function(){
    return eq('1,2,3', join(',', [1, 2, 3]));
  });
  test('empty string as seperator', function(){
    return eq('123', join('', [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = join(',');
    return eq('1,2,3', f([1, 2, 3]));
  });
});
suite('lines', function(){
  test('empty string as input', function(){
    return deepEq([], lines(''));
  });
  return test('string as input', function(){
    return deepEq(['one', 'two', 'three'], lines('one\ntwo\nthree'));
  });
});
suite('unlines', function(){
  test('empty array as input', function(){
    return eq('', unlines([]));
  });
  return test('array as input', function(){
    return eq('one\ntwo\nthree', unlines(['one', 'two', 'three']));
  });
});
suite('words', function(){
  test('empty string as input', function(){
    return deepEq([], words(''));
  });
  return test('string as input', function(){
    return deepEq(['what', 'is', 'this'], words('what   is  this'));
  });
});
suite('unwords', function(){
  test('empty array as input', function(){
    return eq('', unwords([]));
  });
  return test('array as input', function(){
    return eq('what is this', unwords(['what', 'is', 'this']));
  });
});
suite('chars', function(){
  test('empty string as input', function(){
    return deepEq([], chars(''));
  });
  return test('string as input', function(){
    return deepEq(['h', 'e', 'l', 'l', 'o'], chars('hello'));
  });
});
suite('unchars', function(){
  test('empty array as input', function(){
    return eq('', unchars([]));
  });
  return test('array as input', function(){
    return eq('there', unchars(['t', 'h', 'e', 'r', 'e']));
  });
});
suite('empty', function(){
  test('empty string as input', function(){
    return ok(empty(''));
  });
  return test('string as input', function(){
    return ok(!empty('a'));
  });
});
suite('reverse', function(){
  test('empty string as input', function(){
    return eq('', reverse(''));
  });
  return test('a string', function(){
    eq('cba', reverse('abc'));
    return eq('olleh', reverse('hello'));
  });
});
suite('repeat', function(){
  test('zero times', function(){
    return eq('', repeat(0, 'hi'));
  });
  test('empty string as input', function(){
    return eq('', repeat(2, ''));
  });
  test('a string several times', function(){
    eq('aa', repeat(2, 'a'));
    eq('hihihi', repeat(3, 'hi'));
    return eq('hihihihihihihihihihi', repeat(10, 'hi'));
  });
  return test('curried', function(){
    var f;
    f = repeat(2);
    return eq('aa', f('a'));
  });
});
suite('capitalize', function(){
  test('empty string as input', function(){
    return eq('', capitalize(''));
  });
  return test('basic', function(){
    return eq('Foo', capitalize('foo'));
  });
});
suite('camelize', function(){
  test('empty string as input', function(){
    return eq('', camelize(''));
  });
  test('no change', function(){
    return eq('fooBar', camelize('fooBar'));
  });
  test('dashes', function(){
    return eq('fooBar', camelize('foo-bar'));
  });
  test('underscore', function(){
    return eq('fooBar', camelize('foo_bar'));
  });
  test('ending dash', function(){
    return eq('fooBar', camelize('foo-bar-'));
  });
  return test('more than one', function(){
    return eq('fooBar', camelize('foo--bar'));
  });
});
suite('dasherize', function(){
  test('empty string as input', function(){
    return eq('', dasherize(''));
  });
  test('no change', function(){
    return eq('foo-bar', dasherize('foo-bar'));
  });
  test('basic', function(){
    return eq('foo-bar', dasherize('fooBar'));
  });
  test('with numbers', function(){
    return eq('f1-bar', dasherize('f1Bar'));
  });
  test('repeated capitals', function(){
    return eq('set-JSON', dasherize('setJSON'));
  });
  test('starting with capital', function(){
    return eq('foo-bar', dasherize('FooBar'));
  });
  return test('starting with repeated capitals', function(){
    return eq('JSON-get', dasherize('JSONget'));
  });
});
suite('slice', function(){
  test('zero to zero', function(){
    return eq('', slice(0, 0, 'hello'));
  });
  test('empty string as input', function(){
    return eq('', slice(2, 3, ''));
  });
  test('parts', function(){
    return eq('ll', slice(2, 4, 'hello'));
  });
  return test('curried', function(){
    var f, g;
    f = slice(2);
    eq('ll', f(4, 'hello'));
    g = slice(2, 4);
    return eq('ll', g('hello'));
  });
});
suite('take', function(){
  test('empty string as input', function(){
    return eq('', take(3, ''));
  });
  test('zero on string', function(){
    return eq('', take(0, 'abcde'));
  });
  test('string', function(){
    return eq('ab', take(2, 'abcde'));
  });
  return test('curried', function(){
    var f;
    f = take(2);
    return eq('ab', f('abcde'));
  });
});
suite('drop', function(){
  test('empty string as input', function(){
    return eq('', drop(3, ''));
  });
  test('zero on string', function(){
    return eq('abcde', drop(0, 'abcde'));
  });
  test('string', function(){
    return eq('cde', drop(2, 'abcde'));
  });
  return test('curried', function(){
    var f;
    f = drop(2);
    return eq('cde', f('abcde'));
  });
});
suite('split-at', function(){
  test('empty string as input', function(){
    return deepEq(['', ''], splitAt(3, ''));
  });
  test('zero on string', function(){
    return deepEq(['', 'abcde'], splitAt(0, 'abcde'));
  });
  test('string', function(){
    return deepEq(['ab', 'cde'], splitAt(2, 'abcde'));
  });
  return test('curried', function(){
    var f;
    f = splitAt(2);
    return deepEq(['ab', 'cde'], f('abcde'));
  });
});
suite('take-while', function(){
  test('empty string as input', function(){
    return eq('', takeWhile(id, ''));
  });
  test('string', function(){
    return eq('mmmmm', takeWhile((function(it){
      return it === 'm';
    }), 'mmmmmhmm'));
  });
  return test('curried', function(){
    var f;
    f = takeWhile((function(it){
      return it === 'm';
    }));
    return eq('mmmmm', f('mmmmmhmm'));
  });
});
suite('drop-while', function(){
  test('empty string as input', function(){
    return eq('', dropWhile(id, ''));
  });
  test('string', function(){
    return eq('hmm', dropWhile((function(it){
      return it === 'm';
    }), 'mmmmmhmm'));
  });
  return test('curried', function(){
    var f;
    f = dropWhile((function(it){
      return it === 'm';
    }));
    return eq('hmm', f('mmmmmhmm'));
  });
});
suite('span', function(){
  test('empty string as input', function(){
    return deepEq(['', ''], span(id, ''));
  });
  test('string', function(){
    return deepEq(['mmmmm', 'hmm'], span((function(it){
      return it === 'm';
    }), 'mmmmmhmm'));
  });
  return test('curried', function(){
    var f;
    f = span((function(it){
      return it === 'm';
    }));
    return deepEq(['mmmmm', 'hmm'], f('mmmmmhmm'));
  });
});
suite('break-str', function(){
  test('empty string as input', function(){
    return deepEq(['', ''], breakStr(id, ''));
  });
  test('string', function(){
    return deepEq(['mmmmm', 'hmm'], breakStr((function(it){
      return it === 'h';
    }), 'mmmmmhmm'));
  });
  return test('curried', function(){
    var f;
    f = breakStr((function(it){
      return it === 'h';
    }));
    return deepEq(['mmmmm', 'hmm'], f('mmmmmhmm'));
  });
});
