#ifndef DNOTIFY_STATE_H
#define DNOTIFY_STATE_H

#include <map>
#include <memory>
#include <set>
#include <string>

#include "open_file.h"
#include "watcher.h"

class dnotify_state
{
  public:
	dnotify_state(const char* base_path);
	~dnotify_state();

	const std::string base_path;

	// NOTE: to detect multiple paths to base_path, state requires
	// that add_base_watcher() be called before add_imap_watcher()
	void add_base_watcher(int fd, watcher* w);
	void add_imap_watcher(int fd, const std::string& imap_name, watcher* w);

	void remove_base_watcher(int fd);
	void remove_imap_watcher(int fd, const std::string& imap_name);

	watcher* get_watcher_by_fd(int fd);
	watcher* get_imap_watcher(const std::string& imap_name);

  private:
	std::map<int, watcher*> watchers; // fd -> watcher
	std::map<std::string, watcher*> imap2watcher; // imap name -> watcher

	// Multiple paths caused by symlink detection
	std::set<open_file> open_files;

	// Multiple paths to INBOX maildir watcher detection
	// (special case because base_path has two watchers, base and maildir)
	std::auto_ptr<open_file> base_path_file;
	int base_path_fd;
	bool base_path_maildir_watch;

	void remove_watcher(int fd);
};

// tell dnotify to watch 'fd'
void set_fd_watch(int fd, long notify_flags, const char* name);

#endif // #define DNOTIFY_STATE_H
