; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV64

define void @cttz_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v16i8:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -32
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a2, a1, a2
; LMULMAX2-RV32-NEXT:    srli a3, a2, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a6, a1, 1365
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    sub a3, a2, a3
; LMULMAX2-RV32-NEXT:    lui a2, 209715
; LMULMAX2-RV32-NEXT:    addi a2, a2, 819
; LMULMAX2-RV32-NEXT:    and a4, a3, a2
; LMULMAX2-RV32-NEXT:    srli a3, a3, 2
; LMULMAX2-RV32-NEXT:    and a3, a3, a2
; LMULMAX2-RV32-NEXT:    add a3, a4, a3
; LMULMAX2-RV32-NEXT:    srli a4, a3, 4
; LMULMAX2-RV32-NEXT:    add a4, a3, a4
; LMULMAX2-RV32-NEXT:    lui a3, 61681
; LMULMAX2-RV32-NEXT:    addi a3, a3, -241
; LMULMAX2-RV32-NEXT:    and a5, a4, a3
; LMULMAX2-RV32-NEXT:    lui a4, 4112
; LMULMAX2-RV32-NEXT:    addi a4, a4, 257
; LMULMAX2-RV32-NEXT:    mul a5, a5, a4
; LMULMAX2-RV32-NEXT:    srli a5, a5, 24
; LMULMAX2-RV32-NEXT:    sb a5, 16(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v26
; LMULMAX2-RV32-NEXT:    ori a5, a5, 256
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 31(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 30(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 29(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 27(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 26(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 25(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 24(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 23(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 22(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 21(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 20(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 19(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 18(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 17(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 16
; LMULMAX2-RV32-NEXT:    vle8.v v25, (a1)
; LMULMAX2-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 32
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v16i8:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -32
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a2, a1, a2
; LMULMAX2-RV64-NEXT:    srli a3, a2, 1
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a6, a1, 1365
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a3, a2, a3
; LMULMAX2-RV64-NEXT:    lui a2, 13107
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    and a4, a3, a2
; LMULMAX2-RV64-NEXT:    srli a3, a3, 2
; LMULMAX2-RV64-NEXT:    and a3, a3, a2
; LMULMAX2-RV64-NEXT:    add a3, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 4
; LMULMAX2-RV64-NEXT:    add a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 3855
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 241
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, -241
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 241
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, -241
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    lui a4, 4112
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 257
; LMULMAX2-RV64-NEXT:    slli a4, a4, 16
; LMULMAX2-RV64-NEXT:    addi a4, a4, 257
; LMULMAX2-RV64-NEXT:    slli a4, a4, 16
; LMULMAX2-RV64-NEXT:    addi a4, a4, 257
; LMULMAX2-RV64-NEXT:    mul a5, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a5, 56
; LMULMAX2-RV64-NEXT:    sb a5, 31(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX2-RV64-NEXT:    vmv.x.s a5, v26
; LMULMAX2-RV64-NEXT:    ori a5, a5, 256
; LMULMAX2-RV64-NEXT:    addi a1, a5, -1
; LMULMAX2-RV64-NEXT:    not a5, a5
; LMULMAX2-RV64-NEXT:    and a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 30(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 29(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 28(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 27(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 26(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 25(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 23(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 22(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 21(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 20(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 19(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 18(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a5, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 17(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a5, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a5, a1, 1
; LMULMAX2-RV64-NEXT:    and a5, a5, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a5
; LMULMAX2-RV64-NEXT:    and a5, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a5, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    mul a1, a1, a4
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 16(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 16
; LMULMAX2-RV64-NEXT:    vle8.v v25, (a1)
; LMULMAX2-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, sp, 32
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v16i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a2, a1, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a6, a1, 1365
; LMULMAX1-RV32-NEXT:    and a3, a3, a6
; LMULMAX1-RV32-NEXT:    sub a3, a2, a3
; LMULMAX1-RV32-NEXT:    lui a2, 209715
; LMULMAX1-RV32-NEXT:    addi a2, a2, 819
; LMULMAX1-RV32-NEXT:    and a4, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a3, 2
; LMULMAX1-RV32-NEXT:    and a3, a3, a2
; LMULMAX1-RV32-NEXT:    add a3, a4, a3
; LMULMAX1-RV32-NEXT:    srli a4, a3, 4
; LMULMAX1-RV32-NEXT:    add a4, a3, a4
; LMULMAX1-RV32-NEXT:    lui a3, 61681
; LMULMAX1-RV32-NEXT:    addi a3, a3, -241
; LMULMAX1-RV32-NEXT:    and a5, a4, a3
; LMULMAX1-RV32-NEXT:    lui a4, 4112
; LMULMAX1-RV32-NEXT:    addi a4, a4, 257
; LMULMAX1-RV32-NEXT:    mul a5, a5, a4
; LMULMAX1-RV32-NEXT:    srli a5, a5, 24
; LMULMAX1-RV32-NEXT:    sb a5, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX1-RV32-NEXT:    vmv.x.s a5, v26
; LMULMAX1-RV32-NEXT:    ori a5, a5, 256
; LMULMAX1-RV32-NEXT:    addi a1, a5, -1
; LMULMAX1-RV32-NEXT:    not a5, a5
; LMULMAX1-RV32-NEXT:    and a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 31(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 30(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 29(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 27(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 26(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 25(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 23(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 22(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 21(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 19(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 18(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    mul a1, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 17(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v16i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -32
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a2, a1, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    lui a1, 21845
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a6, a1, 1365
; LMULMAX1-RV64-NEXT:    and a3, a3, a6
; LMULMAX1-RV64-NEXT:    sub a3, a2, a3
; LMULMAX1-RV64-NEXT:    lui a2, 13107
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    and a4, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a3, 2
; LMULMAX1-RV64-NEXT:    and a3, a3, a2
; LMULMAX1-RV64-NEXT:    add a3, a4, a3
; LMULMAX1-RV64-NEXT:    srli a4, a3, 4
; LMULMAX1-RV64-NEXT:    add a4, a3, a4
; LMULMAX1-RV64-NEXT:    lui a3, 3855
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 241
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, -241
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 241
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, -241
; LMULMAX1-RV64-NEXT:    and a5, a4, a3
; LMULMAX1-RV64-NEXT:    lui a4, 4112
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 257
; LMULMAX1-RV64-NEXT:    slli a4, a4, 16
; LMULMAX1-RV64-NEXT:    addi a4, a4, 257
; LMULMAX1-RV64-NEXT:    slli a4, a4, 16
; LMULMAX1-RV64-NEXT:    addi a4, a4, 257
; LMULMAX1-RV64-NEXT:    mul a5, a5, a4
; LMULMAX1-RV64-NEXT:    srli a5, a5, 56
; LMULMAX1-RV64-NEXT:    sb a5, 31(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX1-RV64-NEXT:    vmv.x.s a5, v26
; LMULMAX1-RV64-NEXT:    ori a5, a5, 256
; LMULMAX1-RV64-NEXT:    addi a1, a5, -1
; LMULMAX1-RV64-NEXT:    not a5, a5
; LMULMAX1-RV64-NEXT:    and a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 30(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 29(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 27(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 26(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 25(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 23(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 22(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 21(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 20(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 19(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 18(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 17(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a5, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a5, a1, 1
; LMULMAX1-RV64-NEXT:    and a5, a5, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a5
; LMULMAX1-RV64-NEXT:    and a5, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    mul a1, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 32
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}
declare <16 x i8> @llvm.cttz.v16i8(<16 x i8>, i1)

define void @cttz_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v8i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -32
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX2-RV32-NEXT:    lui a6, 16
; LMULMAX2-RV32-NEXT:    or a2, a2, a6
; LMULMAX2-RV32-NEXT:    addi a3, a2, -1
; LMULMAX2-RV32-NEXT:    not a2, a2
; LMULMAX2-RV32-NEXT:    and a3, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a3, 1
; LMULMAX2-RV32-NEXT:    lui a2, 349525
; LMULMAX2-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV32-NEXT:    and a4, a4, a7
; LMULMAX2-RV32-NEXT:    sub a4, a3, a4
; LMULMAX2-RV32-NEXT:    lui a3, 209715
; LMULMAX2-RV32-NEXT:    addi a3, a3, 819
; LMULMAX2-RV32-NEXT:    and a5, a4, a3
; LMULMAX2-RV32-NEXT:    srli a4, a4, 2
; LMULMAX2-RV32-NEXT:    and a4, a4, a3
; LMULMAX2-RV32-NEXT:    add a4, a5, a4
; LMULMAX2-RV32-NEXT:    srli a5, a4, 4
; LMULMAX2-RV32-NEXT:    add a5, a4, a5
; LMULMAX2-RV32-NEXT:    lui a4, 61681
; LMULMAX2-RV32-NEXT:    addi a4, a4, -241
; LMULMAX2-RV32-NEXT:    and a1, a5, a4
; LMULMAX2-RV32-NEXT:    lui a5, 4112
; LMULMAX2-RV32-NEXT:    addi a5, a5, 257
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 16(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 30(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 26(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 24(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 22(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 20(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 18(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 16
; LMULMAX2-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX2-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 32
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v8i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -32
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV64-NEXT:    lui a6, 16
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a3, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a3, a2, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 1
; LMULMAX2-RV64-NEXT:    lui a2, 21845
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 13107
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a4, 2
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    add a4, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a4, 4
; LMULMAX2-RV64-NEXT:    add a5, a4, a5
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a1, a5, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 30(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 28(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 26(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 22(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 20(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 18(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 16(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 16
; LMULMAX2-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX2-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, sp, 32
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    lui a6, 16
; LMULMAX1-RV32-NEXT:    or a2, a2, a6
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a3, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a3, 1
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV32-NEXT:    and a4, a4, a7
; LMULMAX1-RV32-NEXT:    sub a4, a3, a4
; LMULMAX1-RV32-NEXT:    lui a3, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    and a5, a4, a3
; LMULMAX1-RV32-NEXT:    srli a4, a4, 2
; LMULMAX1-RV32-NEXT:    and a4, a4, a3
; LMULMAX1-RV32-NEXT:    add a4, a5, a4
; LMULMAX1-RV32-NEXT:    srli a5, a4, 4
; LMULMAX1-RV32-NEXT:    add a5, a4, a5
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    and a1, a5, a4
; LMULMAX1-RV32-NEXT:    lui a5, 4112
; LMULMAX1-RV32-NEXT:    addi a5, a5, 257
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 30(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 26(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 22(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    or a1, a1, a6
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 18(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -32
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    lui a6, 16
; LMULMAX1-RV64-NEXT:    or a2, a2, a6
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a3, a2, a3
; LMULMAX1-RV64-NEXT:    srli a4, a3, 1
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a4, a3, a4
; LMULMAX1-RV64-NEXT:    lui a3, 13107
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    and a5, a4, a3
; LMULMAX1-RV64-NEXT:    srli a4, a4, 2
; LMULMAX1-RV64-NEXT:    and a4, a4, a3
; LMULMAX1-RV64-NEXT:    add a4, a5, a4
; LMULMAX1-RV64-NEXT:    srli a5, a4, 4
; LMULMAX1-RV64-NEXT:    add a5, a4, a5
; LMULMAX1-RV64-NEXT:    lui a4, 3855
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    and a1, a5, a4
; LMULMAX1-RV64-NEXT:    lui a5, 4112
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 30(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 26(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 22(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 20(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 18(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    or a1, a1, a6
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 32
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}
declare <8 x i16> @llvm.cttz.v8i16(<8 x i16>, i1)

define void @cttz_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v4i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -32
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    lui a3, 349525
; LMULMAX2-RV32-NEXT:    addi a6, a3, 1365
; LMULMAX2-RV32-NEXT:    and a2, a2, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    lui a2, 209715
; LMULMAX2-RV32-NEXT:    addi a2, a2, 819
; LMULMAX2-RV32-NEXT:    and a4, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a4, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a4
; LMULMAX2-RV32-NEXT:    lui a4, 61681
; LMULMAX2-RV32-NEXT:    addi a4, a4, -241
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    lui a5, 4112
; LMULMAX2-RV32-NEXT:    addi a5, a5, 257
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a3, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    srli a3, a1, 1
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a3, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a3, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a3, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    srli a3, a1, 1
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a3, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a3, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    addi a3, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    srli a3, a1, 1
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a3, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a3, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 20(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 16
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX2-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 32
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v4i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -32
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV64-NEXT:    addi a1, zero, 1
; LMULMAX2-RV64-NEXT:    slli a6, a1, 32
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a3, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a3, a2, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 1
; LMULMAX2-RV64-NEXT:    lui a2, 21845
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 13107
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a4, 2
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    add a4, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a4, 4
; LMULMAX2-RV64-NEXT:    add a4, a4, a5
; LMULMAX2-RV64-NEXT:    lui a5, 3855
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 241
; LMULMAX2-RV64-NEXT:    slli a5, a5, 12
; LMULMAX2-RV64-NEXT:    addi a5, a5, -241
; LMULMAX2-RV64-NEXT:    slli a5, a5, 12
; LMULMAX2-RV64-NEXT:    addi a5, a5, 241
; LMULMAX2-RV64-NEXT:    slli a5, a5, 12
; LMULMAX2-RV64-NEXT:    addi a5, a5, -241
; LMULMAX2-RV64-NEXT:    and a4, a4, a5
; LMULMAX2-RV64-NEXT:    lui a1, 4112
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    mul a4, a4, a1
; LMULMAX2-RV64-NEXT:    srli a4, a4, 56
; LMULMAX2-RV64-NEXT:    sw a4, 28(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a4, v26
; LMULMAX2-RV64-NEXT:    or a4, a4, a6
; LMULMAX2-RV64-NEXT:    addi a2, a4, -1
; LMULMAX2-RV64-NEXT:    not a4, a4
; LMULMAX2-RV64-NEXT:    and a2, a4, a2
; LMULMAX2-RV64-NEXT:    srli a4, a2, 1
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a2, a2, a4
; LMULMAX2-RV64-NEXT:    and a4, a2, a3
; LMULMAX2-RV64-NEXT:    srli a2, a2, 2
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    add a2, a4, a2
; LMULMAX2-RV64-NEXT:    srli a4, a2, 4
; LMULMAX2-RV64-NEXT:    add a2, a2, a4
; LMULMAX2-RV64-NEXT:    and a2, a2, a5
; LMULMAX2-RV64-NEXT:    mul a2, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a2, 56
; LMULMAX2-RV64-NEXT:    sw a2, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a4, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a2, 1
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a2, a2, a4
; LMULMAX2-RV64-NEXT:    and a4, a2, a3
; LMULMAX2-RV64-NEXT:    srli a2, a2, 2
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    add a2, a4, a2
; LMULMAX2-RV64-NEXT:    srli a4, a2, 4
; LMULMAX2-RV64-NEXT:    add a2, a2, a4
; LMULMAX2-RV64-NEXT:    and a2, a2, a5
; LMULMAX2-RV64-NEXT:    mul a2, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a2, 56
; LMULMAX2-RV64-NEXT:    sw a2, 20(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a4, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a2, 1
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a2, a2, a4
; LMULMAX2-RV64-NEXT:    and a4, a2, a3
; LMULMAX2-RV64-NEXT:    srli a2, a2, 2
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    add a2, a4, a2
; LMULMAX2-RV64-NEXT:    srli a3, a2, 4
; LMULMAX2-RV64-NEXT:    add a2, a2, a3
; LMULMAX2-RV64-NEXT:    and a2, a2, a5
; LMULMAX2-RV64-NEXT:    mul a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 16(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 16
; LMULMAX2-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX2-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, sp, 32
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    lui a3, 349525
; LMULMAX1-RV32-NEXT:    addi a6, a3, 1365
; LMULMAX1-RV32-NEXT:    and a2, a2, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    lui a2, 209715
; LMULMAX1-RV32-NEXT:    addi a2, a2, 819
; LMULMAX1-RV32-NEXT:    and a4, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a4, a1
; LMULMAX1-RV32-NEXT:    srli a4, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a4
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    lui a5, 4112
; LMULMAX1-RV32-NEXT:    addi a5, a5, 257
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a3, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a3, a1, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a3, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a3, a1
; LMULMAX1-RV32-NEXT:    srli a3, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a3, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a3, a1, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a3, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a3, a1
; LMULMAX1-RV32-NEXT:    srli a3, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a3, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a3, a1, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, a6
; LMULMAX1-RV32-NEXT:    sub a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a3, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    add a1, a3, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -32
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    addi a1, zero, 1
; LMULMAX1-RV64-NEXT:    slli a6, a1, 32
; LMULMAX1-RV64-NEXT:    or a2, a2, a6
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a3, a2, a3
; LMULMAX1-RV64-NEXT:    srli a4, a3, 1
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a4, a3, a4
; LMULMAX1-RV64-NEXT:    lui a3, 13107
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    and a5, a4, a3
; LMULMAX1-RV64-NEXT:    srli a4, a4, 2
; LMULMAX1-RV64-NEXT:    and a4, a4, a3
; LMULMAX1-RV64-NEXT:    add a4, a5, a4
; LMULMAX1-RV64-NEXT:    srli a5, a4, 4
; LMULMAX1-RV64-NEXT:    add a4, a4, a5
; LMULMAX1-RV64-NEXT:    lui a5, 3855
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    and a4, a4, a5
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    mul a4, a4, a1
; LMULMAX1-RV64-NEXT:    srli a4, a4, 56
; LMULMAX1-RV64-NEXT:    sw a4, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV64-NEXT:    or a4, a4, a6
; LMULMAX1-RV64-NEXT:    addi a2, a4, -1
; LMULMAX1-RV64-NEXT:    not a4, a4
; LMULMAX1-RV64-NEXT:    and a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a6
; LMULMAX1-RV64-NEXT:    addi a4, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 20(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    or a2, a2, a6
; LMULMAX1-RV64-NEXT:    addi a4, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 32
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}
declare <4 x i32> @llvm.cttz.v4i32(<4 x i32>, i1)

define void @cttz_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v2i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -32
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    sw zero, 28(sp)
; LMULMAX2-RV32-NEXT:    sw zero, 20(sp)
; LMULMAX2-RV32-NEXT:    addi a6, zero, 32
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a4, a1, 1365
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a3, a1, 819
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a7, a1, -241
; LMULMAX2-RV32-NEXT:    lui a2, 4112
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v25
; LMULMAX2-RV32-NEXT:    addi a2, a2, 257
; LMULMAX2-RV32-NEXT:    bnez a5, .LBB3_2
; LMULMAX2-RV32-NEXT:  # %bb.1:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v25, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a5, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB3_3
; LMULMAX2-RV32-NEXT:  .LBB3_2:
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a5, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB3_3:
; LMULMAX2-RV32-NEXT:    sw a5, 16(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v25
; LMULMAX2-RV32-NEXT:    bnez a5, .LBB3_5
; LMULMAX2-RV32-NEXT:  # %bb.4:
; LMULMAX2-RV32-NEXT:    vsrl.vx v25, v25, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a4, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a4
; LMULMAX2-RV32-NEXT:    and a4, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a1, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB3_6
; LMULMAX2-RV32-NEXT:  .LBB3_5:
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a4, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a4
; LMULMAX2-RV32-NEXT:    and a4, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB3_6:
; LMULMAX2-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 16
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 32
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v2i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    lui a3, 21845
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 1365
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a6, a3, 1365
; LMULMAX2-RV64-NEXT:    and a2, a2, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    lui a2, 13107
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    and a4, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a4, a1
; LMULMAX2-RV64-NEXT:    srli a4, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a4
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    addi a3, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    srli a3, a1, 1
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a3, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a3, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v26, a1
; LMULMAX2-RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    sw zero, 28(sp)
; LMULMAX1-RV32-NEXT:    sw zero, 20(sp)
; LMULMAX1-RV32-NEXT:    addi a6, zero, 32
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a4, a1, 1365
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a1, 819
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a7, a1, -241
; LMULMAX1-RV32-NEXT:    lui a2, 4112
; LMULMAX1-RV32-NEXT:    vmv.x.s a5, v25
; LMULMAX1-RV32-NEXT:    addi a2, a2, 257
; LMULMAX1-RV32-NEXT:    bnez a5, .LBB3_2
; LMULMAX1-RV32-NEXT:  # %bb.1:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v25, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a4
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a7
; LMULMAX1-RV32-NEXT:    mul a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a5, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB3_3
; LMULMAX1-RV32-NEXT:  .LBB3_2:
; LMULMAX1-RV32-NEXT:    addi a1, a5, -1
; LMULMAX1-RV32-NEXT:    not a5, a5
; LMULMAX1-RV32-NEXT:    and a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a5, a5, a4
; LMULMAX1-RV32-NEXT:    sub a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a5, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    and a1, a1, a7
; LMULMAX1-RV32-NEXT:    mul a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB3_3:
; LMULMAX1-RV32-NEXT:    sw a5, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a5, v25
; LMULMAX1-RV32-NEXT:    bnez a5, .LBB3_5
; LMULMAX1-RV32-NEXT:  # %bb.4:
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a5, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a4, a5, a4
; LMULMAX1-RV32-NEXT:    sub a1, a1, a4
; LMULMAX1-RV32-NEXT:    and a4, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a4, a1
; LMULMAX1-RV32-NEXT:    srli a3, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a1, a1, a7
; LMULMAX1-RV32-NEXT:    mul a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a1, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB3_6
; LMULMAX1-RV32-NEXT:  .LBB3_5:
; LMULMAX1-RV32-NEXT:    addi a1, a5, -1
; LMULMAX1-RV32-NEXT:    not a5, a5
; LMULMAX1-RV32-NEXT:    and a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 1
; LMULMAX1-RV32-NEXT:    and a4, a5, a4
; LMULMAX1-RV32-NEXT:    sub a1, a1, a4
; LMULMAX1-RV32-NEXT:    and a4, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a4, a1
; LMULMAX1-RV32-NEXT:    srli a3, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a3
; LMULMAX1-RV32-NEXT:    and a1, a1, a7
; LMULMAX1-RV32-NEXT:    mul a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB3_6:
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    lui a3, 21845
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a6, a3, 1365
; LMULMAX1-RV64-NEXT:    and a2, a2, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    lui a2, 13107
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    and a4, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a4, a1
; LMULMAX1-RV64-NEXT:    srli a4, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a4
; LMULMAX1-RV64-NEXT:    lui a4, 3855
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    lui a5, 4112
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    addi a3, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    srli a3, a1, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, a6
; LMULMAX1-RV64-NEXT:    sub a1, a1, a3
; LMULMAX1-RV64-NEXT:    and a3, a1, a2
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    add a1, a3, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; LMULMAX1-RV64-NEXT:    vmv.s.x v26, a1
; LMULMAX1-RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}
declare <2 x i64> @llvm.cttz.v2i64(<2 x i64>, i1)

define void @cttz_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v32i8:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV32-NEXT:    sw ra, 92(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 88(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    addi a6, zero, 32
; LMULMAX2-RV32-NEXT:    vsetvli zero, a6, e8, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV32-NEXT:    ori a2, a2, 256
; LMULMAX2-RV32-NEXT:    addi a3, a2, -1
; LMULMAX2-RV32-NEXT:    not a2, a2
; LMULMAX2-RV32-NEXT:    and a3, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a3, 1
; LMULMAX2-RV32-NEXT:    lui a2, 349525
; LMULMAX2-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV32-NEXT:    and a4, a4, a7
; LMULMAX2-RV32-NEXT:    sub a4, a3, a4
; LMULMAX2-RV32-NEXT:    lui a3, 209715
; LMULMAX2-RV32-NEXT:    addi a3, a3, 819
; LMULMAX2-RV32-NEXT:    and a5, a4, a3
; LMULMAX2-RV32-NEXT:    srli a4, a4, 2
; LMULMAX2-RV32-NEXT:    and a4, a4, a3
; LMULMAX2-RV32-NEXT:    add a4, a5, a4
; LMULMAX2-RV32-NEXT:    srli a5, a4, 4
; LMULMAX2-RV32-NEXT:    add a5, a4, a5
; LMULMAX2-RV32-NEXT:    lui a4, 61681
; LMULMAX2-RV32-NEXT:    addi a4, a4, -241
; LMULMAX2-RV32-NEXT:    and a1, a5, a4
; LMULMAX2-RV32-NEXT:    lui a5, 4112
; LMULMAX2-RV32-NEXT:    addi a5, a5, 257
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 32(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e8, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 31
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 63(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 30
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 62(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 29
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 61(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 28
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 60(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 27
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 59(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 26
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 58(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 25
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 57(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 24
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 56(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 23
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 55(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 22
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 54(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 21
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 53(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 20
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 52(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 19
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 51(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 18
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 50(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 17
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 49(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 16
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 48(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 47(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 46(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 45(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 44(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 43(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 42(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 41(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 40(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 39(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 38(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 37(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 36(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 35(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 34(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    ori a1, a1, 256
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sb a1, 33(sp)
; LMULMAX2-RV32-NEXT:    vsetvli zero, a6, e8, m2, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 32
; LMULMAX2-RV32-NEXT:    vle8.v v26, (a1)
; LMULMAX2-RV32-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -96
; LMULMAX2-RV32-NEXT:    lw s0, 88(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 92(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 96
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v32i8:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV64-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    addi a6, zero, 32
; LMULMAX2-RV64-NEXT:    vsetvli zero, a6, e8, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e8, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 31
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v28
; LMULMAX2-RV64-NEXT:    ori a2, a2, 256
; LMULMAX2-RV64-NEXT:    addi a3, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a3, a2, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 1
; LMULMAX2-RV64-NEXT:    lui a2, 21845
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 13107
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a4, 2
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    add a4, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a4, 4
; LMULMAX2-RV64-NEXT:    add a5, a4, a5
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a1, a5, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 63(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 30
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 62(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 29
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 61(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 28
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 60(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 27
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 59(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 26
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 58(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 25
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 57(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 24
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 56(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 23
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 55(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 22
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 54(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 21
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 53(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 20
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 52(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 19
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 51(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 18
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 50(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 17
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 49(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 16
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 48(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 47(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 46(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 45(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 44(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 43(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 42(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 41(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 40(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 39(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 38(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 37(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 36(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 35(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 34(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 33(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    ori a1, a1, 256
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sb a1, 32(sp)
; LMULMAX2-RV64-NEXT:    vsetvli zero, a6, e8, m2, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 32
; LMULMAX2-RV64-NEXT:    vle8.v v26, (a1)
; LMULMAX2-RV64-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -96
; LMULMAX2-RV64-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 96
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -48
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a6)
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    ori a2, a2, 256
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a3, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a3, 1
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV32-NEXT:    and a4, a4, a7
; LMULMAX1-RV32-NEXT:    sub a4, a3, a4
; LMULMAX1-RV32-NEXT:    lui a3, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    and a5, a4, a3
; LMULMAX1-RV32-NEXT:    srli a4, a4, 2
; LMULMAX1-RV32-NEXT:    and a4, a4, a3
; LMULMAX1-RV32-NEXT:    add a4, a5, a4
; LMULMAX1-RV32-NEXT:    srli a5, a4, 4
; LMULMAX1-RV32-NEXT:    add a5, a4, a5
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    and a1, a5, a4
; LMULMAX1-RV32-NEXT:    lui a5, 4112
; LMULMAX1-RV32-NEXT:    addi a5, a5, 257
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 32(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 15
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 47(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 14
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 46(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 13
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 45(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 12
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 44(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 11
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 43(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 10
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 42(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 9
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 41(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 8
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 40(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 39(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 38(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 37(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 36(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 35(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 34(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 33(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 31(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 30(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 29(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 27(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 26(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 25(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 23(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 22(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 21(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 19(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 18(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    ori a1, a1, 256
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sb a1, 17(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 32
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a6)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 48
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -48
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    ori a2, a2, 256
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a3, a2, a3
; LMULMAX1-RV64-NEXT:    srli a4, a3, 1
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a4, a3, a4
; LMULMAX1-RV64-NEXT:    lui a3, 13107
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    and a5, a4, a3
; LMULMAX1-RV64-NEXT:    srli a4, a4, 2
; LMULMAX1-RV64-NEXT:    and a4, a4, a3
; LMULMAX1-RV64-NEXT:    add a4, a5, a4
; LMULMAX1-RV64-NEXT:    srli a5, a4, 4
; LMULMAX1-RV64-NEXT:    add a5, a4, a5
; LMULMAX1-RV64-NEXT:    lui a4, 3855
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    and a1, a5, a4
; LMULMAX1-RV64-NEXT:    lui a5, 4112
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 32(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 15
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 47(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 14
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 46(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 13
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 45(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 12
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 44(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 11
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 43(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 10
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 42(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 9
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 41(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 8
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 40(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 39(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 38(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 37(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 36(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 35(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 34(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 33(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 15
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 31(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 14
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 30(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 13
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 29(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 12
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 11
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 27(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 10
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 26(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 9
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 25(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 8
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 23(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 22(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 21(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 20(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 19(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 18(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 17(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    ori a1, a1, 256
; LMULMAX1-RV64-NEXT:    addi a2, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a2
; LMULMAX1-RV64-NEXT:    srli a2, a1, 1
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    sub a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a2, a1, a3
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    add a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    mul a1, a1, a5
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sb a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, sp, 32
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a6)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 48
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}
declare <32 x i8> @llvm.cttz.v32i8(<32 x i8>, i1)

define void @cttz_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV32-NEXT:    sw ra, 92(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 88(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV32-NEXT:    lui a6, 16
; LMULMAX2-RV32-NEXT:    or a2, a2, a6
; LMULMAX2-RV32-NEXT:    addi a3, a2, -1
; LMULMAX2-RV32-NEXT:    not a2, a2
; LMULMAX2-RV32-NEXT:    and a3, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a3, 1
; LMULMAX2-RV32-NEXT:    lui a2, 349525
; LMULMAX2-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV32-NEXT:    and a4, a4, a7
; LMULMAX2-RV32-NEXT:    sub a4, a3, a4
; LMULMAX2-RV32-NEXT:    lui a3, 209715
; LMULMAX2-RV32-NEXT:    addi a3, a3, 819
; LMULMAX2-RV32-NEXT:    and a5, a4, a3
; LMULMAX2-RV32-NEXT:    srli a4, a4, 2
; LMULMAX2-RV32-NEXT:    and a4, a4, a3
; LMULMAX2-RV32-NEXT:    add a4, a5, a4
; LMULMAX2-RV32-NEXT:    srli a5, a4, 4
; LMULMAX2-RV32-NEXT:    add a5, a4, a5
; LMULMAX2-RV32-NEXT:    lui a4, 61681
; LMULMAX2-RV32-NEXT:    addi a4, a4, -241
; LMULMAX2-RV32-NEXT:    and a1, a5, a4
; LMULMAX2-RV32-NEXT:    lui a5, 4112
; LMULMAX2-RV32-NEXT:    addi a5, a5, 257
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 32(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e16, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 62(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 60(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 58(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 56(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 54(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 52(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 50(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 48(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 46(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 44(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 42(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 40(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 38(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 36(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    or a1, a1, a6
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a2, a1, 1
; LMULMAX2-RV32-NEXT:    and a2, a2, a7
; LMULMAX2-RV32-NEXT:    sub a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a2, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a2, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a4
; LMULMAX2-RV32-NEXT:    mul a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sh a1, 34(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 32
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a1)
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -96
; LMULMAX2-RV32-NEXT:    lw s0, 88(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 92(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 96
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV64-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e16, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v28
; LMULMAX2-RV64-NEXT:    lui a6, 16
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a3, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a3, a2, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 1
; LMULMAX2-RV64-NEXT:    lui a2, 21845
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 13107
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a4, 2
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    add a4, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a4, 4
; LMULMAX2-RV64-NEXT:    add a5, a4, a5
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a1, a5, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 62(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 60(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 58(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 56(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 54(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 52(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 50(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 48(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 46(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 44(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 42(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 40(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 38(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 36(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 34(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sh a1, 32(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 32
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a1)
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -96
; LMULMAX2-RV64-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 96
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -48
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a6)
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    lui a7, 16
; LMULMAX1-RV32-NEXT:    or a1, a1, a7
; LMULMAX1-RV32-NEXT:    addi a3, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 1
; LMULMAX1-RV32-NEXT:    lui a3, 349525
; LMULMAX1-RV32-NEXT:    addi t0, a3, 1365
; LMULMAX1-RV32-NEXT:    and a4, a4, t0
; LMULMAX1-RV32-NEXT:    sub a1, a1, a4
; LMULMAX1-RV32-NEXT:    lui a4, 209715
; LMULMAX1-RV32-NEXT:    addi a4, a4, 819
; LMULMAX1-RV32-NEXT:    and a5, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a5, a1
; LMULMAX1-RV32-NEXT:    srli a5, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a5
; LMULMAX1-RV32-NEXT:    lui a5, 61681
; LMULMAX1-RV32-NEXT:    addi a5, a5, -241
; LMULMAX1-RV32-NEXT:    and a2, a1, a5
; LMULMAX1-RV32-NEXT:    lui a1, 4112
; LMULMAX1-RV32-NEXT:    addi a1, a1, 257
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 32(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 46(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 44(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 42(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 40(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 38(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 36(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 34(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 16(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 30(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 26(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 22(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a2, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    sh a2, 20(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    or a2, a2, a7
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a2, 1
; LMULMAX1-RV32-NEXT:    and a3, a3, t0
; LMULMAX1-RV32-NEXT:    sub a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a3, a2, a4
; LMULMAX1-RV32-NEXT:    srli a2, a2, 2
; LMULMAX1-RV32-NEXT:    and a2, a2, a4
; LMULMAX1-RV32-NEXT:    add a2, a3, a2
; LMULMAX1-RV32-NEXT:    srli a3, a2, 4
; LMULMAX1-RV32-NEXT:    add a2, a2, a3
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    mul a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sh a1, 18(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 32
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a6)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 48
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -48
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    lui a7, 16
; LMULMAX1-RV64-NEXT:    or a1, a1, a7
; LMULMAX1-RV64-NEXT:    addi a3, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    srli a4, a1, 1
; LMULMAX1-RV64-NEXT:    lui a3, 21845
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi t0, a3, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, t0
; LMULMAX1-RV64-NEXT:    sub a1, a1, a4
; LMULMAX1-RV64-NEXT:    lui a4, 13107
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    and a5, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    lui a5, 3855
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    and a2, a1, a5
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 32(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 46(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 44(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 42(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 40(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 38(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 36(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 34(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 30(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 26(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 22(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 20(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sh a2, 18(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sh a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, sp, 32
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a6)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 48
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}
declare <16 x i16> @llvm.cttz.v16i16(<16 x i16>, i1)

define void @cttz_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV32-NEXT:    sw ra, 92(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 88(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a2, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a2, a1, a2
; LMULMAX2-RV32-NEXT:    srli a3, a2, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a6, a1, 1365
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    sub a3, a2, a3
; LMULMAX2-RV32-NEXT:    lui a2, 209715
; LMULMAX2-RV32-NEXT:    addi a2, a2, 819
; LMULMAX2-RV32-NEXT:    and a4, a3, a2
; LMULMAX2-RV32-NEXT:    srli a3, a3, 2
; LMULMAX2-RV32-NEXT:    and a3, a3, a2
; LMULMAX2-RV32-NEXT:    add a3, a4, a3
; LMULMAX2-RV32-NEXT:    srli a4, a3, 4
; LMULMAX2-RV32-NEXT:    add a4, a3, a4
; LMULMAX2-RV32-NEXT:    lui a3, 61681
; LMULMAX2-RV32-NEXT:    addi a3, a3, -241
; LMULMAX2-RV32-NEXT:    and a5, a4, a3
; LMULMAX2-RV32-NEXT:    lui a4, 4112
; LMULMAX2-RV32-NEXT:    addi a4, a4, 257
; LMULMAX2-RV32-NEXT:    mul a5, a5, a4
; LMULMAX2-RV32-NEXT:    srli a5, a5, 24
; LMULMAX2-RV32-NEXT:    sw a5, 32(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v28
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 60(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 56(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 52(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 48(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 44(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 40(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a2
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a2, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    mul a1, a1, a4
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    sw a1, 36(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 32
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX2-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -96
; LMULMAX2-RV32-NEXT:    lw s0, 88(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 92(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 96
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV64-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e32, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v28
; LMULMAX2-RV64-NEXT:    addi a1, zero, 1
; LMULMAX2-RV64-NEXT:    slli a6, a1, 32
; LMULMAX2-RV64-NEXT:    or a2, a2, a6
; LMULMAX2-RV64-NEXT:    addi a3, a2, -1
; LMULMAX2-RV64-NEXT:    not a2, a2
; LMULMAX2-RV64-NEXT:    and a3, a2, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 1
; LMULMAX2-RV64-NEXT:    lui a2, 21845
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    sub a4, a3, a4
; LMULMAX2-RV64-NEXT:    lui a3, 13107
; LMULMAX2-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    slli a3, a3, 12
; LMULMAX2-RV64-NEXT:    addi a3, a3, 819
; LMULMAX2-RV64-NEXT:    and a5, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a4, 2
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    add a4, a5, a4
; LMULMAX2-RV64-NEXT:    srli a5, a4, 4
; LMULMAX2-RV64-NEXT:    add a5, a4, a5
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a1, a5, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 60(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 56(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 52(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 48(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 44(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 40(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 36(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    or a1, a1, a6
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    srli a2, a1, 1
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    sub a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a2, a1, a3
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    add a1, a2, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sw a1, 32(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 32
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a1)
; LMULMAX2-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -96
; LMULMAX2-RV64-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 96
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -48
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a6)
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    addi a3, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a3, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a3, 1
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV32-NEXT:    and a4, a4, a7
; LMULMAX1-RV32-NEXT:    sub a4, a3, a4
; LMULMAX1-RV32-NEXT:    lui a3, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    and a5, a4, a3
; LMULMAX1-RV32-NEXT:    srli a4, a4, 2
; LMULMAX1-RV32-NEXT:    and a4, a4, a3
; LMULMAX1-RV32-NEXT:    add a4, a5, a4
; LMULMAX1-RV32-NEXT:    srli a5, a4, 4
; LMULMAX1-RV32-NEXT:    add a5, a4, a5
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    and a1, a5, a4
; LMULMAX1-RV32-NEXT:    lui a5, 4112
; LMULMAX1-RV32-NEXT:    addi a5, a5, 257
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 32(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 44(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 40(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 36(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a7
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    mul a1, a1, a5
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    sw a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 32
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a6)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 48
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -48
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    addi a2, zero, 1
; LMULMAX1-RV64-NEXT:    slli a7, a2, 32
; LMULMAX1-RV64-NEXT:    or a1, a1, a7
; LMULMAX1-RV64-NEXT:    addi a3, a1, -1
; LMULMAX1-RV64-NEXT:    not a1, a1
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    srli a4, a1, 1
; LMULMAX1-RV64-NEXT:    lui a3, 21845
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi t0, a3, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, t0
; LMULMAX1-RV64-NEXT:    sub a1, a1, a4
; LMULMAX1-RV64-NEXT:    lui a4, 13107
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 819
; LMULMAX1-RV64-NEXT:    and a5, a1, a4
; LMULMAX1-RV64-NEXT:    srli a1, a1, 2
; LMULMAX1-RV64-NEXT:    and a1, a1, a4
; LMULMAX1-RV64-NEXT:    add a1, a5, a1
; LMULMAX1-RV64-NEXT:    srli a5, a1, 4
; LMULMAX1-RV64-NEXT:    add a1, a1, a5
; LMULMAX1-RV64-NEXT:    lui a5, 3855
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    and a2, a1, a5
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 32(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 44(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 40(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 36(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    sw a2, 20(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    or a2, a2, a7
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 1
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    sub a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a3, a2, a4
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    add a2, a3, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, sp, 32
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a6)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 48
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}
declare <8 x i32> @llvm.cttz.v8i32(<8 x i32>, i1)

define void @cttz_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-RV32-LABEL: cttz_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV32-NEXT:    sw ra, 92(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 88(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 96
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    sw zero, 60(sp)
; LMULMAX2-RV32-NEXT:    sw zero, 52(sp)
; LMULMAX2-RV32-NEXT:    sw zero, 44(sp)
; LMULMAX2-RV32-NEXT:    sw zero, 36(sp)
; LMULMAX2-RV32-NEXT:    addi a6, zero, 32
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a4, a1, 1365
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a3, a1, 819
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a7, a1, -241
; LMULMAX2-RV32-NEXT:    lui a1, 4112
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v26
; LMULMAX2-RV32-NEXT:    addi a2, a1, 257
; LMULMAX2-RV32-NEXT:    bnez a5, .LBB7_2
; LMULMAX2-RV32-NEXT:  # %bb.1:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vsrl.vx v28, v26, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a5, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB7_3
; LMULMAX2-RV32-NEXT:  .LBB7_2:
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a5, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB7_3:
; LMULMAX2-RV32-NEXT:    sw a5, 32(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a5, v28
; LMULMAX2-RV32-NEXT:    bnez a5, .LBB7_5
; LMULMAX2-RV32-NEXT:  # %bb.4:
; LMULMAX2-RV32-NEXT:    vsrl.vx v28, v28, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a5, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB7_6
; LMULMAX2-RV32-NEXT:  .LBB7_5:
; LMULMAX2-RV32-NEXT:    addi a1, a5, -1
; LMULMAX2-RV32-NEXT:    not a5, a5
; LMULMAX2-RV32-NEXT:    and a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a5, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB7_6:
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    sw a5, 56(sp)
; LMULMAX2-RV32-NEXT:    bnez a1, .LBB7_8
; LMULMAX2-RV32-NEXT:  # %bb.7:
; LMULMAX2-RV32-NEXT:    vsrl.vx v28, v28, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a5, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB7_9
; LMULMAX2-RV32-NEXT:  .LBB7_8:
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a5, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a5, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a5, a1
; LMULMAX2-RV32-NEXT:    srli a5, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a5
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a5, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB7_9:
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    sw a5, 48(sp)
; LMULMAX2-RV32-NEXT:    bnez a1, .LBB7_11
; LMULMAX2-RV32-NEXT:  # %bb.10:
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v26, a6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a4, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a4
; LMULMAX2-RV32-NEXT:    and a4, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    addi a1, a1, 32
; LMULMAX2-RV32-NEXT:    j .LBB7_12
; LMULMAX2-RV32-NEXT:  .LBB7_11:
; LMULMAX2-RV32-NEXT:    addi a5, a1, -1
; LMULMAX2-RV32-NEXT:    not a1, a1
; LMULMAX2-RV32-NEXT:    and a1, a1, a5
; LMULMAX2-RV32-NEXT:    srli a5, a1, 1
; LMULMAX2-RV32-NEXT:    and a4, a5, a4
; LMULMAX2-RV32-NEXT:    sub a1, a1, a4
; LMULMAX2-RV32-NEXT:    and a4, a1, a3
; LMULMAX2-RV32-NEXT:    srli a1, a1, 2
; LMULMAX2-RV32-NEXT:    and a1, a1, a3
; LMULMAX2-RV32-NEXT:    add a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a3, a1, 4
; LMULMAX2-RV32-NEXT:    add a1, a1, a3
; LMULMAX2-RV32-NEXT:    and a1, a1, a7
; LMULMAX2-RV32-NEXT:    mul a1, a1, a2
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:  .LBB7_12:
; LMULMAX2-RV32-NEXT:    sw a1, 40(sp)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    addi a1, sp, 32
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -96
; LMULMAX2-RV32-NEXT:    lw s0, 88(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 92(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 96
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 96
; LMULMAX2-RV64-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 96
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 1, e64, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    addi a2, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a2, a1, a2
; LMULMAX2-RV64-NEXT:    srli a3, a2, 1
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a6, a1, 1365
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a3, a2, a3
; LMULMAX2-RV64-NEXT:    lui a2, 13107
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    slli a2, a2, 12
; LMULMAX2-RV64-NEXT:    addi a2, a2, 819
; LMULMAX2-RV64-NEXT:    and a4, a3, a2
; LMULMAX2-RV64-NEXT:    srli a3, a3, 2
; LMULMAX2-RV64-NEXT:    and a3, a3, a2
; LMULMAX2-RV64-NEXT:    add a3, a4, a3
; LMULMAX2-RV64-NEXT:    srli a4, a3, 4
; LMULMAX2-RV64-NEXT:    add a3, a3, a4
; LMULMAX2-RV64-NEXT:    lui a4, 3855
; LMULMAX2-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, 241
; LMULMAX2-RV64-NEXT:    slli a4, a4, 12
; LMULMAX2-RV64-NEXT:    addi a4, a4, -241
; LMULMAX2-RV64-NEXT:    and a3, a3, a4
; LMULMAX2-RV64-NEXT:    lui a5, 4112
; LMULMAX2-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    slli a5, a5, 16
; LMULMAX2-RV64-NEXT:    addi a5, a5, 257
; LMULMAX2-RV64-NEXT:    mul a3, a3, a5
; LMULMAX2-RV64-NEXT:    srli a3, a3, 56
; LMULMAX2-RV64-NEXT:    sd a3, 56(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    addi a1, a3, -1
; LMULMAX2-RV64-NEXT:    not a3, a3
; LMULMAX2-RV64-NEXT:    and a1, a3, a1
; LMULMAX2-RV64-NEXT:    srli a3, a1, 1
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a3, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a3, a1
; LMULMAX2-RV64-NEXT:    srli a3, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sd a1, 48(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    addi a3, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    srli a3, a1, 1
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a3, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a3, a1
; LMULMAX2-RV64-NEXT:    srli a3, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sd a1, 40(sp)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    addi a3, a1, -1
; LMULMAX2-RV64-NEXT:    not a1, a1
; LMULMAX2-RV64-NEXT:    and a1, a1, a3
; LMULMAX2-RV64-NEXT:    srli a3, a1, 1
; LMULMAX2-RV64-NEXT:    and a3, a3, a6
; LMULMAX2-RV64-NEXT:    sub a1, a1, a3
; LMULMAX2-RV64-NEXT:    and a3, a1, a2
; LMULMAX2-RV64-NEXT:    srli a1, a1, 2
; LMULMAX2-RV64-NEXT:    and a1, a1, a2
; LMULMAX2-RV64-NEXT:    add a1, a3, a1
; LMULMAX2-RV64-NEXT:    srli a2, a1, 4
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    and a1, a1, a4
; LMULMAX2-RV64-NEXT:    mul a1, a1, a5
; LMULMAX2-RV64-NEXT:    srli a1, a1, 56
; LMULMAX2-RV64-NEXT:    sd a1, 32(sp)
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV64-NEXT:    addi a1, sp, 32
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a1)
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -96
; LMULMAX2-RV64-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 96
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -48
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 48
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a7, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a7)
; LMULMAX1-RV32-NEXT:    sw zero, 44(sp)
; LMULMAX1-RV32-NEXT:    sw zero, 36(sp)
; LMULMAX1-RV32-NEXT:    addi a6, zero, 32
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a5, a1, 1365
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a4, a1, 819
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi t0, a1, -241
; LMULMAX1-RV32-NEXT:    lui a2, 4112
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a3, a2, 257
; LMULMAX1-RV32-NEXT:    bnez a1, .LBB7_2
; LMULMAX1-RV32-NEXT:  # %bb.1:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsrl.vx v27, v26, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a1, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB7_3
; LMULMAX1-RV32-NEXT:  .LBB7_2:
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB7_3:
; LMULMAX1-RV32-NEXT:    sw a1, 32(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    bnez a1, .LBB7_5
; LMULMAX1-RV32-NEXT:  # %bb.4:
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v26, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a1, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB7_6
; LMULMAX1-RV32-NEXT:  .LBB7_5:
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB7_6:
; LMULMAX1-RV32-NEXT:    sw a1, 40(sp)
; LMULMAX1-RV32-NEXT:    sw zero, 28(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    sw zero, 20(sp)
; LMULMAX1-RV32-NEXT:    bnez a1, .LBB7_8
; LMULMAX1-RV32-NEXT:  # %bb.7:
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v25, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a1, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB7_9
; LMULMAX1-RV32-NEXT:  .LBB7_8:
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB7_9:
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV32-NEXT:    bnez a2, .LBB7_11
; LMULMAX1-RV32-NEXT:  # %bb.10:
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    addi a2, a1, -1
; LMULMAX1-RV32-NEXT:    not a1, a1
; LMULMAX1-RV32-NEXT:    and a1, a1, a2
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    addi a1, a1, 32
; LMULMAX1-RV32-NEXT:    j .LBB7_12
; LMULMAX1-RV32-NEXT:  .LBB7_11:
; LMULMAX1-RV32-NEXT:    addi a1, a2, -1
; LMULMAX1-RV32-NEXT:    not a2, a2
; LMULMAX1-RV32-NEXT:    and a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 1
; LMULMAX1-RV32-NEXT:    and a2, a2, a5
; LMULMAX1-RV32-NEXT:    sub a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a2, a1, a4
; LMULMAX1-RV32-NEXT:    srli a1, a1, 2
; LMULMAX1-RV32-NEXT:    and a1, a1, a4
; LMULMAX1-RV32-NEXT:    add a1, a2, a1
; LMULMAX1-RV32-NEXT:    srli a2, a1, 4
; LMULMAX1-RV32-NEXT:    add a1, a1, a2
; LMULMAX1-RV32-NEXT:    and a1, a1, t0
; LMULMAX1-RV32-NEXT:    mul a1, a1, a3
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:  .LBB7_12:
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 32
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a7)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 48
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    addi a3, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a3, a2, a3
; LMULMAX1-RV64-NEXT:    srli a4, a3, 1
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a7, a2, 1365
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a4, a3, a4
; LMULMAX1-RV64-NEXT:    lui a3, 13107
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    and a5, a4, a3
; LMULMAX1-RV64-NEXT:    srli a4, a4, 2
; LMULMAX1-RV64-NEXT:    and a4, a4, a3
; LMULMAX1-RV64-NEXT:    add a4, a5, a4
; LMULMAX1-RV64-NEXT:    srli a5, a4, 4
; LMULMAX1-RV64-NEXT:    add a4, a4, a5
; LMULMAX1-RV64-NEXT:    lui a5, 3855
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    and a4, a4, a5
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    mul a4, a4, a1
; LMULMAX1-RV64-NEXT:    srli a4, a4, 56
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v27, a4
; LMULMAX1-RV64-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV64-NEXT:    addi a2, a4, -1
; LMULMAX1-RV64-NEXT:    not a4, a4
; LMULMAX1-RV64-NEXT:    and a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; LMULMAX1-RV64-NEXT:    vmv.s.x v27, a2
; LMULMAX1-RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    addi a4, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a4, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a2, a2, a1
; LMULMAX1-RV64-NEXT:    srli a2, a2, 56
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v26, a2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    addi a4, a2, -1
; LMULMAX1-RV64-NEXT:    not a2, a2
; LMULMAX1-RV64-NEXT:    and a2, a2, a4
; LMULMAX1-RV64-NEXT:    srli a4, a2, 1
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    sub a2, a2, a4
; LMULMAX1-RV64-NEXT:    and a4, a2, a3
; LMULMAX1-RV64-NEXT:    srli a2, a2, 2
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    add a2, a4, a2
; LMULMAX1-RV64-NEXT:    srli a3, a2, 4
; LMULMAX1-RV64-NEXT:    add a2, a2, a3
; LMULMAX1-RV64-NEXT:    and a2, a2, a5
; LMULMAX1-RV64-NEXT:    mul a1, a2, a1
; LMULMAX1-RV64-NEXT:    srli a1, a1, 56
; LMULMAX1-RV64-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; LMULMAX1-RV64-NEXT:    vmv.s.x v26, a1
; LMULMAX1-RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v27, (a6)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}
declare <4 x i64> @llvm.cttz.v4i64(<4 x i64>, i1)
