// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes a media stream from a flow. This action is only available if the media
// stream is not associated with a source or output.
func (c *Client) RemoveFlowMediaStream(ctx context.Context, params *RemoveFlowMediaStreamInput, optFns ...func(*Options)) (*RemoveFlowMediaStreamOutput, error) {
	if params == nil {
		params = &RemoveFlowMediaStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RemoveFlowMediaStream", params, optFns, c.addOperationRemoveFlowMediaStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RemoveFlowMediaStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RemoveFlowMediaStreamInput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	FlowArn *string

	// The name of the media stream that you want to remove.
	//
	// This member is required.
	MediaStreamName *string

	noSmithyDocumentSerde
}

type RemoveFlowMediaStreamOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	FlowArn *string

	// The name of the media stream that was removed.
	MediaStreamName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRemoveFlowMediaStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRemoveFlowMediaStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRemoveFlowMediaStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRemoveFlowMediaStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRemoveFlowMediaStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRemoveFlowMediaStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "mediaconnect",
		OperationName: "RemoveFlowMediaStream",
	}
}
