// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Provides the category rules that are used to automatically categorize contacts
// based on uttered keywords and phrases.
type Categories struct {

	// The category rules that have been matched in the analyzed segment.
	//
	// This member is required.
	MatchedCategories []string

	// The category rule that was matched and when it occurred in the transcript.
	//
	// This member is required.
	MatchedDetails map[string]CategoryDetails

	noSmithyDocumentSerde
}

// Provides information about the category rule that was matched.
type CategoryDetails struct {

	// The section of audio where the category rule was detected.
	//
	// This member is required.
	PointsOfInterest []PointOfInterest

	noSmithyDocumentSerde
}

// For characters that were detected as issues, where they occur in the transcript.
type CharacterOffsets struct {

	// The beginning of the issue.
	//
	// This member is required.
	BeginOffsetChar int32

	// The end of the issue.
	//
	// This member is required.
	EndOffsetChar int32

	noSmithyDocumentSerde
}

// Potential issues that are detected based on an artificial intelligence analysis
// of each turn in the conversation.
type IssueDetected struct {

	// The offset for when the issue was detected in the segment.
	//
	// This member is required.
	CharacterOffsets *CharacterOffsets

	noSmithyDocumentSerde
}

// The section of the contact audio where that category rule was detected.
type PointOfInterest struct {

	// The beginning offset in milliseconds where the category rule was detected.
	//
	// This member is required.
	BeginOffsetMillis int32

	// The ending offset in milliseconds where the category rule was detected.
	//
	// This member is required.
	EndOffsetMillis int32

	noSmithyDocumentSerde
}

// An analyzed segment for a real-time analysis session.
type RealtimeContactAnalysisSegment struct {

	// The matched category rules.
	Categories *Categories

	// The analyzed transcript.
	Transcript *Transcript

	noSmithyDocumentSerde
}

// A list of messages in the session.
type Transcript struct {

	// The beginning offset in the contact for this transcript.
	//
	// This member is required.
	BeginOffsetMillis int32

	// The content of the transcript.
	//
	// This member is required.
	Content *string

	// The end offset in the contact for this transcript.
	//
	// This member is required.
	EndOffsetMillis int32

	// The identifier of the transcript.
	//
	// This member is required.
	Id *string

	// The identifier of the participant.
	//
	// This member is required.
	ParticipantId *string

	// The role of participant. For example, is it a customer, agent, or system.
	//
	// This member is required.
	ParticipantRole *string

	// The sentiment of the detected for this piece of transcript.
	//
	// This member is required.
	Sentiment SentimentValue

	// List of positions where issues were detected on the transcript.
	IssuesDetected []IssueDetected

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
