// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcases

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/connectcases/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a layout in the Cases domain. Layouts define the following configuration
// in the top section and More Info tab of the Cases user interface:
//
// * Fields to
// display to the users
//
// * Field ordering
//
// Title and Status fields cannot be part
// of layouts since they are not configurable.
func (c *Client) CreateLayout(ctx context.Context, params *CreateLayoutInput, optFns ...func(*Options)) (*CreateLayoutOutput, error) {
	if params == nil {
		params = &CreateLayoutInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLayout", params, optFns, c.addOperationCreateLayoutMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLayoutOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLayoutInput struct {

	// Information about which fields will be present in the layout, and information
	// about the order of the fields.
	//
	// This member is required.
	Content types.LayoutContent

	// The unique identifier of the Cases domain.
	//
	// This member is required.
	DomainId *string

	// The name of the layout. It must be unique for the Cases domain.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type CreateLayoutOutput struct {

	// The Amazon Resource Name (ARN) of the newly created layout.
	//
	// This member is required.
	LayoutArn *string

	// The unique identifier of the layout.
	//
	// This member is required.
	LayoutId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLayoutMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLayout{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLayout{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateLayoutValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLayout(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLayout(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cases",
		OperationName: "CreateLayout",
	}
}
