// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a paginated lists of all the channel flows created under a single Chime.
// This is a developer API.
func (c *Client) ListChannelFlows(ctx context.Context, params *ListChannelFlowsInput, optFns ...func(*Options)) (*ListChannelFlowsOutput, error) {
	if params == nil {
		params = &ListChannelFlowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChannelFlows", params, optFns, c.addOperationListChannelFlowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChannelFlowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChannelFlowsInput struct {

	// The ARN of the app instance.
	//
	// This member is required.
	AppInstanceArn *string

	// The maximum number of channel flows that you want to return.
	MaxResults *int32

	// The token passed by previous API calls until all requested channel flows are
	// returned.
	NextToken *string

	noSmithyDocumentSerde
}

type ListChannelFlowsOutput struct {

	// The information about each channel flow.
	ChannelFlows []types.ChannelFlowSummary

	// The token passed by previous API calls until all requested channels are
	// returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChannelFlowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChannelFlows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChannelFlows{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListChannelFlowsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChannelFlows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChannelFlowsAPIClient is a client that implements the ListChannelFlows
// operation.
type ListChannelFlowsAPIClient interface {
	ListChannelFlows(context.Context, *ListChannelFlowsInput, ...func(*Options)) (*ListChannelFlowsOutput, error)
}

var _ ListChannelFlowsAPIClient = (*Client)(nil)

// ListChannelFlowsPaginatorOptions is the paginator options for ListChannelFlows
type ListChannelFlowsPaginatorOptions struct {
	// The maximum number of channel flows that you want to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChannelFlowsPaginator is a paginator for ListChannelFlows
type ListChannelFlowsPaginator struct {
	options   ListChannelFlowsPaginatorOptions
	client    ListChannelFlowsAPIClient
	params    *ListChannelFlowsInput
	nextToken *string
	firstPage bool
}

// NewListChannelFlowsPaginator returns a new ListChannelFlowsPaginator
func NewListChannelFlowsPaginator(client ListChannelFlowsAPIClient, params *ListChannelFlowsInput, optFns ...func(*ListChannelFlowsPaginatorOptions)) *ListChannelFlowsPaginator {
	if params == nil {
		params = &ListChannelFlowsInput{}
	}

	options := ListChannelFlowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChannelFlowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChannelFlowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChannelFlows page.
func (p *ListChannelFlowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChannelFlowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListChannelFlows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListChannelFlows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "chime",
		OperationName: "ListChannelFlows",
	}
}
