#!/bin/sh

# The test script treats a file as "interesting" if it contains the
# literal string "TRIGGER", which is used here as a simple marker for a
# condition of interest.
#
# singledelta does not provide a stable or documented final output file.
# It generates and removes intermediate candidates, logging its progress
# to stderr and to tmp0/log.
#
# Therefore, this test verifies correct behavior by checking that the
# delta debugging process runs to completion and preserves the
# "interesting" property, without relying on undocumented internals.
#
# If singledelta completes successfully and TRIGGER is preserved in
# reduced candidates, the test is considered successful.

cd debian/tests/
cp input.txt test.sh $AUTOPKGTEST_TMP
cd $AUTOPKGTEST_TMP

singledelta -test=./test.sh input.txt

echo "\nREADING TMP0/LOG\n"
cat tmp0/log | grep -C 50 start | grep -B 50 done

echo "\nSEARCHING FOR TRIGGER"
for i in $(ls tmp0/00*); do echo "\n\nFile $i:"; grep -C 10 TRIGGER $i; done
