from collections.abc import Mapping
from debputy.plugin.api.impl_types import (
    KNOWN_PACKAGING_FILE_CATEGORY_DESCRIPTIONS,
    KNOWN_PACKAGING_FILE_CONFIG_FEATURE_DESCRIPTION,
    KnownPackagingConfigFeature,
    KnownPackagingFileCategories,
    ReferenceValue,
)

REFERENCE_DATA_TABLE: Mapping[
    str,
    Mapping[KnownPackagingConfigFeature, ReferenceValue]
    | Mapping[KnownPackagingFileCategories, ReferenceValue],
] = {
    "config-features": KNOWN_PACKAGING_FILE_CONFIG_FEATURE_DESCRIPTION,
    "file-categories": KNOWN_PACKAGING_FILE_CATEGORY_DESCRIPTIONS,
}
