// Copyright (c) 2024 The YAC Authors
//
// SPDX-License-Identifier: BSD-3-Clause

#ifndef YAC_TYPES_H
#define YAC_TYPES_H


// YAC PUBLIC HEADER START

#include <stddef.h>

#ifdef YAC_FOR_CDO

// Global index type for YAC
typedef size_t yac_int;
#define YAC_INT_MAX SIZE_MAX

#else

#include "yac_config.h"

// Global index type for YAC
typedef YAC_INT yac_int;

// MPI Datatype for integers of type yac_int
#define yac_int_dt YAC_INT_MPIDT

#endif // YAC_FOR_CDO

// types for 3D coordinate arrays
typedef double(*yac_coordinate_pointer)[3];
typedef double const (* yac_const_coordinate_pointer)[3] ;

// type for storing an array for two indices
typedef size_t (* yac_size_t_2_pointer)[2];

// YAC PUBLIC HEADER STOP

#endif // YAC_TYPES_H
