/* SPDX-FileCopyrightText: 2023 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#pragma once

/** \file
 * \ingroup bmesh
 *
 * Utility functions that operate directly on the BMesh,
 * These can be used by both Modifiers and BMesh-Operators.
 */

#include "tools/bmesh_beautify.hh"
#include "tools/bmesh_bevel.hh"
#include "tools/bmesh_bisect_plane.hh"
#include "tools/bmesh_boolean.hh"
#include "tools/bmesh_decimate.hh"
#include "tools/bmesh_edgenet.hh"
#include "tools/bmesh_edgesplit.hh"
#include "tools/bmesh_path.hh"
#include "tools/bmesh_path_region.hh"
#include "tools/bmesh_path_region_uv.hh"
#include "tools/bmesh_path_uv.hh"
#include "tools/bmesh_region_match.hh"
#include "tools/bmesh_separate.hh"
#include "tools/bmesh_triangulate.hh"
