//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_2.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root2(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[2] = {1.629171306613029e+00,5.370828693386970e+00};
  constexpr double aw[2] = {5.099756785793345e-01,1.546945155102340e-01};
  constexpr double x[768] = {  7.474864359466880e-01, -3.535658173941201e-02,  5.228416203773162e-04,  2.485061296518964e-05, -1.286755793526887e-06,
 -1.529060242430627e-08,  2.741924267378731e-09, -2.170087112102099e-11, -4.777430276423512e-12,  1.310467565966167e-13,  6.448120285175643e-15, -3.877042844499765e-16,
  1.684813108292035e+00, -2.160811257381258e-02, -9.040762401469994e-04, -1.988193937228332e-05,  3.272923480604569e-07,  5.094525126797847e-08,  1.950137003038232e-09,
 -7.640653828987848e-13, -3.652771686818833e-12, -1.738281289438803e-13, -1.709254798370944e-15,  2.440919723471047e-16,  6.158162416863208e-01, -3.033308763618646e-02,
  6.978424978852686e-04,  4.940843725404344e-06, -1.050678139604984e-06,  3.127002853979206e-08,  8.691750661729360e-10, -8.124912476615054e-11,  8.054950587222888e-13,
  1.019258795300334e-13, -4.737333729542625e-15, -6.673312769918188e-18,  1.582651505850670e+00, -2.961333085382399e-02, -1.070130257993951e-03, -4.268828190005336e-06,
  1.720392803809413e-06,  7.880212263132284e-08, -5.540182866098930e-10, -1.965306872257262e-10, -6.562655701345604e-12,  1.779095774142929e-13,  2.187722986359308e-14,
  4.792482466637508e-16,  5.056890596376877e-01, -2.474759157032097e-02,  6.786599181208557e-04, -6.423218651620005e-06, -3.759717145761455e-07,  2.992714747268947e-08,
 -7.277786166671299e-10, -2.819475528627170e-11,  1.794870499328155e-12, -1.667048887852815e-14, -6.681582101854113e-16,  7.582522665359262e-17,  1.447551445590901e+00,
 -3.780681082210982e-02, -9.123769925979095e-04,  3.298399894904812e-05,  2.643432875327438e-06, -1.200489790976288e-08, -6.789636353402008e-09, -1.359384224383865e-10,
  1.396442397711306e-11,  6.941754172733376e-13, -1.866002652995873e-14, -2.263544659738191e-15,  4.169758284444041e-01, -1.969045367126769e-02,  5.816959553220773e-04,
 -8.759167085272866e-06,  1.480335895305637e-08,  8.833721050412202e-09, -8.198164667756976e-10,  1.749667369472674e-11,  9.974280668345454e-13, -3.084324340063627e-14,
 -8.948333260579315e-16, -2.850492347794160e-17,  1.285148980882289e+00, -4.288131174279671e-02, -3.002750129672969e-04,  6.432879455396865e-05,  7.916271214600058e-07,
 -1.564667429021712e-07, -2.572130324393489e-09,  4.110923579857510e-10,  8.611594429906285e-12, -1.089884915281788e-12, -2.848535691406304e-14,  2.875800494318267e-15,
  3.468713499853666e-01, -1.544578083369613e-02,  4.809518855469166e-04, -7.962203315262075e-06,  4.774751121645091e-08, -2.637114900265327e-09, -9.917420045955821e-11,
  2.523374771337989e-11, -6.061550760371990e-13, -4.208941564237362e-14,  1.360198077801322e-15,  8.930235565954691e-17,  1.113695705262594e+00, -4.222002692803630e-02,
  4.445066975653002e-04,  5.259113875215704e-05, -2.022802838997151e-06, -8.642345939775597e-08,  6.868345045304421e-09,  1.000944114893937e-10, -2.021241635295380e-11,
  8.787057932800161e-14,  5.311472213070862e-14, -1.150277923887976e-15,  2.921915288432307e-01, -1.197122805629367e-02,  3.883617656245046e-04, -7.561814736557046e-06,
  1.298220570731919e-08,  3.780204271175529e-10,  2.118233410222220e-10, -3.490906171323937e-12, -7.102311690755804e-13,  3.241481902353135e-14,  8.653004527215614e-16,
 -9.211043441207253e-17,  9.550479672797951e-01, -3.676309153452646e-02,  8.531408139384384e-04,  1.514573530971713e-05, -2.199534648047374e-06,  5.282570236348175e-08,
  3.124394443345674e-09, -2.438388161229416e-10,  1.285981182814706e-12,  5.528195967666791e-13, -2.281997107951762e-14, -5.576998982924176e-16,  2.499533454298685e-01,
 -9.221702288683917e-03,  2.998405569739338e-04, -7.082150287730557e-06,  5.504454765080618e-08,  2.856985655113707e-09, -2.236338098121205e-11, -7.734943731788895e-12,
  2.887206126403910e-13,  9.859709538528712e-15, -1.077905111995499e-15,  1.791866976638582e-17,  8.220785943506744e-01, -2.971304335985495e-02,  8.660387974165733e-04,
 -9.587257024732306e-06, -8.680027272225072e-07,  6.240699642698617e-08, -1.417107979918841e-09, -5.922329538250839e-11,  5.868590622413579e-12, -1.565752504402489e-13,
 -4.987226166475803e-15,  5.667390859638804e-16,  2.173520186604805e-01, -7.144078288952208e-03,  2.217782526718033e-04, -5.826635542596369e-06,  9.515124715909506e-08,
  8.504757935138597e-10, -1.025081649335068e-10,  1.168092809067093e-12,  1.580632098723895e-13, -8.925294035431219e-15,  7.417757215285088e-17,  1.433760943527218e-17,
  7.161291760539050e-01, -2.339966497208637e-02,  7.020868408434472e-04, -1.559253207170685e-05, -8.618361215964363e-09,  2.407380149821763e-08, -1.356543096404596e-09,
  3.431722537006807e-11,  4.973346477025171e-13, -8.744148420498947e-14,  3.798358370634129e-15, -4.805252660760064e-17,  1.919185845481632e-01, -5.623140504383600e-03,
  1.611690365006497e-04, -4.283839907654742e-06,  9.204290582677077e-08, -9.024475354332403e-10, -3.891160485186306e-11,  2.327687036099450e-12, -4.012897645105856e-14,
 -1.788101662006919e-15,  1.486288252164979e-16, -4.339612887783560e-18,  6.326113464239513e-01, -1.850700388601753e-02,  5.252157638551446e-04, -1.331653055528522e-05,
  2.254449523622719e-07,  2.845836656949062e-09, -4.702669920594657e-10,  2.333252330316981e-11, -6.521400536286020e-13,  2.636238036996794e-15,  8.005186694079457e-16,
 -4.754393867849378e-17,  1.717123956159372e-01, -4.515980435718878e-03,  1.178923758119311e-04, -2.987167669620160e-06,  6.905233217996770e-08, -1.226759037340875e-09,
  4.712504929165402e-12,  8.087088336053919e-13, -3.957535514234357e-14,  8.723688688696528e-16,  7.685756978025904e-18, -1.498672586009573e-18,  5.660631316840471e-01,
 -1.488186947840166e-02,  3.874623103257972e-04, -9.684977866112922e-06,  2.111392974445028e-07, -2.731120856429060e-09, -6.908672051155783e-11,  7.149839348256331e-12,
 -3.252966011271518e-13,  9.592060178555048e-15, -1.363272223614993e-16, -4.028041705053168e-18,  1.553318707869337e-01, -3.699238925940875e-03,  8.790128634465752e-05,
 -2.066969412838208e-06,  4.686583504780913e-08, -9.562310644967710e-10,  1.424854942330056e-11,  1.965515252921482e-14, -1.201853903265797e-14,  5.324602126305858e-16,
 -1.334261932473162e-17,  9.541793835515055e-20,  5.120741843658257e-01, -1.219409171330552e-02,  2.895607227113645e-04, -6.783234267680835e-06,  1.512752296638231e-07,
 -2.885839341847187e-09,  2.892126199979491e-11,  1.089424203751116e-12, -8.895355882863574e-14,  3.773111620223006e-15, -1.130933521755343e-16,  2.197629762570584e-18,
  1.418004763976140e-01, -3.083829980354373e-03,  6.702490233174745e-05, -1.451934719349942e-06,  3.104353210852798e-08, -6.367927170543041e-10,  1.163373746836470e-11,
 -1.484151130921955e-13, -8.097303637010029e-16,  1.419777951506571e-16, -5.885617527301735e-18,  1.565857269867267e-19,  4.674679187559780e-01, -1.016616303611984e-02,
  2.209192077435694e-04, -4.780930436393069e-06,  1.017414423707704e-07, -2.048561355281479e-09,  3.480845202850332e-11, -2.800284526923558e-13, -1.328384471646238e-14,
  9.352939750920233e-16, -3.731176010555706e-17,  1.110257253751786e-18,  1.304379680031112e-01, -2.609756212076620e-03,  5.220683948296087e-05, -1.043373305942618e-06,
  2.076312830442265e-08, -4.069837762372839e-10,  7.627943719461971e-12, -1.265181122862000e-13,  1.420079134183771e-15,  1.132196819115215e-17, -1.399822223927487e-18,
  5.504792044366955e-20,  4.300099390935109e-01, -8.603454903498483e-03,  1.721015337203327e-04, -3.438663269068333e-06,  6.834201439224874e-08, -1.332449051973163e-09,
  2.448705736745445e-11, -3.771066418482650e-13,  2.587156976049802e-15,  1.333710057013966e-16, -8.503038485539305e-18,  3.208748494079897e-19,  1.207621882306315e-01,
 -2.237095432588061e-03,  4.144016705921460e-05, -7.674440648602578e-07,  1.419426355174474e-08, -2.612010551987046e-10,  4.727947344581878e-12, -8.168969187872259e-14,
  1.246185990237379e-15, -1.270105545410073e-17, -1.111059011829718e-19,  1.184712831212960e-20,  3.981122192873408e-01, -7.374944311316357e-03,  1.366131069285781e-04,
 -2.529835160757638e-06,  4.677511256310794e-08, -8.594635993285049e-10,  1.546825374726933e-11, -2.620019669376984e-13,  3.717080788149783e-15, -2.344135173973245e-17,
 -1.137634374428714e-18,  6.790912951071369e-20,  1.124234966928905e-01, -1.938911092960818e-03,  3.343912387732818e-05, -5.766649385242946e-07,  9.941126045092451e-09,
 -1.711055403182990e-10,  2.928469096777421e-12, -4.926460426738907e-14,  7.908978421135157e-16, -1.122818021590678e-17,  1.072119041152323e-19,  8.517872089123589e-22,
  3.706223746575720e-01, -6.391935493271388e-03,  1.102373284325904e-04, -1.901041509134153e-06,  3.276938664784253e-08, -5.637977024554697e-10,  9.633612522425144e-12,
 -1.611195611480800e-13,  2.537070901699062e-15, -3.363990404984412e-17,  2.088461440284223e-19,  8.369271866899193e-21,  1.051625549085330e-01, -1.696611438318282e-03,
  2.737176546367573e-05, -4.415871165778744e-07,  7.123421510081868e-09, -1.148584620074616e-10,  1.848663003141366e-12, -2.957685599082582e-14,  4.650444194738248e-16,
 -6.985024501705196e-18,  9.322774733969678e-20, -8.570134532486165e-22,  3.466854986452624e-01, -5.593155934207734e-03,  9.023545368104955e-05, -1.455759195234674e-06,
  2.348299439970454e-08, -3.786026312537070e-10,  6.090924691613320e-12, -9.728322968512568e-14,  1.520851243108187e-15, -2.242997194222633e-17,  2.813055063303548e-19,
 -1.803557001546193e-21,  9.878302015876514e-02, -1.497056133195335e-03,  2.268786816182885e-05, -3.438331252231605e-07,  5.210643584555188e-09, -7.895524768726611e-11,
  1.195745173580142e-12, -1.807392054186156e-14,  2.715243452327752e-16, -4.010063742876082e-18,  5.668867057763633e-20, -7.173516343914615e-22,  3.256543230567006e-01,
 -4.935289472453801e-03,  7.479424939644312e-05, -1.133501163147318e-06,  1.717764958555825e-08, -2.602810756142087e-10,  3.941386493615662e-12, -5.954631304366240e-14,
  8.930411271922703e-16, -1.311695943184272e-17,  1.823377761877203e-19, -2.183684837299993e-21,  9.313352465823857e-02, -1.330750552480082e-03,  1.901460175161215e-05,
 -2.716923813404048e-07,  3.882086377783053e-09, -5.546754008352735e-11,  7.924054257925951e-13, -1.131355157692504e-14,  1.612030992898595e-16, -2.283033709682518e-18,
  3.180811468459443e-20, -4.253086994486427e-22,  3.070298405736418e-01, -4.387036044671376e-03,  6.268473237971864e-05, -8.956780860438390e-07,  1.279791643501043e-08,
 -1.828565210275398e-10,  2.612198133132279e-12, -3.729079818024076e-14,  5.310847815346245e-16, -7.509059899850060e-18,  1.040861737236106e-19, -1.370846468692437e-21,
  8.809549487116854e-02, -1.190697137943280e-03,  1.609344100817238e-05, -2.175186198742191e-07,  2.939973316335463e-09, -3.973624759030262e-11,  5.370477423104799e-13,
 -7.257130408628917e-15,  9.800416405556867e-17, -1.320814276693047e-18,  1.769654500403965e-20, -2.334409988572770e-22,  2.904211544172246e-01, -3.925327144362286e-03,
  5.305465065690462e-05, -7.170855566262301e-07,  9.692098897685281e-09, -1.309968123865681e-10,  1.770449957989455e-12, -2.392330856524017e-14,  3.230296766035729e-16,
 -4.351411564764841e-18,  5.821021657860943e-20, -7.643041846331619e-22,  8.357472462057285e-02, -1.071646999042280e-03,  1.374132301193388e-05, -1.761997666624271e-07,
  2.259342022859291e-09, -2.897062049683700e-11,  3.714746258998682e-13, -4.762995988563360e-15,  6.105920359993565e-17, -7.822459487363849e-19,  1.000163892949796e-20,
 -1.271496083460261e-22,  2.755176986064848e-01, -3.532858962178838e-03,  4.530051050201087e-05, -5.808712403214509e-07,  7.448288797554644e-09, -9.550633911344380e-11,
  1.224624171090767e-12, -1.570183097914413e-14,  2.012823888817272e-16, -2.578333912449581e-18,  3.295079473376644e-20, -4.182962789999651e-22,  7.949541984836930e-02,
 -9.696005609920306e-04,  1.182615613643347e-05, -1.442428702462360e-07,  1.759320951686525e-09, -2.145831422642865e-11,  2.617248907413425e-13, -3.192192856314278e-15,
  3.893236097685485e-17, -4.747323507567883e-19,  5.785086637908158e-21, -7.035259632479873e-23,  2.620696056831708e-01, -3.196446250274192e-03,  3.898685082846458e-05,
 -4.755201263440506e-07,  5.799888151860719e-09, -7.074082450612973e-11,  8.628183616179568e-13, -1.052355827210095e-14,  1.283453974643874e-16, -1.564957394112294e-18,
  1.906804244745461e-20, -2.317864227301507e-22,  7.579590884186790e-02, -8.814669749246782e-04,  1.025100219336558e-05, -1.192138205957669e-07,  1.386394672206826e-09,
 -1.612304668521075e-11,  1.875025075942149e-13, -2.180548243722737e-15,  2.535819148144463e-17, -2.948811165411599e-19,  3.428398146994380e-21, -3.982984538028157e-23,
  2.498735647975250e-01, -2.905899522031971e-03,  3.379409917903268e-05, -3.930077859735274e-07,  4.570475947925207e-09, -5.315224993262207e-11,  6.181325096009403e-13,
 -7.188528577205178e-15,  8.359717719959375e-17, -9.721117013434743e-19,  1.130172326993275e-20, -1.312826648321456e-22,  7.242549867472541e-02, -8.048271366962591e-04,
  8.943628028808053e-06, -9.938591611399053e-08,  1.104424318838490e-09, -1.227289637241631e-11,  1.363823321970966e-13, -1.515544972568450e-15,  1.684139177089442e-17,
 -1.871460102424363e-19,  2.079498439363620e-21, -2.309936958551629e-23,  2.387624584573340e-01, -2.653243806491212e-03,  2.948412720319985e-05, -3.276418678615025e-07,
  3.640914736877200e-09, -4.045960269540894e-11,  4.496065727369323e-13, -4.996240337100470e-15,  5.552035580323211e-17, -6.169554373626899e-19,  6.855318456029376e-21,
 -7.614719115334830e-23,  6.934213572395484e-02, -7.377657998375416e-04,  7.849460789243879e-06, -8.351435467992392e-08,  8.885511528541696e-10, -9.453741821620219e-12,
  1.005831024266633e-13, -1.070153898668621e-15,  1.138589191793464e-17, -1.211396017938055e-19,  1.288838071366967e-21, -1.370998302026215e-23,  2.285976500416053e-01,
 -2.432165181576055e-03,  2.587702659833444e-05, -2.753186792580457e-07,  2.929253668776875e-09, -3.116580042788876e-11,  3.315885861752048e-13, -3.527936616015077e-15,
  3.753544241074753e-17, -3.993561438956404e-19,  4.248851083922759e-21, -4.519661905727819e-23,  6.651064007975466e-02, -6.787506819227512e-04,  6.926748677471821e-06,
 -7.068847003500566e-08,  7.213860395375368e-10, -7.361848647624365e-12,  7.512872742924042e-14, -7.666994690826185e-16,  7.824276638076633e-18, -7.984776933741996e-20,
  8.148534787152522e-22, -8.314651981271324e-24,  2.192631632449492e-01, -2.237612228578590e-03,  2.283515576160320e-05, -2.330360604892374e-07,  2.378166632557293e-09,
 -2.426953371192454e-11,  2.476740923260126e-13, -2.527549722119369e-15,  2.579400206355366e-17, -2.632311377099273e-19,  2.686295156074283e-21, -2.741051554290008e-23,
  6.390135602619453e-02, -6.265441098630052e-04,  6.143179832413162e-06, -6.023304322746350e-08,  5.905768014826765e-10, -5.790525261395710e-12,  5.677531299703587e-14,
 -5.566742203954236e-16,  5.458114719220074e-18, -5.351605595522982e-20,  5.247169000477970e-22, -5.144253378725906e-24,  2.106612331672631e-01, -2.065504756476855e-03,
  2.025199337763520e-05, -1.985680422573596e-07,  1.946932663354151e-09, -1.908941011711609e-11,  1.871690710651779e-13, -1.835167277927361e-15,  1.799356446304643e-17,
 -1.764243921554156e-19,  1.729814438811115e-21, -1.695885566017691e-23,  6.148910850550922e-02, -5.801375659301468e-04,  5.473483086410216e-06, -5.164122935078946e-08,
  4.872247756589373e-10, -4.596869303667055e-12,  4.337055183572431e-14, -4.091925696317194e-16,  3.860650832111788e-18, -3.642447355867993e-20,  3.436575716769949e-22,
 -3.242047622016043e-24,  2.027088661282298e-01, -1.912518022237299e-03,  1.804422892419796e-05, -1.702437277364025e-07,  1.606215868530800e-09, -1.515432874097472e-11,
  1.429780915569629e-13, -1.348969985299066e-15,  1.272726455881944e-17, -1.200792115567935e-19,  1.132923135477326e-21, -1.068793615740678e-23,  5.925238756035172e-02,
 -5.387025932859677e-04,  4.897701104743516e-06, -4.452823582133857e-08,  4.048356040834648e-10, -3.680627882718986e-12,  3.346301924416495e-14, -3.042344111150379e-16,
  2.765995978442152e-18, -2.514749601789154e-20,  2.286324754948823e-22, -2.078476243635074e-24,  1.953351510483061e-01, -1.775920882891830e-03,  1.614606979524811e-05,
 -1.467945854707779e-07,  1.334606538729326e-09, -1.213378959102089e-11,  1.103162958941911e-13, -1.002958312618191e-15,  9.118556471903456e-18, -8.290281836346143e-20,
  7.537242045610926e-22, -6.852035308220165e-24,  5.717270468026810e-02, -5.015535492227333e-04,  4.399931123509356e-06, -3.859885733363401e-08,  3.386125249782746e-10,
 -2.970513895810901e-12,  2.605914475743343e-14, -2.286065809629211e-16,  2.005475210898894e-18, -1.759324159069341e-20,  1.543385532694342e-22, -1.353846828176395e-24,
  1.884791375399907e-01, -1.653453005525691e-03,  1.450508993814698e-05, -1.272474230659112e-07,  1.116291367096533e-09, -9.792783116768332e-12,  8.590821715312779e-14,
 -7.536388466553584e-16,  6.611375833890912e-18, -5.799898778073989e-20,  5.088021898878630e-22, -4.463176635191021e-24,  5.523408020802621e-02, -4.681190474877184e-04,
  3.967395524565386e-06, -3.362441099719272e-08,  2.849731033640653e-10, -2.415199768040600e-12,  2.046926482067237e-14, -1.734808059502294e-16,  1.470281922330470e-18,
 -1.246091126715878e-20,  1.056085270715647e-22, -8.949874966717623e-25,  1.820881460592574e-01, -1.543230722246694e-03,  1.307916585251528e-05, -1.108483501083745e-07,
  9.394602729489350e-10, -7.962099603522387e-12,  6.748026704443303e-14, -5.719077463280959e-16,  4.847023946255810e-18, -4.107942455267099e-20,  3.481557187234791e-22,
 -2.950472117705441e-24,  5.342263168973623e-02, -4.379198478515059e-04,  3.589748147490279e-06, -2.942614230807709e-08,  2.412140951282558e-10, -1.977297570282227e-12,
  1.620844619118598e-14, -1.328650436231515e-16,  1.089130914108985e-18, -8.927902445384874e-21,  7.318444514778305e-23, -5.998724978909829e-25,  1.761164108346473e-01,
 -1.443674139544114e-03,  1.183418973456853e-05, -9.700807324704991e-08,  7.952015715631123e-10, -6.518483650386640e-12,  5.343378411188373e-14, -4.380112672881385e-16,
  3.590497537361568e-18, -2.943228525440788e-20,  2.412644491534288e-22, -1.977577440217621e-24,  5.172624071123025e-02, -4.105515814474430e-04,  3.258551147568744e-06,
 -2.586314621876781e-08,  2.052759959997686e-10, -1.629277203061961e-12,  1.293158604097154e-14, -1.026381006379013e-16,  8.146394161642400e-19, -6.465799485956617e-21,
  5.131910141914227e-23, -4.072944551833229e-25,  1.705239815391031e-01, -1.353450189555217e-03,  1.074234485421626e-05, -8.526207603164891e-08,  6.767257715035484e-10,
 -5.371177798287196e-12,  4.263108064690995e-14, -3.383632241146962e-16,  2.685591584713324e-18, -2.131556163785082e-20,  1.691817805135464e-22, -1.342712541892376e-24
  };
  constexpr double w[768] = {  8.217044013350129e-02, -2.095080733173159e-02,  3.199747739883691e-03, -3.653041521082034e-04,  3.389664575828230e-05,
 -2.669467244414375e-06,  1.831463935489036e-07, -1.113668023201176e-08,  6.075688894933050e-10, -3.001485043016446e-11,  1.352863514645828e-12, -5.593014156297880e-14,
  1.442177268973693e-01, -5.084892957905012e-02,  9.900478372508317e-03, -1.348561525344196e-03,  1.421188181324683e-04, -1.225235029159208e-05,  8.953682324667308e-07,
 -5.684967421703147e-08,  3.193843843106192e-09, -1.610074496547113e-10,  7.364513155437630e-12, -3.079651222399246e-13,  3.092912429762084e-02, -6.574681913845349e-03,
  8.654337442921429e-04, -8.762873517013969e-05,  7.376276413948772e-06, -5.366265287484452e-07,  3.453827855386454e-08, -1.996551528766789e-09,  1.047307382323888e-10,
 -5.022351962500608e-12,  2.214071767324153e-13, -9.000919694156241e-15,  3.382086662910298e-02, -1.078977347568513e-02,  1.960596418182907e-03, -2.537355612757251e-04,
  2.570834277356369e-05, -2.148478534702900e-06,  1.530829313227255e-07, -9.516758970363193e-09,  5.251203125987188e-10, -2.606131810796889e-11,  1.175754310526925e-12,
 -4.857547530116758e-14,  1.385414424109516e-02, -2.446742707238865e-03,  2.745008896193467e-04, -2.428720564570599e-05,  1.826273752848223e-06, -1.207620449729169e-07,
  7.169120145072569e-09, -3.874922350909415e-10,  1.923701443704990e-11, -8.825484632952422e-13,  3.760104516990072e-14, -1.490352313483846e-15,  9.528288419656371e-03,
 -2.602137144588500e-03,  4.280170225830035e-04, -5.155515277402940e-05,  4.945846808223371e-06, -3.962055432791489e-07,  2.729926158733295e-08, -1.651374745927447e-09,
  8.907416576080599e-11, -4.336403296953916e-12,  1.923870593353948e-13, -7.831626816933952e-15,  7.131636517757842e-03, -1.056879759033969e-03,  1.012353040164624e-04,
 -7.772213699573087e-06,  5.173123783899570e-07, -3.080739603391596e-08,  1.666559612922164e-09, -8.302288642039365e-11,  3.849286729213373e-12, -1.666166212969418e-13,
  6.747717465133845e-15, -2.572368743748521e-16,  3.373205309268166e-03, -7.379687298910949e-04,  1.057825628130040e-04, -1.157572168799637e-05,  1.031225558145559e-06,
 -7.796234451598149e-08,  5.135958475284271e-09, -2.997600581945400e-10,  1.569626213681734e-11, -7.456367045670224e-13,  3.241942654355169e-14, -1.296452516755683e-15,
  4.084080382180146e-03, -5.151702655314934e-04,  4.265583894082131e-05, -2.847409656951167e-06,  1.666196372017974e-07, -8.898679548038270e-09,  4.380427906950336e-10,
 -1.990810723110679e-11,  8.473431181228507e-13, -3.439140176869146e-14,  1.323409321070309e-15, -4.724624421929310e-17,  1.515285612939469e-03, -2.527455099235544e-04,
  3.022152306946896e-05, -2.932973548001137e-06,  2.382936174985909e-07, -1.667990969954041e-08,  1.033107398897390e-09, -5.757118253310410e-11,  2.905896739333131e-12,
 -1.335274288564651e-13,  5.642531733399275e-15, -2.213984480904481e-16,  2.539383600309476e-03, -2.758523932976874e-04,  2.004842372265992e-05, -1.180202671597011e-06,
  6.067048764699764e-08, -2.870170197115083e-09,  1.286025143112756e-10, -5.423157570474198e-12,  2.108905908867027e-13, -7.643353300487131e-15,  2.735853136285636e-16,
 -9.921058390202764e-18,  8.314546990532711e-04, -1.056537665543209e-04,  1.011556658764825e-05, -8.455613788413380e-07,  6.197840102469428e-08, -3.976401550411304e-09,
  2.268488930020083e-10, -1.179559818038968e-11,  5.685139566897349e-13, -2.535952461709936e-14,  1.035455572552186e-15, -3.874181096041579e-17,  1.685714230397797e-03,
 -1.590955258005081e-04,  1.024534901602586e-05, -5.415661483347270e-07,  2.491379988586691e-08, -1.038881509426928e-09,  4.110477611689955e-11, -1.596296590369213e-12,
  6.006134766927243e-14, -2.070227669228993e-15,  6.266797440544943e-17, -1.779679663872125e-18,  5.241412779862696e-04, -5.301806272700354e-05,  4.015806504196925e-06,
 -2.781638614821140e-07,  1.801192097320013e-08, -1.062823274150400e-09,  5.615174512058231e-11, -2.673221307958209e-12,  1.178417292922659e-13, -4.961556977166299e-15,
  2.007928428193802e-16, -7.564024350983413e-18,  1.179946165853777e-03, -9.764440777417368e-05,  5.592498087292695e-06, -2.675923766732012e-07,  1.126402691109152e-08,
 -4.261813551165284e-10,  1.486043141991805e-11, -4.995899768034563e-13,  1.706006636915251e-14, -5.939609785941177e-16,  1.953904110671955e-17, -5.388122422830568e-19,
  3.604434090082699e-04, -3.058519111540928e-05,  1.887908922507919e-06, -1.062607897954044e-07,  5.830422308293610e-09, -3.097475111917307e-10,  1.537445818447755e-11,
 -6.927736341607542e-13,  2.815095470476181e-14, -1.053305860122517e-15,  3.804654752185064e-17, -1.387638888828199e-18,  8.621171003387356e-04, -6.322678434914785e-05,
  3.233442628322962e-06, -1.400333338397436e-07,  5.425207307211449e-09, -1.910616455236539e-10,  6.148057236916958e-12, -1.831111318420684e-13,  5.255815359317989e-15,
 -1.563161853252588e-16,  5.047200546738960e-18, -1.665439531446641e-19,  2.619830003412907e-04, -1.936372863608809e-05,  1.018588836094867e-06, -4.761388219778086e-08,
  2.162125931377624e-09, -9.859948297485439e-11,  4.454756985400743e-12, -1.919636595594273e-13,  7.611894910507692e-15, -2.721232146605844e-16,  8.784512886712331e-18,
 -2.652821813548304e-19,  6.520593862103846e-04, -4.285097629980584e-05,  1.969668997074463e-06, -7.723939268576235e-08,  2.744490433196195e-09, -9.012479652519484e-11,
  2.741445895125712e-12, -7.693580009536806e-14,  1.995164037904693e-15, -4.913478379232952e-17,  1.243454680016695e-18, -3.579694133658229e-20,  1.978779883413612e-04,
 -1.303191874949509e-05,  6.045141291256302e-07, -2.441497710653367e-08,  9.350558697878119e-10, -3.575056960669452e-11,  1.395160874621669e-12, -5.486202704738595e-14,
  2.096798878545711e-15, -7.494899478992519e-17,  2.432908386662768e-18, -7.044515614241970e-20,  5.071986409811795e-04, -3.017155088444545e-05,  1.256636229479968e-06,
 -4.479336519619292e-08,  1.456848787611440e-09, -4.431879262684020e-11,  1.269588080518779e-12, -3.411740985528939e-14,  8.520113641769578e-16, -1.961407008006797e-17,
  4.199112380988411e-19, -8.883990878961502e-21,  1.538666956522468e-04, -9.158043071168739e-06,  3.824405248361126e-07, -1.376712253324541e-08,  4.610949055974278e-10,
 -1.506578767661291e-11,  4.979101056260992e-13, -1.695294439423930e-14,  5.891165550363376e-16, -2.023947196383250e-17,  6.619596119584287e-19, -1.993263639474505e-20,
  4.036967569028851e-04, -2.193030164206483e-05,  8.343154484646810e-07, -2.719596682829933e-08,  8.113187863578774e-10, -2.278397080957377e-11,  6.092545887366934e-13,
 -1.553083138206503e-14,  3.749430886927717e-16, -8.468004880911528e-18,  1.762696295894353e-19, -3.350057875915632e-21,  1.224586314189794e-04, -6.653275517990408e-06,
  2.532954519874337e-07, -8.281038073905805e-09,  2.495304484987575e-10, -7.207745731315670e-12,  2.059882854154986e-13, -5.991906794139525e-15,  1.804751555458023e-16,
 -5.600420607705282e-18,  1.743717150773971e-19, -5.255254577913614e-21,  3.275293030798016e-04, -1.637062197773464e-05,  5.730342459346138e-07, -1.719247555233145e-08,
  4.726047759399943e-10, -1.226377046743764e-11,  3.047850735778082e-13, -7.294530537244319e-15,  1.678934398440935e-16, -3.688175951945518e-18,  7.629954290117097e-20,
 -1.458642943834548e-21,  9.935217454278786e-05, -4.965982657923150e-06,  1.738589056420794e-07, -5.220472229937326e-09,  1.439502162213581e-10, -3.772122959789332e-12,
  9.624590032684614e-14, -2.447541109939813e-15,  6.351315419270113e-17, -1.710313349526113e-18,  4.776058226656670e-20, -1.353660874439984e-21,  2.700685179617348e-04,
 -1.249940242529360e-05,  4.051214155964800e-07, -1.125547078643384e-08,  2.866184951534869e-10, -6.897166781921047e-12,  1.593597062891848e-13, -3.564166926172027e-15,
  7.736240993731571e-17, -1.625642956893625e-18,  3.281837382518522e-20, -6.279169973169906e-22,  8.192185155479257e-05, -3.791558941389904e-06,  1.228943162904912e-07,
 -3.415091148071783e-09,  8.704143531378002e-11, -2.101032065826245e-12,  4.899546021846768e-14, -1.122456945427886e-15,  2.572650355608681e-17, -6.019345408481287e-19,
  1.461730835813279e-20, -3.693438624411935e-22,  2.257951917952995e-04, -9.730017242162879e-06,  2.936102014152078e-07, -7.594827617623904e-09,  1.800833743212015e-10,
 -4.036550756240792e-12,  8.695778721044333e-14, -1.817407407175608e-15,  3.703015912716137e-17, -7.363572212579829e-19,  1.425046408232867e-20, -2.663802554886669e-22,
  6.849205672998371e-05, -2.951479033977860e-06,  8.906381764480475e-08, -2.303937557461796e-09,  5.464231120668706e-11, -1.225908985256528e-12,  2.648781691846646e-14,
 -5.583303691581453e-16,  1.162386320721080e-17, -2.425461530524280e-19,  5.161983501748685e-21, -1.138162926526075e-22,  1.910575756901462e-04, -7.702180626209109e-06,
  2.174213705788662e-07, -5.261120604331217e-09,  1.167011166056187e-10, -2.447374146647073e-12,  4.934368615488669e-14, -9.660157704294275e-16,  1.847347488596324e-17,
 -3.461400078570786e-19,  6.356646995403436e-21, -1.140609336851778e-22,  5.795484212940158e-05, -2.336357402333438e-06,  6.595211006244614e-08, -1.595916027946561e-09,
  3.540241447381339e-11, -7.426194410568485e-13,  1.498592026719371e-14, -2.942000604109783e-16,  5.669567869317853e-18, -1.082717441359935e-19,  2.073770189836779e-21,
 -4.043027972204561e-23,  1.633681348303746e-04, -6.186943956993208e-06,  1.640618660525685e-07, -3.729265065204422e-09,  7.770725506611538e-11, -1.530881799763453e-12,
  2.899834363133257e-14, -5.335282728935924e-16,  9.595859845744748e-18, -1.693893501527445e-19,  2.940569453278546e-21, -5.018427267370742e-23,  4.955560756941897e-05,
 -1.876729407071035e-06,  4.976606590341554e-08, -1.131227924340163e-09,  2.357190998768850e-11, -4.644116900204865e-13,  8.799206692703993e-15, -1.620299947271714e-16,
  2.921630070862918e-18, -5.192733257537302e-20,  9.165223407843408e-22, -1.621963140448844e-23,  1.409889778868115e-04, -5.034421554408347e-06,  1.258701705611538e-07,
 -2.697596112872446e-09,  5.299724230531806e-11, -9.844065816913708e-13,  1.758168188031357e-14, -3.050291277564165e-16,  5.174653836970232e-18, -8.621519540519789e-20,
  1.414686410579383e-21, -2.288708500669185e-23,  4.276718001011698e-05, -1.527126575757795e-06,  3.818108939599188e-08, -8.182814096341034e-10,  1.607609308445544e-11,
 -2.986130810483870e-13,  5.333642975232918e-15, -9.255730195521336e-17,  1.571419456536481e-18, -2.624125838557041e-20,  4.331717195449790e-22, -7.108653218882513e-24,
  1.226787468274722e-04, -4.143890065923385e-06,  9.800411203560496e-08, -1.986819257087702e-09,  3.692272234630579e-11, -6.487455053171319e-13,  1.096031795577148e-14,
 -1.798786303817535e-16,  2.886910679031001e-18, -4.551473697866062e-20,  7.071159412281743e-22, -1.084496866869418e-23,  3.721300858861155e-05, -1.256995371170115e-06,
  2.972827835220251e-08, -6.026759720880061e-10,  1.120003980270684e-11, -1.967894986122574e-13,  3.324744024998497e-15, -5.456870718905967e-17,  8.759867037203007e-19,
 -1.382059490041883e-20,  2.151492123295686e-22, -3.316818428099488e-24,  1.075332397697837e-04, -3.446082551824151e-06,  7.732072098908267e-08, -1.487105000173870e-09,
  2.621849286097670e-11, -4.370376520172754e-13,  7.004850270491807e-15, -1.090661493012299e-16,  1.660696069658478e-18, -2.484215281006994e-20,  3.662660978180703e-22,
 -5.333615365908972e-24,  3.261881522319003e-05, -1.045324499488155e-06,  2.345423913343096e-08, -4.510940504743539e-10,  7.953041745071114e-12, -1.325698578058766e-13,
  2.124842034558429e-15, -3.308456321420924e-17,  5.037946679039410e-19, -7.537808217823308e-21,  1.112064782593649e-22, -1.622242635344907e-24,  9.488228214897549e-05,
 -2.892376096074445e-06,  6.173098173841624e-08, -1.129340758469703e-09,  1.893940507338078e-11, -3.002979297849547e-13,  4.578331440172712e-15, -6.780693107970819e-17,
  9.820946463802279e-19, -1.397468624597965e-20,  1.960058006164893e-22, -2.715796671334124e-24,  2.878131111762104e-05, -8.773648189110663e-07,  1.872529361690765e-08,
 -3.425708908859310e-10,  5.745023417533184e-12, -9.109150942060611e-14,  1.388779297496130e-15, -2.056847183795667e-17,  2.979125437881544e-19, -4.239394278335693e-21,
  5.947225814287153e-23, -8.244924433521090e-25,  8.422135974804740e-05, -2.448005710135858e-06,  4.981659577139024e-08, -8.689748970803266e-10,  1.389502061102098e-11,
 -2.100658623734787e-13,  3.053658777495529e-15, -4.312187428112548e-17,  5.955085708569638e-19, -8.079620563066117e-21,  1.080541463921870e-22, -1.427665019873223e-24,
  2.554745841633530e-05, -7.425708189756057e-07,  1.511121896975839e-08, -2.635922780276469e-10,  4.214874533307005e-12, -6.372076146752760e-14,  9.262881010796481e-16,
 -1.308048001300501e-17,  1.806408678947035e-19, -2.450903128618084e-21,  3.277938569049994e-23, -4.331718452127323e-25,  7.516530534142081e-05, -2.087699614823049e-06,
  4.059603878269046e-08, -6.766580845069337e-10,  1.033886903288254e-11, -1.493553549042784e-13,  2.074613186957804e-15, -2.799403614858311e-17,  3.694088942847275e-19,
 -4.789195641414806e-21,  6.120235479843525e-23, -7.727209399341148e-25,  2.280042163062218e-05, -6.332766326157126e-07,  1.231428245514254e-08, -2.052554640737273e-10,
  3.136161989650006e-12, -4.530501257861430e-14,  6.293070752940332e-16, -8.491630967324904e-18,  1.120555643193810e-19, -1.452748889671567e-21,  1.856533650782463e-23,
 -2.344116529011127e-25,  6.741630894123806e-05, -1.792809396376623e-06,  3.337818735830547e-08, -5.326720985996422e-10,  7.792462736771832e-12, -1.077787757048831e-13,
  1.433376148079411e-15, -1.851821261006169e-17,  2.339652733447473e-19, -2.904138572752355e-21,  3.553320457849140e-23, -4.295448302499373e-25,  2.044986395862197e-05,
 -5.438255050659910e-07,  1.012484073046420e-08, -1.615791805049769e-10,  2.363742622944119e-12, -3.269329544614363e-14,  4.347960917429567e-16, -5.617260314532447e-18,
  7.097035930131843e-20, -8.809340997228913e-22,  1.077859774482128e-23, -1.302994360076072e-25,  6.074142988966828e-05, -1.549385106003693e-06,  2.766867161331778e-08,
 -4.235303965989481e-10,  5.942893584125398e-12, -7.884148640008663e-14,  1.005726582344223e-15, -1.246283760323296e-17,  1.510314331355772e-19, -1.798172584425530e-21,
  2.110312179163880e-23, -2.446948106376506e-25,  1.842512586944746e-05, -4.699859000721794e-07,  8.392933094301615e-09, -1.284724590960656e-10,  1.802699780408839e-12,
 -2.391554354270332e-14,  3.050741307880656e-16, -3.780440397310880e-18,  4.581343238448268e-20, -5.454525534195209e-22,  6.401367797033551e-24, -7.422539372685434e-26,
  5.495653403358952e-05, -1.346860595257818e-06,  2.310873535197907e-08, -3.398568030232324e-10,  4.581760824460462e-12, -5.839990289313464e-14,  7.157477429931544e-16,
 -8.521570746453384e-18,  9.921850371288299e-20, -1.134956701891472e-21,  1.279726767650447e-23, -1.425681400571627e-25,  1.667035265315165e-05, -4.085527133836119e-07,
  7.009735502068690e-09, -1.030911584510739e-10,  1.389817790737803e-12, -1.771485399060823e-14,  2.171128056716581e-16, -2.584908100865175e-18,  3.009664831143956e-20,
 -3.442744417969446e-22,  3.881886751701186e-24, -4.324625786005937e-26,  4.991465184063497e-05, -1.177140682208262e-06,  1.943457502325162e-08, -2.750344009009200e-10,
  3.567921243599863e-12, -4.376093283076147e-14,  5.160905704891363e-16, -5.912579765745817e-18,  6.624321607658627e-20, -7.291541940516810e-22,  7.911315061455742e-24,
 -8.481041116156890e-26,  1.514096300603841e-05, -3.570703764322080e-07,  5.895226564028357e-09, -8.342812252253005e-11,  1.082282687865261e-12, -1.327431206429646e-14,
  1.565493887750569e-16, -1.793504477585988e-18,  2.009402151838874e-20, -2.211794831731721e-22,  2.399795143300387e-24, -2.572614848921189e-26,  4.549742726917798e-05,
 -1.033957665952492e-06,  1.644983634173717e-08, -2.243286969192780e-10,  2.804297030178984e-12, -3.314408913854508e-14,  3.766657287472255e-16, -4.158318978939254e-18,
  4.489446083542677e-20, -4.761910899655460e-22,  4.978758795067747e-24, -5.143225390368276e-26,  1.380105515614839e-05, -3.136376633454116e-07,  4.989844751413602e-09,
 -6.804720409734811e-11,  8.506471752516072e-13, -1.005383006816717e-14,  1.142566692234013e-16, -1.261372192654265e-18,  1.361815311208895e-20, -1.444463988775653e-22,
  1.510242013202404e-24, -1.560130927295122e-26,  4.160875922865134e-05, -9.124113571244663e-07,  1.400671887840916e-08, -1.843086833141521e-10,  2.223160399272886e-12,
 -2.535353624740154e-14,  2.780187849423340e-16, -2.961565610778677e-18,  3.085189225329583e-20, -3.157590253768455e-22,  3.185525158612779e-24, -3.175294778762217e-26,
  1.262147808261974e-05, -2.767681651595610e-07,  4.248756718790231e-09, -5.590765141788376e-11,  6.743669067221748e-13, -7.690666772956098e-15,  8.433339676009150e-17,
 -8.983525618380189e-19,  9.358521839563264e-21, -9.578140987856771e-23,  9.662877939338437e-25, -9.631845560985690e-27,  3.817001953291218e-05, -8.086360375336788e-07,
  1.199280661270206e-08, -1.524584596205272e-10,  1.776632338259766e-12, -1.957429828500656e-14,  2.073684187787892e-16, -2.134079525493017e-18,  2.147789817339812e-20,
 -2.123667179428178e-22,  2.069819217253773e-24, -1.993236818902894e-26,  1.157838094379133e-05, -2.452892663408221e-07,  3.637862522636494e-09, -4.624629867082013e-11,
  5.389184040551422e-13, -5.937609805408123e-15,  6.290252343897122e-17, -6.473453776823569e-19,  6.515042171236986e-21, -6.441869275312415e-23,  6.278528463312419e-25,
 -6.046225701741802e-27,  3.511641854203041e-05, -7.195564382942531e-07,  1.032176635427384e-08, -1.269128258642468e-10,  1.430448054696701e-12, -1.524337545314659e-14,
  1.561916831174420e-16, -1.554698527318567e-18,  1.513378766717567e-20, -1.447313326034424e-22,  1.364359295330039e-24, -1.270802284282079e-26,  1.065211064172134e-05,
 -2.182681239118796e-07,  3.130974108083534e-09, -3.849736160711868e-11,  4.339078863531326e-13, -4.623880470210176e-15,  4.737872365579267e-17, -4.715976575948491e-19,
  4.590638435053360e-21, -4.390237479498208e-23,  4.138607174608154e-25, -3.854814105003421e-27,  3.239421600188801e-05, -6.427069575914891e-07,  8.926696384797377e-09,
 -1.062747974546238e-10,  1.159804173081811e-12, -1.196689312062316e-14,  1.187259888074787e-16, -1.144251951324832e-18,  1.078476454347135e-20, -9.986495953825644e-23,
  9.115213559429233e-25, -8.220644789531512e-27,  9.826365766512463e-06, -1.949568295033998e-07,  2.707797705569141e-09, -3.223708304872381e-11,  3.518115709781396e-13,
 -3.630002000516141e-15,  3.601399064404590e-17, -3.470940059827729e-19,  3.271418610775328e-21, -3.029274175469165e-23,  2.764981948456685e-25, -2.493626101483130e-27
  };
  int offset = -2;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 2;
    if (std::isnan(t)) {
      fill_n(rr+offset, 2, 0.5);
      fill_n(ww+offset, 2, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 2; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=2; ++j) {
        const int boxof = it*24+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
