#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2020, Antoine "vv221/vv222" Le Gonidec
# Copyright (c) 2020, macaron
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Blade Runner
# build native packages from the original installers
# send your bug reports to vv221@dotslashplay.it
###

script_version=20200221.1

# Set game-specific variables

GAME_ID='blade-runner'
GAME_NAME='Blade Runner'

ARCHIVES_LIST='ARCHIVE_GOG_EN ARCHIVE_GOG_FR'

ARCHIVE_GOG_EN='blade_runner_1_0_svm_src_34722.sh'
ARCHIVE_GOG_EN_URL='https://www.gog.com/game/blade_runner'
ARCHIVE_GOG_EN_TYPE='mojosetup_unzip'
ARCHIVE_GOG_EN_MD5='d9dd6f98eb8dc9401d5499a1d48e5d76'
ARCHIVE_GOG_EN_SIZE='1700000'
ARCHIVE_GOG_EN_VERSION='1.0-gog34722'

ARCHIVE_GOG_FR='blade_runner_french_1_0_svm_src_34722.sh'
ARCHIVE_GOG_FR_URL='https://www.gog.com/game/blade_runner'
ARCHIVE_GOG_FR_TYPE='mojosetup_unzip'
ARCHIVE_GOG_FR_MD5='98ee3723ac6114a6b464af0b07f76757'
ARCHIVE_GOG_FR_SIZE='1700000'
ARCHIVE_GOG_FR_VERSION='1.0-gog34722'

ARCHIVE_OPTIONAL_SUBTITLES='Blade_Runner_Subtitles-v6.zip'
ARCHIVE_OPTIONAL_SUBTITLES_URL='https://www.scummvm.org/games/#bladerunner'
ARCHIVE_OPTIONAL_SUBTITLES_MD5='f9b4e5738d3c6092cac3485c41f47cb2'

ARCHIVE_DOC0_MAIN_PATH='data/noarch/docs'
ARCHIVE_DOC0_MAIN_FILES='*.txt'

ARCHIVE_DOC1_MAIN_PATH='data/noarch/game/data'
ARCHIVE_DOC1_MAIN_FILES='*.pdf'

ARCHIVE_DOC2_MAIN_PATH='.'
ARCHIVE_DOC2_MAIN_FILES='readme.txt'

ARCHIVE_GAME0_MAIN_PATH='data/noarch/game/data'
ARCHIVE_GAME0_MAIN_FILES='*.dat *.mix *.tlk'

ARCHIVE_GAME1_MAIN_PATH='.'
ARCHIVE_GAME1_MAIN_FILES='subtitles.mix'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='bladerunner'
APP_MAIN_ICON='data/noarch/support/icon.png'

APP_RESTORED_TYPE='scummvm'
APP_RESTORED_SCUMMID='bladerunner-final'
APP_RESTORED_ID="${GAME_ID}-restored"
APP_RESTORED_NAME="$GAME_NAME with restored content"
APP_RESTORED_ICON='data/noarch/support/icon.png'

PACKAGES_LIST='PKG_MAIN'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_GOG_EN="${GAME_ID}-en"
PKG_MAIN_ID_GOG_FR="${GAME_ID}-fr"
PKG_MAIN_PROVIDE="$PKG_MAIN_ID"
PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.11'

if [ -z "$PLAYIT_LIB2" ]; then
	: "${XDG_DATA_HOME:="$HOME/.local/share"}"
	for path in\
		"$PWD"\
		"$XDG_DATA_HOME/play.it"\
		'/usr/local/share/games/play.it'\
		'/usr/local/share/play.it'\
		'/usr/share/games/play.it'\
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Try to load subtitles archive

ARCHIVE_MAIN="$ARCHIVE"
archive_set 'ARCHIVE_SUBTITLES' 'ARCHIVE_OPTIONAL_SUBTITLES'
ARCHIVE="$ARCHIVE_MAIN"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Extract subtitles data

if [ "$ARCHIVE_SUBTITLES" ]; then
	(
		ARCHIVE='ARCHIVE_SUBTITLES'
		extract_data_from "$ARCHIVE_SUBTITLES"
	)
fi

tolower "$PLAYIT_WORKDIR/gamedata"
prepare_package_layout

# Get icons

icons_get_from_workdir 'APP_MAIN'
rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

launchers_write 'APP_MAIN' 'APP_RESTORED'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
