/* $Header: /home/walid/PAM/pam_dpasswd/RCS/pam_auth_dpasswd.c,v 1.1 1998/04/23 22:09:05 walid Exp walid $ */

/*
 * by Walid Harmoush <walid@cinenet.net>.
 * pieces of the code borrowed from pam_shells and pam_unix.
 * This is free software. Use at your own risk.
 */

/* 
 * $Log: pam_auth_dpasswd.c,v $
 *
 * Revision 1.1  1998/04/23 22:09:05  walid
 * Initial revision
 *
 */

#ifdef linux
# define _GNU_SOURCE
# include <features.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <stdarg.h>

#ifndef NDEBUG

#include <syslog.h>

#endif	/* NDEBUG */

#define _PAM_EXTERN_FUNCTIONS
#include <security/pam_modules.h>

static const char rcsid[] = "$Id: pam_auth_dpasswd.c,v 1.1 1998/04/23 22:09:05 walid Exp walid $";

/* Define function phototypes */

extern char*
crypt(const char *key, const char *salt);

extern	int
converse(pam_handle_t *pamh, int nargs, struct pam_message **message,
                        struct pam_response **response  ); 
                        
extern 	int
_set_auth_tok(pam_handle_t *pamh, int flags, int argc, const char **argv);


static	int
_pam_auth_dpasswd(pam_handle_t *pamh, int flags, int argc, const char **argv);

static	int
_pam_set_cred_dpasswd(pam_handle_t *pamh, int flags, int argc,
					const char ** argv ) ;

void
_pam_log(int err, const char *format, ...);


static int
_pam_auth_dpasswd(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
        int retval;
	char *p, *pp, *pa, *salt, *from;
	const char *userName;
	char *userShell;
	struct passwd * pw;

	retval = pam_get_user(pamh,&userName,NULL);
     	if(retval != PAM_SUCCESS)
       		return PAM_SERVICE_ERR;

	if(!userName || (strlen(userName) <= 0)) {
       		/* Don't let them use a NULL username... */
       		pam_get_user(pamh,&userName,NULL);
        	if (retval != PAM_SUCCESS)
          		return PAM_SERVICE_ERR;
     	}

     	pw = getpwnam(userName);
     	if (!pw)
        	return PAM_AUTH_ERR;            /* user doesn't exist */

     	userShell = pw->pw_shell;

	/* remote host name */

	if (pam_get_item(pamh, PAM_RHOST,(const void **)&from)!=PAM_SUCCESS) {
		_pam_log(LOG_ERR, "cannot find the remote host name");
		return PAM_ABORT;
    	}

	if (from) return PAM_SUCCESS;

        /* local login, set tty name */

        if (pam_get_item(pamh, PAM_TTY, (const void **)&from)
					!= PAM_SUCCESS || from == NULL) {
            	_pam_log(LOG_NOTICE, "PAM_TTY not set, probing stdin");
            	from = ttyname(STDIN_FILENO);
            	if (from == NULL) {
               		_pam_log(LOG_ERR, "couldn't get the tty name");
               		return PAM_ABORT;
             	}
            	if (pam_set_item(pamh, PAM_TTY, from) != PAM_SUCCESS) {
               		_pam_log(LOG_ERR, "couldn't set tty name");
               		return PAM_ABORT;
             	}
        }

	retval = _is_dialup_term(from);

	if (retval == PAM_SERVICE_ERR)
		return PAM_SUCCESS;
	else if (retval == PAM_AUTH_ERR)
		return retval;

	retval = _set_auth_tok(pamh,flags,argc,argv);
	if ( retval != PAM_SUCCESS ) 
		return retval;
	
	pam_get_item(pamh,PAM_AUTHTOK,(void*)&p);

	retval = _get_dialup_passwd(userShell,&pa);

	if (retval != PAM_SUCCESS)
		return retval;

	salt = pa;

	pp = crypt(p, salt);

	if (strcmp(pp,salt) == 0) 
		retval = PAM_SUCCESS;
	else
  		retval =  PAM_AUTH_ERR;
	
	free(pa);

	return retval;
}

/* 
 * The only thing _pam_set_credentials_unix() does is initialization of
 * UNIX group IDs.
 *
 */

static	int
_pam_set_cred_dpasswd(pam_handle_t *pamh, int flags, int argc,
					const char **argv )

{
	return	PAM_SUCCESS;
}


int
converse(pam_handle_t *pamh, int nargs, struct pam_message **message,
		struct pam_response **response	)
{
	int retval;
	struct pam_conv *conv;

	retval = pam_get_item(	pamh, PAM_CONV,  (const void **) &conv ) ; 
	if ( retval == PAM_SUCCESS )
		{
	  		retval = conv->conv(nargs,
				( const struct pam_message ** ) message, 
	  			response, conv->appdata_ptr );
     		}
	return retval;
}


/***************************************************************************/
/* prompt user for a dialup passwd using conversation calls		   */
/***************************************************************************/

int
_set_auth_tok(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
	int	retval;
	char	*p;
	
	struct pam_message msg[1],*pmsg[1];
	struct pam_response *resp;

	/* set up conversation call */

	pmsg[0] = &msg[0];
	msg[0].msg_style = PAM_PROMPT_ECHO_OFF;
	msg[0].msg = "Dialup Password: ";
	resp = NULL;

	if ((retval = converse(pamh,1,pmsg,&resp)) != PAM_SUCCESS) 
		return retval;

	if (resp) 
	{
		if ((flags & PAM_DISALLOW_NULL_AUTHTOK) && resp[0].resp==NULL) 
       		{
			free(resp);
			return PAM_AUTH_ERR;
  		}
		p = resp[0].resp;
		resp[0].resp = NULL;
	} 
	else return PAM_CONV_ERR;

	free(resp);
	pam_set_item(pamh,PAM_AUTHTOK,p);
	return PAM_SUCCESS;
}

void
_pam_log(int err, const char *format, ...)
{
    va_list args;

    va_start(args, format);
    openlog("PAM-dpasswd", LOG_CONS|LOG_PID, LOG_AUTH);
    vsyslog(err, format, args);
    va_end(args);
    closelog();
}

/*
 * PAM framework looks for these entry-points to pass control to the
 * authentication module.
 */
 
PAM_EXTERN int
pam_sm_authenticate(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
	return _pam_auth_dpasswd(pamh, flags, argc, argv);
}

PAM_EXTERN int
pam_sm_setcred( pam_handle_t *pamh, int flags, int argc, const char **argv)
{
	return _pam_set_cred_dpasswd(pamh, flags, argc, argv);
}


/* static module data */
#ifdef PAM_STATIC
struct pam_module _pam_unix_auth_modstruct = {
    "pam_auth_dpasswd",
    pam_sm_authenticate,
    pam_sm_setcred,
    NULL,
    NULL,
    NULL,
    NULL,
};
#endif
