/* pam_rootok module */

/*
 * $Id: pam_rootok.c,v 1.4 1996/12/01 03:10:14 morgan Exp $
 *
 * Written by Andrew Morgan <morgan@parc.power.net> 1996/3/11
 *
 * $Log: pam_rootok.c,v $
 * Revision 1.4  1996/12/01 03:10:14  morgan
 * reformatted
 *
 * Revision 1.3  1996/06/02 08:11:01  morgan
 * updated for new static protocol
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>

/*
 * here, we make a definition for the externally accessible function
 * in this file (this definition is required for static a module
 * but strongly encouraged generally) it is used to instruct the
 * modules include file to define the function prototypes.
 */

#define PAM_SM_AUTH

#include <security/pam_modules.h>

/* some syslogging */

static void _pam_log(int err, const char *format, ...)
{
    char buf[1024];
    va_list args;

    va_start(args, format);
    vsprintf(buf, format, args);

    openlog("pam_rootok_auth", LOG_CONS|LOG_PID, LOG_AUTH);
    syslog(err, buf);
    closelog();
}

/* argument parsing */

#define PAM_DEBUG_ARG       01

static int _pam_parse(int argc, const char **argv)
{
    int ctrl=0;

    /* step through arguments */
    for (ctrl=0; argc-- > 0; ++argv) {

	/* generic options */

	if (!strcmp(*argv,"debug"))
	    ctrl |= PAM_DEBUG_ARG;
	else {
	    _pam_log(LOG_ERR,"pam_parse: unknown option; %s",*argv);
	}
    }

    return ctrl;
}

/* --- authentication management functions (only) --- */

PAM_EXTERN
int pam_sm_authenticate(pam_handle_t *pamh,int flags,int argc
			,const char **argv)
{
    int ctrl;
    int retval = PAM_AUTH_ERR;

    ctrl = _pam_parse(argc, argv);
    if (getuid() == 0)
	retval = PAM_SUCCESS;

    if (ctrl & PAM_DEBUG_ARG) {
	_pam_log(LOG_DEBUG, "authetication %s"
		 , retval==PAM_SUCCESS ? "succeeded":"failed" );
    }

    return retval;
}

PAM_EXTERN
int pam_sm_setcred(pam_handle_t *pamh,int flags,int argc
		   ,const char **argv)
{
    return PAM_SUCCESS;
}


#ifdef PAM_STATIC

/* static module data */

struct pam_module _pam_rootok_modstruct = {
    "pam_rootok",
    pam_sm_authenticate,
    pam_sm_setcred,
    NULL,
    NULL,
    NULL,
    NULL,
};

#endif

/* end of module definition */
