/*
 *  ebtables
 *
 *	Authors:
 *	Bart De Schuymer		<bdschuym@pandora.be>
 *
 *  ebtables.c,v 2.0, April, 2002
 *
 *  This code is stongly inspired on the iptables code which is
 *  Copyright (C) 1999 Paul `Rusty' Russell & Michael J. Neuling
 */
#ifndef __LINUX_BRIDGE_EFF_H
#define __LINUX_BRIDGE_EFF_H

#include <uapi/linux/netfilter_bridge/ebtables.h>


/* return values for match() functions */
#define EBT_MATCH 0
#define EBT_NOMATCH 1

struct ebt_match {
	struct list_head list;
	const char name[EBT_FUNCTION_MAXNAMELEN];
	bool (*match)(const struct sk_buff *skb, const struct net_device *in,
		const struct net_device *out, const struct xt_match *match,
		const void *matchinfo, int offset, unsigned int protoff,
		bool *hotdrop);
	bool (*checkentry)(const char *table, const void *entry,
		const struct xt_match *match, void *matchinfo,
		unsigned int hook_mask);
	void (*destroy)(const struct xt_match *match, void *matchinfo);
	unsigned int matchsize;
	u_int8_t revision;
	u_int8_t family;
	struct module *me;
};

struct ebt_watcher {
	struct list_head list;
	const char name[EBT_FUNCTION_MAXNAMELEN];
	unsigned int (*target)(struct sk_buff *skb,
		const struct net_device *in, const struct net_device *out,
		unsigned int hook_num, const struct xt_target *target,
		const void *targinfo);
	bool (*checkentry)(const char *table, const void *entry,
		const struct xt_target *target, void *targinfo,
		unsigned int hook_mask);
	void (*destroy)(const struct xt_target *target, void *targinfo);
	unsigned int targetsize;
	u_int8_t revision;
	u_int8_t family;
	struct module *me;
};

struct ebt_target {
	struct list_head list;
	const char name[EBT_FUNCTION_MAXNAMELEN];
	/* returns one of the standard EBT_* verdicts */
	unsigned int (*target)(struct sk_buff *skb,
		const struct net_device *in, const struct net_device *out,
		unsigned int hook_num, const struct xt_target *target,
		const void *targinfo);
	bool (*checkentry)(const char *table, const void *entry,
		const struct xt_target *target, void *targinfo,
		unsigned int hook_mask);
	void (*destroy)(const struct xt_target *target, void *targinfo);
	unsigned int targetsize;
	u_int8_t revision;
	u_int8_t family;
	struct module *me;
};

/* used for jumping from and into user defined chains (udc) */
struct ebt_chainstack {
	struct ebt_entries *chaininfo; /* pointer to chain data */
	struct ebt_entry *e; /* pointer to entry data */
	unsigned int n; /* n'th entry */
};

struct ebt_table_info {
	/* total size of the entries */
	unsigned int entries_size;
	unsigned int nentries;
	/* pointers to the start of the chains */
	struct ebt_entries *hook_entry[NF_BR_NUMHOOKS];
	/* room to maintain the stack used for jumping from and into udc */
	struct ebt_chainstack **chainstack;
	char *entries;
	struct ebt_counter counters[0] ____cacheline_aligned;
};

struct ebt_table {
	struct list_head list;
	char name[EBT_TABLE_MAXNAMELEN];
	struct ebt_replace_kernel *table;
	unsigned int valid_hooks;
	rwlock_t lock;
	/* e.g. could be the table explicitly only allows certain
	 * matches, targets, ... 0 == let it in */
	int (*check)(const struct ebt_table_info *info,
	   unsigned int valid_hooks);
	/* the data used by the kernel */
	struct ebt_table_info *private;
	struct module *me;
};

#define EBT_ALIGN(s) (((s) + (__alignof__(struct _xt_align)-1)) & \
		     ~(__alignof__(struct _xt_align)-1))
extern struct ebt_table *ebt_register_table(struct net *net,
					    const struct ebt_table *table);
extern void ebt_unregister_table(struct net *net, struct ebt_table *table);
extern unsigned int ebt_do_table(unsigned int hook, struct sk_buff *skb,
   const struct net_device *in, const struct net_device *out,
   struct ebt_table *table);

/* Used in the kernel match() functions */
#define FWINV(bool,invflg) ((bool) ^ !!(info->invflags & invflg))
/* True if the hook mask denotes that the rule is in a base chain,
 * used in the check() functions */
#define BASE_CHAIN (par->hook_mask & (1 << NF_BR_NUMHOOKS))
/* Clear the bit in the hook mask that tells if the rule is on a base chain */
#define CLEAR_BASE_CHAIN_BIT (par->hook_mask &= ~(1 << NF_BR_NUMHOOKS))
/* True if the target is not a standard target */
#define INVALID_TARGET (info->target < -NUM_STANDARD_TARGETS || info->target >= 0)

#endif
