#
# symlinks()
# Called by protopkg() to remove any symlinks found in the temporary
# package build directory.  Also makes the doinst.sh file for recreating
# those at install time.
#
# Parameters:   $1    The package tree.
#               $2    The embedded package control directory.
#

symlinks() {
   # Get rid of possible pre-existing trouble:
   rm -rf $TMP/iNsT-a.$$

   cd $1
   if [ "$VERBOSE" = "y" ]
   then
      echo
      find . -type l -exec ls -l {} \; | cut -b58- | tee $TMP/iNsT-a.$$
   else
      find . -type l -exec ls -l {} \; | cut -b58- > $TMP/iNsT-a.$$
   fi

   cd $TMP

   # create the install directory if we need it
   if [ ! -d $2 ]
   then
      mkdir -p $2
      chown root.root $2
      chmod 755 $2
   fi

   if [ ! "`file_size $TMP/iNsT-a.$$`" = "0" ]
   then
      if [ "$VERBOSE" = "y" ]
      then
         echo
         make_install_script $TMP/iNsT-a.$$ | tee $TMP/doinst.sh
      else
         make_install_script $TMP/iNsT-a.$$ > $TMP/doinst.sh
      fi

      # write out the doinst script
      cat $TMP/doinst.sh >> $2/doinst.sh
      chown root.root $2/doinst.sh
      chmod 644 $2/doinst.sh

      # remove symlinks and clean up temp files
      cd $1
      if [ "$VERBOSE" = "y" ]
      then
         echo
         find . -type l -exec rm -v {} \;
      else
         find . -type l -exec rm {} \;
      fi
      cd $TMP ; rm -f doinst.sh iNsT-a.$$
   fi

   rm -rf $TMP/iNsT-a.$$
}
