#
# afterinstall()
# Called by protopkg() after the install function from the package
# prototype file is run.  Generates a listing of all files on the system,
# compares against what beforeinstall() found and from that generates a
# list of files that go in the package.  Neat, huh?
#

afterinstall() {
   cd $TMP
   find / $IPATH -printf "%p - %T@ - %s\n" > $TMP/after.lst
   cat before.lst after.lst | sort | uniq -u > $TMP/package.lst

   # in the case that the destination stuff existed, eliminate duplicates
   cat package.lst | cut -d' ' -f1 | uniq | 
                     grep -v "usr/info/dir" | 
                     grep -v usr/local/info/dir > $TMP/package.new
   rm -f package.lst ; mv package.new package.lst

   # remove the before and after lists, since we don't need them anymore
   rm -rf $TMP/before.lst
   rm -rf $TMP/after.lst
}
