.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutMotionFunc 3 "April 2025" "freeglut" "freeglut"
.SH NAME
glutMotionFunc, glutPassiveMotionFunc - set the motion and
passive motion callbacks respectively for the current window.
.SH SYNTAX
.nf
.LP
void glutMotionFunc(void (*func)(int x, int y));
void glutPassiveMotionFunc(void (*func)(int x, int y));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new motion or passive motion callback function.
.SH DESCRIPTION
glutMotionFunc and glutPassiveMotionFunc set the motion and
passive motion callback respectively for the current window. The motion
callback for a window is called when the mouse moves within the window
while one or more mouse buttons are pressed. The passive motion callback
for a window is called when the mouse moves within the window while
no mouse buttons are pressed.

The x and y callback parameters indicate the mouse location in window
relative coordinates.

Passing NULL to glutMotionFunc or glutPassiveMotionFunc
disables the generation of the mouse or passive motion callback
respectively.
.SH SEE ALSO
glutMouseFunc, glutSpaceballMotionFunc, glutTabletMotionFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
