---
title: How to use Lensfun?
linktitle: Usage
layout: default
weight: 3
---
Lensfun itself is only a library for correcting several artefacts and a database for storing lens profiles. To actually use Lensfun to process your images you need an image editing application with Lensfun support.

So far you can use Lensfun with the following applications:

* <a href="https://www.acdsee.com/">ACDSee</a> commercial image viewer and editor (since version 9)
* <a href="https://affinity.serif.com/photo/">Affinity Photo</a> commercial image editor (since version 1.5)
* <a href="https://www.darktable.org/">Darktable</a> RAW processor and photo workflow software similar to Adobe Lightroom
* <a href="https://digikam.org/">Digikam/Kipi</a> image management application, supports Lensfun via Kipi-Plugin
* <a href="https://www.alienskin.com/exposure/">Exposure X3</a> commercial non-destructive RAW editor
* <a href="https://seebk.github.io/GIMP-Lensfun/">GimpLensfun</a> GIMP plugin
* <a href="http://hugin.sourceforge.net/">Hugin</a> panorama stitcher (version 2011.4.0 - 2014.0.0)
* <a href="https://github.com/neothemachine/lensfunpy">lensfunpy</a> Python wrapper for Lensfun
* <a href="https://www.on1.com/">ON1 Photo RAW</a> commercial RAW processor and photo editor
* <a href="http://photivo.org/">Photivo</a> photo processor application
* <a href="https://rawstudio.org/">Rawstudio</a> another raw processor
* <a href="http://rawtherapee.com/">Rawtherapee</a> raw converter and image processor (since version 5.3)
* <a href="http://ufraw.sourceforge.net/">UFRaw</a> is a standalone raw processor but also contains a GIMP plugin to load RAW image files

If the above applications do not recognize your camera or lens in their Lensfun tool please check the <a href="/lenslist/">list of supported lenses</a> and the <a href="/faq/">FAQ</a>.
