/*
  Copyright 1999-2021 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.  You may
  obtain a copy of the License at
  
    https://imagemagick.org/script/license.php
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include "coders/coders-private.h"

#define MagickJP2Headers \
  MagickCoderHeader("JP2", 0, "\x00\x00\x00\x0c\x6a\x50\x20\x20\x0d\x0a\x87\x0a") \
  MagickCoderHeader("JPC", 0, "\x0d\x0a\x87\x0a") \
  MagickCoderHeader("J2K", 0, "\xff\x4f\xff\x51")

#define MagickJP2Aliases \
  MagickCoderAlias("JP2", "J2C") \
  MagickCoderAlias("JP2", "J2K") \
  MagickCoderAlias("JP2", "JPM") \
  MagickCoderAlias("JP2", "JPT") \
  MagickCoderAlias("JP2", "JPC")

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

MagickCoderExports(JP2)

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
