; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

; The mask is all-ones, potentially shifted.

;------------------------------------------------------------------------------;
; 8-bit
;------------------------------------------------------------------------------;

; lshr

define i8 @test_i8_7_mask_lshr_1(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}

define i8 @test_i8_28_mask_lshr_1(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x1c
; CHECK-NEXT:    lsr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_2(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_lshr_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #2, #3
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_3(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_lshr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #3, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_4(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #4, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_lshr_1(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xe0
; CHECK-NEXT:    lsr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_4(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xe0
; CHECK-NEXT:    lsr w0, w8, #4
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_5(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_lshr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #5, #3
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_6(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_lshr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #6, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 6
  ret i8 %t1
}

; ashr

define i8 @test_i8_7_mask_ashr_1(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}

define i8 @test_i8_28_mask_ashr_1(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x1c
; CHECK-NEXT:    lsr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_2(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_ashr_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #2, #3
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_3(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_ashr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #3, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_4(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #4, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_ashr_1(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xe0
; CHECK-NEXT:    sbfx w0, w8, #1, #7
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_4(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xe0
; CHECK-NEXT:    sbfx w0, w8, #4, #4
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_5(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_ashr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #5, #3
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_6(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_ashr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #6, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 6
  ret i8 %t1
}

; shl

define i8 @test_i8_7_mask_shl_1(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_4(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7
; CHECK-NEXT:    lsl w0, w8, #4
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_5(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_shl_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #5
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_6(i8 %a0) {
; CHECK-LABEL: test_i8_7_mask_shl_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #6
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 6
  ret i8 %t1
}

define i8 @test_i8_28_mask_shl_1(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x1c
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_2(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_shl_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x1c
; CHECK-NEXT:    lsl w0, w8, #2
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_3(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_shl_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x1c
; CHECK-NEXT:    lsl w0, w8, #3
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_4(i8 %a0) {
; CHECK-LABEL: test_i8_28_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xc
; CHECK-NEXT:    lsl w0, w8, #4
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_shl_1(i8 %a0) {
; CHECK-LABEL: test_i8_224_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x60
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i8 %a0, 224
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}

;------------------------------------------------------------------------------;
; 16-bit
;------------------------------------------------------------------------------;

; lshr

define i16 @test_i16_127_mask_lshr_1(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = lshr i16 %t0, 1
  ret i16 %t1
}

define i16 @test_i16_2032_mask_lshr_3(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_lshr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f0
; CHECK-NEXT:    lsr w0, w8, #3
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_4(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #4, #7
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_5(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_lshr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #5, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_6(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_lshr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #6, #5
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_lshr_1(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfe00
; CHECK-NEXT:    lsr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_8(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_lshr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfe00
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_9(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_lshr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #9, #7
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_10(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_lshr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #10, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 10
  ret i16 %t1
}

; ashr

define i16 @test_i16_127_mask_ashr_1(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = ashr i16 %t0, 1
  ret i16 %t1
}

define i16 @test_i16_2032_mask_ashr_3(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_ashr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f0
; CHECK-NEXT:    lsr w0, w8, #3
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_4(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #4, #7
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_5(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_ashr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #5, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_6(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_ashr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #6, #5
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_ashr_1(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfe00
; CHECK-NEXT:    sbfx w0, w8, #1, #15
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_8(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_ashr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfe00
; CHECK-NEXT:    sbfx w0, w8, #8, #8
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_9(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_ashr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #9, #7
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_10(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_ashr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #10, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 10
  ret i16 %t1
}

; shl

define i16 @test_i16_127_mask_shl_1(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_8(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_shl_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_9(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_shl_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #9
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_10(i16 %a0) {
; CHECK-LABEL: test_i16_127_mask_shl_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #10
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 10
  ret i16 %t1
}

define i16 @test_i16_2032_mask_shl_3(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_shl_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f0
; CHECK-NEXT:    lsl w0, w8, #3
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_4(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f0
; CHECK-NEXT:    lsl w0, w8, #4
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_5(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_shl_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7f0
; CHECK-NEXT:    lsl w0, w8, #5
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_6(i16 %a0) {
; CHECK-LABEL: test_i16_2032_mask_shl_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x3f0
; CHECK-NEXT:    lsl w0, w8, #6
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_shl_1(i16 %a0) {
; CHECK-LABEL: test_i16_65024_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7e00
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i16 %a0, 65024
  %t1 = shl i16 %t0, 1
  ret i16 %t1
}

;------------------------------------------------------------------------------;
; 32-bit
;------------------------------------------------------------------------------;

; lshr

define i32 @test_i32_32767_mask_lshr_1(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #14
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = lshr i32 %t0, 1
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_lshr_7(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_lshr_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff00
; CHECK-NEXT:    lsr w0, w8, #7
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_8(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_lshr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #8, #15
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_9(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_lshr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #9, #14
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_10(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_lshr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #10, #13
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_lshr_1(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfffe0000
; CHECK-NEXT:    lsr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_16(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_lshr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfffe0000
; CHECK-NEXT:    lsr w0, w8, #16
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_17(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_lshr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w0, w0, #17
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_18(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_lshr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w0, w0, #18
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 18
  ret i32 %t1
}

; ashr

define i32 @test_i32_32767_mask_ashr_1(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #1, #14
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = ashr i32 %t0, 1
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_ashr_7(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_ashr_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff00
; CHECK-NEXT:    lsr w0, w8, #7
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_8(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_ashr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #8, #15
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_9(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_ashr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #9, #14
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_10(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_ashr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #10, #13
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_ashr_1(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfffe0000
; CHECK-NEXT:    asr w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_16(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_ashr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xfffe0000
; CHECK-NEXT:    asr w0, w8, #16
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_17(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_ashr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w0, w0, #17
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_18(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_ashr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w0, w0, #18
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 18
  ret i32 %t1
}

; shl

define i32 @test_i32_32767_mask_shl_1(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_16(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_shl_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff
; CHECK-NEXT:    lsl w0, w8, #16
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_17(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_shl_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #17
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_18(i32 %a0) {
; CHECK-LABEL: test_i32_32767_mask_shl_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #18
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 18
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_shl_7(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_shl_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff00
; CHECK-NEXT:    lsl w0, w8, #7
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_8(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_shl_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff00
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_9(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_shl_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff00
; CHECK-NEXT:    lsl w0, w8, #9
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_10(i32 %a0) {
; CHECK-LABEL: test_i32_8388352_mask_shl_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x3fff00
; CHECK-NEXT:    lsl w0, w8, #10
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_shl_1(i32 %a0) {
; CHECK-LABEL: test_i32_4294836224_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7ffe0000
; CHECK-NEXT:    lsl w0, w8, #1
; CHECK-NEXT:    ret
  %t0 = and i32 %a0, 4294836224
  %t1 = shl i32 %t0, 1
  ret i32 %t1
}

;------------------------------------------------------------------------------;
; 64-bit
;------------------------------------------------------------------------------;

; lshr

define i64 @test_i64_2147483647_mask_lshr_1(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #1, #30
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = lshr i64 %t0, 1
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_lshr_15(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_lshr_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff0000
; CHECK-NEXT:    lsr x0, x8, #15
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_16(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_lshr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #16, #31
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_17(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_lshr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #17, #30
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_18(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_lshr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #18, #29
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_lshr_1(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xfffffffe00000000
; CHECK-NEXT:    lsr x0, x8, #1
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_32(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_lshr_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xfffffffe00000000
; CHECK-NEXT:    lsr x0, x8, #32
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_33(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_lshr_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x0, x0, #33
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_34(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_lshr_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x0, x0, #34
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 34
  ret i64 %t1
}

; ashr

define i64 @test_i64_2147483647_mask_ashr_1(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #1, #30
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = ashr i64 %t0, 1
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_ashr_15(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_ashr_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff0000
; CHECK-NEXT:    lsr x0, x8, #15
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_16(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_ashr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #16, #31
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_17(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_ashr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #17, #30
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_18(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_ashr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx x0, x0, #18, #29
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_ashr_1(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xfffffffe00000000
; CHECK-NEXT:    asr x0, x8, #1
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_32(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_ashr_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xfffffffe00000000
; CHECK-NEXT:    asr x0, x8, #32
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_33(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_ashr_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr x0, x0, #33
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_34(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_ashr_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr x0, x0, #34
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 34
  ret i64 %t1
}

; shl

define i64 @test_i64_2147483647_mask_shl_1(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff
; CHECK-NEXT:    lsl x0, x8, #1
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_32(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_shl_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fffffff
; CHECK-NEXT:    lsl x0, x8, #32
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_33(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_shl_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl x0, x0, #33
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_34(i64 %a0) {
; CHECK-LABEL: test_i64_2147483647_mask_shl_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl x0, x0, #34
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 34
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_shl_15(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_shl_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff0000
; CHECK-NEXT:    lsl x0, x8, #15
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_16(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_shl_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff0000
; CHECK-NEXT:    lsl x0, x8, #16
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_17(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_shl_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7fffffff0000
; CHECK-NEXT:    lsl x0, x8, #17
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_18(i64 %a0) {
; CHECK-LABEL: test_i64_140737488289792_mask_shl_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x3fffffff0000
; CHECK-NEXT:    lsl x0, x8, #18
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_shl_1(i64 %a0) {
; CHECK-LABEL: test_i64_18446744065119617024_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0x7ffffffe00000000
; CHECK-NEXT:    lsl x0, x8, #1
; CHECK-NEXT:    ret
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = shl i64 %t0, 1
  ret i64 %t1
}
