/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import info.aduna.net.ParsedURI;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTBaseDecl;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.VisitorException;

class BaseDeclProcessor {
    BaseDeclProcessor() {
    }

    public static void process(ASTQueryContainer qc, String externalBaseURI) throws MalformedQueryException {
        ParsedURI parsedBaseURI = null;
        ASTBaseDecl baseDecl = qc.getBaseDecl();
        if (baseDecl != null) {
            parsedBaseURI = new ParsedURI(baseDecl.getIRI());
            if (!parsedBaseURI.isAbsolute()) {
                throw new MalformedQueryException("BASE IRI is not an absolute IRI: " + externalBaseURI);
            }
        } else if (externalBaseURI != null && !(parsedBaseURI = new ParsedURI(externalBaseURI)).isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI is not an absolute IRI: " + externalBaseURI);
        }
        if (parsedBaseURI != null) {
            RelativeIRIResolver visitor = new RelativeIRIResolver(parsedBaseURI);
            try {
                qc.jjtAccept(visitor, null);
            }
            catch (VisitorException e) {
                throw new MalformedQueryException(e);
            }
        }
    }

    private static class RelativeIRIResolver
    extends ASTVisitorBase {
        private ParsedURI parsedBaseURI;

        public RelativeIRIResolver(ParsedURI parsedBaseURI) {
            this.parsedBaseURI = parsedBaseURI;
        }

        public Object visit(ASTIRI node, Object data) throws VisitorException {
            ParsedURI resolvedURI = this.parsedBaseURI.resolve(node.getValue());
            node.setValue(resolvedURI.toString());
            return super.visit(node, data);
        }
    }
}

