
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)

#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Alter_table*_statement
#include "sql_truncate.h"                      // Truncate_statement
#include "sql_admin.h"                         // Analyze/Check..._table_stmt
#include "sql_partition_admin.h"               // Alter_table_*_partition_stmt
#include "sql_signal.h"
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable_t *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->dflt)
    it= spv->dflt;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_NO_WRITE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}



/* Line 189 of yacc.c  */
#line 792 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ALWAYS_SYM = 269,
     ANALYZE_SYM = 270,
     AND_AND_SYM = 271,
     AND_SYM = 272,
     ANY_SYM = 273,
     AS = 274,
     ASC = 275,
     ASCII_SYM = 276,
     ASENSITIVE_SYM = 277,
     AT_SYM = 278,
     AUTHORS_SYM = 279,
     AUTOEXTEND_SIZE_SYM = 280,
     AUTO_INC = 281,
     AVG_ROW_LENGTH = 282,
     AVG_SYM = 283,
     BACKUP_SYM = 284,
     BEFORE_SYM = 285,
     BEGIN_SYM = 286,
     BETWEEN_SYM = 287,
     BIGINT = 288,
     BINARY = 289,
     BINLOG_SYM = 290,
     BIN_NUM = 291,
     BIT_AND = 292,
     BIT_OR = 293,
     BIT_SYM = 294,
     BIT_XOR = 295,
     BLOB_SYM = 296,
     BLOCK_SYM = 297,
     BOOLEAN_SYM = 298,
     BOOL_SYM = 299,
     BOTH = 300,
     BTREE_SYM = 301,
     BY = 302,
     BYTE_SYM = 303,
     CACHE_SYM = 304,
     CALL_SYM = 305,
     CASCADE = 306,
     CASCADED = 307,
     CASE_SYM = 308,
     CAST_SYM = 309,
     CATALOG_NAME_SYM = 310,
     CHAIN_SYM = 311,
     CHANGE = 312,
     CHANGED = 313,
     CHARSET = 314,
     CHAR_SYM = 315,
     CHECKPOINT_SYM = 316,
     CHECKSUM_SYM = 317,
     CHECK_SYM = 318,
     CIPHER_SYM = 319,
     CLASS_ORIGIN_SYM = 320,
     CLIENT_SYM = 321,
     CLIENT_STATS_SYM = 322,
     CLOSE_SYM = 323,
     COALESCE = 324,
     CODE_SYM = 325,
     COLLATE_SYM = 326,
     COLLATION_SYM = 327,
     COLUMNS = 328,
     COLUMN_ADD_SYM = 329,
     COLUMN_CREATE_SYM = 330,
     COLUMN_DELETE_SYM = 331,
     COLUMN_EXISTS_SYM = 332,
     COLUMN_GET_SYM = 333,
     COLUMN_LIST_SYM = 334,
     COLUMN_SYM = 335,
     COLUMN_NAME_SYM = 336,
     COMMENT_SYM = 337,
     COMMITTED_SYM = 338,
     COMMIT_SYM = 339,
     COMPACT_SYM = 340,
     COMPLETION_SYM = 341,
     COMPRESSED_SYM = 342,
     CONCURRENT = 343,
     CONDITION_SYM = 344,
     CONNECTION_SYM = 345,
     CONSISTENT_SYM = 346,
     CONSTRAINT = 347,
     CONSTRAINT_CATALOG_SYM = 348,
     CONSTRAINT_NAME_SYM = 349,
     CONSTRAINT_SCHEMA_SYM = 350,
     CONTAINS_SYM = 351,
     CONTEXT_SYM = 352,
     CONTINUE_SYM = 353,
     CONTRIBUTORS_SYM = 354,
     CONVERT_SYM = 355,
     COUNT_SYM = 356,
     CPU_SYM = 357,
     CREATE = 358,
     CROSS = 359,
     CUBE_SYM = 360,
     CURDATE = 361,
     CURRENT_USER = 362,
     CURSOR_SYM = 363,
     CURSOR_NAME_SYM = 364,
     CURTIME = 365,
     DATABASE = 366,
     DATABASES = 367,
     DATAFILE_SYM = 368,
     DATA_SYM = 369,
     DATETIME = 370,
     DATE_ADD_INTERVAL = 371,
     DATE_SUB_INTERVAL = 372,
     DATE_SYM = 373,
     DAY_HOUR_SYM = 374,
     DAY_MICROSECOND_SYM = 375,
     DAY_MINUTE_SYM = 376,
     DAY_SECOND_SYM = 377,
     DAY_SYM = 378,
     DEALLOCATE_SYM = 379,
     DECIMAL_NUM = 380,
     DECIMAL_SYM = 381,
     DECLARE_SYM = 382,
     DEFAULT = 383,
     DEFINER_SYM = 384,
     DELAYED_SYM = 385,
     DELAY_KEY_WRITE_SYM = 386,
     DELETE_SYM = 387,
     DESC = 388,
     DESCRIBE = 389,
     DES_KEY_FILE = 390,
     DETERMINISTIC_SYM = 391,
     DIRECTORY_SYM = 392,
     DISABLE_SYM = 393,
     DISCARD = 394,
     DISK_SYM = 395,
     DISTINCT = 396,
     DIV_SYM = 397,
     DOUBLE_SYM = 398,
     DO_SYM = 399,
     DROP = 400,
     DUAL_SYM = 401,
     DUMPFILE = 402,
     DUPLICATE_SYM = 403,
     DYNAMIC_SYM = 404,
     EACH_SYM = 405,
     ELSE = 406,
     ELSEIF_SYM = 407,
     ENABLE_SYM = 408,
     ENCLOSED = 409,
     END = 410,
     ENDS_SYM = 411,
     END_OF_INPUT = 412,
     ENGINES_SYM = 413,
     ENGINE_SYM = 414,
     ENUM = 415,
     EQ = 416,
     EQUAL_SYM = 417,
     ERROR_SYM = 418,
     ERRORS = 419,
     ESCAPED = 420,
     ESCAPE_SYM = 421,
     EVENTS_SYM = 422,
     EVENT_SYM = 423,
     EVERY_SYM = 424,
     EXAMINED_SYM = 425,
     EXECUTE_SYM = 426,
     EXISTS = 427,
     EXIT_SYM = 428,
     EXPANSION_SYM = 429,
     EXTENDED_SYM = 430,
     EXTENT_SIZE_SYM = 431,
     EXTRACT_SYM = 432,
     FALSE_SYM = 433,
     FAST_SYM = 434,
     FAULTS_SYM = 435,
     FETCH_SYM = 436,
     FILE_SYM = 437,
     FIRST_SYM = 438,
     FIXED_SYM = 439,
     FLOAT_NUM = 440,
     FLOAT_SYM = 441,
     FLUSH_SYM = 442,
     FORCE_SYM = 443,
     FOREIGN = 444,
     FOR_SYM = 445,
     FOUND_SYM = 446,
     FROM = 447,
     FULL = 448,
     FULLTEXT_SYM = 449,
     FUNCTION_SYM = 450,
     GE = 451,
     GENERAL = 452,
     GENERATED_SYM = 453,
     GEOMETRYCOLLECTION = 454,
     GEOMETRY_SYM = 455,
     GET_FORMAT = 456,
     GLOBAL_SYM = 457,
     GRANT = 458,
     GRANTS = 459,
     GROUP_SYM = 460,
     GROUP_CONCAT_SYM = 461,
     GT_SYM = 462,
     HANDLER_SYM = 463,
     HARD_SYM = 464,
     HASH_SYM = 465,
     HAVING = 466,
     HELP_SYM = 467,
     HEX_NUM = 468,
     HEX_STRING = 469,
     HIGH_PRIORITY = 470,
     HOST_SYM = 471,
     HOSTS_SYM = 472,
     HOUR_MICROSECOND_SYM = 473,
     HOUR_MINUTE_SYM = 474,
     HOUR_SECOND_SYM = 475,
     HOUR_SYM = 476,
     IDENT = 477,
     IDENTIFIED_SYM = 478,
     IDENT_QUOTED = 479,
     IF = 480,
     IGNORE_SYM = 481,
     IGNORE_SERVER_IDS_SYM = 482,
     IMPORT = 483,
     INDEXES = 484,
     INDEX_SYM = 485,
     INDEX_STATS_SYM = 486,
     INFILE = 487,
     INITIAL_SIZE_SYM = 488,
     INNER_SYM = 489,
     INOUT_SYM = 490,
     INSENSITIVE_SYM = 491,
     INSERT = 492,
     INSERT_METHOD = 493,
     INSTALL_SYM = 494,
     INTERVAL_SYM = 495,
     INTO = 496,
     INT_SYM = 497,
     INVOKER_SYM = 498,
     IN_SYM = 499,
     IO_SYM = 500,
     IPC_SYM = 501,
     IS = 502,
     ISOLATION = 503,
     ISSUER_SYM = 504,
     ITERATE_SYM = 505,
     JOIN_SYM = 506,
     KEYS = 507,
     KEY_BLOCK_SIZE = 508,
     KEY_SYM = 509,
     KILL_SYM = 510,
     LANGUAGE_SYM = 511,
     LAST_SYM = 512,
     LAST_VALUE = 513,
     LE = 514,
     LEADING = 515,
     LEAVES = 516,
     LEAVE_SYM = 517,
     LEFT = 518,
     LESS_SYM = 519,
     LEVEL_SYM = 520,
     LEX_HOSTNAME = 521,
     LIKE = 522,
     LIMIT = 523,
     LINEAR_SYM = 524,
     LINES = 525,
     LINESTRING = 526,
     LIST_SYM = 527,
     LOAD = 528,
     LOCAL_SYM = 529,
     LOCATOR_SYM = 530,
     LOCKS_SYM = 531,
     LOCK_SYM = 532,
     LOGFILE_SYM = 533,
     LOGS_SYM = 534,
     LONGBLOB = 535,
     LONGTEXT = 536,
     LONG_NUM = 537,
     LONG_SYM = 538,
     LOOP_SYM = 539,
     LOW_PRIORITY = 540,
     LT = 541,
     MASTER_CONNECT_RETRY_SYM = 542,
     MASTER_HOST_SYM = 543,
     MASTER_LOG_FILE_SYM = 544,
     MASTER_LOG_POS_SYM = 545,
     MASTER_PASSWORD_SYM = 546,
     MASTER_PORT_SYM = 547,
     MASTER_SERVER_ID_SYM = 548,
     MASTER_SSL_CAPATH_SYM = 549,
     MASTER_SSL_CA_SYM = 550,
     MASTER_SSL_CERT_SYM = 551,
     MASTER_SSL_CIPHER_SYM = 552,
     MASTER_SSL_KEY_SYM = 553,
     MASTER_SSL_SYM = 554,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 555,
     MASTER_SYM = 556,
     MASTER_USER_SYM = 557,
     MASTER_HEARTBEAT_PERIOD_SYM = 558,
     MATCH = 559,
     MAX_CONNECTIONS_PER_HOUR = 560,
     MAX_QUERIES_PER_HOUR = 561,
     MAX_ROWS = 562,
     MAX_SIZE_SYM = 563,
     MAX_SYM = 564,
     MAX_UPDATES_PER_HOUR = 565,
     MAX_USER_CONNECTIONS_SYM = 566,
     MAX_VALUE_SYM = 567,
     MEDIUMBLOB = 568,
     MEDIUMINT = 569,
     MEDIUMTEXT = 570,
     MEDIUM_SYM = 571,
     MEMORY_SYM = 572,
     MERGE_SYM = 573,
     MESSAGE_TEXT_SYM = 574,
     MICROSECOND_SYM = 575,
     MIGRATE_SYM = 576,
     MINUTE_MICROSECOND_SYM = 577,
     MINUTE_SECOND_SYM = 578,
     MINUTE_SYM = 579,
     MIN_ROWS = 580,
     MIN_SYM = 581,
     MODE_SYM = 582,
     MODIFIES_SYM = 583,
     MODIFY_SYM = 584,
     MOD_SYM = 585,
     MONTH_SYM = 586,
     MULTILINESTRING = 587,
     MULTIPOINT = 588,
     MULTIPOLYGON = 589,
     MUTEX_SYM = 590,
     MYSQL_ERRNO_SYM = 591,
     NAMES_SYM = 592,
     NAME_SYM = 593,
     NATIONAL_SYM = 594,
     NATURAL = 595,
     NCHAR_STRING = 596,
     NCHAR_SYM = 597,
     NDBCLUSTER_SYM = 598,
     NE = 599,
     NEG = 600,
     NEW_SYM = 601,
     NEXT_SYM = 602,
     NODEGROUP_SYM = 603,
     NONE_SYM = 604,
     NOT2_SYM = 605,
     NOT_SYM = 606,
     NOW_SYM = 607,
     NO_SYM = 608,
     NO_WAIT_SYM = 609,
     NO_WRITE_TO_BINLOG = 610,
     NULL_SYM = 611,
     NUM = 612,
     NUMERIC_SYM = 613,
     NVARCHAR_SYM = 614,
     OFFSET_SYM = 615,
     OLD_PASSWORD = 616,
     ON = 617,
     ONE_SHOT_SYM = 618,
     ONE_SYM = 619,
     ONLINE_SYM = 620,
     OPEN_SYM = 621,
     OPTIMIZE = 622,
     OPTIONS_SYM = 623,
     OPTION = 624,
     OPTIONALLY = 625,
     OR2_SYM = 626,
     ORDER_SYM = 627,
     OR_OR_SYM = 628,
     OR_SYM = 629,
     OUTER = 630,
     OUTFILE = 631,
     OUT_SYM = 632,
     OWNER_SYM = 633,
     PACK_KEYS_SYM = 634,
     PAGE_SYM = 635,
     PAGE_CHECKSUM_SYM = 636,
     PARAM_MARKER = 637,
     PARSER_SYM = 638,
     PARSE_VCOL_EXPR_SYM = 639,
     PARTIAL = 640,
     PARTITIONING_SYM = 641,
     PARTITIONS_SYM = 642,
     PARTITION_SYM = 643,
     PASSWORD = 644,
     PERSISTENT_SYM = 645,
     PHASE_SYM = 646,
     PLUGINS_SYM = 647,
     PLUGIN_SYM = 648,
     POINT_SYM = 649,
     POLYGON = 650,
     PORT_SYM = 651,
     POSITION_SYM = 652,
     PRECISION = 653,
     PREPARE_SYM = 654,
     PRESERVE_SYM = 655,
     PREV_SYM = 656,
     PRIMARY_SYM = 657,
     PRIVILEGES = 658,
     PROCEDURE_SYM = 659,
     PROCESS = 660,
     PROCESSLIST_SYM = 661,
     PROFILE_SYM = 662,
     PROFILES_SYM = 663,
     PROXY_SYM = 664,
     PURGE = 665,
     QUARTER_SYM = 666,
     QUERY_SYM = 667,
     QUICK = 668,
     RANGE_SYM = 669,
     READS_SYM = 670,
     READ_ONLY_SYM = 671,
     READ_SYM = 672,
     READ_WRITE_SYM = 673,
     REAL = 674,
     REBUILD_SYM = 675,
     RECOVER_SYM = 676,
     REDOFILE_SYM = 677,
     REDO_BUFFER_SIZE_SYM = 678,
     REDUNDANT_SYM = 679,
     REFERENCES = 680,
     REGEXP = 681,
     RELAY = 682,
     RELAYLOG_SYM = 683,
     RELAY_LOG_FILE_SYM = 684,
     RELAY_LOG_POS_SYM = 685,
     RELAY_THREAD = 686,
     RELEASE_SYM = 687,
     RELOAD = 688,
     REMOVE_SYM = 689,
     RENAME = 690,
     REORGANIZE_SYM = 691,
     REPAIR = 692,
     REPEATABLE_SYM = 693,
     REPEAT_SYM = 694,
     REPLACE = 695,
     REPLICATION = 696,
     REQUIRE_SYM = 697,
     RESET_SYM = 698,
     RESIGNAL_SYM = 699,
     RESOURCES = 700,
     RESTORE_SYM = 701,
     RESTRICT = 702,
     RESUME_SYM = 703,
     RETURNS_SYM = 704,
     RETURN_SYM = 705,
     REVOKE = 706,
     RIGHT = 707,
     ROLLBACK_SYM = 708,
     ROLLUP_SYM = 709,
     ROUTINE_SYM = 710,
     ROWS_SYM = 711,
     ROW_FORMAT_SYM = 712,
     ROW_SYM = 713,
     RTREE_SYM = 714,
     SAVEPOINT_SYM = 715,
     SCHEDULE_SYM = 716,
     SCHEMA_NAME_SYM = 717,
     SECOND_MICROSECOND_SYM = 718,
     SECOND_SYM = 719,
     SECURITY_SYM = 720,
     SELECT_SYM = 721,
     SENSITIVE_SYM = 722,
     SEPARATOR_SYM = 723,
     SERIALIZABLE_SYM = 724,
     SERIAL_SYM = 725,
     SESSION_SYM = 726,
     SERVER_SYM = 727,
     SERVER_OPTIONS = 728,
     SET = 729,
     SET_VAR = 730,
     SHARE_SYM = 731,
     SHIFT_LEFT = 732,
     SHIFT_RIGHT = 733,
     SHOW = 734,
     SHUTDOWN = 735,
     SIGNAL_SYM = 736,
     SIGNED_SYM = 737,
     SIMPLE_SYM = 738,
     SLAVE = 739,
     SLOW = 740,
     SMALLINT = 741,
     SNAPSHOT_SYM = 742,
     SOCKET_SYM = 743,
     SOFT_SYM = 744,
     SONAME_SYM = 745,
     SOUNDS_SYM = 746,
     SOURCE_SYM = 747,
     SPATIAL_SYM = 748,
     SPECIFIC_SYM = 749,
     SQLEXCEPTION_SYM = 750,
     SQLSTATE_SYM = 751,
     SQLWARNING_SYM = 752,
     SQL_BIG_RESULT = 753,
     SQL_BUFFER_RESULT = 754,
     SQL_CACHE_SYM = 755,
     SQL_CALC_FOUND_ROWS = 756,
     SQL_NO_CACHE_SYM = 757,
     SQL_SMALL_RESULT = 758,
     SQL_SYM = 759,
     SQL_THREAD = 760,
     SSL_SYM = 761,
     STARTING = 762,
     STARTS_SYM = 763,
     START_SYM = 764,
     STATUS_SYM = 765,
     STDDEV_SAMP_SYM = 766,
     STD_SYM = 767,
     STOP_SYM = 768,
     STORAGE_SYM = 769,
     STRAIGHT_JOIN = 770,
     STRING_SYM = 771,
     SUBCLASS_ORIGIN_SYM = 772,
     SUBDATE_SYM = 773,
     SUBJECT_SYM = 774,
     SUBPARTITIONS_SYM = 775,
     SUBPARTITION_SYM = 776,
     SUBSTRING = 777,
     SUM_SYM = 778,
     SUPER_SYM = 779,
     SUSPEND_SYM = 780,
     SWAPS_SYM = 781,
     SWITCHES_SYM = 782,
     SYSDATE = 783,
     TABLES = 784,
     TABLESPACE = 785,
     TABLE_REF_PRIORITY = 786,
     TABLE_STATS_SYM = 787,
     TABLE_SYM = 788,
     TABLE_CHECKSUM_SYM = 789,
     TABLE_NAME_SYM = 790,
     TEMPORARY = 791,
     TEMPTABLE_SYM = 792,
     TERMINATED = 793,
     TEXT_STRING = 794,
     TEXT_SYM = 795,
     THAN_SYM = 796,
     THEN_SYM = 797,
     TIMESTAMP = 798,
     TIMESTAMP_ADD = 799,
     TIMESTAMP_DIFF = 800,
     TIME_SYM = 801,
     TINYBLOB = 802,
     TINYINT = 803,
     TINYTEXT = 804,
     TO_SYM = 805,
     TRAILING = 806,
     TRANSACTION_SYM = 807,
     TRANSACTIONAL_SYM = 808,
     TRIGGERS_SYM = 809,
     TRIGGER_SYM = 810,
     TRIM = 811,
     TRUE_SYM = 812,
     TRUNCATE_SYM = 813,
     TYPES_SYM = 814,
     TYPE_SYM = 815,
     UDF_RETURNS_SYM = 816,
     ULONGLONG_NUM = 817,
     UNCOMMITTED_SYM = 818,
     UNDEFINED_SYM = 819,
     UNDERSCORE_CHARSET = 820,
     UNDOFILE_SYM = 821,
     UNDO_BUFFER_SIZE_SYM = 822,
     UNDO_SYM = 823,
     UNICODE_SYM = 824,
     UNINSTALL_SYM = 825,
     UNION_SYM = 826,
     UNIQUE_SYM = 827,
     UNKNOWN_SYM = 828,
     UNLOCK_SYM = 829,
     UNSIGNED = 830,
     UNTIL_SYM = 831,
     UPDATE_SYM = 832,
     UPGRADE_SYM = 833,
     USAGE = 834,
     USER = 835,
     USER_STATS_SYM = 836,
     USE_FRM = 837,
     USE_SYM = 838,
     USING = 839,
     UTC_DATE_SYM = 840,
     UTC_TIMESTAMP_SYM = 841,
     UTC_TIME_SYM = 842,
     VALUES = 843,
     VALUE_SYM = 844,
     VARBINARY = 845,
     VARCHAR = 846,
     VARIABLES = 847,
     VARIANCE_SYM = 848,
     VARYING = 849,
     VAR_SAMP_SYM = 850,
     VIA_SYM = 851,
     VIEW_SYM = 852,
     VIRTUAL_SYM = 853,
     WAIT_SYM = 854,
     WARNINGS = 855,
     WEEK_SYM = 856,
     WHEN_SYM = 857,
     WHERE = 858,
     WHILE_SYM = 859,
     WITH = 860,
     WITH_CUBE_SYM = 861,
     WITH_ROLLUP_SYM = 862,
     WORK_SYM = 863,
     WRAPPER_SYM = 864,
     WRITE_SYM = 865,
     X509_SYM = 866,
     XA_SYM = 867,
     XML_SYM = 868,
     XOR = 869,
     YEAR_MONTH_SYM = 870,
     YEAR_SYM = 871,
     ZEROFILL = 872,
     IMPOSSIBLE_ACTION = 873
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ALWAYS_SYM 269
#define ANALYZE_SYM 270
#define AND_AND_SYM 271
#define AND_SYM 272
#define ANY_SYM 273
#define AS 274
#define ASC 275
#define ASCII_SYM 276
#define ASENSITIVE_SYM 277
#define AT_SYM 278
#define AUTHORS_SYM 279
#define AUTOEXTEND_SIZE_SYM 280
#define AUTO_INC 281
#define AVG_ROW_LENGTH 282
#define AVG_SYM 283
#define BACKUP_SYM 284
#define BEFORE_SYM 285
#define BEGIN_SYM 286
#define BETWEEN_SYM 287
#define BIGINT 288
#define BINARY 289
#define BINLOG_SYM 290
#define BIN_NUM 291
#define BIT_AND 292
#define BIT_OR 293
#define BIT_SYM 294
#define BIT_XOR 295
#define BLOB_SYM 296
#define BLOCK_SYM 297
#define BOOLEAN_SYM 298
#define BOOL_SYM 299
#define BOTH 300
#define BTREE_SYM 301
#define BY 302
#define BYTE_SYM 303
#define CACHE_SYM 304
#define CALL_SYM 305
#define CASCADE 306
#define CASCADED 307
#define CASE_SYM 308
#define CAST_SYM 309
#define CATALOG_NAME_SYM 310
#define CHAIN_SYM 311
#define CHANGE 312
#define CHANGED 313
#define CHARSET 314
#define CHAR_SYM 315
#define CHECKPOINT_SYM 316
#define CHECKSUM_SYM 317
#define CHECK_SYM 318
#define CIPHER_SYM 319
#define CLASS_ORIGIN_SYM 320
#define CLIENT_SYM 321
#define CLIENT_STATS_SYM 322
#define CLOSE_SYM 323
#define COALESCE 324
#define CODE_SYM 325
#define COLLATE_SYM 326
#define COLLATION_SYM 327
#define COLUMNS 328
#define COLUMN_ADD_SYM 329
#define COLUMN_CREATE_SYM 330
#define COLUMN_DELETE_SYM 331
#define COLUMN_EXISTS_SYM 332
#define COLUMN_GET_SYM 333
#define COLUMN_LIST_SYM 334
#define COLUMN_SYM 335
#define COLUMN_NAME_SYM 336
#define COMMENT_SYM 337
#define COMMITTED_SYM 338
#define COMMIT_SYM 339
#define COMPACT_SYM 340
#define COMPLETION_SYM 341
#define COMPRESSED_SYM 342
#define CONCURRENT 343
#define CONDITION_SYM 344
#define CONNECTION_SYM 345
#define CONSISTENT_SYM 346
#define CONSTRAINT 347
#define CONSTRAINT_CATALOG_SYM 348
#define CONSTRAINT_NAME_SYM 349
#define CONSTRAINT_SCHEMA_SYM 350
#define CONTAINS_SYM 351
#define CONTEXT_SYM 352
#define CONTINUE_SYM 353
#define CONTRIBUTORS_SYM 354
#define CONVERT_SYM 355
#define COUNT_SYM 356
#define CPU_SYM 357
#define CREATE 358
#define CROSS 359
#define CUBE_SYM 360
#define CURDATE 361
#define CURRENT_USER 362
#define CURSOR_SYM 363
#define CURSOR_NAME_SYM 364
#define CURTIME 365
#define DATABASE 366
#define DATABASES 367
#define DATAFILE_SYM 368
#define DATA_SYM 369
#define DATETIME 370
#define DATE_ADD_INTERVAL 371
#define DATE_SUB_INTERVAL 372
#define DATE_SYM 373
#define DAY_HOUR_SYM 374
#define DAY_MICROSECOND_SYM 375
#define DAY_MINUTE_SYM 376
#define DAY_SECOND_SYM 377
#define DAY_SYM 378
#define DEALLOCATE_SYM 379
#define DECIMAL_NUM 380
#define DECIMAL_SYM 381
#define DECLARE_SYM 382
#define DEFAULT 383
#define DEFINER_SYM 384
#define DELAYED_SYM 385
#define DELAY_KEY_WRITE_SYM 386
#define DELETE_SYM 387
#define DESC 388
#define DESCRIBE 389
#define DES_KEY_FILE 390
#define DETERMINISTIC_SYM 391
#define DIRECTORY_SYM 392
#define DISABLE_SYM 393
#define DISCARD 394
#define DISK_SYM 395
#define DISTINCT 396
#define DIV_SYM 397
#define DOUBLE_SYM 398
#define DO_SYM 399
#define DROP 400
#define DUAL_SYM 401
#define DUMPFILE 402
#define DUPLICATE_SYM 403
#define DYNAMIC_SYM 404
#define EACH_SYM 405
#define ELSE 406
#define ELSEIF_SYM 407
#define ENABLE_SYM 408
#define ENCLOSED 409
#define END 410
#define ENDS_SYM 411
#define END_OF_INPUT 412
#define ENGINES_SYM 413
#define ENGINE_SYM 414
#define ENUM 415
#define EQ 416
#define EQUAL_SYM 417
#define ERROR_SYM 418
#define ERRORS 419
#define ESCAPED 420
#define ESCAPE_SYM 421
#define EVENTS_SYM 422
#define EVENT_SYM 423
#define EVERY_SYM 424
#define EXAMINED_SYM 425
#define EXECUTE_SYM 426
#define EXISTS 427
#define EXIT_SYM 428
#define EXPANSION_SYM 429
#define EXTENDED_SYM 430
#define EXTENT_SIZE_SYM 431
#define EXTRACT_SYM 432
#define FALSE_SYM 433
#define FAST_SYM 434
#define FAULTS_SYM 435
#define FETCH_SYM 436
#define FILE_SYM 437
#define FIRST_SYM 438
#define FIXED_SYM 439
#define FLOAT_NUM 440
#define FLOAT_SYM 441
#define FLUSH_SYM 442
#define FORCE_SYM 443
#define FOREIGN 444
#define FOR_SYM 445
#define FOUND_SYM 446
#define FROM 447
#define FULL 448
#define FULLTEXT_SYM 449
#define FUNCTION_SYM 450
#define GE 451
#define GENERAL 452
#define GENERATED_SYM 453
#define GEOMETRYCOLLECTION 454
#define GEOMETRY_SYM 455
#define GET_FORMAT 456
#define GLOBAL_SYM 457
#define GRANT 458
#define GRANTS 459
#define GROUP_SYM 460
#define GROUP_CONCAT_SYM 461
#define GT_SYM 462
#define HANDLER_SYM 463
#define HARD_SYM 464
#define HASH_SYM 465
#define HAVING 466
#define HELP_SYM 467
#define HEX_NUM 468
#define HEX_STRING 469
#define HIGH_PRIORITY 470
#define HOST_SYM 471
#define HOSTS_SYM 472
#define HOUR_MICROSECOND_SYM 473
#define HOUR_MINUTE_SYM 474
#define HOUR_SECOND_SYM 475
#define HOUR_SYM 476
#define IDENT 477
#define IDENTIFIED_SYM 478
#define IDENT_QUOTED 479
#define IF 480
#define IGNORE_SYM 481
#define IGNORE_SERVER_IDS_SYM 482
#define IMPORT 483
#define INDEXES 484
#define INDEX_SYM 485
#define INDEX_STATS_SYM 486
#define INFILE 487
#define INITIAL_SIZE_SYM 488
#define INNER_SYM 489
#define INOUT_SYM 490
#define INSENSITIVE_SYM 491
#define INSERT 492
#define INSERT_METHOD 493
#define INSTALL_SYM 494
#define INTERVAL_SYM 495
#define INTO 496
#define INT_SYM 497
#define INVOKER_SYM 498
#define IN_SYM 499
#define IO_SYM 500
#define IPC_SYM 501
#define IS 502
#define ISOLATION 503
#define ISSUER_SYM 504
#define ITERATE_SYM 505
#define JOIN_SYM 506
#define KEYS 507
#define KEY_BLOCK_SIZE 508
#define KEY_SYM 509
#define KILL_SYM 510
#define LANGUAGE_SYM 511
#define LAST_SYM 512
#define LAST_VALUE 513
#define LE 514
#define LEADING 515
#define LEAVES 516
#define LEAVE_SYM 517
#define LEFT 518
#define LESS_SYM 519
#define LEVEL_SYM 520
#define LEX_HOSTNAME 521
#define LIKE 522
#define LIMIT 523
#define LINEAR_SYM 524
#define LINES 525
#define LINESTRING 526
#define LIST_SYM 527
#define LOAD 528
#define LOCAL_SYM 529
#define LOCATOR_SYM 530
#define LOCKS_SYM 531
#define LOCK_SYM 532
#define LOGFILE_SYM 533
#define LOGS_SYM 534
#define LONGBLOB 535
#define LONGTEXT 536
#define LONG_NUM 537
#define LONG_SYM 538
#define LOOP_SYM 539
#define LOW_PRIORITY 540
#define LT 541
#define MASTER_CONNECT_RETRY_SYM 542
#define MASTER_HOST_SYM 543
#define MASTER_LOG_FILE_SYM 544
#define MASTER_LOG_POS_SYM 545
#define MASTER_PASSWORD_SYM 546
#define MASTER_PORT_SYM 547
#define MASTER_SERVER_ID_SYM 548
#define MASTER_SSL_CAPATH_SYM 549
#define MASTER_SSL_CA_SYM 550
#define MASTER_SSL_CERT_SYM 551
#define MASTER_SSL_CIPHER_SYM 552
#define MASTER_SSL_KEY_SYM 553
#define MASTER_SSL_SYM 554
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 555
#define MASTER_SYM 556
#define MASTER_USER_SYM 557
#define MASTER_HEARTBEAT_PERIOD_SYM 558
#define MATCH 559
#define MAX_CONNECTIONS_PER_HOUR 560
#define MAX_QUERIES_PER_HOUR 561
#define MAX_ROWS 562
#define MAX_SIZE_SYM 563
#define MAX_SYM 564
#define MAX_UPDATES_PER_HOUR 565
#define MAX_USER_CONNECTIONS_SYM 566
#define MAX_VALUE_SYM 567
#define MEDIUMBLOB 568
#define MEDIUMINT 569
#define MEDIUMTEXT 570
#define MEDIUM_SYM 571
#define MEMORY_SYM 572
#define MERGE_SYM 573
#define MESSAGE_TEXT_SYM 574
#define MICROSECOND_SYM 575
#define MIGRATE_SYM 576
#define MINUTE_MICROSECOND_SYM 577
#define MINUTE_SECOND_SYM 578
#define MINUTE_SYM 579
#define MIN_ROWS 580
#define MIN_SYM 581
#define MODE_SYM 582
#define MODIFIES_SYM 583
#define MODIFY_SYM 584
#define MOD_SYM 585
#define MONTH_SYM 586
#define MULTILINESTRING 587
#define MULTIPOINT 588
#define MULTIPOLYGON 589
#define MUTEX_SYM 590
#define MYSQL_ERRNO_SYM 591
#define NAMES_SYM 592
#define NAME_SYM 593
#define NATIONAL_SYM 594
#define NATURAL 595
#define NCHAR_STRING 596
#define NCHAR_SYM 597
#define NDBCLUSTER_SYM 598
#define NE 599
#define NEG 600
#define NEW_SYM 601
#define NEXT_SYM 602
#define NODEGROUP_SYM 603
#define NONE_SYM 604
#define NOT2_SYM 605
#define NOT_SYM 606
#define NOW_SYM 607
#define NO_SYM 608
#define NO_WAIT_SYM 609
#define NO_WRITE_TO_BINLOG 610
#define NULL_SYM 611
#define NUM 612
#define NUMERIC_SYM 613
#define NVARCHAR_SYM 614
#define OFFSET_SYM 615
#define OLD_PASSWORD 616
#define ON 617
#define ONE_SHOT_SYM 618
#define ONE_SYM 619
#define ONLINE_SYM 620
#define OPEN_SYM 621
#define OPTIMIZE 622
#define OPTIONS_SYM 623
#define OPTION 624
#define OPTIONALLY 625
#define OR2_SYM 626
#define ORDER_SYM 627
#define OR_OR_SYM 628
#define OR_SYM 629
#define OUTER 630
#define OUTFILE 631
#define OUT_SYM 632
#define OWNER_SYM 633
#define PACK_KEYS_SYM 634
#define PAGE_SYM 635
#define PAGE_CHECKSUM_SYM 636
#define PARAM_MARKER 637
#define PARSER_SYM 638
#define PARSE_VCOL_EXPR_SYM 639
#define PARTIAL 640
#define PARTITIONING_SYM 641
#define PARTITIONS_SYM 642
#define PARTITION_SYM 643
#define PASSWORD 644
#define PERSISTENT_SYM 645
#define PHASE_SYM 646
#define PLUGINS_SYM 647
#define PLUGIN_SYM 648
#define POINT_SYM 649
#define POLYGON 650
#define PORT_SYM 651
#define POSITION_SYM 652
#define PRECISION 653
#define PREPARE_SYM 654
#define PRESERVE_SYM 655
#define PREV_SYM 656
#define PRIMARY_SYM 657
#define PRIVILEGES 658
#define PROCEDURE_SYM 659
#define PROCESS 660
#define PROCESSLIST_SYM 661
#define PROFILE_SYM 662
#define PROFILES_SYM 663
#define PROXY_SYM 664
#define PURGE 665
#define QUARTER_SYM 666
#define QUERY_SYM 667
#define QUICK 668
#define RANGE_SYM 669
#define READS_SYM 670
#define READ_ONLY_SYM 671
#define READ_SYM 672
#define READ_WRITE_SYM 673
#define REAL 674
#define REBUILD_SYM 675
#define RECOVER_SYM 676
#define REDOFILE_SYM 677
#define REDO_BUFFER_SIZE_SYM 678
#define REDUNDANT_SYM 679
#define REFERENCES 680
#define REGEXP 681
#define RELAY 682
#define RELAYLOG_SYM 683
#define RELAY_LOG_FILE_SYM 684
#define RELAY_LOG_POS_SYM 685
#define RELAY_THREAD 686
#define RELEASE_SYM 687
#define RELOAD 688
#define REMOVE_SYM 689
#define RENAME 690
#define REORGANIZE_SYM 691
#define REPAIR 692
#define REPEATABLE_SYM 693
#define REPEAT_SYM 694
#define REPLACE 695
#define REPLICATION 696
#define REQUIRE_SYM 697
#define RESET_SYM 698
#define RESIGNAL_SYM 699
#define RESOURCES 700
#define RESTORE_SYM 701
#define RESTRICT 702
#define RESUME_SYM 703
#define RETURNS_SYM 704
#define RETURN_SYM 705
#define REVOKE 706
#define RIGHT 707
#define ROLLBACK_SYM 708
#define ROLLUP_SYM 709
#define ROUTINE_SYM 710
#define ROWS_SYM 711
#define ROW_FORMAT_SYM 712
#define ROW_SYM 713
#define RTREE_SYM 714
#define SAVEPOINT_SYM 715
#define SCHEDULE_SYM 716
#define SCHEMA_NAME_SYM 717
#define SECOND_MICROSECOND_SYM 718
#define SECOND_SYM 719
#define SECURITY_SYM 720
#define SELECT_SYM 721
#define SENSITIVE_SYM 722
#define SEPARATOR_SYM 723
#define SERIALIZABLE_SYM 724
#define SERIAL_SYM 725
#define SESSION_SYM 726
#define SERVER_SYM 727
#define SERVER_OPTIONS 728
#define SET 729
#define SET_VAR 730
#define SHARE_SYM 731
#define SHIFT_LEFT 732
#define SHIFT_RIGHT 733
#define SHOW 734
#define SHUTDOWN 735
#define SIGNAL_SYM 736
#define SIGNED_SYM 737
#define SIMPLE_SYM 738
#define SLAVE 739
#define SLOW 740
#define SMALLINT 741
#define SNAPSHOT_SYM 742
#define SOCKET_SYM 743
#define SOFT_SYM 744
#define SONAME_SYM 745
#define SOUNDS_SYM 746
#define SOURCE_SYM 747
#define SPATIAL_SYM 748
#define SPECIFIC_SYM 749
#define SQLEXCEPTION_SYM 750
#define SQLSTATE_SYM 751
#define SQLWARNING_SYM 752
#define SQL_BIG_RESULT 753
#define SQL_BUFFER_RESULT 754
#define SQL_CACHE_SYM 755
#define SQL_CALC_FOUND_ROWS 756
#define SQL_NO_CACHE_SYM 757
#define SQL_SMALL_RESULT 758
#define SQL_SYM 759
#define SQL_THREAD 760
#define SSL_SYM 761
#define STARTING 762
#define STARTS_SYM 763
#define START_SYM 764
#define STATUS_SYM 765
#define STDDEV_SAMP_SYM 766
#define STD_SYM 767
#define STOP_SYM 768
#define STORAGE_SYM 769
#define STRAIGHT_JOIN 770
#define STRING_SYM 771
#define SUBCLASS_ORIGIN_SYM 772
#define SUBDATE_SYM 773
#define SUBJECT_SYM 774
#define SUBPARTITIONS_SYM 775
#define SUBPARTITION_SYM 776
#define SUBSTRING 777
#define SUM_SYM 778
#define SUPER_SYM 779
#define SUSPEND_SYM 780
#define SWAPS_SYM 781
#define SWITCHES_SYM 782
#define SYSDATE 783
#define TABLES 784
#define TABLESPACE 785
#define TABLE_REF_PRIORITY 786
#define TABLE_STATS_SYM 787
#define TABLE_SYM 788
#define TABLE_CHECKSUM_SYM 789
#define TABLE_NAME_SYM 790
#define TEMPORARY 791
#define TEMPTABLE_SYM 792
#define TERMINATED 793
#define TEXT_STRING 794
#define TEXT_SYM 795
#define THAN_SYM 796
#define THEN_SYM 797
#define TIMESTAMP 798
#define TIMESTAMP_ADD 799
#define TIMESTAMP_DIFF 800
#define TIME_SYM 801
#define TINYBLOB 802
#define TINYINT 803
#define TINYTEXT 804
#define TO_SYM 805
#define TRAILING 806
#define TRANSACTION_SYM 807
#define TRANSACTIONAL_SYM 808
#define TRIGGERS_SYM 809
#define TRIGGER_SYM 810
#define TRIM 811
#define TRUE_SYM 812
#define TRUNCATE_SYM 813
#define TYPES_SYM 814
#define TYPE_SYM 815
#define UDF_RETURNS_SYM 816
#define ULONGLONG_NUM 817
#define UNCOMMITTED_SYM 818
#define UNDEFINED_SYM 819
#define UNDERSCORE_CHARSET 820
#define UNDOFILE_SYM 821
#define UNDO_BUFFER_SIZE_SYM 822
#define UNDO_SYM 823
#define UNICODE_SYM 824
#define UNINSTALL_SYM 825
#define UNION_SYM 826
#define UNIQUE_SYM 827
#define UNKNOWN_SYM 828
#define UNLOCK_SYM 829
#define UNSIGNED 830
#define UNTIL_SYM 831
#define UPDATE_SYM 832
#define UPGRADE_SYM 833
#define USAGE 834
#define USER 835
#define USER_STATS_SYM 836
#define USE_FRM 837
#define USE_SYM 838
#define USING 839
#define UTC_DATE_SYM 840
#define UTC_TIMESTAMP_SYM 841
#define UTC_TIME_SYM 842
#define VALUES 843
#define VALUE_SYM 844
#define VARBINARY 845
#define VARCHAR 846
#define VARIABLES 847
#define VARIANCE_SYM 848
#define VARYING 849
#define VAR_SAMP_SYM 850
#define VIA_SYM 851
#define VIEW_SYM 852
#define VIRTUAL_SYM 853
#define WAIT_SYM 854
#define WARNINGS 855
#define WEEK_SYM 856
#define WHEN_SYM 857
#define WHERE 858
#define WHILE_SYM 859
#define WITH 860
#define WITH_CUBE_SYM 861
#define WITH_ROLLUP_SYM 862
#define WORK_SYM 863
#define WRAPPER_SYM 864
#define WRITE_SYM 865
#define X509_SYM 866
#define XA_SYM 867
#define XML_SYM 868
#define XOR 869
#define YEAR_MONTH_SYM 870
#define YEAR_SYM 871
#define ZEROFILL 872
#define IMPOSSIBLE_ACTION 873




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 734 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2118 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 786 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2135 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  601
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   55743

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  638
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  923
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2631
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4458

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   873

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   631,     2,     2,     2,   625,   620,     2,
     628,   629,   623,   622,   630,   621,   636,   624,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   637,   634,
       2,     2,     2,     2,   635,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   626,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   632,   619,   633,   627,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   131,   133,   135,   140,   142,   145,
     146,   151,   152,   155,   159,   161,   164,   165,   169,   170,
     176,   178,   182,   186,   190,   194,   198,   202,   206,   210,
     214,   218,   222,   226,   230,   234,   240,   242,   243,   245,
     249,   251,   255,   259,   263,   267,   268,   276,   277,   290,
     291,   304,   305,   318,   319,   326,   327,   331,   336,   341,
     345,   348,   359,   361,   365,   368,   371,   374,   377,   380,
     383,   386,   387,   401,   402,   409,   412,   413,   415,   419,
     421,   422,   425,   426,   429,   430,   432,   436,   441,   442,
     445,   446,   449,   451,   453,   455,   457,   459,   461,   463,
     465,   467,   469,   471,   473,   475,   476,   480,   482,   483,
     486,   487,   490,   493,   496,   499,   502,   506,   510,   512,
     514,   516,   519,   523,   527,   528,   533,   534,   538,   539,
     541,   545,   547,   548,   550,   554,   556,   557,   561,   562,
     564,   568,   570,   575,   576,   578,   580,   582,   583,   587,
     590,   594,   595,   599,   600,   606,   612,   613,   621,   627,
     628,   631,   633,   635,   637,   641,   643,   645,   647,   651,
     652,   654,   656,   658,   660,   663,   665,   669,   671,   673,
     674,   676,   677,   680,   684,   690,   692,   694,   696,   698,
     700,   702,   704,   706,   708,   710,   712,   714,   716,   718,
     720,   724,   726,   730,   731,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   754,   756,   758,   760,   761,
     767,   768,   771,   772,   776,   777,   780,   783,   786,   789,
     790,   797,   800,   801,   804,   806,   808,   812,   813,   814,
     815,   823,   824,   827,   830,   832,   834,   835,   836,   845,
     846,   853,   855,   858,   860,   863,   864,   865,   872,   873,
     874,   881,   882,   885,   886,   892,   893,   895,   896,   902,
     903,   906,   907,   913,   918,   919,   920,   929,   930,   938,
     940,   942,   944,   946,   948,   951,   956,   962,   963,   968,
     973,   978,   982,   986,   989,   992,   993,   996,   998,  1001,
    1005,  1007,  1009,  1011,  1013,  1015,  1018,  1022,  1024,  1026,
    1028,  1030,  1032,  1034,  1036,  1038,  1040,  1042,  1045,  1049,
    1051,  1053,  1055,  1057,  1059,  1061,  1063,  1066,  1070,  1072,
    1074,  1076,  1078,  1080,  1082,  1084,  1086,  1088,  1091,  1095,
    1097,  1099,  1101,  1104,  1107,  1110,  1112,  1114,  1116,  1118,
    1121,  1125,  1129,  1133,  1137,  1141,  1145,  1149,  1153,  1158,
    1159,  1161,  1163,  1165,  1167,  1169,  1172,  1176,  1179,  1184,
    1185,  1192,  1193,  1199,  1200,  1201,  1207,  1208,  1216,  1218,
    1219,  1221,  1222,  1227,  1228,  1229,  1233,  1239,  1246,  1247,
    1252,  1255,  1258,  1261,  1264,  1265,  1267,  1268,  1272,  1273,
    1275,  1277,  1281,  1283,  1288,  1294,  1300,  1301,  1304,  1305,
    1306,  1314,  1315,  1326,  1328,  1332,  1334,  1336,  1337,  1340,
    1341,  1345,  1347,  1351,  1352,  1359,  1361,  1362,  1363,  1369,
    1370,  1375,  1377,  1379,  1381,  1385,  1387,  1391,  1392,  1393,
    1399,  1401,  1405,  1407,  1409,  1410,  1414,  1416,  1420,  1421,
    1426,  1428,  1429,  1431,  1434,  1436,  1440,  1445,  1449,  1453,
    1457,  1461,  1466,  1471,  1475,  1476,  1477,  1484,  1485,  1487,
    1488,  1490,  1492,  1495,  1497,  1499,  1500,  1502,  1504,  1507,
    1509,  1510,  1514,  1515,  1517,  1519,  1522,  1524,  1527,  1531,
    1535,  1539,  1543,  1547,  1551,  1555,  1559,  1563,  1567,  1571,
    1575,  1579,  1583,  1587,  1588,  1595,  1597,  1599,  1603,  1608,
    1613,  1616,  1619,  1622,  1626,  1630,  1634,  1638,  1642,  1646,
    1650,  1655,  1660,  1662,  1664,  1666,  1668,  1670,  1672,  1674,
    1676,  1678,  1680,  1682,  1684,  1686,  1689,  1691,  1693,  1695,
    1697,  1699,  1701,  1705,  1707,  1709,  1712,  1715,  1716,  1725,
    1726,  1736,  1737,  1747,  1748,  1758,  1767,  1770,  1771,  1773,
    1778,  1779,  1781,  1784,  1785,  1789,  1792,  1801,  1802,  1805,
    1806,  1808,  1810,  1811,  1813,  1816,  1818,  1820,  1823,  1826,
    1831,  1835,  1839,  1843,  1847,  1849,  1852,  1854,  1856,  1860,
    1863,  1867,  1870,  1873,  1875,  1879,  1883,  1886,  1890,  1892,
    1895,  1898,  1901,  1903,  1906,  1908,  1910,  1912,  1915,  1919,
    1922,  1926,  1929,  1932,  1936,  1940,  1944,  1945,  1952,  1953,
    1960,  1963,  1965,  1967,  1969,  1971,  1973,  1975,  1977,  1979,
    1981,  1983,  1985,  1988,  1991,  1993,  1996,  1998,  2001,  2005,
    2008,  2010,  2012,  2014,  2016,  2018,  2020,  2022,  2025,  2026,
    2028,  2030,  2036,  2037,  2039,  2042,  2044,  2046,  2048,  2050,
    2054,  2058,  2062,  2066,  2067,  2069,  2070,  2072,  2073,  2075,
    2078,  2080,  2082,  2085,  2088,  2093,  2095,  2099,  2102,  2104,
    2107,  2110,  2113,  2117,  2121,  2125,  2129,  2132,  2135,  2137,
    2139,  2141,  2144,  2146,  2148,  2150,  2152,  2154,  2155,  2158,
    2160,  2162,  2164,  2166,  2168,  2169,  2172,  2174,  2176,  2177,
    2179,  2181,  2184,  2187,  2189,  2192,  2195,  2196,  2198,  2200,
    2202,  2206,  2208,  2212,  2213,  2215,  2216,  2218,  2224,  2225,
    2229,  2233,  2235,  2236,  2239,  2242,  2245,  2246,  2250,  2254,
    2261,  2268,  2270,  2272,  2275,  2278,  2281,  2283,  2286,  2289,
    2291,  2293,  2294,  2296,  2298,  2300,  2302,  2303,  2305,  2307,
    2309,  2310,  2312,  2315,  2316,  2318,  2319,  2321,  2322,  2324,
    2326,  2329,  2331,  2334,  2336,  2339,  2342,  2345,  2349,  2352,
    2356,  2360,  2364,  2368,  2370,  2372,  2374,  2376,  2380,  2382,
    2384,  2386,  2391,  2394,  2396,  2401,  2402,  2404,  2405,  2408,
    2410,  2414,  2415,  2422,  2423,  2429,  2437,  2438,  2444,  2445,
    2451,  2452,  2458,  2459,  2464,  2465,  2476,  2480,  2485,  2489,
    2493,  2501,  2502,  2506,  2508,  2513,  2514,  2518,  2519,  2522,
    2523,  2525,  2526,  2529,  2532,  2535,  2538,  2540,  2542,  2544,
    2548,  2553,  2554,  2561,  2566,  2567,  2573,  2574,  2581,  2586,
    2590,  2592,  2595,  2597,  2599,  2600,  2606,  2607,  2611,  2614,
    2615,  2621,  2622,  2623,  2630,  2632,  2636,  2638,  2640,  2644,
    2647,  2651,  2654,  2659,  2660,  2667,  2668,  2669,  2677,  2682,
    2687,  2691,  2695,  2698,  2701,  2708,  2714,  2718,  2724,  2726,
    2728,  2730,  2731,  2733,  2734,  2736,  2737,  2740,  2741,  2743,
    2746,  2748,  2750,  2752,  2753,  2755,  2757,  2758,  2761,  2763,
    2764,  2766,  2768,  2770,  2771,  2777,  2781,  2782,  2788,  2792,
    2796,  2797,  2801,  2802,  2805,  2807,  2811,  2812,  2814,  2816,
    2817,  2820,  2822,  2826,  2827,  2833,  2834,  2836,  2838,  2839,
    2846,  2847,  2849,  2851,  2854,  2856,  2858,  2860,  2861,  2867,
    2870,  2871,  2877,  2878,  2880,  2882,  2885,  2887,  2889,  2891,
    2893,  2895,  2898,  2899,  2905,  2906,  2908,  2910,  2911,  2916,
    2921,  2925,  2931,  2933,  2937,  2941,  2942,  2949,  2951,  2953,
    2955,  2959,  2962,  2966,  2968,  2970,  2971,  2978,  2980,  2982,
    2984,  2988,  2992,  2997,  2998,  3005,  3006,  3009,  3010,  3015,
    3016,  3019,  3021,  3024,  3029,  3032,  3036,  3039,  3043,  3044,
    3048,  3049,  3050,  3057,  3060,  3062,  3064,  3067,  3070,  3079,
    3084,  3085,  3087,  3090,  3092,  3094,  3096,  3098,  3099,  3102,
    3107,  3111,  3113,  3115,  3119,  3124,  3125,  3126,  3127,  3130,
    3133,  3135,  3137,  3138,  3141,  3145,  3146,  3149,  3153,  3157,
    3161,  3164,  3168,  3173,  3177,  3182,  3186,  3191,  3193,  3197,
    3202,  3206,  3210,  3217,  3219,  3225,  3232,  3238,  3246,  3253,
    3262,  3268,  3275,  3280,  3285,  3291,  3295,  3300,  3302,  3306,
    3310,  3314,  3318,  3322,  3326,  3332,  3338,  3342,  3346,  3350,
    3354,  3358,  3362,  3364,  3366,  3368,  3370,  3372,  3374,  3376,
    3378,  3380,  3382,  3384,  3386,  3388,  3390,  3392,  3394,  3396,
    3397,  3400,  3402,  3405,  3407,  3409,  3411,  3414,  3417,  3419,
    3421,  3424,  3427,  3432,  3434,  3438,  3440,  3442,  3444,  3446,
    3448,  3452,  3454,  3456,  3458,  3460,  3464,  3467,  3470,  3473,
    3476,  3480,  3484,  3490,  3497,  3502,  3507,  3515,  3518,  3525,
    3531,  3538,  3545,  3550,  3555,  3561,  3566,  3573,  3576,  3581,
    3586,  3591,  3602,  3609,  3618,  3625,  3630,  3635,  3642,  3647,
    3652,  3657,  3664,  3669,  3677,  3685,  3693,  3700,  3707,  3714,
    3721,  3725,  3730,  3737,  3746,  3749,  3752,  3761,  3770,  3777,
    3784,  3787,  3794,  3801,  3810,  3819,  3826,  3835,  3842,  3845,
    3854,  3863,  3866,  3869,  3872,  3879,  3886,  3893,  3898,  3903,
    3912,  3917,  3922,  3927,  3932,  3936,  3945,  3950,  3955,  3962,
    3967,  3972,  3977,  3984,  3993,  4000,  4005,  4012,  4014,  4021,
    4026,  4031,  4036,  4041,  4046,  4053,  4058,  4059,  4065,  4072,
    4075,  4079,  4080,  4085,  4086,  4090,  4091,  4093,  4095,  4099,
    4104,  4109,  4115,  4120,  4125,  4130,  4136,  4141,  4142,  4143,
    4151,  4156,  4162,  4167,  4173,  4178,  4183,  4188,  4193,  4198,
    4204,  4205,  4214,  4215,  4219,  4223,  4225,  4230,  4231,  4233,
    4234,  4237,  4238,  4239,  4244,  4249,  4252,  4253,  4257,  4260,
    4264,  4267,  4269,  4271,  4274,  4276,  4279,  4281,  4284,  4287,
    4290,  4291,  4295,  4296,  4298,  4300,  4304,  4306,  4310,  4312,
    4316,  4317,  4319,  4320,  4323,  4328,  4334,  4336,  4338,  4340,
    4342,  4347,  4349,  4353,  4357,  4361,  4362,  4369,  4370,  4377,
    4378,  4387,  4392,  4393,  4402,  4403,  4414,  4421,  4422,  4431,
    4432,  4443,  4450,  4452,  4455,  4458,  4459,  4464,  4468,  4474,
    4477,  4478,  4479,  4487,  4489,  4490,  4491,  4498,  4499,  4503,
    4504,  4505,  4511,  4512,  4514,  4515,  4517,  4518,  4521,  4525,
    4529,  4531,  4533,  4534,  4542,  4543,  4551,  4553,  4556,  4557,
    4558,  4561,  4562,  4565,  4566,  4568,  4570,  4572,  4574,  4578,
    4580,  4584,  4586,  4588,  4590,  4592,  4594,  4596,  4598,  4600,
    4602,  4604,  4606,  4608,  4610,  4612,  4614,  4616,  4618,  4620,
    4622,  4624,  4626,  4628,  4630,  4632,  4634,  4635,  4637,  4639,
    4640,  4643,  4644,  4646,  4647,  4648,  4652,  4653,  4654,  4658,
    4661,  4662,  4663,  4668,  4673,  4676,  4677,  4679,  4681,  4685,
    4689,  4691,  4694,  4695,  4697,  4698,  4703,  4708,  4711,  4712,
    4714,  4716,  4717,  4719,  4720,  4722,  4725,  4731,  4736,  4738,
    4742,  4746,  4748,  4750,  4752,  4754,  4756,  4758,  4759,  4762,
    4766,  4771,  4773,  4776,  4779,  4781,  4783,  4785,  4787,  4789,
    4791,  4793,  4795,  4797,  4799,  4801,  4803,  4805,  4807,  4809,
    4811,  4813,  4815,  4817,  4819,  4821,  4823,  4825,  4827,  4829,
    4831,  4832,  4833,  4840,  4841,  4843,  4847,  4849,  4853,  4854,
    4857,  4861,  4863,  4866,  4868,  4869,  4873,  4874,  4875,  4883,
    4886,  4888,  4889,  4893,  4894,  4902,  4903,  4910,  4915,  4922,
    4927,  4932,  4937,  4938,  4945,  4950,  4955,  4961,  4968,  4973,
    4975,  4979,  4981,  4983,  4987,  4989,  4990,  4993,  4994,  4996,
    4997,  4998,  5007,  5008,  5009,  5016,  5017,  5019,  5021,  5023,
    5025,  5027,  5030,  5032,  5034,  5036,  5040,  5045,  5046,  5050,
    5054,  5056,  5059,  5062,  5063,  5067,  5068,  5074,  5078,  5080,
    5084,  5086,  5090,  5092,  5094,  5095,  5097,  5098,  5103,  5104,
    5106,  5110,  5112,  5114,  5116,  5117,  5118,  5125,  5126,  5127,
    5139,  5143,  5145,  5149,  5153,  5155,  5159,  5160,  5162,  5163,
    5168,  5169,  5176,  5177,  5183,  5184,  5191,  5193,  5197,  5200,
    5205,  5206,  5209,  5210,  5213,  5215,  5217,  5219,  5220,  5225,
    5226,  5228,  5229,  5231,  5233,  5237,  5239,  5241,  5244,  5247,
    5250,  5252,  5254,  5256,  5258,  5259,  5263,  5264,  5268,  5271,
    5276,  5281,  5285,  5290,  5295,  5297,  5301,  5305,  5312,  5315,
    5318,  5319,  5326,  5327,  5334,  5340,  5343,  5345,  5347,  5349,
    5355,  5361,  5364,  5367,  5369,  5374,  5378,  5381,  5385,  5388,
    5391,  5393,  5397,  5402,  5406,  5410,  5413,  5416,  5418,  5420,
    5422,  5424,  5428,  5432,  5436,  5440,  5444,  5448,  5452,  5456,
    5458,  5460,  5462,  5464,  5466,  5467,  5469,  5470,  5473,  5474,
    5476,  5478,  5480,  5481,  5484,  5485,  5488,  5489,  5492,  5495,
    5496,  5501,  5502,  5507,  5509,  5511,  5512,  5514,  5516,  5517,
    5519,  5521,  5522,  5527,  5528,  5529,  5535,  5537,  5538,  5543,
    5547,  5549,  5552,  5555,  5558,  5561,  5564,  5567,  5570,  5572,
    5574,  5576,  5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,
    5594,  5595,  5597,  5598,  5602,  5603,  5607,  5611,  5613,  5614,
    5618,  5620,  5623,  5624,  5626,  5627,  5631,  5635,  5638,  5641,
    5642,  5648,  5649,  5651,  5653,  5654,  5656,  5658,  5660,  5663,
    5666,  5667,  5668,  5669,  5670,  5692,  5694,  5696,  5697,  5699,
    5700,  5702,  5704,  5705,  5707,  5709,  5710,  5713,  5716,  5718,
    5722,  5727,  5731,  5735,  5736,  5739,  5742,  5744,  5748,  5752,
    5753,  5758,  5759,  5763,  5765,  5767,  5768,  5772,  5775,  5779,
    5781,  5783,  5786,  5787,  5790,  5794,  5796,  5802,  5804,  5806,
    5809,  5812,  5814,  5816,  5818,  5820,  5822,  5824,  5827,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5849,  5852,
    5855,  5858,  5861,  5863,  5865,  5867,  5869,  5871,  5873,  5875,
    5879,  5885,  5887,  5889,  5891,  5893,  5895,  5899,  5904,  5910,
    5912,  5918,  5922,  5925,  5927,  5931,  5934,  5937,  5942,  5944,
    5946,  5948,  5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,
    5966,  5968,  5970,  5974,  5977,  5979,  5981,  5983,  5985,  5987,
    5989,  5991,  5993,  5995,  5997,  5999,  6001,  6003,  6005,  6007,
    6009,  6011,  6013,  6015,  6017,  6019,  6021,  6023,  6025,  6027,
    6029,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,  6047,
    6049,  6051,  6053,  6055,  6057,  6059,  6061,  6063,  6065,  6067,
    6069,  6071,  6073,  6075,  6077,  6079,  6081,  6083,  6085,  6087,
    6089,  6091,  6093,  6095,  6097,  6099,  6101,  6103,  6105,  6107,
    6109,  6111,  6113,  6115,  6117,  6119,  6121,  6123,  6125,  6127,
    6129,  6131,  6133,  6135,  6137,  6139,  6141,  6143,  6145,  6147,
    6149,  6151,  6153,  6155,  6157,  6159,  6161,  6163,  6165,  6167,
    6169,  6171,  6173,  6175,  6177,  6179,  6181,  6183,  6185,  6187,
    6189,  6191,  6193,  6195,  6197,  6199,  6201,  6203,  6205,  6207,
    6209,  6211,  6213,  6215,  6217,  6219,  6221,  6223,  6225,  6227,
    6229,  6231,  6233,  6235,  6237,  6239,  6241,  6243,  6245,  6247,
    6249,  6251,  6253,  6255,  6257,  6259,  6261,  6263,  6265,  6267,
    6269,  6271,  6273,  6275,  6277,  6279,  6281,  6283,  6285,  6287,
    6289,  6291,  6293,  6295,  6297,  6299,  6301,  6303,  6305,  6307,
    6309,  6311,  6313,  6315,  6317,  6319,  6321,  6323,  6325,  6327,
    6329,  6331,  6333,  6335,  6337,  6339,  6341,  6343,  6345,  6347,
    6349,  6351,  6353,  6355,  6357,  6359,  6361,  6363,  6365,  6367,
    6369,  6371,  6373,  6375,  6377,  6379,  6381,  6383,  6385,  6387,
    6389,  6391,  6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,
    6409,  6411,  6413,  6415,  6417,  6419,  6421,  6423,  6425,  6427,
    6429,  6431,  6433,  6435,  6437,  6439,  6441,  6443,  6445,  6447,
    6449,  6451,  6453,  6455,  6457,  6459,  6461,  6463,  6465,  6467,
    6469,  6471,  6473,  6475,  6477,  6479,  6481,  6483,  6485,  6487,
    6489,  6491,  6493,  6495,  6497,  6499,  6501,  6503,  6505,  6507,
    6509,  6511,  6513,  6515,  6517,  6519,  6521,  6523,  6525,  6527,
    6529,  6531,  6533,  6535,  6537,  6539,  6541,  6543,  6545,  6547,
    6549,  6551,  6553,  6555,  6557,  6559,  6561,  6563,  6565,  6567,
    6569,  6571,  6573,  6575,  6577,  6579,  6581,  6583,  6585,  6587,
    6589,  6591,  6593,  6595,  6597,  6599,  6601,  6603,  6605,  6607,
    6609,  6611,  6613,  6615,  6617,  6619,  6621,  6623,  6625,  6627,
    6629,  6631,  6633,  6635,  6637,  6639,  6641,  6643,  6645,  6647,
    6649,  6651,  6653,  6655,  6657,  6659,  6661,  6663,  6665,  6667,
    6669,  6671,  6673,  6675,  6677,  6679,  6680,  6685,  6686,  6688,
    6690,  6694,  6695,  6698,  6700,  6702,  6704,  6706,  6707,  6709,
    6710,  6712,  6714,  6716,  6717,  6720,  6723,  6726,  6728,  6731,
    6736,  6742,  6747,  6754,  6757,  6761,  6765,  6769,  6775,  6777,
    6781,  6785,  6788,  6791,  6794,  6796,  6798,  6803,  6808,  6810,
    6812,  6814,  6816,  6818,  6819,  6824,  6826,  6828,  6830,  6834,
    6838,  6840,  6842,  6845,  6848,  6851,  6852,  6856,  6861,  6865,
    6866,  6874,  6876,  6879,  6881,  6883,  6885,  6887,  6889,  6891,
    6892,  6898,  6900,  6902,  6904,  6906,  6908,  6912,  6919,  6926,
    6933,  6941,  6947,  6951,  6960,  6969,  6978,  6985,  6986,  6988,
    6990,  6993,  6994,  6996,  6998,  7002,  7003,  7007,  7008,  7012,
    7013,  7017,  7018,  7022,  7024,  7026,  7028,  7030,  7032,  7034,
    7036,  7038,  7040,  7042,  7044,  7047,  7050,  7052,  7056,  7059,
    7062,  7065,  7068,  7071,  7074,  7077,  7080,  7082,  7084,  7087,
    7088,  7090,  7094,  7096,  7099,  7102,  7105,  7107,  7111,  7115,
    7117,  7119,  7123,  7125,  7129,  7131,  7133,  7135,  7137,  7142,
    7148,  7153,  7160,  7162,  7163,  7167,  7171,  7173,  7175,  7176,
    7179,  7182,  7185,  7188,  7189,  7192,  7193,  7197,  7200,  7202,
    7205,  7208,  7211,  7214,  7217,  7218,  7222,  7223,  7225,  7226,
    7230,  7233,  7234,  7236,  7239,  7240,  7242,  7247,  7252,  7258,
    7261,  7265,  7266,  7268,  7269,  7274,  7275,  7277,  7279,  7280,
    7282,  7283,  7286,  7289,  7291,  7292,  7294,  7296,  7299,  7303,
    7306,  7307,  7314,  7318,  7319,  7320,  7321,  7323,  7326,  7328,
    7330,  7332,  7334,  7336,  7338,  7340,  7342,  7344,  7347,  7350,
    7354,  7356,  7358,  7360,  7362,  7364,  7366,  7368,  7370,  7372,
    7374,  7376,  7378,  7380,  7381,  7385,  7387,  7390,  7392,  7395,
    7399,  7403,  7407,  7408,  7412,  7416,  7417,  7425,  7426,  7430,
    7432,  7436,  7437,  7441,  7444,  7449,  7450,  7454,  7459,  7464,
    7465,  7466,  7467,  7484,  7493,  7501,  7502,  7503,  7504,  7505,
    7506,  7522,  7523,  7524,  7525,  7526,  7539,  7544,  7549,  7553,
    7558,  7562,  7565,  7567,  7571,  7577,  7579,  7581,  7582,  7584,
    7586,  7587,  7590,  7591,  7592,  7596,  7597,  7600,  7606,  7610,
    7614,  7618
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     639,     0,    -1,   157,    -1,    -1,   642,   640,   634,   641,
      -1,   642,   157,    -1,    -1,   157,    -1,   643,    -1,  1488,
      -1,  1000,    -1,  1062,    -1,  1064,    -1,   692,    -1,   655,
      -1,  1065,    -1,  1054,    -1,  1494,    -1,   662,    -1,   644,
      -1,  1312,    -1,  1344,    -1,  1264,    -1,  1266,    -1,   648,
      -1,  1350,    -1,  1460,    -1,  1451,    -1,   653,    -1,  1276,
      -1,  1558,    -1,  1560,    -1,  1078,    -1,  1370,    -1,  1376,
      -1,  1443,    -1,  1070,    -1,   926,    -1,   836,    -1,  1085,
      -1,   646,    -1,  1366,    -1,  1497,    -1,  1073,    -1,  1057,
      -1,  1279,    -1,  1360,    -1,   727,    -1,  1458,    -1,  1495,
      -1,  1496,    -1,  1097,    -1,  1426,    -1,   720,    -1,  1330,
      -1,  1043,    -1,  1046,    -1,  1323,    -1,  1559,    -1,  1449,
      -1,  1304,    -1,  1375,    -1,  1550,    -1,   645,   399,  1420,
      -1,   124,    -1,   145,    -1,   399,  1420,   192,   647,    -1,
    1417,    -1,   635,  1422,    -1,    -1,   171,  1420,   649,   650,
      -1,    -1,   584,   651,    -1,   651,   630,   652,    -1,   652,
      -1,   635,  1422,    -1,    -1,   212,   654,  1422,    -1,    -1,
      57,   301,   550,   656,   657,    -1,   658,    -1,   657,   630,
     658,    -1,   288,   161,  1417,    -1,   302,   161,  1417,    -1,
     291,   161,  1417,    -1,   292,   161,  1243,    -1,   287,   161,
    1243,    -1,   299,   161,  1243,    -1,   295,   161,  1417,    -1,
     294,   161,  1417,    -1,   296,   161,  1417,    -1,   297,   161,
    1417,    -1,   298,   161,  1417,    -1,   300,   161,  1243,    -1,
     303,   161,  1405,    -1,   227,   161,   628,   659,   629,    -1,
     661,    -1,    -1,   660,    -1,   659,   630,   660,    -1,  1243,
      -1,   289,   161,  1417,    -1,   290,   161,  1245,    -1,   429,
     161,  1417,    -1,   430,   161,  1243,    -1,    -1,   103,   888,
     533,   891,  1413,   663,   824,    -1,    -1,   103,   978,   230,
    1420,   982,   362,  1413,   664,   628,   995,   629,   983,    -1,
      -1,   103,   979,   230,  1420,   981,   362,  1413,   665,   628,
     995,   629,   984,    -1,    -1,   103,   980,   230,  1420,   981,
     362,  1413,   666,   628,   995,   629,   985,    -1,    -1,   103,
     111,   891,  1420,   667,   885,    -1,    -1,   103,   668,  1516,
      -1,   103,   580,   685,  1476,    -1,   103,   278,   205,   787,
      -1,   103,   530,   784,    -1,   103,   669,    -1,   472,  1422,
     189,   114,   609,  1422,   368,   628,   670,   629,    -1,   671,
      -1,   670,   630,   671,    -1,   580,  1417,    -1,   216,  1417,
      -1,   111,  1417,    -1,   378,  1417,    -1,   389,  1417,    -1,
     488,  1417,    -1,   396,  1243,    -1,    -1,  1114,   168,   891,
     686,   673,   362,   461,   674,   679,   676,   681,   144,   682,
      -1,    -1,   169,  1119,  1213,   675,   677,   678,    -1,    23,
    1119,    -1,    -1,   153,    -1,   138,   362,   484,    -1,   138,
      -1,    -1,   508,  1119,    -1,    -1,   156,  1119,    -1,    -1,
     680,    -1,   362,    86,   400,    -1,   362,    86,   351,   400,
      -1,    -1,    82,  1417,    -1,    -1,   683,   684,    -1,   733,
      -1,   735,    -1,   731,    -1,   752,    -1,   770,    -1,   772,
      -1,   767,    -1,   737,    -1,   739,    -1,   740,    -1,   741,
      -1,   742,    -1,   744,    -1,    -1,  1420,   636,  1420,    -1,
    1420,    -1,    -1,   687,   689,    -1,    -1,   688,   690,    -1,
      82,  1417,    -1,   256,   504,    -1,   353,   504,    -1,    96,
     504,    -1,   415,   504,   114,    -1,   328,   504,   114,    -1,
     691,    -1,   689,    -1,   136,    -1,  1125,   136,    -1,   504,
     465,   129,    -1,   504,   465,   243,    -1,    -1,    50,   686,
     693,   694,    -1,    -1,   628,   695,   629,    -1,    -1,   696,
      -1,   696,   630,  1119,    -1,  1119,    -1,    -1,   698,    -1,
     698,   630,   700,    -1,   700,    -1,    -1,  1420,   699,   949,
      -1,    -1,   702,    -1,   702,   630,   703,    -1,   703,    -1,
     704,   699,  1420,   949,    -1,    -1,   244,    -1,   377,    -1,
     235,    -1,    -1,   705,   730,   634,    -1,   730,   634,    -1,
     706,   730,   634,    -1,    -1,   707,   708,   634,    -1,    -1,
     127,   728,   709,   949,   729,    -1,   127,  1420,    89,   190,
     716,    -1,    -1,   127,   713,   208,   190,   710,   714,   730,
      -1,   127,  1420,   108,   190,   711,    -1,    -1,   712,  1097,
      -1,   173,    -1,    98,    -1,   715,    -1,   714,   630,   715,
      -1,   719,    -1,  1243,    -1,   717,    -1,   496,   718,  1418,
      -1,    -1,   589,    -1,   716,    -1,  1420,    -1,   497,    -1,
    1125,   191,    -1,   495,    -1,   481,   721,   723,    -1,  1420,
      -1,   717,    -1,    -1,   721,    -1,    -1,   474,   724,    -1,
     726,   161,   725,    -1,   724,   630,   726,   161,   725,    -1,
    1404,    -1,  1150,    -1,  1409,    -1,    65,    -1,   517,    -1,
      93,    -1,    95,    -1,    94,    -1,    55,    -1,   462,    -1,
     535,    -1,    81,    -1,   109,    -1,   319,    -1,   336,    -1,
     444,   722,   723,    -1,  1420,    -1,   728,   630,  1420,    -1,
      -1,   128,  1119,    -1,   733,    -1,   735,    -1,   731,    -1,
     752,    -1,   770,    -1,   772,    -1,   767,    -1,   737,    -1,
     739,    -1,   740,    -1,   741,    -1,   742,    -1,   744,    -1,
      -1,   225,   732,   747,   155,   225,    -1,    -1,   734,   643,
      -1,    -1,   450,   736,  1119,    -1,    -1,   738,   776,    -1,
     262,  1421,    -1,   250,  1421,    -1,   366,  1420,    -1,    -1,
     181,   745,  1420,   241,   743,   746,    -1,    68,  1420,    -1,
      -1,   347,   192,    -1,   192,    -1,  1420,    -1,   746,   630,
    1420,    -1,    -1,    -1,    -1,   748,  1119,   542,   749,   706,
     750,   751,    -1,    -1,   152,   747,    -1,   151,   706,    -1,
     753,    -1,   756,    -1,    -1,    -1,    53,   754,  1119,   755,
     758,   766,   155,    53,    -1,    -1,    53,   757,   759,   766,
     155,    53,    -1,   760,    -1,   758,   760,    -1,   763,    -1,
     759,   763,    -1,    -1,    -1,   602,   761,  1119,   762,   542,
     706,    -1,    -1,    -1,   602,   764,  1119,   765,   542,   706,
      -1,    -1,   151,   706,    -1,    -1,  1421,   637,   768,   776,
     769,    -1,    -1,  1421,    -1,    -1,  1421,   637,   771,   774,
     769,    -1,    -1,   773,   774,    -1,    -1,    31,   775,   707,
     705,   155,    -1,   284,   706,   155,   284,    -1,    -1,    -1,
     604,   777,  1119,   144,   778,   706,   155,   604,    -1,    -1,
     439,   706,   576,   779,  1119,   155,   439,    -1,    30,    -1,
       8,    -1,   237,    -1,   577,    -1,   132,    -1,   809,   811,
      -1,   809,    57,   806,   790,    -1,   809,     6,   806,   785,
     794,    -1,    -1,   583,   278,   205,  1420,    -1,   809,     6,
     806,   797,    -1,   809,   145,   806,   797,    -1,   810,   789,
     800,    -1,   810,   789,   803,    -1,     6,   807,    -1,     6,
     808,    -1,    -1,   791,   792,    -1,   793,    -1,   792,   793,
      -1,   792,   630,   793,    -1,   812,    -1,   813,    -1,   814,
      -1,   795,    -1,   796,    -1,   795,   796,    -1,   795,   630,
     796,    -1,   812,    -1,   813,    -1,   814,    -1,   815,    -1,
     818,    -1,   820,    -1,   822,    -1,   819,    -1,   798,    -1,
     799,    -1,   798,   799,    -1,   798,   630,   799,    -1,   812,
      -1,   813,    -1,   814,    -1,   820,    -1,   822,    -1,   801,
      -1,   802,    -1,   801,   802,    -1,   801,   630,   802,    -1,
     812,    -1,   816,    -1,   817,    -1,   818,    -1,   820,    -1,
     822,    -1,   819,    -1,   804,    -1,   805,    -1,   804,   805,
      -1,   804,   630,   805,    -1,   812,    -1,   820,    -1,   822,
      -1,   113,  1417,    -1,   566,  1417,    -1,   422,  1417,    -1,
    1420,    -1,  1420,    -1,   416,    -1,   418,    -1,   351,     4,
      -1,   233,  1296,   823,    -1,    25,  1296,   823,    -1,   308,
    1296,   823,    -1,   176,  1296,   823,    -1,   567,  1296,   823,
      -1,   423,  1296,   823,    -1,   348,  1296,  1244,    -1,    82,
    1296,  1417,    -1,  1337,   159,  1296,   899,    -1,    -1,   822,
      -1,   599,    -1,   354,    -1,  1244,    -1,   222,    -1,   628,
     825,    -1,   892,   831,   828,    -1,   267,  1413,    -1,   628,
     267,  1413,   629,    -1,    -1,   905,   629,   826,   892,   831,
     828,    -1,    -1,   831,   881,   629,   827,  1501,    -1,    -1,
      -1,  1384,   884,   881,   829,  1498,    -1,    -1,  1384,   884,
     628,   881,   629,   830,  1501,    -1,   832,    -1,    -1,   833,
      -1,    -1,   388,   835,   834,   838,    -1,    -1,    -1,   388,
     837,   838,    -1,    47,   839,   849,   850,   857,    -1,   841,
     254,   842,   628,   843,   629,    -1,    -1,   841,   210,   840,
     847,    -1,   414,   847,    -1,   414,   846,    -1,   272,   847,
      -1,   272,   846,    -1,    -1,   269,    -1,    -1,    11,   161,
    1244,    -1,    -1,   844,    -1,   845,    -1,   844,   630,   845,
      -1,  1420,    -1,    73,   628,   843,   629,    -1,   628,  1114,
     855,  1115,   629,    -1,   628,  1114,   855,  1115,   629,    -1,
      -1,   387,  1244,    -1,    -1,    -1,   521,    47,   841,   210,
     848,   851,   856,    -1,    -1,   521,    47,   841,   254,   842,
     628,   853,   629,   852,   856,    -1,   854,    -1,   853,   630,
     854,    -1,  1420,    -1,  1122,    -1,    -1,   520,  1244,    -1,
      -1,   628,   858,   629,    -1,   859,    -1,   858,   630,   859,
      -1,    -1,   388,   860,   861,   862,   878,   873,    -1,  1420,
      -1,    -1,    -1,   588,   264,   541,   863,   865,    -1,    -1,
     588,   244,   864,   866,    -1,   312,    -1,   868,    -1,   868,
      -1,   628,   867,   629,    -1,   868,    -1,   867,   630,   868,
      -1,    -1,    -1,   628,   869,   871,   870,   629,    -1,   872,
      -1,   871,   630,   872,    -1,   312,    -1,  1122,    -1,    -1,
     628,   874,   629,    -1,   875,    -1,   874,   630,   875,    -1,
      -1,   521,   876,   877,   878,    -1,  1422,    -1,    -1,   879,
      -1,   879,   880,    -1,   880,    -1,   530,  1296,  1422,    -1,
    1337,   159,  1296,   899,    -1,    90,  1296,  1417,    -1,   348,
    1296,  1244,    -1,   307,  1296,  1246,    -1,   325,  1296,  1246,
      -1,   114,   137,  1296,  1417,    -1,   230,   137,  1296,  1417,
      -1,    82,  1296,  1417,    -1,    -1,    -1,   466,   882,  1108,
    1112,   883,   903,    -1,    -1,    19,    -1,    -1,   886,    -1,
     887,    -1,   886,   887,    -1,   898,    -1,   897,    -1,    -1,
     889,    -1,   890,    -1,   890,   889,    -1,   536,    -1,    -1,
     225,  1125,   172,    -1,    -1,   894,    -1,   895,    -1,   895,
     893,    -1,   895,    -1,   895,   894,    -1,   895,   630,   894,
      -1,   159,  1296,   899,    -1,   307,  1296,  1245,    -1,   325,
    1296,  1245,    -1,    27,  1296,  1243,    -1,   389,  1296,  1417,
      -1,    82,  1296,  1417,    -1,    26,  1296,  1245,    -1,   379,
    1296,  1243,    -1,   379,  1296,   128,    -1,    62,  1296,  1243,
      -1,   534,  1296,  1243,    -1,   381,  1296,  1249,    -1,   131,
    1296,  1243,    -1,   457,  1296,   901,    -1,    -1,   571,  1296,
     896,   628,  1358,   629,    -1,   897,    -1,   898,    -1,   238,
    1296,   902,    -1,   114,   137,  1296,  1417,    -1,   230,   137,
    1296,  1417,    -1,   530,  1420,    -1,   514,   140,    -1,   514,
     317,    -1,    90,  1296,  1417,    -1,   253,  1296,  1243,    -1,
     553,  1296,  1249,    -1,  1416,  1295,  1417,    -1,  1416,  1295,
    1420,    -1,  1416,  1295,  1246,    -1,  1416,  1295,   128,    -1,
     961,   952,  1296,   954,    -1,   961,    71,  1296,   960,    -1,
    1422,    -1,  1422,    -1,   128,    -1,   184,    -1,   149,    -1,
      87,    -1,   424,    -1,    85,    -1,   380,    -1,   353,    -1,
     183,    -1,   257,    -1,  1236,    -1,  1107,  1111,    -1,   516,
      -1,   419,    -1,   126,    -1,   242,    -1,   906,    -1,   907,
      -1,   906,   630,   907,    -1,   908,    -1,   909,    -1,   918,
     914,    -1,   918,   967,    -1,    -1,   973,   997,   982,   628,
     995,   629,   910,   983,    -1,    -1,   979,   976,   997,   981,
     628,   995,   629,   911,   984,    -1,    -1,   980,   976,   997,
     981,   628,   995,   629,   912,   985,    -1,    -1,   916,   974,
     997,   982,   628,   995,   629,   913,   983,    -1,   916,   189,
     254,   997,   628,   995,   629,   967,    -1,   916,   915,    -1,
      -1,   915,    -1,    63,   628,  1119,   629,    -1,    -1,   917,
      -1,    92,   997,    -1,    -1,  1412,   919,   920,    -1,   928,
     946,    -1,   928,   921,    19,   628,   927,   629,   922,   923,
      -1,    -1,   198,    14,    -1,    -1,   598,    -1,   390,    -1,
      -1,   924,    -1,   924,   925,    -1,   925,    -1,   572,    -1,
     572,   254,    -1,    82,  1417,    -1,   384,   628,   927,   629,
      -1,  1114,  1119,  1115,    -1,   936,   944,   940,    -1,   937,
     945,   940,    -1,   186,   938,   940,    -1,    39,    -1,    39,
     943,    -1,    44,    -1,    43,    -1,   932,   943,   964,    -1,
     932,   964,    -1,   933,   943,   965,    -1,   933,   965,    -1,
      34,   943,    -1,    34,    -1,   934,   943,   964,    -1,   935,
     943,   965,    -1,   590,   943,    -1,   616,   944,   940,    -1,
     118,    -1,   546,   944,    -1,   543,   944,    -1,   115,   944,
      -1,   547,    -1,    41,   944,    -1,   931,    -1,   313,    -1,
     280,    -1,   283,   590,    -1,   283,   934,   964,    -1,   549,
     964,    -1,   540,   944,   964,    -1,   315,   964,    -1,   281,
     964,    -1,   126,   938,   940,    -1,   358,   938,   940,    -1,
     184,   938,   940,    -1,    -1,   160,   929,   628,   999,   629,
     964,    -1,    -1,   474,   930,   628,   999,   629,   964,    -1,
     283,   964,    -1,   470,    -1,   200,    -1,   199,    -1,   394,
      -1,   333,    -1,   271,    -1,   332,    -1,   395,    -1,   334,
      -1,    60,    -1,   342,    -1,   339,    60,    -1,   932,   594,
      -1,   591,    -1,   339,   591,    -1,   359,    -1,   342,   591,
      -1,   339,    60,   594,    -1,   342,   594,    -1,   242,    -1,
     548,    -1,   486,    -1,   314,    -1,    33,    -1,   419,    -1,
     143,    -1,   143,   398,    -1,    -1,   943,    -1,   939,    -1,
     628,   357,   630,   357,   629,    -1,    -1,   941,    -1,   941,
     942,    -1,   942,    -1,   482,    -1,   575,    -1,   617,    -1,
     628,   282,   629,    -1,   628,   562,   629,    -1,   628,   125,
     629,    -1,   628,   357,   629,    -1,    -1,   943,    -1,    -1,
     939,    -1,    -1,   947,    -1,   947,   948,    -1,   948,    -1,
     356,    -1,  1125,   356,    -1,   128,   950,    -1,   362,   577,
     352,  1118,    -1,    26,    -1,   470,   128,   589,    -1,   966,
     254,    -1,   572,    -1,   572,   254,    -1,    82,  1417,    -1,
      71,   958,    -1,  1416,  1295,  1417,    -1,  1416,  1295,  1420,
      -1,  1416,  1295,  1246,    -1,  1416,  1295,   128,    -1,   928,
     959,    -1,   352,  1118,    -1,  1403,    -1,   213,    -1,   214,
      -1,    60,   474,    -1,    59,    -1,  1422,    -1,    34,    -1,
     953,    -1,   128,    -1,    -1,   952,   954,    -1,  1422,    -1,
      34,    -1,   956,    -1,   128,    -1,  1422,    -1,    -1,    71,
     960,    -1,   958,    -1,   128,    -1,    -1,   128,    -1,    21,
      -1,    34,    21,    -1,    21,    34,    -1,   569,    -1,   569,
      34,    -1,    34,   569,    -1,    -1,   962,    -1,   963,    -1,
      48,    -1,   952,   953,   965,    -1,    34,    -1,    34,   952,
     953,    -1,    -1,    34,    -1,    -1,   402,    -1,   425,  1413,
     968,   970,   971,    -1,    -1,   628,   969,   629,    -1,   969,
     630,  1420,    -1,  1420,    -1,    -1,   304,   193,    -1,   304,
     385,    -1,   304,   483,    -1,    -1,   362,   577,   972,    -1,
     362,   132,   972,    -1,   362,   577,   972,   362,   132,   972,
      -1,   362,   132,   972,   362,   577,   972,    -1,   447,    -1,
      51,    -1,   474,   356,    -1,   353,     5,    -1,   474,   128,
      -1,   975,    -1,   402,   254,    -1,   572,   976,    -1,   254,
      -1,   230,    -1,    -1,   975,    -1,   252,    -1,   230,    -1,
     229,    -1,    -1,   572,    -1,   194,    -1,   493,    -1,    -1,
     981,    -1,   981,   989,    -1,    -1,   986,    -1,    -1,   988,
      -1,    -1,   987,    -1,   991,    -1,   986,   991,    -1,   992,
      -1,   987,   992,    -1,   993,    -1,   988,   993,    -1,   584,
     994,    -1,   560,   994,    -1,   253,  1296,  1243,    -1,    82,
    1417,    -1,  1416,  1295,  1417,    -1,  1416,  1295,  1420,    -1,
    1416,  1295,  1246,    -1,  1416,  1295,   128,    -1,   990,    -1,
     989,    -1,   990,    -1,   990,    -1,   605,   383,  1416,    -1,
      46,    -1,   459,    -1,   210,    -1,   995,   630,   996,  1234,
      -1,   996,  1234,    -1,  1420,    -1,  1420,   628,   357,   629,
      -1,    -1,  1412,    -1,    -1,   636,  1420,    -1,  1401,    -1,
     999,   630,  1401,    -1,    -1,    13,  1035,   533,  1413,  1001,
    1012,    -1,    -1,    13,   111,  1011,  1002,   886,    -1,    13,
     111,  1420,   578,   114,   137,   338,    -1,    -1,    13,   404,
     686,  1003,   687,    -1,    -1,    13,   195,   686,  1004,   687,
      -1,    -1,    13,  1524,  1519,  1005,  1526,    -1,    -1,    13,
    1519,  1006,  1526,    -1,    -1,    13,  1519,   168,   686,  1007,
    1008,  1009,   676,   681,  1010,    -1,    13,   530,   786,    -1,
      13,   278,   205,   788,    -1,    13,   530,   783,    -1,    13,
     530,   782,    -1,    13,   472,  1422,   368,   628,   670,   629,
      -1,    -1,   362,   461,   674,    -1,   680,    -1,   362,   461,
     674,   680,    -1,    -1,   435,   550,   686,    -1,    -1,   144,
     682,    -1,    -1,  1420,    -1,    -1,   139,   530,    -1,   228,
     530,    -1,  1027,   832,    -1,  1027,  1016,    -1,  1016,    -1,
     833,    -1,  1018,    -1,   145,   388,  1025,    -1,   420,   388,
    1072,  1017,    -1,    -1,   367,   388,  1072,  1017,  1013,  1072,
      -1,    15,   388,  1072,  1017,    -1,    -1,    63,   388,  1017,
    1014,  1067,    -1,    -1,   437,   388,  1072,  1017,  1015,  1059,
      -1,    69,   388,  1072,  1244,    -1,   558,   388,  1017,    -1,
    1021,    -1,   434,   386,    -1,    12,    -1,  1025,    -1,    -1,
       6,   388,  1072,  1019,  1020,    -1,    -1,   628,   858,   629,
      -1,   387,  1244,    -1,    -1,   436,   388,  1072,  1022,  1023,
      -1,    -1,    -1,  1025,  1024,   241,   628,   858,   629,    -1,
    1026,    -1,  1025,   630,  1026,    -1,  1420,    -1,  1029,    -1,
    1027,   630,  1029,    -1,     6,  1033,    -1,  1028,   908,  1041,
      -1,     6,   909,    -1,  1028,   628,   905,   629,    -1,    -1,
      57,  1033,  1412,  1030,   918,  1041,    -1,    -1,    -1,   329,
    1033,  1412,  1031,   920,  1032,  1041,    -1,   145,  1033,  1412,
    1040,    -1,   145,   189,   254,   997,    -1,   145,   402,   254,
      -1,   145,   975,  1412,    -1,   138,   252,    -1,   153,   252,
      -1,    13,  1033,  1412,   474,   128,  1403,    -1,    13,  1033,
    1412,   145,   128,    -1,   435,  1042,  1413,    -1,   100,   550,
     952,   954,   959,    -1,   893,    -1,   188,    -1,  1227,    -1,
      -1,    80,    -1,    -1,   226,    -1,    -1,  1036,  1037,    -1,
      -1,  1038,    -1,  1038,  1039,    -1,  1039,    -1,   226,    -1,
     365,    -1,    -1,   447,    -1,    51,    -1,    -1,     8,  1420,
      -1,   183,    -1,    -1,   550,    -1,   161,    -1,    19,    -1,
      -1,   509,   484,  1048,  1044,  1052,    -1,   513,   484,  1048,
      -1,    -1,   484,   509,  1048,  1045,  1052,    -1,   484,   513,
    1048,    -1,   509,   552,  1047,    -1,    -1,   605,    91,   487,
      -1,    -1,  1049,  1050,    -1,  1051,    -1,  1050,   630,  1051,
      -1,    -1,   505,    -1,   431,    -1,    -1,   576,  1053,    -1,
     661,    -1,  1053,   630,   661,    -1,    -1,    62,  1445,  1055,
    1270,  1056,    -1,    -1,   413,    -1,   175,    -1,    -1,   437,
    1072,  1445,  1058,  1270,  1059,    -1,    -1,  1060,    -1,  1061,
      -1,  1061,  1060,    -1,   413,    -1,   175,    -1,   582,    -1,
      -1,    15,  1072,  1445,  1063,  1270,    -1,    35,  1417,    -1,
      -1,    63,  1445,  1066,  1270,  1067,    -1,    -1,  1068,    -1,
    1069,    -1,  1069,  1068,    -1,   413,    -1,   179,    -1,   316,
      -1,   175,    -1,    58,    -1,   190,   578,    -1,    -1,   367,
    1072,  1445,  1071,  1270,    -1,    -1,   355,    -1,   274,    -1,
      -1,   435,  1445,  1074,  1076,    -1,   435,   580,   685,  1075,
      -1,  1423,   550,  1423,    -1,  1075,   630,  1423,   550,  1423,
      -1,  1077,    -1,  1076,   630,  1077,    -1,  1413,   550,  1413,
      -1,    -1,    49,   230,  1079,  1080,   244,  1084,    -1,  1081,
      -1,  1083,    -1,  1082,    -1,  1081,   630,  1082,    -1,  1413,
    1093,    -1,  1413,  1091,  1093,    -1,  1420,    -1,   128,    -1,
      -1,   273,   230,   241,    49,  1086,  1087,    -1,  1090,    -1,
    1088,    -1,  1089,    -1,  1088,   630,  1089,    -1,  1413,  1093,
    1096,    -1,  1413,  1091,  1093,  1096,    -1,    -1,   388,   835,
    1092,   628,  1017,   629,    -1,    -1,  1094,  1095,    -1,    -1,
     975,   628,  1209,   629,    -1,    -1,   226,   261,    -1,  1098,
      -1,   466,  1101,    -1,   628,  1099,   629,  1501,    -1,   466,
    1103,    -1,   628,  1099,   629,    -1,   466,  1188,    -1,   628,
    1100,   629,    -1,    -1,  1103,  1102,  1498,    -1,    -1,    -1,
    1104,  1108,  1112,  1105,  1106,  1111,    -1,  1230,  1236,    -1,
    1259,    -1,  1107,    -1,  1259,  1107,    -1,  1107,  1259,    -1,
     192,  1170,  1219,  1224,  1221,  1230,  1236,  1250,    -1,   192,
     146,  1219,  1236,    -1,    -1,  1109,    -1,  1109,  1110,    -1,
    1110,    -1,  1515,    -1,   502,    -1,   500,    -1,    -1,   190,
     577,    -1,   277,   244,   476,   327,    -1,  1112,   630,  1113,
      -1,  1113,    -1,   623,    -1,  1114,  1407,  1115,    -1,  1114,
    1119,  1115,  1116,    -1,    -1,    -1,    -1,    19,  1420,    -1,
      19,  1417,    -1,  1420,    -1,  1417,    -1,    -1,   628,   629,
      -1,   628,  1244,   629,    -1,    -1,   628,   629,    -1,  1119,
    1123,  1119,    -1,  1119,   614,  1119,    -1,  1119,  1124,  1119,
      -1,   351,  1119,    -1,  1120,   247,   557,    -1,  1120,   247,
    1125,   557,    -1,  1120,   247,   178,    -1,  1120,   247,  1125,
     178,    -1,  1120,   247,   573,    -1,  1120,   247,  1125,   573,
      -1,  1120,    -1,  1120,   247,   356,    -1,  1120,   247,  1125,
     356,    -1,  1120,   162,  1121,    -1,  1120,  1127,  1121,    -1,
    1120,  1127,  1128,   628,  1510,   629,    -1,  1121,    -1,  1122,
     244,   628,  1510,   629,    -1,  1122,  1125,   244,   628,  1510,
     629,    -1,  1122,   244,   628,  1119,   629,    -1,  1122,   244,
     628,  1119,   630,  1163,   629,    -1,  1122,  1125,   244,   628,
    1119,   629,    -1,  1122,  1125,   244,   628,  1119,   630,  1163,
     629,    -1,  1122,    32,  1122,    17,  1121,    -1,  1122,  1125,
      32,  1122,    17,  1121,    -1,  1122,   491,   267,  1122,    -1,
    1122,   267,  1133,  1223,    -1,  1122,  1125,   267,  1133,  1223,
      -1,  1122,   426,  1122,    -1,  1122,  1125,   426,  1122,    -1,
    1122,    -1,  1122,   619,  1122,    -1,  1122,   620,  1122,    -1,
    1122,   477,  1122,    -1,  1122,   478,  1122,    -1,  1122,   622,
    1122,    -1,  1122,   621,  1122,    -1,  1122,   622,   240,  1119,
    1213,    -1,  1122,   621,   240,  1119,  1213,    -1,  1122,   623,
    1122,    -1,  1122,   624,  1122,    -1,  1122,   625,  1122,    -1,
    1122,   142,  1122,    -1,  1122,   330,  1122,    -1,  1122,   626,
    1122,    -1,  1133,    -1,   374,    -1,   371,    -1,    17,    -1,
      16,    -1,   351,    -1,   350,    -1,   631,    -1,   350,    -1,
     161,    -1,   196,    -1,   207,    -1,   259,    -1,   286,    -1,
     344,    -1,    12,    -1,    18,    -1,    -1,    19,  1130,    -1,
     242,    -1,   575,   242,    -1,   143,    -1,   419,    -1,   186,
      -1,   126,   938,    -1,   932,   964,    -1,   933,    -1,   118,
      -1,   546,   944,    -1,   115,   944,    -1,  1119,   630,  1119,
    1129,    -1,  1131,    -1,  1132,   630,  1131,    -1,  1409,    -1,
    1134,    -1,  1135,    -1,  1138,    -1,  1136,    -1,  1133,    71,
    1422,    -1,  1404,    -1,  1402,    -1,  1150,    -1,  1146,    -1,
    1133,   373,  1133,    -1,   622,  1133,    -1,   621,  1133,    -1,
     627,  1133,    -1,  1126,  1133,    -1,   628,  1510,   629,    -1,
     628,  1119,   629,    -1,   628,  1119,   630,  1163,   629,    -1,
     458,   628,  1119,   630,  1163,   629,    -1,   172,   628,  1510,
     629,    -1,   632,  1420,  1119,   633,    -1,   304,  1164,     9,
     628,  1122,  1140,   629,    -1,    34,  1133,    -1,    54,   628,
    1119,    19,  1160,   629,    -1,    53,  1166,  1168,  1167,   155,
      -1,   100,   628,  1119,   630,  1160,   629,    -1,   100,   628,
    1119,   584,   953,   629,    -1,   128,   628,  1409,   629,    -1,
     588,   628,  1410,   629,    -1,   240,  1119,  1213,   622,  1119,
      -1,    60,   628,  1163,   629,    -1,    60,   628,  1163,   584,
     953,   629,    -1,   107,  1118,    -1,   118,   628,  1119,   629,
      -1,   123,   628,  1119,   629,    -1,   221,   628,  1119,   629,
      -1,   237,   628,  1119,   630,  1119,   630,  1119,   630,  1119,
     629,    -1,   240,   628,  1119,   630,  1119,   629,    -1,   240,
     628,  1119,   630,  1119,   630,  1163,   629,    -1,   263,   628,
    1119,   630,  1119,   629,    -1,   324,   628,  1119,   629,    -1,
     331,   628,  1119,   629,    -1,   452,   628,  1119,   630,  1119,
     629,    -1,   464,   628,  1119,   629,    -1,   546,   628,  1119,
     629,    -1,   543,   628,  1119,   629,    -1,   543,   628,  1119,
     630,  1119,   629,    -1,   556,   628,  1119,   629,    -1,   556,
     628,   260,  1119,   192,  1119,   629,    -1,   556,   628,   551,
    1119,   192,  1119,   629,    -1,   556,   628,    45,  1119,   192,
    1119,   629,    -1,   556,   628,   260,   192,  1119,   629,    -1,
     556,   628,   551,   192,  1119,   629,    -1,   556,   628,    45,
     192,  1119,   629,    -1,   556,   628,  1119,   192,  1119,   629,
      -1,   580,   628,   629,    -1,   616,   628,  1119,   629,    -1,
       7,   628,  1119,   630,  1119,   629,    -1,     7,   628,  1119,
     630,   240,  1119,  1213,   629,    -1,   106,  1118,    -1,   110,
    1117,    -1,   116,   628,  1119,   630,   240,  1119,  1213,   629,
      -1,   117,   628,  1119,   630,   240,  1119,  1213,   629,    -1,
     177,   628,  1213,   192,  1119,   629,    -1,   201,   628,  1215,
     630,  1119,   629,    -1,   352,  1117,    -1,   397,   628,  1122,
     244,  1119,   629,    -1,   518,   628,  1119,   630,  1119,   629,
      -1,   518,   628,  1119,   630,   240,  1119,  1213,   629,    -1,
     522,   628,  1119,   630,  1119,   630,  1119,   629,    -1,   522,
     628,  1119,   630,  1119,   629,    -1,   522,   628,  1119,   192,
    1119,   190,  1119,   629,    -1,   522,   628,  1119,   192,  1119,
     629,    -1,   528,  1117,    -1,   544,   628,  1214,   630,  1119,
     630,  1119,   629,    -1,   545,   628,  1214,   630,  1119,   630,
    1119,   629,    -1,   585,  1118,    -1,   587,  1117,    -1,   586,
    1117,    -1,    74,   628,  1119,   630,  1132,   629,    -1,    76,
     628,  1119,   630,  1163,   629,    -1,    77,   628,  1119,   630,
    1119,   629,    -1,    79,   628,  1119,   629,    -1,    75,   628,
    1132,   629,    -1,    78,   628,  1119,   630,  1119,    19,  1160,
     629,    -1,    21,   628,  1119,   629,    -1,    59,   628,  1119,
     629,    -1,    69,   628,  1163,   629,    -1,    72,   628,  1119,
     629,    -1,   111,   628,   629,    -1,   225,   628,  1119,   630,
    1119,   630,  1119,   629,    -1,   258,   628,  1163,   629,    -1,
     320,   628,  1119,   629,    -1,   330,   628,  1119,   630,  1119,
     629,    -1,   361,   628,  1119,   629,    -1,   389,   628,  1119,
     629,    -1,   411,   628,  1119,   629,    -1,   439,   628,  1119,
     630,  1119,   629,    -1,   440,   628,  1119,   630,  1119,   630,
    1119,   629,    -1,   558,   628,  1119,   630,  1119,   629,    -1,
     601,   628,  1119,   629,    -1,   601,   628,  1119,   630,  1119,
     629,    -1,  1137,    -1,    96,   628,  1119,   630,  1119,   629,
      -1,   199,   628,  1163,   629,    -1,   271,   628,  1163,   629,
      -1,   332,   628,  1163,   629,    -1,   333,   628,  1163,   629,
      -1,   334,   628,  1163,   629,    -1,   394,   628,  1119,   630,
    1119,   629,    -1,   395,   628,  1163,   629,    -1,    -1,  1416,
     628,  1139,  1143,   629,    -1,  1420,   636,  1420,   628,  1162,
     629,    -1,  1141,  1142,    -1,   244,    43,   327,    -1,    -1,
     244,   340,   256,   327,    -1,    -1,   605,   412,   174,    -1,
      -1,  1144,    -1,  1145,    -1,  1144,   630,  1145,    -1,  1114,
    1119,  1115,  1116,    -1,    28,   628,  1158,   629,    -1,    28,
     628,   141,  1158,   629,    -1,    37,   628,  1158,   629,    -1,
      38,   628,  1158,   629,    -1,    40,   628,  1158,   629,    -1,
     101,   628,  1218,   623,   629,    -1,   101,   628,  1158,   629,
      -1,    -1,    -1,   101,   628,   141,  1147,  1163,  1148,   629,
      -1,   326,   628,  1158,   629,    -1,   326,   628,   141,  1158,
     629,    -1,   309,   628,  1158,   629,    -1,   309,   628,   141,
    1158,   629,    -1,   512,   628,  1158,   629,    -1,   593,   628,
    1158,   629,    -1,   511,   628,  1158,   629,    -1,   595,   628,
    1158,   629,    -1,   523,   628,  1158,   629,    -1,   523,   628,
     141,  1158,   629,    -1,    -1,   206,   628,  1153,  1149,  1163,
    1155,  1154,   629,    -1,    -1,   635,  1151,  1152,    -1,  1422,
     475,  1119,    -1,  1422,    -1,   635,  1435,  1422,   998,    -1,
      -1,   141,    -1,    -1,   468,  1401,    -1,    -1,    -1,   372,
      47,  1156,  1157,    -1,  1157,   630,  1408,  1234,    -1,  1408,
    1234,    -1,    -1,  1218,  1159,  1119,    -1,    34,   944,    -1,
      60,   944,   964,    -1,   342,   944,    -1,   242,    -1,   482,
      -1,   482,   242,    -1,   575,    -1,   575,   242,    -1,   118,
      -1,   546,   944,    -1,   115,   944,    -1,   126,   938,    -1,
      -1,   143,  1161,   945,    -1,    -1,  1163,    -1,  1119,    -1,
    1163,   630,  1119,    -1,  1165,    -1,   628,  1165,   629,    -1,
    1409,    -1,  1165,   630,  1409,    -1,    -1,  1119,    -1,    -1,
     151,  1119,    -1,   602,  1119,   542,  1119,    -1,  1168,   602,
    1119,   542,  1119,    -1,  1182,    -1,  1173,    -1,  1172,    -1,
    1169,    -1,   632,  1420,  1169,   633,    -1,  1171,    -1,  1172,
     630,  1171,    -1,  1169,  1181,  1169,    -1,  1169,   515,  1182,
      -1,    -1,  1169,  1181,  1169,   362,  1174,  1119,    -1,    -1,
    1169,   515,  1182,   362,  1175,  1119,    -1,    -1,  1169,  1181,
    1169,   584,  1176,   628,  1212,   629,    -1,  1169,   340,   251,
    1182,    -1,    -1,  1169,   263,  1198,   251,  1169,   362,  1177,
    1119,    -1,    -1,  1169,   263,  1198,   251,  1182,  1178,   584,
     628,  1212,   629,    -1,  1169,   340,   263,  1198,   251,  1182,
      -1,    -1,  1169,   452,  1198,   251,  1169,   362,  1179,  1119,
      -1,    -1,  1169,   452,  1198,   251,  1182,  1180,   584,   628,
    1212,   629,    -1,  1169,   340,   452,  1198,   251,  1182,    -1,
     251,    -1,   234,   251,    -1,   104,   251,    -1,    -1,  1183,
    1413,  1217,  1207,    -1,  1197,  1196,  1193,    -1,   628,  1196,
    1184,   629,  1217,    -1,  1191,  1502,    -1,    -1,    -1,  1184,
     571,  1506,  1185,  1507,  1186,  1502,    -1,  1188,    -1,    -1,
      -1,  1189,  1513,  1112,  1190,   903,  1111,    -1,    -1,  1196,
    1192,  1172,    -1,    -1,    -1,  1194,  1108,  1112,  1195,   903,
      -1,    -1,   466,    -1,    -1,   375,    -1,    -1,   190,   251,
      -1,   190,   372,    47,    -1,   190,   205,    47,    -1,   188,
      -1,   226,    -1,    -1,  1200,   975,  1199,  1202,   628,  1211,
     629,    -1,    -1,   583,   975,  1199,  1203,   628,  1209,   629,
      -1,  1201,    -1,  1204,  1201,    -1,    -1,    -1,  1206,  1204,
      -1,    -1,  1208,  1205,    -1,    -1,  1211,    -1,  1420,    -1,
     402,    -1,  1210,    -1,  1211,   630,  1210,    -1,  1420,    -1,
    1212,   630,  1420,    -1,  1214,    -1,   119,    -1,   120,    -1,
     121,    -1,   122,    -1,   218,    -1,   219,    -1,   220,    -1,
     322,    -1,   323,    -1,   463,    -1,   615,    -1,   123,    -1,
     601,    -1,   221,    -1,   324,    -1,   331,    -1,   411,    -1,
     464,    -1,   320,    -1,   616,    -1,   118,    -1,   546,    -1,
     115,    -1,   543,    -1,    -1,    19,    -1,   161,    -1,    -1,
    1216,  1420,    -1,    -1,    12,    -1,    -1,    -1,   603,  1220,
    1119,    -1,    -1,    -1,   211,  1222,  1119,    -1,   166,  1133,
      -1,    -1,    -1,   205,    47,  1225,  1226,    -1,  1225,   630,
    1408,  1234,    -1,  1408,  1234,    -1,    -1,   606,    -1,   607,
      -1,   372,    47,  1228,    -1,  1228,   630,  1229,    -1,  1229,
      -1,  1410,  1234,    -1,    -1,  1231,    -1,    -1,   372,    47,
    1232,  1233,    -1,  1233,   630,  1408,  1234,    -1,  1408,  1234,
      -1,    -1,    20,    -1,   133,    -1,    -1,  1237,    -1,    -1,
    1237,    -1,   268,  1238,    -1,   268,  1238,   456,   170,  1240,
      -1,   268,   456,   170,  1240,    -1,  1239,    -1,  1239,   630,
    1239,    -1,  1239,   360,  1239,    -1,  1420,    -1,  1402,    -1,
     562,    -1,   282,    -1,   357,    -1,  1239,    -1,    -1,   268,
    1239,    -1,   268,   456,   170,    -1,   268,  1239,   456,   170,
      -1,   357,    -1,   621,   357,    -1,   621,   282,    -1,   357,
      -1,   213,    -1,   282,    -1,   562,    -1,   125,    -1,   185,
      -1,   357,    -1,   213,    -1,   282,    -1,   562,    -1,  1247,
      -1,   357,    -1,   562,    -1,   282,    -1,   125,    -1,   185,
      -1,   357,    -1,   562,    -1,   213,    -1,   282,    -1,  1247,
      -1,  1248,    -1,   125,    -1,   185,    -1,  1243,    -1,   128,
      -1,    -1,    -1,   404,  1420,  1251,   628,  1252,   629,    -1,
      -1,  1253,    -1,  1253,   630,  1254,    -1,  1254,    -1,  1114,
    1119,  1115,    -1,    -1,  1256,  1257,    -1,  1257,   630,  1258,
      -1,  1258,    -1,   635,  1422,    -1,  1422,    -1,    -1,   241,
    1260,  1261,    -1,    -1,    -1,   376,  1419,  1262,   955,  1263,
    1385,  1388,    -1,   147,  1419,    -1,  1255,    -1,    -1,   144,
    1265,  1163,    -1,    -1,   145,  1275,  1445,  1274,  1267,  1270,
    1040,    -1,    -1,   145,   230,  1420,   362,  1413,  1268,    -1,
     145,   111,  1274,  1420,    -1,   145,   195,  1274,  1420,   636,
    1420,    -1,   145,   195,  1274,  1420,    -1,   145,   404,  1274,
     686,    -1,   145,   580,   685,  1475,    -1,    -1,   145,   597,
    1274,  1269,  1270,  1040,    -1,   145,   168,  1274,   686,    -1,
     145,   555,  1274,   686,    -1,   145,   530,   809,   820,   821,
      -1,   145,   278,   205,   810,   820,   821,    -1,   145,   472,
    1274,  1422,    -1,  1271,    -1,  1270,   630,  1271,    -1,  1413,
      -1,  1273,    -1,  1272,   630,  1273,    -1,  1414,    -1,    -1,
     225,   172,    -1,    -1,   536,    -1,    -1,    -1,   237,  1277,
    1282,  1034,  1284,  1278,  1286,  1302,    -1,    -1,    -1,   440,
    1280,  1283,  1284,  1281,  1286,    -1,    -1,   285,    -1,   130,
      -1,   215,    -1,  1311,    -1,   130,    -1,   241,  1285,    -1,
    1285,    -1,  1271,    -1,  1289,    -1,   628,   629,  1289,    -1,
     628,  1288,   629,  1289,    -1,    -1,   474,  1287,  1293,    -1,
    1288,   630,  1406,    -1,  1406,    -1,   588,  1292,    -1,   589,
    1292,    -1,    -1,   881,  1290,  1498,    -1,    -1,   628,   881,
     629,  1291,  1501,    -1,  1292,   630,  1297,    -1,  1297,    -1,
    1293,   630,  1294,    -1,  1294,    -1,  1410,  1295,  1301,    -1,
     161,    -1,   475,    -1,    -1,  1295,    -1,    -1,   628,  1298,
    1299,   629,    -1,    -1,  1300,    -1,  1300,   630,  1301,    -1,
    1301,    -1,  1119,    -1,   128,    -1,    -1,    -1,   362,   148,
    1303,   254,   577,  1309,    -1,    -1,    -1,   577,  1305,  1311,
    1034,  1170,   474,  1307,  1306,  1219,  1230,  1241,    -1,  1307,
     630,  1308,    -1,  1308,    -1,  1410,  1295,  1301,    -1,  1309,
     630,  1310,    -1,  1310,    -1,  1410,  1295,  1301,    -1,    -1,
     285,    -1,    -1,   132,  1313,  1321,  1314,    -1,    -1,   192,
    1413,  1315,  1219,  1230,  1241,    -1,    -1,  1318,  1316,   192,
    1170,  1219,    -1,    -1,   192,  1272,  1317,   584,  1170,  1219,
      -1,  1319,    -1,  1318,   630,  1319,    -1,  1420,  1320,    -1,
    1420,   636,  1420,  1320,    -1,    -1,   636,   623,    -1,    -1,
    1322,  1321,    -1,   413,    -1,   285,    -1,   226,    -1,    -1,
     558,  1325,  1324,  1271,    -1,    -1,   533,    -1,    -1,  1327,
      -1,  1328,    -1,  1327,   630,  1328,    -1,   102,    -1,   317,
      -1,    42,   245,    -1,    97,   527,    -1,   380,   180,    -1,
     246,    -1,   526,    -1,   492,    -1,    12,    -1,    -1,   190,
     412,   357,    -1,    -1,   479,  1331,  1332,    -1,   112,  1343,
      -1,  1339,   529,  1338,  1343,    -1,  1339,   554,  1338,  1343,
      -1,   167,  1338,  1343,    -1,   533,   510,  1338,  1343,    -1,
     366,   529,  1338,  1343,    -1,   392,    -1,   159,   900,  1335,
      -1,   159,    12,  1335,    -1,  1339,    73,  1340,  1413,  1338,
    1343,    -1,  1336,   279,    -1,   484,   217,    -1,    -1,    35,
     167,  1341,  1342,  1333,  1235,    -1,    -1,   428,   167,  1341,
    1342,  1334,  1235,    -1,   977,  1340,  1413,  1338,  1219,    -1,
    1337,   158,    -1,    24,    -1,    99,    -1,   403,    -1,   101,
     628,   623,   629,   600,    -1,   101,   628,   623,   629,   164,
      -1,   600,  1235,    -1,   164,  1235,    -1,   408,    -1,   407,
    1326,  1329,  1235,    -1,  1434,   510,  1343,    -1,  1339,   406,
      -1,  1434,   592,  1343,    -1,   952,  1343,    -1,    72,  1343,
      -1,   204,    -1,   204,   190,  1423,    -1,   103,   111,   891,
    1420,    -1,   103,   533,  1413,    -1,   103,   597,  1413,    -1,
     301,   510,    -1,   484,   510,    -1,    67,    -1,   581,    -1,
     532,    -1,   231,    -1,   103,   404,   686,    -1,   103,   195,
     686,    -1,   103,   555,   686,    -1,   404,   510,  1343,    -1,
     195,   510,  1343,    -1,   404,    70,   686,    -1,   195,    70,
     686,    -1,   103,   168,   686,    -1,   510,    -1,   335,    -1,
     279,    -1,   301,    -1,    34,    -1,    -1,   514,    -1,    -1,
    1340,  1420,    -1,    -1,   193,    -1,   192,    -1,   244,    -1,
      -1,   244,  1417,    -1,    -1,   192,  1245,    -1,    -1,   267,
    1417,    -1,   603,  1119,    -1,    -1,  1347,  1413,  1345,  1349,
      -1,    -1,  1347,  1348,  1346,  1097,    -1,   133,    -1,   134,
      -1,    -1,   175,    -1,   387,    -1,    -1,  1401,    -1,  1420,
      -1,    -1,   187,  1072,  1351,  1352,    -1,    -1,    -1,  1445,
    1353,  1358,  1354,  1355,    -1,  1356,    -1,    -1,   605,   417,
     277,  1359,    -1,  1356,   630,  1357,    -1,  1357,    -1,   163,
     279,    -1,   159,   279,    -1,   197,   279,    -1,   485,   279,
      -1,    34,   279,    -1,   427,   279,    -1,   412,    49,    -1,
     217,    -1,   403,    -1,   279,    -1,   510,    -1,   484,    -1,
      67,    -1,   581,    -1,   532,    -1,   231,    -1,   301,    -1,
     135,    -1,   445,    -1,    -1,  1270,    -1,    -1,    17,   138,
      61,    -1,    -1,   443,  1361,  1362,    -1,  1362,   630,  1363,
      -1,  1363,    -1,    -1,   484,  1364,  1365,    -1,   301,    -1,
     412,    49,    -1,    -1,    12,    -1,    -1,   410,  1367,  1368,
      -1,  1336,   279,  1369,    -1,   550,  1417,    -1,    30,  1119,
      -1,    -1,   255,  1371,  1372,  1373,  1374,    -1,    -1,   209,
      -1,   489,    -1,    -1,    90,    -1,   412,    -1,  1119,    -1,
     580,  1423,    -1,   583,  1420,    -1,    -1,    -1,    -1,    -1,
     273,  1381,  1377,  1383,  1382,   232,  1419,  1378,  1384,   241,
     533,  1413,  1379,   955,  1380,  1391,  1385,  1388,  1392,  1394,
    1397,    -1,   114,    -1,   613,    -1,    -1,   274,    -1,    -1,
      88,    -1,   285,    -1,    -1,   440,    -1,   226,    -1,    -1,
      73,  1386,    -1,  1386,  1387,    -1,  1387,    -1,   538,    47,
    1401,    -1,   370,   154,    47,  1401,    -1,   154,    47,  1401,
      -1,   165,    47,  1401,    -1,    -1,   270,  1389,    -1,  1389,
    1390,    -1,  1390,    -1,   538,    47,  1401,    -1,   507,    47,
    1401,    -1,    -1,   456,   223,    47,  1401,    -1,    -1,   226,
     357,  1393,    -1,   270,    -1,   456,    -1,    -1,   628,  1395,
     629,    -1,   628,   629,    -1,  1395,   630,  1396,    -1,  1396,
      -1,  1410,    -1,   635,  1422,    -1,    -1,   474,  1398,    -1,
    1398,   630,  1399,    -1,  1399,    -1,  1410,  1295,  1114,  1301,
    1115,    -1,   539,    -1,   341,    -1,   565,   539,    -1,  1400,
    1418,    -1,  1418,    -1,   213,    -1,   214,    -1,    36,    -1,
     382,    -1,  1404,    -1,   622,  1405,    -1,   621,  1405,    -1,
    1400,    -1,  1405,    -1,   356,    -1,   178,    -1,   557,    -1,
     213,    -1,   214,    -1,    36,    -1,   565,   951,    -1,   565,
      36,    -1,   118,  1400,    -1,   546,  1400,    -1,   543,  1400,
      -1,   357,    -1,   282,    -1,   562,    -1,   125,    -1,   185,
      -1,  1410,    -1,  1407,    -1,  1420,   636,   623,    -1,  1420,
     636,  1420,   636,   623,    -1,  1119,    -1,  1420,    -1,  1411,
      -1,  1420,    -1,  1411,    -1,  1420,   636,  1420,    -1,   636,
    1420,   636,  1420,    -1,  1420,   636,  1420,   636,  1420,    -1,
    1420,    -1,  1420,   636,  1420,   636,  1420,    -1,  1420,   636,
    1420,    -1,   636,  1420,    -1,  1420,    -1,  1420,   636,  1420,
      -1,   636,  1420,    -1,  1420,  1320,    -1,  1420,   636,  1420,
    1320,    -1,  1420,    -1,   222,    -1,   224,    -1,   539,    -1,
     539,    -1,   539,    -1,  1416,    -1,  1424,    -1,  1416,    -1,
    1425,    -1,  1420,    -1,  1417,    -1,   266,    -1,  1422,    -1,
    1422,   635,  1422,    -1,   107,  1118,    -1,  1425,    -1,    21,
      -1,    29,    -1,    31,    -1,    48,    -1,    49,    -1,    59,
      -1,    62,    -1,    61,    -1,    68,    -1,    74,    -1,    75,
      -1,    76,    -1,    77,    -1,    78,    -1,    79,    -1,    82,
      -1,    84,    -1,    96,    -1,   124,    -1,   144,    -1,   155,
      -1,   170,    -1,   171,    -1,   187,    -1,   208,    -1,   212,
      -1,   216,    -1,   239,    -1,   256,    -1,   353,    -1,   366,
      -1,   369,    -1,   368,    -1,   378,    -1,   383,    -1,   388,
      -1,   396,    -1,   399,    -1,   434,    -1,   437,    -1,   443,
      -1,   446,    -1,   453,    -1,   460,    -1,   465,    -1,   472,
      -1,   482,    -1,   488,    -1,   484,    -1,   490,    -1,   509,
      -1,   513,    -1,   558,    -1,   569,    -1,   570,    -1,   609,
      -1,   612,    -1,   578,    -1,     5,    -1,     7,    -1,     8,
      -1,     9,    -1,    10,    -1,    11,    -1,    14,    -1,    18,
      -1,    23,    -1,    24,    -1,    26,    -1,    25,    -1,    27,
      -1,    28,    -1,    35,    -1,    39,    -1,    42,    -1,    44,
      -1,    43,    -1,    46,    -1,    52,    -1,    55,    -1,    56,
      -1,    58,    -1,    64,    -1,    67,    -1,    66,    -1,    65,
      -1,    69,    -1,    70,    -1,    72,    -1,    81,    -1,    73,
      -1,    83,    -1,    85,    -1,    86,    -1,    87,    -1,    88,
      -1,    90,    -1,    91,    -1,    93,    -1,    95,    -1,    94,
      -1,    97,    -1,    99,    -1,   102,    -1,   105,    -1,   109,
      -1,   114,    -1,   113,    -1,   115,    -1,   118,    -1,   123,
      -1,   129,    -1,   131,    -1,   135,    -1,   137,    -1,   138,
      -1,   139,    -1,   140,    -1,   147,    -1,   148,    -1,   149,
      -1,   156,    -1,   160,    -1,   159,    -1,   158,    -1,   163,
      -1,   164,    -1,   166,    -1,   168,    -1,   167,    -1,   169,
      -1,   174,    -1,   175,    -1,   176,    -1,   180,    -1,   179,
      -1,   191,    -1,   153,    -1,   193,    -1,   182,    -1,   183,
      -1,   184,    -1,   197,    -1,   198,    -1,   200,    -1,   199,
      -1,   201,    -1,   204,    -1,   202,    -1,   210,    -1,   209,
      -1,   217,    -1,   221,    -1,   223,    -1,   227,    -1,   231,
      -1,   243,    -1,   228,    -1,   229,    -1,   233,    -1,   245,
      -1,   246,    -1,   248,    -1,   249,    -1,   238,    -1,   253,
      -1,   258,    -1,   257,    -1,   261,    -1,   264,    -1,   265,
      -1,   271,    -1,   272,    -1,   274,    -1,   276,    -1,   278,
      -1,   279,    -1,   307,    -1,   301,    -1,   303,    -1,   288,
      -1,   292,    -1,   289,    -1,   290,    -1,   302,    -1,   291,
      -1,   293,    -1,   287,    -1,   299,    -1,   295,    -1,   294,
      -1,   296,    -1,   297,    -1,   298,    -1,   305,    -1,   306,
      -1,   308,    -1,   310,    -1,   311,    -1,   316,    -1,   317,
      -1,   318,    -1,   319,    -1,   320,    -1,   321,    -1,   324,
      -1,   325,    -1,   329,    -1,   327,    -1,   331,    -1,   332,
      -1,   333,    -1,   334,    -1,   335,    -1,   336,    -1,   338,
      -1,   337,    -1,   339,    -1,   342,    -1,   343,    -1,   347,
      -1,   346,    -1,   354,    -1,   348,    -1,   349,    -1,   359,
      -1,   360,    -1,   361,    -1,   363,    -1,   364,    -1,   365,
      -1,   379,    -1,   380,    -1,   385,    -1,   386,    -1,   387,
      -1,   389,    -1,   390,    -1,   391,    -1,   393,    -1,   392,
      -1,   394,    -1,   395,    -1,   400,    -1,   401,    -1,   403,
      -1,   405,    -1,   406,    -1,   407,    -1,   408,    -1,   409,
      -1,   411,    -1,   412,    -1,   413,    -1,   416,    -1,   420,
      -1,   421,    -1,   423,    -1,   422,    -1,   424,    -1,   427,
      -1,   428,    -1,   429,    -1,   430,    -1,   431,    -1,   433,
      -1,   436,    -1,   438,    -1,   441,    -1,   445,    -1,   448,
      -1,   449,    -1,   454,    -1,   455,    -1,   456,    -1,   457,
      -1,   458,    -1,   459,    -1,   461,    -1,   462,    -1,   464,
      -1,   470,    -1,   469,    -1,   471,    -1,   483,    -1,   476,
      -1,   480,    -1,   485,    -1,   487,    -1,   489,    -1,   491,
      -1,   492,    -1,   500,    -1,   499,    -1,   502,    -1,   505,
      -1,   508,    -1,   510,    -1,   514,    -1,   516,    -1,   517,
      -1,   518,    -1,   519,    -1,   521,    -1,   520,    -1,   524,
      -1,   525,    -1,   526,    -1,   527,    -1,   535,    -1,   532,
      -1,   529,    -1,   534,    -1,   530,    -1,   536,    -1,   537,
      -1,   540,    -1,   541,    -1,   552,    -1,   553,    -1,   554,
      -1,   543,    -1,   544,    -1,   545,    -1,   546,    -1,   559,
      -1,   560,    -1,   561,    -1,   195,    -1,   563,    -1,   564,
      -1,   567,    -1,   566,    -1,   573,    -1,   576,    -1,   580,
      -1,   581,    -1,   582,    -1,   592,    -1,   597,    -1,   598,
      -1,   589,    -1,   600,    -1,   599,    -1,   601,    -1,   608,
      -1,   611,    -1,   613,    -1,   616,    -1,   596,    -1,    -1,
     474,  1428,  1427,  1429,    -1,    -1,   369,    -1,  1430,    -1,
    1429,   630,  1430,    -1,    -1,  1431,  1436,    -1,  1433,    -1,
     202,    -1,   274,    -1,   471,    -1,    -1,   363,    -1,    -1,
     202,    -1,   274,    -1,   471,    -1,    -1,   202,   636,    -1,
     274,   636,    -1,   471,   636,    -1,  1437,    -1,  1433,  1438,
      -1,  1432,  1439,  1295,  1442,    -1,  1432,   552,   248,   265,
    1440,    -1,   635,  1422,  1295,  1119,    -1,   635,   635,  1435,
    1439,  1295,  1442,    -1,   952,   957,    -1,   337,  1295,  1119,
      -1,   337,   954,   959,    -1,   389,  1295,  1441,    -1,   389,
     190,  1423,  1295,  1441,    -1,  1420,    -1,  1420,   636,  1420,
      -1,   128,   636,  1420,    -1,   417,   563,    -1,   417,    83,
      -1,   438,   417,    -1,   469,    -1,   539,    -1,   389,   628,
     539,   629,    -1,   361,   628,   539,   629,    -1,  1119,    -1,
     128,    -1,   362,    -1,    12,    -1,    34,    -1,    -1,   277,
    1445,  1444,  1446,    -1,   533,    -1,   529,    -1,  1447,    -1,
    1446,   630,  1447,    -1,  1413,  1217,  1448,    -1,   417,    -1,
     610,    -1,   610,    88,    -1,   285,   610,    -1,   417,   274,
      -1,    -1,   574,  1450,  1445,    -1,   208,  1413,   366,  1217,
      -1,   208,  1415,    68,    -1,    -1,   208,  1415,   417,  1452,
    1453,  1219,  1236,    -1,  1454,    -1,  1420,  1455,    -1,   183,
      -1,   347,    -1,   183,    -1,   347,    -1,   401,    -1,   257,
      -1,    -1,  1457,  1456,   628,  1300,   629,    -1,   161,    -1,
     196,    -1,   259,    -1,   207,    -1,   286,    -1,   451,   685,
    1459,    -1,  1463,   362,  1462,  1474,   192,  1475,    -1,  1463,
     362,   195,  1474,   192,  1475,    -1,  1463,   362,   404,  1474,
     192,  1475,    -1,    12,  1464,   630,   203,   369,   192,  1475,
      -1,   409,   362,  1423,   192,  1475,    -1,   203,   685,  1461,
      -1,  1463,   362,  1462,  1474,   550,  1476,  1483,  1484,    -1,
    1463,   362,   195,  1474,   550,  1476,  1483,  1484,    -1,  1463,
     362,   404,  1474,   550,  1476,  1483,  1484,    -1,   409,   362,
    1423,   550,  1476,  1485,    -1,    -1,   533,    -1,  1465,    -1,
      12,  1464,    -1,    -1,   403,    -1,  1466,    -1,  1465,   630,
    1466,    -1,    -1,   466,  1467,  1480,    -1,    -1,   237,  1468,
    1480,    -1,    -1,   577,  1469,  1480,    -1,    -1,   425,  1470,
    1480,    -1,   132,    -1,   579,    -1,   230,    -1,    13,    -1,
     103,    -1,   145,    -1,   171,    -1,   433,    -1,   480,    -1,
     405,    -1,   182,    -1,   203,   369,    -1,   479,   112,    -1,
     524,    -1,   103,   536,   529,    -1,   277,   529,    -1,   441,
     484,    -1,   441,    66,    -1,   103,   597,    -1,   479,   597,
      -1,   103,   455,    -1,    13,   455,    -1,   103,   580,    -1,
     168,    -1,   555,    -1,   103,   530,    -1,    -1,    17,    -1,
    1473,  1471,  1472,    -1,  1473,    -1,   519,   539,    -1,   249,
     539,    -1,    64,   539,    -1,   623,    -1,  1420,   636,   623,
      -1,   623,   636,   623,    -1,  1413,    -1,  1423,    -1,  1475,
     630,  1423,    -1,  1479,    -1,  1476,   630,  1479,    -1,   596,
      -1,   605,    -1,   584,    -1,    19,    -1,  1423,   223,    47,
     539,    -1,  1423,   223,    47,   389,   539,    -1,  1423,   223,
    1477,  1422,    -1,  1423,   223,  1477,  1422,  1478,  1417,    -1,
    1423,    -1,    -1,   628,  1481,   629,    -1,  1481,   630,  1482,
      -1,  1482,    -1,  1420,    -1,    -1,   442,  1472,    -1,   442,
     506,    -1,   442,   611,    -1,   442,   349,    -1,    -1,   605,
    1486,    -1,    -1,   605,   203,   369,    -1,  1486,  1487,    -1,
    1487,    -1,   203,   369,    -1,   306,  1243,    -1,   310,  1243,
      -1,   305,  1243,    -1,   311,  1242,    -1,    -1,    31,  1489,
    1490,    -1,    -1,   608,    -1,    -1,    17,   353,    56,    -1,
      17,    56,    -1,    -1,   432,    -1,   353,   432,    -1,    -1,
     460,    -1,    84,  1490,  1491,  1492,    -1,   453,  1490,  1491,
    1492,    -1,   453,  1490,   550,  1493,  1420,    -1,   460,  1420,
      -1,   432,   460,  1420,    -1,    -1,  1499,    -1,    -1,   571,
    1506,  1500,  1098,    -1,    -1,  1499,    -1,  1503,    -1,    -1,
    1503,    -1,    -1,  1504,  1505,    -1,  1231,  1235,    -1,  1237,
      -1,    -1,   141,    -1,    12,    -1,   466,  1187,    -1,   628,
    1100,   629,    -1,  1507,  1502,    -1,    -1,  1508,   571,  1506,
    1509,  1507,  1502,    -1,  1511,  1508,  1512,    -1,    -1,    -1,
      -1,  1514,    -1,  1514,  1515,    -1,  1515,    -1,   515,    -1,
     215,    -1,   141,    -1,   503,    -1,   498,    -1,   499,    -1,
     501,    -1,    12,    -1,  1521,  1517,    -1,  1520,  1518,    -1,
    1522,  1519,  1526,    -1,  1526,    -1,  1534,    -1,  1545,    -1,
    1539,    -1,   672,    -1,  1526,    -1,  1534,    -1,  1545,    -1,
    1539,    -1,  1538,    -1,   672,    -1,  1520,    -1,  1521,    -1,
      -1,   129,   161,  1423,    -1,  1523,    -1,  1523,  1524,    -1,
    1524,    -1,   374,   440,    -1,    11,   161,   564,    -1,    11,
     161,   318,    -1,    11,   161,   537,    -1,    -1,   504,   465,
     129,    -1,   504,   465,   243,    -1,    -1,  1525,   597,  1413,
    1527,  1528,    19,  1530,    -1,    -1,   628,  1529,   629,    -1,
    1420,    -1,  1529,   630,  1420,    -1,    -1,  1531,  1532,  1533,
      -1,   466,  1101,    -1,   628,  1099,   629,  1501,    -1,    -1,
     605,    63,   369,    -1,   605,    52,    63,   369,    -1,   605,
     274,    63,   369,    -1,    -1,    -1,    -1,   555,  1114,   686,
     780,   781,   362,  1114,  1535,  1413,   190,  1114,  1536,   150,
     458,  1537,   730,    -1,    10,  1114,   195,  1420,   449,   904,
     490,  1417,    -1,  1114,   195,  1420,   449,   904,   490,  1417,
      -1,    -1,    -1,    -1,    -1,    -1,  1114,   195,   686,   628,
    1540,   697,   629,  1541,   449,  1542,   949,  1543,   688,  1544,
     730,    -1,    -1,    -1,    -1,    -1,   404,  1114,   686,  1546,
     628,  1547,   701,   629,  1548,   688,  1549,   730,    -1,   612,
    1552,  1551,  1553,    -1,   612,   155,  1551,  1555,    -1,   612,
     399,  1551,    -1,   612,    84,  1551,  1554,    -1,   612,   453,
    1551,    -1,   612,   421,    -1,  1401,    -1,  1401,   630,  1401,
      -1,  1401,   630,  1401,   630,  1243,    -1,    31,    -1,   509,
      -1,    -1,   251,    -1,   448,    -1,    -1,   364,   391,    -1,
      -1,    -1,   525,  1556,  1557,    -1,    -1,   190,   321,    -1,
     239,   393,  1420,   490,  1417,    -1,   239,   490,  1417,    -1,
     570,   393,  1420,    -1,   570,   490,  1417,    -1,   618,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1706,  1706,  1719,  1718,  1743,  1750,  1752,  1756,  1757,
    1762,  1763,  1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,
    1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,  1781,
    1782,  1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,  1791,
    1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,  1800,  1801,
    1802,  1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,
    1812,  1813,  1814,  1818,  1828,  1829,  1833,  1843,  1850,  1861,
    1860,  1871,  1873,  1877,  1878,  1882,  1895,  1894,  1914,  1913,
    1922,  1923,  1927,  1931,  1935,  1939,  1943,  1947,  1952,  1956,
    1960,  1964,  1968,  1972,  1978,  2009,  2014,  2017,  2019,  2020,
    2024,  2030,  2034,  2050,  2054,  2066,  2065,  2107,  2106,  2118,
    2116,  2129,  2127,  2139,  2138,  2151,  2150,  2158,  2162,  2166,
    2170,  2177,  2190,  2191,  2195,  2199,  2203,  2207,  2211,  2215,
    2219,  2227,  2226,  2258,  2257,  2264,  2271,  2272,  2278,  2284,
    2294,  2300,  2306,  2308,  2315,  2316,  2320,  2326,  2335,  2336,
    2344,  2344,  2402,  2403,  2404,  2405,  2406,  2407,  2408,  2409,
    2410,  2411,  2412,  2413,  2414,  2419,  2433,  2449,  2468,  2469,
    2473,  2474,  2479,  2481,  2483,  2485,  2487,  2489,  2491,  2497,
    2498,  2499,  2503,  2507,  2515,  2514,  2527,  2529,  2532,  2534,
    2538,  2542,  2549,  2551,  2555,  2556,  2561,  2581,  2607,  2609,
    2613,  2614,  2618,  2644,  2645,  2646,  2647,  2651,  2652,  2656,
    2657,  2662,  2665,  2692,  2691,  2756,  2772,  2771,  2825,  2851,
    2851,  2874,  2875,  2880,  2882,  2887,  2910,  2923,  2927,  2944,
    2945,  2949,  2953,  2962,  2969,  2976,  2986,  3001,  3024,  3030,
    3031,  3037,  3040,  3044,  3052,  3072,  3074,  3092,  3098,  3100,
    3102,  3104,  3106,  3108,  3110,  3112,  3114,  3116,  3118,  3120,
    3125,  3140,  3155,  3173,  3174,  3178,  3179,  3180,  3181,  3182,
    3183,  3184,  3185,  3186,  3187,  3188,  3189,  3190,  3195,  3194,
    3201,  3201,  3258,  3257,  3286,  3286,  3300,  3353,  3396,  3417,
    3416,  3438,  3457,  3459,  3460,  3464,  3484,  3507,  3509,  3525,
    3507,  3544,  3546,  3547,  3551,  3552,  3557,  3563,  3556,  3584,
    3583,  3599,  3600,  3604,  3605,  3610,  3614,  3609,  3635,  3639,
    3634,  3658,  3668,  3673,  3672,  3708,  3709,  3714,  3713,  3746,
    3746,  3761,  3760,  3796,  3808,  3810,  3807,  3837,  3836,  3857,
    3859,  3864,  3866,  3868,  3885,  3890,  3896,  3903,  3904,  3912,
    3918,  3927,  3933,  3939,  3940,  3944,  3944,  3949,  3950,  3951,
    3955,  3956,  3957,  3961,  3965,  3966,  3967,  3971,  3972,  3973,
    3974,  3975,  3976,  3977,  3978,  3982,  3986,  3987,  3988,  3992,
    3993,  3994,  3995,  3996,  4000,  4004,  4005,  4006,  4010,  4011,
    4012,  4013,  4014,  4015,  4016,  4020,  4024,  4025,  4026,  4030,
    4031,  4032,  4037,  4045,  4053,  4061,  4073,  4085,  4090,  4095,
    4103,  4111,  4119,  4127,  4135,  4143,  4151,  4164,  4177,  4190,
    4192,  4196,  4201,  4214,  4215,  4266,  4267,  4270,  4285,  4304,
    4303,  4312,  4310,  4317,  4319,  4318,  4322,  4321,  4327,  4364,
    4365,  4370,  4369,  4388,  4407,  4406,  4423,  4427,  4435,  4434,
    4437,  4439,  4441,  4443,  4448,  4449,  4455,  4456,  4473,  4474,
    4478,  4479,  4483,  4502,  4512,  4523,  4532,  4533,  4549,  4551,
    4550,  4555,  4553,  4564,  4565,  4569,  4587,  4603,  4604,  4620,
    4635,  4657,  4658,  4663,  4662,  4686,  4696,  4718,  4717,  4735,
    4734,  4754,  4776,  4780,  4809,  4821,  4822,  4827,  4838,  4826,
    4863,  4864,  4868,  4881,  4902,  4915,  4941,  4942,  4947,  4946,
    4983,  4988,  4989,  4993,  4994,  4998,  5000,  5006,  5012,  5014,
    5016,  5018,  5020,  5022,  5032,  5047,  5031,  5061,  5062,  5066,
    5067,  5071,  5072,  5076,  5077,  5081,  5082,  5086,  5087,  5091,
    5095,  5096,  5099,  5101,  5105,  5106,  5110,  5111,  5112,  5116,
    5121,  5126,  5131,  5136,  5141,  5146,  5151,  5166,  5172,  5177,
    5182,  5187,  5192,  5198,  5197,  5223,  5224,  5225,  5230,  5235,
    5240,  5242,  5244,  5246,  5252,  5257,  5262,  5268,  5274,  5280,
    5289,  5307,  5324,  5347,  5361,  5362,  5363,  5364,  5365,  5366,
    5367,  5371,  5372,  5373,  5377,  5378,  5382,  5383,  5384,  5385,
    5390,  5397,  5398,  5402,  5403,  5407,  5408,  5416,  5415,  5424,
    5422,  5432,  5430,  5440,  5438,  5446,  5465,  5471,  5473,  5477,
    5481,  5482,  5486,  5491,  5490,  5516,  5517,  5526,  5528,  5533,
    5536,  5540,  5547,  5548,  5552,  5553,  5557,  5563,  5569,  5573,
    5589,  5605,  5606,  5607,  5608,  5613,  5617,  5622,  5627,  5631,
    5636,  5641,  5647,  5652,  5658,  5662,  5667,  5672,  5690,  5692,
    5694,  5707,  5709,  5714,  5719,  5731,  5736,  5741,  5746,  5748,
    5750,  5752,  5754,  5756,  5758,  5760,  5763,  5762,  5767,  5766,
    5770,  5772,  5781,  5782,  5783,  5788,  5789,  5790,  5791,  5792,
    5796,  5800,  5801,  5805,  5806,  5810,  5811,  5812,  5813,  5814,
    5818,  5819,  5820,  5821,  5822,  5826,  5831,  5833,  5839,  5840,
    5842,  5847,  5856,  5857,  5861,  5862,  5866,  5867,  5868,  5872,
    5873,  5874,  5875,  5878,  5879,  5883,  5884,  5888,  5889,  5893,
    5894,  5898,  5899,  5900,  5901,  5908,  5909,  5915,  5921,  5927,
    5933,  5934,  5947,  5953,  5959,  5965,  5974,  5995,  6001,  6006,
    6007,  6011,  6012,  6016,  6024,  6028,  6029,  6033,  6034,  6038,
    6047,  6051,  6052,  6056,  6067,  6068,  6072,  6073,  6077,  6078,
    6083,  6084,  6088,  6095,  6104,  6112,  6123,  6124,  6125,  6126,
    6127,  6128,  6133,  6141,  6142,  6146,  6148,  6152,  6164,  6165,
    6169,  6176,  6189,  6190,  6192,  6194,  6200,  6205,  6211,  6217,
    6224,  6234,  6235,  6236,  6237,  6238,  6242,  6246,  6247,  6251,
    6252,  6256,  6257,  6261,  6262,  6263,  6267,  6268,  6272,  6276,
    6289,  6301,  6302,  6306,  6307,  6311,  6312,  6316,  6317,  6321,
    6322,  6326,  6327,  6331,  6332,  6336,  6337,  6341,  6343,  6344,
    6350,  6356,  6362,  6370,  6371,  6375,  6379,  6380,  6393,  6394,
    6395,  6399,  6400,  6404,  6410,  6424,  6425,  6429,  6430,  6434,
    6435,  6443,  6442,  6481,  6480,  6494,  6506,  6505,  6524,  6523,
    6542,  6541,  6560,  6554,  6574,  6573,  6606,  6611,  6616,  6621,
    6626,  6636,  6637,  6638,  6639,  6643,  6644,  6656,  6657,  6661,
    6662,  6665,  6667,  6668,  6669,  6671,  6673,  6674,  6683,  6684,
    6688,  6697,  6695,  6709,  6723,  6722,  6736,  6734,  6748,  6755,
    6766,  6770,  6777,  6781,  6786,  6785,  6801,  6803,  6808,  6816,
    6815,  6831,  6835,  6834,  6846,  6847,  6851,  6866,  6867,  6871,
    6880,  6884,  6889,  6894,  6893,  6905,  6916,  6904,  6932,  6941,
    6945,  6954,  6963,  6969,  6975,  6984,  6993,  7012,  7033,  7043,
    7047,  7055,  7056,  7060,  7061,  7065,  7065,  7068,  7070,  7074,
    7075,  7079,  7080,  7084,  7085,  7086,  7090,  7091,  7092,  7096,
    7097,  7098,  7099,  7108,  7107,  7116,  7124,  7123,  7131,  7140,
    7149,  7150,  7157,  7157,  7163,  7164,  7168,  7169,  7170,  7174,
    7175,  7191,  7192,  7197,  7196,  7208,  7209,  7210,  7215,  7214,
    7236,  7237,  7241,  7242,  7246,  7247,  7248,  7253,  7252,  7274,
    7283,  7282,  7309,  7310,  7314,  7315,  7319,  7320,  7321,  7322,
    7323,  7324,  7329,  7328,  7350,  7351,  7352,  7357,  7356,  7362,
    7369,  7374,  7382,  7383,  7387,  7401,  7400,  7413,  7414,  7418,
    7419,  7423,  7433,  7443,  7444,  7449,  7448,  7459,  7460,  7464,
    7465,  7469,  7479,  7490,  7489,  7497,  7497,  7506,  7507,  7512,
    7513,  7522,  7531,  7532,  7536,  7541,  7546,  7551,  7556,  7555,
    7575,  7583,  7575,  7590,  7591,  7592,  7593,  7594,  7598,  7605,
    7612,  7614,  7625,  7626,  7630,  7631,  7659,  7689,  7691,  7697,
    7707,  7708,  7709,  7724,  7731,  7757,  7763,  7769,  7770,  7771,
    7772,  7773,  7777,  7778,  7779,  7783,  7784,  7789,  7840,  7847,
    7890,  7896,  7902,  7908,  7914,  7920,  7926,  7932,  7936,  7942,
    7948,  7954,  7960,  7966,  7970,  7976,  7986,  7992,  8000,  8006,
    8016,  8022,  8031,  8041,  8047,  8057,  8063,  8072,  8076,  8082,
    8088,  8094,  8100,  8106,  8112,  8118,  8124,  8130,  8136,  8142,
    8148,  8154,  8160,  8164,  8165,  8169,  8170,  8174,  8175,  8179,
    8180,  8184,  8185,  8186,  8187,  8188,  8189,  8193,  8194,  8199,
    8205,  8209,  8216,  8223,  8230,  8237,  8244,  8249,  8255,  8262,
    8269,  8277,  8288,  8310,  8317,  8325,  8326,  8327,  8328,  8329,
    8330,  8342,  8343,  8344,  8345,  8346,  8352,  8356,  8362,  8368,
    8374,  8380,  8382,  8389,  8396,  8402,  8404,  8413,  8420,  8428,
    8434,  8441,  8447,  8461,  8468,  8484,  8490,  8496,  8504,  8510,
    8516,  8522,  8528,  8543,  8555,  8561,  8567,  8573,  8579,  8585,
    8591,  8597,  8603,  8609,  8615,  8621,  8627,  8633,  8639,  8645,
    8651,  8659,  8680,  8687,  8693,  8700,  8707,  8714,  8721,  8727,
    8733,  8740,  8746,  8753,  8759,  8765,  8771,  8777,  8783,  8801,
    8807,  8813,  8820,  8827,  8835,  8842,  8849,  8856,  8863,  8870,
    8887,  8893,  8899,  8905,  8911,  8918,  8924,  8930,  8936,  8942,
    8948,  8960,  8966,  8972,  8978,  8984,  8996,  9002,  9018,  9024,
    9031,  9038,  9045,  9052,  9059,  9063,  9083,  9082,  9155,  9197,
    9199,  9204,  9205,  9209,  9210,  9214,  9215,  9219,  9226,  9234,
    9260,  9266,  9272,  9278,  9284,  9290,  9299,  9306,  9308,  9305,
    9315,  9326,  9332,  9338,  9344,  9350,  9356,  9362,  9368,  9374,
    9381,  9380,  9400,  9399,  9414,  9424,  9432,  9448,  9449,  9454,
    9459,  9462,  9465,  9464,  9481,  9483,  9489,  9488,  9505,  9507,
    9509,  9511,  9513,  9515,  9517,  9519,  9521,  9523,  9529,  9535,
    9538,  9537,  9543,  9544,  9548,  9555,  9563,  9564,  9568,  9575,
    9583,  9584,  9588,  9589,  9593,  9601,  9612,  9613,  9625,  9636,
    9637,  9643,  9644,  9664,  9666,  9670,  9668,  9685,  9683,  9701,
    9699,  9706,  9715,  9713,  9731,  9730,  9740,  9751,  9749,  9768,
    9767,  9778,  9789,  9790,  9791,  9803,  9803,  9817,  9857,  9933,
    9944,  9949,  9941,  9968,  9988,  9996,  9988, 10005, 10004, 10027,
   10044, 10027, 10051, 10055, 10081, 10082, 10087, 10090, 10091, 10092,
   10096, 10097, 10102, 10101, 10107, 10106, 10114, 10115, 10118, 10120,
   10120, 10124, 10124, 10129, 10130, 10134, 10136, 10141, 10142, 10146,
   10157, 10170, 10171, 10172, 10173, 10174, 10175, 10176, 10177, 10178,
   10179, 10180, 10181, 10185, 10186, 10187, 10188, 10189, 10190, 10191,
   10192, 10193, 10197, 10198, 10199, 10200, 10203, 10205, 10206, 10210,
   10211, 10219, 10221, 10225, 10227, 10226, 10240, 10243, 10242, 10257,
   10263, 10278, 10280, 10284, 10286, 10291, 10292, 10312, 10337, 10341,
   10342, 10346, 10359, 10361, 10366, 10365, 10400, 10402, 10407, 10408,
   10409, 10414, 10421, 10425, 10426, 10430, 10434, 10438, 10445, 10452,
   10459, 10469, 10503, 10507, 10513, 10519, 10528, 10536, 10540, 10547,
   10548, 10552, 10553, 10554, 10558, 10559, 10560, 10561, 10562, 10563,
   10567, 10568, 10569, 10570, 10571, 10575, 10576, 10577, 10578, 10579,
   10583, 10584, 10585, 10586, 10587, 10591, 10596, 10597, 10601, 10602,
   10605, 10608, 10607, 10638, 10639, 10643, 10644, 10648, 10660, 10660,
   10670, 10671, 10675, 10694, 10727, 10726, 10739, 10747, 10738, 10749,
   10761, 10773, 10772, 10790, 10789, 10800, 10800, 10816, 10823, 10846,
   10867, 10879, 10884, 10883, 10893, 10899, 10906, 10911, 10916, 10926,
   10927, 10931, 10942, 10943, 10947, 10958, 10959, 10963, 10964, 10972,
   10980, 10971, 10990, 10997, 10989, 11007, 11015, 11016, 11024, 11028,
   11029, 11040, 11041, 11045, 11054, 11055, 11056, 11058, 11057, 11068,
   11069, 11073, 11074, 11076, 11075, 11079, 11078, 11084, 11085, 11089,
   11090, 11094, 11104, 11105, 11109, 11110, 11115, 11114, 11128, 11129,
   11133, 11138, 11146, 11147, 11155, 11157, 11157, 11165, 11173, 11164,
   11195, 11196, 11200, 11208, 11209, 11213, 11223, 11224, 11231, 11230,
   11246, 11245, 11257, 11256, 11268, 11267, 11281, 11282, 11286, 11299,
   11315, 11316, 11320, 11321, 11325, 11326, 11327, 11332, 11331, 11353,
   11355, 11358, 11360, 11363, 11364, 11367, 11371, 11375, 11379, 11383,
   11387, 11391, 11395, 11399, 11407, 11410, 11420, 11419, 11434, 11441,
   11449, 11457, 11465, 11473, 11481, 11488, 11490, 11492, 11501, 11505,
   11510, 11509, 11515, 11514, 11519, 11528, 11535, 11544, 11553, 11558,
   11560, 11562, 11564, 11566, 11568, 11575, 11583, 11585, 11593, 11600,
   11607, 11617, 11624, 11630, 11639, 11647, 11651, 11655, 11662, 11669,
   11676, 11683, 11690, 11697, 11703, 11710, 11717, 11722, 11727, 11735,
   11737, 11739, 11744, 11745, 11748, 11750, 11754, 11755, 11759, 11760,
   11764, 11765, 11769, 11770, 11774, 11775, 11778, 11780, 11787, 11798,
   11797, 11813, 11812, 11822, 11823, 11827, 11828, 11829, 11833, 11834,
   11835, 11850, 11849, 11862, 11871, 11861, 11873, 11877, 11878, 11892,
   11893, 11898, 11900, 11902, 11904, 11906, 11908, 11910, 11912, 11914,
   11916, 11918, 11920, 11925, 11927, 11929, 11931, 11933, 11935, 11937,
   11942, 11943, 11947, 11948, 11952, 11951, 11961, 11962, 11966, 11966,
   11968, 11969, 11973, 11974, 11979, 11978, 11989, 11993, 11997, 12010,
   12009, 12023, 12024, 12025, 12028, 12029, 12030, 12034, 12039, 12049,
   12061, 12073, 12083, 12093, 12060, 12101, 12102, 12106, 12107, 12111,
   12112, 12120, 12124, 12125, 12126, 12129, 12131, 12135, 12136, 12140,
   12145, 12152, 12157, 12164, 12166, 12170, 12171, 12175, 12180, 12188,
   12189, 12192, 12194, 12202, 12204, 12208, 12209, 12210, 12214, 12216,
   12221, 12222, 12231, 12232, 12236, 12237, 12241, 12254, 12278, 12290,
   12301, 12320, 12328, 12340, 12348, 12363, 12384, 12385, 12386, 12394,
   12395, 12396, 12403, 12409, 12415, 12421, 12427, 12433, 12462, 12490,
   12491, 12492, 12496, 12506, 12516, 12522, 12531, 12546, 12547, 12551,
   12560, 12576, 12580, 12627, 12631, 12649, 12653, 12732, 12757, 12788,
   12789, 12805, 12815, 12819, 12825, 12831, 12841, 12847, 12856, 12866,
   12867, 12897, 12913, 12929, 12946, 12947, 12958, 12959, 12970, 12971,
   12972, 12976, 12993, 13015, 13030, 13031, 13032, 13033, 13034, 13035,
   13036, 13037, 13038, 13039, 13040, 13041, 13042, 13043, 13044, 13045,
   13046, 13047, 13048, 13049, 13050, 13051, 13052, 13053, 13054, 13055,
   13056, 13057, 13058, 13059, 13060, 13061, 13062, 13063, 13064, 13065,
   13066, 13067, 13068, 13069, 13070, 13071, 13072, 13073, 13074, 13075,
   13076, 13077, 13078, 13079, 13080, 13081, 13082, 13083, 13084, 13085,
   13086, 13087, 13088, 13098, 13099, 13100, 13101, 13102, 13103, 13104,
   13105, 13106, 13107, 13108, 13109, 13110, 13111, 13112, 13113, 13114,
   13115, 13116, 13117, 13118, 13119, 13120, 13121, 13122, 13123, 13124,
   13125, 13126, 13127, 13128, 13129, 13130, 13131, 13132, 13133, 13134,
   13135, 13136, 13137, 13138, 13139, 13140, 13141, 13142, 13143, 13144,
   13145, 13146, 13147, 13148, 13149, 13150, 13151, 13152, 13153, 13154,
   13155, 13156, 13157, 13158, 13159, 13160, 13161, 13162, 13163, 13164,
   13165, 13166, 13167, 13168, 13169, 13170, 13171, 13172, 13173, 13174,
   13175, 13176, 13177, 13178, 13179, 13180, 13181, 13182, 13183, 13184,
   13185, 13186, 13187, 13188, 13189, 13190, 13191, 13192, 13193, 13194,
   13195, 13196, 13197, 13198, 13199, 13200, 13201, 13202, 13203, 13204,
   13205, 13206, 13207, 13208, 13209, 13210, 13211, 13212, 13213, 13214,
   13215, 13216, 13217, 13218, 13219, 13220, 13221, 13222, 13223, 13224,
   13225, 13226, 13227, 13228, 13229, 13230, 13231, 13232, 13233, 13234,
   13235, 13236, 13237, 13238, 13239, 13240, 13241, 13242, 13243, 13244,
   13245, 13246, 13247, 13248, 13249, 13250, 13251, 13252, 13253, 13254,
   13255, 13256, 13257, 13258, 13259, 13260, 13261, 13262, 13263, 13264,
   13265, 13266, 13267, 13268, 13269, 13270, 13271, 13272, 13273, 13274,
   13275, 13276, 13277, 13278, 13279, 13280, 13281, 13282, 13283, 13284,
   13285, 13286, 13287, 13288, 13289, 13290, 13291, 13292, 13293, 13294,
   13295, 13296, 13297, 13298, 13299, 13300, 13301, 13302, 13303, 13304,
   13305, 13306, 13307, 13308, 13309, 13310, 13311, 13312, 13313, 13314,
   13315, 13316, 13317, 13318, 13319, 13320, 13321, 13322, 13323, 13324,
   13325, 13326, 13327, 13328, 13329, 13330, 13331, 13332, 13333, 13334,
   13335, 13336, 13337, 13338, 13339, 13340, 13341, 13342, 13343, 13344,
   13345, 13346, 13347, 13348, 13349, 13350, 13351, 13352, 13353, 13354,
   13355, 13356, 13357, 13358, 13359, 13360, 13361, 13362, 13363, 13364,
   13365, 13366, 13367, 13368, 13369, 13370, 13371, 13372, 13373, 13374,
   13375, 13376, 13377, 13378, 13379, 13380, 13381, 13382, 13383, 13384,
   13385, 13386, 13387, 13388, 13389, 13396, 13395, 13410, 13411, 13415,
   13416, 13420, 13420, 13502, 13503, 13504, 13505, 13509, 13510, 13514,
   13515, 13516, 13517, 13521, 13522, 13523, 13524, 13528, 13529, 13533,
   13575, 13594, 13605, 13618, 13632, 13647, 13666, 13693, 13706, 13733,
   13776, 13790, 13791, 13792, 13793, 13797, 13798, 13807, 13819, 13820,
   13821, 13827, 13833, 13845, 13844, 13860, 13861, 13865, 13866, 13870,
   13885, 13886, 13887, 13892, 13893, 13898, 13897, 13917, 13929, 13942,
   13941, 13975, 13976, 13980, 13981, 13985, 13986, 13987, 13988, 13990,
   13989, 14002, 14003, 14004, 14005, 14006, 14012, 14017, 14023, 14034,
   14045, 14049, 14059, 14064, 14071, 14083, 14095, 14104, 14106, 14110,
   14111, 14118, 14120, 14124, 14125, 14130, 14129, 14133, 14132, 14136,
   14135, 14139, 14138, 14141, 14142, 14143, 14144, 14145, 14146, 14147,
   14148, 14149, 14150, 14151, 14152, 14153, 14154, 14155, 14156, 14157,
   14158, 14159, 14160, 14161, 14162, 14163, 14164, 14165, 14166, 14170,
   14171, 14175, 14176, 14180, 14190, 14200, 14213, 14228, 14241, 14254,
   14266, 14271, 14279, 14284, 14291, 14291, 14292, 14292, 14295, 14322,
   14327, 14333, 14339, 14345, 14349, 14353, 14354, 14358, 14385, 14387,
   14391, 14395, 14399, 14406, 14407, 14411, 14412, 14416, 14417, 14421,
   14422, 14428, 14434, 14440, 14450, 14449, 14459, 14460, 14465, 14466,
   14467, 14472, 14473, 14474, 14478, 14479, 14483, 14495, 14504, 14514,
   14523, 14537, 14538, 14543, 14542, 14558, 14559, 14560, 14564, 14565,
   14569, 14569, 14593, 14594, 14598, 14599, 14600, 14604, 14608, 14615,
   14618, 14616, 14632, 14639, 14660, 14677, 14679, 14683, 14684, 14688,
   14689, 14697, 14698, 14699, 14700, 14706, 14712, 14722, 14724, 14726,
   14731, 14732, 14733, 14734, 14735, 14739, 14740, 14741, 14742, 14743,
   14744, 14754, 14755, 14760, 14773, 14786, 14788, 14790, 14795, 14800,
   14802, 14804, 14810, 14811, 14813, 14819, 14818, 14836, 14837, 14841,
   14846, 14854, 14854, 14879, 14880, 14885, 14886, 14888, 14890, 14908,
   14914, 14919, 14901, 14981, 14999, 15024, 15056, 15060, 15069, 15092,
   15020, 15157, 15181, 15190, 15198, 15156, 15219, 15223, 15227, 15231,
   15235, 15239, 15246, 15253, 15260, 15270, 15271, 15275, 15276, 15277,
   15281, 15282, 15287, 15289, 15288, 15294, 15295, 15299, 15306, 15316,
   15322, 15333
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM", "ANALYZE_SYM",
  "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASCII_SYM",
  "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BETWEEN_SYM", "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM",
  "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM",
  "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY", "BYTE_SYM",
  "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET",
  "CHAR_SYM", "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CREATE_SYM", "COLUMN_DELETE_SYM",
  "COLUMN_EXISTS_SYM", "COLUMN_GET_SYM", "COLUMN_LIST_SYM", "COLUMN_SYM",
  "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM", "DIRECTORY_SYM",
  "DISABLE_SYM", "DISCARD", "DISK_SYM", "DISTINCT", "DIV_SYM",
  "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM",
  "DYNAMIC_SYM", "EACH_SYM", "ELSE", "ELSEIF_SYM", "ENABLE_SYM",
  "ENCLOSED", "END", "ENDS_SYM", "END_OF_INPUT", "ENGINES_SYM",
  "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERROR_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EVENT_SYM", "EVERY_SYM",
  "EXAMINED_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM", "EXPANSION_SYM",
  "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM",
  "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM",
  "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "GE", "GENERAL", "GENERATED_SYM", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING",
  "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM",
  "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT",
  "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM",
  "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LAST_VALUE", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT",
  "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM",
  "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM",
  "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM", "ONLINE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM", "PARTIAL",
  "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD",
  "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM",
  "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM",
  "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM",
  "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM",
  "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM",
  "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN", "STRING_SYM",
  "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_STATS_SYM", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE", "WHILE_SYM",
  "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM", "WRAPPER_SYM",
  "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR", "YEAR_MONTH_SYM",
  "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION", "'|'", "'&'", "'-'", "'+'",
  "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'",
  "'}'", "';'", "'@'", "'.'", "':'", "$accept", "query", "$@1",
  "opt_end_of_input", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "$@2",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "$@3",
  "change", "$@4", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "master_file_def", "create", "$@5", "$@6", "$@7",
  "$@8", "$@9", "$@10", "server_def", "server_options_list",
  "server_option", "event_tail", "$@11", "ev_schedule_time", "$@12",
  "opt_ev_status", "ev_starts", "ev_ends", "opt_ev_on_completion",
  "ev_on_completion", "opt_ev_comment", "ev_sql_stmt", "$@13",
  "ev_sql_stmt_inner", "clear_privileges", "sp_name", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "$@14",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "$@15", "$@16",
  "sp_cursor_stmt", "$@17", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "sqlstate", "opt_value", "sp_hcond",
  "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "sp_decl_idents", "sp_opt_default", "sp_proc_stmt",
  "sp_proc_stmt_if", "$@18", "sp_proc_stmt_statement", "$@19",
  "sp_proc_stmt_return", "$@20", "sp_proc_stmt_unlabeled", "$@21",
  "sp_proc_stmt_leave", "sp_proc_stmt_iterate", "sp_proc_stmt_open",
  "sp_proc_stmt_fetch", "$@22", "sp_proc_stmt_close", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "$@23", "$@24", "$@25", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "$@26", "$@27",
  "searched_case_stmt", "$@28", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "$@29", "$@30",
  "searched_when_clause", "$@31", "$@32", "else_clause_opt",
  "sp_labeled_control", "$@33", "sp_opt_label", "sp_labeled_block", "$@34",
  "sp_unlabeled_block", "$@35", "sp_block_content", "$@36",
  "sp_unlabeled_control", "$@37", "$@38", "$@39", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "$@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "$@41", "$@42", "create3", "$@43", "$@44",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@45",
  "have_partitioning", "partition_entry", "$@46", "partition",
  "part_type_def", "$@47", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@48",
  "$@49", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@50", "part_name", "opt_part_values", "$@51", "$@52", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@53", "$@54",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@55", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@56", "$@57", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@58", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "$@59", "$@60", "$@61", "$@62", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "$@63",
  "field_def", "opt_generated_always", "vcol_opt_specifier",
  "vcol_opt_attribute", "vcol_opt_attribute_list", "vcol_attribute",
  "parse_vcol_expr", "virtual_column_func", "type", "$@64", "$@65",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "hex_num_or_string",
  "charset", "charset_name", "charset_name_or_default",
  "opt_load_data_charset", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "ascii", "unicode",
  "opt_binary", "opt_bin_mod", "opt_primary", "references", "opt_ref_list",
  "ref_list", "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@66", "$@67", "$@68", "$@69", "$@70", "$@71",
  "$@72", "ev_alter_on_schedule_completion", "opt_ev_rename_to",
  "opt_ev_sql_stmt", "ident_or_empty", "alter_commands", "$@73", "$@74",
  "$@75", "remove_partitioning", "all_or_alt_part_name_list",
  "add_partition_rule", "$@76", "add_part_extra", "reorg_partition_rule",
  "$@77", "reorg_parts_rule", "$@78", "alt_part_name_list",
  "alt_part_name_item", "alter_list", "add_column", "alter_list_item",
  "$@79", "$@80", "$@81", "opt_column", "opt_ignore", "alter_options",
  "$@82", "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@83", "$@84", "start",
  "start_transaction_opts", "slave_thread_opts", "$@85",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@86", "opt_checksum_type", "repair",
  "$@87", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@88", "binlog_base64_event", "check", "$@89",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@90", "opt_no_write_to_binlog", "rename", "$@91", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@92",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@93",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@94", "cache_keys_spec", "$@95",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@96",
  "select_part2", "$@97", "$@98", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_time_precision", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "opt_dyncol_type", "dyncol_type",
  "dyncall_create_element", "dyncall_create_list", "simple_expr",
  "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "geometry_function", "function_call_generic",
  "@99", "fulltext_options", "opt_natural_language_mode",
  "opt_query_expansion", "opt_udf_expr_list", "udf_expr_list", "udf_expr",
  "sum_expr", "$@100", "$@101", "$@102", "variable", "$@103",
  "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "$@104", "gorder_list", "in_sum_expr", "$@105",
  "cast_type", "$@106", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@107", "$@108", "$@109", "$@110", "$@111", "$@112", "$@113",
  "normal_join", "table_factor", "$@114", "select_derived_union", "$@115",
  "$@116", "select_init2_derived", "select_part2_derived", "$@117",
  "$@118", "select_derived", "$@119", "select_derived2", "$@120", "$@121",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@122",
  "$@123", "index_hints_list", "opt_index_hints_list", "$@124",
  "opt_key_definition", "$@125", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@126", "having_clause", "$@127", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@128", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@129", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@130",
  "select_var_list", "select_var_ident", "into", "$@131",
  "into_destination", "$@132", "$@133", "do", "$@134", "drop", "$@135",
  "$@136", "$@137", "table_list", "table_name", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "insert", "$@138",
  "$@139", "replace", "$@140", "$@141", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@142", "fields", "insert_values", "$@143", "$@144", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@145", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@146", "update", "$@147", "$@148", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@149", "single_multi", "$@150", "$@151", "$@152", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@153", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@154", "show_param",
  "$@155", "$@156", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@157", "$@158", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@159",
  "flush_options", "$@160", "$@161", "opt_with_read_lock",
  "flush_options_list", "flush_option", "opt_table_list",
  "optional_flush_tables_arguments", "reset", "$@162", "reset_options",
  "reset_option", "$@163", "slave_reset_options", "purge", "$@164",
  "purge_options", "purge_option", "kill", "$@165", "kill_type",
  "kill_option", "kill_expr", "use", "load", "$@166", "$@167", "$@168",
  "$@169", "data_or_xml", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_xml_rows_identified_by",
  "opt_ignore_lines", "lines_or_rows", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "load_data_set_list", "load_data_set_elem", "text_literal",
  "text_string", "param_marker", "signed_literal", "literal",
  "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "$@170", "opt_option", "option_value_list", "option_type_value",
  "$@171", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@172",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@173", "handler", "$@174", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@175",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@176", "$@177", "$@178",
  "$@179", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@180", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@181",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@182",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@183", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@184",
  "view_list_opt", "view_list", "view_select", "$@185", "view_select_aux",
  "view_check_option", "trigger_tail", "$@186", "$@187", "$@188",
  "udf_tail", "sf_tail", "$@189", "$@190", "$@191", "$@192", "$@193",
  "sp_tail", "$@194", "$@195", "$@196", "$@197", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@198", "opt_migrate", "install", "uninstall", "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   124,
      38,    45,    43,    42,    47,    37,    94,   126,    40,    41,
      44,    33,   123,   125,    59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   638,   639,   640,   639,   639,   641,   641,   642,   642,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   644,   645,   645,   646,   647,   647,   649,
     648,   650,   650,   651,   651,   652,   654,   653,   656,   655,
     657,   657,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   658,   658,   658,   658,   659,   659,   659,
     660,   661,   661,   661,   661,   663,   662,   664,   662,   665,
     662,   666,   662,   667,   662,   668,   662,   662,   662,   662,
     662,   669,   670,   670,   671,   671,   671,   671,   671,   671,
     671,   673,   672,   675,   674,   674,   676,   676,   676,   676,
     677,   677,   678,   678,   679,   679,   680,   680,   681,   681,
     683,   682,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   685,   686,   686,   687,   687,
     688,   688,   689,   689,   689,   689,   689,   689,   689,   690,
     690,   690,   691,   691,   693,   692,   694,   694,   695,   695,
     696,   696,   697,   697,   698,   698,   699,   700,   701,   701,
     702,   702,   703,   704,   704,   704,   704,   705,   705,   706,
     706,   707,   707,   709,   708,   708,   710,   708,   708,   712,
     711,   713,   713,   714,   714,   715,   716,   716,   717,   718,
     718,   719,   719,   719,   719,   719,   720,   721,   721,   722,
     722,   723,   723,   724,   724,   725,   725,   725,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     727,   728,   728,   729,   729,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   732,   731,
     734,   733,   736,   735,   738,   737,   739,   740,   741,   743,
     742,   744,   745,   745,   745,   746,   746,   748,   749,   750,
     747,   751,   751,   751,   752,   752,   754,   755,   753,   757,
     756,   758,   758,   759,   759,   761,   762,   760,   764,   765,
     763,   766,   766,   768,   767,   769,   769,   771,   770,   773,
     772,   775,   774,   776,   777,   778,   776,   779,   776,   780,
     780,   781,   781,   781,   782,   783,   784,   785,   785,   786,
     786,   787,   788,   789,   789,   791,   790,   792,   792,   792,
     793,   793,   793,   794,   795,   795,   795,   796,   796,   796,
     796,   796,   796,   796,   796,   797,   798,   798,   798,   799,
     799,   799,   799,   799,   800,   801,   801,   801,   802,   802,
     802,   802,   802,   802,   802,   803,   804,   804,   804,   805,
     805,   805,   806,   807,   808,   809,   810,   811,   811,   811,
     812,   813,   814,   815,   816,   817,   818,   819,   820,   821,
     821,   822,   822,   823,   823,   824,   824,   824,   824,   826,
     825,   827,   825,   828,   829,   828,   830,   828,   831,   832,
     832,   834,   833,   835,   837,   836,   838,   839,   840,   839,
     839,   839,   839,   839,   841,   841,   842,   842,   843,   843,
     844,   844,   845,   846,   847,   848,   849,   849,   850,   851,
     850,   852,   850,   853,   853,   854,   855,   856,   856,   857,
     857,   858,   858,   860,   859,   861,   862,   863,   862,   864,
     862,   865,   865,   866,   866,   867,   867,   869,   870,   868,
     871,   871,   872,   872,   873,   873,   874,   874,   876,   875,
     877,   878,   878,   879,   879,   880,   880,   880,   880,   880,
     880,   880,   880,   880,   882,   883,   881,   884,   884,   885,
     885,   886,   886,   887,   887,   888,   888,   889,   889,   890,
     891,   891,   892,   892,   893,   893,   894,   894,   894,   895,
     895,   895,   895,   895,   895,   895,   895,   895,   895,   895,
     895,   895,   895,   896,   895,   895,   895,   895,   895,   895,
     895,   895,   895,   895,   895,   895,   895,   895,   895,   895,
     897,   898,   899,   900,   901,   901,   901,   901,   901,   901,
     901,   902,   902,   902,   903,   903,   904,   904,   904,   904,
     905,   906,   906,   907,   907,   908,   908,   910,   909,   911,
     909,   912,   909,   913,   909,   909,   909,   914,   914,   915,
     916,   916,   917,   919,   918,   920,   920,   921,   921,   922,
     922,   922,   923,   923,   924,   924,   925,   925,   925,   926,
     927,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   928,   928,   929,   928,   930,   928,
     928,   928,   931,   931,   931,   931,   931,   931,   931,   931,
     932,   933,   933,   934,   934,   935,   935,   935,   935,   935,
     936,   936,   936,   936,   936,   937,   937,   937,   938,   938,
     938,   939,   940,   940,   941,   941,   942,   942,   942,   943,
     943,   943,   943,   944,   944,   945,   945,   946,   946,   947,
     947,   948,   948,   948,   948,   948,   948,   948,   948,   948,
     948,   948,   948,   948,   948,   948,   949,   950,   950,   951,
     951,   952,   952,   953,   953,   954,   954,   955,   955,   956,
     956,   957,   957,   958,   959,   959,   960,   960,   961,   961,
     962,   962,   962,   963,   963,   963,   964,   964,   964,   964,
     964,   964,   964,   965,   965,   966,   966,   967,   968,   968,
     969,   969,   970,   970,   970,   970,   971,   971,   971,   971,
     971,   972,   972,   972,   972,   972,   973,   974,   974,   975,
     975,   976,   976,   977,   977,   977,   978,   978,   979,   980,
     981,   982,   982,   983,   983,   984,   984,   985,   985,   986,
     986,   987,   987,   988,   988,   989,   989,   990,   990,   990,
     990,   990,   990,   991,   991,   992,   993,   993,   994,   994,
     994,   995,   995,   996,   996,   997,   997,   998,   998,   999,
     999,  1001,  1000,  1002,  1000,  1000,  1003,  1000,  1004,  1000,
    1005,  1000,  1006,  1000,  1007,  1000,  1000,  1000,  1000,  1000,
    1000,  1008,  1008,  1008,  1008,  1009,  1009,  1010,  1010,  1011,
    1011,  1012,  1012,  1012,  1012,  1012,  1012,  1012,  1012,  1012,
    1012,  1013,  1012,  1012,  1014,  1012,  1015,  1012,  1012,  1012,
    1012,  1016,  1017,  1017,  1019,  1018,  1020,  1020,  1020,  1022,
    1021,  1023,  1024,  1023,  1025,  1025,  1026,  1027,  1027,  1028,
    1029,  1029,  1029,  1030,  1029,  1031,  1032,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1033,  1033,  1034,  1034,  1036,  1035,  1037,  1037,  1038,
    1038,  1039,  1039,  1040,  1040,  1040,  1041,  1041,  1041,  1042,
    1042,  1042,  1042,  1044,  1043,  1043,  1045,  1043,  1043,  1046,
    1047,  1047,  1049,  1048,  1050,  1050,  1051,  1051,  1051,  1052,
    1052,  1053,  1053,  1055,  1054,  1056,  1056,  1056,  1058,  1057,
    1059,  1059,  1060,  1060,  1061,  1061,  1061,  1063,  1062,  1064,
    1066,  1065,  1067,  1067,  1068,  1068,  1069,  1069,  1069,  1069,
    1069,  1069,  1071,  1070,  1072,  1072,  1072,  1074,  1073,  1073,
    1075,  1075,  1076,  1076,  1077,  1079,  1078,  1080,  1080,  1081,
    1081,  1082,  1083,  1084,  1084,  1086,  1085,  1087,  1087,  1088,
    1088,  1089,  1090,  1092,  1091,  1094,  1093,  1095,  1095,  1096,
    1096,  1097,  1098,  1098,  1099,  1099,  1100,  1100,  1102,  1101,
    1104,  1105,  1103,  1106,  1106,  1106,  1106,  1106,  1107,  1107,
    1108,  1108,  1109,  1109,  1110,  1110,  1110,  1111,  1111,  1111,
    1112,  1112,  1112,  1113,  1113,  1114,  1115,  1116,  1116,  1116,
    1116,  1116,  1117,  1117,  1117,  1118,  1118,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1120,  1120,
    1120,  1120,  1120,  1120,  1121,  1121,  1121,  1121,  1121,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1123,  1123,  1124,  1124,  1125,  1125,  1126,
    1126,  1127,  1127,  1127,  1127,  1127,  1127,  1128,  1128,  1129,
    1129,  1130,  1130,  1130,  1130,  1130,  1130,  1130,  1130,  1130,
    1130,  1130,  1131,  1132,  1132,  1133,  1133,  1133,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1134,  1134,  1134,  1134,  1134,
    1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,
    1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,  1134,
    1134,  1134,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1137,  1137,
    1137,  1137,  1137,  1137,  1137,  1137,  1139,  1138,  1138,  1140,
    1140,  1141,  1141,  1142,  1142,  1143,  1143,  1144,  1144,  1145,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1147,  1148,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1149,  1146,  1151,  1150,  1152,  1152,  1152,  1153,  1153,  1154,
    1154,  1155,  1156,  1155,  1157,  1157,  1159,  1158,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1161,  1160,  1162,  1162,  1163,  1163,  1164,  1164,  1165,  1165,
    1166,  1166,  1167,  1167,  1168,  1168,  1169,  1169,  1170,  1171,
    1171,  1172,  1172,  1173,  1173,  1174,  1173,  1175,  1173,  1176,
    1173,  1173,  1177,  1173,  1178,  1173,  1173,  1179,  1173,  1180,
    1173,  1173,  1181,  1181,  1181,  1183,  1182,  1182,  1182,  1184,
    1185,  1186,  1184,  1187,  1189,  1190,  1188,  1192,  1191,  1194,
    1195,  1193,  1196,  1197,  1198,  1198,  1199,  1199,  1199,  1199,
    1200,  1200,  1202,  1201,  1203,  1201,  1204,  1204,  1205,  1206,
    1205,  1208,  1207,  1209,  1209,  1210,  1210,  1211,  1211,  1212,
    1212,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,
    1213,  1213,  1213,  1214,  1214,  1214,  1214,  1214,  1214,  1214,
    1214,  1214,  1215,  1215,  1215,  1215,  1216,  1216,  1216,  1217,
    1217,  1218,  1218,  1219,  1220,  1219,  1221,  1222,  1221,  1223,
    1223,  1224,  1224,  1225,  1225,  1226,  1226,  1226,  1227,  1228,
    1228,  1229,  1230,  1230,  1232,  1231,  1233,  1233,  1234,  1234,
    1234,  1235,  1235,  1236,  1236,  1237,  1237,  1237,  1238,  1238,
    1238,  1239,  1239,  1239,  1239,  1239,  1240,  1241,  1241,  1241,
    1241,  1242,  1242,  1242,  1243,  1243,  1243,  1243,  1243,  1243,
    1244,  1244,  1244,  1244,  1244,  1245,  1245,  1245,  1245,  1245,
    1246,  1246,  1246,  1246,  1246,  1247,  1248,  1248,  1249,  1249,
    1250,  1251,  1250,  1252,  1252,  1253,  1253,  1254,  1256,  1255,
    1257,  1257,  1258,  1258,  1260,  1259,  1262,  1263,  1261,  1261,
    1261,  1265,  1264,  1267,  1266,  1268,  1266,  1266,  1266,  1266,
    1266,  1266,  1269,  1266,  1266,  1266,  1266,  1266,  1266,  1270,
    1270,  1271,  1272,  1272,  1273,  1274,  1274,  1275,  1275,  1277,
    1278,  1276,  1280,  1281,  1279,  1282,  1282,  1282,  1282,  1283,
    1283,  1284,  1284,  1285,  1286,  1286,  1286,  1287,  1286,  1288,
    1288,  1289,  1289,  1290,  1289,  1291,  1289,  1292,  1292,  1293,
    1293,  1294,  1295,  1295,  1296,  1296,  1298,  1297,  1299,  1299,
    1300,  1300,  1301,  1301,  1302,  1303,  1302,  1305,  1306,  1304,
    1307,  1307,  1308,  1309,  1309,  1310,  1311,  1311,  1313,  1312,
    1315,  1314,  1316,  1314,  1317,  1314,  1318,  1318,  1319,  1319,
    1320,  1320,  1321,  1321,  1322,  1322,  1322,  1324,  1323,  1325,
    1325,  1326,  1326,  1327,  1327,  1328,  1328,  1328,  1328,  1328,
    1328,  1328,  1328,  1328,  1329,  1329,  1331,  1330,  1332,  1332,
    1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,
    1333,  1332,  1334,  1332,  1332,  1332,  1332,  1332,  1332,  1332,
    1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,
    1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,
    1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1332,  1335,
    1335,  1335,  1336,  1336,  1337,  1337,  1338,  1338,  1339,  1339,
    1340,  1340,  1341,  1341,  1342,  1342,  1343,  1343,  1343,  1345,
    1344,  1346,  1344,  1347,  1347,  1348,  1348,  1348,  1349,  1349,
    1349,  1351,  1350,  1353,  1354,  1352,  1352,  1355,  1355,  1356,
    1356,  1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,
    1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,
    1358,  1358,  1359,  1359,  1361,  1360,  1362,  1362,  1364,  1363,
    1363,  1363,  1365,  1365,  1367,  1366,  1368,  1369,  1369,  1371,
    1370,  1372,  1372,  1372,  1373,  1373,  1373,  1374,  1374,  1375,
    1377,  1378,  1379,  1380,  1376,  1381,  1381,  1382,  1382,  1383,
    1383,  1383,  1384,  1384,  1384,  1385,  1385,  1386,  1386,  1387,
    1387,  1387,  1387,  1388,  1388,  1389,  1389,  1390,  1390,  1391,
    1391,  1392,  1392,  1393,  1393,  1394,  1394,  1394,  1395,  1395,
    1396,  1396,  1397,  1397,  1398,  1398,  1399,  1400,  1400,  1400,
    1400,  1401,  1401,  1401,  1401,  1402,  1403,  1403,  1403,  1404,
    1404,  1404,  1404,  1404,  1404,  1404,  1404,  1404,  1404,  1404,
    1404,  1404,  1405,  1405,  1405,  1405,  1405,  1406,  1406,  1407,
    1407,  1408,  1409,  1409,  1410,  1410,  1411,  1411,  1411,  1412,
    1412,  1412,  1412,  1413,  1413,  1413,  1414,  1414,  1415,  1416,
    1416,  1417,  1418,  1419,  1420,  1420,  1421,  1421,  1422,  1422,
    1422,  1423,  1423,  1423,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,  1424,
    1424,  1424,  1424,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,  1425,
    1425,  1425,  1425,  1425,  1425,  1427,  1426,  1428,  1428,  1429,
    1429,  1431,  1430,  1432,  1432,  1432,  1432,  1433,  1433,  1434,
    1434,  1434,  1434,  1435,  1435,  1435,  1435,  1436,  1436,  1437,
    1437,  1438,  1438,  1438,  1438,  1438,  1438,  1438,  1439,  1439,
    1439,  1440,  1440,  1440,  1440,  1441,  1441,  1441,  1442,  1442,
    1442,  1442,  1442,  1444,  1443,  1445,  1445,  1446,  1446,  1447,
    1448,  1448,  1448,  1448,  1448,  1450,  1449,  1451,  1451,  1452,
    1451,  1453,  1453,  1454,  1454,  1455,  1455,  1455,  1455,  1456,
    1455,  1457,  1457,  1457,  1457,  1457,  1458,  1459,  1459,  1459,
    1459,  1459,  1460,  1461,  1461,  1461,  1461,  1462,  1462,  1463,
    1463,  1464,  1464,  1465,  1465,  1467,  1466,  1468,  1466,  1469,
    1466,  1470,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,
    1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,
    1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1471,
    1471,  1472,  1472,  1473,  1473,  1473,  1474,  1474,  1474,  1474,
    1475,  1475,  1476,  1476,  1477,  1477,  1478,  1478,  1479,  1479,
    1479,  1479,  1479,  1480,  1480,  1481,  1481,  1482,  1483,  1483,
    1483,  1483,  1483,  1484,  1484,  1485,  1485,  1486,  1486,  1487,
    1487,  1487,  1487,  1487,  1489,  1488,  1490,  1490,  1491,  1491,
    1491,  1492,  1492,  1492,  1493,  1493,  1494,  1495,  1495,  1496,
    1497,  1498,  1498,  1500,  1499,  1501,  1501,  1501,  1502,  1502,
    1504,  1503,  1505,  1505,  1506,  1506,  1506,  1507,  1507,  1508,
    1509,  1508,  1510,  1511,  1512,  1513,  1513,  1514,  1514,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1516,  1516,  1516,
    1517,  1517,  1517,  1517,  1517,  1518,  1518,  1518,  1518,  1518,
    1518,  1519,  1519,  1520,  1521,  1522,  1522,  1522,  1523,  1524,
    1524,  1524,  1525,  1525,  1525,  1527,  1526,  1528,  1528,  1529,
    1529,  1531,  1530,  1532,  1532,  1533,  1533,  1533,  1533,  1535,
    1536,  1537,  1534,  1538,  1538,  1540,  1541,  1542,  1543,  1544,
    1539,  1546,  1547,  1548,  1549,  1545,  1550,  1550,  1550,  1550,
    1550,  1550,  1551,  1551,  1551,  1552,  1552,  1553,  1553,  1553,
    1554,  1554,  1555,  1556,  1555,  1557,  1557,  1558,  1558,  1559,
    1559,  1560
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     0,     1,     3,
       1,     3,     3,     3,     3,     0,     7,     0,    12,     0,
      12,     0,    12,     0,     6,     0,     3,     4,     4,     3,
       2,    10,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     0,    13,     0,     6,     2,     0,     1,     3,     1,
       0,     2,     0,     2,     0,     1,     3,     4,     0,     2,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     1,     0,     2,
       0,     2,     2,     2,     2,     2,     3,     3,     1,     1,
       1,     2,     3,     3,     0,     4,     0,     3,     0,     1,
       3,     1,     0,     1,     3,     1,     0,     3,     0,     1,
       3,     1,     4,     0,     1,     1,     1,     0,     3,     2,
       3,     0,     3,     0,     5,     5,     0,     7,     5,     0,
       2,     1,     1,     1,     3,     1,     1,     1,     3,     0,
       1,     1,     1,     1,     2,     1,     3,     1,     1,     0,
       1,     0,     2,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     5,
       0,     2,     0,     3,     0,     2,     2,     2,     2,     0,
       6,     2,     0,     2,     1,     1,     3,     0,     0,     0,
       7,     0,     2,     2,     1,     1,     0,     0,     8,     0,
       6,     1,     2,     1,     2,     0,     0,     6,     0,     0,
       6,     0,     2,     0,     5,     0,     1,     0,     5,     0,
       2,     0,     5,     4,     0,     0,     8,     0,     7,     1,
       1,     1,     1,     1,     2,     4,     5,     0,     4,     4,
       4,     3,     3,     2,     2,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     0,
       1,     1,     1,     1,     1,     2,     3,     2,     4,     0,
       6,     0,     5,     0,     0,     5,     0,     7,     1,     0,
       1,     0,     4,     0,     0,     3,     5,     6,     0,     4,
       2,     2,     2,     2,     0,     1,     0,     3,     0,     1,
       1,     3,     1,     4,     5,     5,     0,     2,     0,     0,
       7,     0,    10,     1,     3,     1,     1,     0,     2,     0,
       3,     1,     3,     0,     6,     1,     0,     0,     5,     0,
       4,     1,     1,     1,     3,     1,     3,     0,     0,     5,
       1,     3,     1,     1,     0,     3,     1,     3,     0,     4,
       1,     0,     1,     2,     1,     3,     4,     3,     3,     3,
       3,     4,     4,     3,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     0,     6,     1,     1,     3,     4,     4,
       2,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     2,     2,     0,     8,     0,
       9,     0,     9,     0,     9,     8,     2,     0,     1,     4,
       0,     1,     2,     0,     3,     2,     8,     0,     2,     0,
       1,     1,     0,     1,     2,     1,     1,     2,     2,     4,
       3,     3,     3,     3,     1,     2,     1,     1,     3,     2,
       3,     2,     2,     1,     3,     3,     2,     3,     1,     2,
       2,     2,     1,     2,     1,     1,     1,     2,     3,     2,
       3,     2,     2,     3,     3,     3,     0,     6,     0,     6,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     2,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       1,     5,     0,     1,     2,     1,     1,     1,     1,     3,
       3,     3,     3,     0,     1,     0,     1,     0,     1,     2,
       1,     1,     2,     2,     4,     1,     3,     2,     1,     2,
       2,     2,     3,     3,     3,     3,     2,     2,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     0,     1,
       1,     2,     2,     1,     2,     2,     0,     1,     1,     1,
       3,     1,     3,     0,     1,     0,     1,     5,     0,     3,
       3,     1,     0,     2,     2,     2,     0,     3,     3,     6,
       6,     1,     1,     2,     2,     2,     1,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     0,     1,     1,     1,
       0,     1,     2,     0,     1,     0,     1,     0,     1,     1,
       2,     1,     2,     1,     2,     2,     2,     3,     2,     3,
       3,     3,     3,     1,     1,     1,     1,     3,     1,     1,
       1,     4,     2,     1,     4,     0,     1,     0,     2,     1,
       3,     0,     6,     0,     5,     7,     0,     5,     0,     5,
       0,     5,     0,     4,     0,    10,     3,     4,     3,     3,
       7,     0,     3,     1,     4,     0,     3,     0,     2,     0,
       1,     0,     2,     2,     2,     2,     1,     1,     1,     3,
       4,     0,     6,     4,     0,     5,     0,     6,     4,     3,
       1,     2,     1,     1,     0,     5,     0,     3,     2,     0,
       5,     0,     0,     6,     1,     3,     1,     1,     3,     2,
       3,     2,     4,     0,     6,     0,     0,     7,     4,     4,
       3,     3,     2,     2,     6,     5,     3,     5,     1,     1,
       1,     0,     1,     0,     1,     0,     2,     0,     1,     2,
       1,     1,     1,     0,     1,     1,     0,     2,     1,     0,
       1,     1,     1,     0,     5,     3,     0,     5,     3,     3,
       0,     3,     0,     2,     1,     3,     0,     1,     1,     0,
       2,     1,     3,     0,     5,     0,     1,     1,     0,     6,
       0,     1,     1,     2,     1,     1,     1,     0,     5,     2,
       0,     5,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     0,     5,     0,     1,     1,     0,     4,     4,
       3,     5,     1,     3,     3,     0,     6,     1,     1,     1,
       3,     2,     3,     1,     1,     0,     6,     1,     1,     1,
       3,     3,     4,     0,     6,     0,     2,     0,     4,     0,
       2,     1,     2,     4,     2,     3,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     0,     2,     4,
       3,     1,     1,     3,     4,     0,     0,     0,     2,     2,
       1,     1,     0,     2,     3,     0,     2,     3,     3,     3,
       2,     3,     4,     3,     4,     3,     4,     1,     3,     4,
       3,     3,     6,     1,     5,     6,     5,     7,     6,     8,
       5,     6,     4,     4,     5,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     5,     5,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     2,     1,     1,     1,     2,     2,     1,     1,
       2,     2,     4,     1,     3,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     3,     2,     2,     2,     2,
       3,     3,     5,     6,     4,     4,     7,     2,     6,     5,
       6,     6,     4,     4,     5,     4,     6,     2,     4,     4,
       4,    10,     6,     8,     6,     4,     4,     6,     4,     4,
       4,     6,     4,     7,     7,     7,     6,     6,     6,     6,
       3,     4,     6,     8,     2,     2,     8,     8,     6,     6,
       2,     6,     6,     8,     8,     6,     8,     6,     2,     8,
       8,     2,     2,     2,     6,     6,     6,     4,     4,     8,
       4,     4,     4,     4,     3,     8,     4,     4,     6,     4,
       4,     4,     6,     8,     6,     4,     6,     1,     6,     4,
       4,     4,     4,     4,     6,     4,     0,     5,     6,     2,
       3,     0,     4,     0,     3,     0,     1,     1,     3,     4,
       4,     5,     4,     4,     4,     5,     4,     0,     0,     7,
       4,     5,     4,     5,     4,     4,     4,     4,     4,     5,
       0,     8,     0,     3,     3,     1,     4,     0,     1,     0,
       2,     0,     0,     4,     4,     2,     0,     3,     2,     3,
       2,     1,     1,     2,     1,     2,     1,     2,     2,     2,
       0,     3,     0,     1,     1,     3,     1,     3,     1,     3,
       0,     1,     0,     2,     4,     5,     1,     1,     1,     1,
       4,     1,     3,     3,     3,     0,     6,     0,     6,     0,
       8,     4,     0,     8,     0,    10,     6,     0,     8,     0,
      10,     6,     1,     2,     2,     0,     4,     3,     5,     2,
       0,     0,     7,     1,     0,     0,     6,     0,     3,     0,
       0,     5,     0,     1,     0,     1,     0,     2,     3,     3,
       1,     1,     0,     7,     0,     7,     1,     2,     0,     0,
       2,     0,     2,     0,     1,     1,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     1,     1,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     5,     4,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     0,     2,     3,
       4,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     3,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     0,     7,     2,
       1,     0,     3,     0,     7,     0,     6,     4,     6,     4,
       4,     4,     0,     6,     4,     4,     5,     6,     4,     1,
       3,     1,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     8,     0,     0,     6,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    11,
       3,     1,     3,     3,     1,     3,     0,     1,     0,     4,
       0,     6,     0,     5,     0,     6,     1,     3,     2,     4,
       0,     2,     0,     2,     1,     1,     1,     0,     4,     0,
       1,     0,     1,     1,     3,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     0,     3,     0,     3,     2,     4,
       4,     3,     4,     4,     1,     3,     3,     6,     2,     2,
       0,     6,     0,     6,     5,     2,     1,     1,     1,     5,
       5,     2,     2,     1,     4,     3,     2,     3,     2,     2,
       1,     3,     4,     3,     3,     2,     2,     1,     1,     1,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     0,     1,     1,     0,     1,
       1,     0,     4,     0,     0,     5,     1,     0,     4,     3,
       1,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     0,     3,     0,     3,     3,     1,     0,     3,
       1,     2,     0,     1,     0,     3,     3,     2,     2,     0,
       5,     0,     1,     1,     0,     1,     1,     1,     2,     2,
       0,     0,     0,     0,    21,     1,     1,     0,     1,     0,
       1,     1,     0,     1,     1,     0,     2,     2,     1,     3,
       4,     3,     3,     0,     2,     2,     1,     3,     3,     0,
       4,     0,     3,     1,     1,     0,     3,     2,     3,     1,
       1,     2,     0,     2,     3,     1,     5,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     0,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     1,     2,     4,
       5,     4,     6,     2,     3,     3,     3,     5,     1,     3,
       3,     2,     2,     2,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     3,     3,
       1,     1,     2,     2,     2,     0,     3,     4,     3,     0,
       7,     1,     2,     1,     1,     1,     1,     1,     1,     0,
       5,     1,     1,     1,     1,     1,     3,     6,     6,     6,
       7,     5,     3,     8,     8,     8,     6,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     2,     0,
       1,     3,     1,     2,     2,     2,     1,     3,     3,     1,
       1,     3,     1,     3,     1,     1,     1,     1,     4,     5,
       4,     6,     1,     0,     3,     3,     1,     1,     0,     2,
       2,     2,     2,     0,     2,     0,     3,     2,     1,     2,
       2,     2,     2,     2,     0,     3,     0,     1,     0,     3,
       2,     0,     1,     2,     0,     1,     4,     4,     5,     2,
       3,     0,     1,     0,     4,     0,     1,     1,     0,     1,
       0,     2,     2,     1,     0,     1,     1,     2,     3,     2,
       0,     6,     3,     0,     0,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     2,     1,     2,     3,
       3,     3,     0,     3,     3,     0,     7,     0,     3,     1,
       3,     0,     3,     2,     4,     0,     3,     4,     4,     0,
       0,     0,    16,     8,     7,     0,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2,     5,     3,     3,
       3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   955,  1024,  2494,     0,     0,     0,     0,     0,     0,
    2496,   115,    64,  1668,  1783,  1784,  1581,  1607,     2,     0,
    1024,   165,     0,    76,  1609,     0,  1839,     0,     0,  1024,
       0,   444,     0,  1834,     0,     0,  1024,  1612,  1824,   239,
     165,  2496,     0,  1070,  2317,  1706,     0,     0,     0,     0,
    1689,     0,  2375,  1657,     0,     0,  2631,     0,     0,     3,
       8,    19,     0,    40,    24,    28,    14,    18,    13,    53,
      47,    38,    37,    10,    55,    56,    16,    44,    11,    12,
      15,    36,    43,    32,    39,    51,  1061,    22,    23,    29,
      45,    60,    20,    57,    54,    21,  1785,    25,    46,    41,
      33,    61,    34,    52,    35,    59,    27,    48,    26,     9,
      17,    49,    50,    42,    62,    30,    58,    31,     0,   889,
       0,     0,     0,     0,     0,     0,     0,   957,   872,  2561,
    2562,  2563,  1026,  1025,     0,  2496,  1951,  1009,  1035,  2023,
    2024,  2025,  2026,  2027,  2028,  2029,  2030,  1965,  2031,  2032,
    2034,  2033,  2035,  2036,  1966,  1967,  2037,  2038,  2039,  2041,
    2040,  2042,  1968,  1969,  2043,  2044,  2045,  2046,  1970,  1972,
    1971,  2047,  2050,  2049,  2048,  1973,  2051,  2052,  2053,  2055,
    1974,  1975,  1976,  1977,  1978,  1979,  2054,  1980,  2056,  1981,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2065,  2064,  1982,
    2066,  2067,  2068,  2069,  2070,  2072,  2071,  2073,  2074,  2075,
    1983,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  1984,  2083,
    2084,  2085,  2102,  1985,  2086,  2089,  2088,  2087,  2090,  2091,
    2092,  2094,  2093,  2095,  1986,  1987,  2096,  2097,  2098,  2100,
    2099,  2104,  2105,  2106,  1988,  2101,  2103,  2293,  2107,  2108,
    2110,  2109,  2111,  2113,  2112,  1989,  2115,  2114,  1990,  1991,
    2116,  2117,  1949,  2118,  1950,  2119,  2122,  2123,  2120,  2124,
    2129,  1992,  2121,  2125,  2126,  2127,  2128,  2130,  1993,  2132,
    2131,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2152,  2145,  2147,  2148,  2150,  2146,  2151,  2155,  2154,  2156,
    2157,  2158,  2153,  2143,  2149,  2144,  2159,  2160,  2142,  2161,
    2162,  2163,  2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,
    2173,  2172,  2174,  2175,  2176,  2177,  2178,  2179,  2181,  2180,
    2182,  2183,  2184,  2186,  2185,  2188,  2189,  1994,  2187,  2190,
    2191,  2192,  2193,  2194,  2195,  1995,  1997,  1996,  1998,  2196,
    2197,  1999,  2198,  2199,  2200,  2000,  2201,  2202,  2203,  2205,
    2204,  2206,  2207,  2001,  2002,  2208,  2209,  2210,  2211,  2212,
    2213,  2214,  2215,  2216,  2217,  2218,  2219,  2220,  2221,  2223,
    2222,  2224,  2225,  2226,  2227,  2228,  2229,  2230,  2003,  2231,
    2004,  2232,  2233,  2005,  2234,  2006,  2235,  2236,  2007,  2237,
    2238,  2239,  2240,  2241,  2242,  2008,  2243,  2244,  2245,  2009,
    2247,  2246,  2248,  2010,  2250,  2251,  2011,  2249,  2013,  2252,
    2253,  2012,  2254,  2014,  2255,  2256,  2258,  2257,  2259,  2260,
    2261,  2015,  2262,  2016,  2263,  2264,  2265,  2266,  2267,  2269,
    2268,  2270,  2271,  2272,  2273,  2276,  2278,  2275,  2277,  2274,
    2279,  2280,  2281,  2282,  2286,  2287,  2288,  2289,  2283,  2284,
    2285,  2017,  2290,  2291,  2292,  2294,  2295,  2297,  2296,  2018,
    2019,  2298,  2299,  2022,  2300,  2301,  2302,  2306,  2303,  2314,
    2304,  2305,  2308,  2307,  2309,  2310,  2020,  2311,  2021,  2312,
    2313,   184,  1954,   167,  1955,  1964,     0,  2366,  2365,   993,
    1010,  2497,  2498,   540,   818,     0,     0,   819,     0,   539,
     817,   165,  2563,   120,     0,   536,   537,     0,     0,     0,
    1682,     0,  1605,  1605,  1605,     0,     0,  1605,  1605,     0,
    1608,  1605,   165,  1605,     0,    69,  1791,     0,     0,     0,
       0,  1948,     0,  1615,     0,     0,  1841,  1855,     0,  1856,
    1850,  2363,     0,  1095,     0,     0,     0,     0,   165,  1027,
       0,  1666,     0,   229,   238,   240,   241,   237,     0,  2498,
    2509,  1062,  1068,  1080,  2318,  2315,  1768,   241,   982,   982,
     982,   980,   982,  1690,  1687,     0,     0,     0,  1666,  1849,
    2615,     0,     0,     0,  2611,     0,  2616,     0,  1070,     0,
       0,     1,     5,     0,     0,  2097,  2200,  1781,  1779,  1943,
       0,   863,   890,     0,   868,     0,   866,  1960,  1959,  1958,
       0,   879,   878,   876,     0,   405,     0,   961,   962,   956,
     958,   960,     0,  2572,   870,  1007,  2495,     0,   186,     0,
      78,     0,     0,     0,  2501,     0,     0,     0,     0,   119,
       0,     0,     0,   116,  1095,  1095,  2563,  2565,  2567,   540,
     538,     0,     0,     0,  1686,  1685,  1684,     0,  1682,  2024,
    1965,  2036,     0,  1916,     0,     0,     0,  1370,     0,  1970,
       0,  2051,  2053,  1974,  1975,  1976,  1977,  1978,  1979,  1982,
       0,     0,  1105,  1105,  1102,     0,     0,     0,  2074,  2075,
    1925,     0,     0,     0,  1912,  1926,  2110,  2111,     0,  1914,
    1915,  2117,     0,     0,     0,  2131,     0,  2136,  1923,     0,
       0,  2168,  2170,     0,     0,  2174,  2175,  2176,  2177,  1898,
    1160,     0,  1102,  1911,  1922,  2192,  1905,  2201,  2206,  2207,
       0,  2216,     0,     0,     0,  2241,  2245,     0,     0,  2266,
       0,     0,  1102,  1897,  2286,  2287,  2288,  2289,     0,  1913,
    2017,  1924,     0,  2300,  1105,  1102,  1102,     0,     0,     0,
    2309,  2313,     0,     0,     0,  2533,  1159,     0,  1332,     0,
    1364,  1117,  1123,  1137,     0,  1152,  1186,  1187,  1189,  1287,
    1188,  1194,  1193,  1582,  1909,  1192,  1191,  1910,  1185,  1933,
    1954,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
    1764,     0,     0,  1592,  1605,    71,     0,  2411,  2426,  2427,
    2423,  2428,  2446,  2429,  2433,     0,  2425,  2417,     0,  2432,
       0,  2421,  2430,     0,  2415,     0,  2431,  2436,  2447,  2419,
    2424,  2402,     0,  2409,  2413,  1945,  1476,  2378,  2379,     0,
      77,  1617,  1618,  1616,   953,     0,  2628,  1842,  1843,  1844,
       0,  1859,     0,  1022,     0,     0,   454,   445,     0,  1763,
    1762,     0,  1835,  2510,     0,     0,   998,  1620,  1667,     0,
    1619,  1830,     0,  1828,  1825,  1827,   230,     0,     0,   260,
    2411,     0,  2396,     0,  2504,  2501,  2511,  2546,  2541,  2540,
    2543,  2544,  1086,  2545,  1085,  2542,  2539,  1095,  1081,  1083,
    1084,  2321,  1726,     0,   752,     0,  1747,  1776,  1727,     0,
       0,  1776,     0,  1511,  1766,  1769,     0,  2330,  1740,   815,
     814,  1750,   813,  2331,  1762,     0,  1714,  1728,     0,  1691,
    1733,     0,  2332,     0,  1765,  1749,     0,  1748,  1511,  1776,
       0,  1707,     0,     0,     0,     0,   236,   976,   986,   978,
     973,     0,   979,   975,     0,  2629,  2630,  2376,   953,  1904,
    1902,  1903,  1952,  2612,  1901,  2620,  2622,  2608,  2610,  2617,
    1064,     0,  2515,     6,    63,     0,  1788,  2570,  2571,  2569,
     768,     0,  1105,  1961,  2564,   168,   877,     0,   406,   168,
       0,     0,     0,     0,     0,   407,   408,   344,   861,   959,
     874,     0,     0,   873,  2572,     0,     0,  1037,  1039,  1038,
    1055,   188,   185,   166,     0,   995,  1599,  1601,  1012,  2500,
       0,     0,  2502,  2506,  1158,  1157,     0,   113,   118,     0,
       0,     0,  2472,   117,  2462,  2568,  1095,  1095,  1095,  2560,
       0,  2548,  2555,  2556,  2559,  2558,  2557,  2554,     0,  2547,
    2550,  2551,  2553,  2552,  2572,  2566,     0,   820,   820,   820,
       0,  1669,  1672,  1676,  1680,  1683,     0,     0,  1481,  1207,
    1481,  1481,  1481,  1371,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1481,     0,
    1244,  1217,     0,  1245,     0,     0,     0,     0,     0,  1919,
       0,     0,  2533,     0,     0,     0,  1337,     0,     0,     0,
    2533,     0,     0,     0,     0,     0,     0,  1366,  1368,  1932,
    1481,     0,     0,  1481,     0,     0,     0,     0,     0,  1110,
    1250,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1481,  1481,     0,     0,  1481,  1258,     0,  1921,
       0,     0,     0,  1920,     0,     0,  1918,   749,   750,  1899,
    1917,     0,  1261,  1263,  1262,     0,  1481,  1481,     0,     0,
    1197,  1196,  1198,     0,     0,     0,     0,     0,     0,  1156,
    1155,  1154,  1153,     0,     0,     0,  1161,     0,  1162,  1163,
       0,  1164,  1165,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1199,     0,     0,     0,  1900,  1296,     0,
    1606,  1587,  1594,  1589,     0,  1764,  1590,  1598,   419,     0,
    1595,  2460,  1591,     0,  1583,     0,    70,     0,  1813,  1818,
       0,     0,     0,  1808,  1816,  1810,  1817,  1809,     0,     0,
    1819,  1812,     0,  1811,  1815,  1814,  1792,  1796,  1800,  1793,
    2412,  2410,  2444,  2443,  2448,     0,  2445,  2441,  2434,  2473,
    2438,     0,  2473,  2440,  2439,  2473,  2435,  2442,  2473,  2407,
       0,  1477,  1478,     0,  2377,     0,  1944,   954,     0,     0,
    1845,  1846,     0,  1045,  1860,  1861,  1857,  1476,  2364,  2367,
       0,   639,  1096,   455,     0,     0,   466,     0,     0,    66,
      67,     0,  1029,     0,  1028,  1032,     0,     0,     0,  1623,
    1613,  1622,  1831,  1832,     0,   228,   253,   248,   256,   250,
     252,   251,   257,   258,   259,   254,   249,   255,   242,     0,
    2410,     0,  2407,  2505,     0,  2507,  2524,  1069,  2512,  1092,
    1071,  1091,     0,  1082,  2316,  2319,  2327,  1772,   751,     0,
       0,  1739,     0,   540,     0,     0,     0,     0,     0,     0,
    1708,     0,     0,   583,     0,  1732,  1512,  1770,  1771,  1776,
       0,     0,  1776,     0,  1745,  1766,     0,  1776,  1703,     0,
       0,  1695,  1700,  1696,     0,  1702,  1701,  1704,  1692,  1693,
    1772,  1719,  1746,  1766,  1731,  1738,     0,  1718,  1725,     0,
    1736,  1766,  1766,  1776,  1776,   989,   988,   987,   983,   984,
     989,     0,  1688,  1405,     0,     0,  2609,  2623,  2607,  2618,
    2619,  2606,  1065,  2516,  1063,  2517,     0,     7,     4,  1782,
    1780,  1789,  1790,   769,   768,   531,   534,   533,     0,     0,
    1963,     0,   869,     0,  1764,   867,     0,     0,  1764,   355,
    1764,   409,   768,   881,     0,     0,   871,  1008,     0,     0,
     443,  1055,  1041,  1057,     0,   189,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    79,    80,    96,   997,   996,
       0,   994,  1020,  1019,  1017,     0,  1018,  1016,  1011,  1013,
    1014,  2499,  2503,   541,   768,  1764,     0,   347,     0,     0,
       0,     0,     0,   540,     0,     0,  2549,   105,   821,     0,
       0,     0,  1674,  1602,  1670,  1604,  1943,     0,     0,     0,
    1678,     0,     0,  1482,  1481,     0,  1346,     0,     0,     0,
       0,  1372,     0,     0,     0,     0,     0,     0,     0,  1183,
       0,     0,     0,     0,     0,     0,     0,  1317,     0,  1346,
    1106,  1556,  1557,  1541,  1542,  1540,  1543,  1103,     0,  1544,
    1555,  1274,     0,     0,     0,     0,     0,     0,  1452,  1453,
    1454,  1455,  1463,  1456,  1457,  1458,  1465,  1470,  1459,  1460,
    1466,  1467,  1468,  1461,  1469,  1464,  1462,  1471,     0,  1451,
       0,  1474,  1472,  1475,  1473,     0,  1338,  1330,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1481,     0,     0,     0,  1481,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1481,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1240,     0,  1935,
    1934,     0,     0,     0,     0,  1201,     0,  1200,  1414,     0,
    2518,  2534,     0,  2333,  1333,  1335,     0,  1108,  1107,  1109,
    1120,  1113,  1118,  1111,  1115,     0,  1167,  2030,  1121,     0,
       0,  1149,  2533,  1490,  1150,  1135,  1140,  1141,     0,  1138,
    1139,     0,  1143,     0,  1142,  1146,  1147,  1148,  1151,     0,
       0,     0,     0,  1190,  1195,  1365,  1095,  1936,     0,  1585,
     419,   422,   421,  1596,   420,  1644,     0,   963,     0,     0,
      72,    74,  1805,  1802,  1801,  1803,  1807,  1806,  1804,     0,
    1820,  2437,     0,  2418,     0,  2422,  2416,  2420,     0,     0,
    2408,     0,  2414,  1480,  2105,  2185,     0,  1483,  2381,  1610,
    2627,  2300,  1847,  1840,     0,  1858,     0,     0,     0,  1023,
     640,     0,  1095,   453,   452,   451,   450,     0,   468,   448,
     456,    68,     0,     0,  1836,     0,     0,     0,     0,  1000,
    1621,     0,  1833,  1829,  1826,     0,     0,     0,     0,     0,
       0,     0,  2508,  2526,  2525,  2513,  1095,  1502,  1096,  1096,
    1932,  2321,  2324,  2325,  2328,  2326,     0,  2323,  2322,  2337,
       0,  1774,  1777,  1778,     0,     0,  1758,  1752,  1751,  1743,
    1753,  1744,  1761,  1760,  1759,  1716,  1715,  1524,  1525,  2239,
    1523,  1515,  1518,  1522,  1521,  1711,  1767,  1757,  1755,  1741,
    1776,  1756,  1754,  1697,  1698,  1699,     0,  1511,     0,  1774,
    1776,  1766,     0,  1776,  1776,  1735,  1737,     0,   977,   986,
     974,   981,  1423,  1422,     0,  1379,     0,  1381,  1378,  1377,
    1376,     0,  1422,  2613,  2621,  2625,     0,  1511,  2523,  2521,
     532,  1644,  1644,     0,  1962,     0,     0,     0,     0,     0,
       0,     0,   169,   178,     0,     0,   353,   354,  1644,   352,
     395,   396,   399,   400,   401,     0,     0,     0,     0,     0,
       0,     0,     0,   122,   402,  1644,  1644,   349,   375,   376,
     379,   380,   381,   382,   383,   345,     0,   350,   951,   951,
       0,  1644,  1644,   951,  1644,     0,     0,  1644,  1644,     0,
       0,  1644,     0,     0,   951,     0,  1644,   949,     0,     0,
    1644,  1644,  1644,  1644,   951,     0,     0,  1644,  1644,   443,
    1644,     0,     0,   969,     0,     0,  1644,     0,     0,  1644,
    1644,     0,  1644,   897,   948,   544,   565,   566,   862,   896,
     898,   910,   439,     0,   927,   950,     0,     0,   883,   885,
    2573,  2574,  2575,  1044,  1036,  1043,  1040,  1055,  1053,  1042,
     810,   809,     0,  1056,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1600,  1021,  1015,   114,   768,
    1644,  1644,  1644,  1644,   351,   384,   385,   388,   389,   390,
     391,   394,   392,   393,     0,     0,  1764,     0,  2464,  2465,
       0,  2463,     0,  2601,     0,     0,     0,   167,   542,     0,
       0,   822,     0,     0,     0,     0,     0,  1483,     0,  1946,
    1677,  1405,  1681,  1680,     0,  1270,     0,  1310,     0,  1312,
    1313,  1314,     0,     0,     0,     0,     0,  1271,     0,  1215,
    1272,  1273,     0,     0,  1268,     0,     0,     0,     0,  1267,
       0,     0,     0,     0,  1316,     0,  1104,     0,     0,  1218,
    1219,  1212,  1204,     0,  1289,     0,     0,  1220,     0,     0,
       0,     0,  1276,     0,  1290,  1367,     0,  1369,  1936,     0,
    1322,  1277,  1225,     0,  1320,     0,  1226,  1291,  1292,  1293,
    1279,  1280,     0,  1295,     0,  1281,     0,     0,     0,     0,
    1228,  1326,  1324,     0,     0,     0,     0,  1328,  1230,     0,
       0,     0,  1229,     0,     0,     0,     0,     0,     0,     0,
    1232,     0,  1213,  1325,  1327,  1285,     0,  1241,     0,  2527,
    1413,  2535,  1414,     0,     0,  2529,  2519,  2524,  2532,  1205,
       0,     0,     0,     0,     0,  1937,  1114,  1119,  1112,  1116,
    2533,     0,     0,     0,     0,  1133,  1132,     0,     0,     0,
    2533,  1490,  1136,     0,     0,  1306,  1307,  1362,     0,  1588,
    1586,  1597,  1642,  1643,  1645,     0,  2461,   965,   964,  1593,
     963,    75,     0,  1799,  1821,  1794,  2477,     0,  2476,     0,
    2456,  2459,  1943,     0,     0,     0,  2391,  2385,  2392,  2394,
    2388,  2393,  2395,  2386,  2387,  2382,  2389,  1484,  1513,     0,
    1848,  1046,  1048,  1049,  1047,  1055,     0,     0,  2370,  2371,
    2369,  2368,   458,     0,   467,     0,   479,     0,     0,     0,
    1838,  1837,     0,  1030,  1033,  1034,  1005,  1004,  1006,   999,
    1001,  1002,   524,  1627,     0,     0,     0,  1633,  1614,  1624,
       0,  2074,  2286,  2289,   243,   246,   245,   247,     0,     0,
       0,     0,     0,     0,  1090,  1405,  1574,  1087,  1075,  1513,
    1503,  1074,  1097,  1093,     0,  2320,     0,  2283,  2348,     0,
       0,     0,     0,     0,  2338,  1773,     0,  1720,     0,  1742,
       0,     0,     0,     0,  1713,     0,  1734,  1694,  1722,  1712,
    1483,  1766,  1709,  1710,   991,   990,   985,  1422,  1405,     0,
       0,  1402,  1424,     0,  1424,  1405,  1405,     0,  1405,  1476,
    1419,     0,     0,  2624,  1504,  2522,     0,     0,   865,   172,
     175,   173,     0,   174,     0,     0,   404,   403,     0,  1764,
     397,   126,   125,   127,   128,  1538,  1539,  1535,  1536,  1534,
    1537,   130,   129,   124,   880,     0,     0,     0,  1764,   377,
     356,   357,   360,   361,   362,   952,   855,  1024,   931,     0,
     621,   855,   806,   811,   811,   929,     0,  1024,     0,     0,
       0,     0,     0,  1024,     0,     0,     0,  1644,     0,   942,
     892,     0,     0,     0,     0,     0,   943,     0,   893,  1644,
       0,     0,     0,     0,     0,  1024,     0,     0,     0,   441,
       0,  1024,   911,   972,   971,   970,     0,  1024,  1024,     0,
     571,   572,   570,     0,     0,     0,   563,   545,   768,   894,
     440,   895,   620,     0,   966,   617,   623,  1939,     0,     0,
       0,     0,   136,  2577,     0,  1443,   190,    97,    86,    82,
     101,  1548,  1549,  1547,  1545,  1546,   102,    84,    85,    89,
      88,    90,    91,    92,    87,    93,    83,    94,   103,   104,
      81,     0,     0,     0,     0,  1764,   386,     0,     0,  1644,
     346,   363,   364,   367,   368,   369,   370,   371,   374,   372,
     373,     0,  2468,  2470,     0,     0,   340,   339,     0,   131,
    2595,     0,     0,   620,   106,   439,   543,   546,   848,   850,
     849,   836,   835,   107,   109,   111,  1603,  1680,  1405,  1502,
    1944,  1483,     0,  1679,     0,     0,  1311,  1347,     0,  1373,
       0,  1209,   723,   723,   723,  1356,   708,  1360,  1351,   723,
    1352,   723,  1354,     0,   754,     0,   753,     0,  1169,  1184,
       0,     0,     0,     0,     0,     0,  1318,  1315,     0,     0,
       0,     0,  1341,     0,     0,     0,  1214,     0,  1301,  1323,
    1321,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1202,  1095,  2536,  2538,  1066,
       0,  2528,  2530,  2334,  2335,  2336,   857,  1334,     0,  1130,
    1126,     0,  1124,  1489,  1145,  1144,     0,     0,     0,  1134,
    1096,  1297,  1095,     0,  1363,  1938,   418,   582,  1584,    73,
    1797,  2474,     0,  2485,     0,     0,     0,     0,     0,     0,
       0,  2380,  1514,  1654,     0,  1055,  1059,  1953,  1851,  2373,
    2374,  2372,     0,   459,   460,   462,  1096,   476,   454,     0,
     446,   449,     0,   458,     0,  1003,  1080,     0,  1646,  1631,
    1638,  1632,     0,     0,     0,  1630,  1928,  1927,  1934,  2511,
       0,     0,  2401,     0,     0,     0,  2514,  1483,  1483,  1568,
       0,     0,  1072,  1077,  1073,  1076,     0,  1094,  1101,  1100,
    1929,  1936,     0,     0,     0,     0,   756,   755,   764,     0,
       0,     0,  2333,     0,   760,   762,   761,  2343,   759,  1775,
    1511,  1730,  1729,  1526,  1517,     0,  1520,  1519,  1705,  1511,
    1724,  1776,     0,     0,  2518,  1417,     0,  1404,  1403,  1425,
       0,  1405,  1424,  1424,     0,  1384,  1383,  1658,  1661,     0,
    1382,  1441,  1407,  1080,  2614,  2626,     0,   767,   766,   581,
     763,   580,   177,   176,   182,   183,   424,   410,   423,   398,
     123,   411,   412,   378,     0,   358,   622,   856,   914,     0,
       0,     0,   811,   616,   855,   820,   812,   855,   855,     0,
       0,   555,   552,   933,   558,   912,   904,   913,   924,   926,
       0,   554,   573,     0,     0,   561,   855,   899,   940,   941,
     963,   549,     0,   592,   593,   591,   567,   574,   550,   551,
     935,     0,  1498,  1500,  1508,   557,   556,  1559,  1558,   560,
       0,   553,     0,   946,   919,     0,   589,   587,   584,   586,
     585,   590,   588,   562,   559,   575,   909,     0,   951,   951,
     928,     0,   600,   601,   603,   604,  1942,     0,   968,   930,
       0,   605,   618,   606,     0,     0,   579,  1552,  1553,  1550,
    1551,   578,  1554,   576,   577,     0,   146,     0,     0,   882,
       0,   139,   137,   148,     0,     0,     0,  1446,     0,  1447,
    1444,  1445,     0,    98,   100,   417,   416,   415,   414,   387,
       0,     0,     0,  1764,   365,  2469,  2467,  2466,     0,     0,
    2602,   343,   341,   342,     0,     0,   192,   598,   599,   597,
     596,     0,   427,     0,  2000,   425,     0,   438,     0,  1862,
     768,   547,     0,     0,     0,     0,  1483,  1527,  1947,  1673,
       0,  1242,  1374,     0,     0,   724,  1348,   776,  1358,     0,
    1359,   710,   709,   725,  1350,  1353,  1357,  1355,  1208,  1216,
    1264,     0,  1182,  1265,  1266,     0,  1288,  1211,  1210,     0,
       0,     0,  1248,  1249,     0,  1339,     0,     0,  1222,     0,
    1224,     0,     0,  1303,  1278,  1294,  1251,  1282,     0,  1227,
    1203,     0,  1252,     0,  1257,  1255,     0,  1231,     0,     0,
    1238,     0,  1236,     0,  1237,     0,  1239,  1284,  1286,  1415,
    2537,  1067,     0,     0,  1336,  1122,     0,  1131,  1128,     0,
    1125,  1097,  1308,  1298,     0,  1795,  2475,     0,  2406,  2458,
    2457,  2478,  2478,  2478,     0,  1485,     0,  1611,  1050,  1055,
    1059,     0,  1051,  1862,   463,     0,     0,     0,   483,     0,
     481,   457,     0,  1031,  1095,  1628,  1640,     0,  1648,     0,
       0,  1625,  1635,     0,     0,     0,  1634,   244,     0,  2398,
    2399,  2397,  1513,  1491,     0,     0,  1580,     0,  1575,  1088,
       0,  1099,  1098,     0,  2350,     0,  2349,  2361,  2362,  2359,
    2360,  2358,  2339,     0,  2345,  2344,     0,     0,     0,  2355,
    2346,     0,     0,  1721,  1516,  1723,  1717,   992,  2524,  1476,
    1409,  1405,  1380,  1405,  1391,     0,     0,  1405,  1387,  1385,
    1389,     0,  1483,     0,  1406,  1438,  1095,  1931,  1505,  1508,
     359,   916,     0,   855,   807,   808,   820,     0,   820,   820,
       0,     0,   903,     0,  1012,     0,   908,   764,   568,   939,
     938,   569,     0,   901,     0,  1509,  1510,  1501,   442,   900,
     921,   906,  1820,   932,   620,   967,   788,   704,   653,   644,
     723,   647,   646,   690,   723,   658,   708,   706,   676,   708,
     708,   683,   682,   700,   686,   666,   776,   776,   665,   703,
     776,   687,   685,   689,     0,   691,   708,   696,   684,   688,
     705,   681,   678,   702,   723,   723,   723,   662,   701,   776,
       0,   694,   723,   624,   727,   664,   776,   783,     0,     0,
     723,   725,  1941,   147,   135,     0,     0,   884,   886,     0,
       0,   887,  2579,     0,  2581,     0,  1058,     0,    95,     0,
       0,   348,   413,   366,  2471,     0,   203,  1095,     0,     0,
     193,   195,   196,     0,     0,     0,   429,  1864,  1863,   426,
     527,   548,     0,     0,     0,  1680,  1675,     0,  1671,     0,
    1375,     0,     0,     0,     0,   770,   781,   779,   773,     0,
     777,   778,  1349,     0,     0,   726,  1361,   723,  1179,   708,
    1173,  1175,  1171,     0,   691,  1174,   723,     0,   776,  1178,
    1170,     0,  1319,     0,     0,  1342,     0,     0,     0,     0,
       0,     0,     0,  1206,     0,  1299,     0,     0,     0,     0,
       0,     0,  1235,  1233,  1234,  1513,  2518,   858,  1127,     0,
    1309,     0,     0,     0,  2483,  2483,  2483,  1653,  1652,     0,
    1651,  1655,  1052,  1060,     0,   461,   464,     0,   456,     0,
     480,     0,   447,   525,     0,     0,     0,  1649,  1637,  2515,
    1626,  1629,  1936,  2400,  1079,     0,  1486,  1579,  1576,     0,
    1569,  1571,  1573,     0,  1930,     0,     0,  2354,  2340,   765,
       0,     0,     0,     0,  2341,  1410,  1408,  1418,     0,  1376,
    1405,  1405,     0,  1376,     0,     0,     0,  1660,  1502,  1662,
    1442,     0,  1420,     0,  1507,     0,     0,   915,     0,     0,
       0,     0,     0,     0,   945,     0,   966,   905,   925,   947,
     936,  1024,  1499,   920,   922,  1000,     0,   602,     0,   792,
     652,   645,   663,   661,   712,   707,     0,   712,   712,   672,
     690,   667,     0,   776,   680,   671,   692,   695,   697,   699,
     712,     0,   776,   660,   659,   669,   656,   712,   735,     0,
       0,     0,     0,   731,     0,   786,     0,   738,     0,   625,
     728,   730,     0,     0,     0,   693,   776,   649,   784,   783,
     651,   776,   783,   712,   712,     0,   133,   138,   149,   150,
     875,  2578,     0,  2576,     0,  1054,  1448,    99,     0,     0,
     206,   204,   205,     0,   199,   201,   196,  2589,     0,  2596,
       0,     0,  2594,   428,   431,   542,   528,     0,     0,  1508,
     853,     0,     0,  2239,  1528,  1243,   721,   719,   722,   720,
     772,   771,   775,     0,   774,   783,     0,     0,  1181,  1176,
     692,  1180,  1172,  1177,  1269,  1246,  1247,     0,  1340,  1331,
    1275,     0,  1223,  1300,     0,     0,  1283,  1253,  1256,  1254,
    1259,  1260,  1087,  1087,   594,  2531,  1129,  1822,  2486,     0,
       0,  2482,  2480,     0,  2481,  2479,  2449,     0,  2404,  2405,
    2403,  2390,     0,     0,     0,  1095,   469,     0,   486,   485,
     482,  1513,  1639,  1641,  1647,  1636,     0,  1487,  1502,   757,
    1572,     0,  1089,  2352,  2351,  2353,  2347,     0,     0,     0,
       0,  1392,     0,  1396,  1401,  1397,     0,  1388,  1386,     0,
    1527,  1430,  1431,     0,     0,  1436,  1440,  1513,  1508,   918,
       0,   619,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   944,  1906,   934,   966,   902,     0,   907,   564,
       0,   791,     0,   796,   716,   717,   718,   673,   713,   715,
       0,   675,   643,   668,   698,   674,     0,   670,   657,   741,
     740,  1105,   733,   748,   628,     0,     0,   739,     0,   729,
     737,   732,     0,   648,   650,   654,   655,   641,   642,  1940,
     140,   888,   280,  2580,  1070,     0,  2585,   121,  2593,  2603,
     203,     0,     0,   144,     0,   194,   764,   197,  2515,   439,
       0,   434,   823,     0,   852,     0,   825,   827,  1529,     0,
     782,   780,     0,  1343,  1508,     0,  1302,  1304,  1416,   595,
       0,  1798,  2455,  2454,  2453,  2450,     0,     0,     0,     0,
       0,     0,  2484,  2488,  1650,     0,     0,     0,   477,     0,
       0,   511,   526,  1495,  1508,     0,  1513,     0,  1577,  1570,
    2357,  2356,  2342,  1411,     0,     0,     0,     0,     0,  1449,
    1659,  1426,  1426,  1437,  1421,  1506,   917,     0,     0,   607,
       0,     0,  1908,  1907,   937,     0,   789,     0,   793,   794,
     795,     0,   787,   714,     0,   859,     0,   747,  1105,   736,
    1095,   745,   744,   742,   743,     0,   142,   306,     0,   292,
     278,     0,     0,     0,   282,   151,   154,   152,     0,   153,
     159,     0,   160,   161,   162,   163,   164,   155,   304,   305,
     158,   156,   157,     0,  1956,     0,  1957,  2583,     0,     0,
    2582,   170,   200,     0,     0,   136,   145,  2597,   746,   432,
    1862,     0,  2511,     0,  1644,   108,   824,   844,   843,   829,
       0,  1508,     0,     0,   110,   826,   846,   833,   112,   828,
     845,   831,  1530,   711,     0,  1345,  1221,     0,  2451,  2489,
    2492,  2490,  2491,  1531,     0,  2493,  2487,     0,  1852,  1096,
       0,   470,     0,   473,   475,   489,     0,  1644,  1644,     0,
       0,  1644,  1644,  1644,  1644,   504,   512,   514,     0,  1496,
    1497,     0,  1492,  1494,  1488,  1560,   758,  1865,  2518,  1393,
       0,  1398,     0,  1390,     0,     0,  1434,  1432,     0,   613,
     823,   609,   611,     0,   790,     0,     0,   776,     0,   776,
     734,     0,   141,     0,   134,     0,     0,   291,   294,     0,
       0,   297,   287,   286,   288,     0,   281,   280,   280,   334,
     285,   331,   330,   323,  2515,     0,     0,     0,  2604,   202,
    1095,   148,     0,   430,   436,   435,   838,     0,   830,     0,
     851,   854,     0,   834,   832,  1508,  1823,  1533,  1532,  1656,
    1664,     0,   757,     0,   478,   471,     0,     0,   487,     0,
       0,  1644,  1644,     0,     0,     0,     0,     0,   484,   513,
    1644,  1508,     0,  1078,     0,  1873,  1412,     0,     0,  1450,
       0,  1427,     0,     0,     0,   615,   823,   608,   825,   827,
       0,   802,     0,   801,     0,   798,   797,   677,   860,   679,
     629,   143,   307,   318,   321,   313,   293,     0,     0,     0,
     283,   280,     0,   267,   265,   266,   272,   273,   274,   275,
     276,   277,   268,   271,   269,   270,   280,     0,   211,     0,
       0,  2584,     0,  2586,     0,   180,   179,   171,     0,   280,
    2590,     0,  2598,  2515,   837,   842,   841,   839,   840,   847,
    1344,     0,     0,  1853,   465,   477,   474,   497,   490,   493,
       0,   523,   517,     0,     0,   519,   520,   518,   515,   508,
       0,   506,     0,  1493,  1561,     0,     0,     0,     0,  1866,
    1868,     0,  1578,  1395,  1400,  1429,  1428,  1443,     0,   614,
     610,   612,   923,   804,   805,   803,     0,     0,   631,   630,
     632,     0,     0,   280,   314,     0,   289,     0,     0,     0,
       0,   209,   337,     0,   207,   325,   325,  2587,  2588,   181,
    2605,     0,   150,   170,   437,  1663,  1665,  1879,   472,   497,
       0,   495,     0,   491,   488,   492,   521,   522,     0,   505,
       0,   516,     0,     0,     0,     0,     0,  1867,     0,     0,
    1874,  1876,     0,     0,     0,     0,     0,   636,   626,   633,
     635,   315,   321,   311,   319,   280,     0,     0,   279,   298,
     333,   210,     0,   335,     0,   280,     0,   324,   326,   328,
       0,   132,  2599,     0,  1865,   494,     0,   502,   498,   500,
     503,   511,   510,   507,  1095,  1871,  1872,     0,  1869,     0,
       0,  1875,  1435,  1433,   800,   799,   638,   637,   634,     0,
     312,     0,     0,   310,   290,   295,   280,     0,   280,   222,
     221,     0,   213,   261,   332,     0,   212,  2591,   280,     0,
    1873,   496,     0,     0,   509,     0,     0,  1564,  1566,  1870,
    1878,  1877,   316,     0,   280,     0,   280,     0,   280,     0,
       0,     0,     0,     0,   208,   280,  2600,     0,  1881,   501,
     499,  1096,  1562,  1095,     0,   308,   280,   296,   301,   338,
       0,   216,   262,   263,     0,   219,  2592,  1880,     0,  1885,
    1567,  1565,   280,   280,   297,   300,   336,     0,     0,   214,
     215,   227,   226,   218,     0,     0,     0,  1892,   280,   280,
     302,   235,   233,   280,   223,   231,   225,     0,   232,   264,
     220,  1883,  1884,  1882,  1887,     0,     0,  1889,  1890,     0,
    1854,     0,   217,   234,  1891,  1886,     0,  1893,  1895,     0,
     224,  1888,     0,  1095,  1894,     0,  1096,  1896
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    58,   603,  1448,    59,    60,    61,    62,    63,  1319,
      64,   815,  1246,  1750,  1751,    65,   542,    66,  1024,  1505,
    1506,  2972,  2973,  1507,    67,  2088,  3012,  3013,  3014,  1524,
     512,   513,  1942,  1943,  1049,  2995,  2959,  3770,  2963,  3886,
    4024,  3925,  2018,  3311,  3771,  3772,  3895,   537,  2086,  1462,
    4048,  1922,  4157,  1923,    68,   638,  1022,  1484,  1485,  3329,
    3330,  3591,  3331,  3583,  3584,  3585,  3586,  4295,  4131,  4234,
    4296,  4371,  4407,  4413,  4414,  4341,  4423,  4424,  4425,  4411,
     887,  4426,    69,   565,   566,   889,  1348,  2334,  1349,    70,
    4342,  4409,  4132,  4133,  4031,  4134,  3898,  4135,  4035,  4136,
    3901,  4137,  4138,  4139,  4140,  4287,  4141,  4030,  4334,  4128,
    4129,  4336,  4388,  4405,  4142,  3908,  4025,  4221,  3909,  4026,
    4282,  4124,  4283,  4329,  4384,  4125,  4222,  4332,  4225,  4143,
    4149,  4297,  4144,  4150,  4145,  3913,  4042,  4148,  4040,  4147,
    4338,  4292,  2578,  2994,   621,   622,   649,  2076,   623,  1038,
     996,  1464,  1955,  1956,  2440,  2441,  2560,  2561,  2562,  1947,
    1948,  1949,  2064,  2065,  2066,  1929,  1930,  1931,  1468,  1926,
    1927,   624,   997,  1007,  1950,  1951,  1952,  2566,  2068,  2069,
    2070,  2071,  1953,  1743,  1954,  2847,  2584,  3005,  3595,  3788,
    3339,  3932,  4163,  3006,  3007,  2510,  2910,  2489,    71,   554,
     867,  1316,  2307,  1317,  2309,  2732,  2733,  2734,  1793,  1794,
    3666,  1798,  2306,  3828,  4175,  3972,  3973,  2736,  3971,  2740,
    3129,  3130,  3429,  3668,  3831,  4180,  4077,  4254,  4178,  4250,
    4179,  4252,  4353,  4308,  4309,  4088,  4190,  4191,  4258,  4311,
    3985,  3986,  3987,  2327,  2746,  3671,  3597,  2058,  1454,  1455,
     514,   515,   516,   646,  2585,  2004,  2586,  2587,  2927,  2006,
    2007,  2706,  1382,  2923,  2896,  3642,  3001,  2931,  2932,  2933,
    2934,  2935,  4010,  4108,  4109,  4106,  2941,  2863,  2449,  2450,
    2515,  2944,  3293,  3548,  4220,  4278,  4279,  4280,    72,   864,
    3786,  3516,  3531,  3295,  3296,  3297,  3298,  3299,  3300,  3301,
    3030,  3031,  3737,  3738,  3739,  3025,  3026,  3366,  3549,  3550,
    3551,  3787,  3752,  1170,  3359,  2787,  2788,  3838,  2796,  2797,
    2838,  3174,  2839,  1458,  3360,  3361,  3362,  3560,  3552,  2943,
    3509,  3730,  3733,  3872,  4115,  2451,  2864,  2452,  2867,   950,
     517,  2453,  2454,  1538,  1539,  3935,  3944,  3948,  3936,  3949,
    3945,  3937,  3938,  3939,  3951,  3947,  2591,  3598,  3599,  2856,
    3094,  3874,    73,  1472,   990,   999,   995,  1014,   633,  1473,
    2019,  2522,  3570,   611,  2008,  3501,  3224,  3505,  2009,  2876,
    2010,  3211,  3487,  2011,  3240,  3503,  3727,  2877,  2878,  2012,
    2013,  2014,  3223,  3232,  3725,  2455,  1298,   126,   127,   629,
     630,   631,  2259,  2939,  2496,    74,  1430,  1425,    75,   962,
     957,   958,  1428,  1429,  1888,  2385,    76,   641,  1511,    77,
    1327,  2319,  2320,  2321,    78,  1015,    79,    80,   642,  1518,
    1519,  1520,    81,  1310,   134,    82,   875,  1322,  1324,  1325,
      83,   637,  1016,  1017,  1018,  1019,  2024,    84,  1784,  2291,
    2292,  2293,  2294,  1481,  2524,  1482,  1483,  2033,  3122,    85,
      86,   600,  2214,   571,   896,   572,   573,  1827,  2347,  3643,
     907,   908,   909,  2772,  1360,  1361,  1362,  1790,  2777,  1103,
    1100,   780,   781,   782,   783,  1194,  1195,  3553,   784,  1204,
    1709,  3042,  3380,  1569,  1570,   785,   786,   787,   788,   789,
     790,  1736,  3062,  3063,  3395,  2244,  2245,  2246,   791,  2133,
    3049,  2146,   792,  1187,  1694,  1627,  3387,  3055,  3627,  3803,
    1555,  2108,  2623,  3033,  2703,  2208,  1126,  1127,  1084,  2115,
    1561,  1895,  1896,  1897,  1898,  1899,  3475,  3474,  3476,  3844,
    3692,  3846,  3696,  2396,  1900,  1901,  2813,  3690,  3998,  2209,
    2210,  2211,  3405,  2814,  3191,  2832,  2833,  3707,  2387,  1902,
    2820,  4006,  3704,  3705,  4104,  4103,  3706,  3480,  3481,  3204,
    3205,  2968,  2969,  2970,  3848,  1618,  1619,  1625,  1293,  1294,
    1556,  2288,  2720,  3678,  3835,  2235,  3446,  3833,  3992,  2015,
    2902,  2903,  2349,  2350,  2836,  3208,  3237,  1385,  3644,  2722,
    1861,  2803,  2804,  3348,  3965,  4412,  2848,  2536,  2951,  1589,
    1590,  2909,  4093,  4262,  4356,  4357,  4358,  3156,  3157,  3450,
    3451,  2351,  2769,  3158,  3679,  3997,    87,   521,    88,  1748,
    2250,  1243,  2264,  1026,  1542,  1543,   803,   534,    89,   543,
    2289,    90,   561,  1811,   854,   879,  1330,  1331,  2328,  2747,
    2754,  2329,  2759,  3439,  2749,  3135,  3136,  2254,  2255,  2750,
    3138,  3436,  3419,  3420,  3117,  3663,    91,   588,  3202,  2827,
    2828,  4069,  4070,   880,    92,   520,  1071,  2097,  1548,  2096,
    1072,  1073,  2099,   667,   668,    93,   964,   584,  1407,  1408,
    1409,  1877,    94,   576,   951,  2800,  2809,  1855,   871,  1239,
    1389,   954,  1390,  1841,  2367,  1371,    95,   986,   985,    96,
     607,  1450,    97,   816,  1266,  1760,  2710,  3105,  1267,  1268,
    2265,  3811,    98,   562,   884,   885,  1333,  1813,    99,   556,
     872,  1804,   100,   546,   859,  1302,  1783,   101,   102,   861,
    3123,  4072,  4247,   550,  1786,  1306,  3340,  4095,  4199,  4200,
    4202,  4270,  4271,  4304,  4399,  4433,  4417,  4436,  4437,  4440,
    4447,  4448,   794,   973,   795,  3722,   796,   797,  2755,  2756,
    3209,   798,  2757,   799,  2857,  1027,  1545,   540,   492,   618,
     974,  2728,   801,  3915,   993,  1042,   494,   495,   103,   911,
     575,  1364,  1365,  1366,  1836,  1837,   955,  2223,  1838,  1839,
    2364,  2359,  3458,  3180,  3172,   104,   862,   499,  1308,  1309,
    2300,   105,   587,   106,  1295,  1777,  1778,  2285,  2719,  2286,
     107,   892,   108,   841,  1771,   842,  1271,   843,   844,  1285,
    1279,  1288,  1282,  3816,  3655,  3656,  2273,  1242,  1043,  2080,
    2988,  1044,  1763,  2267,  2268,  3414,  3658,  3108,  3822,  3823,
     109,   135,   502,   644,  1033,  1354,   110,   111,   112,   113,
    1357,  1443,  2343,  1444,  2215,  1445,  1446,  1909,  1825,  1690,
    1691,  3092,  1184,  1185,  2218,  2676,  2677,   910,   653,  1059,
    1051,   128,   129,   130,   656,   657,   131,  1012,  1013,  2523,
    2965,  3313,  3573,  3574,  3776,  3920,  1053,  3782,  4241,  4375,
    1054,  1055,  2996,  3784,  4052,  4243,  4348,  1056,  2575,  3326,
    3921,  4159,   114,   975,   597,  1441,  1436,  1438,  1905,  2403,
     115,   116,   117
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3702
static const int yypact[] =
{
    4770,  2551,    61, -3702,  -153,   806, 47807,   678,   892,   892,
    -217,  3862, -3702, -3702, -3702, -3702, -3702,  3211, -3702, 47807,
      61, -3702, 23990, -3702, -3702,   -26, -3702,   211,   892,    61,
     542, -3702, 47807, -3702,   608,  1295,    61, -3702, -3702, 42927,
   -3702,  -217, 47807, -3702,   804, -3702, 42927,  1026,  -116,   754,
     720,  1388, -3702, -3702, 47807,  1838, -3702,   723,  1374,  1300,
   -3702, -3702,  1077, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, 24604, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  1330, 47807,
    1360, 47807,  1218, 47807, 41097, 47807,   955,   977,  1435, -3702,
   -3702,  1531, -3702, -3702,   892,  -217, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702,  1108, -3702, -3702,  1199, -3702, -3702, -3702,
   -3702, -3702,  1696,  1530, -3702,  1565, 41097, -3702, 47807, -3702,
   -3702, -3702,   934, -3702,  1240, -3702,  1257,  1601,  1661,  1664,
    1139, 10885,  1693,  1693,  1693, 47807,  1709,  1693,  1693, 47807,
   -3702,  1693, -3702,  1693,   892, -3702, -3702,  4293, 47807,  1558,
     431,   593, 41097,   187, 47807,  -153,    70, -3702,  1699, -3702,
   -3702, -3702,   892, -3702,  1921,  1767,   236, 47807, -3702, -3702,
     892,   191,  1211,  1386, -3702, -3702,  1504, -3702,  4676,   136,
   -3702, -3702, -3702,  1916, -3702, -3702,  6053,  1504, -3702, -3702,
   -3702,  1377, -3702, -3702, -3702, 47807,  -153,   892,  1702, -3702,
   -3702,   269,   269,   269, -3702,   269, -3702,   269, -3702,   723,
    1370, -3702, -3702,  1361, 47807,   946,  1009, -3702, -3702,  1387,
    1102, -3702,  1459, 38657, -3702, 47807, -3702, -3702, -3702, -3702,
    1672, -3702, -3702, -3702,  2157, -3702, 23990, -3702, -3702, -3702,
     977, -3702, 47807,  1538, -3702, -3702, -3702, 23990,  1426, 47807,
   -3702, 23990, 23990,   175,   665,  1433, 47807, 47807,  1872, -3702,
    2066, 38657,  1638, -3702,   138,   976,  1531,  2088, -3702,  1530,
   -3702, 47807, 47807, 47807, -3702, -3702, -3702, 43537,  1139,  1467,
    1473,  1481, 15941, -3702,  1496,  1509,  1519, 10885,  1525,  1541,
    1544,  1554,  1563,  1569,  1591,  1603,  1617,  1624,  1644,  1649,
    1673,  1683,  1687,  1687,  1691,  1694,  1703,  1714,   -80,  1721,
   -3702,  1731,  1734,  1744, -3702, -3702,  1747,  1749,  1764, -3702,
   -3702,  1782,  1796,  1802, 11517,  1816,  1819,  1821, -3702, 20911,
    1832,  1836,  1839,  1847,  1849,  1858,  1888,  1892,  1894, -3702,
   -3702, 10885,  1691, -3702, -3702,  1897, -3702,  1907,  1924,  1927,
    1935,  1939,  1942,  1944,  1946,  1950,  1957,  1959,  1961,  1964,
    1968,  1983,  1691, -3702,  1113,  1989,  1994,  1192,  1999, -3702,
    2005, -3702,   293,  2009,  1687,  1691,  1691,  2017,  2025,  2029,
    2032,  2037, 15941, 15941, 15941, 10885, -3702, 47807, -3702, 47807,
    2002,  2911, -3702,  2405, 15941,   179, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702,  1556,  1566, -3702, -3702, -3702, -3702, -3702,
    2041,  1572,  2098, 47807, 47807, 47807,  1965, 47807, 47807, 41097,
    1771, 47807, 38657, -3702,  1693,  1690,  3646,  1992,  1834,  1732,
   -3702, -3702, -3702, -3702, -3702,  2053, -3702, -3702,  1810, -3702,
    2077, -3702, -3702,   422, -3702,    90, -3702, -3702, -3702, -3702,
   -3702, -3702,  2095,  1871, -3702, -3702,   114, -3702, -3702, 47807,
   -3702, -3702, -3702, -3702,  2288,  2047, -3702, -3702, -3702,   159,
    2495,   826, 23990, -3702,  1986, 10885,  1492, -3702,  -184, -3702,
   -3702,  2392, -3702, -3702, 38657, 23990, -3702, -3702, -3702, 21527,
   -3702, -3702,  2627, -3702,  2049, -3702, -3702,  1566,  3741, -3702,
    1992,  2321, -3702,  2323,  2227,   665,  2118, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2081,  1916, -3702,
   -3702, -3702, -3702,  2534, -3702,  2243, -3702,    11, -3702,  2108,
     752,    11, 39267,  2476,   196, -3702,   171, -3702,  2581, -3702,
   -3702, -3702, -3702, -3702,  2272,  2256, -3702, -3702,   369,  1724,
   -3702,  2636, -3702,    52, -3702, -3702,  2316, -3702,  2476,    11,
     196, -3702,  2548,  2677,   554,  -144, -3702, -3702,   582, -3702,
   -3702,  2745, -3702, -3702, 23990, -3702, -3702, -3702,  2288, -3702,
   -3702, -3702, -3702,  2209, -3702,  2485,  2326, -3702, -3702,    45,
   -3702,  2223,  1022,  2696, -3702,  1017, 34997, -3702, -3702, -3702,
    2727,  2743,  1687,  2232, -3702, -3702, -3702,  2862, -3702, -3702,
    2244,  2766,  2766,  2766,  2880, -3702, -3702, -3702, -3702, -3702,
   -3702,  2421,  2293, -3702,  1538, 23990,  2644,  2261, -3702, -3702,
    2505, 10885, -3702, -3702,  4284,   247, -3702, -3702,   219, -3702,
    2838,  2467, -3702, -3702, -3702, -3702,  2733, -3702, -3702,  2862,
    2793,  2766,  2687,  2281, -3702, -3702, -3702, -3702, -3702, -3702,
    1621, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  1659, -3702,
   -3702, -3702, -3702, -3702,  1538, -3702, 23990, -3702, -3702, -3702,
   23990, -3702,  2290, -3702,  2282, -3702, 10885, 10885,  1083,  2855,
    2917,  2917,  2917,  2002,  2328, 10885, 10885, 10885, 10885, 10885,
   10885, 10885, 10885, 10885, 10885, 10885, 10885, 10885,  1266,  2303,
   -3702, -3702,  2131, -3702,  2306, 10885, 10885,  2394, 10885,  1566,
   10885, 25218, -3702,  3889, 10885,  1067,  2795, 10885, 10885, 10885,
   10885,  2781, 10885, 10885, 10885, 25218,  2928,  2308, -3702,  2305,
    1416, 10885, 10885,  1552, 10885, 10885, 10885, 10885, 10885, -3702,
   -3702, 10885, 10885, 10885, 10885, 15941, 10885, 10885, 10885, 10885,
   10885, 10885,  2917,  2917, 10885, 10885,  1606, -3702, 10885,  1566,
    1997,  1997, 10885,  1566,  7725, 10885, -3702, -3702, -3702, -3702,
   -3702,  2311, -3702, -3702, -3702, 25218,  2917,  2917, 10885, 10885,
    2855,  2855,  2855,   209,  2313,  1023, 10885, 26446,  2312, -3702,
   -3702, -3702, -3702, 10885, 10885, 10885, -3702, 15941, -3702, -3702,
    1854, -3702, -3702, -3702, 12149, 15941, 15941,  2324, 15941, 15941,
   15941, 15941, 15941,  2684, 15941, 15941, 16573, 17205, 15941, 15941,
   15941, 15941,  1159,  2855, 41097, 15941, 10885, -3702, -3702, 47807,
   -3702, -3702, -3702,  2325, 23990,  1771, -3702, -3702,   -90,  2785,
   -3702, -3702,  2334, 23990, -3702,  2331, -3702,  2690, -3702, -3702,
    2693,  2695,  2700, -3702, -3702, -3702, -3702, -3702,  2914,  2703,
   -3702, -3702,  2704, -3702, -3702, -3702, -3702,  2357, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702,  2460, -3702, -3702, -3702,  2364,
   -3702, 38657,  2364, -3702, -3702,  2364, -3702, -3702,  2364,    25,
    3313, -3702, -3702, 47807, -3702, 48417, -3702, -3702, 21527,  -153,
   -3702, -3702, 12781, -3702, -3702, -3702,  2721,   182,  2366, -3702,
   23990, -3702,  2002, -3702,   118,   118,  2619,   167, 41097, -3702,
   -3702,   139,  2377,  2461,  2383, -3702,  2469, 23990, 23990, -3702,
   -3702, -3702, -3702,  3005,  1211, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2390,  2861,
    2404, 38657,    67, -3702, 47807, -3702,  1646, -3702, -3702, -3702,
    2408, -3702, 10885, -3702,  2415, -3702,  1474,  2791, -3702,  -153,
   10885, -3702,  2429,  1530, 47807, 47807, 47807, 23990, 47807, 23990,
   -3702,  1071,  1071, -3702, 35607, -3702, -3702, -3702, -3702,    11,
   47807, 47807,    11, 38657, -3702,   196, 47807,    11, -3702,  2801,
    2526, -3702, -3702, -3702,  2876, -3702, -3702,  2867,  2430, -3702,
    2791, -3702, -3702,   196, -3702, -3702, 23990, -3702, -3702,   196,
   -3702,   196,   196,    11,    11,  2486, -3702, -3702,  2433, -3702,
    2486,  2578, -3702,  1105,   269,  2675, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,   781, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702,   153, -3702, -3702, -3702,  1987,  2933,
   -3702, 41097,  2241,  -111,  1349,  2241,  1799,  -153,   501, -3702,
     501, -3702,  4090,  2709,   204, 23990, -3702,  2444, 44147, 23990,
   -3702, -3702, -3702,  1413,  2450,  2452,  2002,  2922,  2923,  2925,
    2927,  2932,  2935,  2936,  2939,  2941,  2947,  2948,  2950,  2952,
    2961,  2962,  2966,  2972,  2976,  2459, -3702, -3702, -3702, -3702,
   23990, -3702, -3702, -3702, -3702,  2562, -3702, -3702, -3702, -3702,
    2370, -3702, -3702, -3702,   208,  1212,  2532,  2561,   147, 38657,
    2951, 47807, 47807,  1530, 47807, 47807, -3702, -3702,  1096,  2783,
    2797,  2798,  2517, -3702, -3702, -3702,  1296, 47807,  2970, 29507,
   -3702,   415,   303, -3702,  2917,  2539, -3702,  2540,  2542,  2544,
   10885,    78,   176,   323,  -224,  1381,   396,   436,   440, -3702,
    1391,   463,   538,   621,  1058,   687,   251, -3702,  2545,  2554,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2550, -3702,
   -3702, -3702,   749,   801,  1063,  1065,  2556,  2557, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2971, -3702,
    1454, -3702, -3702, -3702, -3702,  2553, -3702, -3702,  1075,   803,
     813,   217,  2569,  1520,   834,  1560,  1605,  2570, 25218, 47807,
    2917,  2571,  1082,  1100,  2917,  2572,   876,  1163,  1653,  1670,
    1676,  1194,  1215,   878,  1684,  2221,  1248,   884,   888,   902,
     906,  1250,  2577,  2582,   908,   273,  2917,  2583,   314,  2580,
    2584,  1254,  8989,  9621, 10253,   198,   932, -3702,  2586, -3702,
    2305,  2589,  2597,   340,  1338, -3702, 10885, -3702, -3702,  1033,
    1262,  2656,   160,  1024, -3702,  2755, 47807,  2105,   170, -3702,
   -3702, -3702, -3702, -3702, -3702,   789, -3702,  2605, -3702,  2607,
    1908,  2615, 10885,   192,  2615,  3443,  2291,  2291, 15941,  2916,
    3136, 11517,  1217, 11517,  1217,  2615,  2615,  2615, -3702, 15941,
    2614, 15941, 15941, -3702,  2855,  2002,  2622,  -243, 47807, -3702,
     -90, -3702, -3702, -3702, -3702,   811, 38657,   161, 23990, 41097,
    2613, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  3300,
   23990, -3702, 47807, -3702,  2698, -3702, -3702, -3702, 22141, 22141,
   -3702, 22141, -3702, -3702,   305,   360,  3114,  2651, -3702, -3702,
   -3702, 28895,  2002, -3702, 23990, -3702,  3026,   734, 23990,  2444,
   -3702,  2628, -3702, -3702, -3702, -3702, -3702,  2423,  2738, -3702,
    3249, -3702, 10885,  -153, -3702, 38657, 38657, 23990, 23990,   382,
   -3702,  1704, -3702, -3702, -3702,  3741, 17837,  3058,  3070, 22141,
   22141, 22141, -3702, -3702, -3702, -3702, -3702,  1335,  2002, -3702,
    2629, -3702, -3702, -3702, -3702, -3702, 44757,   129, -3702, -3702,
    -153,  3072, -3702,  2002,  2637, 47807, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  3098,
   -3702,  2813,   642, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
      11, -3702, -3702, -3702, -3702, -3702,  2858,  2476,  1724,  3072,
      11,   196, 23990,    11,    11, -3702, -3702,  1469, -3702,   582,
   -3702, -3702, -3702, -3702, 47807,  2200,  2802, -3702,  2641, -3702,
   -3702, 23990, -3702,  2647, -3702,  3091,  3235,  2476, -3702, -3702,
   -3702,   811,   811,  2945, -3702,  -153,  2787,  2790,  2799,  2810,
    2811,  2836, -3702, -3702,  -153,  -153, -3702, -3702,   811, -3702,
     701, -3702, -3702, -3702, -3702,  -153,  -153,  -153,  -153,  2712,
    -153,  -153,  1705, -3702, -3702,   811,   811, -3702,   258, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,  1081, -3702,  3160,  3222,
    2929,   811,   811,  3222,   811,  2931,  2940,   811,   811,  2754,
    3168,   811,  3068,  2803,  1417,  3071,   811, -3702,  2809,  3190,
     811,   811,   811,   811,  3222,  2943,  3282,   811,   811, -3702,
     811,  2956,  2964,   177,  2963,  2968,   811,   178, 47807,   811,
     811,  2969,   811, -3702, -3702,  5272, -3702, -3702, -3702, -3702,
   -3702, -3702,   -97, 22758, -3702, -3702,   811,   162, -3702,  2930,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702,  2724, -3702, -3702, 10885,  2730,  2712,  -153,  -153,
    1029,  -153,  2712,  -153,  -153,  -153,  -153,  -153,  2712,  2712,
    -153,  1156,  -153,  2712,  4284, -3702, -3702, -3702, -3702,   224,
     811,   811,   811,   811, -3702,  2500, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, 41097,  3082,  1028,   715, -3702, -3702,
   41097, -3702, 47807, -3702,   384, 47807,  2734,  -152,  3094,   875,
     875, -3702, 23990, 23990, 23990, 47807,  2779,  2651, 29507, -3702,
   -3702,  1105, -3702,  2728, 13413, -3702,  2737, -3702, 10885, -3702,
   -3702, -3702,   239, 10885, 10885,  3213,  3046, -3702, 39877, -3702,
   -3702, -3702, 10885, 10885, -3702, 10885, 10885, 10885, 10885, -3702,
   10885, 39877,  3046, 10885, -3702,  2740, -3702,  3132,  3138, -3702,
   -3702, -3702, -3702, 10885, -3702, 10885, 10885, -3702, 10885, 10885,
   10885, 10885, -3702, 10885, -3702, -3702, 15941, -3702,  2744,  2747,
   -3702, -3702, -3702,  2756, -3702, 10885, -3702, -3702, -3702, -3702,
   -3702, -3702, 10885, -3702, 10885, -3702, 10885, 10885, 10885, 10885,
   -3702, -3702, -3702, 14045, 10885, 10885,  2757, -3702, -3702, 10885,
   10885, 10885, -3702, 10885,   691, 10885,  1204, 10885,  1224, 10885,
   -3702, 10885, -3702, -3702, -3702, -3702, 10885, -3702,  1751, -3702,
   -3702,  1185, -3702,  1033,  2758, -3702, -3702,  1646, -3702, -3702,
    2748,  2762,  2769, 41097, 10885, -3702, -3702, -3702, -3702, -3702,
   -3702, 15941,   347,  2763, 15941, -3702,  3443,  2781,  2781,  2106,
   10885,   192,  3443, 10885,  2778,  2753, -3702, 10885, 47807, -3702,
   -3702, -3702, -3702, -3702, -3702, 41097, -3702, -3702, -3702, -3702,
     161, -3702,  2331, -3702,  2444, -3702, -3702,  1760, -3702, 38657,
    2772, -3702,  2774,  2841,  2863,  2868, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2476,  1704,
   -3702, -3702,  2796, -3702, -3702,  2505,  2878,  2815,  3146,  3333,
   -3702, -3702, 47807, 15941, -3702,  3380,  2804,  2812,  3268,  2814,
    2002, -3702,  2881, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,   823, -3702, -3702,  2816,  2816, 19681, -3702, -3702, -3702,
    3278,   -61,   -61,   -61, -3702, -3702, -3702, -3702,  3077, 38657,
    3255,  3256,  3257,  1017, -3702,   213, -3702,   172,  3209,  2476,
   -3702,  3261, 41707, -3702, 30117, -3702,  2818,  3207,  2820,   811,
   34387,  1032, 27059, 36217, -3702, -3702,  1029, -3702,   280, -3702,
   36827,  3287, 36827, 36827, -3702,  3105, -3702, -3702, -3702, -3702,
    2651,   196, -3702, -3702, -3702,  2834, -3702, -3702,  1095,  3214,
    3216, -3702,  3096,   950,  3096,  1095,  1095, 25218,  1105,  2119,
   -3702,  2712,  3148, -3702, -3702, -3702, 40487, 37437, -3702, -3702,
   -3702, -3702,  3356, -3702,  3358,   249, -3702, -3702,  2304,  1349,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702,  1799,  2304,  2304,   501, -3702,
      99, -3702, -3702, -3702, -3702, -3702, 25832,    61, -3702,   261,
   -3702, 25832, -3702,  1413,  1413, -3702, 25832,    61,  1029,  2712,
   25832,  2712, 45367,    61,  -153,  -153,  2152,   811,  2712, -3702,
   -3702,  3220, 47807,  3223, 25832, 25832, -3702, 41097, -3702,   811,
    1126,  2712,  1029,  1029, 25832,    61, 25218,  2418,  2481, -3702,
    -153,    61, -3702, -3702, -3702, -3702, 23990,    61,    61,  2800,
   -3702, -3702, -3702,  2712,  2481, 45367, -3702, -3702,  5211, -3702,
   -3702, -3702, 19067, 47807,   294,   194, -3702,  2840, 32557,   918,
     299,  2937,  1582,  2850,  2851, 45977,  2002,  2712, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,  -153,  2423,  2304,  2304,  1212, -3702,  3112,  3277,   811,
   -3702,  2202, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,  2949, -3702,   156,  3041,  2864, -3702, -3702,   287, -3702,
   -3702,  1086, 23990, 18453, -3702,  3103, -3702,  2564, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2860,  1105,  3122,
    1366,  2651,  2882, -3702, 11517,  1350, -3702,  2002, 10885,  2002,
    1111, -3702,  2871,  2871,  2871, -3702,  2873, -3702, -3702,  2871,
    3264,  2871,  3265,  2883, -3702,  2884, -3702,  1775,  1967, -3702,
    1777,  1424,  1981,  1451,  2889,  2890,  1556, -3702, 10885, 10885,
    1461,  1477,   695,   939,   949,   354, -3702,  1484,  3193, -3702,
   -3702,  1542,  1567,  1580,  1584,   958,  1614,  1855, 11517,  1632,
     297,   387, -3702,  1657,   990,  1027,  1665, 10885,  1681, 10885,
    1689, 10885,  1711,  1722,  1729, -3702,  2081,  1185, -3702, -3702,
    2891, -3702, -3702, -3702, -3702, -3702,  2874,  2002,  2892, -3702,
   -3702, 10885, -3702,   179, -3702, -3702, 15941,   409,  2893, -3702,
    2002, -3702, -3702,  2895,  1556, -3702, -3702, -3702, -3702, -3702,
    2904, -3702, 47807,  -229,  2902, 30727, 38657, 38657, 38657,  2898,
   10885, -3702, -3702,  3165, 23990, -3702,  3303, -3702, -3702, -3702,
   -3702, -3702,  2901,  2915, -3702, -3702, -3702,  3443,  3263,  3156,
   -3702, -3702,  2423, 47807, 38657, -3702,  1916, 25218, -3702,  2919,
   -3702,  2919,  -154,  2905,  1863, -3702, -3702, -3702,  2910,  2118,
   17837,  3355,  2334, 38657, 38657, 38657, -3702,  2651,  2651,   127,
    2977,  3309, -3702, -3702, -3702, -3702, 46587, -3702, -3702, -3702,
   -3702,  -241, 47807,  3290, 47807,  8357, -3702, -3702,  3485, 10885,
   38657,   913,  1024,   811, -3702, -3702, -3702, -3702, -3702, -3702,
    2476, -3702, -3702, -3702, -3702, 36827, -3702, -3702, -3702,  2476,
   -3702,    11,  1469,  -202,  1262, -3702,  1184, -3702, -3702, -3702,
    3307,  1095,  3096,  3096,  3312,  3198,   -68,  2938, -3702,   811,
   -3702, -3702, -3702,  1916, -3702, -3702, 10885, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702,  1081, -3702, -3702, -3702, -3702,  2942,
    3311,  3315,  1413, -3702, 25832, -3702, -3702, 25832, 25832,   113,
   45367, -3702, -3702, -3702, -3702, -3702, -3702,  2944, -3702, -3702,
    2423, -3702, -3702, 37437,  -153, -3702, 25832,  2944, -3702, -3702,
     201, -3702,  -153, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, 45367,  2946, -3702,   295, -3702, -3702, -3702, -3702, -3702,
    1921, -3702, 45367, -3702, -3702, 45367, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2953,  2896,  2208,
   -3702,  2958,  2959, -3702, -3702, -3702, -3702, 47807, -3702, -3702,
   23990, -3702, -3702, -3702,  5958, 47807, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702,  3167, -3702, 10885, 10885,  3229,
   47807,  3236, -3702,  3489, 47807,  3554, 45367, -3702,  2973, -3702,
    2967, -3702,  1866, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
    2954, 47807,  2304,  1028, -3702, -3702, -3702, -3702,  -153,  1086,
   -3702, -3702, -3702, -3702,  3237,  3238, 47807, -3702, -3702, -3702,
   -3702,  3088, -3702, 23990,  3556, -3702,  3140, -3702,  2975,   785,
    5395, -3702,  2981,  2983,  2984, 29507,  2651,  3348, -3702, -3702,
    2781, -3702,  2002, 10885,   765, -3702, -3702,   206, -3702,   777,
   -3702, -3702, -3702,  2989, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,  3169, -3702, -3702, -3702,  3046, -3702, -3702, -3702,  2990,
    2781,  2781, -3702, -3702,  3571,  3152, 10885, 10885, -3702, 10885,
   -3702,   284,  2993,  3020, -3702, -3702, -3702, -3702, 10885, -3702,
   -3702,  2781, -3702, 10885, -3702, -3702, 10885, -3702, 10885, 10885,
   -3702,  1736, -3702,  1755, -3702,  1769, -3702, -3702, -3702,  2408,
   -3702, -3702,  1023, 47807, -3702, -3702,  1909, -3702, -3702, 10885,
   -3702, 41707, -3702, -3702,  3206, -3702, -3702,  3423, -3702, -3702,
   -3702,   546,   546,   546, 14677,  2002,  3479, -3702, -3702, -3702,
    3303,  3369, -3702,    81, -3702, 47807,  3002,   948, -3702,  1912,
   -3702, -3702,  3003, -3702,  2081,  3006, -3702,   811, 14677,  2816,
    3140, -3702, -3702,  -154, 25218, 30117, -3702, -3702, 38657,  2334,
    2334,  2334,  2476,  3428,  2878,  2878, -3702, 27672, -3702, -3702,
    3159, -3702, -3702, 31337, -3702,  1574, -3702, -3702, 15941,  1731,
   -3702,  2002, -3702, 40487, -3702,  2002,   811,  3009,  3014, -3702,
   -3702, 47197, 10885, -3702, -3702, -3702, -3702, -3702,  1646,  2407,
   -3702,  1105, -3702,  1095, -3702,  3392,  3393,  1095, -3702, -3702,
   -3702, 25218,  2651, 14677, -3702,   232,  2081,  2002,  3015,   295,
   -3702,  -114, 10885, 25832, -3702, -3702, -3702,  3021, -3702, -3702,
    3518,  3520, -3702, 25832,  2370, 47807, -3702,  3485, -3702, -3702,
   -3702, -3702,  5958, -3702, 25218, -3702, -3702, -3702, -3702, -3702,
   47807, -3702, 23990, -3702, 19067, -3702,  3022, -3702,  2871,  2871,
    2871, -3702, -3702, -3702,  2871, -3702,  2873,  3253, -3702,  2873,
    2873, -3702, -3702, -3702, -3702, -3702,   206,  1883, -3702, -3702,
     206, -3702, -3702, -3702,   168,  -195,  2873, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702,  2871,  2871,  2871, -3702, -3702,   206,
    2871, -3702,  2871, -3702,  2606, -3702,   313,   128,  2871,  2871,
    2871,  2989,  3019, -3702,  2002,  2781,  3568, -3702, -3702,  3172,
    -153,  3515, -3702,  1928, -3702,  3032, -3702, 45977, -3702,  2712,
    1799, -3702, -3702, -3702, -3702,  3173,   963, -3702,  3201,  3035,
    3036, -3702, -3702,  -153,  3038,  3040, -3702, -3702, -3702, -3702,
    3653, -3702, 47807, 47807, 47807,  2728, -3702, 38047, -3702,  1286,
    2002,  3044,  3045,  3047,  3048,  3644,   200, -3702,  3645, 39877,
   -3702, -3702, -3702,  1936,  3324, -3702, -3702,  2871, -3702,  2873,
   -3702, -3702, -3702,  3622, -3702, -3702,  2871,  3442,   206, -3702,
   -3702,  3056, -3702,  3059,  3060, -3702,   269,  3061,  1774,  1040,
    1970,  3360,  3435, -3702,  3280, -3702,  1780,  1327,  1829,  1865,
    1873,  1884, -3702, -3702, -3702,  1499,  1262, -3702, -3702,  1972,
   -3702,  3417,  3326,  1048,  3092,  3092,  3092,  1731,  2002,  1975,
   -3702, -3702, -3702, -3702,  3455, -3702, -3702,  3073,  3249, 47807,
   -3702,  3156, -3702,  2408, 25218, 14677,  3069,  3074, -3702,  1022,
   -3702, -3702,  3063,  2334, -3702,  3655,  3494, -3702, -3702, 41097,
    3078, -3702, -3702,  3373, -3702,    95,  3294, -3702, -3702, -3702,
     913,  3175,  3180,   811,  2002, -3702, -3702,  2641,  2752,  3137,
    1095,  1095,  3062,  3139, 10885, 10885,  3097, -3702,  3122, -3702,
   -3702,   301,  2408, 10885, -3702,  2423,  3156, -3702,  1886,  3101,
    3102, 47807,  3106,  3107, -3702,  3095,   294, -3702, -3702, -3702,
   -3702,    61, -3702, -3702,  2944,   823,  3104, -3702, 47807,  3416,
   -3702, -3702, -3702, -3702,   515, -3702,  3108,   515,   515, -3702,
    2243, -3702,  3130,   206, -3702, -3702,  3145, -3702, -3702, -3702,
     515,  3115,   206, -3702, -3702, -3702, -3702,   515, -3702, 41097,
    -153,  3018,  3712, -3702,  3154, -3702,  3612,  3488,  3729, -3702,
    2837, -3702,  3495,  3394,   811, -3702,   206, -3702, -3702,  3717,
   -3702,   206,  3717,   515,   515, 47807, -3702, -3702, -3702, -3702,
   -3702, -3702, 47807, -3702,  1141, -3702, -3702, -3702,  1990,  -153,
   -3702, -3702, -3702,  3123,  3125, -3702, -3702, -3702,   299, -3702,
   47807,  5958, -3702, -3702, -3702,  5272, -3702,  1176,  2021,   295,
    3141,  2034,  2038,  3583,  3314, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, 39877, -3702,  3717,  3408,  3142, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, 10885, -3702, -3702,
   -3702, 10885, -3702, -3702,  3440,  3594, -3702, -3702, -3702, -3702,
   -3702, -3702,   172,   172, -3702, -3702, -3702,  3754, -3702,  3239,
    3241, -3702, -3702,  3243, -3702, -3702,   119,  2333, -3702, -3702,
   -3702, -3702, 14677,  3523,  3250, -3702, -3702,  3158,  3186, -3702,
   -3702,  1499, -3702, -3702, -3702, -3702, 10885, -3702,  3122,  2152,
   -3702, 27672, -3702, -3702, -3702, -3702, -3702,  3161,  3166,  8357,
    1023, -3702,  3204, -3702, -3702, -3702,  3205,  2002,  2002, 47807,
    3348, -3702, -3702,  1413,  1413, -3702,   301,  1499,   295, -3702,
    2044, -3702, 47807, 47807,  2052, 47807, 47807,   -61,   -61,   -61,
    1156,  1156, -3702, -3702, -3702,   294, -3702,  3553, -3702, -3702,
    2067, -3702,    60,  3436, -3702, -3702, -3702, -3702,   515, -3702,
     269, -3702, -3702, -3702, -3702, -3702,   269, -3702, -3702, -3702,
   -3702,  1687, -3702, -3702, -3702,  3447,  3212, -3702,  3174, -3702,
   -3702, -3702, 33167, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
    3292, -3702, 53907, -3702, -3702,   723,  3199, -3702, -3702, -3702,
    1475, 47807, 23990,  3229,  3354, -3702,  3485, -3702,  1022,  3103,
    3140, -3702,   122, 47807, -3702,  3450,   126,  1811, -3702,  3641,
   -3702, -3702,  3192,  3194,   295,  1895, -3702, -3702, -3702, -3702,
    3687, -3702, -3702, -3702, -3702, -3702,   325,  3457,  2712,  2712,
    2712,   636,  2333, -3702, -3702,  3251, 23990, 15941,  3310, 47807,
    1382,  2691, -3702,  1512,   295, 10885,  2476, 37437, -3702, -3702,
   -3702, -3702, -3702, -3702, 10885,  3210, 10885,  3217,  2078, -3702,
   -3702,  3637,  3637, -3702, -3702, -3702, -3702,  2084,  2110, -3702,
    2113,  2121, -3702, -3702, -3702,  3218, -3702, 47807, -3702, -3702,
   -3702,   298, -3702, -3702,  2132, -3702,  2135, -3702,  1687, -3702,
   -3702, -3702, -3702, -3702, -3702, 10885,  3673,  3242, 47807,   779,
   -3702, 55127, 55127, 47807, -3702, -3702, -3702, -3702,  5471, -3702,
   -3702,   899, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702,  3808, -3702,  3203, -3702, -3702,  3219,   246,
   -3702, -3702, -3702,  5958,  3651,  1582, -3702, -3702, -3702, -3702,
     785,  3224,  2118,  -153,   811, -3702,   122, -3702, -3702, -3702,
     811,   295,  3225,  3466, -3702,   126, -3702, -3702, -3702,  1811,
   -3702, -3702, -3702, -3702, 10885, -3702, -3702,  3791, -3702, -3702,
   -3702, -3702, -3702, -3702,   862, -3702, -3702, 25218, -3702, -3702,
    2423, -3702,  2138, -3702, -3702, -3702,  3316,   811,   811,  3718,
    3719,   811,   811,   811,   811,  3230,  2691, -3702,  3700, -3702,
   -3702, 10885, -3702, -3702,  2002,  3456, -3702,  3789,  1262,  2002,
   47807,  2002, 47807, -3702, 47807,  1245, -3702, -3702,  3439, -3702,
     122, -3702, -3702,  3156, -3702,   930,   930,   206,   269,   206,
   -3702,  3240,  2002, 10885, -3702, 10885,  3269, -3702, -3702,  3674,
   47807, -3702, -3702, -3702, -3702, 10885, -3702, 53907, 53907, -3702,
   -3702, -3702, -3702,  3834,  1022,  3804,  3501,  3809,  1007, -3702,
   -3702,  3489,  5958, -3702, -3702, -3702, -3702,  2712, -3702, 33777,
   -3702, -3702,   872, -3702, -3702,   295, -3702, -3702, -3702,  3244,
   -3702,   811,  2152,  3246, -3702, -3702, 47807,  3245, -3702,  -153,
    -153,   811,   811,  3024,  3024,  2423, 41097,  3357, -3702, -3702,
     811,   295, 47807, -3702,  1091,  3606, -3702,  2161,  2163, -3702,
    3832, -3702,  3833,  3258,  3260, -3702,   122, -3702,   126,  1811,
    2166, -3702,  3878, -3702,   154,  3527,  3531, -3702, -3702, -3702,
     650,  2002,  2002, -3702,   257, -3702, -3702,  3643,  3730, 10885,
    2002, 50857,  3262, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, 54517, 10885, -3702,   899,
    3808, -3702,  3525, -3702,  3526, -3702, -3702, -3702,  3763, 53907,
   -3702,  3756, -3702,  1022, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, 25218, 14677, -3702, -3702,  3310, -3702,  3273, -3702, -3702,
     285, -3702, -3702,  -153,  -153, -3702, -3702, -3702, -3702, -3702,
    2177, -3702, 41097, -3702, -3702,  3855,  3857,  3751,  3872,  1091,
   -3702,  -127, -3702, -3702, -3702, -3702, -3702, 45977, 45977, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,  3345,  3792, -3702, -3702,
      92,  3321, 10885, 53907, -3702,  3773, -3702,  3705,  1904,  3648,
    3299, -3702,  3297,  2000,  3810, 55127, 55127, -3702, -3702, -3702,
   -3702,  3786, -3702, -3702, -3702, -3702, -3702,  3486, -3702, -3702,
    2179, -3702, 15309, -3702, -3702, -3702, -3702, -3702, 41097, -3702,
    3357, -3702,  3318,   269,   269,  3901,   269, -3702,  3902,  3903,
    -127, -3702,  3322,  2183,   930,   930,  -153,  3706, -3702,    92,
   -3702, -3702,   272, -3702,  2002, 51467,  3921, 47807, -3702, -3702,
   -3702, -3702, 10885, -3702, 42317, 52077,  3320, -3702, -3702, -3702,
    3524, -3702,  1007,  3755,  3789, -3702,  3273, -3702,  3350, -3702,
    3443,  2691, -3702, -3702,  3352, -3702, -3702,   269, -3702,   269,
     269, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, 10885,
   -3702,  3829,  3445, -3702,  3359, -3702, 53907,  2028, 53907, -3702,
   -3702,  3780,  3361,  1362, -3702,  3363, -3702, -3702, 53907,  3943,
    3606, -3702, 15309,  3364, -3702, 10885,  3366,  3362, -3702, -3702,
   -3702, -3702,  2002,  3948, 53907, 47807, 49027,  3563, 52687,  3813,
   47807,  5958,  3814,  3815, -3702, 53907, -3702,   269,  3787, -3702,
   -3702,  2002, -3702, -3702,  3464, -3702, 49637, -3702,  2478, -3702,
    3413, -3702, -3702,  3891,  2685, -3702, -3702, -3702,  3663,  3395,
   -3702, -3702, 53907, 53907, -3702, -3702, -3702, 31947, 10885, -3702,
   -3702, -3702, -3702, -3702,  1017,   771, 20295,  3547, 50247, 53297,
   -3702, -3702, -3702, 28285, -3702, -3702, -3702,  3837, -3702,  2002,
   -3702, -3702, -3702, -3702, -3702, 41097,  2186, -3702, -3702, 25218,
   -3702, 31947, -3702, -3702, -3702, -3702, 23374,  3404, -3702,   811,
   -3702, -3702, 25218, -3702, -3702, 14677, -3702, -3702
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3702, -3702, -3702, -3702, -3702,   145, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702,  1783, -3702, -3702, -3702, -3702, -3702,
    1996, -3702,   725, -1784, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702,   728,  1616,  3397, -3702,   466, -3702,   130, -3702,
   -3702, -3702, -2845,     6,  -183, -3702, -3702,   268,    17,  3075,
    -182, -2972, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,   485,   482, -3702, -3702,   296, -3702, -3702, -2287, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702,  -366,  -316,  1923,
   -3702, -3702, -3702,  4033, -3702,  3504, -3702,  1322,  2269, -3702,
   -3702, -3702,   -44,   316, -3702,   317, -3702,   318, -3702,   321,
   -3702,   322,   326,   327,   328, -3702,   329, -3702, -3702,  -319,
   -3702, -3702, -3702, -3702,   332, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702,  -187, -3702, -3702,   -27, -3702, -3702,  -176,   339,
   -3702,  -124,   341, -3702,   342, -3702,   -32, -3702,   -30, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,  3081, -3702, -3702, -3702, -2208, -3702, -3702, -2314,  2652,
   -3702, -1661, -3702, -3702, -1759, -3702, -3702, -1724,   931, -3702,
   -3702,   901,  -346, -3702, -1367, -1865, -1846, -3702, -3702, -3702,
   -1969, -1946,  -781,  2381, -1180, -2200, -3702, -3702, -3702, -3702,
     195, -3702, -3702, -2529,  2112,  2654, -3702,  2648, -3702, -3702,
    1219, -3702, -3702,  1389,   704,  1390, -3702,  1010,  2819, -1219,
   -3702, -3702, -3702, -3702, -3702, -3702,    62,   309,   -38, -3702,
   -3314,   708, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -2330, -3702, -3702, -3702,  -211, -3702, -3702,  -118, -3702, -3702,
    -168, -3702,   158, -2273, -3702, -3702, -3702, -3702,  2621, -1299,
   -3702,  3630, -3702,  -551,   555,  2146, -2371, -1401, -3702,  -929,
    -913, -2432, -3702, -3702, -3702, -3297,  1165,  1575, -3702,   911,
    2144, -1857, -3702, -3702, -3702, -3702, -3702,  1645, -3702, -3702,
     938, -3702,   935, -3702, -3702, -3702, -3702,  -117, -3702,   283,
   -2602, -3702, -3702, -3702, -2738,  1123,   903, -3702, -3702, -3702,
   -1389, -2123, -1338, -3702,   428, -2135, -2414,   870, -3702, -3702,
     623, -3701, -3702, -3702,  -569, -2063, -2353,   102, -3702, -3702,
     637, -3060,  1004, -3702, -3702, -3702, -3086, -1750, -3702,   173,
   -3702, -3702, -3702, -3702, -2663, -3702, -3702, -1463, -2203, -3702,
   -3702,  4171,  4173, -1034, -2652, -2968,    77,    79, -3702, -3702,
   -3702,  2649, -1076,   253,   243,   248,  2104, -1483,   402, -2283,
   -3702,   450, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2185,  -804,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -2349,   973, -3702,
   -3702,  1692, -3702, -3702, -3702, -1828,  3247, -3702, -3702, -3702,
   -3702,  3575, -2139, -3210, -3702, -3702, -3702, -3702, -3702, -3702,
    1642, -3702, -3702,  2317,  2777, -3702, -3702, -3702, -3702, -3702,
   -3702,   703,  1889, -3702, -3702, -3702, -3702, -3702, -3702,   992,
    2694, -3702, -3702, -3702,   -15, -3702, -3702, -3702, -3702,  2410,
   -3702, -3702, -3702, -3702,  2746, -3702, -3702, -3702, -3702, -3702,
   -3702,  1495, -3702,  1929, -3702, -1434, -3702, -3702,  1103,  -981,
    1879,  -593,  2013,   456, -3702,  3633, -3702, -3702, -3702, -1588,
   -2418, -3702,  3325,  -824, -2516,  2406,  -550, -1801,  1133,  1441,
    -676,  3522, -3702, -1145, -1136, -3702, -3702,  -644, -3702, -3702,
   -3702, -3702, -3702,  2114,  2115,  -647, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702,  1536, -3702, -3702,
   -3702, -3702, -1714, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
    1794, -3702, -2023, -3702, -3702,  -471, -3702,  3117, -3702, -3702,
   -3702, -2247, -1882,  1842,  1053, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -2331, -3702, -3702, -3702, -3702, -3702,
    2033, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -1667, -3702,
   -1925,   394, -3702,   544, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,    41,   937,    47, -2143, -1090,  1660, -3702, -3702, -1266,
    3162, -2031, -3702, -3702, -3702,  2015, -3702, -3702, -3702, -3702,
   -3702,  1025, -2542,  2817, -3702, -3702, -3087,  -904, -2237,  -856,
   -3702, -1342,  1452,   561, -3702, -1749, -1092, -2040, -2415, -2469,
   -3702,  1758, -3702, -3702, -3702, -3702,  -119, -3702, -3702, -3702,
     584,  1918, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702,  -542,  -722, -3702,  2172,  2601, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,  2979,  2955,  1979, -3702,
   -3702, -2514, -3702, -3702,  1945, -3702,   835, -1977, -1817,  1132,
   -3702, -3702,  1136, -3140, -3702, -3702, -3702, -3702, -3702, -3702,
    1074, -3702,   108,  3692, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702,  2735, -1055,  3616, -3702, -3702, -3702, -3702, -3702, -3702,
    2409, -3702, -3702, -3702, -3702, -3702, -3702,  2903,  3710,  -574,
   -1279, -3702,  -741,  2879,  2411,  -884, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,  2533,
    1049, -3702, -3702, -3702, -3702,  2960, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,  1172,    -8, -3702,   100,
     -52, -3702,    31, -3702, -3702, -3702, -3702, -3702,  -143, -3702,
   -3702,  -150,  -668,  -974, -1346,   766, -1773, -2005,  1164,  2957,
   -2882,  -687, -1153, -1167, -1907,    65, -3702, -3702,  2821,    89,
     356,  -332,    -6, -2726,  -109,  -589, -3702, -2429, -3702, -3702,
   -3702, -3702,  2479, -3702, -3702, -3702, -3702,  1517, -3702, -3702,
   -3702,  1130, -3702,   853,   626, -3702, -3702,   189, -3702,  2528,
   -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702, -3702,  2965,  3753,  3433, -3702,  3037, -3702,
   -3702, -3702, -3702, -3702,   509, -3702,   684, -2219, -1683, -3702,
   -3702,  2806,   774, -3702,  1618,  -288,  -582, -3702, -3702,   507,
   -3702, -3702,   359,  3764,  3437, -3702, -3702, -3702, -3702, -3702,
   -2699,  -885, -3702, -3287, -2752, -1672, -3702, -3702, -2119, -2960,
   -3702, -3702, -1040, -3702, -3702, -3702, -3702, -1993, -3702, -3702,
   -3702,    66,  3824,  3825, -3702, -3702,  -171, -3702,   541, -3702,
   -3702, -3702, -3702, -3702, -3702, -3702,  3683, -3702, -3702, -3702,
   -3702,  3684, -3702, -3702, -3702, -3702, -3702,  3685, -3702, -3702,
   -3702, -3702, -3702,  1828, -3702, -3702, -3702, -3702, -3702, -3702,
   -3702, -3702, -3702
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2573
static const yytype_int16 yytable[] =
{
     493,  1036,   953,   865,  1449,   536,   981,   949,  1679,  1655,
    1588,  1358,  1451,   535,   552,   620,   541,  1101,  2216,  1550,
    2032,   560,  1678,   491,   994,  1079,   555,  2352,  2353,  1238,
    1109,  1632,  1128,   567,  1540,  1541,   570,  1380,  1863,  2518,
     567,  1787,  1862,  2336,  1414,  2891,  2547,  2029,   589,  2952,
     793,  2721,  1700,  2753,  2841,  2625,  3009,  3017,  1744,  1708,
    3146,  1456,  3190,  3479,  2825,  1415,  2599,  1386,  2634,  1710,
    1711,  2005,  1597,  1714,  1715,  1716,  1717,  1457,  1719,  1720,
    1722,  1724,  1725,  1726,  1727,  1728,  1159,   539,  1172,  1163,
     609,  2443,  1386,   137,  2406,  2407,  1796,  1932,  2682,  1025,
    1028,  2448,  2335,  2384,  1050,  1058,  2516,  2567,  1066,  2635,
    2444,  2418,  2774,   612,  3307,   493,  1870,   493,   619,   625,
    2762,  2708,  3484,  2887,  1945,  1180,  1181,  1182,  2436,  2437,
    2568,  2456,  3406,  1291,  1880,  2460,  3815,  1223,   614,  1222,
     616,  2816,  1883,  1884,  2458,  2459,  2475,  2461,  1046,  2826,
    2464,  2465,  3675,   643,  2468,  1910,  2484,  1329,  2067,  2477,
    3089,   608,  3558,  2480,  2481,  2482,  2483,  3499,  2865,  1802,
    2487,  2488,  3710,  2490,  4276,  2986,  1189,  1190,  3683,  2499,
    3519,  3524,  2503,  2504,  3525,  2506,  1189,  1190,   914,   915,
    2431,  1791,  1189,  1190,  2077,  2116,  2493,   634,   500,  3027,
    3028,  1291,  1286,  3535,  3933,  3034,  2420,  3036,  3933,  1416,
    3557,  2564,  2257,  3217,  1189,  1190,  3011,   551,  2678,  2601,
    1768,  3611,  4049,  1241,   559,  1189,  1190,  3355,  3526,  2113,
    2565,  1029,  2855,  1189,  1190,  2400,  2851,  2852,  3141,  2348,
    3356,  1391,  1432,  2551,  2552,  2553,  2554,  2984,  2519,  1300,
    1224,  2868,  2257,  3868,  3357,  1189,  1190,  2859,  3220,   914,
     915,   729,  1819,  1224,  1741,   914,   915,  1189,  1190,  1411,
     869, -1479,  2393,  3485,  3154,  1292, -2452,  1512,  1369,   857,
     729,  1453,  4214,  1945,  1934,  1323,  3724,  2439,  2528,  1189,
    1190,  1989,  3623,  2538,  3199,  3673,  1439,  2581,  4045,  2544,
    2545,  1039,  2937,  3378,  2549,   969,  2556,  3337,   568,  4046,
    -864,  1924,  2322,  1189,  1190,  3235,  1460,   851,  2500,  1189,
    1190,   877,  2957,   635,  2859,   547,  2799,  3391,  3134,  1166,
    1189,  1190,  1928,  2020,  3355,   132,  1453,  1992,  2494,  1189,
    1190,   658,  3294,  1292,   262,  2073,   264,  3356,   262,  2810,
     264,  4162,  1453,  2977,  2978,   136,  1189,  1190,  2234,  2767,
    2118,  3357,  2770,  1189,  1190,  -529,  1423,   544,   580,  3188,
    1189,  1190,   914,   915,  3832,  3934,  3107,  1799,  2844,  3934,
    4268,  -530,  2785,  2789,  2791,  2247,   136,  2247,  1387,  3649,
    2199,   501,  2576,  2248,  1513,  3163,  3528,   648,  1514,  3529,
     569,  1529,   852,  1189,  1190,  2119,  1226,  1946,  4223,  1515,
    3854,  4269,  1189,  1190,  2577,  3206,   133, -1764,  2871,  2991,
   -1439,  1800,  1508,  4223,  1596,  1189,  1190,  3189,  3236,  1769,
    4015,  1189,  1190,   850,  2324,  2325,   581,  3743,  1128,  1396,
    1388,   548,  2898,  2899,  2801,  3869,  3747,  2021,  1424,  2771,
    2860,  1318,  1189,  1190,  1740,  1925,  1189,  1190, -1439,   753,
    1903,  1235, -2383,  2768,   545,  2184,  2360, -1479,  2958,  2824,
    3763,  1820,   853,  1477,  3140,  3765,   878,  2938,   753,  1189,
    1190,  3032,   970,   971,   639,  1107,  1065,  3073,  1283,  3701,
    3194,  1928,  2845,  1440,   636,  2501,  1530,  1531,  1532,   847,
     619,  3929,   625,  3155,  1107,  1865,  1167,  1168,  1868,  1742,
    4215,  2474,  3794,  1872,  3486,  3864,  3200, -2384,  2361,   806,
    4047,  3338,  3824,   625,  2992,  1456,  1945,  3702,  1030,  3522,
    3227,  1191,   845,  2508,  1192,  1516,   619,   870,   855,  1885,
    1886,  1457,  1047,  3870,  3149,  3150,  3151,  1191,  1108,  2869,
    1192,   873,  1225,  2873,  1189,  1190,  1705,  2316,  1770,   858,
    1744,  1713,  1412,  1932,  3490,  1225,  1946,  2889,  2890,  1191,
    3019,  1301,  1192, -2383,  3650,  2443,  1329,  2900,  1734,   965,
    1191,  3216,  2236,  1192,  3218,  3219,  2713,  3221,  1191,  2442,
    1908,  1192,  2567,  2239,  2444,  1456,  2242,  4253,   984, -1479,
    1770,  3708,  2380,  3229,  2005,  2516,  1329,   619,  2258,   998,
    1191,  1457,  1741,  1192,  1370,  2568,  1564,  1565,  3433,  2940,
     609,  3855,  1191,  2520,  3392,  1192,   493,  1419, -2384,  3440,
    3294,   609,  1517,  1023,   856,   609,   609,  1189,  1190,  3341,
    1037,   998,  1011,  1620,  1191,   619,  3210,  1192,  2258,  1010,
    2884,  1633,  2834,  1635,  3645,  1067,  1068,  1069,  3684,  3215,
    1509,  1074,  2892,  2861,  4277,  1648,  1649,  1650,  1191,  3323,
    4393,  1192,  2233,  1654,  1191,   966,  2516,  1192,  1882,  1892,
    2114,  1392,  2089,  1933,  3090,  1191,   894,  1287,  1192,  1803,
    3482,  1008,  1764,  1048,  1191,  2849,  2564,  1192,  2067,  4110,
    1237,  1747,  1020,  1189,  1190,  2304,  2090,  1189,  1190,  2563,
    2872,  1191,  2874,  1129,  1192,  2565,  3016,  3955,  1191,  2885,
    2815,  1192,  1064,   814, -2452,  1191,  3928,  2495,  1192,  2854,
    3843,  3943,  2897,  3335,  1928, -2572,  3152,  3153,  2906,  2908,
    2987,   863,  2982,  2078,  2072,  3804,  1792,  3993, -1479,   876,
    1934,  3230,  2079, -2452,  2924,  2908,  3024,  4151,  1191,  3527,
    1910,  1192,  1818,  2775,  2362,  1189,  1190,  1191,  1789,  3612,
    1192,  1186,   944,  1188,  1193,  3358,   967,  2853,  2974,   651,
    1191,  2608,  3322,  1192,  1193,  1809,  1191,  -864,  2055,  1192,
    1193,  1510, -1479,  2219,  3834,  2317,  2979,  1231,   493,  1233,
     812,   998,   493,   619,  1869,   493,   619,  1191,   972,  1946,
    1192,  1191,  1193,  1383,  1192, -1439,  3182,  1189,  1190,  1189,
    1190,  1232,  1845,  1193,   549,  1236,   874,  2200,  1240,  1189,
    1190,  1193,  1169,  2862,  1191,  2131,  3512,  1192,  1685,  1686,
    3513,  1893,  -529,  1296,  3653,  1894,  1685,  2150,   848,  1510,
    1189,  1190,  3203,  1193,  4060,  1741,   609,  1742,  -530,  4123,
   -1764,  2726,  3469,  1373,  2993,  1193,  3473,  2753,   619,   609,
    3532,  3533,  3534,   609,  4281,  4016,  4244,  1510,  3537,  1397,
    2802,  2132,  3358,  2667,  3703,  2073,  3563,  1193,  2438,  1912,
    3351,  3504,  1189,  1190,  1189,  1190,  2570,  3195,  3196,  3101,
    1189,  1190,  3351,  2185,  1189,  1190,  1284,  3555, -2383,  1191,
    3365,  1193,  1192,  4249,  1304,  3444,   619,  1193,  1189,  1190,
    1374,  2588,  1189,  1190,  1189,  1190,  3074,  1307,  1193,  3443,
    3489,  4117,  2105,  4119,  1928,  3126,  3700,  1193,  3926, -2383,
    1326,  3024,  -433,  2188,  2189,   118,  3468,  1375,  1189,  1190,
    3472,  2157,  2117,  3618,  1193,  1189,  1190,  1320,   609, -1943,
    1420,  1193,  3621, -2384,  2318,  1189,  1190,  2226,  1193,  2205,
    2206,  4028,  2252,  2376,  1189,  1190,  2690,  2691,  4170,   496,
    1452,  4111,  2085,  3058,  3059,  3346,  2374,  2336,  3413,  2443,
    2866,  2866,  1191,  3963, -2384,  1192,  2379,  3734,  2316,  2382,
    2383,  1193,  2372,  2405,  4193,  1269,  1189,  1190,  2444,   609,
    1193,  3337,  1510,  1426,  2567,   944,  3075,  3076,  1031,  2297,
    2648,  1386,  3381,  1193,  1863,  2121,  1863,  1863,  3187,  1193,
    2806,  2807,  4246,  3111,  3112,  3113,   138,  2568,  3098,  3099,
    4218,  4431,  4107,  1189,  1190,  2104,  2335,  3352,  2603,  1384,
    1193,  1386,  1932,  1945,  1193,  1741,  1189,  1190,  1191,  3352,
     609,  1192,  1191,   120,  1546,  1192,  2122,  3054,   557,  3465,
    2123,  2448,  4065,  2442,  1189,  1190,  4156,  1193,  1695,  1189,
    1190,  1189,  1190,  1421,  2241,  2589,  2689,  1427,  2741,  1915,
    3735,  1189,  1190,  2126,   262,  1553,   264,  1032,  1189,  1190,
    1742,  2475,  2811,  1916,  2571,  1129,  1945,  2005,  1422,  4091,
    2060,  1305,  3649,  3510,  3511,  1733,  1189,  1190,  2564,  1129,
    1191,  3032,  3353,  1192,  3032,  3032,  4029,  1189,  1190,  2337,
    1456,  1537,  3736,  2831,  3363,  1544,  3836,  2565,  4209,  3693,
    3694,  3032,  2216,  4155,  4067,  2227,  1457,  2694,  2695,  1933,
    1227,  2298,  1193,  1906,  2531,  3536,  1376,  2256,  3427,  1679,
    3435,  3556,  3559,  3561,  3562,  4032,  4033,  2737,  2127,  1680,
     553,  3478,  1191,   574,  1191,  1192,  1529,  1192,  3365,  1189,
    1190,   619,  1621,  4037,  1191,  1622,  2243,  1192,  2067,   598,
    2688,  1729,  2290,  2252,  2563,  1052,  1060,   897,  3580,  3460,
    2698,  2821,  3428,   627,  2559,  1191,  2260,  3581,  1192,  1801,
    1189,  1190,  2997,  2822,  2532,   944,  2312,  2313,   619,  4068,
    1189,  1190,  2790,  1737,  1554,  3338,  2220,  4432,   609,   849,
    1679,  1189,  1190,  4055,  3032,  1193,  2317,   609,   582,  1934,
    1189,  1190,  2303,  1335,  2829,  4195,  4096,  1191,  4219,  1191,
    1192,  2128,  1192,   583,  2572,  1191,  4196,  3964,  1192,  1191,
    3930,  1928,  1192,  1917,  1189,  1190,  1189,  1190,  2363,  2955,
    1189,  1190,  2373,  1191,  3177,   619,  1192,  1191,  1553,  1191,
    1192,   700,  1192,  4112,  2072,  1377,  2253,  1773,  2389,  1776,
   -2520,  3120,   609,  2952,  2060,  2569,  3615,  3650,  2221,  1739,
    1742,  1193,  3178,  1191,   609,  1193,  1192,  1378,   652,  2893,
    1191,  2533,   619,  1192,  1928,  4456,  2516,  2130,  2956,  1679,
    1191,   609,   609,  1192,  3791,  1226,   898,  3354,  2998,  1191,
    4156,  2419,  1192,  2904,  2590,  1918,  1946,  2516,  4038,  3354,
    3582,   705,   628,  3916,  2299,   619,  2228,  3882,  1822,  1379,
    1852,   599,  1914,  4116,  1189,  1190,  1830,  1034,  1035,  1206,
    1919,  1191,  2229,  1193,  1192,   664,  1189,  1190,   493,   493,
     493,   609,   493,   609,   601,  2073,  2061,  4113,  1864,  2137,
    1047,  2570,  1741,  2894,  1866,   493,  2534,   619,  1780,  1946,
     493,  1846,  1847,  1848, -2520,  1850,  2669,  3651,  1191,  2866,
     899,  1192,  2823,  1730,  4114,  2318,  1853,  1577,  1867,   650,
     609,  1191, -1786,  1871,  1192,  1193,  2671,  1193,  2390,  -433,
     987,   497,  1920,   615,   665,   498,  1731,  1193,  1553,  1191,
     810,  2138,  1192,  2148,  1191,  2391,  1191,  1192,   718,  1192,
    1189,  1190,  1849,  2149,  1851,  1928,  1191,  2392,  1193,  1192,
    4100,  4372,  3179,  1191,   729,   619,  1192,   602,  1842,  1863,
    2976,  4197,  3916,  3916,  2153,  1227,  2474,  1189,  1190,   609,
    4373,  1191,  2025,   609,  1192, -1787,   604,  1189,  1190,  2895,
    1011,  1881,  1191,    43,  3996,  1192,  3689,  2442,   626,  1688,
    1193,   610,  1193,  1189,  1190,  2222,  4101,  2445,  1193,  2212,
    1189,  1190,  1193,  4039,   609,  2999,  2165,  2253,  2172,  4298,
    4298,  1921,   881,   734,  2176,  1227,  1193,  3931,  2177,  1227,
    1193,   613,  1193,   619,  2393,   493,   493,  2345,  2087,   493,
   -2520,  1048,  2178,   729,  1191,   578,  2179,  1192,  2183,   579,
    2022,  1074,   944,  2103,  2027,  3018,  1193,  1209,  2083,  2084,
    3800,  3097,   666,  1193,  3652,  1476,  1944,  1640,  1189,  1190,
    2061,  1892,  2201,  1193,  1553,  1191,  1741,  3653,  1192,  3056,
    2974,  1892,  1193, -2572, -1786,  1191,  2346,  3762,  1192,  3057,
    1679,  1854,  1928,  1189,  1190,  1732,  1191,  2693,  3068,  1192,
    2952,  2535,  -198,  1356,  3137,  1191,  1189,  1190,  1192,  3995,
    1189,  1190,  3000,   632,  1193,  1536,  2471,  3774,  3916,  3916,
    1623,  4324,  4325,  1624,  2952,  2952,  2563,  4102,  1553,  1191,
    3078,  1191,  1192,   882,  1192,  1191,  3975,  1742,  1192,  4198,
    1189,  1190,  1129,  2158, -2520,  2062,  2394, -1787,  1933,   988,
    2261,  1193,  2322,  2030,  4166,    57,  3976,  2030,  1189,  1190,
    3131,  1689,   753,  3023,  1193,  2630,  2089,  3079,  1823,  3654,
     120,  2213,  2636,  1109,  1159,  1163,   989,  2031,  4185,  4186,
    3631,  2031,  1193,  1189,  1190,  2642,  1832,  1193,  1107,  1193,
    2090,  1189,  1190,   900,   901,  2726,   903,  2129,   905,  1193,
    2225,  2345,  2139,  1644,  2140,   883,  1193,  1189,  1190,  2395,
     906,  2926,  3916,  1741,  2147,  1189,  1190,  1906,  2657,  1191,
    3580,  2161,  1192,   643,  1193,  3862,  3863,  3916,   761,  3581,
    2961,  1191,  3723,  1893,  1192,  1193,   944,  1189,  1190,  2162,
    3916,   753,  2249,  1893,  2216,  2962,  1398,  1894,  1189,  1190,
     619,  1158,   609,   619,   639,  1189,  1190,  1666,  1833,   640,
    1241,  4146,  1189,  1190,   609,   645,  2266,  1107,  1490,  1491,
    4261,  1313,  2272,  2272,  1314,  2272,  1399,  1384,  3723,  3775,
     647,  1189,  1190,   659,  2072,   619,  2704,  1193,   609,  2063,
    2569,   585,   609,  1034,  1035,  1189,  1190,  1824,  3226,  1533,
    1189,  1190,  2166,   509,  3916,  1191,  1189,  1190,  1192,   619,
     619,   609,   609,  2570,  3790,  2472,  3916,  3916,  1193,  3764,
    1129,  1742,  3766,  2272,  2272,  2272,  1534,  3192,  1193,  2473,
    1162,  1400,  1191,  2170,   497,  1192,  1401,  1533,   498,  1193,
    2358,   661,  1191,  2271,  2271,  1192,  2271,  1834,  1193,  2369,
    1218,  1219,  1220,  1221,  2171,  1189,  1190,  4251,  1191,  2295,
    4255,  1192,  3582,  1307,  1535,  1191,  3916,  4097,  1192,  4098,
    3601,  3602,  1193,   944,  1193,  3801,  3916,  3514,  1193,   590,
    3517,  3518,  1326,  2315,  1358,   558,   609,  2175,   586,  2180,
   -1680,  1189,  1190,  2192,  2271,  2271,  2271,  3530,  2388,  1189,
    1190,   662,  2311,  3933,   663,   609,  3183,  2883,  1503,  1504,
    1189,  1190,  1189,  1190,  3355,  3185,  1315,  3916,  2151,  3916,
    1935,  1189,  1190,  1191,   807,  3605,  1192,  3356,   802,  3916,
    1189,  1190,   591,  3466,   846,  2231, -1680,  3186,   897,  2365,
    3349,  3357,  2098,  1469,  1470,  3916,  4285,  3916,  1191,  3916,
     860,  1192,   914,  3520,  1386,  1835,  3916,  2381,  1742,  2151,
   -1680,  1191,  1193,  1386,  1192,  1191,  3637,  3916,  1192,   868,
    3383,  3384,   564,  4059,  1193,  2557,  2399,  2207,   866,   564,
    1402,  2573,  1527,  3916,  3916,   886,  4351,  1679,   888,  3021,
    3619,  3397,   961,  1189,  1190,  1191,  3041,   878,  1192,  3916,
    3916,  3455,  2502,   592,  3916,   983, -1680,  1189,  1190,   982,
    3045,  1863,  2602,  1191,  2409,  3604,  1192,  2517,  3714,  2626,
    2120,  1226,  3456,  2416,  2417,  1936,  1189,  1190,  1189,  1190,
    2124,  2125,  2626,   849,  2421,  2422,  2423,  2424,  1191,  2432,
    2433,  1192,  1701,   262,  1679,   264,  1191,   991,  1193,  1192,
    1000,  1403,  1011,  3457,  1189,  1190,   914,   915,  2829,  4366,
    1206,  4368,  1191,  3044,  1021,  1192,  1765,   898,  1911,  1766,
    1191,  1040,  1767,  1192,  3934,  1193,  3222,  1679,   619,  3960,
    3961,  3962,  1041,  2337,   619,  1193,  2574,  4386,  1045,   493,
    3046,  2904,  1191,  2144,  1226,  1192,   609,   609,   609,  2597,
    3052,  1193,  2600,  1191,  4172,  1076,  1192,  3233,  1193,   118,
    1191,  1077,  2579,  1192,  1404,   972,  3053,  1191,  3239,  1078,
    1192,  3241,   619,  3060,  2686,  4418,  4419,  4057,  3989,  3990,
    1602,  1189,  1190,  2696,  1080,   619,  1191,  2529,  2530,  1192,
    2537,   899,  2539,  2540,  2541,  2542,  2543,  1081,  1291,  2546,
    1191,  2548,  3991,  1192,  4293,  1191,  2707,  1082,  1192,  2152,
    1226,  1191,  2243,  1085,  1192,  3133,  1193,  2593,  2594,  2595,
    4079,  4080,  3315,  1001,  4083,  4084,  4085,  4086,  4073,  1086,
    2322,  3064,  1087,  1140,  1241,  1241,  1241,  1937,  2323,  3741,
    3742,  1193,  1088,  4367,  3492,  3493,  1226,  1273,  1938,  2154,
    1226,  1089,  3745,  1157,  1193,  1939,  3065,  1090,  1193,  3748,
    1191,  3176,  2569,  1192,  1034,  1035,  1173,  1174,  1229,  3066,
    1702,   914,   915,  3067,  1002,  3566,  1405,   619,  1606,  1091,
    3096,   959,   960, -1479,   963,  3767,  3768,  1945,  1193,  3857,
    3858,  1092,  3860,  3861,  2155,  1638,  1191,   593,  1209,  1192,
    3851,  3852,  2705,  3069,  1191,  1093,  1193,  1192,  1206,   619,
    1406,  2626,  1094,  2793,  2798,  1191,  1581,  1191,  1192,   594,
    1192,  3072,  1274,   619,  4183,  4184,  1191,  1679,  1275,  1192,
    1230,  1193,  1095,  4192,  1245,  1191, -1479,  1096,  1192,  1193,
    1292,  3137,  2167,  1226,  2060,   944,  3077,  1940,  2445,  1272,
    3018,   595,  2324,  2325,  3080,  1193,  2735,  2840,  2626,  2168,
    1226,  1097,  1003,  1193,  2389,  2169,  1226, -1479,  4164, -1479,
    3082,  1098,  1276,  2173,  1226,  1099,  1582,  1607,  3084,  1102,
    2758,  1610,  1104,  1915, -1479,  1193,  2216,  1234,  1611,  1277,
   -1479,  1105,  2326,   619,  2434,  2435,  1193,  1916,  1191,  1280,
    3086,  1192,  1106,  1193,  1583, -1479,  2779,   596,  2781,  1110,
    1193,  3087,  1191, -1479,   619,  1192,   619,   619,  3088,  1111,
   -1479, -1764,  1112,  1206,  1864,  3402,  1864,  1864,  2707,  1193,
   -1479,  1191,  1113,  1191,  1192,  1114,  1192,  1115,  2559,  1941,
    2675,  1226, -1479,  1193,  3403,  1211,  1212, -1479,  1193,  2711,
    2712,  1680,  1116,  3709,  1193,  1270, -1479,  2471,  3404,  1191,
     619,   619,  1192,  3630,  3040,  2125,  3043,  1226,  1612,  3636,
    1117,  1703,  3628,  1584,   900,   901,   902,   903,   904,   905,
     976,   977,  1278,   978,  1118,   979,  1291,  1704,  1512,  1581,
    1119,   906,  2858,  1206,  2390,  1928,  1209,  1205,  2030,  1281,
    2517,  2778,  2870,  1193,  1122,  2517,  4289,  1123,  2880,  1124,
    2517,  2391,  3358,  2274,  2517,  2275,  2879,  1289,  3638, -1479,
    1130,  1614,  2031,  2392,  1131,  2174,  2879,  1132,  2517,  2517,
    2901,   619,  4453,  3521,  3291,  1133,  2912,  1134,  2517,  1193,
    1680, -1479,  2914,  2915,  3070,  1226,  1135,  1193,  1585,  1582,
     609, -1479,  3143,  3144,  3639,  3318,  3319,  1917,  1193,  2879,
    1193,  1290,  3640,  2340,  2341,  2342,  2517,  2936,  1004,  1193,
    1946, -1479,  2954,  3641,  1297,  3711,  1136,  1583,  1193,  2971,
    1137,  1079,  1138, -1479,  3956,  1141,  2846,  1214,  1215,  1216,
    1217,  1218,  1219,  1220,  1221,  1142,  3817,  1299,  3408,  1226,
    2393,  3430,  3431,  2425,  1303,  1513,  2905,  1206,  1581,  1514,
    2061,  1209,  1143,  2881,  2882,  1144,  1741,  3571,  3572,  1241,
    1515,  2913,   118,  1145, -1479,  3608,  3616,  1146,  1292,  1918,
    1147, -1479,  1148,  1005,  1149,  1006,   609,  2517,  1150,  2911,
    4400,  1193,  2060,  1211,  1212,  1151,  1584,  1152,  3390,  1153,
    1961,  1962,  1154, -1479,  1919,  1193,  1155, -1479,  1615,  3632,
    1226,  3646,  1226,  2426,  3661,  3662,  2425,  2953,  1582,  2907,
    2473,  1156, -1479,  1617,  1193,  1311,  1193,  1160, -1479,  3777,
    2435,  1209,  1161,  -768,  -768,  -627,  1964,  1164,  3409,  4403,
    4404,  2427,  3538,  1165, -1479,  -768,  1583,  1171,  3818,  3819,
    2975, -1479,  1193,  3820,  3821,  1175,  1967,  3002, -1479,  1207,
    3792,  3793,  2394,  1176,  1968,  4457,  1920,  1177, -1479, -1764,
    1178,  1585,   119,  3796,  3793,  1179,  2426,  3797,  3793,  1228,
   -1479,  1321,  1208,  3856,  3431, -1479,  1332,  3539,  1970,  1334,
     120,  3859,  3793,  1351, -1479,  1352,  1516,  1353,  3540,  1356,
   -1479,  2737,  1453,  1586,  2427,  1971,  3866,  3867,  1211,  1212,
    2428,  1367, -1479, -1479,  1359,  1584,  2266,  4003,  4004,  1296,
     619,   619,   619,  4008,  3793,  2395,   944,  1368,   609, -2563,
    3946,  3950, -1479,  1976, -1479,  1214,  1215,  1216,  1217,  1218,
    1219,  1220,  1221,  1928,  3541,  1209,  1372,  2735,   619,  4009,
    3793,  1680,  4011,  3793,  1384,  1921,   121, -1479, -1479, -1479,
    4012,  3793, -1479, -1479,  1129,  1034,  1035,   619,   619,   619,
    1587,  4017,  4018,  2428,  4019,  4018,  3875,  4075,  4076, -1479,
    3162,  1393,  3875,  3977,  2626,  2429,  3164,  3587,  3166, -1479,
    1585,  3978,  1394,  1517,   619,  1395,   262,  3613,   264,  3119,
    4203,  4004,  4204,  4004,  1979,  4212,  3431,  1189,  1190,  1864,
    1679,  1742,  1980,  1410,  3542,  3979,  4259,  4260,  4305,  4306,
    2425, -1479,  4323,  3317,  4071,  4445,  4446,  1981,  3808,  3809,
    1669,  1670,  3447,  3448,  3415,  3416,  1413,  1417,   262,   122,
     264,  1210,  2983,  3659,  3660,  1418,  1431,  2425,  2429,  1434,
    1214,  1215,  1216,  1217,  1218,  1219,  1220,  1221,  2061,  1435,
   -1764,  1437,  1442,  1447,  1741,  1453,  2389,  1459,  2517, -1479,
    -785,  2517,  2517,  3538,  2879,  3161,  1586,  1461,  1463,  3946,
    2426,  1982,  1466,  3950,  1557,  1558,  1559,   619,  4074,  1467,
    2517, -1479,  1211,  1212,  1471,  2916,  1474,  2917,  1478,  1983,
    1475,  1479,  1578,  1480,  1521,  2879,  1213,  2426,  2427,  1522,
    1598,  1599,  1600,  1601,  1602,  1523,  2879,  1526,  3539,  2879,
    1528,  1529,  1216,  1217,  1218,  1219,  1220,  1221,  1549,  3540,
    1547,  3980, -1479,  2062,  1641,  2427,  1224,  1645,  2918,  1553,
    1560,  3245,  1580,  1169,   609,  1591,  1626,  1637,  1638,  3302,
    1677,  1639,  1687,  1987,  1745,  1988,  1662,  1663,  1696,  2919,
    1667,  1718,  1712,  1990,   493,   123,  1034,  1035,  3312,  -620,
    2879,  1738,  3543,  1756,  1746,  3541,  1749,  2428,  3544,  1752,
    1681,  1682,  1753,  3228,  1754,  3321,  2445,  3308, -1479,  1755,
    2430,  3231,  1757,  1758,  2920,  1586,  2390,  1759,  2446,  1761,
    3332, -1479,  1762,  4187,  2428,  1785,  1788,   609,  3981,  1603,
    1604,  1605,  1606,  2391,  1679,  3246,  1797,  1805,  3545,  3345,
   -1479,  1806, -1479,  1807,   944,  2392,  3982,  1812,  4071,  1808,
    1815,  1996,  1816,   124,  1214,  1215,  1216,  1217,  1218,  1219,
    1220,  1221,  3946,  3950,  1817,  1840, -1479, -1479,  1826,  3983,
   -1479, -1479,  2429,  2430,  4118,  1831,  1873,  1358,  3452,  1109,
    1159,  1163,  1844,  1874,   673, -2563,  1875,  1876,  1206,   262,
    1878,   264,  1887,  1889,  2840,  1891,  1904,  2063,  3334,  2429,
    1913,  2017,  1196,  1197,  1510,  3877,  3546,  3324,  1997,  2034,
    2612,   125,  2035,  2036,  2037,  -620,  2038,  3407,  2039,  2054,
     504,  -785,  2393,  2040,  1998,  2779,  2041,  2042,  1999,  1742,
    2043,  1607,  2044,  1608,  1609,  1610,  2613,  1198,  2045,  2046,
    3837,  2047,  1611,  2048,  3691,  3827,  4310,  2000,  1199,  2735,
    1961,  1962,  2049,  2050,   804,   805,  2030,  2051,   808,   809,
    2555,   673,   811,  2052,   813,  2002,  3717,  2053,  2758,  3442,
    2056,  2074,   619,   700,  2075,  2092,  2082,  2095, -2563,  1581,
    2031,   619,  1191,  -768,  -768,  1192,  1964,  2705,  1200,  2093,
    2094,  2614,  2101,  2143,  2615,  -768,  2389,   619,  2107,  2109,
    1201,  2110,  2616,  2111,  2134,  2358,  1967,  2135,  3547,  2136,
    2921,   563,  3918,  2145,  1968,  2141,  2142,  1034,  1035,  2617,
    2778,  2151,  1612,  3543,  3010,  1680,   704,  1202,  2156,  3544,
    2160,  2164,  4020,   705,  2394,   944,  2181,  2517,  1970,  1582,
    2190,  2182,  2187,  3717,  2191,  2202,  4310,  2517,  2203,  2879,
     700,  3984,  1453,  -620,  2922,  1971,  2204,  2217,  1680,  3253,
    2224,   709,   710, -1168,  2879,  2230,   609,  2947,  2517,  3545,
    2445,  1221,  2240,  2262,  1613,  1614,  1209,  2430,  2269,  1679,
    2626, -1305,  2446,  1976,  2287,  1203,  2302,  3988,  2296,  2305,
    2308,  2338,  2339,  4438,  2366,  2354,  2368,  2395,  2370,  2371,
    2375,  2398,  1679,   704,  2430,  2276,  2397,  2401,  1206,  1679,
     705,  2402,  2404,  2408,  3367,  1679,  4449,  3368,  2618,  4315,
    4316,  2410,  4318,  4438,  2411,  3369,  2390,  2277,  -620,  4449,
     718,  2415,  2445,  2412,  2466,  2467,  2948,  3546,   709,   710,
    2278,  2971,  3370,  2391,  2413,  2414,   262,  2457,   264,  2462,
    2469,  2279,   522,  2476,  1979,  2392,   818,  2479,  2463,  2486,
     865,  2485,  1980,  2470,  1247,  1206,  3600,  3600,  3600,  2478,
    3680,  1864,   800,  4359,  2491,  4360,  4361,  1981,  2106,  -620,
    2492,  2497,  2525,   619,   504,  3371,  2498,  2505,  2527,   729,
    2558,  2582,  2580,  2598,  2602,  2521,  2606,  1248,  2611,  2637,
    3751,  2280,  2638,  2281,   733,   734,  2649,   718,  2639,   523,
    2248,  2949,  1615,  2702,  2683,  2650,  2662,  2681,  2619,   507,
    2030,  2716,  2692,  1211,  1212,  1193,  1616,  1617,  2684,  3568,
    2282,  1982,  2393,  4397,  4158,  2685,   524,  2701,  2714,  3547,
    2715,  3372,  3988,  2717,  2031,  1244,   819,  2727,  2718,  1983,
    2730,  2731,  3592,  3669,  3695,  2729,  2724,  2738,  1680,  2742,
    2840,  2744,  2739,  4430,  2159,  1249,   729,  3061,  2163,  2760,
    1792,   525,  2743,   619,  2748,   820,  2761,  2763,  2764,  2765,
    2346,   733,   734,  2345,  2782,  2783,  2784,  2805,   821,  1250,
    2186,  2283,  2808,  1251,  2812,  2817,  1209,  2818,  -620,  2835,
    2842,  2819,  2843,  1987,  2886,  1988,  2945,  2888,  2964,  2966,
    2980,   822,  2981,  1990,   823,  3600,  3726,  2960,  2985,   526,
    2989,  1989,  2990,   800,  1906,   824,  3015,  1252,   800,  3024,
    4160,  3029,  3731,  3837,  2626,  2102,  3035,  3037,  3373,  3104,
    3093,  3374,  3038,  3039,  2394,  2284,   825,  1253,  3047,  3048,
    3091,  3095,  3100,  1209,  3103,  3109,  3114,  3116,  2620,  3121,
    3124,  1254,  1313,   619,  3142,   800,  1215,  1216,  1217,  1218,
    1219,  1220,  1221,   826,  3128,  3125,  3145,  3148,  2447,  3139,
     827,  1996,   800,  3160,  3159,  3165,  3173,   753,  3193,  3769,
    3198,  3718,  -620,  3197,  3719,  3213,  3773,  3303,  3201,  3214,
    3212,  3310,  3452,  3314,  3225,   759,  3234,  2395,  3333,  1255,
     761,  3242,  3320,   762,  3332,  1206,  2950,  3243,  3375,  3244,
     828,  3306,  2621,   800,   800,   800,   800,  3317,  3309,  3327,
    3328,  1256,  3316,  -443,  3336,   800,  2322,   619,  1997,  3342,
     -65,  3343,  3344,  1211,  1212,   527,  3347,  3364,  3385,  3382,
    3386,  2622,  3393,  3411,  1998,  3394,  3412,  3421,  1999,  3750,
    3423,  3426,  3432,  3445,   753,  3453,  3434,  3461,  3718,  3720,
    3721,  3719,  3462,  3470,  3471,  3483,  3494,  2000,  3495,  3491,
    3508,  3515,   759,   507,  2519,  3565,  3567,   761,  4158,  3569,
     762,  3575,  3588,  3579,  3589,  2002,  3590,  3593,  3778,  3594,
    1211,  1212,  3596,  3606,  3607,   619,  3608,  3609,  3610,  3614,
    1247,  3617,  3620,   528,  3622,  3624,   800,  3633,  3625,  3626,
    3629,  3634,  3635,  3849,  3647,  3648,  3664,  3657,  3674,  3163,
    3682,  3665,  3676,  1257,  3662,  3677,  3600,  3600,  3681,  3600,
    3600,  3685,  1258,  1248,  3687,  3376,  3720,  3721,   829,  3688,
    3732, -1394,  2583, -1399,  3555,  3699,  3754,  1259,  2626,  3712,
    3713,  3755,  -620,  3729,  3715,  3716,  3740,  3988,   831,  3744,
    3756,   529,  3757,  3746,  3377,  1260,   832,   530,  3758,  3760,
    3761,  3558,  3779,  3798,   833,  3780,  3884,  1216,  1217,  1218,
    1219,  1220,  1221,  4427,  4355,  3802,   531,  3806,  3807,  3795,
    3799,  3810,  3616,  1209,  3830,  3923,   609,  3825,  3812,   834,
    3813,  1249,  3814,  3826,  1261,  1262,  3829,  3600,  3845,  3847,
    3840,   532,   835,   836,  3865,  3841,  1336,  4427,  3871,  3878,
    3885,  3879,  3880,  3927,  3919,  1250,  1337,  3942,   533,  1251,
    1263,  3952,  1214,  1215,  1216,  1217,  1218,  1219,  1220,  1221,
     609,  3953,  1338,  3974,  3954,  3957,  3959,  4005,  3967,  4023,
    3970,   619,  1264,  4355,  1339,  1340,  1341,   837,  4000,  4041,
    4043,  4050,   800,  1252,  -309,  4002,  4013,  3924,  4044,  4062,
    1342,  3883,  4066,  4054,  4061,  4081,  4082,  4078,  4087,  4090,
    4092,  4014,  4094,  1253,  2940,  -327,  4126,  4152,   838,  4120,
    4153,  4123,  4154,  4177,  4171,  4174,  4201,  1254,  4189,  4205,
    4206,  1265,  4027,  4213,  4226,  4227,  4207,  4034,  4208,  4216,
     839,  3968,   840,  4217,  4237,  4238,  4231,   800,   800,  4239,
    4242,  4249,  4263,  4455,  4264,  4265,   800,   800,   800,   800,
     800,   800,   800,   800,   800,   800,   800,   800,   800,  4266,
    1211,  1212,  4274,  4281,  4275,  1255,   800,   800,  4286,   800,
    4288,   800,  4290,  4291, -2299,   800,  4300,  4294,   800,   800,
     800,   800,  4303,   800,   800,   800,  4314,  1256,  4317,  4319,
    4320,  4322,   800,   800,  4346,   800,   800,   800,   800,   800,
    4327,  1680,   800,   800,   800,   800,   800,   800,   800,   800,
     800,   800,   800,   503,  4333,   800,   800,  4188,  4349,   800,
    4352, -1563,  4347,   800,  4363,   800,   800,  4364,  4369,  4365,
    4377,  4370,  4383,  4380,  3849,  4382,  3849,  4374,  4099,   800,
     800,  4385,  4389,  4391,  4394,  4395,  4402,   800,  1598,  1599,
    1600,  1601,  1602,  4398,   800,   800,   800,  4406,   800,  4408,
    4415,  4439,  4056,  4416,  4127,   800,   800,   800,  4443,   800,
     800,   800,   800,   800,  4452,   800,   800,   800,   800,   800,
     800,   800,   800,  4036,  3577,  2709,   800,   800,  3578,  1257,
    2550,  2850,  1057,  4168,  3783,  4051,   504,  4161,  1258,  4301,
    1343,  4302,  1214,  1215,  1216,  1217,  1218,  1219,  1220,  1221,
    3974,  3781,  3785,  1259,  1465,  4450,  3922,  1344,  4410,   577,
     619,   956,  3147,  2707,  2330,  4420,  4194,  4230,  3896,  3897,
    3899,  1260,  -816,  3900,  3902,  4330,  1958,  4224,  3903,  3904,
    3905,  3906,  4230,  1959,  3907,  1960,  4331,  1603,  1604,  1605,
    1606,  3910,  4299,  3911,  3912,  4240,  1961,  1962,  4236,  4235,
    1525,  2251,  1957,   800,  2509,  4053,  2003,  3127,  2028,  3238,
    1261,  1262,  3667,  3132,  1795,  3425,  3969,  4248,  4176,  3670,
     505,  4379,  4313,  4354,  4089,  2059,   660,  1963,  4167,  4312,
    3789,  2507,  1964,  1965,  3325,  3507,  1263,  2514,  3008,  1966,
    2942,  3496,  4328,  4021,  3379,  1680,  3873,  3500,  4181,  4182,
    3523,  3564,  1967,  3759,  4173,   497,  3749,  3459,  1264,   498,
    1968,  4105,   518,   800,   519,  4210,   619,  2091,  4211,  4058,
    1969,   800,  4064,  4063,  2592,  3941,  3876,  2511,  3498,  1083,
    2930,  2971,  2971,  1345,  1970,  1009,  2386,  1890,  3728,  1607,
    2745,  1608,  1609,  1610,  2057,  1433,  3497,  2314,  1453,  3118,
    1611,  1971,  2766,  3422,  2725,  2026,  2680,  1265,  1972,  1973,
    3917,   980,  2344,  1363,  3410,  1974,  1121,  2627,  3102,  2629,
    2830,  4230,  1636,  1975,  3467,  2679,  4007,  -891,  4272,  1976,
    3853,  4345,   619,  1139,  3576,  4273,  2699,  3184,  1346,  3502,
    1579,  3850,  2925,  1907,  4401,  3839,  2773,  2596,  2723,  3672,
    2751,  3438,  4256,  4257,  3437,  3477,  1347,  1779,  1977,  4245,
     968,  4335,  2100,  1810,  1075,  1856,   952,  2377,  4343,  1879,
    2378,  3506,  2263,  2016,  1814,  3424,  4350,  1183,  4378,  4267,
    1612,  4321,  4454,  4451,  4376,   817,   818,  3753,  3441,  3181,
    2355,  3463,   262,  3686,   264,  3842,  2301,  1821,  1978,  1829,
    1979,   893,  4230,  1350,  4230,  3958,  4444,  1772,  1980,  3966,
    3106,  4396,  1355,   895,   506,  2081,   654,   655,  1061,  1062,
    1063,     0,  4230,  1981,     0,     0,     0,     0,     0,     0,
       0,     0,  1613,  1614,     0,   507,     0,     0,     0,  4387,
       0,     0,     0,     0,  4392,  4326,     0,     0,     0,     0,
       0,     0,     0,     0,  4230,  4230,     0,     0,     0,  4442,
       0,   800,     0,     0,     0,     0,     0,  1312,     0,     0,
       0,     0,   508,     0,     0,  -535,   819,  1982,   509,     0,
       0,  4428,     0,     0,     0,     0,     0,     0,     0,     0,
    1680,     0,     0,     0,     0,  1983,     0,     0,     0,  1984,
       0,     0,     0,     0,     0,   820,     0,     0,     0,   619,
       0,     0,     0,  1680,   510,  4428,     0,     0,   821,     0,
    1680,     0,   511,     0,     0,     0,  1680,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1985,     0,     0,
       0,   822,  1986,     0,   823,     0,     0,     0,     0,  1987,
       0,  1988,     0,     0,     0,   824,     0,     0,  1989,  1990,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1615,     0,     0,   800,   800,   800,   825,     0,     0,     0,
       0,     0,     0,     0,  1616,  1617,     0,   800,     0,     0,
    1991,  1487,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   826,  1992,  1993,  1994,  1995,     0,     0,
     827,     0,     0,   800,     0,     0,     0,     0,     0,   800,
       0,     0,   800,  1486,   800,     0,     0,  1996,     0,     0,
     800,     0,   800,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     828,  1488,  1489,  1490,  1491,  1492,  1493,     0,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,     0,  1501,  1502,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,  1997,     0,     0,  1562,  1563,     0,
       0,  1566,  1567,  1568,  1571,  1572,  1573,  1574,  1575,  1576,
    1998,     0,     0,   800,  1999,     0,     0,  1592,  1593,     0,
    1594,     0,  1595,     0,     0,     0,     0,     0,     0,  1628,
    1629,  1630,  1631,  2000,     0,  1634,     0,     0,  2001,     0,
       0,     0,     0,  1642,  1643,     0,  1646,  1647,     0,     0,
       0,  2002,     0,  1651,  1652,  1653,     0,     0,  1656,  1657,
    1658,  1659,  1660,  1661,     0,     0,  1664,  1665,     0,     0,
    1668,     0,     0,     0,  1671,     0,  1675,  1676,   890,   818,
       0,     0,     0,     0,     0,     0,     0,     0,   829,     0,
    1683,  1684,   830,     0,     0,     0,     0,     0,  1692,     0,
       0,     0,     0,  1503,  1504,  1697,  1698,  1699,   831,     0,
       0,     0,     0,     0,  -891,     0,   832,     0,     0,     0,
       0,     0,     0,     0,   833,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1735,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   834,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   835,   836,     0,     0,     0,     0,     0,   819,
       0,     0,     0,     1,     0,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     3,     0,     0,     0,     4,     0,     0,   820,     0,
       0,     0,     0,     0,     0,     0,     0,   837,     0,     5,
       6,   821,     0,     0,  1782,     0,  2016,     7,     0,     0,
       0,     0,     8,     9,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   822,     0,     0,   823,   838,     0,
       0,     0,     0,     0,    10,     0,   800,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     839,     0,   840,    11,     0,     0,     0,     0,     0,   825,
       0,     0,     0,     0,  1828,     0,     0,     0,     0,     0,
       0,     0,  1843,     0,    12,     0,     0,     0,     0,     0,
       0,     0,    13,    14,    15,     0,   826,     0,     0,  2016,
       0,     0,     0,   827,    16,    17,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   800,     0,    18,     0,   800,
       0,     0,     0,     0,   800,   800,     0,     0,     0,     0,
       0,    19,     0,   800,   800,     0,   800,   800,   800,   800,
       0,   800,     0,   828,   800,     0,     0,    20,     0,     0,
       0,     0,     0,     0,   800,     0,   800,   800,     0,   800,
     800,   800,   800,    21,   800,     0,     0,   800,    22,     0,
       0,     0,    23,     0,     0,     0,   800,     0,     0,     0,
       0,     0,     0,   800,     0,   800,     0,   800,   800,   800,
     800,     0,     0,     0,   800,   800,   800,    24,     0,    25,
     800,   800,   800,     0,   800,     0,   800,     0,   800,     0,
     800,     0,   800,     0,     0,    26,     0,   800,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,     0,   800,     0,    28,     0,     0,
       0,     0,   800,     0,     0,   800,     0,     0,     0,     0,
       0,   800,     0,     0,   800,     0,     0,     0,   800,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   829,  2112,     0,     0,   891,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   831,     0,     0,     0,     0,     0,     0,     0,   832,
       0,     0,     0,     0,     0,     0,     0,   833,     0,     0,
       0,     0,     0,     0,   800,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    29,     0,     0,
       0,     0,   834,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,   835,   836,     0,    31,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    32,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2194,  2196,  2198,     0,     0,     0,
     837,     0,    34,     0,     0,    35,     0,    36,     0,     0,
      37,     0,     0,    38,    39,     0,     0,  2928,     0,     0,
       0,    40,     0,    41,  1959,     0,     0,     0,     0,     0,
      42,   838,     0,     0,  2232,     0,    43,  1961,  1962,     0,
       0,     0,     0,  2237,    44,  2238,     0,     0,     0,    45,
       0,    46,     0,   839,    47,   840,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1963,     0,
       0,     0,     0,  1964,     0,     0,     0,     0,     0,    48,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1967,     0,     0,     0,     0,  1961,  1962,
       0,  1968,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1969,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2310,  1970,     0,     0,    50,  2016,
       0,  -768,  -768,     0,  1964,     0,     0,     0,     0,  1453,
      51,     0,  1971,  -768,    52,     0,     0,    53,     0,  1972,
       0,     0,     0,    54,  1967,     0,  2929,     0,     0,     0,
       0,     0,  1968,     0,  1975,     0,     0,     0,     0,     0,
    1976,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,  1970,     0,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    57,  1977,
    1453,     0,     0,  1971,     0,     0,     0,     0,  2016,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1961,  1962,     0,     0,   800,     0,     0,     0,   800,
       0,  1976,     0,   262,     0,   264,     0,     0,     0,     0,
       0,  1979,     0,     0,     0,     0,     0,     0,     0,  1980,
       0,     0,     0,     0,     0,     0,     0,  1964,     0,   800,
     800,     0,     0,     0,  1981,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1967,     0,   800,
       0,     0,     0,     0,     1,  1968,     2,     0,   800,     0,
     800,     0,   800,     0,   262,     0,   264,     0,     0,     0,
       0,     0,  1979,     0,     0,     0,     4,     0,     0,  1970,
    1980,     0,   800,     0,     0,     0,     0,   800,  1982,     0,
       5,     6,     0,  1453,     0,  1981,  1971,     0,     7,     0,
       0,     0,     0,     8,     9,     0,  1983,     0,     0,     0,
    1984,   800,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1976,    10,     0,  2526,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    11,     0,     0,     0,     0,  1982,
       0,     0,     0,  1986,     0,     0,     0,     0,     0,     0,
    1987,     0,  1988,     0,     0,    12,     0,  1983,     0,     0,
    1990,     0,     0,    13,    14,    15,   800,     0,     0,     0,
     800,     0,     0,     0,     0,    16,    17,   262,     0,   264,
       0,     0,     0,     0,     0,  1979,  2605,     0,     0,     0,
    2607,     0,     0,  1980,     0,  2609,  2610,     0,     0,     0,
       0,     0,    19,     0,  1568,  2628,  1993,  1568,  1981,  2631,
    2632,  1987,  2633,  1988,     0,     0,     0,   800,    20,     0,
       0,  1990,     0,     0,     0,  2640,     0,  2641,  1996,     0,
    2643,  2644,  2645,  2646,    21,  2647,     0,     0,     0,    22,
       0,     0,     0,    23,     0,     0,     0,  2651,     0,     0,
       0,     0,     0,     0,  2652,     0,  2653,     0,  2654,  2655,
    2656,     0,  1982,     0,     0,  2659,  2660,  2661,    24,     0,
      25,  2663,  2664,  2665,     0,  2666,     0,  2668,     0,  2670,
    1983,  2672,     0,  2673,     0,  1997,    26,     0,  2674,  1996,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1998,     0,     0,    27,  1999,  2687,     0,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2697,     0,  2000,  2700,     0,     0,     0,     0,
       0,     0,     0,     0,  1987,     0,  1988,     0,   800,   800,
       0,     0,  2002,     0,  1990,     0,  1997,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1998,     0,     0,     0,  1999,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2000,     0,     0,     0,     0,
       0,  2016,     0,     0,     0,     0,     0,     0,    29,     0,
       0,     0,     0,  2002,   800,     0,     0,     0,     0,     0,
       0,     0,  1996,     0,     0,    30,     0,     0,     0,    31,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      32,     0,     0,     0,     0,     0,     0,   800,   800,     0,
     800,    33,     0,     0,     0,     0,     0,     0,     0,   800,
       0,     0,     0,     0,   800,     0,     0,   800,     0,   800,
     800,     0,     0,    34,     0,     0,    35,     0,    36,  1997,
       0,    37,     0,     0,    38,    39,     0,     0,     0,     0,
     800,     0,    40,     0,    41,  1998,     0,     0,     0,  1999,
       0,    42,     0,     0,     0,   800,     0,    43,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,  2000,     0,
      45,     0,    46,     0,     0,    47,     0,     0,     0,   800,
       0,     0,     0,     0,     0,     0,  2002,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,     0,     0,     0,    49,     0,     0,     0,     0,   800,
       0,  3247,  3248,     0,     0,     0,     0,  3249,     0,  3250,
       0,  3251,  3252,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3253,     0,
       0,     0,     0,     0,   800,     0,     0,     0,     0,    50,
       0,     0,     0,   800,     0,     0,     0,     0,     0,     0,
       0,    51,     0,     0,     0,    52,     0,     0,    53,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3254,     0,     0,  3255,   912,     0,     0,
       0,     0,     0,    55,  3256,     0,     0,   869,   913,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    57,
       0,  3257,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   914,   915,     0,  3554,     0,     0,  3258,     0,
     916,     0,     0,     0,     0,   917,  3020,     0,     0,     0,
    3022,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3259,     0,  3260,     0,     0,     0,     0,     0,
       0,     0,   918,     0,   919,     0,   920,  3261,  3262,     0,
    3050,  3051,     0,     0,     0,   921,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3071,     0,     0,     0,     0,     0,     0,     0,     0,  3081,
       0,  3083,     0,  3085,     0,     0,     0,     0,     0,     0,
    3263,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1764,   922,     0,     0,     0,     0,   923,     0,     0,
     924,     0,     0,     0,     0,     0,     0,     0,     0,  3264,
       0,     0,     0,     0,     0,     0,     0,     0,  3265,  3266,
       0,  3267,  3115,     0,     0,     0,   925,     0,   926,     0,
       0,     0,     0,     0,     0,   927,   800,   928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3268,  3269,  3270,     0,     0,     0,     0,     0,     0,
       0,     0,   929,   930,   931,     0,     0,     0,     0,     0,
    3271,  3272,  3273,     0,     0,   800,   800,  3274,     0,     0,
    3275,     0,     0,     0,   800,   932,     0,  3171,     0,     0,
       0,  3175,     0,     0,     0,     0,  3276,  3277,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   933,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3278,  3279,   934,     0,     0,     0,  3207,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3554,     0,     0,     0,     0,     0,  3280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2016,     0,     0,   935,
       0,     0,     0,     0,     0,     0,     0,     0,  3281,     0,
       0,     0,  3282,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3283,   936,     0,     0,   800,     0,
       0,     0,   800,     0,     0,     0,   937,   938,     0,     0,
     939,   940,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3304,
    3305,   941,     0,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   800,  3284,     0,
       0,  3285,     0,     0,  3286,  3287,  3288,  3289,     0,     0,
     800,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   942,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   943,     0,     0,
       0,     0,     0,     0,     0,  3350,     0,     0,  3290,  3291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2329,     0,     0,     0,   944,     0,     0,
       0,     0,     0,     0,  3292,     0,     0,     0,  3388,  3389,
       0,     0,     0,     0,     0,   945,   946,     0,     0,     0,
    3396,     0,     0,  3914,     0,  3398,     0,     0,  3399,     0,
    3400,  3401,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3940,     0,     0,     0,  3940,  3940,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   947,     0,  3418,     0,     0,     0,
       0,     0,     0,     0,     0, -2329,     0,     0,   800,     0,
       0,     0,     0,   948,     0,     0,   800,     0,     0,     0,
    3418,     0,     0,     0,     0,   800,     0,   800,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3464,     0,   800,     0,     0,     0,
       0,     0,  3914,  3914,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3418,     0,     0,     0,     0,
       0,     0,     0,     0,  3488,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3940,     0,     0,
       0,     0,     0,     0,     0,     0,  3940,     0,     0,     0,
    3940,     0,     0,     0,     0,   800,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   800,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3940,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   800,     0,   800,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   800,     0,  3914,  3914,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4169,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3940,     0,  3940,
    3940,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     800,     0,  3914,     0,     0,     0,     0,  3418,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3914,   800,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3914,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   800,     0,     0,  3697,  3698,     0,     0,
       0,     0,     0,     0,     0,  3207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   800,  3914,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3914,  3914,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3914,     0,     0,     0,
       0,     0,     0,   800,     0,     0,  3914,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3207,
     800,     0,     0,  3805,     0,     0,     0,  3914,     0,  3914,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3914,
       0,     0,     0,   800,     0,     0,   800,     0,     0,     0,
       0,     0,     0,     0,  3418,  3914,     0,  3914,     0,  3914,
       0,     0,     0,     0,     0,     0,  3914,     0,  3207,     0,
       0,     0,     0,     0,     0,     0,     0,  3914,     0,     0,
       0,  3171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3914,  3914,     0,     0,     0,     0,   800,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3914,
    3914,     0,     0,     0,  3914,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   800,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3994,     0,     0,
       0,     0,     0,     0,     0,     0,  3999,     0,  4001,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4022,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4121,     0,  4122,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4130,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4233,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3418,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     139,     0,   669,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,  4284,     0,   670,     0,   148,   149,
     150,   151,   152,   671,   154,     0,   155,     0,     0,   672,
     156,   673,   674,   675,   157,   676,     0,   158,   159,   160,
    1672,   161,     0,   162,   163,     0,     0,   164,   677,   678,
     165,   166,     0,   167,   679,   680,   169,   170,     0,   171,
     172,   173,   174,   175,   681,   177,     0,   682,   179,   683,
     684,   685,   686,   687,   688,     0,   186,   187,   188,   189,
     190,   191,   192,   193,  4337,   194,   195,     0,   196,   197,
     198,   689,   200,     0,   201,   690,   691,   202,     0,     0,
     203,   692,   693,     0,   204,   694,   695,     0,   205,   206,
     207,   696,   697,   698,     0,     0,     0,     0,   699,   210,
     700,  4362,     0,   701,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,  4381,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,   702,     0,   236,
     237,   238,   703,   704,   239,   240,     0,   241,   242,   243,
     705,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   706,   251,   707,   253,     0,   254,
    4429,   708,     0,   255,   256,   257,     0,   258,   709,   710,
       0,   259,   260,     0,     0,     0,   711,   262,   263,   264,
     712,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,   713,   270,   271,   714,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,  3418,   277,     0,
       0,   278,   279,   715,     0,  1673,   281,     0,   716,   282,
     283,     0,     0,     0,     0,     0,   717,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   718,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,   719,
     306,   307,   308,   309,   720,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   721,   317,     0,     0,   722,
     319,   723,   320,     0,   321,   724,   725,   726,   727,   728,
     326,   327,   328,   329,   330,     0,   729,   331,   332,     0,
       0,   333,   334,   335,   336,   730,   731,   732,   337,   338,
       0,   733,   734,     0,   339,   340,   735,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,   736,   351,     0,
     352,   353,   354,   355,   737,   357,   358,   359,   360,   738,
     739,   363,   740,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   741,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,   742,   743,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,   744,   398,   399,
     400,   401,   402,   745,   404,   405,   406,   407,     0,   746,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   747,   748,   433,   434,
       0,   435,   436,   749,   438,   439,   440,   750,   751,   441,
     442,   443,   444,   752,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,   753,   452,   453,     0,   754,   755,
     756,   757,     0,     0,     0,     0,  1674,   458,   459,   460,
       0,   758,   759,   760,   462,   463,   464,   761,   465,   466,
     762,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   763,   475,   476,     0,     0,
     764,   765,   766,   767,   477,     0,     0,   478,   768,     0,
     769,   479,   480,   481,   482,   483,   770,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   771,     0,     0,     0,     0,   772,   773,     0,     0,
       0,     0,   774,   775,     0,     0,   776,   777,     0,     0,
     778,   779,   139,     0,   669,   141,   142,   143,   144,  3167,
       0,   145,     0,     0,     0,   146,     0,     0,   670,     0,
     148,   149,   150,   151,   152,   671,   154,     0,   155,     0,
       0,  3168,   156,   673,   674,   675,   157,   676,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
     677,   678,   165,   166,     0,   167,   679,   680,   169,   170,
       0,   171,   172,   173,   174,   175,   681,   177,     0,   682,
     179,   683,   684,   685,   686,   687,   688,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   689,   200,     0,   201,   690,   691,   202,
       0,     0,   203,   692,   693,     0,   204,   694,   695,     0,
     205,   206,   207,   696,   697,   698,     0,     0,     0,     0,
     699,   210,   700,     0,     0,  3169,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,   702,
       0,   236,   237,   238,   703,   704,   239,   240,     0,   241,
     242,   243,   705,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   706,   251,   707,   253,
       0,   254,     0,   708,     0,   255,   256,   257,     0,   258,
     709,   710,     0,   259,   260,     0,     0,     0,   711,   262,
     263,   264,   712,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,   713,   270,   271,   714,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   715,     0,     0,   281,     0,
     716,   282,   283,     0,     0,     0,     0,     0,   717,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   718,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,   719,   306,   307,   308,   309,   720,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   721,   317,     0,
       0,   722,   319,   723,   320,     0,   321,   724,   725,   726,
     727,   728,   326,   327,   328,   329,   330,     0,   729,   331,
     332,     0,     0,   333,   334,   335,   336,   730,   731,   732,
     337,   338,     0,   733,   734,     0,   339,   340,   735,  3170,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   737,   357,   358,   359,
     360,   738,   739,   363,   740,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   741,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,   742,   743,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,   744,
     398,   399,   400,   401,   402,   745,   404,   405,   406,   407,
       0,   746,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,   747,   748,
     433,   434,     0,   435,   436,   749,   438,   439,   440,   750,
     751,   441,   442,   443,   444,   752,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   753,   452,   453,     0,
     754,   755,   756,   757,     0,     0,     0,     0,     0,   458,
     459,   460,     0,   758,   759,   760,   462,   463,   464,   761,
     465,   466,   762,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   763,   475,   476,
       0,     0,   764,   765,   766,   767,   477,     0,     0,   478,
     768,     0,   769,   479,   480,   481,   482,   483,   770,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   771,     0,     0,     0,     0,   772,   773,
       0,     0,     0,     0,   774,   775,     0,     0,   776,   777,
       0,     0,   778,   779,   139,     0,   669,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     670,     0,   148,   149,   150,   151,   152,   671,   154,     0,
     155,     0,     0,   672,   156,   673,   674,   675,   157,   676,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,   677,   678,   165,   166,     0,   167,   679,   680,
     169,   170,     0,   171,   172,   173,   174,   175,   681,   177,
       0,   682,   179,   683,   684,   685,   686,   687,   688,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   689,   200,     0,   201,   690,
     691,   202,     0,     0,   203,   692,   693,     0,   204,   694,
     695,     0,   205,   206,   207,   696,   697,   698,     0,     0,
       0,     0,   699,   210,   700,     0,     0,   701,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,   702,     0,   236,   237,   238,   703,   704,   239,   240,
       0,   241,   242,   243,   705,     0,   244,     0,     0,     0,
     245,  2193,   246,     0,   247,     0,   248,   249,   706,   251,
     707,   253,     0,   254,     0,   708,     0,   255,   256,   257,
       0,   258,   709,   710,     0,   259,   260,     0,     0,     0,
     711,   262,   263,   264,   712,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,   713,   270,   271,   714,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   715,     0,     0,
     281,     0,   716,   282,   283,     0,     0,     0,     0,     0,
     717,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,   718,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,   719,   306,   307,   308,   309,   720,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   721,
     317,     0,     0,   722,   319,   723,   320,     0,   321,   724,
     725,   726,   727,   728,   326,   327,   328,   329,   330,     0,
     729,   331,   332,     0,     0,   333,   334,   335,   336,   730,
     731,   732,   337,   338,     0,   733,   734,     0,   339,   340,
     735,     0,   342,   343,   344,   345,     0,   346,   347,     0,
       0,     0,     0,     0,     0,     0,     0,   348,   349,   350,
       0,   736,   351,     0,   352,   353,   354,   355,   737,   357,
     358,   359,   360,   738,   739,   363,   740,     0,   364,   365,
     366,     0,   367,     0,   368,   369,   370,   371,   372,     0,
     741,   374,   375,     0,     0,   376,     0,     0,     0,   377,
     378,   379,   380,   381,     0,     0,   382,   383,   384,   385,
     386,     0,   387,   388,     0,   389,   390,   391,   742,   743,
     392,     0,   393,     0,   394,   395,     0,   396,   397,     0,
       0,   744,   398,   399,   400,   401,   402,   745,   404,   405,
     406,   407,     0,   746,   409,     0,     0,     0,   410,   411,
     412,   413,     0,     0,     0,   414,     0,     0,     0,   415,
       0,   416,   417,   418,   419,     0,   420,   421,   422,   423,
     424,   425,     0,     0,     0,     0,     0,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     747,   748,   433,   434,     0,   435,   436,   749,   438,   439,
     440,   750,   751,   441,   442,   443,   444,   752,   445,   446,
       0,   447,     0,   448,   449,   450,   451,     0,   753,   452,
     453,     0,   754,   755,   756,   757,     0,     0,     0,     0,
       0,   458,   459,   460,     0,   758,   759,   760,   462,   463,
     464,   761,   465,   466,   762,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   763,
     475,   476,     0,     0,   764,   765,   766,   767,   477,     0,
       0,   478,   768,     0,   769,   479,   480,   481,   482,   483,
     770,     0,     0,     0,     0,     0,     0,   485,   486,     0,
     487,   488,   489,     0,     0,   771,     0,     0,     0,     0,
     772,   773,     0,     0,     0,     0,   774,   775,     0,     0,
     776,   777,     0,     0,   778,   779,   139,     0,   669,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   670,     0,   148,   149,   150,   151,   152,   671,
     154,     0,   155,     0,     0,   672,   156,   673,   674,   675,
     157,   676,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,   677,   678,   165,   166,     0,   167,
     679,   680,   169,   170,     0,   171,   172,   173,   174,   175,
     681,   177,     0,   682,   179,   683,   684,   685,   686,   687,
     688,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   689,   200,     0,
     201,   690,   691,   202,     0,     0,   203,   692,   693,     0,
     204,   694,   695,     0,   205,   206,   207,   696,   697,   698,
       0,     0,     0,     0,   699,   210,   700,     0,     0,   701,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,   702,     0,   236,   237,   238,   703,   704,
     239,   240,     0,   241,   242,   243,   705,     0,   244,     0,
       0,     0,   245,  2195,   246,     0,   247,     0,   248,   249,
     706,   251,   707,   253,     0,   254,     0,   708,     0,   255,
     256,   257,     0,   258,   709,   710,     0,   259,   260,     0,
       0,     0,   711,   262,   263,   264,   712,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,   713,   270,
     271,   714,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   715,
       0,     0,   281,     0,   716,   282,   283,     0,     0,     0,
       0,     0,   717,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,   718,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,   719,   306,   307,   308,   309,
     720,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   721,   317,     0,     0,   722,   319,   723,   320,     0,
     321,   724,   725,   726,   727,   728,   326,   327,   328,   329,
     330,     0,   729,   331,   332,     0,     0,   333,   334,   335,
     336,   730,   731,   732,   337,   338,     0,   733,   734,     0,
     339,   340,   735,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,   736,   351,     0,   352,   353,   354,   355,
     737,   357,   358,   359,   360,   738,   739,   363,   740,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   741,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
     742,   743,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,   744,   398,   399,   400,   401,   402,   745,
     404,   405,   406,   407,     0,   746,   409,     0,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,   747,   748,   433,   434,     0,   435,   436,   749,
     438,   439,   440,   750,   751,   441,   442,   443,   444,   752,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
     753,   452,   453,     0,   754,   755,   756,   757,     0,     0,
       0,     0,     0,   458,   459,   460,     0,   758,   759,   760,
     462,   463,   464,   761,   465,   466,   762,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   763,   475,   476,     0,     0,   764,   765,   766,   767,
     477,     0,     0,   478,   768,     0,   769,   479,   480,   481,
     482,   483,   770,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   771,     0,     0,
       0,     0,   772,   773,     0,     0,     0,     0,   774,   775,
       0,     0,   776,   777,     0,     0,   778,   779,   139,     0,
     669,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   670,     0,   148,   149,   150,   151,
     152,   671,   154,     0,   155,     0,     0,   672,   156,   673,
     674,   675,   157,   676,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,   677,   678,   165,   166,
       0,   167,   679,   680,   169,   170,     0,   171,   172,   173,
     174,   175,   681,   177,     0,   682,   179,   683,   684,   685,
     686,   687,   688,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   689,
     200,     0,   201,   690,   691,   202,     0,     0,   203,   692,
     693,     0,   204,   694,   695,     0,   205,   206,   207,   696,
     697,   698,     0,     0,     0,     0,   699,   210,   700,     0,
       0,   701,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,   702,     0,   236,   237,   238,
     703,   704,   239,   240,     0,   241,   242,   243,   705,     0,
     244,     0,     0,     0,   245,  2197,   246,     0,   247,     0,
     248,   249,   706,   251,   707,   253,     0,   254,     0,   708,
       0,   255,   256,   257,     0,   258,   709,   710,     0,   259,
     260,     0,     0,     0,   711,   262,   263,   264,   712,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
     713,   270,   271,   714,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   715,     0,     0,   281,     0,   716,   282,   283,     0,
       0,     0,     0,     0,   717,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,   718,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,   719,   306,   307,
     308,   309,   720,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   721,   317,     0,     0,   722,   319,   723,
     320,     0,   321,   724,   725,   726,   727,   728,   326,   327,
     328,   329,   330,     0,   729,   331,   332,     0,     0,   333,
     334,   335,   336,   730,   731,   732,   337,   338,     0,   733,
     734,     0,   339,   340,   735,     0,   342,   343,   344,   345,
       0,   346,   347,     0,     0,     0,     0,     0,     0,     0,
       0,   348,   349,   350,     0,   736,   351,     0,   352,   353,
     354,   355,   737,   357,   358,   359,   360,   738,   739,   363,
     740,     0,   364,   365,   366,     0,   367,     0,   368,   369,
     370,   371,   372,     0,   741,   374,   375,     0,     0,   376,
       0,     0,     0,   377,   378,   379,   380,   381,     0,     0,
     382,   383,   384,   385,   386,     0,   387,   388,     0,   389,
     390,   391,   742,   743,   392,     0,   393,     0,   394,   395,
       0,   396,   397,     0,     0,   744,   398,   399,   400,   401,
     402,   745,   404,   405,   406,   407,     0,   746,   409,     0,
       0,     0,   410,   411,   412,   413,     0,     0,     0,   414,
       0,     0,     0,   415,     0,   416,   417,   418,   419,     0,
     420,   421,   422,   423,   424,   425,     0,     0,     0,     0,
       0,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,   747,   748,   433,   434,     0,   435,
     436,   749,   438,   439,   440,   750,   751,   441,   442,   443,
     444,   752,   445,   446,     0,   447,     0,   448,   449,   450,
     451,     0,   753,   452,   453,     0,   754,   755,   756,   757,
       0,     0,     0,     0,     0,   458,   459,   460,     0,   758,
     759,   760,   462,   463,   464,   761,   465,   466,   762,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   763,   475,   476,     0,     0,   764,   765,
     766,   767,   477,     0,     0,   478,   768,     0,   769,   479,
     480,   481,   482,   483,   770,     0,     0,     0,     0,     0,
       0,   485,   486,     0,   487,   488,   489,     0,     0,   771,
       0,     0,     0,     0,   772,   773,     0,     0,     0,     0,
     774,   775,     0,     0,   776,   777,     0,     0,   778,   779,
     139,     0,   669,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   670,     0,   148,   149,
     150,   151,   152,   671,   154,     0,   155,     0,     0,   672,
     156,   673,   674,   675,   157,   676,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,   677,   678,
     165,   166,     0,   167,   679,   680,   169,   170,     0,   171,
     172,   173,   174,   175,   681,   177,     0,   682,   179,   683,
     684,   685,   686,   687,   688,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   689,   200,     0,   201,   690,   691,   202,     0,     0,
     203,   692,   693,     0,   204,   694,   695,     0,   205,   206,
     207,   696,   697,   698,     0,     0,     0,     0,   699,   210,
     700,     0,     0,   701,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,   702,     0,   236,
     237,   238,   703,   704,   239,   240,     0,   241,   242,   243,
     705,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   706,   251,   707,   253,     0,   254,
       0,   708,     0,   255,   256,   257,     0,   258,   709,   710,
       0,   259,   260,     0,     0,     0,   711,   262,   263,   264,
     712,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,   713,   270,   271,   714,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   715,     0,     0,   281,     0,   716,   282,
     283,     0,     0,     0,     0,     0,   717,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   718,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,   719,
     306,   307,   308,   309,   720,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   721,   317,     0,     0,   722,
     319,   723,   320,     0,   321,   724,   725,   726,   727,   728,
     326,   327,   328,   329,   330,     0,   729,   331,   332,     0,
       0,   333,   334,   335,   336,   730,   731,   732,   337,   338,
       0,   733,   734,     0,   339,   340,   735,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,   736,   351,     0,
     352,   353,   354,   355,   737,   357,   358,   359,   360,   738,
     739,   363,   740,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   741,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,   742,   743,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,   744,   398,   399,
     400,   401,   402,   745,   404,   405,   406,   407,     0,   746,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   747,   748,   433,   434,
       0,   435,   436,   749,   438,   439,   440,   750,   751,   441,
     442,   443,   444,   752,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,   753,   452,   453,     0,   754,   755,
     756,   757,     0,     0,     0,     0,     0,   458,   459,   460,
       0,   758,   759,   760,   462,   463,   464,   761,   465,   466,
     762,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   763,   475,   476,     0,     0,
     764,   765,   766,   767,   477,     0,     0,   478,   768,     0,
     769,   479,   480,   481,   482,   483,   770,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   771,     0,     0,     0,     0,   772,   773,     0,     0,
       0,     0,   774,   775,     0,     0,   776,   777,     0,     0,
     778,   779,   139,     0,   669,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   670,     0,
     148,   149,   150,   151,   152,   671,   154,     0,   155,     0,
       0,   672,   156,   673,   674,   675,   157,   676,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
     677,   678,   165,   166,     0,   167,   679,   680,   169,   170,
       0,   171,   172,   173,   174,   175,   681,   177,     0,   682,
     179,   683,   684,   685,   686,   687,   688,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   689,   200,     0,   201,   690,   691,   202,
       0,     0,   203,   692,   693,     0,   204,   694,   695,     0,
     205,   206,   207,   696,   697,   698,     0,     0,     0,     0,
     699,   210,   700,     0,     0,   701,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,   702,
       0,   236,   237,   238,   703,   704,   239,   240,     0,   241,
     242,   243,   705,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   706,   251,   707,   253,
       0,   254,     0,   708,     0,   255,   256,   257,     0,   258,
     709,   710,     0,   259,   260,     0,     0,     0,   711,   262,
     263,   264,   712,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,   713,   270,   271,   714,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   715,     0,     0,   281,     0,
     716,   282,   283,     0,     0,     0,     0,     0,   717,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   718,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,   719,   306,   307,   308,   309,   720,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   721,   317,     0,
       0,   722,   319,   723,   320,     0,   321,   724,   725,   726,
     727,   728,   326,   327,   328,   329,   330,     0,   729,   331,
     332,     0,     0,   333,   334,   335,   336,   730,   731,   732,
     337,   338,     0,   733,   734,     0,   339,   340,   735,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   737,   357,   358,   359,
     360,   738,   739,   363,   740,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   741,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,   742,   743,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,   744,
     398,   399,   400,   401,   402,   745,   404,   405,   406,   407,
       0,   746,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,   747,   748,
     433,   434,     0,   435,   436,   749,   438,   439,   440,   750,
     751,   441,   442,   443,   444,   752,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   753,   452,   453,     0,
     754,   755,   756,   757,     0,     0,     0,     0,     0,   458,
     459,   460,     0,   758,   759,   760,   462,   463,   464,   761,
     465,   466,   762,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   763,   475,   476,
       0,     0,   764,   765,   766,   767,   477,     0,     0,   478,
     768,     0,   769,   479,   480,   481,   482,   483,   770,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   771,     0,     0,     0,     0,   772,   773,
       0,     0,     0,     0,   774,  1120,     0,     0,   776,   777,
       0,     0,   778,   779,   139,     0,   669,   141,   142,   143,
     144,  1706,     0,   145,     0,     0,     0,  1707,     0,     0,
     670,     0,   148,   149,   150,   151,   152,   671,   154,     0,
     155,     0,     0,   672,   156,   673,   674,   675,   157,   676,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,   677,   678,   165,   166,     0,   167,   679,   680,
     169,   170,     0,   171,   172,   173,   174,   175,   681,   177,
       0,   682,   179,   683,   684,   685,   686,   687,   688,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   689,   200,     0,   201,   690,
     691,   202,     0,     0,   203,   692,   693,     0,   204,   694,
     695,     0,   205,   206,   207,   696,   697,   698,     0,     0,
       0,     0,   699,   210,   700,     0,     0,   701,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,   702,     0,   236,   237,   238,   703,   704,   239,   240,
       0,   241,   242,   243,   705,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   706,   251,
     707,   253,     0,   254,     0,   708,     0,   255,   256,   257,
       0,   258,   709,   710,     0,   259,   260,     0,     0,     0,
     711,   262,   263,   264,   712,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,   713,   270,   271,   714,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   715,     0,     0,
     281,     0,   716,   282,   283,     0,     0,     0,     0,     0,
     717,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,   718,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,   719,   306,   307,   308,   309,   720,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   721,
     317,     0,     0,   722,   319,   723,   320,     0,   321,   724,
     725,   726,   727,   728,   326,   327,   328,   329,   330,     0,
     729,   331,   332,     0,     0,   333,   334,   335,   336,   730,
       0,   732,   337,   338,     0,   733,   734,     0,   339,   340,
     735,     0,   342,   343,   344,   345,     0,   346,   347,     0,
       0,     0,     0,     0,     0,     0,     0,   348,   349,   350,
       0,   736,   351,     0,   352,   353,   354,   355,   737,   357,
     358,   359,   360,   738,   739,   363,   740,     0,   364,   365,
     366,     0,   367,     0,   368,   369,   370,   371,   372,     0,
     741,   374,   375,     0,     0,   376,     0,     0,     0,   377,
     378,   379,   380,   381,     0,     0,   382,   383,   384,   385,
     386,     0,   387,   388,     0,   389,   390,   391,   742,   743,
     392,     0,   393,     0,   394,   395,     0,   396,   397,     0,
       0,   744,   398,   399,   400,   401,   402,   745,   404,   405,
     406,   407,     0,   746,   409,     0,     0,     0,   410,   411,
     412,   413,     0,     0,     0,   414,     0,     0,     0,   415,
       0,   416,   417,   418,   419,     0,   420,   421,   422,   423,
     424,   425,     0,     0,     0,     0,     0,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     747,   748,   433,   434,     0,   435,   436,   749,   438,   439,
     440,   750,   751,   441,   442,   443,   444,   752,   445,   446,
       0,   447,     0,   448,   449,   450,   451,     0,   753,   452,
     453,     0,   754,   755,   756,   757,     0,     0,     0,     0,
       0,   458,   459,   460,     0,   758,   759,   760,   462,   463,
     464,   761,   465,   466,   762,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   763,
     475,   476,     0,     0,   764,   765,   766,   767,   477,     0,
       0,   478,   768,     0,   769,   479,   480,   481,   482,   483,
     770,     0,     0,     0,     0,     0,     0,   485,   486,     0,
     487,   488,   489,     0,     0,   771,     0,     0,     0,     0,
     772,   773,     0,     0,     0,     0,   774,   775,     0,     0,
     776,   777,     0,     0,   778,   779,   139,     0,   669,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   670,     0,   148,   149,   150,   151,   152,   671,
     154,     0,   155,     0,     0,   672,   156,   673,   674,   675,
     157,   676,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,   677,   678,   165,   166,     0,   167,
     679,   680,   169,   170,     0,   171,   172,   173,   174,   175,
     681,   177,     0,   682,   179,   683,   684,   685,   686,   687,
     688,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   689,   200,     0,
     201,   690,   691,   202,     0,     0,   203,   692,   693,     0,
     204,   694,   695,     0,   205,   206,   207,   696,   697,   698,
       0,     0,     0,     0,   699,   210,   700,     0,     0,   701,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,   702,     0,   236,   237,   238,   703,   704,
     239,   240,     0,   241,   242,   243,   705,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     706,   251,   707,   253,     0,   254,     0,   708,     0,   255,
     256,   257,     0,   258,   709,   710,     0,   259,   260,     0,
       0,     0,   711,   262,   263,   264,   712,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,   713,   270,
     271,   714,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   715,
       0,     0,   281,     0,   716,   282,   283,     0,     0,     0,
       0,     0,   717,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,   718,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,   719,   306,   307,   308,   309,
     720,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   721,   317,     0,     0,   722,   319,   723,   320,     0,
     321,   724,   725,   726,   727,   728,   326,   327,   328,   329,
     330,     0,   729,   331,   332,     0,     0,   333,   334,   335,
     336,   730,   731,   732,   337,   338,     0,   733,   734,     0,
     339,   340,   735,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,   736,   351,     0,   352,   353,   354,   355,
     737,   357,   358,   359,   360,   738,   739,   363,   740,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   741,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
     742,   743,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,   744,   398,   399,   400,   401,   402,   745,
     404,   405,   406,   407,     0,   746,   409,     0,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,   747,   748,   433,   434,     0,   435,   436,   749,
     438,   439,   440,   750,   751,   441,   442,   443,   444,   752,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
     753,   452,   453,     0,   754,   755,   756,   757,     0,     0,
       0,     0,     0,   458,   459,   460,     0,   758,   759,   760,
     462,   463,   464,   761,   465,   466,   762,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,  1781,   475,   476,     0,     0,   764,   765,   766,   767,
     477,     0,     0,   478,   768,     0,   769,   479,   480,   481,
     482,   483,   770,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   771,     0,     0,
       0,     0,   772,   773,     0,     0,     0,     0,   774,   775,
       0,     0,   776,   777,     0,     0,   778,   779,   139,     0,
     669,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   670,     0,   148,   149,   150,   151,
     152,   671,   154,     0,   155,     0,     0,   672,   156,   673,
     674,   675,   157,   676,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,   677,   678,   165,   166,
       0,   167,   679,   680,   169,   170,     0,   171,   172,   173,
     174,   175,   681,   177,     0,   682,   179,   683,   684,   685,
     686,   687,   688,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   689,
     200,     0,   201,   690,   691,   202,     0,     0,   203,   692,
     693,     0,   204,   694,   695,     0,   205,   206,   207,   696,
     697,   698,     0,     0,     0,     0,   699,   210,   700,     0,
       0,   701,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,   702,     0,   236,   237,   238,
     703,   704,   239,   240,     0,   241,   242,   243,   705,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   706,   251,   707,   253,     0,   254,     0,   708,
       0,   255,   256,   257,     0,   258,   709,   710,     0,   259,
     260,     0,     0,     0,   711,   262,   263,   264,   712,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
     713,   270,   271,  2604,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   715,     0,     0,   281,     0,   716,   282,   283,     0,
       0,     0,     0,     0,   717,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,   718,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,   719,   306,   307,
     308,   309,   720,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   721,   317,     0,     0,   722,   319,   723,
     320,     0,   321,   724,   725,   726,   727,   728,   326,   327,
     328,   329,   330,     0,   729,   331,   332,     0,     0,   333,
     334,   335,   336,   730,   731,   732,   337,   338,     0,   733,
     734,     0,   339,   340,   735,     0,   342,   343,   344,   345,
       0,   346,   347,     0,     0,     0,     0,     0,     0,     0,
       0,   348,   349,   350,     0,   736,   351,     0,   352,   353,
     354,   355,   737,   357,   358,   359,   360,   738,   739,   363,
     740,     0,   364,   365,   366,     0,   367,     0,   368,   369,
     370,   371,   372,     0,   741,   374,   375,     0,     0,   376,
       0,     0,     0,   377,   378,   379,   380,   381,     0,     0,
     382,   383,   384,   385,   386,     0,   387,   388,     0,   389,
     390,   391,   742,   743,   392,     0,   393,     0,   394,   395,
       0,   396,   397,     0,     0,   744,   398,   399,   400,   401,
     402,   745,   404,   405,   406,   407,     0,   746,   409,     0,
       0,     0,   410,   411,   412,   413,     0,     0,     0,   414,
       0,     0,     0,   415,     0,   416,   417,   418,   419,     0,
     420,   421,   422,   423,   424,   425,     0,     0,     0,     0,
       0,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,   747,   748,   433,   434,     0,   435,
     436,   749,   438,   439,   440,   750,   751,   441,   442,   443,
     444,   752,   445,   446,     0,   447,     0,   448,   449,   450,
     451,     0,   753,   452,   453,     0,   754,   755,   756,   757,
       0,     0,     0,     0,     0,   458,   459,   460,     0,   758,
     759,   760,   462,   463,   464,   761,   465,   466,   762,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   763,   475,   476,     0,     0,   764,   765,
     766,   767,   477,     0,     0,   478,   768,     0,   769,   479,
     480,   481,   482,   483,   770,     0,     0,     0,     0,     0,
       0,   485,   486,     0,   487,   488,   489,     0,     0,   771,
       0,     0,     0,     0,   772,   773,     0,     0,     0,     0,
     774,   775,     0,     0,   776,   777,     0,     0,   778,   779,
     139,     0,   669,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   670,     0,   148,   149,
     150,   151,   152,   671,   154,     0,   155,     0,     0,   672,
     156,   673,   674,   675,   157,   676,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,   677,   678,
     165,   166,     0,   167,   679,   680,   169,   170,     0,   171,
     172,   173,   174,   175,   681,   177,     0,   682,   179,   683,
     684,   685,   686,   687,   688,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   689,   200,     0,   201,   690,   691,   202,     0,     0,
     203,   692,   693,     0,   204,   694,   695,     0,   205,   206,
     207,   696,   697,   698,     0,     0,     0,     0,   699,   210,
     700,     0,     0,   701,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,   702,     0,   236,
     237,   238,   703,   704,   239,   240,     0,   241,   242,   243,
     705,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   706,   251,   707,   253,     0,   254,
       0,   708,     0,   255,   256,   257,     0,   258,   709,   710,
       0,   259,   260,     0,     0,     0,   711,   262,   263,   264,
     712,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,   713,   270,   271,  2658,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   715,     0,     0,   281,     0,   716,   282,
     283,     0,     0,     0,     0,     0,   717,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   718,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,   719,
     306,   307,   308,   309,   720,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   721,   317,     0,     0,   722,
     319,   723,   320,     0,   321,   724,   725,   726,   727,   728,
     326,   327,   328,   329,   330,     0,   729,   331,   332,     0,
       0,   333,   334,   335,   336,   730,   731,   732,   337,   338,
       0,   733,   734,     0,   339,   340,   735,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,   736,   351,     0,
     352,   353,   354,   355,   737,   357,   358,   359,   360,   738,
     739,   363,   740,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   741,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,   742,   743,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,   744,   398,   399,
     400,   401,   402,   745,   404,   405,   406,   407,     0,   746,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   747,   748,   433,   434,
       0,   435,   436,   749,   438,   439,   440,   750,   751,   441,
     442,   443,   444,   752,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,   753,   452,   453,     0,   754,   755,
     756,   757,     0,     0,     0,     0,     0,   458,   459,   460,
       0,   758,   759,   760,   462,   463,   464,   761,   465,   466,
     762,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   763,   475,   476,     0,     0,
     764,   765,   766,   767,   477,     0,     0,   478,   768,     0,
     769,   479,   480,   481,   482,   483,   770,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   771,     0,     0,     0,     0,   772,   773,     0,     0,
       0,     0,   774,   775,     0,     0,   776,   777,     0,     0,
     778,   779,   139,     0,   669,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   670,     0,
     148,   149,   150,   151,   152,   671,   154,     0,   155,     0,
       0,   672,   156,   673,   674,   675,   157,   676,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
     677,   678,   165,   166,     0,   167,   679,   680,   169,   170,
       0,   171,   172,   173,   174,   175,   681,   177,     0,   682,
     179,   683,   684,   685,   686,   687,   688,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   689,   200,     0,   201,   690,   691,   202,
       0,     0,   203,   692,   693,     0,   204,   694,   695,     0,
     205,   206,   207,   696,   697,   698,     0,     0,     0,     0,
     699,   210,   700,     0,     0,  3417,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,   702,
       0,   236,   237,   238,   703,   704,   239,   240,     0,   241,
     242,   243,   705,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   706,   251,   707,   253,
       0,   254,     0,   708,     0,   255,   256,   257,     0,   258,
     709,   710,     0,   259,   260,     0,     0,     0,   711,   262,
     263,   264,   712,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,   713,   270,   271,   714,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   715,     0,     0,   281,     0,
     716,   282,   283,     0,     0,     0,     0,     0,   717,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   718,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,   719,   306,   307,   308,   309,   720,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   721,   317,     0,
       0,   722,   319,   723,   320,     0,   321,   724,   725,   726,
     727,   728,   326,   327,   328,   329,   330,     0,   729,   331,
     332,     0,     0,   333,   334,   335,   336,   730,   731,   732,
     337,   338,     0,   733,   734,     0,   339,   340,   735,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   737,   357,   358,   359,
     360,   738,   739,   363,   740,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   741,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,   742,   743,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,   744,
     398,   399,   400,   401,   402,   745,   404,   405,   406,   407,
       0,   746,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,   747,   748,
     433,   434,     0,   435,   436,   749,   438,   439,   440,   750,
     751,   441,   442,   443,   444,   752,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   753,   452,   453,     0,
     754,   755,   756,   757,     0,     0,     0,     0,     0,   458,
     459,   460,     0,   758,   759,   760,   462,   463,   464,   761,
     465,   466,   762,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   763,   475,   476,
       0,     0,   764,   765,   766,   767,   477,     0,     0,   478,
     768,     0,   769,   479,   480,   481,   482,   483,   770,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   771,     0,     0,     0,     0,   772,   773,
       0,     0,     0,     0,   774,   775,     0,     0,   776,   777,
       0,     0,   778,   779,   139,     0,   669,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     670,     0,   148,   149,   150,   151,   152,   671,   154,     0,
     155,     0,     0,   672,   156,   673,   674,   675,   157,   676,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,   677,   678,   165,   166,     0,   167,   679,   680,
     169,   170,     0,   171,   172,   173,   174,   175,   681,   177,
       0,   682,   179,   683,   684,   685,   686,   687,   688,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   689,   200,     0,   201,   690,
     691,   202,     0,     0,   203,   692,   693,     0,   204,   694,
     695,     0,   205,   206,   207,   696,   697,   698,     0,     0,
       0,     0,   699,   210,   700,     0,     0,   701,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,   702,     0,   236,   237,   238,   703,   704,   239,   240,
       0,   241,   242,   243,   705,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   706,   251,
     707,   253,     0,   254,     0,   708,     0,   255,   256,   257,
       0,   258,   709,   710,     0,   259,   260,     0,     0,     0,
     711,   262,   263,   264,   712,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,   713,   270,   271,   714,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   715,     0,     0,
     281,     0,   716,   282,   283,     0,     0,     0,     0,     0,
     717,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,   718,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,   719,   306,   307,   308,   309,   720,   310,
     311,  4307,     0,     0,     0,   312,   313,   314,   315,   721,
     317,     0,     0,   722,   319,   723,   320,     0,   321,   724,
     725,   726,   727,   728,   326,   327,   328,   329,   330,     0,
     729,   331,   332,     0,     0,   333,   334,   335,   336,   730,
       0,   732,   337,   338,     0,   733,   734,     0,   339,   340,
     735,     0,   342,   343,   344,   345,     0,   346,   347,     0,
       0,     0,     0,     0,     0,     0,     0,   348,   349,   350,
       0,   736,   351,     0,   352,   353,   354,   355,   737,   357,
     358,   359,   360,   738,   739,   363,   740,     0,   364,   365,
     366,     0,   367,     0,   368,   369,   370,   371,   372,     0,
     741,   374,   375,     0,     0,   376,     0,     0,     0,   377,
     378,   379,   380,   381,     0,     0,   382,   383,   384,   385,
     386,     0,   387,   388,     0,   389,   390,   391,   742,   743,
     392,     0,   393,     0,   394,   395,     0,   396,   397,     0,
       0,   744,   398,   399,   400,   401,   402,   745,   404,   405,
     406,   407,     0,   746,   409,     0,     0,     0,   410,   411,
     412,   413,     0,     0,     0,   414,     0,     0,     0,   415,
       0,   416,   417,   418,   419,     0,   420,   421,   422,   423,
     424,   425,     0,     0,     0,     0,     0,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     747,   748,   433,   434,     0,   435,   436,   749,   438,   439,
     440,   750,   751,   441,   442,   443,   444,   752,   445,   446,
       0,   447,     0,   448,   449,   450,   451,     0,   753,   452,
     453,     0,   754,   755,   756,   757,     0,     0,     0,     0,
       0,   458,   459,   460,     0,   758,   759,   760,   462,   463,
     464,   761,   465,   466,   762,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   763,
     475,   476,     0,     0,   764,   765,   766,   767,   477,     0,
       0,   478,   768,     0,   769,   479,   480,   481,   482,   483,
     770,     0,     0,     0,     0,     0,     0,   485,   486,     0,
     487,   488,   489,     0,     0,   771,     0,     0,     0,     0,
     772,   773,     0,     0,     0,     0,   774,   775,     0,     0,
     776,   777,     0,     0,   778,   779,   139,     0,   669,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   670,     0,   148,   149,   150,   151,   152,   671,
     154,     0,   155,     0,     0,   672,   156,   673,   674,   675,
     157,   676,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,   677,   678,   165,   166,     0,   167,
     679,   680,   169,   170,     0,   171,   172,   173,   174,   175,
     681,   177,     0,   682,   179,   683,   684,   685,   686,   687,
     688,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   689,   200,     0,
     201,   690,   691,   202,     0,     0,   203,   692,   693,     0,
     204,   694,   695,     0,   205,   206,   207,   696,   697,   698,
       0,     0,     0,     0,   699,   210,   700,     0,     0,   701,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,   702,     0,   236,   237,   238,   703,   704,
     239,   240,     0,   241,   242,   243,   705,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     706,   251,   707,   253,     0,   254,     0,   708,     0,   255,
     256,   257,     0,   258,   709,   710,     0,   259,   260,     0,
       0,     0,   711,   262,   263,   264,   712,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,   713,   270,
     271,   714,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   715,
       0,     0,   281,     0,   716,   282,   283,     0,     0,     0,
       0,     0,   717,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,   718,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,   719,   306,   307,   308,   309,
     720,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   721,   317,     0,     0,   722,   319,   723,   320,     0,
     321,   724,   725,   726,   727,   728,   326,   327,   328,   329,
     330,     0,   729,   331,   332,     0,     0,   333,   334,   335,
     336,   730,     0,   732,   337,   338,     0,   733,   734,     0,
     339,   340,   735,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,   736,   351,     0,   352,   353,   354,   355,
     737,   357,   358,   359,   360,   738,   739,   363,   740,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   741,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
     742,   743,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,   744,   398,   399,   400,   401,   402,   745,
     404,   405,   406,   407,     0,   746,   409,     0,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,   747,   748,   433,   434,     0,   435,   436,   749,
     438,   439,   440,   750,   751,   441,   442,   443,   444,   752,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
     753,   452,   453,     0,   754,   755,   756,   757,     0,     0,
       0,     0,     0,   458,   459,   460,     0,   758,   759,   760,
     462,   463,   464,   761,   465,   466,   762,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   763,   475,   476,     0,     0,   764,   765,   766,   767,
     477,     0,     0,   478,   768,     0,   769,   479,   480,   481,
     482,   483,   770,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   771,     0,     0,
       0,     0,   772,   773,     0,     0,     0,     0,   774,   775,
       0,     0,   776,   777,     0,     0,   778,   779,   139,     0,
     669,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   670,     0,   148,   149,   150,   151,
     152,   671,   154,     0,   155,     0,     0,   672,   156,   673,
     674,   675,   157,   676,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,   677,   678,   165,   166,
       0,   167,   679,   680,   169,   170,     0,   171,   172,   173,
     174,   175,   681,   177,     0,   682,   179,   683,   684,   685,
     686,   687,   688,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   689,
     200,     0,   201,   690,   691,   202,     0,     0,   203,   692,
     693,     0,   204,   694,   695,     0,   205,   206,   207,   696,
     697,   698,     0,     0,     0,     0,   699,   210,   700,     0,
       0,   701,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,   702,     0,   236,   237,   238,
     703,   704,   239,   240,     0,   241,   242,   243,   705,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   706,   251,   707,   253,     0,   254,     0,   708,
       0,   255,   256,   257,     0,   258,   709,   710,     0,   259,
     260,     0,     0,     0,   711,   262,   263,   264,   712,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
     713,   270,   271,  1721,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   715,     0,     0,   281,     0,   716,   282,   283,     0,
       0,     0,     0,     0,   717,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,   718,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,   719,   306,   307,
     308,   309,   720,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   721,   317,     0,     0,   722,   319,   723,
     320,     0,   321,   724,   725,   726,   727,   728,   326,   327,
     328,   329,   330,     0,   729,   331,   332,     0,     0,   333,
     334,   335,   336,   730,     0,   732,   337,   338,     0,   733,
     734,     0,   339,   340,   735,     0,   342,   343,   344,   345,
       0,   346,   347,     0,     0,     0,     0,     0,     0,     0,
       0,   348,   349,   350,     0,   736,   351,     0,   352,   353,
     354,   355,   737,   357,   358,   359,   360,   738,   739,   363,
     740,     0,   364,   365,   366,     0,   367,     0,   368,   369,
     370,   371,   372,     0,   741,   374,   375,     0,     0,   376,
       0,     0,     0,   377,   378,   379,   380,   381,     0,     0,
     382,   383,   384,   385,   386,     0,   387,   388,     0,   389,
     390,   391,   742,   743,   392,     0,   393,     0,   394,   395,
       0,   396,   397,     0,     0,   744,   398,   399,   400,   401,
     402,   745,   404,   405,   406,   407,     0,   746,   409,     0,
       0,     0,   410,   411,   412,   413,     0,     0,     0,   414,
       0,     0,     0,   415,     0,   416,   417,   418,   419,     0,
     420,   421,   422,   423,   424,   425,     0,     0,     0,     0,
       0,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,   747,   748,   433,   434,     0,   435,
     436,   749,   438,   439,   440,   750,   751,   441,   442,   443,
     444,   752,   445,   446,     0,   447,     0,   448,   449,   450,
     451,     0,   753,   452,   453,     0,   754,   755,   756,   757,
       0,     0,     0,     0,     0,   458,   459,   460,     0,   758,
     759,   760,   462,   463,   464,   761,   465,   466,   762,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   763,   475,   476,     0,     0,   764,   765,
     766,   767,   477,     0,     0,   478,   768,     0,   769,   479,
     480,   481,   482,   483,   770,     0,     0,     0,     0,     0,
       0,   485,   486,     0,   487,   488,   489,     0,     0,   771,
       0,     0,     0,     0,   772,   773,     0,     0,     0,     0,
     774,   775,     0,     0,   776,   777,     0,     0,   778,   779,
     139,     0,   669,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   670,     0,   148,   149,
     150,   151,   152,   671,   154,     0,   155,     0,     0,   672,
     156,   673,   674,   675,   157,   676,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,   677,   678,
     165,   166,     0,   167,   679,   680,   169,   170,     0,   171,
     172,   173,   174,   175,   681,   177,     0,   682,   179,   683,
     684,   685,   686,   687,   688,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   689,   200,     0,   201,   690,   691,   202,     0,     0,
     203,   692,   693,     0,   204,   694,   695,     0,   205,   206,
     207,   696,   697,   698,     0,     0,     0,     0,   699,   210,
     700,     0,     0,   701,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,   702,     0,   236,
     237,   238,   703,   704,   239,   240,     0,   241,   242,   243,
     705,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   706,   251,   707,   253,     0,   254,
       0,   708,     0,   255,   256,   257,     0,   258,   709,   710,
       0,   259,   260,     0,     0,     0,   711,   262,   263,   264,
     712,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,   713,   270,   271,  1723,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   715,     0,     0,   281,     0,   716,   282,
     283,     0,     0,     0,     0,     0,   717,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   718,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,   719,
     306,   307,   308,   309,   720,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   721,   317,     0,     0,   722,
     319,   723,   320,     0,   321,   724,   725,   726,   727,   728,
     326,   327,   328,   329,   330,     0,   729,   331,   332,     0,
       0,   333,   334,   335,   336,   730,     0,   732,   337,   338,
       0,   733,   734,     0,   339,   340,   735,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,   736,   351,     0,
     352,   353,   354,   355,   737,   357,   358,   359,   360,   738,
     739,   363,   740,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   741,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,   742,   743,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,   744,   398,   399,
     400,   401,   402,   745,   404,   405,   406,   407,     0,   746,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   747,   748,   433,   434,
       0,   435,   436,   749,   438,   439,   440,   750,   751,   441,
     442,   443,   444,   752,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,   753,   452,   453,     0,   754,   755,
     756,   757,     0,     0,     0,     0,     0,   458,   459,   460,
       0,   758,   759,   760,   462,   463,   464,   761,   465,   466,
     762,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   763,   475,   476,     0,     0,
     764,   765,   766,   767,   477,     0,     0,   478,   768,     0,
     769,   479,   480,   481,   482,   483,   770,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   771,     0,     0,     0,     0,   772,   773,     0,     0,
       0,     0,   774,   775,     0,     0,   776,   777,     0,     0,
     778,   779,   139,     0,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,   673,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,  2331,     0,     0,     0,     0,
     209,   210,   700,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,   704,   239,   240,     0,   241,
     242,   243,   705,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
     709,   710,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   718,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,   729,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,   733,   734,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   753,   452,   453,     0,
    2332,   455,   456,  2333,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,   759,   461,   462,   463,   464,   761,
     465,   466,   762,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   490,     0,     0,     0,     0,   139,     0,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,   778,   779,   147,     0,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,  2446,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   237,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,   504,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,     0,     0,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,  2030,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,  2031,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,     0,
    3003,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,     0,   331,   332,     0,     0,   333,
     334,   335,   336,     0,     0,     0,   337,   338,     0,     0,
       0,     0,   339,   340,   341,     0,   342,   343,   344,   345,
       0,   346,   347,     0,     0,     0,     0,     0,     0,     0,
       0,   348,   349,   350,     0,     0,   351,     0,   352,   353,
     354,  3004,   356,   357,   358,   359,   360,   361,   362,   363,
       0,     0,   364,   365,   366,     0,   367,     0,   368,   369,
     370,   371,   372,     0,   373,   374,   375,     0,     0,   376,
       0,     0,     0,   377,   378,   379,   380,   381,     0,     0,
     382,   383,   384,   385,   386,     0,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,   393,     0,   394,   395,
       0,   396,   397,     0,     0,     0,   398,   399,   400,   401,
     402,   403,   404,   405,   406,   407,     0,   408,   409,  -439,
       0,     0,   410,   411,   412,   413,     0,     0,     0,   414,
       0,     0,     0,   415,     0,   416,   417,   418,   419,     0,
     420,   421,   422,   423,   424,   425,   507,     0,     0,     0,
       0,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,     0,     0,   433,   434,     0,   435,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   443,
     444,     0,   445,   446,     0,   447,     0,   448,   449,   450,
     451,     0,     0,   452,   453,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,   458,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,   476,     0,     0,     0,     0,
       0,     0,   477,     0,     0,   478,     0,     0,     0,   479,
     480,   481,   482,   483,   484,     0,     0,     0,     0,     0,
       0,   485,   486,     0,   487,   488,   489,     0,     0,   490,
       0,     0,   139,     0,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,  2513,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,  2446,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,   504,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,  2030,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,  2031,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
     507,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   490,     0,     0,   139,     0,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   147,  2513,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,     0,     0,   331,   332,     0,     0,   333,   334,   335,
     336,     0,     0,     0,   337,   338,     0,     0,     0,     0,
     339,   340,   341,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,     0,   351,     0,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   373,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,     0,   408,   409,  2322,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,     0,     0,   433,   434,     0,   435,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   443,   444,     0,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,   458,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,   476,     0,     0,     0,     0,     0,     0,
     477,     0,     0,   478,     0,     0,     0,   479,   480,   481,
     482,   483,   484,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   490,     0,     0,
     139,     0,   140,   141,   142,   143,   144,     0,     0,   145,
    2752,     0,     0,   146,     0,     0,   147,   779,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,     0,   239,   240,     0,   241,   242,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
       0,   333,   334,   335,   336,     0,     0,     0,   337,   338,
       0,     0,     0,     0,   339,   340,   341,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,     0,   351,     0,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   373,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,     0,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,     0,   408,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,     0,     0,   433,   434,
       0,   435,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   443,   444,     0,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,     0,   452,   453,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,   458,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,   484,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   490,     0,     0,     0,     0,   139,     0,   140,   141,
     142,   143,   144,     0,  4434,   145,     0,     0,     0,   146,
    4435,   779,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,     0,     0,   331,   332,     0,     0,   333,   334,   335,
     336,     0,     0,     0,   337,   338,     0,     0,     0,     0,
     339,   340,   341,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,     0,   351,     0,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   373,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,     0,   408,   409,     0,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,     0,     0,   433,   434,     0,   435,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   443,   444,     0,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,   458,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,   476,     0,     0,     0,     0,     0,     0,
     477,     0,     0,   478,     0,     0,     0,   479,   480,   481,
     482,   483,   484,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   490,     0,     0,
       0,     0,   139,     0,   140,   141,   142,   143,   144,  1125,
       0,   145,     0,     0,     0,   146,     0,   779,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,  1328,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,     0,   490,     0,     0,   139,     0,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   147,   538,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,     0,     0,   331,   332,     0,     0,   333,   334,   335,
     336,     0,     0,     0,   337,   338,     0,     0,     0,     0,
     339,   340,   341,     0,   342,   343,   344,   345,     0,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,   348,
     349,   350,     0,     0,   351,     0,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,     0,
     364,   365,   366,     0,   367,     0,   368,   369,   370,   371,
     372,     0,   373,   374,   375,     0,     0,   376,     0,     0,
       0,   377,   378,   379,   380,   381,     0,     0,   382,   383,
     384,   385,   386,     0,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,   393,     0,   394,   395,     0,   396,
     397,     0,     0,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,     0,   408,   409,     0,     0,     0,
     410,   411,   412,   413,     0,     0,     0,   414,     0,     0,
       0,   415,     0,   416,   417,   418,   419,     0,   420,   421,
     422,   423,   424,   425,     0,     0,     0,     0,     0,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,     0,     0,   433,   434,     0,   435,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   443,   444,     0,
     445,   446,     0,   447,     0,   448,   449,   450,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,   458,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,   476,     0,     0,     0,     0,     0,     0,
     477,     0,     0,   478,     0,     0,     0,   479,   480,   481,
     482,   483,   484,     0,     0,     0,     0,     0,     0,   485,
     486,     0,   487,   488,   489,     0,     0,   490,     0,     0,
       0,     0,     0,   139,  2270,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,   538,     0,   147,
       0,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,     0,   333,   334,   335,   336,     0,     0,
       0,   337,   338,     0,     0,     0,     0,   339,   340,   341,
       0,   342,   343,   344,   345,     0,   346,   347,     0,     0,
       0,     0,     0,     0,     0,     0,   348,   349,   350,     0,
       0,   351,     0,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,     0,     0,   364,   365,   366,
       0,   367,     0,   368,   369,   370,   371,   372,     0,   373,
     374,   375,     0,     0,   376,     0,     0,     0,   377,   378,
     379,   380,   381,     0,     0,   382,   383,   384,   385,   386,
       0,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,   393,     0,   394,   395,     0,   396,   397,     0,     0,
       0,   398,   399,   400,   401,   402,   403,   404,   405,   406,
     407,     0,   408,   409,     0,     0,     0,   410,   411,   412,
     413,     0,     0,     0,   414,     0,     0,     0,   415,     0,
     416,   417,   418,   419,     0,   420,   421,   422,   423,   424,
     425,     0,     0,     0,     0,     0,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,     0,
       0,   433,   434,     0,   435,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   443,   444,     0,   445,   446,     0,
     447,     0,   448,   449,   450,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
     458,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
     476,     0,     0,     0,     0,     0,     0,   477,     0,     0,
     478,     0,     0,     0,   479,   480,   481,   482,   483,   484,
       0,     0,     0,     0,     0,     0,   485,   486,     0,   487,
     488,   489,     0,     0,   490,     0,     0,     0,     0,   139,
       0,   140,   141,   142,   143,   144,  2512,     0,   145,     0,
       0,     0,   146,     0,  2513,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,     0,
     333,   334,   335,   336,     0,     0,     0,   337,   338,     0,
       0,     0,     0,   339,   340,   341,     0,   342,   343,   344,
     345,     0,   346,   347,     0,     0,     0,     0,     0,     0,
       0,     0,   348,   349,   350,     0,     0,   351,     0,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,     0,     0,   364,   365,   366,     0,   367,     0,   368,
     369,   370,   371,   372,     0,   373,   374,   375,     0,     0,
     376,     0,     0,     0,   377,   378,   379,   380,   381,     0,
       0,   382,   383,   384,   385,   386,     0,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,   393,     0,   394,
     395,     0,   396,   397,     0,     0,     0,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,     0,   408,   409,
       0,     0,     0,   410,   411,   412,   413,     0,     0,     0,
     414,     0,     0,     0,   415,     0,   416,   417,   418,   419,
       0,   420,   421,   422,   423,   424,   425,     0,     0,     0,
       0,     0,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,     0,     0,   433,   434,     0,
     435,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     443,   444,     0,   445,   446,     0,   447,     0,   448,   449,
     450,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,     0,     0,     0,     0,     0,   458,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,   476,     0,     0,     0,
       0,     0,     0,   477,     0,     0,   478,     0,     0,     0,
     479,   480,   481,   482,   483,   484,     0,     0,     0,     0,
       0,     0,   485,   486,     0,   487,   488,   489,     0,     0,
     490,     0,     0,     0,     0,   139,     0,   140,   141,   142,
     143,   144,     0,     0,   145,     0,     0,     0,   146,  4435,
     779,   147,     0,   148,   149,   150,   151,   152,   153,   154,
       0,   155,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,     0,     0,   165,   166,     0,   167,   168,
       0,   169,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,   178,   179,   180,   181,   182,   183,   184,   185,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   199,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,   210,     0,     0,     0,     0,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,     0,     0,   236,   237,   238,     0,     0,   239,
     240,     0,   241,   242,   243,     0,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,   255,   256,
     257,     0,   258,     0,     0,     0,   259,   260,     0,     0,
       0,   261,   262,   263,   264,     0,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,   271,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   280,     0,
       0,   281,     0,     0,   282,   283,     0,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,     0,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,     0,   333,   334,   335,   336,
       0,     0,     0,   337,   338,     0,     0,     0,     0,   339,
     340,   341,     0,   342,   343,   344,   345,     0,   346,   347,
       0,     0,     0,     0,     0,     0,     0,     0,   348,   349,
     350,     0,     0,   351,     0,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,     0,     0,   364,
     365,   366,     0,   367,     0,   368,   369,   370,   371,   372,
       0,   373,   374,   375,     0,     0,   376,     0,     0,     0,
     377,   378,   379,   380,   381,     0,     0,   382,   383,   384,
     385,   386,     0,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,   393,     0,   394,   395,     0,   396,   397,
       0,     0,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,     0,   408,   409,     0,     0,     0,   410,
     411,   412,   413,     0,     0,     0,   414,     0,     0,     0,
     415,     0,   416,   417,   418,   419,     0,   420,   421,   422,
     423,   424,   425,     0,     0,     0,     0,     0,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,     0,     0,   433,   434,     0,   435,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   443,   444,     0,   445,
     446,     0,   447,     0,   448,   449,   450,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,   458,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,   484,     0,     0,     0,     0,     0,     0,   485,   486,
       0,   487,   488,   489,     0,     0,   490,     0,     0,   139,
       0,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,     0,     0,   147,   538,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   605,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,     0,
     333,   334,   335,   336,     0,     0,     0,   337,   338,     0,
       0,     0,     0,   339,   340,   341,     0,   342,   343,   344,
     345,     0,   346,   347,     0,     0,     0,     0,     0,     0,
       0,     0,   348,   349,   350,     0,     0,   351,     0,   352,
     353,   606,   355,   356,   357,   358,   359,   360,   361,   362,
     363,     0,     0,   364,   365,   366,     0,   367,     0,   368,
     369,   370,   371,   372,     0,   373,   374,   375,     0,     0,
     376,     0,     0,     0,   377,   378,   379,   380,   381,     0,
       0,   382,   383,   384,   385,   386,     0,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,   393,     0,   394,
     395,     0,   396,   397,     0,     0,     0,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,     0,   408,   409,
       0,     0,     0,   410,   411,   412,   413,     0,     0,     0,
     414,     0,     0,     0,   415,     0,   416,   417,   418,   419,
       0,   420,   421,   422,   423,   424,   425,     0,     0,     0,
       0,     0,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,     0,     0,   433,   434,     0,
     435,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     443,   444,     0,   445,   446,     0,   447,     0,   448,   449,
     450,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,     0,     0,     0,     0,     0,   458,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,   476,     0,     0,     0,
       0,     0,     0,   477,     0,     0,   478,     0,     0,     0,
     479,   480,   481,   482,   483,   484,     0,     0,     0,     0,
       0,     0,   485,   486,     0,   487,   488,   489,     0,     0,
     490,     0,     0,   139,     0,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,   147,
     538,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,     0,   333,   334,   335,   336,     0,     0,
       0,   337,   338,     0,     0,     0,     0,   339,   340,   341,
       0,   342,   343,   344,   345,     0,   346,   347,     0,     0,
       0,     0,     0,     0,     0,     0,   348,   349,   350,     0,
       0,   351,     0,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,     0,     0,   364,   365,   366,
       0,   367,     0,   368,   369,   370,   371,   372,     0,   373,
     374,   375,     0,     0,   376,     0,     0,     0,   377,   378,
     379,   380,   381,     0,     0,   382,   383,   384,   385,   386,
       0,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,   393,     0,   394,   395,     0,   396,   397,     0,     0,
       0,   398,   399,   400,   401,   402,   403,   404,   405,   406,
     407,     0,   408,   409,     0,     0,     0,   410,   411,   412,
     413,     0,     0,     0,   414,     0,     0,     0,   415,     0,
     416,   417,   418,   419,     0,   420,   421,   422,   423,   424,
     425,     0,     0,     0,     0,     0,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,     0,
       0,   433,   434,     0,   435,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   443,   444,     0,   445,   446,     0,
     447,     0,   448,   449,   450,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
     458,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
     476,     0,     0,     0,     0,     0,     0,   477,     0,     0,
     478,     0,     0,     0,   479,   480,   481,   482,   483,   484,
       0,     0,     0,     0,     0,     0,   485,   486,     0,   487,
     488,   489,     0,     0,   490,     0,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,   779,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,     0,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,     0,   333,   334,
     335,   336,     0,     0,     0,   337,   338,     0,     0,     0,
       0,   339,   340,   341,     0,   342,   343,   344,   345,     0,
     346,   347,     0,     0,     0,     0,     0,     0,     0,     0,
     348,   349,   350,     0,     0,   351,     0,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,     0,
       0,   364,   365,   366,     0,   367,     0,   368,   369,   370,
     371,   372,     0,   373,   374,   375,     0,     0,   376,     0,
       0,     0,   377,   378,   379,   380,   381,     0,     0,   382,
     383,   384,   385,   386,     0,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,   393,     0,   394,   395,     0,
     396,   397,     0,     0,     0,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,     0,   408,   409,     0,     0,
       0,   410,   411,   412,   413,     0,     0,     0,   414,     0,
       0,     0,   415,     0,   416,   417,   418,   419,     0,   420,
     421,   422,   423,   424,   425,     0,     0,     0,     0,     0,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,     0,     0,   433,   434,     0,   435,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   443,   444,
       0,   445,   446,     0,   447,     0,   448,   449,   450,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,     0,
       0,     0,     0,     0,   458,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,   476,     0,     0,     0,     0,     0,
       0,   477,     0,     0,   478,     0,     0,     0,   479,   480,
     481,   482,   483,   484,     0,     0,     0,     0,     0,     0,
     485,   486,     0,   487,   488,   489,     0,     0,   490,     0,
       0,   139,     0,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   147,  2513,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,   617,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,     0,   333,   334,   335,   336,     0,     0,     0,   337,
     338,     0,     0,     0,     0,   339,   340,   341,     0,   342,
     343,   344,   345,     0,   346,   347,     0,     0,     0,     0,
       0,     0,     0,     0,   348,   349,   350,     0,     0,   351,
       0,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,     0,     0,   364,   365,   366,     0,   367,
       0,   368,   369,   370,   371,   372,     0,   373,   374,   375,
       0,     0,   376,     0,     0,     0,   377,   378,   379,   380,
     381,     0,     0,   382,   383,   384,   385,   386,     0,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,   393,
       0,   394,   395,     0,   396,   397,     0,     0,     0,   398,
     399,   400,   401,   402,   403,   404,   405,   406,   407,     0,
     408,   409,     0,     0,     0,   410,   411,   412,   413,     0,
       0,     0,   414,     0,     0,     0,   415,     0,   416,   417,
     418,   419,     0,   420,   421,   422,   423,   424,   425,     0,
       0,     0,     0,     0,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,     0,     0,   433,
     434,     0,   435,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   443,   444,     0,   445,   446,     0,   447,     0,
     448,   449,   450,   451,     0,   136,   452,   453,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,   458,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,   476,     0,
       0,     0,     0,     0,     0,   477,     0,     0,   478,     0,
       0,     0,   479,   480,   481,   482,   483,   484,     0,     0,
       0,     0,     0,     0,   485,   486,     0,   487,   488,   489,
       0,     0,   490,     0,   139,     0,   140,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     147,  1693,   148,   149,   150,   151,   152,   153,   154,     0,
     155,     0,     0,     0,   156,     0,     0,     0,   157,     0,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,     0,     0,   165,   166,     0,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,   178,   179,   180,   181,   182,   183,   184,   185,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   199,   200,     0,   201,     0,
       0,   202,     0,     0,   203,     0,     0,     0,   204,     0,
       0,     0,   205,   206,   207,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,     0,     0,     0,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,     0,     0,   236,   237,   238,     0,     0,   239,   240,
       0,   241,   242,   243,     0,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   250,   251,
     252,   253,     0,   254,     0,     0,     0,   255,   256,   257,
       0,   258,     0,     0,     0,   259,   260,     0,     0,     0,
     261,   262,   263,   264,     0,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,     0,   270,   271,     0,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   280,     0,     0,
     281,     0,     0,   282,   283,   617,     0,     0,     0,     0,
     284,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,     0,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,     0,   306,   307,   308,   309,     0,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   316,
     317,     0,     0,   318,   319,     0,   320,     0,   321,     0,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,     0,   333,   334,   335,   336,     0,
       0,     0,   337,   338,     0,     0,     0,     0,   339,   340,
     341,     0,   342,   343,   344,   345,     0,   346,   347,     0,
       0,     0,     0,     0,     0,     0,     0,   348,   349,   350,
       0,     0,   351,     0,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,     0,   364,   365,
     366,     0,   367,     0,   368,   369,   370,   371,   372,     0,
     373,   374,   375,     0,     0,   376,     0,     0,     0,   377,
     378,   379,   380,   381,     0,     0,   382,   383,   384,   385,
     386,     0,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,   393,     0,   394,   395,     0,   396,   397,     0,
       0,     0,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,     0,   408,   409,     0,     0,     0,   410,   411,
     412,   413,     0,     0,     0,   414,     0,     0,     0,   415,
       0,   416,   417,   418,   419,     0,   420,   421,   422,   423,
     424,   425,     0,     0,     0,     0,     0,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
       0,     0,   433,   434,     0,   435,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   443,   444,     0,   445,   446,
       0,   447,     0,   448,   449,   450,   451,     0,   136,   452,
     453,     0,   454,   455,   456,   457,     0,     0,     0,     0,
       0,   458,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,   476,     0,     0,     0,     0,     0,     0,   477,     0,
       0,   478,     0,     0,     0,   479,   480,   481,   482,   483,
     484,     0,     0,     0,     0,     0,     0,   485,   486,     0,
     487,   488,   489,     0,     0,   490,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,  2792,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,   617,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,     0,   333,   334,
     335,   336,     0,     0,     0,   337,   338,     0,     0,     0,
       0,   339,   340,   341,     0,   342,   343,   344,   345,     0,
     346,   347,     0,     0,     0,     0,     0,     0,     0,     0,
     348,   349,   350,     0,     0,   351,     0,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,     0,
       0,   364,   365,   366,     0,   367,     0,   368,   369,   370,
     371,   372,     0,   373,   374,   375,     0,     0,   376,     0,
       0,     0,   377,   378,   379,   380,   381,     0,     0,   382,
     383,   384,   385,   386,     0,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,   393,     0,   394,   395,     0,
     396,   397,     0,     0,     0,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,     0,   408,   409,     0,     0,
       0,   410,   411,   412,   413,     0,     0,     0,   414,     0,
       0,     0,   415,     0,   416,   417,   418,   419,     0,   420,
     421,   422,   423,   424,   425,     0,     0,     0,     0,     0,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,     0,     0,   433,   434,     0,   435,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   443,   444,
       0,   445,   446,     0,   447,     0,   448,   449,   450,   451,
       0,   136,   452,   453,     0,   454,   455,   456,   457,     0,
       0,     0,     0,     0,   458,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,   476,     0,     0,     0,     0,     0,
       0,   477,     0,     0,   478,     0,     0,     0,   479,   480,
     481,   482,   483,   484,     0,     0,     0,     0,     0,     0,
     485,   486,     0,   487,   488,   489,     0,     0,   490,     0,
     139,     0,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,     0,  3449,   148,   149,
     150,   151,   152,   153,     0,     0,  -329,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,     0,     0,     0,     0,   164,  3887,     0,
     165,   166,     0,   167,     0,     0,     0,     0,     0,   171,
     172,   173,   174,  3888,   176,   177,     0,   178,   179,     0,
       0,     0,     0,     0,     0,     0,   186,     0,   188,     0,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,     0,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,     0,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,     0,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
       0,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,     0,     0,     0,     0,   236,
     237,   238,     0,     0,   239,   240,  3889,   241,   242,   243,
       0,     0,     0,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,     0,   256,   257,     0,     0,     0,     0,
       0,     0,   260,     0,     0,     0,   261,   262,   263,   264,
    3890,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,     0,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,  3891,     0,     0,   277,     0,
       0,     0,   279,   280,     0,     0,   281,  3892,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,  -284,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
       0,   333,   334,   335,   336,     0,     0,     0,     0,   338,
       0,     0,     0,     0,   339,   340,   341,     0,   342,   343,
     344,  3893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,     0,     0,     0,     0,
     352,   353,   354,     0,   356,   357,   358,   359,   360,   361,
     362,     0,     0,     0,     0,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   373,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,     0,
       0,   389,     0,   391,  -284,     0,   392,     0,     0,     0,
     394,     0,     0,   396,   397,  3894,     0,     0,     0,   399,
     400,   401,   402,   403,   404,     0,   406,   407,     0,   408,
       0,     0,     0,     0,   410,   411,   412,     0,     0,     0,
       0,   414,     0,     0,     0,   415,     0,     0,   417,     0,
     419,     0,   420,     0,   422,     0,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   443,   444,     0,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,     0,   452,   453,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,   458,   459,   460,
       0,     0,     0,     0,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,     0,     0,     0,     0,   471,     0,
       0,   472,     0,     0,     0,   474,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,   484,     0,     0,  -284,
       0,     0,     0,   485,     0,     0,   487,     0,   489,     0,
     139,   490,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,  4441,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,   992,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,     0,   239,   240,     0,   241,   242,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,   617,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
       0,   333,   334,   335,   336,     0,     0,     0,   337,   338,
       0,     0,     0,     0,   339,   340,   341,     0,   342,   343,
     344,   345,     0,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,     0,     0,   351,     0,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,     0,   364,   365,   366,     0,   367,     0,
     368,   369,   370,   371,   372,     0,   373,   374,   375,     0,
       0,   376,     0,     0,     0,   377,   378,   379,   380,   381,
       0,     0,   382,   383,   384,   385,   386,     0,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,   393,     0,
     394,   395,     0,   396,   397,     0,     0,     0,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,     0,   408,
     409,     0,     0,     0,   410,   411,   412,   413,     0,     0,
       0,   414,     0,     0,     0,   415,     0,   416,   417,   418,
     419,     0,   420,   421,   422,   423,   424,   425,     0,     0,
       0,     0,     0,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,     0,     0,   433,   434,
       0,   435,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   443,   444,     0,   445,   446,     0,   447,     0,   448,
     449,   450,   451,     0,   136,   452,   453,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,   458,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,   484,     0,     0,     0,
       0,     0,     0,   485,   486,     0,   487,   488,   489,     0,
       0,   490,   139,     0,   140,   141,   142,   143,   144,     0,
       0,   145,     0,  1171,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
    2102,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
    2780,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
    3110,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
    3454,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,  2425,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,  2426,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
    2427,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  2428,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,  1034,  1035,     0,
     337,   338,     0,     0,  2429,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,  4421,   563,  4422,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  2430,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,  1581,     0,     0,  2946,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,  1582,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
    2947,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  2948,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  2949,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  2950,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,  1581,     0,     0,  3881,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,  1582,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
    2947,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  2948,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  2949,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  2950,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,  1581,     0,     0,  4165,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,  1582,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
    2947,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  2948,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  2949,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  2950,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,  2624,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2786,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,  2252,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,  2253,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,   969,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
     970,   971,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   972,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  1857,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  1858,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,  1859,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  1860,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,  2794,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2795,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  1857,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  1858,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  1860,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,  2624,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2786,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,  1857,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,  1858,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,   736,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,  3603,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,  1860,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,   992,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,  1381,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,  2624,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2837,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   617,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,  2776,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,  4339,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
    4340,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,   563,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,  1070,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2023,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2356,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,  2357,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,  2875,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,  2967,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,   136,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2356,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
    1774,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,  1775,   335,   336,     0,     0,     0,
     337,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,   345,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,   348,   349,   350,     0,     0,
     351,     0,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,     0,   364,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
     393,     0,   394,   395,     0,   396,   397,     0,     0,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
       0,   408,   409,     0,     0,     0,   410,   411,   412,   413,
       0,     0,     0,   414,     0,     0,     0,   415,     0,   416,
     417,   418,   419,     0,   420,   421,   422,   423,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,     0,     0,
     433,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,   486,     0,   487,   488,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,  -299,  -299,
     222,     0,  -299,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,  -320,     0,
     222,     0,  -320,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,  -320,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,  -317,     0,
     222,     0,  -317,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,  -317,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,  4229,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,  -322,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,  4344,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,  4390,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,  -303,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,     0,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3887,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3888,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,     0,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3889,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3890,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3891,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3892,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,  3893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,  -284,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,  3894,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,  4232,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,  -284,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,   139,   490,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,     0,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
       0,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,     0,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,     0,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,     0,   333,   334,   335,   336,     0,     0,     0,
       0,   338,     0,     0,     0,     0,   339,   340,   341,     0,
     342,   343,   344,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,     0,     0,
       0,     0,   352,   353,   354,     0,   356,   357,   358,   359,
     360,   361,   362,     0,     0,     0,     0,   365,   366,     0,
     367,     0,   368,   369,   370,   371,   372,     0,   373,   374,
     375,     0,     0,   376,     0,     0,     0,   377,   378,   379,
     380,   381,     0,     0,   382,   383,   384,   385,   386,     0,
     387,     0,     0,   389,     0,   391,     0,     0,   392,     0,
       0,     0,   394,     0,     0,   396,   397,     0,     0,     0,
       0,   399,   400,   401,   402,   403,   404,     0,   406,   407,
       0,   408,     0,     0,     0,     0,   410,   411,   412,     0,
       0,     0,     0,   414,     0,     0,     0,   415,     0,     0,
     417,     0,   419,     0,   420,     0,   422,     0,   424,   425,
       0,     0,     0,     0,     0,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   443,   444,     0,   445,   446,     0,   447,
       0,   448,   449,   450,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,   458,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,   472,     0,     0,     0,   474,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,   484,     0,
       0,     0,     0,     0,     0,   485,     0,     0,   487,     0,
     489,     0,     0,   490
};

static const yytype_int16 yycheck[] =
{
       6,   645,   576,   553,   985,    20,   599,   576,  1175,  1145,
    1102,   896,   986,    19,    29,   124,    22,   693,  1690,  1074,
    1483,    36,  1175,     6,   613,   672,    32,  1828,  1829,   810,
     698,  1121,   719,    39,  1068,  1069,    42,   921,  1384,  2016,
      46,  1307,  1384,  1816,   948,  2477,  2051,  1481,    54,  2518,
     521,  2288,  1197,  2326,  2407,  2118,  2585,  2599,  1238,  1204,
    2759,   990,  2814,  3203,  2395,   949,  2097,   923,  2131,  1205,
    1206,  1472,  1112,  1209,  1210,  1211,  1212,   990,  1214,  1215,
    1216,  1217,  1218,  1219,  1220,  1221,   754,    22,   764,   757,
      96,  1956,   948,     4,  1911,  1912,  1315,  1464,  2217,   641,
     642,  1958,  1816,  1887,   654,   655,  2013,  2076,   659,  2132,
    1956,  1928,  2349,   119,  2959,   121,  1395,   123,   124,   125,
    2339,  2260,  3209,  2472,    25,   772,   773,   774,  1945,  1946,
    2076,  1959,  3092,    19,  1413,  1963,    17,   784,   121,   783,
     123,  2388,  1421,  1422,  1961,  1962,  1974,  1964,    10,  2396,
    1967,  1968,  3439,    17,  1971,  1454,  1984,   879,  1525,  1976,
    2676,    96,    34,  1980,  1981,  1982,  1983,  3227,  2451,    30,
    1987,  1988,  3486,  1990,    82,    19,    16,    17,    83,  1996,
    3266,  3267,  1999,  2000,  3270,  2002,    16,    17,    59,    60,
    1939,    73,    16,    17,    47,    19,    19,   131,     9,  2613,
    2614,    19,   112,  3289,    82,  2619,  1930,  2621,    82,   950,
    3296,  2076,    51,  2865,    16,    17,  2587,    28,  2211,  2101,
     195,    21,  3923,   812,    35,    16,    17,    21,    60,   151,
    2076,    56,  2440,    16,    17,  1902,  2436,  2437,  2752,  1827,
      34,    70,   964,  2060,  2061,  2062,  2063,  2561,    86,    90,
      71,  2454,    51,   193,    48,    16,    17,    63,   145,    59,
      60,   341,   195,    71,   354,    59,    60,    16,    17,   217,
      34,   157,   340,   387,   147,   161,   157,    58,   267,   209,
     341,   128,   128,    25,  1464,   874,  3496,  1948,  2037,    16,
      17,   388,  3378,  2042,   362,  3435,   251,   449,    52,  2048,
    2049,   647,     8,  3041,  2053,    36,  2065,   226,    40,    63,
     157,   422,   466,    16,    17,    20,   992,   130,   140,    16,
      17,   130,    23,   134,    63,   114,  2366,    43,  2746,    36,
      16,    17,   233,   129,    21,   274,   128,   434,   161,    16,
      17,   512,  2944,   161,   222,  1525,   224,    34,   222,  2380,
     224,  4052,   128,  2553,  2554,   539,    16,    17,   166,   146,
     584,    48,   190,    16,    17,   157,   510,   393,   484,   571,
      16,    17,    59,    60,  3671,   253,   605,   210,   129,   253,
     507,   157,  2359,  2360,  2361,   628,   539,   628,   192,    64,
     192,   608,     8,   636,   175,   636,   591,   506,   179,   594,
      41,   630,   215,    16,    17,   629,   630,   308,   151,   190,
    3707,   538,    16,    17,    30,  2833,   355,   159,  2458,   132,
     188,   254,   175,   151,  1111,    16,    17,   629,   133,   404,
     132,    16,    17,   542,   588,   589,   552,  3523,  1125,    70,
     244,   230,  2482,  2483,   164,   385,  3532,   243,   592,   277,
     189,   635,    16,    17,  1235,   566,    16,    17,   226,   539,
    1434,   807,   157,  2345,   490,   192,   337,   285,   169,  2394,
    3556,   404,   285,  1015,   628,  3561,   285,   183,   539,    16,
      17,  2616,   213,   214,   636,   565,   657,   190,    66,   188,
    2821,   233,   243,   448,   135,   317,  1046,  1047,  1048,    68,
     506,  3788,   508,   376,   565,  1389,   213,   214,  1392,   599,
     356,  1974,  3599,  1397,   628,  3725,   584,   157,   389,   525,
     274,   440,  3662,   529,   237,  1454,    25,   226,   353,  3267,
    2883,   371,   538,   630,   374,   316,   542,   301,   544,  1423,
    1424,  1454,   404,   483,  2763,  2764,  2765,   371,   628,  2456,
     374,   557,   373,  2460,    16,    17,  1200,   175,   533,   489,
    1740,  1208,   510,  1930,  3216,   373,   308,  2474,  2475,   371,
    2601,   412,   374,   268,   249,  2440,  1298,  2484,  1225,   585,
     371,  2864,  1718,   374,  2867,  2868,  2269,   474,   371,  1956,
    1446,   374,  2561,  1729,  2440,  1524,  1732,   312,   604,   417,
     533,  3483,  1881,  2886,  2005,  2512,  1328,   613,   447,   615,
     371,  1524,   354,   374,   603,  2561,  1087,  1088,  3134,   425,
     626,  3708,   371,   461,   340,   374,   632,    73,   268,  3143,
    3232,   637,   413,   639,   545,   641,   642,    16,    17,  3010,
     646,   647,   504,  1114,   371,   651,  2854,   374,   447,   632,
    2467,  1122,  2401,  1124,  3406,   661,   662,   663,   563,  2862,
     413,   667,  2479,   402,   572,  1136,  1137,  1138,   371,  2983,
    4371,   374,  1712,  1144,   371,   586,  2583,   374,  1419,   466,
     602,   510,   560,  1464,  2677,   371,   550,   597,   374,   550,
    3206,   626,  1281,   555,   371,  2419,  2561,   374,  2065,  4013,
     809,  1243,   637,    16,    17,  1797,   584,    16,    17,  2076,
    2459,   371,  2461,   719,   374,  2561,  2598,  3804,   371,  2468,
    2387,   374,   656,   534,   605,   371,  3786,   550,   374,   630,
    3690,   605,  2481,  3006,   233,   597,  2767,  2768,  2487,  2488,
     584,   552,  2559,   596,  1525,  3627,   628,  3834,   634,   560,
    1930,  2890,   605,   634,  2503,  2504,   628,  4044,   371,   591,
    2059,   374,  1351,  2351,   635,    16,    17,   371,  1310,   569,
     374,   777,   514,   779,   614,   569,   587,  2438,  2527,   511,
     371,   542,  2982,   374,   614,  1327,   371,   634,  1510,   374,
     614,   630,   610,   633,  3676,   413,  2555,   803,   804,   805,
     532,   807,   808,   809,  1393,   811,   812,   371,   539,   308,
     374,   371,   614,   922,   374,   583,  2793,    16,    17,    16,
      17,   804,  1373,   614,   613,   808,   558,   629,   811,    16,
      17,   614,   539,   572,   371,   584,  3250,   374,   629,   630,
    3254,   628,   634,   849,   519,   632,   629,   630,   417,   630,
      16,    17,  2829,   614,  3941,   354,   862,   599,   634,   602,
     159,  2295,  3193,   111,   577,   614,  3197,  3140,   874,   875,
    3284,  3285,  3286,   879,   602,   577,  4163,   630,  3292,   510,
     600,   630,   569,   192,   583,  2065,  3300,   614,   630,  1458,
     125,  3240,    16,    17,    16,    17,  2076,  2822,  2823,  2700,
      16,    17,   125,   630,    16,    17,   484,   594,   603,   371,
    3033,   614,   374,   628,    88,  3152,   922,   614,    16,    17,
     168,    46,    16,    17,    16,    17,   629,   862,   614,  3148,
    3213,  4017,   629,  4019,   233,  2736,  3478,   614,  3783,   634,
     875,   628,   157,   629,   630,    11,  3193,   195,    16,    17,
    3197,  1638,   629,  3367,   614,    16,    17,   868,   964,   366,
     406,   614,  3376,   603,   582,    16,    17,   178,   614,   629,
     630,   192,   161,  1877,    16,    17,   629,   630,  4065,   301,
     986,    51,  1533,   629,   630,  3016,  1870,  2760,   442,  2854,
    2453,  2454,   371,   357,   634,   374,  1880,   482,   175,  1883,
    1884,   614,   360,  1907,  4091,   816,    16,    17,  2854,  1015,
     614,   226,   630,   431,  2983,   514,   629,   630,   353,   285,
    2156,  1877,  3045,   614,  2370,   629,  2372,  2373,  2812,   614,
    2372,  2373,  4172,  2716,  2717,  2718,   230,  2983,   629,   630,
     390,   270,  4010,    16,    17,   630,  2760,   282,  2103,   268,
     614,  1907,  2419,    25,   614,   354,    16,    17,   371,   282,
    1066,   374,   371,   129,  1070,   374,   630,   372,   460,  3188,
     630,  2928,  3954,  2440,    16,    17,  4048,   614,  1187,    16,
      17,    16,    17,   529,  1731,   210,  2231,   505,  2307,    82,
     575,    16,    17,   630,   222,    12,   224,   432,    16,    17,
     599,  2929,  2381,    96,   389,  1111,    25,  2508,   554,  3991,
      82,   285,    64,  3248,  3249,  1224,    16,    17,  2983,  1125,
     371,  3256,   357,   374,  3259,  3260,   347,    16,    17,  1816,
    2059,  1066,   617,  2399,   357,  1070,  3678,  2983,  4106,  3470,
    3471,  3276,  2814,   136,   282,   356,  2059,  2237,  2238,  1930,
     794,   417,   614,   372,   125,  3290,   404,  1746,   210,  2326,
    3137,  3296,  3297,  3298,  3299,  3891,  3892,  2303,   630,  1175,
     628,  3202,   371,   369,   371,   374,   630,   374,  3301,    16,
      17,  1187,   115,   284,   371,   118,  1736,   374,  2555,   466,
    2230,    32,  1781,   161,  2561,   654,   655,    12,   235,  3176,
    2240,   251,   254,   226,   176,   371,  1748,   244,   374,  1318,
      16,    17,   126,   263,   185,   514,  1805,  1806,  1224,   357,
      16,    17,   190,  1229,   141,   440,   202,   456,  1234,   636,
    2397,    16,    17,  3932,  3369,   614,   413,  1243,   484,  2419,
      16,    17,  1792,   887,  2397,   154,  3998,   371,   598,   371,
     374,   630,   374,   533,   539,   371,   165,   621,   374,   371,
    3789,   233,   374,   256,    16,    17,    16,    17,  1837,   351,
      16,    17,   630,   371,   361,  1281,   374,   371,    12,   371,
     374,   125,   374,   353,  2065,   533,   475,  1293,   104,  1295,
     268,  2725,  1298,  3762,    82,  2076,  3359,   249,   274,  1234,
     599,   614,   389,   371,  1310,   614,   374,   555,   374,   183,
     371,   282,  1318,   374,   233,  4455,  3223,   630,   400,  2486,
     371,  1327,  1328,   374,  3597,   630,   141,   562,   242,   371,
    4302,   630,   374,  2486,   459,   328,   308,  3244,   439,   562,
     377,   185,   365,  3772,   610,  1351,   557,  3762,  1354,   597,
     279,   628,  1461,  4016,    16,    17,  1362,   350,   351,   142,
     353,   371,   573,   614,   374,   226,    16,    17,  1374,  1375,
    1376,  1377,  1378,  1379,     0,  2555,   348,   447,  1384,   630,
     404,  2561,   354,   257,  1390,  1391,   357,  1393,  1299,   308,
    1396,  1374,  1375,  1376,   372,  1378,   192,   349,   371,  2862,
     215,   374,   452,   244,   474,   582,   335,   141,  1391,   508,
    1416,   371,   466,  1396,   374,   614,   192,   614,   234,   634,
     318,   529,   415,   205,   285,   533,   267,   614,    12,   371,
     529,   630,   374,   630,   371,   251,   371,   374,   282,   374,
      16,    17,  1377,   630,  1379,   233,   371,   263,   614,   374,
     205,    89,   539,   371,   341,  1461,   374,   157,  1369,  2805,
    2552,   370,  3891,  3892,   630,  1109,  2929,    16,    17,  1475,
     108,   371,  1478,  1479,   374,   466,   399,    16,    17,   353,
     504,  1416,   371,   466,  3837,   374,  3463,  2854,   533,   466,
     614,   161,   614,    16,    17,   471,   251,    80,   614,   466,
      16,    17,   614,   604,  1510,   419,   630,   475,   630,  4235,
    4236,   504,   301,   357,   630,  1159,   614,  3790,   630,  1163,
     614,   161,   614,  1529,   340,  1531,  1532,   192,  1534,  1535,
     268,   555,   630,   341,   371,   509,   630,   374,   630,   513,
    1475,  1547,   514,  1549,  1479,  2600,   614,   330,  1531,  1532,
    3613,  2696,   413,   614,   506,  1014,  1467,   141,    16,    17,
     348,   466,   630,   614,    12,   371,   354,   519,   374,   630,
    3319,   466,   614,   597,   628,   371,   241,  3554,   374,   630,
    2747,   510,   233,    16,    17,   426,   371,  2234,   630,   374,
    4059,   562,   629,   571,  2747,   371,    16,    17,   374,  3836,
      16,    17,   516,   168,   614,  1064,   189,   466,  4037,  4038,
     543,  4274,  4275,   546,  4083,  4084,  2983,   372,    12,   371,
     630,   371,   374,   412,   374,   371,   244,   599,   374,   538,
      16,    17,  1638,  1639,   372,   423,   452,   628,  2419,   537,
    1749,   614,   466,   230,  4059,   628,   264,   230,    16,    17,
    2742,   628,   539,   542,   614,  2126,   560,   630,    12,   611,
     129,   628,  2133,  2331,  2332,  2333,   564,   254,  4083,  4084,
     630,   254,   614,    16,    17,  2146,   202,   614,   565,   614,
     584,    16,    17,   498,   499,  3119,   501,   629,   503,   614,
    1696,   192,   629,   141,   629,   484,   614,    16,    17,   515,
     515,  2505,  4131,   354,   629,    16,    17,   372,  2179,   371,
     235,   629,   374,    17,   614,  3720,  3721,  4146,   562,   244,
     138,   371,  3495,   628,   374,   614,   514,    16,    17,   629,
    4159,   539,  1738,   628,  3406,   153,    12,   632,    16,    17,
    1746,   628,  1748,  1749,   636,    16,    17,   141,   274,   550,
    2339,  4038,    16,    17,  1760,   225,  1762,   565,   289,   290,
    4192,   269,  1768,  1769,   272,  1771,    42,   268,  3541,   628,
     205,    16,    17,   533,  2555,  1781,  2247,   614,  1784,   567,
    2561,   393,  1788,   350,   351,    16,    17,   141,  2880,   168,
      16,    17,   629,   536,  4223,   371,    16,    17,   374,  1805,
    1806,  1807,  1808,  2983,   628,   388,  4235,  4236,   614,  3559,
    1816,   599,  3562,  1819,  1820,  1821,   195,   633,   614,   402,
     628,    97,   371,   629,   529,   374,   102,   168,   533,   614,
    1836,   230,   371,  1768,  1769,   374,  1771,   363,   614,  1845,
     623,   624,   625,   626,   629,    16,    17,  4177,   371,  1784,
    4180,   374,   377,  1788,   195,   371,  4285,  4000,   374,  4002,
    3343,  3344,   614,   514,   614,  3615,  4295,  3256,   614,    31,
    3259,  3260,  1807,  1808,  2759,   580,  1882,   629,   490,   629,
     584,    16,    17,   629,  1819,  1820,  1821,  3276,  1894,    16,
      17,   230,  1803,    82,   230,  1901,  2800,  2466,   429,   430,
      16,    17,    16,    17,    21,  2809,   414,  4336,   622,  4338,
     111,    16,    17,   371,   205,   629,   374,    34,   225,  4348,
      16,    17,    84,  3189,   366,    17,   630,  2811,    12,  1840,
    3020,    48,   636,  1002,  1003,  4364,  4223,  4366,   371,  4368,
     241,   374,    59,    60,  2800,   471,  4375,  1882,   599,   622,
     584,   371,   614,  2809,   374,   371,   629,  4386,   374,   192,
    3050,  3051,    39,  3940,   614,  2074,  1901,   629,    47,    46,
     246,  2080,  1041,  4402,  4403,   589,  4306,  3144,   474,   629,
    3369,  3071,   605,    16,    17,   371,    19,   285,   374,  4418,
    4419,   417,  1998,   155,  4423,   634,   630,    16,    17,   629,
      19,  3347,   636,   371,  1915,  3347,   374,  2013,  3491,  2118,
     629,   630,   438,  1924,  1925,   216,    16,    17,    16,    17,
     629,   630,  2131,   636,  1935,  1936,  1937,  1938,   371,  1940,
    1941,   374,   178,   222,  3201,   224,   371,   578,   614,   374,
     368,   317,   504,   469,    16,    17,    59,    60,  3201,  4336,
     142,  4338,   371,   629,   628,   374,  1282,   141,    71,  1285,
     371,   189,  1288,   374,   253,   614,  2870,  3234,  2074,  3818,
    3819,  3820,     6,  2760,  2080,   614,  2082,  4364,   440,  2085,
     629,  3234,   371,   629,   630,   374,  2092,  2093,  2094,  2095,
     629,   614,  2098,   371,  4071,   628,   374,  2901,   614,    11,
     371,   628,  2085,   374,   380,   539,   629,   371,  2912,   628,
     374,  2915,  2118,   629,  2223,  4402,  4403,  3934,   606,   607,
     123,    16,    17,    17,   628,  2131,   371,  2038,  2039,   374,
    2041,   215,  2043,  2044,  2045,  2046,  2047,   628,    19,  2050,
     371,  2052,   630,   374,   144,   371,  2255,   628,   374,   629,
     630,   371,  2702,   628,   374,  2744,   614,  2092,  2093,  2094,
    3977,  3978,  2966,     6,  3981,  3982,  3983,  3984,  3969,   628,
     466,   629,   628,   732,  2763,  2764,  2765,   378,   474,  3517,
    3518,   614,   628,   155,  3218,  3219,   630,   455,   389,   629,
     630,   628,  3530,   752,   614,   396,   629,   628,   614,  3537,
     371,  2790,  2983,   374,   350,   351,   765,   766,   636,   629,
     356,    59,    60,   629,    57,  3305,   492,  2223,   221,   628,
    2691,   579,   580,   104,   582,  3563,  3564,    25,   614,  3712,
    3713,   628,  3715,  3716,   629,   630,   371,   399,   330,   374,
    3703,  3704,  2248,   629,   371,   628,   614,   374,   142,  2255,
     526,  2360,   628,  2362,  2363,   371,   125,   371,   374,   421,
     374,   629,   530,  2269,  4081,  4082,   371,  3434,   536,   374,
     172,   614,   628,  4090,   584,   371,   157,   628,   374,   614,
     161,  3434,   629,   630,    82,   514,   629,   488,    80,   455,
    3345,   453,   588,   589,   629,   614,  2302,  2406,  2407,   629,
     630,   628,   145,   614,   104,   629,   630,   188,  4057,   190,
     629,   628,   580,   629,   630,   628,   185,   320,   629,   628,
    2326,   324,   628,    82,   205,   614,  3998,   362,   331,   597,
     211,   628,   628,  2339,   629,   630,   614,    96,   371,   529,
     629,   374,   628,   614,   213,   226,  2352,   509,  2354,   628,
     614,   629,   371,   234,  2360,   374,  2362,  2363,   629,   628,
     241,   159,   628,   142,  2370,   629,  2372,  2373,  2477,   614,
     251,   371,   628,   371,   374,   628,   374,   628,   176,   580,
     629,   630,   263,   614,   629,   477,   478,   268,   614,   629,
     630,  2397,   628,  3485,   614,   403,   277,   189,   629,   371,
    2406,  2407,   374,   629,   629,   630,   629,   630,   411,   629,
     628,   557,  3386,   282,   498,   499,   500,   501,   502,   503,
     592,   593,   369,   595,   628,   597,    19,   573,    58,   125,
     628,   515,  2447,   142,   234,   233,   330,    32,   230,   362,
    2446,  2352,  2457,   614,   628,  2451,   542,   628,  2463,   628,
    2456,   251,   569,  1769,  2460,  1771,  2462,   362,   629,   340,
     628,   464,   254,   263,   628,   244,  2472,   628,  2474,  2475,
    2485,  2477,  4449,   590,   591,   628,  2491,   628,  2484,   614,
    2486,   362,  2497,  2498,   629,   630,   628,   614,   357,   185,
    2496,   372,   629,   630,   629,   629,   630,   256,   614,  2505,
     614,   630,   629,  1819,  1820,  1821,  2512,  2513,   351,   614,
     308,   104,  2518,   629,   226,   629,   628,   213,   614,  2525,
     628,  3168,   628,   404,   629,   628,   222,   619,   620,   621,
     622,   623,   624,   625,   626,   628,   203,   490,   629,   630,
     340,   629,   630,   125,    49,   175,   128,   142,   125,   179,
     348,   330,   628,  2464,  2465,   628,   354,   629,   630,  3148,
     190,  2496,    11,   628,   157,   629,   630,   628,   161,   328,
     628,   452,   628,   416,   628,   418,  2582,  2583,   628,  2490,
    4381,   614,    82,   477,   478,   628,   282,   628,  3059,   628,
      26,    27,   628,   474,   353,   614,   628,   190,   601,   629,
     630,   629,   630,   185,   629,   630,   125,  2518,   185,   128,
     402,   628,   205,   616,   614,   629,   614,   628,   211,   629,
     630,   330,   628,    59,    60,    19,    62,   628,  3099,   151,
     152,   213,    26,   628,   515,    71,   213,   628,   305,   306,
    2551,   234,   614,   310,   311,   628,    82,  2582,   241,   244,
     629,   630,   452,   628,    90,  4456,   415,   628,   251,   159,
     628,   357,   111,   629,   630,   628,   185,   629,   630,   628,
     263,   279,   267,   629,   630,   268,    49,    71,   114,   630,
     129,   629,   630,   362,   277,   362,   316,   460,    82,   571,
     571,  3827,   128,   562,   213,   131,   629,   630,   477,   478,
     282,   167,   583,   584,   623,   282,  2712,   629,   630,  2715,
    2716,  2717,  2718,   629,   630,   515,   514,   474,  2724,   168,
    3796,  3797,   603,   159,   605,   619,   620,   621,   622,   623,
     624,   625,   626,   233,   128,   330,   628,  2743,  2744,   629,
     630,  2747,   629,   630,   268,   504,   195,   340,   629,   630,
     629,   630,   633,   634,  2760,   350,   351,  2763,  2764,  2765,
     629,   629,   630,   282,   629,   630,  3740,   629,   630,   362,
    2776,   190,  3746,    82,  2883,   357,  2782,  3327,  2784,   372,
     357,    90,   510,   413,  2790,   529,   222,  3356,   224,  2724,
     629,   630,   629,   630,   230,   629,   630,    16,    17,  2805,
    3967,   599,   238,   167,   198,   114,   629,   630,   629,   630,
     125,   404,   629,   630,  3967,   629,   630,   253,  3642,  3643,
    1160,  1161,  3154,  3155,  3112,  3113,   510,   279,   222,   278,
     224,   426,   630,  3415,  3416,   158,    91,   125,   357,   630,
     619,   620,   621,   622,   623,   624,   625,   626,   348,   364,
     159,   525,   629,   157,   354,   128,   104,   114,  2864,   452,
     254,  2867,  2868,    26,  2870,  2776,   562,   635,     6,  3945,
     185,   307,   628,  3949,  1080,  1081,  1082,  2883,  3970,   113,
    2886,   474,   477,   478,     4,    85,   465,    87,   244,   325,
     597,   630,  1098,   388,    56,  2901,   491,   185,   213,   432,
     119,   120,   121,   122,   123,   172,  2912,   114,    71,  2915,
     223,   630,   621,   622,   623,   624,   625,   626,   636,    82,
     630,   230,   515,   423,  1130,   213,    71,  1133,   128,    12,
     602,  2937,   629,   539,  2940,   629,   141,     9,   630,  2945,
     629,   636,   629,   379,   159,   381,  1152,  1153,   636,   149,
    1156,   267,   628,   389,  2960,   404,   350,   351,  2964,    63,
    2966,   636,   356,    49,   630,   128,   635,   282,   362,   279,
    1176,  1177,   279,  2884,   279,  2981,    80,  2960,   571,   279,
     562,  2892,   279,   279,   184,   562,   234,   630,    92,   529,
    2996,   584,   628,  4085,   282,   274,   630,  3003,   307,   218,
     219,   220,   221,   251,  4171,  2940,   387,   630,   402,  3015,
     603,   550,   605,   630,   514,   263,   325,    12,  4171,   550,
     630,   457,   161,   472,   619,   620,   621,   622,   623,   624,
     625,   626,  4108,  4109,   630,   244,   629,   630,   630,   348,
     633,   634,   357,   562,  4018,   630,   245,  3932,  3157,  3717,
    3718,  3719,   623,   527,    36,   504,   180,   190,   142,   222,
     630,   224,   576,   630,  3173,   487,   391,   567,  3003,   357,
     137,   362,   161,   162,   630,  3751,   470,  2988,   514,   629,
      34,   530,   630,   161,   161,   189,   161,  3093,   161,   630,
     194,   254,   340,   161,   530,  3101,   161,   161,   534,   599,
     161,   320,   161,   322,   323,   324,    60,   196,   161,   161,
    3679,   161,   331,   161,   362,  3665,  4252,   553,   207,  3125,
      26,    27,   161,   161,   523,   524,   230,   161,   527,   528,
     630,    36,   531,   161,   533,   571,   118,   161,  3144,  3145,
     578,   609,  3148,   125,   583,   362,   195,   630,   597,   125,
     254,  3157,   371,    59,    60,   374,    62,  3163,   247,   362,
     362,   115,   192,   192,   118,    71,   104,  3173,   629,   629,
     259,   629,   126,   629,   629,  3181,    82,   623,   572,   629,
     380,   496,  3775,   630,    90,   629,   629,   350,   351,   143,
    3101,   622,   411,   356,   630,  3201,   178,   286,   628,   362,
     629,   629,  3878,   185,   452,   514,   629,  3213,   114,   185,
     630,   629,   629,   118,   630,   629,  4352,  3223,   629,  3225,
     125,   530,   128,    63,   424,   131,   629,   571,  3234,    60,
     475,   213,   214,   628,  3240,   628,  3242,   213,  3244,   402,
      80,   626,   628,   630,   463,   464,   330,   562,   550,  4416,
    3359,   629,    92,   159,   603,   344,   628,  3831,   232,   521,
      11,   203,   192,  4416,   192,   636,   629,   515,   170,   456,
     412,   630,  4439,   178,   562,   161,   474,   630,   142,  4446,
     185,   190,    47,   338,   115,  4452,  4439,   118,   242,  4263,
    4264,   504,  4266,  4446,   504,   126,   234,   183,   402,  4452,
     282,   465,    80,   504,   550,   137,   282,   470,   213,   214,
     196,  3317,   143,   251,   504,   504,   222,   388,   224,   388,
     252,   207,   111,   252,   230,   263,    13,   137,   388,    47,
    3880,   388,   238,   530,    34,   142,  3342,  3343,  3344,   530,
    3449,  3347,   521,  4317,   388,  4319,  4320,   253,  1554,   189,
     386,   388,   628,  3359,   194,   186,   388,   388,   628,   341,
     278,   267,   628,   584,   636,   435,   629,    67,   155,   629,
     352,   257,   240,   259,   356,   357,   629,   282,   240,   168,
     636,   357,   601,   630,   636,   629,   629,   629,   342,   493,
     230,   550,   629,   477,   478,   614,   615,   616,   636,  3310,
     286,   307,   340,  4377,  4048,   636,   195,   629,   636,   572,
     636,   242,  3986,   550,   254,   814,   103,   539,   550,   325,
     274,    88,  3333,  3429,   362,   610,   630,    47,  3434,   161,
    3539,   550,   628,  4414,  1640,   135,   341,   244,  1644,   161,
     628,   230,   628,  3449,   628,   132,   369,   192,   192,   192,
     241,   356,   357,   192,   636,   248,   636,   170,   145,   159,
    1666,   347,   357,   163,   630,   251,   330,   251,   572,   321,
     114,   375,   114,   379,   254,   381,   636,   254,   628,   628,
     368,   168,   205,   389,   171,  3491,  3501,   550,   539,   278,
     449,   388,   628,   672,   372,   182,   636,   197,   677,   628,
    4050,   628,  3508,  4072,  3613,   623,   242,   242,   339,   605,
     636,   342,   629,   629,   452,   401,   203,   217,   629,   629,
     629,   629,   629,   330,   629,   623,   628,   362,   482,   226,
     629,   231,   269,  3539,   629,   714,   620,   621,   622,   623,
     624,   625,   626,   230,   388,   630,   636,   192,   388,   630,
     237,   457,   731,   244,   577,   265,    71,   539,   251,  3565,
     362,   543,   402,   251,   546,   254,  3572,   400,   630,   254,
     628,    82,  3681,    19,   630,   557,   630,   515,   490,   279,
     562,   628,   628,   565,  3590,   142,   562,   629,   419,   630,
     277,   362,   546,   772,   773,   774,   775,   630,   362,   362,
     362,   301,   629,    47,   629,   784,   466,  3613,   514,   628,
     399,   628,   628,   477,   478,   404,   268,   628,    47,   629,
     468,   575,   629,   417,   530,   605,   203,   148,   534,  3540,
     261,   629,   629,   205,   539,   476,   630,   628,   543,   621,
     622,   546,   628,   251,   251,   630,   128,   553,   128,   628,
     628,   398,   557,   493,    86,   636,   484,   562,  4302,   144,
     565,   629,   461,   490,   629,   571,   630,   629,  3579,   629,
     477,   478,    19,   629,   629,  3681,   629,   629,    34,    34,
      34,   357,    60,   472,   242,   629,   865,   327,   629,   629,
     629,   256,   412,  3699,   277,   369,   241,   605,   629,   636,
     327,   628,    47,   403,   630,   211,  3712,  3713,   630,  3715,
    3716,   417,   412,    67,   539,   546,   621,   622,   405,   539,
     304,   584,   628,   584,   594,   628,    14,   427,  3837,   628,
     628,   577,   572,   629,   628,   628,   628,  4311,   425,   594,
     128,   530,   254,   628,   575,   445,   433,   536,    19,   254,
     356,    34,   629,   170,   441,   630,  3762,   621,   622,   623,
     624,   625,   626,  4407,  4314,   357,   555,   327,   174,   628,
     456,    17,   630,   330,   588,  3781,  3782,   254,   539,   466,
     539,   135,   539,   533,   484,   485,   628,  3793,   584,   584,
     629,   580,   479,   480,   241,   629,    55,  4441,   362,   352,
     508,   589,   628,   449,   605,   159,    65,   357,   597,   163,
     510,   170,   619,   620,   621,   622,   623,   624,   625,   626,
    3826,   629,    81,  3829,   630,   138,   369,   190,   577,   156,
     520,  3837,   532,  4383,    93,    94,    95,   524,   628,    31,
     637,   190,  1021,   197,   602,   628,   628,  3782,   629,   383,
     109,  3762,    61,   629,   629,   137,   137,   541,   628,   159,
     404,  3867,    73,   217,   425,    31,   192,    63,   555,   629,
     369,   602,    63,   628,   630,   629,   270,   231,   521,    47,
      47,   581,  3888,     5,   241,   155,   628,  3893,   628,   362,
     577,  3826,   579,   362,   369,   369,   634,  1076,  1077,   136,
     144,   628,    47,  4453,    47,   154,  1085,  1086,  1087,  1088,
    1089,  1090,  1091,  1092,  1093,  1094,  1095,  1096,  1097,    47,
     477,   478,   577,   602,   132,   279,  1105,  1106,   155,  1108,
     225,  1110,   284,   634,   637,  1114,   150,   127,  1117,  1118,
    1119,  1120,   456,  1122,  1123,  1124,   628,   301,    47,    47,
      47,   629,  1131,  1132,   634,  1134,  1135,  1136,  1137,  1138,
     254,  3967,  1141,  1142,  1143,  1144,  1145,  1146,  1147,  1148,
    1149,  1150,  1151,   111,    53,  1154,  1155,  4086,   223,  1158,
     630,   629,   458,  1162,   155,  1164,  1165,   542,   208,   630,
      47,   630,   630,   629,  4000,   629,  4002,   634,  4004,  1178,
    1179,    53,   439,   190,   190,   190,   542,  1186,   119,   120,
     121,   122,   123,   226,  1193,  1194,  1195,   604,  1197,   128,
     357,   474,  3933,   628,  4030,  1204,  1205,  1206,   191,  1208,
    1209,  1210,  1211,  1212,   630,  1214,  1215,  1216,  1217,  1218,
    1219,  1220,  1221,  3898,  3319,  2262,  1225,  1226,  3320,   403,
    2054,  2435,   655,  4059,  3588,  3925,   194,  4051,   412,  4242,
     319,  4243,   619,   620,   621,   622,   623,   624,   625,   626,
    4076,  3586,  3590,   427,   999,  4441,  3780,   336,  4394,    46,
    4086,   577,  2760,  4192,  1815,  4404,  4092,  4131,  3772,  3772,
    3772,   445,   230,  3772,  3772,  4282,     6,  4124,  3772,  3772,
    3772,  3772,  4146,    13,  3772,    15,  4282,   218,   219,   220,
     221,  3772,  4236,  3772,  3772,  4159,    26,    27,  4150,  4149,
    1039,  1740,  1470,  1302,  2012,  3930,  1472,  2738,  1480,  2910,
     484,   485,  3428,  2743,  1315,  3125,  3827,  4175,  4076,  3431,
     278,  4352,  4260,  4311,  3986,  1524,   516,    57,  4059,  4258,
    3595,  2005,    62,    63,  2989,  3244,   510,  2013,  2583,    69,
    2515,  3223,  4279,  3880,  3041,  4171,  3738,  3232,  4079,  4080,
    3267,  3301,    82,  3550,  4072,   529,  3539,  3173,   532,   533,
      90,  4008,    11,  1362,    11,  4108,  4192,  1538,  4109,  3936,
     100,  1370,  3949,  3945,  2090,  3793,  3746,  2012,  3225,   677,
    2508,  4207,  4208,   462,   114,   630,  1889,  1430,  3505,   320,
    2321,   322,   323,   324,  1520,   968,  3224,  1807,   128,  2724,
     331,   131,  2343,  3120,  2295,  1479,  2213,   581,   138,   139,
    3774,   598,  1826,   908,  3101,   145,   714,  2122,  2702,  2125,
    2398,  4285,  1125,   153,  3191,  2212,  3852,   157,  4207,   159,
    3706,  4295,  4258,   731,  3317,  4208,  2241,  2805,   517,  3234,
    1098,  3700,  2504,  1446,  4383,  3681,  2348,  2095,  2289,  3434,
    2325,  3139,  4183,  4184,  3138,  3201,   535,  1298,   188,  4171,
     588,  4287,  1547,  1328,   668,  1382,   576,  1878,  4294,  1410,
    1879,  3242,  1759,  1472,  1334,  3123,  4304,   775,  4350,  4199,
     411,  4270,  4452,  4446,  4348,    12,    13,  3541,  3144,  2792,
    1831,  3181,   222,  3460,   224,  3689,  1788,  1352,   228,  1362,
     230,   568,  4366,   890,  4368,  3816,  4435,  1290,   238,  3822,
    2712,  4375,   895,   569,   472,  1529,   512,   512,   655,   655,
     655,    -1,  4386,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   463,   464,    -1,   493,    -1,    -1,    -1,  4365,
      -1,    -1,    -1,    -1,  4370,  4276,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4418,  4419,    -1,    -1,    -1,  4423,
      -1,  1560,    -1,    -1,    -1,    -1,    -1,   865,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,   103,   307,   536,    -1,
      -1,  4407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4416,    -1,    -1,    -1,    -1,   325,    -1,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,  4435,
      -1,    -1,    -1,  4439,   572,  4441,    -1,    -1,   145,    -1,
    4446,    -1,   580,    -1,    -1,    -1,  4452,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,    -1,
      -1,   168,   372,    -1,   171,    -1,    -1,    -1,    -1,   379,
      -1,   381,    -1,    -1,    -1,   182,    -1,    -1,   388,   389,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     601,    -1,    -1,  1672,  1673,  1674,   203,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   615,   616,    -1,  1686,    -1,    -1,
     420,   227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   230,   434,   435,   436,   437,    -1,    -1,
     237,    -1,    -1,  1712,    -1,    -1,    -1,    -1,    -1,  1718,
      -1,    -1,  1721,  1021,  1723,    -1,    -1,   457,    -1,    -1,
    1729,    -1,  1731,  1732,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   287,   288,   289,   290,   291,   292,    -1,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,  1077,
      -1,    -1,    -1,    -1,   514,    -1,    -1,  1085,  1086,    -1,
      -1,  1089,  1090,  1091,  1092,  1093,  1094,  1095,  1096,  1097,
     530,    -1,    -1,  1802,   534,    -1,    -1,  1105,  1106,    -1,
    1108,    -1,  1110,    -1,    -1,    -1,    -1,    -1,    -1,  1117,
    1118,  1119,  1120,   553,    -1,  1123,    -1,    -1,   558,    -1,
      -1,    -1,    -1,  1131,  1132,    -1,  1134,  1135,    -1,    -1,
      -1,   571,    -1,  1141,  1142,  1143,    -1,    -1,  1146,  1147,
    1148,  1149,  1150,  1151,    -1,    -1,  1154,  1155,    -1,    -1,
    1158,    -1,    -1,    -1,  1162,    -1,  1164,  1165,    12,    13,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,
    1178,  1179,   409,    -1,    -1,    -1,    -1,    -1,  1186,    -1,
      -1,    -1,    -1,   429,   430,  1193,  1194,  1195,   425,    -1,
      -1,    -1,    -1,    -1,   634,    -1,   433,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1226,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,    -1,    -1,    -1,    -1,   103,
      -1,    -1,    -1,    13,    -1,    15,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    31,    -1,    -1,    -1,    35,    -1,    -1,   132,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   524,    -1,    49,
      50,   145,    -1,    -1,  1302,    -1,  2005,    57,    -1,    -1,
      -1,    -1,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,   171,   555,    -1,
      -1,    -1,    -1,    -1,    84,    -1,  2035,    -1,   182,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     577,    -1,   579,   103,    -1,    -1,    -1,    -1,    -1,   203,
      -1,    -1,    -1,    -1,  1362,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1370,    -1,   124,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,   133,   134,    -1,   230,    -1,    -1,  2088,
      -1,    -1,    -1,   237,   144,   145,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2104,    -1,   157,    -1,  2108,
      -1,    -1,    -1,    -1,  2113,  2114,    -1,    -1,    -1,    -1,
      -1,   171,    -1,  2122,  2123,    -1,  2125,  2126,  2127,  2128,
      -1,  2130,    -1,   277,  2133,    -1,    -1,   187,    -1,    -1,
      -1,    -1,    -1,    -1,  2143,    -1,  2145,  2146,    -1,  2148,
    2149,  2150,  2151,   203,  2153,    -1,    -1,  2156,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,  2165,    -1,    -1,    -1,
      -1,    -1,    -1,  2172,    -1,  2174,    -1,  2176,  2177,  2178,
    2179,    -1,    -1,    -1,  2183,  2184,  2185,   237,    -1,   239,
    2189,  2190,  2191,    -1,  2193,    -1,  2195,    -1,  2197,    -1,
    2199,    -1,  2201,    -1,    -1,   255,    -1,  2206,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,  2224,    -1,   277,    -1,    -1,
      -1,    -1,  2231,    -1,    -1,  2234,    -1,    -1,    -1,    -1,
      -1,  2240,    -1,    -1,  2243,    -1,    -1,    -1,  2247,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   405,  1560,    -1,    -1,   409,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   433,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   441,    -1,    -1,
      -1,    -1,    -1,    -1,  2303,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,    -1,
      -1,    -1,   466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   384,   479,   480,    -1,   388,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1672,  1673,  1674,    -1,    -1,    -1,
     524,    -1,   432,    -1,    -1,   435,    -1,   437,    -1,    -1,
     440,    -1,    -1,   443,   444,    -1,    -1,     6,    -1,    -1,
      -1,   451,    -1,   453,    13,    -1,    -1,    -1,    -1,    -1,
     460,   555,    -1,    -1,  1712,    -1,   466,    26,    27,    -1,
      -1,    -1,    -1,  1721,   474,  1723,    -1,    -1,    -1,   479,
      -1,   481,    -1,   577,   484,   579,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,   509,
      -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,    26,    27,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1802,   114,    -1,    -1,   558,  2508,
      -1,    59,    60,    -1,    62,    -1,    -1,    -1,    -1,   128,
     570,    -1,   131,    71,   574,    -1,    -1,   577,    -1,   138,
      -1,    -1,    -1,   583,    82,    -1,   145,    -1,    -1,    -1,
      -1,    -1,    90,    -1,   153,    -1,    -1,    -1,    -1,    -1,
     159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   612,    -1,    -1,    -1,   114,    -1,   618,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   628,   188,
     128,    -1,    -1,   131,    -1,    -1,    -1,    -1,  2587,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    26,    27,    -1,    -1,  2604,    -1,    -1,    -1,  2608,
      -1,   159,    -1,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   238,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,  2638,
    2639,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,  2658,
      -1,    -1,    -1,    -1,    13,    90,    15,    -1,  2667,    -1,
    2669,    -1,  2671,    -1,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,    35,    -1,    -1,   114,
     238,    -1,  2691,    -1,    -1,    -1,    -1,  2696,   307,    -1,
      49,    50,    -1,   128,    -1,   253,   131,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    -1,   325,    -1,    -1,    -1,
     329,  2720,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   159,    84,    -1,  2035,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   307,
      -1,    -1,    -1,   372,    -1,    -1,    -1,    -1,    -1,    -1,
     379,    -1,   381,    -1,    -1,   124,    -1,   325,    -1,    -1,
     389,    -1,    -1,   132,   133,   134,  2785,    -1,    -1,    -1,
    2789,    -1,    -1,    -1,    -1,   144,   145,   222,    -1,   224,
      -1,    -1,    -1,    -1,    -1,   230,  2104,    -1,    -1,    -1,
    2108,    -1,    -1,   238,    -1,  2113,  2114,    -1,    -1,    -1,
      -1,    -1,   171,    -1,  2122,  2123,   435,  2125,   253,  2127,
    2128,   379,  2130,   381,    -1,    -1,    -1,  2836,   187,    -1,
      -1,   389,    -1,    -1,    -1,  2143,    -1,  2145,   457,    -1,
    2148,  2149,  2150,  2151,   203,  2153,    -1,    -1,    -1,   208,
      -1,    -1,    -1,   212,    -1,    -1,    -1,  2165,    -1,    -1,
      -1,    -1,    -1,    -1,  2172,    -1,  2174,    -1,  2176,  2177,
    2178,    -1,   307,    -1,    -1,  2183,  2184,  2185,   237,    -1,
     239,  2189,  2190,  2191,    -1,  2193,    -1,  2195,    -1,  2197,
     325,  2199,    -1,  2201,    -1,   514,   255,    -1,  2206,   457,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   273,   534,  2224,    -1,   277,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2240,    -1,   553,  2243,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,    -1,   381,    -1,  2957,  2958,
      -1,    -1,   571,    -1,   389,    -1,   514,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   530,    -1,    -1,    -1,   534,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,    -1,    -1,
      -1,  3010,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,
      -1,    -1,    -1,   571,  3023,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   457,    -1,    -1,   384,    -1,    -1,    -1,   388,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     399,    -1,    -1,    -1,    -1,    -1,    -1,  3056,  3057,    -1,
    3059,   410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3068,
      -1,    -1,    -1,    -1,  3073,    -1,    -1,  3076,    -1,  3078,
    3079,    -1,    -1,   432,    -1,    -1,   435,    -1,   437,   514,
      -1,   440,    -1,    -1,   443,   444,    -1,    -1,    -1,    -1,
    3099,    -1,   451,    -1,   453,   530,    -1,    -1,    -1,   534,
      -1,   460,    -1,    -1,    -1,  3114,    -1,   466,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   474,    -1,    -1,   553,    -1,
     479,    -1,   481,    -1,    -1,   484,    -1,    -1,    -1,  3138,
      -1,    -1,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     509,    -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,  3168,
      -1,    33,    34,    -1,    -1,    -1,    -1,    39,    -1,    41,
      -1,    43,    44,  3182,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    -1,
      -1,    -1,    -1,    -1,  3203,    -1,    -1,    -1,    -1,   558,
      -1,    -1,    -1,  3212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,    -1,    -1,   577,    -1,
      -1,    -1,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,    -1,    -1,   118,    24,    -1,    -1,
      -1,    -1,    -1,   612,   126,    -1,    -1,    34,    35,   618,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   628,
      -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    59,    60,    -1,  3294,    -1,    -1,   160,    -1,
      67,    -1,    -1,    -1,    -1,    72,  2604,    -1,    -1,    -1,
    2608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   184,    -1,   186,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,   101,    -1,   103,   199,   200,    -1,
    2638,  2639,    -1,    -1,    -1,   112,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2667,
      -1,  2669,    -1,  2671,    -1,    -1,    -1,    -1,    -1,    -1,
     242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   158,   159,    -1,    -1,    -1,    -1,   164,    -1,    -1,
     167,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,  2720,    -1,    -1,    -1,   193,    -1,   195,    -1,
      -1,    -1,    -1,    -1,    -1,   202,  3435,   204,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   313,   314,   315,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   229,   230,   231,    -1,    -1,    -1,    -1,    -1,
     332,   333,   334,    -1,    -1,  3474,  3475,   339,    -1,    -1,
     342,    -1,    -1,    -1,  3483,   252,    -1,  2785,    -1,    -1,
      -1,  2789,    -1,    -1,    -1,    -1,   358,   359,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   394,   395,   301,    -1,    -1,    -1,  2836,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3550,    -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3595,    -1,    -1,   366,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   470,    -1,
      -1,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   486,   392,    -1,    -1,  3627,    -1,
      -1,    -1,  3631,    -1,    -1,    -1,   403,   404,    -1,    -1,
     407,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2957,
    2958,   428,    -1,  3662,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3676,   540,    -1,
      -1,   543,    -1,    -1,   546,   547,   548,   549,    -1,    -1,
    3689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   484,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3023,    -1,    -1,   590,   591,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   510,    -1,    -1,    -1,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   616,    -1,    -1,    -1,  3056,  3057,
      -1,    -1,    -1,    -1,    -1,   532,   533,    -1,    -1,    -1,
    3068,    -1,    -1,  3772,    -1,  3073,    -1,    -1,  3076,    -1,
    3078,  3079,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3792,    -1,    -1,    -1,  3796,  3797,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   581,    -1,  3114,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   592,    -1,    -1,  3827,    -1,
      -1,    -1,    -1,   600,    -1,    -1,  3835,    -1,    -1,    -1,
    3138,    -1,    -1,    -1,    -1,  3844,    -1,  3846,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3182,    -1,  3885,    -1,    -1,    -1,
      -1,    -1,  3891,  3892,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3203,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3936,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3945,    -1,    -1,    -1,
    3949,    -1,    -1,    -1,    -1,  3954,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3991,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4010,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4023,    -1,  4025,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4035,    -1,  4037,  4038,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4062,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4106,    -1,  4108,
    4109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4129,    -1,  4131,    -1,    -1,    -1,    -1,  3435,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4146,  4147,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4172,    -1,    -1,  3474,  3475,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3483,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4222,  4223,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4235,  4236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4252,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4285,    -1,    -1,    -1,
      -1,    -1,    -1,  4292,    -1,    -1,  4295,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3627,
    4329,    -1,    -1,  3631,    -1,    -1,    -1,  4336,    -1,  4338,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4348,
      -1,    -1,    -1,  4352,    -1,    -1,  4355,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3662,  4364,    -1,  4366,    -1,  4368,
      -1,    -1,    -1,    -1,    -1,    -1,  4375,    -1,  3676,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4386,    -1,    -1,
      -1,  3689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4402,  4403,    -1,    -1,    -1,    -1,  4408,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4418,
    4419,    -1,    -1,    -1,  4423,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4455,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3835,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3844,    -1,  3846,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3885,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3954,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3991,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4023,    -1,  4025,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4035,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4147,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,  4222,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      45,    46,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,  4292,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,   100,   101,   102,    -1,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,  4329,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,  4355,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,   172,    -1,   174,
     175,   176,   177,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
    4408,   206,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,  4455,   253,    -1,
      -1,   256,   257,   258,    -1,   260,   261,    -1,   263,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,   341,   342,   343,    -1,
      -1,   346,   347,   348,   349,   350,   351,   352,   353,   354,
      -1,   356,   357,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,   382,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,   439,   440,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,   511,   512,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,   539,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,   551,   552,   553,   554,
      -1,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
     585,   586,   587,   588,   589,    -1,    -1,   592,   593,    -1,
     595,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,    -1,    -1,    -1,    -1,   621,   622,    -1,    -1,
      -1,    -1,   627,   628,    -1,    -1,   631,   632,    -1,    -1,
     635,   636,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,   100,   101,   102,
      -1,    -1,   105,   106,   107,    -1,   109,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,   172,
      -1,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,   225,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,   342,
     343,    -1,    -1,   346,   347,   348,   349,   350,   351,   352,
     353,   354,    -1,   356,   357,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,   439,   440,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,   511,   512,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,   522,
     523,   524,   525,   526,   527,   528,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,   556,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,   585,   586,   587,   588,   589,    -1,    -1,   592,
     593,    -1,   595,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,    -1,    -1,   621,   622,
      -1,    -1,    -1,    -1,   627,   628,    -1,    -1,   631,   632,
      -1,    -1,   635,   636,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,   100,
     101,   102,    -1,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,   172,    -1,   174,   175,   176,   177,   178,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,   192,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,   206,    -1,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,   225,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
     341,   342,   343,    -1,    -1,   346,   347,   348,   349,   350,
     351,   352,   353,   354,    -1,   356,   357,    -1,   359,   360,
     361,    -1,   363,   364,   365,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,
      -1,   382,   383,    -1,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,   405,   406,   407,   408,   409,    -1,
     411,   412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,   427,   428,   429,   430,
     431,    -1,   433,   434,    -1,   436,   437,   438,   439,   440,
     441,    -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,
      -1,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,
     471,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,   485,    -1,   487,   488,   489,   490,
     491,   492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,
      -1,   502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,
     511,   512,   513,   514,    -1,   516,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
      -1,   532,    -1,   534,   535,   536,   537,    -1,   539,   540,
     541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,
      -1,   552,   553,   554,    -1,   556,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,    -1,   569,   570,
      -1,    -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,
     581,   582,    -1,    -1,   585,   586,   587,   588,   589,    -1,
      -1,   592,   593,    -1,   595,   596,   597,   598,   599,   600,
     601,    -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,
     611,   612,   613,    -1,    -1,   616,    -1,    -1,    -1,    -1,
     621,   622,    -1,    -1,    -1,    -1,   627,   628,    -1,    -1,
     631,   632,    -1,    -1,   635,   636,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,   100,   101,   102,    -1,    -1,   105,   106,   107,    -1,
     109,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,   172,    -1,   174,   175,   176,   177,   178,
     179,   180,    -1,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,   191,   192,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,   206,    -1,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,   225,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,
     239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,   341,   342,   343,    -1,    -1,   346,   347,   348,
     349,   350,   351,   352,   353,   354,    -1,   356,   357,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,   382,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
     439,   440,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,   511,   512,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
     539,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,   556,   557,   558,
     559,   560,   561,   562,   563,   564,   565,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,   585,   586,   587,   588,
     589,    -1,    -1,   592,   593,    -1,   595,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
      -1,    -1,   621,   622,    -1,    -1,    -1,    -1,   627,   628,
      -1,    -1,   631,   632,    -1,    -1,   635,   636,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,   100,   101,   102,    -1,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
     177,   178,   179,   180,    -1,   182,   183,   184,   185,    -1,
     187,    -1,    -1,    -1,   191,   192,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,   206,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
     237,   238,   239,   240,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,   341,   342,   343,    -1,    -1,   346,
     347,   348,   349,   350,   351,   352,   353,   354,    -1,   356,
     357,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
      -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   378,   379,   380,    -1,   382,   383,    -1,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,   399,   400,   401,    -1,   403,    -1,   405,   406,
     407,   408,   409,    -1,   411,   412,   413,    -1,    -1,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
     427,   428,   429,   430,   431,    -1,   433,   434,    -1,   436,
     437,   438,   439,   440,   441,    -1,   443,    -1,   445,   446,
      -1,   448,   449,    -1,    -1,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,    -1,   464,   465,    -1,
      -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,
      -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,
     487,   488,   489,   490,   491,   492,    -1,    -1,    -1,    -1,
      -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,
      -1,   508,   509,   510,   511,   512,   513,   514,    -1,   516,
     517,   518,   519,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,    -1,   532,    -1,   534,   535,   536,
     537,    -1,   539,   540,   541,    -1,   543,   544,   545,   546,
      -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,   556,
     557,   558,   559,   560,   561,   562,   563,   564,   565,   566,
     567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,
      -1,   578,    -1,   580,   581,   582,    -1,    -1,   585,   586,
     587,   588,   589,    -1,    -1,   592,   593,    -1,   595,   596,
     597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,
      -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,   616,
      -1,    -1,    -1,    -1,   621,   622,    -1,    -1,    -1,    -1,
     627,   628,    -1,    -1,   631,   632,    -1,    -1,   635,   636,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,   100,   101,   102,    -1,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,   172,    -1,   174,
     175,   176,   177,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,   206,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,   341,   342,   343,    -1,
      -1,   346,   347,   348,   349,   350,   351,   352,   353,   354,
      -1,   356,   357,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,   382,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,   439,   440,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,   511,   512,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,   539,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
     585,   586,   587,   588,   589,    -1,    -1,   592,   593,    -1,
     595,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,    -1,    -1,    -1,    -1,   621,   622,    -1,    -1,
      -1,    -1,   627,   628,    -1,    -1,   631,   632,    -1,    -1,
     635,   636,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,   100,   101,   102,
      -1,    -1,   105,   106,   107,    -1,   109,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,   172,
      -1,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,   225,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,   342,
     343,    -1,    -1,   346,   347,   348,   349,   350,   351,   352,
     353,   354,    -1,   356,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,   439,   440,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,   511,   512,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,   522,
     523,   524,   525,   526,   527,   528,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,   556,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,   585,   586,   587,   588,   589,    -1,    -1,   592,
     593,    -1,   595,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,    -1,    -1,   621,   622,
      -1,    -1,    -1,    -1,   627,   628,    -1,    -1,   631,   632,
      -1,    -1,   635,   636,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,   100,
     101,   102,    -1,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,   172,    -1,   174,   175,   176,   177,   178,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,   206,    -1,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,   225,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
     341,   342,   343,    -1,    -1,   346,   347,   348,   349,   350,
      -1,   352,   353,   354,    -1,   356,   357,    -1,   359,   360,
     361,    -1,   363,   364,   365,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,
      -1,   382,   383,    -1,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,   405,   406,   407,   408,   409,    -1,
     411,   412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,   427,   428,   429,   430,
     431,    -1,   433,   434,    -1,   436,   437,   438,   439,   440,
     441,    -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,
      -1,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,
     471,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,   485,    -1,   487,   488,   489,   490,
     491,   492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,
      -1,   502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,
     511,   512,   513,   514,    -1,   516,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
      -1,   532,    -1,   534,   535,   536,   537,    -1,   539,   540,
     541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,
      -1,   552,   553,   554,    -1,   556,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,    -1,   569,   570,
      -1,    -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,
     581,   582,    -1,    -1,   585,   586,   587,   588,   589,    -1,
      -1,   592,   593,    -1,   595,   596,   597,   598,   599,   600,
     601,    -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,
     611,   612,   613,    -1,    -1,   616,    -1,    -1,    -1,    -1,
     621,   622,    -1,    -1,    -1,    -1,   627,   628,    -1,    -1,
     631,   632,    -1,    -1,   635,   636,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,   100,   101,   102,    -1,    -1,   105,   106,   107,    -1,
     109,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,   172,    -1,   174,   175,   176,   177,   178,
     179,   180,    -1,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,   206,    -1,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,   225,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,
     239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,   341,   342,   343,    -1,    -1,   346,   347,   348,
     349,   350,   351,   352,   353,   354,    -1,   356,   357,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,   382,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
     439,   440,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,   511,   512,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
     539,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,   556,   557,   558,
     559,   560,   561,   562,   563,   564,   565,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,   585,   586,   587,   588,
     589,    -1,    -1,   592,   593,    -1,   595,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
      -1,    -1,   621,   622,    -1,    -1,    -1,    -1,   627,   628,
      -1,    -1,   631,   632,    -1,    -1,   635,   636,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,   100,   101,   102,    -1,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
     177,   178,   179,   180,    -1,   182,   183,   184,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,   206,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
     237,   238,   239,   240,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,   341,   342,   343,    -1,    -1,   346,
     347,   348,   349,   350,   351,   352,   353,   354,    -1,   356,
     357,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
      -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   378,   379,   380,    -1,   382,   383,    -1,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,   399,   400,   401,    -1,   403,    -1,   405,   406,
     407,   408,   409,    -1,   411,   412,   413,    -1,    -1,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
     427,   428,   429,   430,   431,    -1,   433,   434,    -1,   436,
     437,   438,   439,   440,   441,    -1,   443,    -1,   445,   446,
      -1,   448,   449,    -1,    -1,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,    -1,   464,   465,    -1,
      -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,
      -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,
     487,   488,   489,   490,   491,   492,    -1,    -1,    -1,    -1,
      -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,
      -1,   508,   509,   510,   511,   512,   513,   514,    -1,   516,
     517,   518,   519,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,    -1,   532,    -1,   534,   535,   536,
     537,    -1,   539,   540,   541,    -1,   543,   544,   545,   546,
      -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,   556,
     557,   558,   559,   560,   561,   562,   563,   564,   565,   566,
     567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,
      -1,   578,    -1,   580,   581,   582,    -1,    -1,   585,   586,
     587,   588,   589,    -1,    -1,   592,   593,    -1,   595,   596,
     597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,
      -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,   616,
      -1,    -1,    -1,    -1,   621,   622,    -1,    -1,    -1,    -1,
     627,   628,    -1,    -1,   631,   632,    -1,    -1,   635,   636,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,   100,   101,   102,    -1,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,   172,    -1,   174,
     175,   176,   177,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,   206,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,   341,   342,   343,    -1,
      -1,   346,   347,   348,   349,   350,   351,   352,   353,   354,
      -1,   356,   357,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,   382,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,   439,   440,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,   511,   512,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,   539,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
     585,   586,   587,   588,   589,    -1,    -1,   592,   593,    -1,
     595,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,    -1,    -1,    -1,    -1,   621,   622,    -1,    -1,
      -1,    -1,   627,   628,    -1,    -1,   631,   632,    -1,    -1,
     635,   636,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,   100,   101,   102,
      -1,    -1,   105,   106,   107,    -1,   109,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,   172,
      -1,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,   225,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,   342,
     343,    -1,    -1,   346,   347,   348,   349,   350,   351,   352,
     353,   354,    -1,   356,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,   439,   440,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,   511,   512,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,   522,
     523,   524,   525,   526,   527,   528,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,   556,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,   585,   586,   587,   588,   589,    -1,    -1,   592,
     593,    -1,   595,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,    -1,    -1,   621,   622,
      -1,    -1,    -1,    -1,   627,   628,    -1,    -1,   631,   632,
      -1,    -1,   635,   636,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,   100,
     101,   102,    -1,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,   172,    -1,   174,   175,   176,   177,   178,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,   206,    -1,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,   225,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
     341,   342,   343,    -1,    -1,   346,   347,   348,   349,   350,
      -1,   352,   353,   354,    -1,   356,   357,    -1,   359,   360,
     361,    -1,   363,   364,   365,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,
      -1,   382,   383,    -1,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,   405,   406,   407,   408,   409,    -1,
     411,   412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,   427,   428,   429,   430,
     431,    -1,   433,   434,    -1,   436,   437,   438,   439,   440,
     441,    -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,
      -1,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,
     471,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,   485,    -1,   487,   488,   489,   490,
     491,   492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,
      -1,   502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,
     511,   512,   513,   514,    -1,   516,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
      -1,   532,    -1,   534,   535,   536,   537,    -1,   539,   540,
     541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,
      -1,   552,   553,   554,    -1,   556,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,    -1,   569,   570,
      -1,    -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,
     581,   582,    -1,    -1,   585,   586,   587,   588,   589,    -1,
      -1,   592,   593,    -1,   595,   596,   597,   598,   599,   600,
     601,    -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,
     611,   612,   613,    -1,    -1,   616,    -1,    -1,    -1,    -1,
     621,   622,    -1,    -1,    -1,    -1,   627,   628,    -1,    -1,
     631,   632,    -1,    -1,   635,   636,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,   100,   101,   102,    -1,    -1,   105,   106,   107,    -1,
     109,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,   172,    -1,   174,   175,   176,   177,   178,
     179,   180,    -1,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,   206,    -1,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,   225,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,
     239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,   341,   342,   343,    -1,    -1,   346,   347,   348,
     349,   350,    -1,   352,   353,   354,    -1,   356,   357,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,   382,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
     439,   440,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,   511,   512,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
     539,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,   556,   557,   558,
     559,   560,   561,   562,   563,   564,   565,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,   585,   586,   587,   588,
     589,    -1,    -1,   592,   593,    -1,   595,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
      -1,    -1,   621,   622,    -1,    -1,    -1,    -1,   627,   628,
      -1,    -1,   631,   632,    -1,    -1,   635,   636,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,   100,   101,   102,    -1,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
     177,   178,   179,   180,    -1,   182,   183,   184,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,   206,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
     237,   238,   239,   240,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,   341,   342,   343,    -1,    -1,   346,
     347,   348,   349,   350,    -1,   352,   353,   354,    -1,   356,
     357,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
      -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   378,   379,   380,    -1,   382,   383,    -1,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,   399,   400,   401,    -1,   403,    -1,   405,   406,
     407,   408,   409,    -1,   411,   412,   413,    -1,    -1,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
     427,   428,   429,   430,   431,    -1,   433,   434,    -1,   436,
     437,   438,   439,   440,   441,    -1,   443,    -1,   445,   446,
      -1,   448,   449,    -1,    -1,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,    -1,   464,   465,    -1,
      -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,
      -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,
     487,   488,   489,   490,   491,   492,    -1,    -1,    -1,    -1,
      -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,
      -1,   508,   509,   510,   511,   512,   513,   514,    -1,   516,
     517,   518,   519,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,    -1,   532,    -1,   534,   535,   536,
     537,    -1,   539,   540,   541,    -1,   543,   544,   545,   546,
      -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,   556,
     557,   558,   559,   560,   561,   562,   563,   564,   565,   566,
     567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,
      -1,   578,    -1,   580,   581,   582,    -1,    -1,   585,   586,
     587,   588,   589,    -1,    -1,   592,   593,    -1,   595,   596,
     597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,
      -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,   616,
      -1,    -1,    -1,    -1,   621,   622,    -1,    -1,    -1,    -1,
     627,   628,    -1,    -1,   631,   632,    -1,    -1,   635,   636,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,   100,   101,   102,    -1,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,   172,    -1,   174,
     175,   176,   177,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,   206,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,   341,   342,   343,    -1,
      -1,   346,   347,   348,   349,   350,    -1,   352,   353,   354,
      -1,   356,   357,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,   382,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,   439,   440,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,   511,   512,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,   539,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
     585,   586,   587,   588,   589,    -1,    -1,   592,   593,    -1,
     595,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,    -1,    -1,    -1,    -1,   621,   622,    -1,    -1,
      -1,    -1,   627,   628,    -1,    -1,   631,   632,    -1,    -1,
     635,   636,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    36,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,   356,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,   635,   636,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,
      -1,    58,    59,    -1,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    93,    94,    95,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,
      -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,    -1,    -1,   174,   175,   176,
      -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,   194,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,
     227,   228,   229,   230,   231,    -1,   233,    -1,    -1,    -1,
      -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,   254,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,
     267,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,    -1,   305,   306,
     307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,    -1,
     327,    -1,   329,    -1,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,    -1,   342,   343,    -1,    -1,   346,
     347,   348,   349,    -1,    -1,    -1,   353,   354,    -1,    -1,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
      -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   378,   379,   380,    -1,    -1,   383,    -1,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,   405,   406,
     407,   408,   409,    -1,   411,   412,   413,    -1,    -1,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
     427,   428,   429,   430,   431,    -1,   433,   434,    -1,   436,
     437,   438,    -1,    -1,   441,    -1,   443,    -1,   445,   446,
      -1,   448,   449,    -1,    -1,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,    -1,   464,   465,   466,
      -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,
      -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,
     487,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,
      -1,   508,   509,   510,    -1,    -1,   513,   514,    -1,   516,
     517,   518,   519,   520,   521,    -1,    -1,   524,   525,   526,
     527,    -1,   529,   530,    -1,   532,    -1,   534,   535,   536,
     537,    -1,    -1,   540,   541,    -1,   543,   544,   545,   546,
      -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,   558,   559,   560,   561,    -1,   563,   564,    -1,   566,
     567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,
      -1,   578,    -1,   580,   581,   582,    -1,    -1,    -1,    -1,
      -1,    -1,   589,    -1,    -1,   592,    -1,    -1,    -1,   596,
     597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,
      -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,   616,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   636,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,   194,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,   230,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,   254,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,   636,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,    -1,    -1,   346,   347,   348,
     349,    -1,    -1,    -1,   353,   354,    -1,    -1,    -1,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,    -1,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
      -1,    -1,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,   466,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,    -1,    -1,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,    -1,    -1,   524,   525,   526,   527,    -1,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
      -1,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,   558,
     559,   560,   561,    -1,   563,   564,    -1,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,    -1,    -1,    -1,    -1,
     589,    -1,    -1,   592,    -1,    -1,    -1,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
     629,    -1,    -1,    18,    -1,    -1,    21,   636,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,
      -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,    -1,    -1,   174,
     175,   176,    -1,    -1,   179,   180,    -1,   182,   183,   184,
      -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
      -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,    -1,
      -1,   346,   347,   348,   349,    -1,    -1,    -1,   353,   354,
      -1,    -1,    -1,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,    -1,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,    -1,    -1,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,    -1,    -1,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,    -1,    -1,   524,
     525,   526,   527,    -1,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,    -1,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,   558,   559,   560,   561,    -1,   563,   564,
      -1,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
      -1,    -1,    -1,    -1,   589,    -1,    -1,   592,    -1,    -1,
      -1,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,   629,    14,    -1,    -1,    -1,    18,
     635,   636,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,    -1,    -1,   346,   347,   348,
     349,    -1,    -1,    -1,   353,   354,    -1,    -1,    -1,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,    -1,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
      -1,    -1,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,    -1,    -1,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,    -1,    -1,   524,   525,   526,   527,    -1,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
      -1,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,   558,
     559,   560,   561,    -1,   563,   564,    -1,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,    -1,    -1,    -1,    -1,
     589,    -1,    -1,   592,    -1,    -1,    -1,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,   628,
      -1,    14,    -1,    -1,    -1,    18,    -1,   636,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,   241,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,    -1,   616,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,   636,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,    -1,    -1,   346,   347,   348,
     349,    -1,    -1,    -1,   353,   354,    -1,    -1,    -1,    -1,
     359,   360,   361,    -1,   363,   364,   365,   366,    -1,   368,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,
     379,   380,    -1,    -1,   383,    -1,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,    -1,   405,   406,   407,   408,
     409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,   427,   428,
     429,   430,   431,    -1,   433,   434,    -1,   436,   437,   438,
      -1,    -1,   441,    -1,   443,    -1,   445,   446,    -1,   448,
     449,    -1,    -1,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,
     469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,   485,    -1,   487,   488,
     489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,
     509,   510,    -1,    -1,   513,   514,    -1,   516,   517,   518,
     519,   520,   521,    -1,    -1,   524,   525,   526,   527,    -1,
     529,   530,    -1,   532,    -1,   534,   535,   536,   537,    -1,
      -1,   540,   541,    -1,   543,   544,   545,   546,    -1,    -1,
      -1,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,   558,
     559,   560,   561,    -1,   563,   564,    -1,   566,   567,    -1,
     569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,
      -1,   580,   581,   582,    -1,    -1,    -1,    -1,    -1,    -1,
     589,    -1,    -1,   592,    -1,    -1,    -1,   596,   597,   598,
     599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,
     609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,
      -1,    -1,    -1,     5,   623,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,   636,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,
      -1,   353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,    -1,   368,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,
      -1,   383,    -1,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,    -1,    -1,   427,   428,   429,   430,   431,
      -1,   433,   434,    -1,   436,   437,   438,    -1,    -1,   441,
      -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,
      -1,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,
     472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,
     482,   483,   484,   485,    -1,   487,   488,   489,   490,   491,
     492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,
     502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,
      -1,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
      -1,    -1,   524,   525,   526,   527,    -1,   529,   530,    -1,
     532,    -1,   534,   535,   536,   537,    -1,    -1,   540,   541,
      -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,   558,   559,   560,   561,
      -1,   563,   564,    -1,   566,   567,    -1,   569,   570,    -1,
      -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,
     582,    -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,
     592,    -1,    -1,    -1,   596,   597,   598,   599,   600,   601,
      -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,
     612,   613,    -1,    -1,   616,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,   628,    -1,    14,    -1,
      -1,    -1,    18,    -1,   636,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,    -1,    -1,
     346,   347,   348,   349,    -1,    -1,    -1,   353,   354,    -1,
      -1,    -1,    -1,   359,   360,   361,    -1,   363,   364,   365,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   378,   379,   380,    -1,    -1,   383,    -1,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,   399,   400,   401,    -1,   403,    -1,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,    -1,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,
      -1,   427,   428,   429,   430,   431,    -1,   433,   434,    -1,
     436,   437,   438,    -1,    -1,   441,    -1,   443,    -1,   445,
     446,    -1,   448,   449,    -1,    -1,    -1,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,    -1,   464,   465,
      -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,
      -1,   487,   488,   489,   490,   491,   492,    -1,    -1,    -1,
      -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,
      -1,    -1,   508,   509,   510,    -1,    -1,   513,   514,    -1,
     516,   517,   518,   519,   520,   521,    -1,    -1,   524,   525,
     526,   527,    -1,   529,   530,    -1,   532,    -1,   534,   535,
     536,   537,    -1,    -1,   540,   541,    -1,   543,   544,   545,
     546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,   558,   559,   560,   561,    -1,   563,   564,    -1,
     566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,
     576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,    -1,
      -1,    -1,    -1,   589,    -1,    -1,   592,    -1,    -1,    -1,
     596,   597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,
      -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,
     616,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,   635,
     636,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,    49,
      -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,    59,
      -1,    61,    62,    -1,    64,    65,    66,    67,    68,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    99,
      -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,   109,
      -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,    -1,
      -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,   129,
      -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,
      -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,
     160,    -1,    -1,   163,   164,    -1,   166,   167,   168,   169,
     170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,   179,
     180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,   222,   223,   224,    -1,    -1,   227,   228,   229,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,   239,
      -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,
      -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,
      -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,
      -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,   279,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
      -1,   301,   302,   303,    -1,   305,   306,   307,   308,    -1,
     310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,    -1,    -1,   346,   347,   348,   349,
      -1,    -1,    -1,   353,   354,    -1,    -1,    -1,    -1,   359,
     360,   361,    -1,   363,   364,   365,   366,    -1,   368,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,
     380,    -1,    -1,   383,    -1,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,    -1,    -1,   399,
     400,   401,    -1,   403,    -1,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,    -1,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,    -1,    -1,   427,   428,   429,
     430,   431,    -1,   433,   434,    -1,   436,   437,   438,    -1,
      -1,   441,    -1,   443,    -1,   445,   446,    -1,   448,   449,
      -1,    -1,    -1,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,    -1,   464,   465,    -1,    -1,    -1,   469,
     470,   471,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,   485,    -1,   487,   488,   489,
     490,   491,   492,    -1,    -1,    -1,    -1,    -1,    -1,   499,
     500,    -1,   502,    -1,    -1,   505,    -1,    -1,   508,   509,
     510,    -1,    -1,   513,   514,    -1,   516,   517,   518,   519,
     520,   521,    -1,    -1,   524,   525,   526,   527,    -1,   529,
     530,    -1,   532,    -1,   534,   535,   536,   537,    -1,    -1,
     540,   541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,   558,   559,
     560,   561,    -1,   563,   564,    -1,   566,   567,    -1,   569,
     570,    -1,    -1,   573,    -1,    -1,   576,    -1,   578,    -1,
     580,   581,   582,    -1,    -1,    -1,    -1,    -1,    -1,   589,
      -1,    -1,   592,    -1,    -1,    -1,   596,   597,   598,   599,
     600,   601,    -1,    -1,    -1,    -1,    -1,    -1,   608,   609,
      -1,   611,   612,   613,    -1,    -1,   616,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,   636,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,    -1,    -1,
     346,   347,   348,   349,    -1,    -1,    -1,   353,   354,    -1,
      -1,    -1,    -1,   359,   360,   361,    -1,   363,   364,   365,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   378,   379,   380,    -1,    -1,   383,    -1,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,   399,   400,   401,    -1,   403,    -1,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,    -1,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,    -1,
      -1,   427,   428,   429,   430,   431,    -1,   433,   434,    -1,
     436,   437,   438,    -1,    -1,   441,    -1,   443,    -1,   445,
     446,    -1,   448,   449,    -1,    -1,    -1,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,    -1,   464,   465,
      -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,   485,
      -1,   487,   488,   489,   490,   491,   492,    -1,    -1,    -1,
      -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,   505,
      -1,    -1,   508,   509,   510,    -1,    -1,   513,   514,    -1,
     516,   517,   518,   519,   520,   521,    -1,    -1,   524,   525,
     526,   527,    -1,   529,   530,    -1,   532,    -1,   534,   535,
     536,   537,    -1,    -1,   540,   541,    -1,   543,   544,   545,
     546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,   558,   559,   560,   561,    -1,   563,   564,    -1,
     566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,    -1,
     576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,    -1,
      -1,    -1,    -1,   589,    -1,    -1,   592,    -1,    -1,    -1,
     596,   597,   598,   599,   600,   601,    -1,    -1,    -1,    -1,
      -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,    -1,
     616,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     636,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,
      -1,   353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,    -1,   368,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,
      -1,   383,    -1,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,    -1,    -1,   427,   428,   429,   430,   431,
      -1,   433,   434,    -1,   436,   437,   438,    -1,    -1,   441,
      -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,
      -1,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,
     472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,
     482,   483,   484,   485,    -1,   487,   488,   489,   490,   491,
     492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,
     502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,
      -1,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
      -1,    -1,   524,   525,   526,   527,    -1,   529,   530,    -1,
     532,    -1,   534,   535,   536,   537,    -1,    -1,   540,   541,
      -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,   558,   559,   560,   561,
      -1,   563,   564,    -1,   566,   567,    -1,   569,   570,    -1,
      -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,
     582,    -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,
     592,    -1,    -1,    -1,   596,   597,   598,   599,   600,   601,
      -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,
     612,   613,    -1,    -1,   616,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   636,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,    -1,    -1,   346,   347,
     348,   349,    -1,    -1,    -1,   353,   354,    -1,    -1,    -1,
      -1,   359,   360,   361,    -1,   363,   364,   365,   366,    -1,
     368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     378,   379,   380,    -1,    -1,   383,    -1,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,    -1,
      -1,   399,   400,   401,    -1,   403,    -1,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,   427,
     428,   429,   430,   431,    -1,   433,   434,    -1,   436,   437,
     438,    -1,    -1,   441,    -1,   443,    -1,   445,   446,    -1,
     448,   449,    -1,    -1,    -1,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,    -1,   464,   465,    -1,    -1,
      -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,
      -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,   487,
     488,   489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,
      -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,
     508,   509,   510,    -1,    -1,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,    -1,    -1,   524,   525,   526,   527,
      -1,   529,   530,    -1,   532,    -1,   534,   535,   536,   537,
      -1,    -1,   540,   541,    -1,   543,   544,   545,   546,    -1,
      -1,    -1,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
     558,   559,   560,   561,    -1,   563,   564,    -1,   566,   567,
      -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,
     578,    -1,   580,   581,   582,    -1,    -1,    -1,    -1,    -1,
      -1,   589,    -1,    -1,   592,    -1,    -1,    -1,   596,   597,
     598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,
     608,   609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,   636,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
      -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,
     114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,
     124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,    -1,
     174,   175,   176,    -1,    -1,   179,   180,    -1,   182,   183,
     184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
      -1,   305,   306,   307,   308,    -1,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,    -1,   327,    -1,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
      -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,   353,
     354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,   363,
     364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,   383,
      -1,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
      -1,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,    -1,    -1,   427,   428,   429,   430,   431,    -1,   433,
     434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,   443,
      -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,    -1,
     464,   465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,   485,    -1,   487,   488,   489,   490,   491,   492,    -1,
      -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,
      -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,   513,
     514,    -1,   516,   517,   518,   519,   520,   521,    -1,    -1,
     524,   525,   526,   527,    -1,   529,   530,    -1,   532,    -1,
     534,   535,   536,   537,    -1,   539,   540,   541,    -1,   543,
     544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,   563,
     564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,   573,
      -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,
      -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,    -1,
      -1,    -1,   596,   597,   598,   599,   600,   601,    -1,    -1,
      -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,
      -1,    -1,   616,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,   635,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,    -1,
      -1,   102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,
      -1,    -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,    -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,
      -1,   182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,
      -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,    -1,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,    -1,   305,   306,   307,   308,    -1,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,    -1,    -1,   346,   347,   348,   349,    -1,
      -1,    -1,   353,   354,    -1,    -1,    -1,    -1,   359,   360,
     361,    -1,   363,   364,   365,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,   380,
      -1,    -1,   383,    -1,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,    -1,   399,   400,
     401,    -1,   403,    -1,   405,   406,   407,   408,   409,    -1,
     411,   412,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,   427,   428,   429,   430,
     431,    -1,   433,   434,    -1,   436,   437,   438,    -1,    -1,
     441,    -1,   443,    -1,   445,   446,    -1,   448,   449,    -1,
      -1,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,    -1,   464,   465,    -1,    -1,    -1,   469,   470,
     471,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,   485,    -1,   487,   488,   489,   490,
     491,   492,    -1,    -1,    -1,    -1,    -1,    -1,   499,   500,
      -1,   502,    -1,    -1,   505,    -1,    -1,   508,   509,   510,
      -1,    -1,   513,   514,    -1,   516,   517,   518,   519,   520,
     521,    -1,    -1,   524,   525,   526,   527,    -1,   529,   530,
      -1,   532,    -1,   534,   535,   536,   537,    -1,   539,   540,
     541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,   558,   559,   560,
     561,    -1,   563,   564,    -1,   566,   567,    -1,   569,   570,
      -1,    -1,   573,    -1,    -1,   576,    -1,   578,    -1,   580,
     581,   582,    -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,
      -1,   592,    -1,    -1,    -1,   596,   597,   598,   599,   600,
     601,    -1,    -1,    -1,    -1,    -1,    -1,   608,   609,    -1,
     611,   612,   613,    -1,    -1,   616,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   635,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,    -1,    -1,   346,   347,
     348,   349,    -1,    -1,    -1,   353,   354,    -1,    -1,    -1,
      -1,   359,   360,   361,    -1,   363,   364,   365,   366,    -1,
     368,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     378,   379,   380,    -1,    -1,   383,    -1,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,    -1,
      -1,   399,   400,   401,    -1,   403,    -1,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,    -1,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,   427,
     428,   429,   430,   431,    -1,   433,   434,    -1,   436,   437,
     438,    -1,    -1,   441,    -1,   443,    -1,   445,   446,    -1,
     448,   449,    -1,    -1,    -1,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,    -1,   464,   465,    -1,    -1,
      -1,   469,   470,   471,   472,    -1,    -1,    -1,   476,    -1,
      -1,    -1,   480,    -1,   482,   483,   484,   485,    -1,   487,
     488,   489,   490,   491,   492,    -1,    -1,    -1,    -1,    -1,
      -1,   499,   500,    -1,   502,    -1,    -1,   505,    -1,    -1,
     508,   509,   510,    -1,    -1,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,    -1,    -1,   524,   525,   526,   527,
      -1,   529,   530,    -1,   532,    -1,   534,   535,   536,   537,
      -1,   539,   540,   541,    -1,   543,   544,   545,   546,    -1,
      -1,    -1,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
     558,   559,   560,   561,    -1,   563,   564,    -1,   566,   567,
      -1,   569,   570,    -1,    -1,   573,    -1,    -1,   576,    -1,
     578,    -1,   580,   581,   582,    -1,    -1,    -1,    -1,    -1,
      -1,   589,    -1,    -1,   592,    -1,    -1,    -1,   596,   597,
     598,   599,   600,   601,    -1,    -1,    -1,    -1,    -1,    -1,
     608,   609,    -1,   611,   612,   613,    -1,    -1,   616,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    -1,   635,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      55,    56,    -1,    58,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    81,    -1,    83,    -1,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    -1,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
      -1,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,    -1,    -1,    -1,    -1,   174,
     175,   176,    -1,    -1,   179,   180,   181,   182,   183,   184,
      -1,    -1,    -1,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,    -1,
      -1,    -1,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,    -1,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,   250,    -1,    -1,   253,    -1,
      -1,    -1,   257,   258,    -1,    -1,   261,   262,    -1,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,   284,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,    -1,
      -1,   346,   347,   348,   349,    -1,    -1,    -1,    -1,   354,
      -1,    -1,    -1,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,    -1,    -1,    -1,    -1,
     385,   386,   387,    -1,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,    -1,    -1,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,    -1,
      -1,   436,    -1,   438,   439,    -1,   441,    -1,    -1,    -1,
     445,    -1,    -1,   448,   449,   450,    -1,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,    -1,   464,
      -1,    -1,    -1,    -1,   469,   470,   471,    -1,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,    -1,   483,    -1,
     485,    -1,   487,    -1,   489,    -1,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,    -1,   510,    -1,    -1,    -1,   514,
      -1,   516,   517,   518,   519,   520,   521,    -1,    -1,   524,
     525,   526,   527,    -1,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,    -1,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,   560,   561,    -1,   563,   564,
      -1,   566,   567,    -1,    -1,    -1,    -1,    -1,   573,    -1,
      -1,   576,    -1,    -1,    -1,   580,   581,   582,    -1,    -1,
      -1,    -1,    -1,    -1,   589,    -1,    -1,   592,    -1,    -1,
      -1,   596,   597,   598,   599,   600,   601,    -1,    -1,   604,
      -1,    -1,    -1,   608,    -1,    -1,   611,    -1,   613,    -1,
       5,   616,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,   630,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,   107,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,
      -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,    -1,    -1,   174,
     175,   176,    -1,    -1,   179,   180,    -1,   182,   183,   184,
      -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
      -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,    -1,
      -1,   346,   347,   348,   349,    -1,    -1,    -1,   353,   354,
      -1,    -1,    -1,    -1,   359,   360,   361,    -1,   363,   364,
     365,   366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,    -1,    -1,   383,    -1,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,    -1,   399,   400,   401,    -1,   403,    -1,
     405,   406,   407,   408,   409,    -1,   411,   412,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,   427,   428,   429,   430,   431,    -1,   433,   434,
      -1,   436,   437,   438,    -1,    -1,   441,    -1,   443,    -1,
     445,   446,    -1,   448,   449,    -1,    -1,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,    -1,   464,
     465,    -1,    -1,    -1,   469,   470,   471,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
     485,    -1,   487,   488,   489,   490,   491,   492,    -1,    -1,
      -1,    -1,    -1,    -1,   499,   500,    -1,   502,    -1,    -1,
     505,    -1,    -1,   508,   509,   510,    -1,    -1,   513,   514,
      -1,   516,   517,   518,   519,   520,   521,    -1,    -1,   524,
     525,   526,   527,    -1,   529,   530,    -1,   532,    -1,   534,
     535,   536,   537,    -1,   539,   540,   541,    -1,   543,   544,
     545,   546,    -1,    -1,    -1,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,   558,   559,   560,   561,    -1,   563,   564,
      -1,   566,   567,    -1,   569,   570,    -1,    -1,   573,    -1,
      -1,   576,    -1,   578,    -1,   580,   581,   582,    -1,    -1,
      -1,    -1,    -1,    -1,   589,    -1,    -1,   592,    -1,    -1,
      -1,   596,   597,   598,   599,   600,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   609,    -1,   611,   612,   613,    -1,
      -1,   616,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,   628,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
     623,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
     623,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
     623,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
     623,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,   495,   496,   497,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,   161,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,   475,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    36,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,    -1,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,   539,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,    -1,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,    -1,    -1,   346,   347,   348,   349,    -1,    -1,    -1,
     353,   354,    -1,    -1,   357,    -1,   359,   360,   361,    -1,
     363,   364,   365,   366,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   378,   379,   380,    -1,   382,
     383,    -1,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,    -1,   405,   406,   407,   408,   409,    -1,   411,   412,
     413,    -1,    -1,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,   427,   428,   429,   430,   431,    -1,
     433,   434,    -1,   436,   437,   438,    -1,    -1,   441,    -1,
     443,    -1,   445,   446,    -1,   448,   449,    -1,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
      -1,   464,   465,    -1,    -1,    -1,   469,   470,   471,   472,
      -1,    -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,
     483,   484,   485,    -1,   487,   488,   489,   490,   491,   492,
      -1,    -1,    -1,    -1,    -1,    -1,   499,   500,    -1,   502,
      -1,    -1,   505,    -1,    -1,   508,   509,   510,    -1,    -1,
     513,   514,    -1,   516,   517,   518,   519,   520,   521,    -1,
      -1,   524,   525,   526,   527,    -1,   529,   530,    -1,   532,
      -1,   534,   535,   536,   537,    -1,    -1,   540,   541,    -1,
     543,   544,   545,   546,    -1,    -1,    -1,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,   558,   559,   560,   561,   562,
     563,   564,    -1,   566,   567,    -1,   569,   570,    -1,    -1,
     573,    -1,    -1,   576,    -1,   578,    -1,   580,   581,   582,
      -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   592,
      -1,    -1,    -1,   596,   597,   598,   599,   600,   601,    -1,
      -1,    -1,    -1,    -1,    -1,   608,   609,    -1,   611,   612,
     613,    -1,     5,   616,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,   107,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
  