/*
    This file is part of the Okteta Kasten module, made within the KDE community.

    Copyright 2010 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef BYTEARRAYVIEWPROFILEMANAGER_H
#define BYTEARRAYVIEWPROFILEMANAGER_H

// lib
#include "bytearrayviewprofile.h"
// Qt
#include <QtCore/QObject>
#include <QtCore/QList>


namespace Kasten1
{

class OKTETAKASTENGUI_EXPORT ByteArrayViewProfileManager : public QObject
{
  Q_OBJECT

  public:
    ByteArrayViewProfileManager();
    virtual ~ByteArrayViewProfileManager();

  public:
    QList<ByteArrayViewProfile> viewProfiles() const;

  public:
    void addViewProfiles( const QList<ByteArrayViewProfile>& viewProfiles );

  Q_SIGNALS:
    void viewProfilesAdded( const QList<Kasten1::ByteArrayViewProfile>& viewProfiles );
    void viewProfilesChanged( const QList<Kasten1::ByteArrayViewProfile>& viewProfiles );
    void viewProfilesRemoved( const QList<Kasten1::ByteArrayViewProfile>& viewProfiles );

protected:
   QList<ByteArrayViewProfile> mViewProfiles;
};


inline QList<ByteArrayViewProfile> ByteArrayViewProfileManager::viewProfiles() const { return mViewProfiles; }

}

#endif
