
MACRO(TIMESTAMP RESULT)
    IF(WIN32)
        EXECUTE_PROCESS(COMMAND "cmd" " /C date /T" OUTPUT_VARIABLE DATE)
        string(REGEX REPLACE "(..)[/.](..)[/.](....).*" "\\3\\2\\1" DATE ${DATE})
        EXECUTE_PROCESS(COMMAND "cmd" " /C time /T" OUTPUT_VARIABLE TIME)
        string(REGEX REPLACE "(..):(..)" "\\1\\2" TIME ${TIME})
        set (${RESULT} "${DATE}${TIME}")
    ELSEIF(UNIX)
        EXECUTE_PROCESS(COMMAND "date" "+%Y%m%d%H%M" OUTPUT_VARIABLE ${RESULT})
    ELSE()
        MESSAGE(SEND_ERROR "date not implemented")
        SET(${RESULT} 000000000000)
    ENDIF()
ENDMACRO()
