/* This file is part of the KDE project

   Copyright (C) 2009 Dario Freddi <drf@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef ACTIONWIDGET_H
#define ACTIONWIDGET_H

#include <QtGui/QWidget>
#include "../PKLAEntry.h"
#include <PolkitQt1/ActionDescription>

class KComboBox;
class QListWidgetItem;
namespace Ui {
class ActionWidget;
}

namespace PolkitKde {

class ActionWidget : public QWidget
{
    Q_OBJECT
    public:
        explicit ActionWidget(const PolkitQt1::ActionDescription &action, QWidget* parent = 0);
        virtual ~ActionWidget();

        static int comboBoxIndexFor(PolkitQt1::ActionDescription::ImplicitAuthorization auth);
        static PolkitQt1::ActionDescription::ImplicitAuthorization implicitAuthorizationFor(int comboBoxIndex);

        PKLAEntryList entries() const;

    public Q_SLOTS:
        void setAction(const PolkitQt1::ActionDescription &action);
        void computeActionPolicies();
        void editExplicitPKLAEntry(QListWidgetItem *item);
        void addExplicitPKLAEntry();

    private Q_SLOTS:
        void reloadPKLAs();
        void movePKLADown();
        void movePKLAUp();
        void explicitSelectionChanged(QListWidgetItem *current,QListWidgetItem*);
        void removePKLAEntry();

    Q_SIGNALS:
        void changed();

    private:
        void setImplicitAuthorization(PolkitQt1::ActionDescription::ImplicitAuthorization auth, KComboBox *box);
        void addNewPKLAEntry(const PKLAEntry &entry);
        QString formatPKLAEntry(const PKLAEntry &entry);
        QString formatIdentities(const QString &identities);

        Ui::ActionWidget *m_ui;
        PolkitQt1::ActionDescription m_action;
        PKLAEntryList m_entries;
};

}

#endif // ACTIONWIDGET_H
