.TH sane\-epjitsu 5 "09 Feb 2010" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-epjitsu

.SH NAME
sane\-epjitsu \- SANE backend for Epson-based Fujitsu USB scanners.

.SH DESCRIPTION
The 
.B sane\-epjitsu
library implements a SANE (Scanner Access Now Easy) backend which provides basic access the Fujitsu fi\-60F and ScanSnap S300/S1300 scanners.

.SH HARDWARE SUPPORT
These scanners are fairly limited, only supporting a couple of modes and resolutions, and always scanning full width. The backend supports missing modes (binary, grayscale) in software, but makes no effort to offer intermediate resolutions or scan area controls. See 
.B KNOWN ISSUES.

This backend may support other scanners. If physical inspection reveals an Epson chipset, please contact the author for instructions on collecting a USB trace under Windows to verify.

.SH OPTIONS
A limited effort has been made to expose the standard options to the API.  This allows a frontend to set resolution, color mode, and choose the ADF setting. The epjitsu backend supports the following basic options for most scanners:
.PP
source s 
.RS
Selects the source for the scan. Options may include "Flatbed", "ADF Front", "ADF Back", "ADF Duplex".
.RE
.PP
mode m 
.RS
Selects the mode for the scan. Options may include "Lineart", "Gray", "Color".
.RE
.PP
resolution, y\-resolution
.RS
Controls scan resolution. Setting \-\-resolution also sets \-\-y\-resolution, though this behavior is overridden by some frontends.
.RE
.PP
Other options will be available based on the capabilities of the scanner. Use 'scanimage \-\-help' to get a list. Be aware that some options may appear only when another option has been set, and that advanced options may be hidden by the frontend.
.PP
.SH CONFIGURATION FILE
The configuration file "@CONFIGDIR@/epjitsu.conf" is used to tell the backend how to look for scanners, and provide options controlling the operation of the backend. This file is read each time the frontend asks the backend for a list of scanners, generally only when the frontend starts. If the configuration file is missing, the backend will not work.
.PP
Scanners can be specified in the configuration file in two ways:
.PP
"usb 0x04c5 0x10c7" (or other vendor/product ids)
.RS
Requests backend to search all usb busses in the system for a device which uses that vendor and product id. The device will then be queried to determine if it is a supported scanner.
.RE
.PP
"usb /dev/usb/scanner0" (or other device file)
.RS
Some systems use a kernel driver to access usb scanners. This method is untested.
.RE
.PP
The only configuration option supported is "firmware /PATH/TO/FILE", allowing you to set the location of the firmware file you have extracted from the Windows driver.
.PP
.B Note: 
This firmware is a copyrighted work of Fujitsu, so cannot be provided by the backend or the author. Please do not ask.
.PP
.B Note: 
These scanners REQUIRE a firmware file to function. See the supplied configuration file for more detail.
.PP
.B Note: 
This option may appear multiple times in the configuration file. It only applies to scanners discovered by 'usb' lines that follow this option.
.PP

.SH ENVIRONMENT
The backend uses a single environment variable, SANE_DEBUG_EPJITSU, which enables debugging output to stderr. Valid values are:
.PP
.RS
5  Errors
.br
10 Function trace
.br
15 Function detail
.br
20 Option commands
.br
25 USB trace
.br
30 USB detail
.br
35 Useless noise
.RE

.SH KNOWN ISSUES
.PP
.RS
No scan area options are exposed.
.br
.br
fi\-60F hardware grayscale mode is not used.
.RE

.SH CREDITS
S300 support funded by Microdea, Inc. and Archivista, GmbH.
.br
fi\-60F support funded by TrueCheck, Inc.
.br
Improved calibration code provided by Richard Goedeken.

.SH "SEE ALSO"
sane(7),
sane\-usb(5)

.SH AUTHOR
m. allan noah: <kitno455 a t gmail d o t com>

